# How to contribute to MapServer

Contributions to the MapServer project are most welcome, and can take many forms such as detailed bug reports, documentation, 
tests, features, and patches.  Note that all contributions are managed by the MapServer [Project Steering Committee](https://mapserver.org/psc.html).

## Bugs and Help

GitHub issues should only be created to log bugs. For general help and support the MapServer [mailing lists](https://mapserver.org/community/lists.html)
should be used. If you are unsure if you have discovered a bug, or may need help with configuring MapServer please 
post to the [mapserver-users list](https://lists.osgeo.org/mailman/listinfo/mapserver-users). There is also 
a [MapServer FAQ](https://mapserver.org/faq.html) which may have a solution to your problem. 

If you have discovered a bug, please refer to the [Bug Submission page](https://mapserver.org/development/bugs.html) for
guidelines on creating an issue on GitHub. Please also search the existing issues to see if the bug has already been reported, and
add any further details to the existing issue. 

For professional support please see the [MapServer Service Providers page](https://mapserver.org/community/service_providers.html). 

## Development

A separate [mapserver-dev mailing list](https://lists.osgeo.org/mailman/listinfo/mapserver-dev) is available for developers
working on the MapServer code. Send a short message there to introduce yourself
to the community, and mention what you are interested in working on.

Details on using GitHub can be found on the [MapServer GitHub page](https://mapserver.org/development/git.html).

Request for Comments (RFCs), where upcoming major changes to the source 
code are proposed, and a description of the various software tests & release 
plans, can be found on the [MapServer Development page](https://mapserver.org/development/).  

Additional developer notes can be found in the [MapServer wiki](https://github.com/mapserver/mapserver/wiki#developer-notes), including
coding style and guidelines, memory management, and working with Git. 

## Documentation

The MapServer documentation is stored in a [separate repository](https://github.com/MapServer/MapServer-documentation). Please submit any documentation
issues or changes there. See the [Documentation Development Guide](https://mapserver.org/development/documentation.html) for further details. 
