/* valaerrortype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#ifndef __VALA_VALAERRORTYPE_H__
#define __VALA_VALAERRORTYPE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valareferencetype.h>
#include <vala/valaerrordomain.h>
#include <vala/valasourcereference.h>
#include <vala/valadatatype.h>
#include <vala/valascope.h>
#include <vala/valasymbol.h>

G_BEGIN_DECLS


#define VALA_TYPE_ERROR_TYPE (vala_error_type_get_type ())
#define VALA_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorType))
#define VALA_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))
#define VALA_IS_ERROR_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_TYPE))
#define VALA_IS_ERROR_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_TYPE))
#define VALA_ERROR_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_TYPE, ValaErrorTypeClass))

typedef struct _ValaErrorType ValaErrorType;
typedef struct _ValaErrorTypeClass ValaErrorTypeClass;
typedef struct _ValaErrorTypePrivate ValaErrorTypePrivate;

/**
 * A class type.
 */
struct _ValaErrorType {
	ValaReferenceType parent_instance;
	ValaErrorTypePrivate * priv;
};

struct _ValaErrorTypeClass {
	ValaReferenceTypeClass parent_class;
};


ValaErrorType* vala_error_type_new (ValaErrorDomain* error_domain, ValaSourceReference* source_reference);
ValaErrorDomain* vala_error_type_get_error_domain (ValaErrorType* self);
void vala_error_type_set_error_domain (ValaErrorType* self, ValaErrorDomain* value);
GType vala_error_type_get_type (void);


G_END_DECLS

#endif
