/* valaccodedynamicmethodbinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEDYNAMICMETHODBINDING_H__
#define __GOBJECT_VALACCODEDYNAMICMETHODBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valadynamicmethod.h>
#include <gobject/valaccodemethodbinding.h>
#include <gobject/valaccodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING (vala_ccode_dynamic_method_binding_get_type ())
#define VALA_CCODE_DYNAMIC_METHOD_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING, ValaCCodeDynamicMethodBinding))
#define VALA_CCODE_DYNAMIC_METHOD_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING, ValaCCodeDynamicMethodBindingClass))
#define VALA_IS_CCODE_DYNAMIC_METHOD_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING))
#define VALA_IS_CCODE_DYNAMIC_METHOD_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING))
#define VALA_CCODE_DYNAMIC_METHOD_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DYNAMIC_METHOD_BINDING, ValaCCodeDynamicMethodBindingClass))

typedef struct _ValaCCodeDynamicMethodBindingPrivate ValaCCodeDynamicMethodBindingPrivate;

/**
 * The link between a dynamic method and generated code.
 */
struct _ValaCCodeDynamicMethodBinding {
	ValaCCodeMethodBinding parent_instance;
	ValaCCodeDynamicMethodBindingPrivate * priv;
};

struct _ValaCCodeDynamicMethodBindingClass {
	ValaCCodeMethodBindingClass parent_class;
};


ValaCCodeDynamicMethodBinding* vala_ccode_dynamic_method_binding_new (ValaCCodeGenerator* codegen, ValaDynamicMethod* method);
void vala_ccode_dynamic_method_binding_generate_wrapper (ValaCCodeDynamicMethodBinding* self);
GType vala_ccode_dynamic_method_binding_get_type (void);


G_END_DECLS

#endif
