/* valaccodebinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __GOBJECT_VALACCODEBINDING_H__
#define __GOBJECT_VALACCODEBINDING_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodebinding.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valacodenode.h>
#include <vala/valamethod.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valaelementaccess.h>
#include <vala/valaassignment.h>

G_BEGIN_DECLS

typedef struct _ValaCCodeArrayCreationExpressionBinding ValaCCodeArrayCreationExpressionBinding;
typedef struct _ValaCCodeArrayCreationExpressionBindingClass ValaCCodeArrayCreationExpressionBindingClass;
typedef struct _ValaCCodeExpressionBinding ValaCCodeExpressionBinding;
typedef struct _ValaCCodeExpressionBindingClass ValaCCodeExpressionBindingClass;
typedef struct _ValaCCodeBinding ValaCCodeBinding;
typedef struct _ValaCCodeBindingClass ValaCCodeBindingClass;
typedef struct _ValaCCodeMethodBinding ValaCCodeMethodBinding;
typedef struct _ValaCCodeMethodBindingClass ValaCCodeMethodBindingClass;
typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
typedef struct _ValaCCodeDynamicMethodBinding ValaCCodeDynamicMethodBinding;
typedef struct _ValaCCodeDynamicMethodBindingClass ValaCCodeDynamicMethodBindingClass;
typedef struct _ValaCCodeDynamicPropertyBinding ValaCCodeDynamicPropertyBinding;
typedef struct _ValaCCodeDynamicPropertyBindingClass ValaCCodeDynamicPropertyBindingClass;
typedef struct _ValaCCodeDynamicSignalBinding ValaCCodeDynamicSignalBinding;
typedef struct _ValaCCodeDynamicSignalBindingClass ValaCCodeDynamicSignalBindingClass;
typedef struct _ValaCCodeElementAccessBinding ValaCCodeElementAccessBinding;
typedef struct _ValaCCodeElementAccessBindingClass ValaCCodeElementAccessBindingClass;
typedef struct _ValaCCodeAssignmentBinding ValaCCodeAssignmentBinding;
typedef struct _ValaCCodeAssignmentBindingClass ValaCCodeAssignmentBindingClass;

#define VALA_TYPE_CCODE_BINDING (vala_ccode_binding_get_type ())
#define VALA_CCODE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BINDING, ValaCCodeBinding))
#define VALA_CCODE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BINDING, ValaCCodeBindingClass))
#define VALA_IS_CCODE_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BINDING))
#define VALA_IS_CCODE_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BINDING))
#define VALA_CCODE_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BINDING, ValaCCodeBindingClass))

typedef struct _ValaCCodeBindingPrivate ValaCCodeBindingPrivate;

/**
 * The link between a source code node and generated code.
 */
struct _ValaCCodeBinding {
	ValaCodeBinding parent_instance;
	ValaCCodeBindingPrivate * priv;
};

struct _ValaCCodeBindingClass {
	ValaCodeBindingClass parent_class;
	void (*emit) (ValaCCodeBinding* self);
};


void vala_ccode_binding_emit (ValaCCodeBinding* self);
ValaCCodeIdentifier* vala_ccode_binding_get_value_setter_function (ValaCCodeBinding* self, ValaDataType* type_reference);
ValaCCodeExpression* vala_ccode_binding_get_construct_property_assignment (ValaCCodeBinding* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
ValaCCodeBinding* vala_ccode_binding_code_binding (ValaCCodeBinding* self, ValaCodeNode* node);
ValaCCodeMethodBinding* vala_ccode_binding_method_binding (ValaCCodeBinding* self, ValaMethod* node);
ValaCCodeArrayCreationExpressionBinding* vala_ccode_binding_array_creation_expression_binding (ValaCCodeBinding* self, ValaArrayCreationExpression* node);
ValaCCodeElementAccessBinding* vala_ccode_binding_element_access_binding (ValaCCodeBinding* self, ValaElementAccess* node);
ValaCCodeAssignmentBinding* vala_ccode_binding_assignment_binding (ValaCCodeBinding* self, ValaAssignment* node);
ValaCCodeGenerator* vala_ccode_binding_get_codegen (ValaCCodeBinding* self);
void vala_ccode_binding_set_codegen (ValaCCodeBinding* self, ValaCCodeGenerator* value);
GType vala_ccode_binding_get_type (void);


G_END_DECLS

#endif
