# File: superbox.py
# Purpose: Message box superclass.

OPT_THREAD = 1		# sort messages into threads
OPT_HEADERS_ONLY = 2	# only collect headers (without body text)

# Flags the various box types have
BOX_ISDELETEABLE = 0x01 # Can delete box
BOX_MAKE_NEW_MSG = 0x02 # Can compose new messages from it
BOX_REPLY_SINGLE = 0x04
BOX_REPLY_GROUP  = 0x08
BOX_REPLY_FORWARD= 0x10
BOX_DEL_MESSAGE  = 0x20 # allow deletion of messages
BOX_UPDATE_METHOD= 0x40 # there is an update method

class superbox:
	"""
	Message box superclass.
	"""
	def __init__(self, name, uid):
		self.name = name
		self.uid = uid
		self.opts = 0

