#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gui.h"
#include "jobmanager.h"
#include "database_mysql.h"
#include "configuration.h"
#include "datadispatcher.h"
#include "dirwatcher.h"

#include "job_connecttodatabase.h"
#include "splashscreen.h"

#include <unistd.h>
#include <qapplication.h>
#include <qtextcodec.h>
#include <getopt.h>

#include <qmessagebox.h>
#include <qtooltip.h>
#include <qpalette.h>

#include <libintl.h>
#define _(String) gettext (String)


GUI *gui;
JobManager *jobman;
DataBase *database;
Configuration *config;
DataDispatcher *datadispatcher;
DirWatcher *dirwatcher;
QApplication *app;

int verbose = 0;

void usage() {
  qWarning(_(" Valid options are:\n"
	   "    -vX ,verbose debug output to stderr. X: verbosity level (default to 1).\n"
           "      1,2 and 3 provide general purpose logging. Higher numbers for specific development only.\n"
	   "    -h ,this message\n\n"
	   " All standard QT command lines options are valid but not necessarily supported by Prokyon3:\n"
	   "    -style style, sets the application GUI style. Possible values are motif, windows, and platinum.\n"
	   "    -session session, restores the application from an earlier session.\n\n" 
	   " Prokyon3 also supports some traditional X11 command line options:\n" 
	   "    -display display, sets the X display (default is $DISPLAY). \n"
	   "    -geometry geometry, sets the client geometry of the main widget. \n"
	   "    -fn or -font font, defines the application font. The font should be specified\n"
	   "                 using an X logical font description. \n"
	   "    -bg or -background color, sets the default background color and an application palette \n"
	   "                              (light and dark shades are calculated). \n"
	   "    -fg or -foreground color, sets the default foreground color.\n" 
	   "    -btn or -button color, sets the default button color. \n"
	   "    -name name, sets the application name. \n"
	   "    -title title, sets the application title (caption). \n"
	   "    -visual TrueColor, forces the application to use a TrueColor visual on an 8-bit display. \n"
	   "    -ncols count, limits the number of colors allocated in the color cube on an 8-bit display,\n"
	   "    -cmap, causes the application to install a private color map on an 8-bit display. \n"));
}

/* Note: specific verbose mode is as follows:
   1 and above: Print a warning when catching library exception
   2 and above: dump files name when synchronizing 

   4 : trace tag edit signals and slots
   5 : trace deltamaps
   6 : dump tags detail when reading files
*/


int main(int argc, char *argv[])
{

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

  app = new QApplication(argc, argv);

  int optch;
  static char optstring[] = "v::h";
  while (( optch = getopt(argc,argv,optstring)) != -1)
    switch ( optch ) {
    case 'v':
      verbose = !optarg ? 1 : atoi(optarg);
      break;
    case 'h':
    default:
      usage();
      return 0;
    }

  QPixmap pixmap( PROKYON_HOME + "/images/splash4.png" );
  SplashScreen *splash = new SplashScreen( pixmap );
  splash->setFont( QFont("Times", 10, QFont::Bold) );
  splash->setStatus( _("Initializing...") );
  app->processEvents();

  QToolTip::setPalette( QPalette( Qt::black, Qt::cyan));
  config = new Configuration();

  gui = new GUI();
  jobman = new JobManager();
  database = new DataBase_MySQL();
  datadispatcher = new DataDispatcher();
  dirwatcher = new DirWatcher();
  app->processEvents();

  gui->resize( QSize( config->getwidth(), config->getheight()) );        // restore size
  gui->move( QPoint(config->getposx(), config->getposy() ) );
  gui->show();

  gui->notifyLostConnection();
		
  gui->getSelector()->correctSize();
  //  gui->getTagListing()->setFixedHeight(gui->getTagListing()->size().height() - gui->fontMetrics().lineSpacing()+4);
	
  gui->getSourcer()->init();
  app->processEvents();

  if(config->getStartupTip() == 1) {
    splash->finish(gui);
    gui->slot_WELCOME();
  }

  splash->setStatus( _("Connecting...") );
  if(config->getAutoConnect() == 1) {
    jobman->lock();
    jobman->addJob(new Job_ConnectToDatabase(config->getHOST(), config->getDATABASE(), config->getUSER(), config->getPASS()));
    jobman->unlock();
  }

  app->processEvents();
  app->setMainWidget(gui);
  if(config->getStartupTip() != 1) splash->finish(gui);
  delete splash;
  int x =  app->exec();

  usleep(300000);
	
  // dirwatcher->stop();
  delete dirwatcher;
  delete config;
  delete database;
  delete datadispatcher;
  //	delete app;
	
  return x;
}


