/***************************************************************************
                          job_modifytracksindatabase.cpp  -  description
                             -------------------
    begin                : Sat May 26 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "job_modifytracksindatabase.h"

#include "job_disconnectfromdatabase.h"

#include "database.h"
#include "jobmanager.h"
#include "datadispatcher.h"
#include "tagger.h"

#include "gui.h"

#include <qdir.h>

Job_ModifyTracksInDatabase::Job_ModifyTracksInDatabase(QList<TRACK> *_changedTracks, QList<QString> *_origFilenames, bool _updateSamplerTab, bool _updateFavouritesTab)
  : changedTracks(_changedTracks), origFilenames(_origFilenames), updateSamplerTab(_updateSamplerTab), updateFavouritesTab(_updateFavouritesTab)
{}

Job_ModifyTracksInDatabase::~Job_ModifyTracksInDatabase() {}

void Job_ModifyTracksInDatabase::run()
{
  int error = 0;

  app->lock();
  datadispatcher->eventAddEditLock();
  datadispatcher->eventAddReadWriteLock();
  app->unlock();

  TRACK *curr;
  QString *fname;
  for(curr = changedTracks->first(), fname = origFilenames->first();
      curr != 0 && fname != 0;
      curr = changedTracks->next(), fname = origFilenames->next())
    {
      bool fx = false;

      if((curr->filename != *fname) && Tagger::isExtensionValid(curr)) {
	QDir dir(curr->path);
	if(!dir.rename(*fname, curr->filename)) curr->filename = *fname; else fx = true;
      } else curr->filename = *fname;

      app->lock();
      datadispatcher->eventFilenameHasChanged(curr->id, curr->filename);
      app->unlock();
    }

  database->lock();
  app->lock();

  database->updateTracks(changedTracks);

  datadispatcher->eventNewArtistDelta(database->getArtistDelta());
  datadispatcher->eventRemoveReadWriteLock();
  datadispatcher->eventRemoveEditLock();
  datadispatcher->eventSelectArtistAlbum();
  if(updateSamplerTab) datadispatcher->eventNewSamplerBasis(database->getSamplerBasis());
  if(updateFavouritesTab) datadispatcher->eventNewFavouritesBasis(database->getFavouritesBasis());

  datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(0),0);
  int pID = gui->getPlaylisting()->getDisplayedPlaylistID();
  if(pID > 0) datadispatcher->eventNewPlaylistTracksBasis(database->getPlaylistTracksBasis(pID),pID);

  error = database->getError();

  app->unlock();
  database->unlock();

  if(error) {
    jobman->lock();
    jobman->addJob(new Job_DisconnectFromDatabase());
    jobman->unlock();
  }

  for(TRACK *curr = changedTracks->first(); curr != 0; curr = changedTracks->next()) delete curr;
  for(QString *curr = origFilenames->first(); curr != 0; curr = origFilenames->next()) delete curr;
  
  jobman->lock();
  jobman->jobDone(this);
  jobman->unlock();
  exit();
}
