/***************************************************************************
                          dirwatcher.cpp  -  description
                             -------------------
    begin                : Mon Jun 4 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirwatcher.h"

#include "datadispatcher.h"

#include <qdir.h>

DirWatcher::DirWatcher() { stopCalled = false; }

void DirWatcher::addDir(QString dir) {
  QFileInfo fi(dir);
  if(fi.exists()) lastChanged[dir] = fi.lastModified();
}

void DirWatcher::stop() {
  mutex.lock();
  stopCalled = true;
  mutex.unlock();
}

void DirWatcher::run()
{
  QFileInfo fi("/etc/mtab");
  QDateTime mtabDate = fi.lastModified();

  for(;;) {
    msleep(200);
    mutex.lock();
    if(stopCalled) { mutex.unlock(); exit(); }
    QFileInfo fi("/etc/mtab");
    if(fi.lastModified() != mtabDate) {
      mtabDate = fi.lastModified();
      for(QMap<QString, QDateTime>::Iterator it = lastChanged.begin(); it != lastChanged.end(); ++it) {
	QString dir = it.key();
	QFileInfo fi(dir);
	if(fi.exists()) {
	  if(fi.lastModified() != lastChanged[dir]) {
	    lastChanged[dir] = fi.lastModified();
	    app->lock();
	    datadispatcher->eventDirHasChanged(dir);
	    app->unlock();
	  }
	}
      }
    }
    mutex.unlock();
  }
}
