////////////////////////////////////////////////////////////////////////
// class_loader.cpp:
// some implementation code for class_loader.h and cllite.h
// 
// Author: stephan@s11n.net
// License: Public Domain
////////////////////////////////////////////////////////////////////////

#include <stdlib.h> // getenv()



#if HAVE_CONFIG_H
#  include "config.h" // might have PACKAGE_NAMESPACE_CLASS_LOADER_DEFAULT_PATH
#endif

////////////////////////////////////////////////////////////////////////////////
// When defining this via the build process, Be sure to escape the quotes:
// -DPACKAGE_NAMESPACE_CLASS_LOADER_DEFAULT_PATH=\"/some/path:/another/path\"
#ifndef PACKAGE_NAMESPACE_CLASS_LOADER_DEFAULT_PATH
#  define PACKAGE_NAMESPACE_CLASS_LOADER_DEFAULT_PATH "."
#endif
////////////////////////////////////////////////////////////////////////////////



#include "path_finder.h" // path_finder class
#include "class_loader.h" // core cl framework
#include "cllite.h" // "lite" framework

#ifndef PACKAGE_NAMESPACE_CLASSLOADER_DEBUG_DEFAULT
    // lib's startup default debugging level for classloader_debug_level()
#  define PACKAGE_NAMESPACE_CLASSLOADER_DEBUG_DEFAULT 0
#endif

////////////////////////////////////////////////////////////////////////////////
// class_loader stuff:
namespace PACKAGE_NAMESPACE {

        int m_CL_debug_level = PACKAGE_NAMESPACE_CLASSLOADER_DEBUG_DEFAULT;
        int class_loader_debug_level() { return m_CL_debug_level; }
        void class_loader_debug_level( int dlevel ) { m_CL_debug_level = dlevel; }


}
// end class_loader
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// cllite:

#define LITECERR if(PACKAGE_NAMESPACE::class_loader_debug_level() > 0) CERR

namespace cllite {

        struct sharing_context {};

        std::string open_dll( const std::string & key )
        {

                std::string where = class_path().find( key );
                if( where.empty() )
                {
                        LITECERR << "No dll found for key '"<<key<<"' "
                             << "in path ["<<class_path()<<"]\n";
                        return where;
                }

                static bool donethat = false;
                if( !donethat && (donethat=true) )
                {
                        // About these dlopen(0) calls:
                        // They are here for client-side convenience, to open the main() app.
                        // In theory, that really isn't necessary any more, but that needs 
                        // to be tested.
#if ! WIN32
#  if HAVE_LTDL
                        lt_dlinit();
                        lt_dlopen( 0 );
#  else
                        dlopen( 0, RTLD_NOW | RTLD_GLOBAL );
#  endif
#else
                        // ??? anything?
#endif // WIN32
                }
                void * soh = 0;
#if ! WIN32
#  if HAVE_LTDL // libltdl:
                soh = lt_dlopen( where.c_str() );
#  else // libdl:
                soh = dlopen( where.c_str(), RTLD_NOW | RTLD_GLOBAL );
#  endif
                return soh ? where : "";
#else // WIN32:
                LoadModule( where.c_str(), NULL ); // WTF does LoadModule() really return?
                return where;
#endif // WIN32
        }

        const char * dll_error()
        {
#if ! WIN32
#  if HAVE_LTDL
                return lt_dlerror();
#  else
                return dlerror();
#  endif
#else
                return 0;
                // win32 equivalent (???)
#endif // !WIN32
        }


        classname_to_dllname::classname_to_dllname() : m_nssep("_")
        {}

        classname_to_dllname::classname_to_dllname( const std::string & ns_xlate )
                : m_nssep(ns_xlate)
        {}

        std::string
        classname_to_dllname::operator()( const std::string & key ) const
        {
                std::string xlated = key;
                std::string::size_type colon, pos = 0;
                if( std::string::npos != (colon = key.find( "<"))  )
                {
                        xlated = xlated.substr( 0, colon );
                }
                while( std::string::npos != (colon = xlated.find( ":", pos ))  )
                {
                        xlated.replace( colon, 2, this->m_nssep );
                        pos = colon + 2;
                }
                return xlated;
        }
        


        /**
           Internal helper class for setting the shared classloader
           path. Initializes the  given path_finder  using the global
           classloader path. Intended for use with phoenix<>.
         */
        struct class_path_initer
        {
                void operator()( PACKAGE_NAMESPACE::path_finder & path )
                {
#if WIN32
                        path.add_extension( ".dll" );
#else
                        path.add_extension( ".so" );
#endif
                        path.add_path( PACKAGE_NAMESPACE_CLASS_LOADER_DEFAULT_PATH );
                        const char * p = 0;
                        if( (p = getenv( "LD_LIBRARY_PATH" )) )
                        {
                                path.add_path( p );
                        }
                        if( (p = getenv( "CLLITE_CLASSPATH" )) )
                        {
                                path.add_path( p );
                        }
                }
        };



        /**
           Returns this library's class search-path. It is up to specific
           classloaders to use or ignore this path: it is a
           suggestion, and not a rule. Clients are free to modify
           the returned object.
        */
        PACKAGE_NAMESPACE::path_finder & class_path()
        {
                return PACKAGE_NAMESPACE::phoenix<
                        PACKAGE_NAMESPACE::path_finder,
                        cllite::sharing_context,
                        class_path_initer
                        >::instance();
        }



} // namespace cllite

