/* ptal-device -- PTAL command-line device listing client */

/* Copyright (C) 2000-2002 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 * In addition, as a special exception, Hewlett-Packard Company
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included LICENSE.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

/* Original author: David Paschal */

#include <stdio.h>
#include "ptal.h"


int devicePrintfCallback(ptalDevice_t dev,void *cbd) {
	printf("%s\n",ptalDeviceGetName(dev));
	return 1;
}

int main(int argc,char **argv) {
	ptalInit();

	/* TODO: Add command-line options for adding devices to the mix,
	 * querying information from a specific device's config file,
	 * and/or adjusting the output format. */

	ptalDeviceEnumerate(0,devicePrintfCallback,0);

	ptalDone();
	return 0;
}
