/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
package com.db4odoc.android.compare.refactored;

import java.io.File;
import java.util.Date;

import android.content.Context;
import android.util.Log;
import android.widget.TextView;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.query.Query;


public class Db4oExample {
	
	private static ObjectContainer _container = null;
	private static Context _context = null;
	private static TextView _console = null;
	
	
	public static void init(Context context, TextView console){
		_context = context;
		_console = console;
	}
	// end init

	public static void init(Context context){
		_context = context;
	}
	// end init

	
	public static ObjectContainer database(){
		long startTime = 0;
    	try {
    		if(_container == null){
    			startTime = System.currentTimeMillis();
    			_container = Db4o.openFile(configure(), db4oDBFullPath());
    		}
    	} catch (Exception e) {
        	Log.e(Db4oExample.class.getName(), e.toString());
        	return null;
        }
    	logToConsole(startTime, "Database opened: ", false);
    	return _container;
    }
	// end database
	
	private static void logToConsole(long startTime, String message, boolean add) {
		if (_console != null){
			long diff = 0;
    		if (startTime != 0){
    			diff = (System.currentTimeMillis() - startTime);
    		} 
			if (add){
				_console.setText(_console.getText() + "\n" + message + diff + " ms.");
			} else {
				_console.setText("db4o: " + message + diff + " ms.");
			}
    	}
	}
	// end logToConsole
	
	private static Configuration configure(){
		Configuration configuration = Db4o.newConfiguration();
    	configuration.objectClass(Car.class).objectField("pilot").indexed(true);
    	configuration.objectClass(Pilot.class).objectField("points").indexed(true);
    	configuration.lockDatabaseFile(false);
        
    	return configuration;
    }
	// end configure
	
	private static String db4oDBFullPath() throws Exception {
		if (_context == null){
			throw new Exception("Db4o Module not initialized");
		}
		return _context.getDataDir() + "/" + "android.db4o";
	}
	// end db4oDBFullPath
	
	/**
     * Close database connection
     */
    public static void close() {
    	if(_container != null){
    		long startTime = System.currentTimeMillis();
    		_container.close();
    		logToConsole(startTime, "Database committed and closed: ", false);
    		_container = null;
    	}
    }
    // end close
	
	
    public static void fillUpDB() throws Exception {
    	close();
        new File(db4oDBFullPath()).delete();
        ObjectContainer container=database();
        if (container != null){
        	long startTime = System.currentTimeMillis();
        	for (int i=0; i<100;i++){
    			addCar(container,i);
    		}
        	logToConsole(startTime, "Stored 100 objects: ", false);
        	startTime = System.currentTimeMillis();
		}
    }
    // end fillUpDB

    
    public static void selectCarAndUpdate() {
    	ObjectContainer container = database();
    	if (container != null){
			Query query = container.query();
			query.constrain(Car.class);
			query.descend("pilot").descend("points").constrain(new Integer(15));

			long startTime = System.currentTimeMillis();
			ObjectSet  result = query.execute();
			result.reset();
			if (!result.hasNext()){
				logToConsole(0, "Car not found, refill the database to continue.", false);
			} else {
				Car car = (Car)result.next();
				logToConsole(startTime, "Selected Car (" + car + "): ", false);
				startTime = System.currentTimeMillis();
				car.setRegistration(new RegistrationRecord("A1", new Date(System.currentTimeMillis())));
				logToConsole(startTime, "Updated Car (" + car + "): ", true);
			}
			
    	}
    }
    // end selectCarAndUpdate

    
    private static void addCar(ObjectContainer container, int points)
	{
		Car car = new Car("BMW");
		car.setPilot(new Pilot("Tester", points));
		container.set(car);
	}
    // end addCar
        
}
