/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;

namespace Db4objects.Db4o.Internal.Query
{
	/// <summary>
	/// A very simple caching strategy that caches only the last added item.
	/// </summary>
	public class SingleItemCachingStrategy : ICachingStrategy
	{
		private object _lastKey;
		private object _lastItem;
		private object _monitor = new object();
		
		#region ICachingStrategy Members
		public void Add(object key, object item)
		{
			if (null == key) throw new ArgumentNullException("key");
			lock (_monitor)
			{
				_lastKey = key;
				_lastItem = item;
			}
		}

		public object Get(object key)
		{
			if (null == key) throw new ArgumentNullException("key");
			lock (_monitor)
			{
				return key.Equals(_lastKey)
					? _lastItem
					: null;
			}
		}
		#endregion
	}
    
    public class NullCachingStrategy : ICachingStrategy
    {
        public static readonly ICachingStrategy Default = new NullCachingStrategy();
        
        #region ICachingStrategy Members
        public void Add(object key, object item)
        {   
        }

        public object Get(object key)
        {
            return null;
        }
        #endregion
    }
}