/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using System.Linq.Expressions;
using System.Text;

using Db4objects.Db4o.Linq.Caching;

using Db4oUnit;
using Db4oUnit.Extensions;

namespace Db4objects.Db4o.Linq.Tests.Caching
{
	public class CachingStrategyTestCase : AbstractDb4oTestCase
	{
		public void TestSingleItemStrategy()
		{
			var strategy = new SingleItemCachingStrategy<string, int>();
			strategy.Add("foo", 42);
			Assert.AreEqual(42, strategy.Get("foo"));
			strategy.Add("bar", 7);
			Assert.AreEqual(0, strategy.Get("foo"));
			Assert.AreEqual(7, strategy.Get("bar"));
		}

		public void TestAllItemsStrategy()
		{
			var strategy = new AllItemsCachingStrategy<string, int>();
			strategy.Add("foo", 42);
			strategy.Add("bar", 7);
			strategy.Add("baz", 12);

			Assert.AreEqual(7, strategy.Get("bar"));
			Assert.AreEqual(12, strategy.Get("baz"));
			Assert.AreEqual(42, strategy.Get("foo"));
		}

		public void TestNullStrategy()
		{
			var strategy = new NullCachingStrategy();
			strategy.Add("foo", 42);
			strategy.Add("bar", 7);

			Assert.AreEqual(null, strategy.Get("foo"));
			Assert.AreEqual(null, strategy.Get("bar"));
		}
	}
}
