/***************************************************************************
                          code.cpp  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of thef License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "cuyointl.h"
#include "global.h"
#include "code.h"
#include "variable.h"
#include "fehler.h"
#include "blop.h"
#include "knoten.h"
#include "aufnahme.h"


//tCodeSpeicher Code::gCodeSpeicher;


/* Die ganzen (normalen) Konstruktoren brauchen alle ein paar Standard-
   Parameter, die ich nicht jedes mal tippen will... */
     
#define STDPAR DefKnoten * knoten, __String datna, int znr, int art
#define STDINIT \
  mArt(art), \
  mBeschaeftigtNr(knoten->neueBoolVariable()), \
  mDateiName(datna), \
  mZeilenNr(znr)


Code::Code(STDPAR): STDINIT,
  mF1(0), mF2(0), mF3(0), mVar1(0), mVar2(0)
{
}




Code::Code(STDPAR, int zahl, int zahl2 /* = 0 */): STDINIT,
  mF1(0), mF2(0), mF3(0), mVar1(0), mVar2(0),
  mZahl(zahl), mZahl2(zahl2)
{
}


Code::Code(STDPAR, Variable * v1): STDINIT,
  mF1(0), mF2(0), mF3(0), mVar1(v1), mVar2(0)
{
}


Code::Code(STDPAR, Variable * v1, Variable * v2): STDINIT,
  mF1(0), mF2(0), mF3(0), mVar1(v1), mVar2(v2)
{
}


Code::Code(STDPAR, Variable * v1, int zahl): STDINIT,
  mF1(0), mF2(0), mF3(0), mVar1(v1), mVar2(0), mZahl(zahl)
{
}


Code::Code(STDPAR, Code * f1, Variable * v1): STDINIT,
  mF1(f1), mF2(0), mF3(0), mVar1(v1), mVar2(0)
{
}


Code::Code(STDPAR, Code * f1,
           int zahl /* = 0 */, int zahl2 /* = 0 */): STDINIT,
  mF1(f1), mF2(0), mF3(0), mVar1(0), mVar2(0),
  mZahl(zahl), mZahl2(zahl2)
{
}


Code::Code(STDPAR, Code * f1, Code * f2,
           Code * f3 /* =0 */, int zahl /* = 0 */): STDINIT,
  mF1(f1), mF2(f2), mF3(f3), mVar1(0), mVar2(0),
  mZahl(zahl)
{
}


Code::Code(STDPAR, Code * f1, Code * f2, Variable * v1): STDINIT,
  mF1(f1), mF2(f2), mF3(0), mVar1(v1), mVar2(0)
{
}


Code::Code(STDPAR, __String str): STDINIT,
  mF1(0), mF2(0), mF3(0), mVar1(0), mVar2(0),
  mString(str)
{
}  


#undef STDPAR
#undef STDINIT
  
Code::Code(DefKnoten * knoten, const Code & f, bool neueBusyNummern):
       Definition() {
  kopiere(knoten, f, neueBusyNummern);
}




void Code::deepLoesch() {
  if (mF1) delete mF1;
  if (mF2) delete mF2;
  if (mF3) delete mF3;
  if (mVar1) delete mVar1;
  if (mVar2) delete mVar2;
}




void Code::kopiere(DefKnoten * knoten, const Code & f, bool neueBusyNummern) {
  mArt = f.mArt;
  
  mDateiName = f.mDateiName;
  mZeilenNr = f.mZeilenNr;

  if (f.mF1)
    mF1 = new Code(knoten, *f.mF1, neueBusyNummern);
  else
    mF1 = 0;

  if (f.mF2)
    mF2 = new Code(knoten, *f.mF2, neueBusyNummern);
  else
    mF2 = 0;

  if (f.mF3)
    mF3 = new Code(knoten, *f.mF3, neueBusyNummern);
  else
    mF3 = 0;

  if (f.mVar1)
    mVar1 = new Variable(*f.mVar1);
  else
    mVar1 = 0;

  if (f.mVar2)
    mVar2 = new Variable(*f.mVar2);
  else
    mVar2 = 0;

  mZahl = f.mZahl;
  mZahl2 = f.mZahl2;

  mString = f.mString;
  
  if (neueBusyNummern)
    mBeschaeftigtNr = knoten->neueBoolVariable();
  else
    mBeschaeftigtNr = f.mBeschaeftigtNr;
}









/** Wird von eval vom Vater aufgerufen, wenn er wissen will, ob
    das Kind fertig ist. */
bool Code::istBeschaeftigt(Blop & b) const {
  return b.getBoolVariable(mBeschaeftigtNr);
}

/** Setzt, ob dieser Code beschftigt ist. Wird von eval()
    aufgerufen. */
void Code::setBeschaeftigt(Blop & b, bool besch) const {
  b.setBoolVariable(mBeschaeftigtNr, besch);
}



/** Liefert einen String zurck, der angibt, wo dieser Code
    definiert wurde (fr Fehlermeldungen) */
__String Code::getDefString() const {
  __String ret;
  ret.sprintf("%s:%d", mDateiName.data(), mZeilenNr);
  return ret;
}





/** Liefert zurck, wie viele Bilder dieser Code hchstens gleichzeitig
    malt. Dabei wird (im Moment) der Einfachheit halber davon ausgegangen,
    dass Ausdrcke nix malen knnen; dementsprechend darf getAnzBilder()
    dafr auch nicht aufgerufen werden. nsh wird um die Anzahl der
    Nachbarstapel-Malungen erhht. */
int Code::getStapelHoehe(int & nsh) const {
  switch (mArt) {
    case weiterleit_code:
      return mF1->getStapelHoehe(nsh);
    case stapel_code:
      return mF1->getStapelHoehe(nsh) + mF2->getStapelHoehe(nsh);
    case push_code:
      return mF2->getStapelHoehe(nsh);
    case set_code:
    case add_code:
    case sub_code:
    case mul_code:
    case div_code:
    case mod_code:
    case nop_code:
    case busy_code:
    case buchstabe_code:
    case zahl_code:
    case bonus_code:
    case message_code:
    case explode_code:
      return 0;
    case mal_code:
      return 1;
    case mal_code_relativ:
      nsh++;
      return 0;
    case folge_code: {
      int a1 = mF1->getStapelHoehe(nsh);
      int a2 = mF2->getStapelHoehe(nsh);
      return a1 > a2 ? a1 : a2;
    }
    case bedingung_code: {
      int a2 = mF2->getStapelHoehe(nsh);
      int a3 = mF3->getStapelHoehe(nsh);
      return a2 > a3 ? a2 : a3;
    }
    /* Fr die ganzen Ausdruck-Codes darf getStapelHoehe() nicht aufgerufen
       werden. */
    default:
      throw iFehler(_("%s: Internal error in Code::getStapelHoehe(): Unbekannte Code-Art %d"),
                   getDefString().data(), mArt);
  }
}





int Code::eval(Blop & b) const {
  /* Fehlermeldung verbessern */
  try {

    int ret = 0;
    switch (mArt) {
      case weiterleit_code:
        mF1->eval(b);
	setBeschaeftigt(b, mF1->istBeschaeftigt(b));
        break;
      case stapel_code:
	mF1->eval(b);
	mF2->eval(b);
	setBeschaeftigt(b,
	  mF1->istBeschaeftigt(b) || mF2->istBeschaeftigt(b));
	break;
      case push_code: {
	int merk = b.getVariable(*mVar1);
	b.setVariable(*mVar1, mF1->eval(b), set_code);
	mF2->eval(b);
	b.setVariable(*mVar1, merk, set_code);
	setBeschaeftigt(b, mF2->istBeschaeftigt(b));
	break;
      }
      case set_code:
      case add_code:
      case sub_code:
      case mul_code:
      case div_code:
      case mod_code: {
	int w;
	w = mF1->eval(b);
        
	if (mArt == div_code && w == 0)
          throw Fehler(_("Division by zero"));

	if (mArt == mod_code && w == 0)
          throw Fehler(_("Modulo zero"));

        /* setVariable() entscheidet anhand von mArt, was zu tun ist.
	   Insbesondere wird die Operation vielleicht erst in der Zukunft
	   ausgefhrt. */
	b.setVariable(*mVar1, w, mArt);

	break;
      }
      case mal_code:
	b.speichereBild();
	break;
      case mal_code_relativ:
	b.speichereBildRelativ(mZahl, mZahl2);
	break;
      case nop_code:
	break;
      case busy_code:
        /* Anmerkung: Auch ein busy-Code ist nicht immer busy, sondern nur
	   dann, wenn er grade ausgefhrt wird. */
	setBeschaeftigt(b, true);
	break;
      case folge_code: {
	/* Ablauf einer Folge:
	 A - Wenn niemand beschftigt ist (weder ich noch Kinder), dann fngt
             die Folge frisch an => Kind1, selbst auf beschftigt schalten
	 B - Wenn ich beschftigt bin, schaue ob Kind1 beschftigt.
	 C   - Wenn ja, sind wir noch in der Kind1 Folge => Kind1
	 D   - Wenn nein, sind wir mit Kind1 fertig => Kind2
               Auerdem selbst auf unbeschftigt schalten, wenn Kind2 fertig ist
               (also auf unbeschftigt geschaltet hat)
	   - Wenn ich selbst unbeschftigt bin, aber ein Kind, ist irgend was
             schiefgelaufen. Das kann eigentlich noch nicht mal durch Programm-
             unterbrechung passieren.
	*/
	bool ich_besch = istBeschaeftigt(b);
	if (!ich_besch) {
	  // Fall A
	  mF1->eval(b);
	  setBeschaeftigt(b, true);
	} else {
	  // Fall B
	  bool k1_besch = mF1->istBeschaeftigt(b);
	  if (k1_besch) {
            // Fall C
            mF1->eval(b);
	  } else {
            // Fall D
            mF2->eval(b);
            if (!mF2->istBeschaeftigt(b))
              setBeschaeftigt(b, false);
	  }
	}

	break;
      }
      case buchstabe_code: {
	b.setVariable(spezvar_pos, mZahl, set_code);
	break;
      }
      case zahl_code: {
	b.setVariable(spezvar_file, mZahl, set_code);
	break;
      }
      case bedingung_code: {
	
	
	/* Funktionsweise von
	     switch {
	       bed_1 pfeil_1 code_1;
	       bed_2 pfeil_2 code_2;
	       ...
	     }
	   
	   
	   a) Bestimmen, welcher Ast im im vorigen Schritt ausgefhrt wurde.
	      Wenn wir es nicht rausfinden knnen, brauchen wir es auch
	      nicht zu wissen:
	        v := -1
                Wenn fr ein i code_i busy ist:
	          v := i
         */
	int v = -1;
	if (mF2->istBeschaeftigt(b)) v = 1;
	if (mF3->istBeschaeftigt(b)) v = 2;
	 
	 /*
           b) Bestimmen, was wir als nchstes ausfhren wollen:
	        Wenn v != -1 && pfeil_v == "=>":
	          n := v
        	Sonst:
  	          n := minimal, so dass bed_n true ist.
	*/
	int n;
	if (v != -1 && (mZahl & v))
	  n = v;
	else if (mF1->eval(b))
	  n = 1;
	else
	  n = 2;
	
        /*
	   c) Evtl. busy-Reset:
                Wenn v != -1 && v != n:
	          Sende code_v ein busy_reset.
	 */
	if (v != -1 && v != n) {
	  if (v == 1) mF2->busyReset(b);
	  else mF3->busyReset(b);
	}
	/*     
	   Ausfhrung:
	     Fhre code_n aus.
	     Sei busy, wenn code_n busy ist.
	   Diese letzte Zeile ist im Moment verndert zu:
	     Sei busy, wenn code_n busy ist und pfeil_n == "=>"
	*/
	if (n == 1) {
	  mF2->eval(b);
          setBeschaeftigt(b, (mZahl & 1) && mF2->istBeschaeftigt(b));
	} else {
	  mF3->eval(b);
          setBeschaeftigt(b, (mZahl & 2) && mF3->istBeschaeftigt(b));
	}

	
	break;
      }
       case bonus_code: {
         b.bekommPunkte(mF1->eval(b));
        break;
      }
      case message_code: {
        b.zeigMessage(mString);
	break;
      }
      case explode_code: {
        if (b.getSpezConst(spezconst_falling)) {
          if (gDebug)
            fprintf(stderr, "Warning: Can't use 'explode' in falling blob.\n");
	} else
          b.lassPlatzen();
        break;
      }
      
      /***** Ab hier: Ausdruck-Codes *****/
      
      case zahl_acode: {
	ret = mZahl;
	break;
      }
      case variable_acode: {
	ret = b.getVariable(*mVar1);
	break;
      }
      case manchmal_acode: {
	ret = mF2->eval(b);
	if (ret == 0)
	  throw Fehler(_("Probability x:0 in the animation program"));
	/* Vermutlich sollte auch "long" oder so statt double gehen; aber
	   ich bin mir grad nicht ganz sicher, ob long wirklich immer long
	   genug ist. */
	ret = Aufnahme::rnd(mF2->eval(b)) < mF1->eval(b);
	break;
      }
      case nachbar_acode: {
	ret = (b.getVariable(spezconst_connect) & mZahl) == mZahl2;
	break;
      }
      case eq_acode: {
	ret = mF1->eval(b) == mF2->eval(b);
	break;
      }
      case ne_acode: {
	ret = mF1->eval(b) != mF2->eval(b);
	break;
      }
      case gt_acode: {
	ret = mF1->eval(b) > mF2->eval(b);
	break;
      }
      case lt_acode: {
	ret = mF1->eval(b) < mF2->eval(b);
	break;
      }
      case ge_acode: {
	ret = mF1->eval(b) >= mF2->eval(b);
	break;
      }
      case le_acode: {
	ret = mF1->eval(b) <= mF2->eval(b);
	break;
      }
      case not_acode: {
	ret = ! mF1->eval(b);
	break;
      }
      case rnd_acode: {
	int w = mF1->eval(b);
	if (w <= 0)
	  throw Fehler(_("rnd(<=0) in the animation program"));
	ret = Aufnahme::rnd(w);
	break;
      }
      case und_acode: {
	ret = mF1->eval(b) && mF2->eval(b);
	break;
      }
      case oder_acode: {
	ret = mF1->eval(b) || mF2->eval(b);
	break;
      }
      case add_acode: {
	ret = mF1->eval(b) + mF2->eval(b);
	break;
      }
      case sub_acode: {
	ret = mF1->eval(b) - mF2->eval(b);
	break;
      }
      case mul_acode: {
	ret = mF1->eval(b) * mF2->eval(b);
	break;
      }
      case div_acode: {
	ret = mF2->eval(b);
	if (ret == 0)
	  throw Fehler(_("Division by zero"));
	ret = mF1->eval(b) / ret;
	break;
      }
      case mod_acode: {
	ret = mF2->eval(b);
	if (ret == 0)
	  throw Fehler(_("Modulo zero"));
	ret = mF1->eval(b) % ret;
	break;
      }
      case neg_acode: {
        ret = -mF1->eval(b);
	break;
      }
      case intervall_acode: {
	int z1 = mF1->eval(b);
	ret = (z1 >= mZahl && z1 <= mZahl2);
	break;
      }
      case ggt_acode: {
        int a_ = mF1->eval(b);
        int b_ = mF2->eval(b);
        while (b_!=0) {
          int c_ = a_%b_;
          a_=b_;
          b_=c_;
        };
        ret = a_;
        break;
      }
      default: {
	throw iFehler(_("Internal error in Code::eval(): Unbekannte Code-Art %d"), mArt);
	break; // mit dem break fhl ich mich wohler...
      }
    }  
    return ret;


  } catch (Fehler fe) {
    /* Fehlermeldung verbessern */
    if (!fe.mMitZeile) {
      /* Da ist noch keine Zeilenangabe dabei. Also eine hinzufgen. */
      Fehler f2 = Fehler(_("%s: %s"), getDefString().data(), fe.getText().data());
      f2.mMitZeile = true;
      throw f2;
    } else
      throw fe;
  }
}




/** Setzt das Busy-Flag dieses Codes auf false zurck (ggf. rekursiv).
    Erwartet, dass aus (x busy) auch (vater-von-x busy) folgt. */
void Code::busyReset(Blop & b) const {
  if (istBeschaeftigt(b)) {
    setBeschaeftigt(b, false);
    if (mF1) mF1->busyReset(b);
    if (mF2) mF2->busyReset(b);
    if (mF3) mF3->busyReset(b);
  }
}



/************************************************************************/


/** Erzeugt einen Code, der prft, ob es die
    gewnschten Nachbarn gibt (aus "01?"-String).
    Der "01?"-String kann Lnge 6 oder 8 haben. */
Code * newNachbarCode(DefKnoten * knoten, __String datna, int znr, __String * str) {
  /* Getestet wird nachher: x & z1 == z2 */
  int l = str->length();
  CASSERT(l == 6 || l == 8);
  int z1 = 0, z2 = 0;
  int bit = 1;
  for (int i = 0; i < l; i++) {
    if ((*str)[i] != '?')
      z1 |= bit;
    if ((*str)[i] == '1')
      z2 |= bit;
    bit *= 2;
    /* Wenn die Lnge 6 ist, dann intern noch Fragezeichen fr
       die waagrechten Richtungen einfgen (nach den Hex-Zeichen
       1 und 4). */
    if (l == 6 && (i == 1 || i == 4))
      bit *= 2;
  }
  delete str;
  return new Code(knoten, datna, znr, nachbar_acode, z1, z2);
}




