#
#   Copyright 2005 by Mark Weyer
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

SilberGold={
  name="Silver and Gold"
  name[de]="Silber und Gold"
  author="Mark Weyer"
  numexplode=4
  chaingrass=0
  pics=silber,gold,silbergold,goldsilber
  bgcolor=0,0,0
  topcolor=255,255,255
  textcolor=255,0,0
  toptime=200
  emptypic=nichts
  startpic=weiss
  startdist=".AA.AA.AA.","AAAAAAAAAA","AAAAAAAAAA"
  greypic=grau
  neighbours=4
  description="..."

  <<

    verbindungen = {
      pos=1;
      qu=Q_TL;
      if (kind@(-1,0)==gold) && (kind@(1,-1)==gold) -> {file=1; *};
      if (kind@(-1,0)==goldsilber) && (kind@(1,-1)==goldsilber) -> {file=3; *};
      if (kind@(0,-1)==silber) && (kind@(-1,1)==silber) -> {file=0; *};
      if (kind@(0,-1)==silbergold) && (kind@(-1,1)==silbergold) -> {file=2; *};
      qu=Q_TR;
      if (kind@(-1,-1)==gold) && (kind@(1,0)==gold) -> {file=1; *};
      if (kind@(-1,-1)==silbergold) && (kind@(1,0)==silbergold) -> {file=2; *};
      if (kind@(0,-1)==silber) && (kind@(1,1)==silber) -> {file=0; *};
      if (kind@(0,-1)==goldsilber) && (kind@(1,1)==goldsilber) -> {file=3; *};
      qu=Q_BL;
      if (kind@(0,1)==silber) && (kind@(-1,-1)==silber) -> {file=0; *};
      if (kind@(0,1)==goldsilber) && (kind@(-1,-1)==goldsilber) -> {file=3; *};
      if (kind@(-1,0)==gold) && (kind@(1,1)==gold) -> {file=1; *};
      if (kind@(-1,0)==silbergold) && (kind@(1,1)==silbergold) -> {file=2; *};
      qu=Q_BR;
      if (kind@(0,1)==silber) && (kind@(1,-1)==silber) -> {file=0; *};
      if (kind@(0,1)==silbergold) && (kind@(1,-1)==silbergold) -> {file=2; *};
      if (kind@(-1,1)==gold) && (kind@(1,0)==gold) -> {file=1; *};
      if (kind@(-1,1)==goldsilber) && (kind@(1,0)==goldsilber) -> {file=3; *};
    };

    nichts = verbindungen;

    silber.init = {inhibit = DIR_LLU+DIR_LLD+DIR_RRD+DIR_RRU};
    silber = {file=0; *; verbindungen;};

    gold.init = {inhibit = DIR_UUL+DIR_DDL+DIR_DDR+DIR_UUR};
    gold = {file=1; *; verbindungen;};

    silbergold.init = {inhibit = DIR_UUL+DIR_LLD+DIR_DDR+DIR_RRU};
    silbergold = {file=2; *; verbindungen;};

    goldsilber.init = {inhibit = DIR_LLU+DIR_DDL+DIR_RRD+DIR_UUR};
    goldsilber = {file=3; *; verbindungen;};

    weiss = {file=4; *; verbindungen;};
    grau.init = {switch {
        1:4 -> {kind=silber; silber.init;};
        1:3 -> {kind=gold; gold.init;};
        1:2 -> {kind=silbergold; silbergold.init;};
            -> {kind=goldsilber; goldsilber.init;};
      };
    };

  >>

  silber = {pics = mgsSilber.xpm,mgsGold.xpm,
    mgsSilberGold.xpm,mgsGoldSilber.xpm}
  gold = {pics = mgsSilber.xpm,mgsGold.xpm,
    mgsSilberGold.xpm,mgsGoldSilber.xpm}
  silbergold = {pics = mgsSilber.xpm,mgsGold.xpm,
    mgsSilberGold.xpm,mgsGoldSilber.xpm}
  goldsilber = {pics = mgsSilber.xpm,mgsGold.xpm,
    mgsSilberGold.xpm,mgsGoldSilber.xpm}
  nichts = {pics = mgsSilber.xpm,mgsGold.xpm,
    mgsSilberGold.xpm,mgsGoldSilber.xpm}
  weiss = {pics = mgsSilber.xpm,mgsGold.xpm,
    mgsSilberGold.xpm,mgsGoldSilber.xpm,mgsWeiss.xpm}
  grau = {pics = mgsSilber.xpm,mgsGold.xpm,
    mgsSilberGold.xpm,mgsGoldSilber.xpm}

}

