/*
** Copyright (C) 1995-1997 The University of Melbourne.
** This file may only be copied under the terms of the GNU Library General
** Public License - see the file COPYING.LIB in the Mercury distribution.
*/

/*
** mercury_types.h - definitions of some basic types used by the
** code generated by the Mercury compiler and by the Mercury runtime.
*/

#ifndef MERCURY_TYPES_H
#define MERCURY_TYPES_H

#include "conf.h"

/* 
** Note that we require sizeof(Word) == sizeof(Integer) == sizeof(Code*)
** this is assured by the autoconfiguration script
*/

typedef	unsigned WORD_TYPE	Word;
typedef WORD_TYPE		Integer;
typedef unsigned WORD_TYPE	Unsigned;
typedef void			Code;	/* code addresses are `void *' */

/*
** Float64 is required for the bytecode.
** XXX: We should also check for IEEE-754 compliance.
*/

#if	MR_FLOAT_IS_64_BIT
	typedef	float			Float64;
#elif	MR_DOUBLE_IS_64_BIT
	typedef	double			Float64;
#elif	MR_LONG_DOUBLE_IS_64_BIT
	typedef	long double		Float64;
#else
	#error	For Mercury bytecode, we require 64-bit IEEE-754 floating point
#endif


/* continuation function type, for --high-level-C option */
typedef void (*Cont) (void);

/* spinlocks -- see spinlock.h */
typedef Word	SpinLock;

/*
** semidet predicates indicate success or failure by leaving nonzero or zero
** respectively in register r1
** (should this #define go in some other header file?)
*/
#define SUCCESS_INDICATOR r1

#endif /* not MERCURY_TYPES_H */
