/*
** Automatically generated from `io.m' by the Mercury compiler,
** version 0.7.3, configured for alpha-dec-osf3.2.
** Do not edit.
*/
/*
INIT mercury__io__init
ENDINIT
*/

#include "imp.h"
#include "io.h"

#line 15 "io.c"
#line 946 "io.m"

	extern Word ML_io_stream_names;
	extern Word ML_io_user_globals;
	#if 0
	  extern Word ML_io_ops_table;
	#endif

#line 24 "io.c"
#line 1999 "io.m"


#include "init.h"
#include "wrapper.h"
#include "type_info.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef HAVE_SYS_WAIT
#include <sys/wait.h>
#endif

/*
** Mercury files are not quite the same as C stdio FILEs,
** because we keep track of a little bit more information.
*/

typedef struct mercury_file {
	FILE *file;
	int line_number;
} MercuryFile;

extern MercuryFile mercury_stdin;
extern MercuryFile mercury_stdout;
extern MercuryFile mercury_stderr;
extern MercuryFile *mercury_current_text_input;
extern MercuryFile *mercury_current_text_output;
extern MercuryFile *mercury_current_binary_input;
extern MercuryFile *mercury_current_binary_output;

#define initial_io_state()		0	/* some random number */
#define update_io(r_src, r_dest)	((r_dest) = (r_src))
#define final_io_state(r)		((void)0)

void 		mercury_init_io(void);
MercuryFile*	mercury_open(const char *filename, const char *type);
int		mercury_output_error(MercuryFile* mf);
void		mercury_print_string(MercuryFile* mf, const char *s);
void		mercury_print_binary_string(MercuryFile* mf, const char *s);
int		mercury_getc(MercuryFile* mf);
void		mercury_close(MercuryFile* mf);

#line 71 "io.c"
#line 2649 "io.m"

#ifndef IO_HAVE_TEMPNAM
	#include <sys/stat.h>
	#include <unistd.h>
	extern int	ML_io_tempnam_counter;
	#define	MAX_TEMPNAME_TRIES	5
#endif

#line 81 "io.c"
#line 3 "array.opt"

MR_ArrayType *ML_make_array(Integer size, Word item);

#line 86 "io.c"
#line 4 "array.opt"

MR_ArrayType * ML_resize_array(MR_ArrayType *old_array,
					Integer array_size, Word item);

#line 92 "io.c"
#line 5 "array.opt"

MR_ArrayType * ML_shrink_array(MR_ArrayType *old_array,
					Integer array_size);

#line 98 "io.c"
#line 6 "array.opt"

MR_ArrayType *ML_copy_array(MR_ArrayType *old_array);

#line 103 "io.c"
#line 2 "benchmarking.opt"


#include <stdio.h>
#include "timing.h"


#line 111 "io.c"
#line 2 "char.opt"
#include <limits.h>
#line 114 "io.c"
#line 2 "int.opt"

	#include <limits.h>

#line 119 "io.c"
#line 2 "require.opt"
#include <stdio.h>
#line 122 "io.c"
#line 3 "std_util.opt"


#include "type_info.h"

int	ML_compare_type_info(Word type_info_1, Word type_info_2);


#line 131 "io.c"
#line 4 "std_util.opt"

/*
**	`univ' is represented as a two word structure.
**	One word contains the address of a type_info for the type.
**	The other word contains the data.
**	The offsets UNIV_OFFSET_FOR_TYPEINFO and UNIV_OFFSET_FOR_DATA 
**	are defined in runtime/type_info.h.
*/

#include "type_info.h"



#line 146 "io.c"
#line 5 "std_util.opt"


typedef struct ML_Construct_Info_Struct {
	int vector_type;
	int arity;
	Word *functors_vector;
	Word *argument_vector;
	Word primary_tag;
	Word secondary_tag;
	ConstString functor_name;
} ML_Construct_Info;

int	ML_get_num_functors(Word type_info); 
Word 	ML_copy_argument_typeinfos(int arity, Word type_info,
				Word *arg_vector);
bool 	ML_get_functors_check_range(int functor_number, Word type_info, 
				ML_Construct_Info *info);
void	ML_copy_arguments_from_list_to_vector(int arity, Word arg_list, 
				Word term_vector);
bool	ML_typecheck_arguments(Word type_info, int arity, 
				Word arg_list, Word* arg_vector);
Word 	ML_collapse_equivalences(Word maybe_equiv_type_info);
Word 	ML_make_type(int arity, Word *base_type_info, Word arg_type_list);


#line 173 "io.c"
#line 6 "std_util.opt"


Word ML_make_ctor_info(Word *type_info, Word *base_type_info);

	/*
	** Several predicates use these (the MR_BASE_TYPEINFO_IS_HO_*
	** macros need access to these addresses).
	*/
MR_DECLARE_STRUCT(mercury_data___base_type_info_pred_0);
MR_DECLARE_STRUCT(mercury_data___base_type_info_func_0);



#line 188 "io.c"
#line 7 "std_util.opt"


	#include <stdio.h>

	/* 
	 * Code for functor, arg and deconstruct
	 * 
	 * This relies on some C primitives that take a type_info
	 * and a data_word, and get a functor, arity, argument vector,
	 * and argument type_info vector.
	 */

	/* Type definitions */

	/* 
	 * The last two fields, need_functor, and need_args, must
	 * be set by the caller, to indicate whether ML_expand
	 * should copy the functor (if need_functor is non-zero) or
	 * the argument vector and type_info_vector (if need_args is
	 * non-zero). The arity will always be set.
	 *
	 * ML_expand will fill in the other fields (functor, arity,
	 * argument_vector, type_info_vector, and non_canonical_type)
	 * accordingly, but
	 * the values of fields not asked for should be assumed to
	 * contain random data when ML_expand returns.
	 * (that is, they should not be relied on to remain unchanged).
	 */


typedef struct ML_Expand_Info_Struct {
	ConstString functor;
	int arity;
	Word *argument_vector;
	Word *type_info_vector;
	bool non_canonical_type;
	bool need_functor;
	bool need_args;
} ML_Expand_Info;


	/* Prototypes */

void ML_expand(Word* type_info, Word *data_word_ptr, ML_Expand_Info *info);

Word * ML_create_type_info(Word *term_type_info, Word *arg_pseudo_type_info);

	/* NB. ML_arg() is also used by store__arg_ref in store.m */
bool ML_arg(Word term_type_info, Word *term, Word argument_index,
		Word *arg_type_info, Word **argument_ptr);


#line 242 "io.c"
#line 3 "string.opt"

#include <string.h>
#include <stdio.h>

#line 248 "io.c"

Declare_static(mercury____Index___io__error_0__ua10000_2_0);
Declare_static(mercury____Index___io__read_result_1__ua10000_2_0);
Declare_label(mercury____Index___io__read_result_1__ua10000_2_0_i4);
Declare_label(mercury____Index___io__read_result_1__ua10000_2_0_i5);
Declare_static(mercury____Index___io__result_1__ua10000_2_0);
Declare_label(mercury____Index___io__result_1__ua10000_2_0_i4);
Declare_label(mercury____Index___io__result_1__ua10000_2_0_i5);
Declare_static(mercury____Index___io__res_1__ua10000_2_0);
Declare_label(mercury____Index___io__res_1__ua10000_2_0_i3);
Declare_static(mercury____Index___io__state_0__ua10000_2_0);
Declare_static(mercury__io__ops__lookup_op__ua0_2_0);
Declare_label(mercury__io__ops__lookup_op__ua0_2_0_i1005);
Declare_label(mercury__io__ops__lookup_op__ua0_2_0_i3);
Declare_static(mercury__io__convert_read_result__ua10000_2_0);
Declare_label(mercury__io__convert_read_result__ua10000_2_0_i4);
Declare_label(mercury__io__convert_read_result__ua10000_2_0_i5);
Declare_static(mercury__io__write_c_pointer__ua10000_3_0);
Declare_static(mercury__io__set_op_table__ua10000_3_0);
Declare_static(mercury__io__write_list__ua10000_6_0);
Declare_label(mercury__io__write_list__ua10000_6_0_i2);
Declare_static(mercury__io__write_list__ua10000_5_0);
Declare_label(mercury__io__write_list__ua10000_5_0_i1002);
Declare_label(mercury__io__write_list__ua10000_5_0_i4);
Declare_label(mercury__io__write_list__ua10000_5_0_i6);
Declare_label(mercury__io__write_list__ua10000_5_0_i3);
Define_extern_entry(mercury__io__read_char_3_0);
Define_extern_entry(mercury__io__read_word_3_0);
Define_extern_entry(mercury__io__read_line_3_0);
Define_extern_entry(mercury__io__read_file_3_0);
Define_extern_entry(mercury__io__putback_char_3_0);
Define_extern_entry(mercury__io__read_char_4_0);
Declare_label(mercury__io__read_char_4_0_i2);
Declare_label(mercury__io__read_char_4_0_i5);
Define_extern_entry(mercury__io__read_word_4_0);
Declare_label(mercury__io__read_word_4_0_i2);
Declare_label(mercury__io__read_word_4_0_i6);
Declare_label(mercury__io__read_word_4_0_i5);
Define_extern_entry(mercury__io__read_line_4_0);
Declare_label(mercury__io__read_line_4_0_i2);
Declare_label(mercury__io__read_line_4_0_i5);
Declare_label(mercury__io__read_line_4_0_i7);
Declare_label(mercury__io__read_line_4_0_i10);
Declare_label(mercury__io__read_line_4_0_i13);
Declare_label(mercury__io__read_line_4_0_i3);
Define_extern_entry(mercury__io__read_file_4_0);
Define_extern_entry(mercury__io__putback_char_4_0);
Define_extern_entry(mercury__io__read_3_0);
Declare_label(mercury__io__read_3_0_i2);
Declare_label(mercury__io__read_3_0_i5);
Declare_label(mercury__io__read_3_0_i6);
Declare_label(mercury__io__read_3_0_i9);
Declare_label(mercury__io__read_3_0_i8);
Declare_label(mercury__io__read_3_0_i16);
Declare_label(mercury__io__read_3_0_i13);
Declare_label(mercury__io__read_3_0_i12);
Define_extern_entry(mercury__io__read_4_0);
Declare_label(mercury__io__read_4_0_i2);
Define_extern_entry(mercury__io__ignore_whitespace_3_0);
Define_extern_entry(mercury__io__ignore_whitespace_4_0);
Declare_label(mercury__io__ignore_whitespace_4_0_i1003);
Declare_label(mercury__io__ignore_whitespace_4_0_i2);
Declare_label(mercury__io__ignore_whitespace_4_0_i5);
Declare_label(mercury__io__ignore_whitespace_4_0_i9);
Declare_label(mercury__io__ignore_whitespace_4_0_i8);
Declare_label(mercury__io__ignore_whitespace_4_0_i6);
Define_extern_entry(mercury__io__print_3_0);
Declare_label(mercury__io__print_3_0_i2);
Declare_label(mercury__io__print_3_0_i5);
Declare_label(mercury__io__print_3_0_i8);
Define_extern_entry(mercury__io__print_4_0);
Declare_label(mercury__io__print_4_0_i2);
Define_extern_entry(mercury__io__write_3_0);
Define_extern_entry(mercury__io__write_4_0);
Declare_label(mercury__io__write_4_0_i2);
Define_extern_entry(mercury__io__nl_2_0);
Define_extern_entry(mercury__io__nl_3_0);
Define_extern_entry(mercury__io__write_string_3_0);
Define_extern_entry(mercury__io__write_string_4_0);
Define_extern_entry(mercury__io__write_strings_3_0);
Define_extern_entry(mercury__io__write_strings_4_0);
Declare_label(mercury__io__write_strings_4_0_i1001);
Declare_label(mercury__io__write_strings_4_0_i3);
Define_extern_entry(mercury__io__write_char_3_0);
Define_extern_entry(mercury__io__write_char_4_0);
Define_extern_entry(mercury__io__write_int_3_0);
Define_extern_entry(mercury__io__write_int_4_0);
Define_extern_entry(mercury__io__write_float_3_0);
Define_extern_entry(mercury__io__write_float_4_0);
Define_extern_entry(mercury__io__format_4_0);
Declare_label(mercury__io__format_4_0_i2);
Define_extern_entry(mercury__io__format_5_0);
Declare_label(mercury__io__format_5_0_i2);
Define_extern_entry(mercury__io__write_many_3_0);
Define_extern_entry(mercury__io__write_many_4_0);
Declare_label(mercury__io__write_many_4_0_i1004);
Declare_label(mercury__io__write_many_4_0_i10);
Declare_label(mercury__io__write_many_4_0_i8);
Declare_label(mercury__io__write_many_4_0_i6);
Declare_label(mercury__io__write_many_4_0_i3);
Define_extern_entry(mercury__io__write_list_5_0);
Define_extern_entry(mercury__io__write_list_6_0);
Define_extern_entry(mercury__io__flush_output_2_0);
Define_extern_entry(mercury__io__flush_output_3_0);
Define_extern_entry(mercury__io__see_4_0);
Declare_label(mercury__io__see_4_0_i2);
Declare_label(mercury__io__see_4_0_i4);
Define_extern_entry(mercury__io__seen_2_0);
Define_extern_entry(mercury__io__open_input_4_0);
Declare_label(mercury__io__open_input_4_0_i7);
Declare_label(mercury__io__open_input_4_0_i2);
Define_extern_entry(mercury__io__close_input_3_0);
Define_extern_entry(mercury__io__input_stream_3_0);
Define_extern_entry(mercury__io__set_input_stream_4_0);
Define_extern_entry(mercury__io__stdin_stream_3_0);
Define_extern_entry(mercury__io__input_stream_name_3_0);
Define_extern_entry(mercury__io__input_stream_name_4_0);
Define_extern_entry(mercury__io__get_line_number_3_0);
Define_extern_entry(mercury__io__get_line_number_4_0);
Define_extern_entry(mercury__io__set_line_number_3_0);
Define_extern_entry(mercury__io__set_line_number_4_0);
Define_extern_entry(mercury__io__tell_4_0);
Declare_label(mercury__io__tell_4_0_i2);
Declare_label(mercury__io__tell_4_0_i3);
Define_extern_entry(mercury__io__told_2_0);
Define_extern_entry(mercury__io__open_output_4_0);
Declare_label(mercury__io__open_output_4_0_i7);
Declare_label(mercury__io__open_output_4_0_i2);
Define_extern_entry(mercury__io__open_append_4_0);
Declare_label(mercury__io__open_append_4_0_i7);
Declare_label(mercury__io__open_append_4_0_i2);
Define_extern_entry(mercury__io__close_output_3_0);
Define_extern_entry(mercury__io__output_stream_3_0);
Define_extern_entry(mercury__io__set_output_stream_4_0);
Define_extern_entry(mercury__io__stdout_stream_3_0);
Define_extern_entry(mercury__io__stderr_stream_3_0);
Define_extern_entry(mercury__io__output_stream_name_3_0);
Define_extern_entry(mercury__io__output_stream_name_4_0);
Define_extern_entry(mercury__io__get_output_line_number_3_0);
Define_extern_entry(mercury__io__get_output_line_number_4_0);
Define_extern_entry(mercury__io__set_output_line_number_3_0);
Define_extern_entry(mercury__io__set_output_line_number_4_0);
Define_extern_entry(mercury__io__read_binary_3_0);
Declare_label(mercury__io__read_binary_3_0_i2);
Declare_label(mercury__io__read_binary_3_0_i5);
Declare_label(mercury__io__read_binary_3_0_i6);
Define_extern_entry(mercury__io__read_binary_4_0);
Declare_label(mercury__io__read_binary_4_0_i2);
Define_extern_entry(mercury__io__read_byte_3_0);
Define_extern_entry(mercury__io__read_byte_4_0);
Declare_label(mercury__io__read_byte_4_0_i2);
Declare_label(mercury__io__read_byte_4_0_i5);
Define_extern_entry(mercury__io__read_binary_file_3_0);
Define_extern_entry(mercury__io__read_binary_file_4_0);
Define_extern_entry(mercury__io__putback_byte_3_0);
Define_extern_entry(mercury__io__putback_byte_4_0);
Define_extern_entry(mercury__io__write_binary_3_0);
Declare_label(mercury__io__write_binary_3_0_i2);
Define_extern_entry(mercury__io__write_binary_4_0);
Declare_label(mercury__io__write_binary_4_0_i2);
Define_extern_entry(mercury__io__write_byte_3_0);
Define_extern_entry(mercury__io__write_byte_4_0);
Define_extern_entry(mercury__io__write_bytes_3_0);
Define_extern_entry(mercury__io__write_bytes_4_0);
Define_extern_entry(mercury__io__flush_binary_output_2_0);
Define_extern_entry(mercury__io__flush_binary_output_3_0);
Define_extern_entry(mercury__io__seek_binary_5_0);
Declare_label(mercury__io__seek_binary_5_0_i3);
Declare_label(mercury__io__seek_binary_5_0_i4);
Declare_label(mercury__io__seek_binary_5_0_i2);
Define_extern_entry(mercury__io__binary_stream_offset_4_0);
Define_extern_entry(mercury__io__see_binary_4_0);
Declare_label(mercury__io__see_binary_4_0_i2);
Declare_label(mercury__io__see_binary_4_0_i4);
Define_extern_entry(mercury__io__seen_binary_2_0);
Define_extern_entry(mercury__io__open_binary_input_4_0);
Declare_label(mercury__io__open_binary_input_4_0_i7);
Declare_label(mercury__io__open_binary_input_4_0_i2);
Define_extern_entry(mercury__io__close_binary_input_3_0);
Define_extern_entry(mercury__io__binary_input_stream_3_0);
Define_extern_entry(mercury__io__set_binary_input_stream_4_0);
Define_extern_entry(mercury__io__stdin_binary_stream_3_0);
Define_extern_entry(mercury__io__binary_input_stream_name_3_0);
Define_extern_entry(mercury__io__binary_input_stream_name_4_0);
Define_extern_entry(mercury__io__tell_binary_4_0);
Declare_label(mercury__io__tell_binary_4_0_i2);
Declare_label(mercury__io__tell_binary_4_0_i3);
Define_extern_entry(mercury__io__told_binary_2_0);
Define_extern_entry(mercury__io__open_binary_output_4_0);
Declare_label(mercury__io__open_binary_output_4_0_i7);
Declare_label(mercury__io__open_binary_output_4_0_i2);
Define_extern_entry(mercury__io__open_binary_append_4_0);
Declare_label(mercury__io__open_binary_append_4_0_i7);
Declare_label(mercury__io__open_binary_append_4_0_i2);
Define_extern_entry(mercury__io__close_binary_output_3_0);
Define_extern_entry(mercury__io__binary_output_stream_3_0);
Define_extern_entry(mercury__io__stdout_binary_stream_3_0);
Define_extern_entry(mercury__io__set_binary_output_stream_4_0);
Define_extern_entry(mercury__io__binary_output_stream_name_3_0);
Define_extern_entry(mercury__io__binary_output_stream_name_4_0);
Define_extern_entry(mercury__io__progname_4_0);
Define_extern_entry(mercury__io__progname_base_4_0);
Declare_label(mercury__io__progname_base_4_0_i2);
Define_extern_entry(mercury__io__command_line_arguments_3_0);
Define_extern_entry(mercury__io__get_exit_status_3_0);
Define_extern_entry(mercury__io__set_exit_status_3_0);
Define_extern_entry(mercury__io__get_globals_3_0);
Define_extern_entry(mercury__io__set_globals_3_0);
Define_extern_entry(mercury__io__get_environment_var_4_0);
Declare_label(mercury__io__get_environment_var_4_0_i2);
Define_extern_entry(mercury__io__set_environment_var_4_0);
Declare_label(mercury__io__set_environment_var_4_0_i2);
Declare_label(mercury__io__set_environment_var_4_0_i3);
Declare_label(mercury__io__set_environment_var_4_0_i6);
Define_extern_entry(mercury__io__tmpnam_3_0);
Declare_label(mercury__io__tmpnam_3_0_i4);
Declare_label(mercury__io__tmpnam_3_0_i3);
Define_extern_entry(mercury__io__tmpnam_5_0);
Define_extern_entry(mercury__io__remove_file_4_0);
Declare_label(mercury__io__remove_file_4_0_i2);
Define_extern_entry(mercury__io__report_stats_2_0);
Define_extern_entry(mercury__io__preallocate_heap_space_3_0);
Define_extern_entry(mercury__io__call_system_4_0);
Declare_label(mercury__io__call_system_4_0_i2);
Declare_label(mercury__io__call_system_4_0_i7);
Declare_label(mercury__io__call_system_4_0_i5);
Define_extern_entry(mercury__io__error_message_2_0);
Define_extern_entry(mercury__io__read_anything_3_0);
Define_extern_entry(mercury__io__read_anything_4_0);
Declare_label(mercury__io__read_anything_4_0_i2);
Define_extern_entry(mercury__io__write_anything_3_0);
Define_extern_entry(mercury__io__write_anything_4_0);
Declare_label(mercury__io__write_anything_4_0_i2);
Define_extern_entry(mercury__io__get_op_table_3_0);
Define_extern_entry(mercury__io__set_op_table_3_0);
Declare_static(mercury__io__read_char_code_4_0);
Declare_static(mercury__io__call_system_code_4_0);
Declare_static(mercury__io__do_open_6_0);
Declare_static(mercury__io__getenv_2_0);
Declare_label(mercury__io__getenv_2_0_i1);
Declare_static(mercury__io__putenv_1_0);
Declare_label(mercury__io__putenv_1_0_i1);
Declare_static(mercury__io__read_word_2_4_0);
Declare_label(mercury__io__read_word_2_4_0_i2);
Declare_label(mercury__io__read_word_2_4_0_i5);
Declare_label(mercury__io__read_word_2_4_0_i9);
Declare_label(mercury__io__read_word_2_4_0_i8);
Declare_label(mercury__io__read_word_2_4_0_i11);
Declare_label(mercury__io__read_word_2_4_0_i14);
Declare_label(mercury__io__read_word_2_4_0_i3);
Define_extern_entry(mercury__io__read_file_2_5_0);
Declare_label(mercury__io__read_file_2_5_0_i1002);
Declare_label(mercury__io__read_file_2_5_0_i2);
Declare_label(mercury__io__read_file_2_5_0_i6);
Declare_label(mercury__io__read_file_2_5_0_i5);
Declare_label(mercury__io__read_file_2_5_0_i3);
Define_extern_entry(mercury__io__read_binary_file_2_5_0);
Declare_label(mercury__io__read_binary_file_2_5_0_i1002);
Declare_label(mercury__io__read_binary_file_2_5_0_i2);
Declare_label(mercury__io__read_binary_file_2_5_0_i6);
Declare_label(mercury__io__read_binary_file_2_5_0_i5);
Declare_label(mercury__io__read_binary_file_2_5_0_i3);
Define_extern_entry(mercury__io__write_univ_3_0);
Declare_static(mercury__io__write_univ_4_0);
Declare_label(mercury__io__write_univ_4_0_i4);
Declare_label(mercury__io__write_univ_4_0_i3);
Declare_label(mercury__io__write_univ_4_0_i8);
Declare_label(mercury__io__write_univ_4_0_i7);
Declare_label(mercury__io__write_univ_4_0_i12);
Declare_label(mercury__io__write_univ_4_0_i11);
Declare_label(mercury__io__write_univ_4_0_i15);
Declare_label(mercury__io__write_univ_4_0_i14);
Declare_label(mercury__io__write_univ_4_0_i18);
Declare_label(mercury__io__write_univ_4_0_i19);
Declare_label(mercury__io__write_univ_4_0_i17);
Declare_label(mercury__io__write_univ_4_0_i23);
Declare_label(mercury__io__write_univ_4_0_i22);
Declare_label(mercury__io__write_univ_4_0_i28);
Declare_label(mercury__io__write_univ_4_0_i27);
Declare_label(mercury__io__write_univ_4_0_i33);
Declare_label(mercury__io__write_univ_4_0_i34);
Declare_label(mercury__io__write_univ_4_0_i36);
Declare_label(mercury__io__write_univ_4_0_i38);
Declare_label(mercury__io__write_univ_4_0_i39);
Declare_label(mercury__io__write_univ_4_0_i32);
Declare_static(mercury__io__write_univ_as_univ_3_0);
Declare_label(mercury__io__write_univ_as_univ_3_0_i2);
Declare_label(mercury__io__write_univ_as_univ_3_0_i3);
Declare_static(mercury__io__write_ordinary_term_4_0);
Declare_label(mercury__io__write_ordinary_term_4_0_i2);
Declare_label(mercury__io__write_ordinary_term_4_0_i3);
Declare_label(mercury__io__write_ordinary_term_4_0_i10);
Declare_label(mercury__io__write_ordinary_term_4_0_i11);
Declare_label(mercury__io__write_ordinary_term_4_0_i12);
Declare_label(mercury__io__write_ordinary_term_4_0_i4);
Declare_label(mercury__io__write_ordinary_term_4_0_i14);
Declare_label(mercury__io__write_ordinary_term_4_0_i24);
Declare_label(mercury__io__write_ordinary_term_4_0_i25);
Declare_label(mercury__io__write_ordinary_term_4_0_i19);
Declare_label(mercury__io__write_ordinary_term_4_0_i31);
Declare_label(mercury__io__write_ordinary_term_4_0_i33);
Declare_label(mercury__io__write_ordinary_term_4_0_i34);
Declare_label(mercury__io__write_ordinary_term_4_0_i35);
Declare_label(mercury__io__write_ordinary_term_4_0_i36);
Declare_label(mercury__io__write_ordinary_term_4_0_i37);
Declare_label(mercury__io__write_ordinary_term_4_0_i28);
Declare_label(mercury__io__write_ordinary_term_4_0_i27);
Declare_label(mercury__io__write_ordinary_term_4_0_i43);
Declare_label(mercury__io__write_ordinary_term_4_0_i45);
Declare_label(mercury__io__write_ordinary_term_4_0_i46);
Declare_label(mercury__io__write_ordinary_term_4_0_i47);
Declare_label(mercury__io__write_ordinary_term_4_0_i48);
Declare_label(mercury__io__write_ordinary_term_4_0_i49);
Declare_label(mercury__io__write_ordinary_term_4_0_i40);
Declare_label(mercury__io__write_ordinary_term_4_0_i39);
Declare_label(mercury__io__write_ordinary_term_4_0_i56);
Declare_label(mercury__io__write_ordinary_term_4_0_i58);
Declare_label(mercury__io__write_ordinary_term_4_0_i59);
Declare_label(mercury__io__write_ordinary_term_4_0_i60);
Declare_label(mercury__io__write_ordinary_term_4_0_i64);
Declare_label(mercury__io__write_ordinary_term_4_0_i61);
Declare_label(mercury__io__write_ordinary_term_4_0_i65);
Declare_label(mercury__io__write_ordinary_term_4_0_i66);
Declare_label(mercury__io__write_ordinary_term_4_0_i67);
Declare_label(mercury__io__write_ordinary_term_4_0_i68);
Declare_label(mercury__io__write_ordinary_term_4_0_i69);
Declare_label(mercury__io__write_ordinary_term_4_0_i70);
Declare_label(mercury__io__write_ordinary_term_4_0_i52);
Declare_label(mercury__io__write_ordinary_term_4_0_i51);
Declare_label(mercury__io__write_ordinary_term_4_0_i77);
Declare_label(mercury__io__write_ordinary_term_4_0_i79);
Declare_label(mercury__io__write_ordinary_term_4_0_i80);
Declare_label(mercury__io__write_ordinary_term_4_0_i81);
Declare_label(mercury__io__write_ordinary_term_4_0_i82);
Declare_label(mercury__io__write_ordinary_term_4_0_i83);
Declare_label(mercury__io__write_ordinary_term_4_0_i84);
Declare_label(mercury__io__write_ordinary_term_4_0_i85);
Declare_label(mercury__io__write_ordinary_term_4_0_i73);
Declare_label(mercury__io__write_ordinary_term_4_0_i72);
Declare_label(mercury__io__write_ordinary_term_4_0_i91);
Declare_label(mercury__io__write_ordinary_term_4_0_i93);
Declare_label(mercury__io__write_ordinary_term_4_0_i94);
Declare_label(mercury__io__write_ordinary_term_4_0_i95);
Declare_label(mercury__io__write_ordinary_term_4_0_i96);
Declare_label(mercury__io__write_ordinary_term_4_0_i89);
Declare_label(mercury__io__write_ordinary_term_4_0_i88);
Declare_label(mercury__io__write_ordinary_term_4_0_i97);
Declare_label(mercury__io__write_ordinary_term_4_0_i98);
Declare_label(mercury__io__write_ordinary_term_4_0_i102);
Declare_label(mercury__io__write_ordinary_term_4_0_i103);
Declare_label(mercury__io__write_ordinary_term_4_0_i104);
Declare_label(mercury__io__write_ordinary_term_4_0_i99);
Declare_static(mercury__io__maybe_write_char_5_0);
Declare_label(mercury__io__maybe_write_char_5_0_i2);
Declare_static(mercury__io__adjust_priority_3_0);
Declare_label(mercury__io__adjust_priority_3_0_i2);
Declare_static(mercury__io__write_list_tail_3_0);
Declare_label(mercury__io__write_list_tail_3_0_i1006);
Declare_label(mercury__io__write_list_tail_3_0_i4);
Declare_label(mercury__io__write_list_tail_3_0_i7);
Declare_label(mercury__io__write_list_tail_3_0_i9);
Declare_label(mercury__io__write_list_tail_3_0_i3);
Declare_label(mercury__io__write_list_tail_3_0_i13);
Declare_label(mercury__io__write_list_tail_3_0_i14);
Declare_label(mercury__io__write_list_tail_3_0_i12);
Declare_static(mercury__io__write_term_args_3_0);
Declare_label(mercury__io__write_term_args_3_0_i1001);
Declare_label(mercury__io__write_term_args_3_0_i4);
Declare_label(mercury__io__write_term_args_3_0_i3);
Define_extern_entry(mercury__io__convert_read_result_2_0);
Define_extern_entry(mercury__io__stream_name_4_0);
Declare_label(mercury__io__stream_name_4_0_i4);
Declare_label(mercury__io__stream_name_4_0_i3);
Declare_label(mercury__io__stream_name_4_0_i6);
Declare_static(mercury__io__get_stream_names_3_0);
Declare_static(mercury__io__set_stream_names_3_0);
Declare_static(mercury__io__init_state_2_0);
Declare_label(mercury__io__init_state_2_0_i2);
Declare_static(mercury__io__finalize_state_2_0);
Declare_static(mercury__io__gc_init_2_0);
Declare_static(mercury__io__insert_std_stream_names_2_0);
Declare_label(mercury__io__insert_std_stream_names_2_0_i2);
Declare_label(mercury__io__insert_std_stream_names_2_0_i3);
Declare_label(mercury__io__insert_std_stream_names_2_0_i4);
Define_extern_entry(mercury__io__whence_to_int_2_0);
Declare_label(mercury__io__whence_to_int_2_0_i3);
Declare_label(mercury__io__whence_to_int_2_0_i4);
Define_extern_entry(mercury__io__seek_binary_2_5_0);
Declare_static(mercury__io__tmpnam_2_3_0);
Declare_static(mercury__io__remove_file_2_5_0);
Define_extern_entry(mercury____Unify___io__state_0_0);
Define_extern_entry(mercury____Index___io__state_0_0);
Define_extern_entry(mercury____Compare___io__state_0_0);
Define_extern_entry(mercury____Unify___io__input_stream_0_0);
Define_extern_entry(mercury____Index___io__input_stream_0_0);
Define_extern_entry(mercury____Compare___io__input_stream_0_0);
Define_extern_entry(mercury____Unify___io__output_stream_0_0);
Define_extern_entry(mercury____Index___io__output_stream_0_0);
Define_extern_entry(mercury____Compare___io__output_stream_0_0);
Define_extern_entry(mercury____Unify___io__binary_input_stream_0_0);
Define_extern_entry(mercury____Index___io__binary_input_stream_0_0);
Define_extern_entry(mercury____Compare___io__binary_input_stream_0_0);
Define_extern_entry(mercury____Unify___io__binary_output_stream_0_0);
Define_extern_entry(mercury____Index___io__binary_output_stream_0_0);
Define_extern_entry(mercury____Compare___io__binary_output_stream_0_0);
Define_extern_entry(mercury____Unify___io__binary_stream_0_0);
Define_extern_entry(mercury____Index___io__binary_stream_0_0);
Define_extern_entry(mercury____Compare___io__binary_stream_0_0);
Define_extern_entry(mercury____Unify___io__res_0_0);
Declare_label(mercury____Unify___io__res_0_0_i3);
Declare_label(mercury____Unify___io__res_0_0_i1);
Define_extern_entry(mercury____Index___io__res_0_0);
Declare_label(mercury____Index___io__res_0_0_i3);
Define_extern_entry(mercury____Compare___io__res_0_0);
Declare_label(mercury____Compare___io__res_0_0_i3);
Declare_label(mercury____Compare___io__res_0_0_i2);
Declare_label(mercury____Compare___io__res_0_0_i5);
Declare_label(mercury____Compare___io__res_0_0_i4);
Declare_label(mercury____Compare___io__res_0_0_i6);
Declare_label(mercury____Compare___io__res_0_0_i8);
Declare_label(mercury____Compare___io__res_0_0_i13);
Declare_label(mercury____Compare___io__res_0_0_i10);
Define_extern_entry(mercury____Unify___io__res_1_0);
Declare_label(mercury____Unify___io__res_1_0_i3);
Declare_label(mercury____Unify___io__res_1_0_i1);
Define_extern_entry(mercury____Index___io__res_1_0);
Define_extern_entry(mercury____Compare___io__res_1_0);
Declare_label(mercury____Compare___io__res_1_0_i3);
Declare_label(mercury____Compare___io__res_1_0_i2);
Declare_label(mercury____Compare___io__res_1_0_i5);
Declare_label(mercury____Compare___io__res_1_0_i4);
Declare_label(mercury____Compare___io__res_1_0_i6);
Declare_label(mercury____Compare___io__res_1_0_i8);
Declare_label(mercury____Compare___io__res_1_0_i13);
Declare_label(mercury____Compare___io__res_1_0_i10);
Define_extern_entry(mercury____Unify___io__result_0_0);
Declare_label(mercury____Unify___io__result_0_0_i5);
Declare_label(mercury____Unify___io__result_0_0_i4);
Declare_label(mercury____Unify___io__result_0_0_i1);
Define_extern_entry(mercury____Index___io__result_0_0);
Declare_label(mercury____Index___io__result_0_0_i5);
Declare_label(mercury____Index___io__result_0_0_i4);
Define_extern_entry(mercury____Compare___io__result_0_0);
Declare_label(mercury____Compare___io__result_0_0_i5);
Declare_label(mercury____Compare___io__result_0_0_i4);
Declare_label(mercury____Compare___io__result_0_0_i2);
Declare_label(mercury____Compare___io__result_0_0_i9);
Declare_label(mercury____Compare___io__result_0_0_i8);
Declare_label(mercury____Compare___io__result_0_0_i6);
Declare_label(mercury____Compare___io__result_0_0_i10);
Declare_label(mercury____Compare___io__result_0_0_i12);
Declare_label(mercury____Compare___io__result_0_0_i19);
Declare_label(mercury____Compare___io__result_0_0_i18);
Declare_label(mercury____Compare___io__result_0_0_i14);
Define_extern_entry(mercury____Unify___io__result_1_0);
Declare_label(mercury____Unify___io__result_1_0_i4);
Declare_label(mercury____Unify___io__result_1_0_i6);
Declare_label(mercury____Unify___io__result_1_0_i1);
Define_extern_entry(mercury____Index___io__result_1_0);
Define_extern_entry(mercury____Compare___io__result_1_0);
Declare_label(mercury____Compare___io__result_1_0_i4);
Declare_label(mercury____Compare___io__result_1_0_i5);
Declare_label(mercury____Compare___io__result_1_0_i2);
Declare_label(mercury____Compare___io__result_1_0_i8);
Declare_label(mercury____Compare___io__result_1_0_i9);
Declare_label(mercury____Compare___io__result_1_0_i6);
Declare_label(mercury____Compare___io__result_1_0_i10);
Declare_label(mercury____Compare___io__result_1_0_i12);
Declare_label(mercury____Compare___io__result_1_0_i18);
Declare_label(mercury____Compare___io__result_1_0_i20);
Declare_label(mercury____Compare___io__result_1_0_i14);
Define_extern_entry(mercury____Unify___io__read_result_1_0);
Declare_label(mercury____Unify___io__read_result_1_0_i4);
Declare_label(mercury____Unify___io__read_result_1_0_i6);
Declare_label(mercury____Unify___io__read_result_1_0_i1);
Define_extern_entry(mercury____Index___io__read_result_1_0);
Define_extern_entry(mercury____Compare___io__read_result_1_0);
Declare_label(mercury____Compare___io__read_result_1_0_i4);
Declare_label(mercury____Compare___io__read_result_1_0_i5);
Declare_label(mercury____Compare___io__read_result_1_0_i2);
Declare_label(mercury____Compare___io__read_result_1_0_i8);
Declare_label(mercury____Compare___io__read_result_1_0_i9);
Declare_label(mercury____Compare___io__read_result_1_0_i6);
Declare_label(mercury____Compare___io__read_result_1_0_i10);
Declare_label(mercury____Compare___io__read_result_1_0_i12);
Declare_label(mercury____Compare___io__read_result_1_0_i18);
Declare_label(mercury____Compare___io__read_result_1_0_i20);
Declare_label(mercury____Compare___io__read_result_1_0_i26);
Declare_label(mercury____Compare___io__read_result_1_0_i14);
Declare_label(mercury____Compare___io__read_result_1_0_i34);
Define_extern_entry(mercury____Unify___io__error_0_0);
Declare_label(mercury____Unify___io__error_0_0_i1);
Define_extern_entry(mercury____Index___io__error_0_0);
Define_extern_entry(mercury____Compare___io__error_0_0);
Define_extern_entry(mercury____Unify___io__poly_type_0_0);
Define_extern_entry(mercury____Index___io__poly_type_0_0);
Define_extern_entry(mercury____Compare___io__poly_type_0_0);
Define_extern_entry(mercury____Unify___io__whence_0_0);
Declare_label(mercury____Unify___io__whence_0_0_i1);
Define_extern_entry(mercury____Index___io__whence_0_0);
Define_extern_entry(mercury____Compare___io__whence_0_0);
Declare_static(mercury____Unify___io__stream_names_0_0);
Declare_static(mercury____Index___io__stream_names_0_0);
Declare_static(mercury____Compare___io__stream_names_0_0);
Declare_static(mercury____Unify___io__stream_putback_0_0);
Declare_static(mercury____Index___io__stream_putback_0_0);
Declare_static(mercury____Compare___io__stream_putback_0_0);
Declare_static(mercury____Unify___io__stream_0_0);
Declare_static(mercury____Index___io__stream_0_0);
Declare_static(mercury____Compare___io__stream_0_0);
#line 2658 "io.m"

#ifndef IO_HAVE_TEMPNAM
	int	ML_io_tempnam_counter = 0;
#endif

#line 765 "io.c"
#line 2139 "io.m"


void
mercury_close(MercuryFile* mf)
{
	if (mf != &mercury_stdin &&
	    mf != &mercury_stdout &&
	    mf != &mercury_stderr)
	{
		if (fclose(mf->file) < 0) {
			fprintf(stderr,
				"Mercury runtime: error closing file: %s\n",
				strerror(errno));
			exit(1);
		}
		oldmem(mf);
	}
}


#line 787 "io.c"
#line 2125 "io.m"


int
mercury_getc(MercuryFile* mf)
{
	int c = getc(mf->file);
	if (c == '\n') {
		mf->line_number++;
	}
	return c;
}


#line 802 "io.c"
#line 2113 "io.m"


void
mercury_print_binary_string(MercuryFile* mf, const char *s)
{
	if (fprintf(mf->file, "%s", s) < 0) {
		mercury_output_error(mf);
	}
}


#line 815 "io.c"
#line 2096 "io.m"


void
mercury_print_string(MercuryFile* mf, const char *s)
{
	if (fprintf(mf->file, "%s", s) < 0) {
		mercury_output_error(mf);
	}
	while (*s) {
		if (*s++ == '\n') {
			mf->line_number++;
		}
	}
}


#line 833 "io.c"
#line 2083 "io.m"


int
mercury_output_error(MercuryFile* mf)
{
	fprintf(stderr,
		"Mercury runtime: error writing to output file: %s\n",
		strerror(errno));
	exit(1);
}


#line 847 "io.c"
#line 2065 "io.m"


MercuryFile*
mercury_open(const char *filename, const char *type)
{
	MercuryFile *mf;
	FILE *f;
	
	f = fopen(filename, type);
	if (!f) return NULL;
	mf = make(MercuryFile);
	mf->file = f;
	mf->line_number = 1;
	return mf;
}


#line 866 "io.c"
#line 2045 "io.m"


MercuryFile mercury_stdin = { NULL, 1 };
MercuryFile mercury_stdout = { NULL, 1 };
MercuryFile mercury_stderr = { NULL, 1 };
MercuryFile *mercury_current_text_input = &mercury_stdin;
MercuryFile *mercury_current_text_output = &mercury_stdout;
MercuryFile *mercury_current_binary_input = &mercury_stdin;
MercuryFile *mercury_current_binary_output = &mercury_stdout;

void
mercury_init_io(void)
{
	mercury_stdin.file = stdin;
	mercury_stdout.file = stdout;
	mercury_stderr.file = stderr;
}


#line 887 "io.c"
#line 954 "io.m"

	Word ML_io_stream_names;
	Word ML_io_user_globals;
	#if 0
	  extern Word ML_io_ops_table;
	#endif

#line 896 "io.c"

extern const struct mercury_data_io__base_type_layout_binary_input_stream_0_struct
	mercury_data_io__base_type_layout_binary_input_stream_0;
extern const struct mercury_data_io__base_type_functors_binary_input_stream_0_struct
	mercury_data_io__base_type_functors_binary_input_stream_0;
const struct mercury_data_io__base_type_info_binary_input_stream_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_binary_input_stream_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__binary_input_stream_0_0),
	ENTRY(mercury____Index___io__binary_input_stream_0_0),
	ENTRY(mercury____Compare___io__binary_input_stream_0_0),
	(const Word *) &mercury_data_io__base_type_layout_binary_input_stream_0,
	(const Word *) &mercury_data_io__base_type_functors_binary_input_stream_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("binary_input_stream", 19)
};

extern const struct mercury_data_io__base_type_layout_binary_output_stream_0_struct
	mercury_data_io__base_type_layout_binary_output_stream_0;
extern const struct mercury_data_io__base_type_functors_binary_output_stream_0_struct
	mercury_data_io__base_type_functors_binary_output_stream_0;
const struct mercury_data_io__base_type_info_binary_output_stream_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_binary_output_stream_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__binary_output_stream_0_0),
	ENTRY(mercury____Index___io__binary_output_stream_0_0),
	ENTRY(mercury____Compare___io__binary_output_stream_0_0),
	(const Word *) &mercury_data_io__base_type_layout_binary_output_stream_0,
	(const Word *) &mercury_data_io__base_type_functors_binary_output_stream_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("binary_output_stream", 20)
};

extern const struct mercury_data_io__base_type_layout_binary_stream_0_struct
	mercury_data_io__base_type_layout_binary_stream_0;
extern const struct mercury_data_io__base_type_functors_binary_stream_0_struct
	mercury_data_io__base_type_functors_binary_stream_0;
const struct mercury_data_io__base_type_info_binary_stream_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_binary_stream_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__binary_stream_0_0),
	ENTRY(mercury____Index___io__binary_stream_0_0),
	ENTRY(mercury____Compare___io__binary_stream_0_0),
	(const Word *) &mercury_data_io__base_type_layout_binary_stream_0,
	(const Word *) &mercury_data_io__base_type_functors_binary_stream_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("binary_stream", 13)
};

extern const struct mercury_data_io__base_type_layout_error_0_struct
	mercury_data_io__base_type_layout_error_0;
extern const struct mercury_data_io__base_type_functors_error_0_struct
	mercury_data_io__base_type_functors_error_0;
const struct mercury_data_io__base_type_info_error_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_error_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__error_0_0),
	ENTRY(mercury____Index___io__error_0_0),
	ENTRY(mercury____Compare___io__error_0_0),
	(const Word *) &mercury_data_io__base_type_layout_error_0,
	(const Word *) &mercury_data_io__base_type_functors_error_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("error", 5)
};

extern const struct mercury_data_io__base_type_layout_input_stream_0_struct
	mercury_data_io__base_type_layout_input_stream_0;
extern const struct mercury_data_io__base_type_functors_input_stream_0_struct
	mercury_data_io__base_type_functors_input_stream_0;
const struct mercury_data_io__base_type_info_input_stream_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_input_stream_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__input_stream_0_0),
	ENTRY(mercury____Index___io__input_stream_0_0),
	ENTRY(mercury____Compare___io__input_stream_0_0),
	(const Word *) &mercury_data_io__base_type_layout_input_stream_0,
	(const Word *) &mercury_data_io__base_type_functors_input_stream_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("input_stream", 12)
};

extern const struct mercury_data_io__base_type_layout_output_stream_0_struct
	mercury_data_io__base_type_layout_output_stream_0;
extern const struct mercury_data_io__base_type_functors_output_stream_0_struct
	mercury_data_io__base_type_functors_output_stream_0;
const struct mercury_data_io__base_type_info_output_stream_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_output_stream_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__output_stream_0_0),
	ENTRY(mercury____Index___io__output_stream_0_0),
	ENTRY(mercury____Compare___io__output_stream_0_0),
	(const Word *) &mercury_data_io__base_type_layout_output_stream_0,
	(const Word *) &mercury_data_io__base_type_functors_output_stream_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("output_stream", 13)
};

extern const struct mercury_data_io__base_type_layout_poly_type_0_struct
	mercury_data_io__base_type_layout_poly_type_0;
extern const struct mercury_data_io__base_type_functors_poly_type_0_struct
	mercury_data_io__base_type_functors_poly_type_0;
const struct mercury_data_io__base_type_info_poly_type_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_poly_type_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__poly_type_0_0),
	ENTRY(mercury____Index___io__poly_type_0_0),
	ENTRY(mercury____Compare___io__poly_type_0_0),
	(const Word *) &mercury_data_io__base_type_layout_poly_type_0,
	(const Word *) &mercury_data_io__base_type_functors_poly_type_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("poly_type", 9)
};

extern const struct mercury_data_io__base_type_layout_read_result_1_struct
	mercury_data_io__base_type_layout_read_result_1;
extern const struct mercury_data_io__base_type_functors_read_result_1_struct
	mercury_data_io__base_type_functors_read_result_1;
const struct mercury_data_io__base_type_info_read_result_1_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_read_result_1 = {
	(Integer) 1,
	ENTRY(mercury____Unify___io__read_result_1_0),
	ENTRY(mercury____Index___io__read_result_1_0),
	ENTRY(mercury____Compare___io__read_result_1_0),
	(const Word *) &mercury_data_io__base_type_layout_read_result_1,
	(const Word *) &mercury_data_io__base_type_functors_read_result_1,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("read_result", 11)
};

extern const struct mercury_data_io__base_type_layout_res_0_struct
	mercury_data_io__base_type_layout_res_0;
extern const struct mercury_data_io__base_type_functors_res_0_struct
	mercury_data_io__base_type_functors_res_0;
const struct mercury_data_io__base_type_info_res_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_res_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__res_0_0),
	ENTRY(mercury____Index___io__res_0_0),
	ENTRY(mercury____Compare___io__res_0_0),
	(const Word *) &mercury_data_io__base_type_layout_res_0,
	(const Word *) &mercury_data_io__base_type_functors_res_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("res", 3)
};

extern const struct mercury_data_io__base_type_layout_res_1_struct
	mercury_data_io__base_type_layout_res_1;
extern const struct mercury_data_io__base_type_functors_res_1_struct
	mercury_data_io__base_type_functors_res_1;
const struct mercury_data_io__base_type_info_res_1_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_res_1 = {
	(Integer) 1,
	ENTRY(mercury____Unify___io__res_1_0),
	ENTRY(mercury____Index___io__res_1_0),
	ENTRY(mercury____Compare___io__res_1_0),
	(const Word *) &mercury_data_io__base_type_layout_res_1,
	(const Word *) &mercury_data_io__base_type_functors_res_1,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("res", 3)
};

extern const struct mercury_data_io__base_type_layout_result_0_struct
	mercury_data_io__base_type_layout_result_0;
extern const struct mercury_data_io__base_type_functors_result_0_struct
	mercury_data_io__base_type_functors_result_0;
const struct mercury_data_io__base_type_info_result_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_result_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__result_0_0),
	ENTRY(mercury____Index___io__result_0_0),
	ENTRY(mercury____Compare___io__result_0_0),
	(const Word *) &mercury_data_io__base_type_layout_result_0,
	(const Word *) &mercury_data_io__base_type_functors_result_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("result", 6)
};

extern const struct mercury_data_io__base_type_layout_result_1_struct
	mercury_data_io__base_type_layout_result_1;
extern const struct mercury_data_io__base_type_functors_result_1_struct
	mercury_data_io__base_type_functors_result_1;
const struct mercury_data_io__base_type_info_result_1_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_result_1 = {
	(Integer) 1,
	ENTRY(mercury____Unify___io__result_1_0),
	ENTRY(mercury____Index___io__result_1_0),
	ENTRY(mercury____Compare___io__result_1_0),
	(const Word *) &mercury_data_io__base_type_layout_result_1,
	(const Word *) &mercury_data_io__base_type_functors_result_1,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("result", 6)
};

extern const struct mercury_data_io__base_type_layout_state_0_struct
	mercury_data_io__base_type_layout_state_0;
extern const struct mercury_data_io__base_type_functors_state_0_struct
	mercury_data_io__base_type_functors_state_0;
const struct mercury_data_io__base_type_info_state_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_state_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__state_0_0),
	ENTRY(mercury____Index___io__state_0_0),
	ENTRY(mercury____Compare___io__state_0_0),
	(const Word *) &mercury_data_io__base_type_layout_state_0,
	(const Word *) &mercury_data_io__base_type_functors_state_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("state", 5)
};

extern const struct mercury_data_io__base_type_layout_stream_0_struct
	mercury_data_io__base_type_layout_stream_0;
extern const struct mercury_data_io__base_type_functors_stream_0_struct
	mercury_data_io__base_type_functors_stream_0;
static const struct mercury_data_io__base_type_info_stream_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_stream_0 = {
	(Integer) 0,
	STATIC(mercury____Unify___io__stream_0_0),
	STATIC(mercury____Index___io__stream_0_0),
	STATIC(mercury____Compare___io__stream_0_0),
	(const Word *) &mercury_data_io__base_type_layout_stream_0,
	(const Word *) &mercury_data_io__base_type_functors_stream_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("stream", 6)
};

extern const struct mercury_data_io__base_type_layout_stream_names_0_struct
	mercury_data_io__base_type_layout_stream_names_0;
extern const struct mercury_data_io__base_type_functors_stream_names_0_struct
	mercury_data_io__base_type_functors_stream_names_0;
static const struct mercury_data_io__base_type_info_stream_names_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_stream_names_0 = {
	(Integer) 0,
	STATIC(mercury____Unify___io__stream_names_0_0),
	STATIC(mercury____Index___io__stream_names_0_0),
	STATIC(mercury____Compare___io__stream_names_0_0),
	(const Word *) &mercury_data_io__base_type_layout_stream_names_0,
	(const Word *) &mercury_data_io__base_type_functors_stream_names_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("stream_names", 12)
};

extern const struct mercury_data_io__base_type_layout_stream_putback_0_struct
	mercury_data_io__base_type_layout_stream_putback_0;
extern const struct mercury_data_io__base_type_functors_stream_putback_0_struct
	mercury_data_io__base_type_functors_stream_putback_0;
static const struct mercury_data_io__base_type_info_stream_putback_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_stream_putback_0 = {
	(Integer) 0,
	STATIC(mercury____Unify___io__stream_putback_0_0),
	STATIC(mercury____Index___io__stream_putback_0_0),
	STATIC(mercury____Compare___io__stream_putback_0_0),
	(const Word *) &mercury_data_io__base_type_layout_stream_putback_0,
	(const Word *) &mercury_data_io__base_type_functors_stream_putback_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("stream_putback", 14)
};

extern const struct mercury_data_io__base_type_layout_whence_0_struct
	mercury_data_io__base_type_layout_whence_0;
extern const struct mercury_data_io__base_type_functors_whence_0_struct
	mercury_data_io__base_type_functors_whence_0;
const struct mercury_data_io__base_type_info_whence_0_struct {
	Integer f1;
	Code * f2;
	Code * f3;
	Code * f4;
	const Word * f5;
	const Word * f6;
	const Word * f7;
	const Word * f8;
} mercury_data_io__base_type_info_whence_0 = {
	(Integer) 0,
	ENTRY(mercury____Unify___io__whence_0_0),
	ENTRY(mercury____Index___io__whence_0_0),
	ENTRY(mercury____Compare___io__whence_0_0),
	(const Word *) &mercury_data_io__base_type_layout_whence_0,
	(const Word *) &mercury_data_io__base_type_functors_whence_0,
	(const Word *) string_const("io", 2),
	(const Word *) string_const("whence", 6)
};

extern const struct mercury_data_io__common_7_struct
	mercury_data_io__common_7;
const struct mercury_data_io__base_type_functors_whence_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_whence_0 = {
	(Integer) 1,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_7)
};

const struct mercury_data_io__base_type_layout_whence_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_whence_0 = {
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_7),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_7),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_7),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_7)
};

extern const struct mercury_data_io__common_8_struct
	mercury_data_io__common_8;
static const struct mercury_data_io__base_type_functors_stream_putback_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_stream_putback_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_8)
};

extern const struct mercury_data_io__common_9_struct
	mercury_data_io__common_9;
static const struct mercury_data_io__base_type_layout_stream_putback_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_stream_putback_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_9),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_9),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_9),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_9)
};

extern const struct mercury_data_io__common_10_struct
	mercury_data_io__common_10;
static const struct mercury_data_io__base_type_functors_stream_names_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_stream_names_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_10)
};

extern const struct mercury_data_io__common_11_struct
	mercury_data_io__common_11;
static const struct mercury_data_io__base_type_layout_stream_names_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_stream_names_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_11),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_11),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_11),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_11)
};

extern const struct mercury_data_io__common_12_struct
	mercury_data_io__common_12;
static const struct mercury_data_io__base_type_functors_stream_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_stream_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12)
};

extern const struct mercury_data_io__common_13_struct
	mercury_data_io__common_13;
static const struct mercury_data_io__base_type_layout_stream_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_stream_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13)
};

extern const struct mercury_data_io__common_14_struct
	mercury_data_io__common_14;
const struct mercury_data_io__base_type_functors_state_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_state_0 = {
	(Integer) 4,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_14)
};

const struct mercury_data_io__base_type_layout_state_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_state_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_14),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_14),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_14),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_14)
};

extern const struct mercury_data_io__common_15_struct
	mercury_data_io__common_15;
extern const struct mercury_data_io__common_17_struct
	mercury_data_io__common_17;
extern const struct mercury_data_io__common_18_struct
	mercury_data_io__common_18;
const struct mercury_data_io__base_type_functors_result_1_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
	const Word * f5;
} mercury_data_io__base_type_functors_result_1 = {
	(Integer) 0,
	(Integer) 3,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_15),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_17),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_18)
};

extern const struct mercury_data_io__common_19_struct
	mercury_data_io__common_19;
const struct mercury_data_io__base_type_layout_result_1_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_result_1 = {
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_19),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_18),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_17),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

extern const struct mercury_data_io__common_20_struct
	mercury_data_io__common_20;
extern const struct mercury_data_io__common_21_struct
	mercury_data_io__common_21;
extern const struct mercury_data_io__common_22_struct
	mercury_data_io__common_22;
const struct mercury_data_io__base_type_functors_result_0_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
	const Word * f5;
} mercury_data_io__base_type_functors_result_0 = {
	(Integer) 0,
	(Integer) 3,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_20),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_21),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_22)
};

extern const struct mercury_data_io__common_23_struct
	mercury_data_io__common_23;
const struct mercury_data_io__base_type_layout_result_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_result_0 = {
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_23),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_21),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1)),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

extern const struct mercury_data_io__common_24_struct
	mercury_data_io__common_24;
const struct mercury_data_io__base_type_functors_res_1_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_functors_res_1 = {
	(Integer) 0,
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_21),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_24)
};

const struct mercury_data_io__base_type_layout_res_1_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_res_1 = {
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_24),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_21),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1)),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

const struct mercury_data_io__base_type_functors_res_0_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_functors_res_0 = {
	(Integer) 0,
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_21),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_22)
};

extern const struct mercury_data_io__common_25_struct
	mercury_data_io__common_25;
const struct mercury_data_io__base_type_layout_res_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_res_0 = {
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_25),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_21),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1)),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

extern const struct mercury_data_io__common_27_struct
	mercury_data_io__common_27;
const struct mercury_data_io__base_type_functors_read_result_1_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
	const Word * f5;
} mercury_data_io__base_type_functors_read_result_1 = {
	(Integer) 0,
	(Integer) 3,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_15),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_27),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_18)
};

const struct mercury_data_io__base_type_layout_read_result_1_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_read_result_1 = {
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_19),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_18),
	(const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_27),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

extern const struct mercury_data_io__common_28_struct
	mercury_data_io__common_28;
const struct mercury_data_io__base_type_functors_poly_type_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_poly_type_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_28)
};

extern const struct mercury_data_io__common_29_struct
	mercury_data_io__common_29;
const struct mercury_data_io__base_type_layout_poly_type_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_poly_type_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_29),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_29),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_29),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_29)
};

const struct mercury_data_io__base_type_functors_output_stream_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_output_stream_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12)
};

const struct mercury_data_io__base_type_layout_output_stream_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_output_stream_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13)
};

const struct mercury_data_io__base_type_functors_input_stream_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_input_stream_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12)
};

const struct mercury_data_io__base_type_layout_input_stream_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_input_stream_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13)
};

extern const struct mercury_data_io__common_16_struct
	mercury_data_io__common_16;
const struct mercury_data_io__base_type_functors_error_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_error_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_16)
};

extern const struct mercury_data_io__common_30_struct
	mercury_data_io__common_30;
const struct mercury_data_io__base_type_layout_error_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_error_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_30),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_30),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_30),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_30)
};

const struct mercury_data_io__base_type_functors_binary_stream_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_binary_stream_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12)
};

const struct mercury_data_io__base_type_layout_binary_stream_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_binary_stream_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13)
};

const struct mercury_data_io__base_type_functors_binary_output_stream_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_binary_output_stream_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12)
};

const struct mercury_data_io__base_type_layout_binary_output_stream_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_binary_output_stream_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13)
};

const struct mercury_data_io__base_type_functors_binary_input_stream_0_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__base_type_functors_binary_input_stream_0 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12)
};

const struct mercury_data_io__base_type_layout_binary_input_stream_0_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__base_type_layout_binary_input_stream_0 = {
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13),
	(const Word *) mkword(mktag(3), (Word) (const Word *) &mercury_data_io__common_13)
};

static const struct mercury_data_io__common_0_struct {
	const Word * f1;
} mercury_data_io__common_0 = {
	(const Word *) string_const("read error", 10)
};

static const struct mercury_data_io__common_1_struct {
	const Word * f1;
} mercury_data_io__common_1 = {
	(const Word *) string_const("can't open input file", 21)
};

static const struct mercury_data_io__common_2_struct {
	const Word * f1;
} mercury_data_io__common_2 = {
	(const Word *) string_const("can't open output file", 22)
};

static const struct mercury_data_io__common_3_struct {
	const Word * f1;
} mercury_data_io__common_3 = {
	(const Word *) string_const("can't append to file", 20)
};

static const struct mercury_data_io__common_4_struct {
	const Word * f1;
} mercury_data_io__common_4 = {
	(const Word *) string_const("can't invoke system command", 27)
};

static const struct mercury_data_io__common_5_struct {
	const Word * f1;
} mercury_data_io__common_5 = {
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

extern const struct mercury_data_list__base_type_info_list_1_struct
	mercury_data_list__base_type_info_list_1;
extern const struct mercury_data___base_type_info_character_0_struct
	mercury_data___base_type_info_character_0;
static const struct mercury_data_io__common_6_struct {
	const Word * f1;
	const Word * f2;
} mercury_data_io__common_6 = {
	(const Word *) &mercury_data_list__base_type_info_list_1,
	(const Word *) &mercury_data___base_type_info_character_0
};

static const struct mercury_data_io__common_7_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
	const Word * f5;
} mercury_data_io__common_7 = {
	(Integer) 1,
	(Integer) 3,
	(const Word *) string_const("set", 3),
	(const Word *) string_const("cur", 3),
	(const Word *) string_const("end", 3)
};

extern const struct mercury_data_tree234__base_type_info_tree234_2_struct
	mercury_data_tree234__base_type_info_tree234_2;
extern const struct mercury_data_mercury_builtin__base_type_info_c_pointer_0_struct
	mercury_data_mercury_builtin__base_type_info_c_pointer_0;
static const struct mercury_data_io__common_8_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
} mercury_data_io__common_8 = {
	(const Word *) &mercury_data_tree234__base_type_info_tree234_2,
	(const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_6)
};

static const struct mercury_data_io__common_9_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__common_9 = {
	(Integer) 0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_8)
};

extern const struct mercury_data___base_type_info_string_0_struct
	mercury_data___base_type_info_string_0;
static const struct mercury_data_io__common_10_struct {
	const Word * f1;
	const Word * f2;
	const Word * f3;
} mercury_data_io__common_10 = {
	(const Word *) &mercury_data_tree234__base_type_info_tree234_2,
	(const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0,
	(const Word *) &mercury_data___base_type_info_string_0
};

static const struct mercury_data_io__common_11_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__common_11 = {
	(Integer) 0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_10)
};

static const struct mercury_data_io__common_12_struct {
	const Word * f1;
} mercury_data_io__common_12 = {
	(const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0
};

static const struct mercury_data_io__common_13_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__common_13 = {
	(Integer) 0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12)
};

static const struct mercury_data_io__common_14_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__common_14 = {
	(Integer) 1,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_12),
	(const Word *) string_const("state", 5),
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

static const struct mercury_data_io__common_15_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
} mercury_data_io__common_15 = {
	(Integer) 0,
	(const Word *) string_const("eof", 3),
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

static const struct mercury_data_io__common_16_struct {
	const Word * f1;
} mercury_data_io__common_16 = {
	(const Word *) &mercury_data___base_type_info_string_0
};

static const struct mercury_data_io__common_17_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__common_17 = {
	(Integer) 1,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_16),
	(const Word *) string_const("error", 5),
	(const Word *) mkword(mktag(2), mkbody((Integer) 0))
};

static const struct mercury_data_io__common_18_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__common_18 = {
	(Integer) 1,
	(Integer) 1,
	(const Word *) string_const("ok", 2),
	(const Word *) mkword(mktag(1), mkbody((Integer) 0))
};

static const struct mercury_data_io__common_19_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
} mercury_data_io__common_19 = {
	(Integer) 0,
	(Integer) 1,
	(const Word *) string_const("eof", 3)
};

static const struct mercury_data_io__common_20_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
} mercury_data_io__common_20 = {
	(Integer) 0,
	(const Word *) string_const("eof", 3),
	(const Word *) mkword(mktag(0), mkbody((Integer) 1))
};

static const struct mercury_data_io__common_21_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__common_21 = {
	(Integer) 1,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_16),
	(const Word *) string_const("error", 5),
	(const Word *) mkword(mktag(1), mkbody((Integer) 0))
};

static const struct mercury_data_io__common_22_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
} mercury_data_io__common_22 = {
	(Integer) 0,
	(const Word *) string_const("ok", 2),
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

static const struct mercury_data_io__common_23_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__common_23 = {
	(Integer) 0,
	(Integer) 2,
	(const Word *) string_const("ok", 2),
	(const Word *) string_const("eof", 3)
};

static const struct mercury_data_io__common_24_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
	const Word * f4;
} mercury_data_io__common_24 = {
	(Integer) 1,
	(Integer) 1,
	(const Word *) string_const("ok", 2),
	(const Word *) mkword(mktag(0), mkbody((Integer) 0))
};

static const struct mercury_data_io__common_25_struct {
	Integer f1;
	Integer f2;
	const Word * f3;
} mercury_data_io__common_25 = {
	(Integer) 0,
	(Integer) 1,
	(const Word *) string_const("ok", 2)
};

extern const struct mercury_data___base_type_info_int_0_struct
	mercury_data___base_type_info_int_0;
static const struct mercury_data_io__common_26_struct {
	const Word * f1;
} mercury_data_io__common_26 = {
	(const Word *) &mercury_data___base_type_info_int_0
};

static const struct mercury_data_io__common_27_struct {
	Integer f1;
	const Word * f2;
	const Word * f3;
	const Word * f4;
	const Word * f5;
} mercury_data_io__common_27 = {
	(Integer) 2,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_16),
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_26),
	(const Word *) string_const("error", 5),
	(const Word *) mkword(mktag(2), mkbody((Integer) 0))
};

extern const struct mercury_data_string__base_type_info_poly_type_0_struct
	mercury_data_string__base_type_info_poly_type_0;
static const struct mercury_data_io__common_28_struct {
	const Word * f1;
} mercury_data_io__common_28 = {
	(const Word *) &mercury_data_string__base_type_info_poly_type_0
};

static const struct mercury_data_io__common_29_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__common_29 = {
	(Integer) 0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_28)
};

static const struct mercury_data_io__common_30_struct {
	Integer f1;
	const Word * f2;
} mercury_data_io__common_30 = {
	(Integer) 0,
	(const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_16)
};


BEGIN_MODULE(mercury__io_module0)
	init_entry(mercury____Index___io__error_0__ua10000_2_0);
BEGIN_CODE

/* code for predicate '__Index___io__error_0__ua10000'/2 in mode 0 */
Define_static(mercury____Index___io__error_0__ua10000_2_0);
	r1 = (Integer) -1;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module1)
	init_entry(mercury____Index___io__read_result_1__ua10000_2_0);
	init_label(mercury____Index___io__read_result_1__ua10000_2_0_i4);
	init_label(mercury____Index___io__read_result_1__ua10000_2_0_i5);
BEGIN_CODE

/* code for predicate '__Index___io__read_result_1__ua10000'/2 in mode 0 */
Define_static(mercury____Index___io__read_result_1__ua10000_2_0);
	r2 = tag(r1);
	if ((r2 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Index___io__read_result_1__ua10000_2_0_i4);
	r1 = (Integer) 1;
	proceed();
Define_label(mercury____Index___io__read_result_1__ua10000_2_0_i4);
	if ((r2 != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Index___io__read_result_1__ua10000_2_0_i5);
	r1 = (Integer) 0;
	proceed();
Define_label(mercury____Index___io__read_result_1__ua10000_2_0_i5);
	r1 = (Integer) 2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module2)
	init_entry(mercury____Index___io__result_1__ua10000_2_0);
	init_label(mercury____Index___io__result_1__ua10000_2_0_i4);
	init_label(mercury____Index___io__result_1__ua10000_2_0_i5);
BEGIN_CODE

/* code for predicate '__Index___io__result_1__ua10000'/2 in mode 0 */
Define_static(mercury____Index___io__result_1__ua10000_2_0);
	r2 = tag(r1);
	if ((r2 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Index___io__result_1__ua10000_2_0_i4);
	r1 = (Integer) 1;
	proceed();
Define_label(mercury____Index___io__result_1__ua10000_2_0_i4);
	if ((r2 != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Index___io__result_1__ua10000_2_0_i5);
	r1 = (Integer) 0;
	proceed();
Define_label(mercury____Index___io__result_1__ua10000_2_0_i5);
	r1 = (Integer) 2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module3)
	init_entry(mercury____Index___io__res_1__ua10000_2_0);
	init_label(mercury____Index___io__res_1__ua10000_2_0_i3);
BEGIN_CODE

/* code for predicate '__Index___io__res_1__ua10000'/2 in mode 0 */
Define_static(mercury____Index___io__res_1__ua10000_2_0);
	if ((tag(r1) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Index___io__res_1__ua10000_2_0_i3);
	r1 = (Integer) 0;
	proceed();
Define_label(mercury____Index___io__res_1__ua10000_2_0_i3);
	r1 = (Integer) 1;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module4)
	init_entry(mercury____Index___io__state_0__ua10000_2_0);
BEGIN_CODE

/* code for predicate '__Index___io__state_0__ua10000'/2 in mode 0 */
Define_static(mercury____Index___io__state_0__ua10000_2_0);
	r1 = (Integer) 0;
	proceed();
END_MODULE

Declare_entry(mercury__ops__op_table_4_1);

BEGIN_MODULE(mercury__io_module5)
	init_entry(mercury__io__ops__lookup_op__ua0_2_0);
	init_label(mercury__io__ops__lookup_op__ua0_2_0_i1005);
	init_label(mercury__io__ops__lookup_op__ua0_2_0_i3);
BEGIN_CODE

/* code for predicate 'lookup_op__ua0'/2 in mode 0 */
Define_static(mercury__io__ops__lookup_op__ua0_2_0);
	incr_sp_push_msg(4, "ops:lookup_op__ua0/2");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = (Word) curfr;
	detstackvar(2) = (Word) maxfr;
	detstackvar(3) = (Word) bt_redoip(maxfr);
	bt_redoip(maxfr) = LABEL(mercury__io__ops__lookup_op__ua0_2_0_i3);
	call_localret(ENTRY(mercury__ops__op_table_4_1),
		mercury__io__ops__lookup_op__ua0_2_0_i1005,
		STATIC(mercury__io__ops__lookup_op__ua0_2_0));
Define_label(mercury__io__ops__lookup_op__ua0_2_0_i1005);
	update_prof_current_proc(LABEL(mercury__io__ops__lookup_op__ua0_2_0));
	maxfr = (const Word *) detstackvar(2);
	bt_redoip(maxfr) = (Code *) detstackvar(3);
	curfr = (const Word *) detstackvar(1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	r1 = TRUE;
	proceed();
Define_label(mercury__io__ops__lookup_op__ua0_2_0_i3);
	update_prof_current_proc(LABEL(mercury__io__ops__lookup_op__ua0_2_0));
	curfr = (const Word *) detstackvar(1);
	bt_redoip(maxfr) = (Code *) detstackvar(3);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module6)
	init_entry(mercury__io__convert_read_result__ua10000_2_0);
	init_label(mercury__io__convert_read_result__ua10000_2_0_i4);
	init_label(mercury__io__convert_read_result__ua10000_2_0_i5);
BEGIN_CODE

/* code for predicate 'convert_read_result__ua10000'/2 in mode 0 */
Define_static(mercury__io__convert_read_result__ua10000_2_0);
	r2 = tag(r1);
	if ((r2 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__convert_read_result__ua10000_2_0_i4);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	proceed();
Define_label(mercury__io__convert_read_result__ua10000_2_0_i4);
	if ((r2 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__convert_read_result__ua10000_2_0_i5);
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = const_field(mktag(1), r2, (Integer) 0);
	proceed();
Define_label(mercury__io__convert_read_result__ua10000_2_0_i5);
	r2 = r1;
	tag_incr_hp(r1, mktag(2), (Integer) 1);
	field(mktag(2), r1, (Integer) 0) = const_field(mktag(2), r2, (Integer) 0);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module7)
	init_entry(mercury__io__write_c_pointer__ua10000_3_0);
BEGIN_CODE

/* code for predicate 'write_c_pointer__ua10000'/3 in mode 0 */
Define_static(mercury__io__write_c_pointer__ua10000_3_0);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) (Word) (const Word *) string_const("<<c_pointer>>", 13);
		IO0 = r1;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 2181 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module8)
	init_entry(mercury__io__set_op_table__ua10000_3_0);
BEGIN_CODE

/* code for predicate 'set_op_table__ua10000'/3 in mode 0 */
Define_static(mercury__io__set_op_table__ua10000_3_0);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module9)
	init_entry(mercury__io__write_list__ua10000_6_0);
	init_label(mercury__io__write_list__ua10000_6_0_i2);
BEGIN_CODE

/* code for predicate 'write_list__ua10000'/6 in mode 0 */
Define_static(mercury__io__write_list__ua10000_6_0);
	incr_sp_push_msg(2, "io:write_list__ua10000/6");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r1;
		IO0 = r5;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 2222 "io.c"
		r6 = OutStream;
		r7 = IO;

	}
	detstackvar(1) = r6;
	r1 = r2;
	r2 = r3;
	r3 = r4;
	r4 = r7;
	call_localret(STATIC(mercury__io__write_list__ua10000_5_0),
		mercury__io__write_list__ua10000_6_0_i2,
		STATIC(mercury__io__write_list__ua10000_6_0));
Define_label(mercury__io__write_list__ua10000_6_0_i2);
	update_prof_current_proc(LABEL(mercury__io__write_list__ua10000_6_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r1;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 2250 "io.c"
		r2 = OutStream;
		r3 = IO;

	}
	r1 = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE

Declare_entry(do_call_det_closure);

BEGIN_MODULE(mercury__io_module10)
	init_entry(mercury__io__write_list__ua10000_5_0);
	init_label(mercury__io__write_list__ua10000_5_0_i1002);
	init_label(mercury__io__write_list__ua10000_5_0_i4);
	init_label(mercury__io__write_list__ua10000_5_0_i6);
	init_label(mercury__io__write_list__ua10000_5_0_i3);
BEGIN_CODE

/* code for predicate 'write_list__ua10000'/5 in mode 0 */
Define_static(mercury__io__write_list__ua10000_5_0);
	incr_sp_push_msg(4, "io:write_list__ua10000/5");
	detstackvar(4) = (Word) succip;
Define_label(mercury__io__write_list__ua10000_5_0_i1002);
	if (((Integer) r1 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_list__ua10000_5_0_i3);
	detstackvar(1) = r2;
	detstackvar(2) = r3;
	detstackvar(3) = const_field(mktag(1), r1, (Integer) 1);
	r5 = r4;
	r4 = const_field(mktag(1), r1, (Integer) 0);
	r1 = r3;
	r2 = (Integer) 2;
	r3 = (Integer) 1;
	call_localret(ENTRY(do_call_det_closure),
		mercury__io__write_list__ua10000_5_0_i4,
		STATIC(mercury__io__write_list__ua10000_5_0));
Define_label(mercury__io__write_list__ua10000_5_0_i4);
	update_prof_current_proc(LABEL(mercury__io__write_list__ua10000_5_0));
	if (((Integer) detstackvar(3) != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_list__ua10000_5_0_i6);
	r2 = detstackvar(1);
	r3 = detstackvar(2);
	r4 = r1;
	r1 = detstackvar(3);
	succip = (Code *) detstackvar(4);
	GOTO_LABEL(mercury__io__write_list__ua10000_5_0_i1002);
Define_label(mercury__io__write_list__ua10000_5_0_i6);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) detstackvar(1);
		IO0 = r1;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 2311 "io.c"
		r4 = IO;

	}
	r2 = detstackvar(1);
	r3 = detstackvar(2);
	r1 = detstackvar(3);
	succip = (Code *) detstackvar(4);
	GOTO_LABEL(mercury__io__write_list__ua10000_5_0_i1002);
Define_label(mercury__io__write_list__ua10000_5_0_i3);
	r1 = r4;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module11)
	init_entry(mercury__io__read_char_3_0);
BEGIN_CODE

/* code for predicate 'read_char'/3 in mode 0 */
Define_entry(mercury__io__read_char_3_0);
	incr_sp_push_msg(1, "io:read_char/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 2346 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__read_char_4_0),
		ENTRY(mercury__io__read_char_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module12)
	init_entry(mercury__io__read_word_3_0);
BEGIN_CODE

/* code for predicate 'read_word'/3 in mode 0 */
Define_entry(mercury__io__read_word_3_0);
	incr_sp_push_msg(1, "io:read_word/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 2378 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__read_word_4_0),
		ENTRY(mercury__io__read_word_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module13)
	init_entry(mercury__io__read_line_3_0);
BEGIN_CODE

/* code for predicate 'read_line'/3 in mode 0 */
Define_entry(mercury__io__read_line_3_0);
	incr_sp_push_msg(1, "io:read_line/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 2410 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__read_line_4_0),
		ENTRY(mercury__io__read_line_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module14)
	init_entry(mercury__io__read_file_3_0);
BEGIN_CODE

/* code for predicate 'read_file'/3 in mode 0 */
Define_entry(mercury__io__read_file_3_0);
	incr_sp_push_msg(1, "io:read_file/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 2442 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__read_file_2_5_0),
		ENTRY(mercury__io__read_file_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module15)
	init_entry(mercury__io__putback_char_3_0);
BEGIN_CODE

/* code for predicate 'putback_char'/3 in mode 0 */
Define_entry(mercury__io__putback_char_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 2472 "io.c"
		r3 = Stream;
		r4 = IO;

	}
	{
		Word	File;
		Char	Character;
		Word	IO0;
		Word	IO;
		File = r3;
		Character = r1;
		IO0 = r4;
#line 2168 "io.m"
{		{
	MercuryFile* mf = (MercuryFile *)File;
	if (Character == '\n') {
		mf->line_number--;
	}
	/* XXX should work even if ungetc() fails */
	if (ungetc(Character, mf->file) == EOF) {
		fatal_error("io__putback_char: ungetc failed");
	}
	update_io(IO0, IO);
};}
#line 2497 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module16)
	init_entry(mercury__io__read_char_4_0);
	init_label(mercury__io__read_char_4_0_i2);
	init_label(mercury__io__read_char_4_0_i5);
BEGIN_CODE

/* code for predicate 'read_char'/4 in mode 0 */
Define_entry(mercury__io__read_char_4_0);
	incr_sp_push_msg(1, "io:read_char/4");
	{
		Word	File;
		Integer	CharCode;
		Word	IO0;
		Word	IO;
		File = r1;
		IO0 = r2;
#line 2162 "io.m"
{		
	CharCode = mercury_getc((MercuryFile*)File);
	update_io(IO0, IO);
;}
#line 2527 "io.c"
		r3 = CharCode;
		r4 = IO;

	}
	if (((Integer) r3 != (Integer) -1))
		GOTO_LABEL(mercury__io__read_char_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r4;
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__read_char_4_0_i2);
	{
		Char	Character;
		Integer	Int;
		Int = r3;
{		
	/*
	** If the integer doesn't fit into a char, then
	** the assignment `Character = Int' below will truncate it.
	** SUCCESS_INDICATOR will be set to true only if
	** the result was not truncated.
	*/
	Character = Int;
	SUCCESS_INDICATOR = ((UnsignedChar) Character == Int);
;}
#line 2553 "io.c"
		r2 = Character;

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__read_char_4_0_i5);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r2;
	r2 = r4;
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__read_char_4_0_i5);
	r1 = (Word) (const Word *) mkword(mktag(2), (Word) (const Word *) &mercury_data_io__common_0);
	r2 = r4;
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module17)
	init_entry(mercury__io__read_word_4_0);
	init_label(mercury__io__read_word_4_0_i2);
	init_label(mercury__io__read_word_4_0_i6);
	init_label(mercury__io__read_word_4_0_i5);
BEGIN_CODE

/* code for predicate 'read_word'/4 in mode 0 */
Define_entry(mercury__io__read_word_4_0);
	incr_sp_push_msg(2, "io:read_word/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	call_localret(STATIC(mercury__io__ignore_whitespace_4_0),
		mercury__io__read_word_4_0_i2,
		ENTRY(mercury__io__read_word_4_0));
Define_label(mercury__io__read_word_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_word_4_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_word_4_0_i5);
	if (((Integer) unmkbody(r1) != (Integer) 0))
		GOTO_LABEL(mercury__io__read_word_4_0_i6);
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	tailcall(STATIC(mercury__io__read_word_2_4_0),
		ENTRY(mercury__io__read_word_4_0));
Define_label(mercury__io__read_word_4_0_i6);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
Define_label(mercury__io__read_word_4_0_i5);
	r3 = r1;
	tag_incr_hp(r1, mktag(2), (Integer) 1);
	field(mktag(2), r1, (Integer) 0) = const_field(mktag(1), r3, (Integer) 0);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module18)
	init_entry(mercury__io__read_line_4_0);
	init_label(mercury__io__read_line_4_0_i2);
	init_label(mercury__io__read_line_4_0_i5);
	init_label(mercury__io__read_line_4_0_i7);
	init_label(mercury__io__read_line_4_0_i10);
	init_label(mercury__io__read_line_4_0_i13);
	init_label(mercury__io__read_line_4_0_i3);
BEGIN_CODE

/* code for predicate 'read_line'/4 in mode 0 */
Define_entry(mercury__io__read_line_4_0);
	incr_sp_push_msg(2, "io:read_line/4");
	detstackvar(2) = (Word) succip;
	detstackvar(1) = r1;
	call_localret(STATIC(mercury__io__read_char_4_0),
		mercury__io__read_line_4_0_i2,
		ENTRY(mercury__io__read_line_4_0));
Define_label(mercury__io__read_line_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_line_4_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_line_4_0_i5);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
Define_label(mercury__io__read_line_4_0_i5);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_line_4_0_i3);
	r3 = const_field(mktag(1), r1, (Integer) 0);
	if (((Integer) r3 != (Integer) 10))
		GOTO_LABEL(mercury__io__read_line_4_0_i7);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	{
	Word tempr1;
	tag_incr_hp(tempr1, mktag(1), (Integer) 2);
	field(mktag(1), r1, (Integer) 0) = tempr1;
	field(mktag(1), tempr1, (Integer) 1) = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	field(mktag(1), tempr1, (Integer) 0) = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
	}
Define_label(mercury__io__read_line_4_0_i7);
	r1 = detstackvar(1);
	detstackvar(1) = r3;
	localcall(mercury__io__read_line_4_0,
		LABEL(mercury__io__read_line_4_0_i10),
		ENTRY(mercury__io__read_line_4_0));
Define_label(mercury__io__read_line_4_0_i10);
	update_prof_current_proc(LABEL(mercury__io__read_line_4_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_line_4_0_i13);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	tag_incr_hp(r3, mktag(1), (Integer) 2);
	field(mktag(1), r3, (Integer) 0) = detstackvar(1);
	field(mktag(1), r3, (Integer) 1) = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	field(mktag(1), r1, (Integer) 0) = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
Define_label(mercury__io__read_line_4_0_i13);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_line_4_0_i3);
	r3 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	{
	Word tempr1;
	tag_incr_hp(tempr1, mktag(1), (Integer) 2);
	field(mktag(1), tempr1, (Integer) 1) = const_field(mktag(1), r3, (Integer) 0);
	field(mktag(1), tempr1, (Integer) 0) = detstackvar(1);
	field(mktag(1), r1, (Integer) 0) = tempr1;
	}
Define_label(mercury__io__read_line_4_0_i3);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module19)
	init_entry(mercury__io__read_file_4_0);
BEGIN_CODE

/* code for predicate 'read_file'/4 in mode 0 */
Define_entry(mercury__io__read_file_4_0);
	r3 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	tailcall(STATIC(mercury__io__read_file_2_5_0),
		ENTRY(mercury__io__read_file_4_0));
END_MODULE


BEGIN_MODULE(mercury__io_module20)
	init_entry(mercury__io__putback_char_4_0);
BEGIN_CODE

/* code for predicate 'putback_char'/4 in mode 0 */
Define_entry(mercury__io__putback_char_4_0);
	{
		Word	File;
		Char	Character;
		Word	IO0;
		Word	IO;
		File = r1;
		Character = r2;
		IO0 = r3;
#line 2168 "io.m"
{		{
	MercuryFile* mf = (MercuryFile *)File;
	if (Character == '\n') {
		mf->line_number--;
	}
	/* XXX should work even if ungetc() fails */
	if (ungetc(Character, mf->file) == EOF) {
		fatal_error("io__putback_char: ungetc failed");
	}
	update_io(IO0, IO);
};}
#line 2735 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE

Declare_entry(mercury__parser__read_term_3_0);
Declare_entry(mercury__term__try_term_to_type_2_0);
Declare_entry(mercury__term__is_ground_2_1_0);

BEGIN_MODULE(mercury__io_module21)
	init_entry(mercury__io__read_3_0);
	init_label(mercury__io__read_3_0_i2);
	init_label(mercury__io__read_3_0_i5);
	init_label(mercury__io__read_3_0_i6);
	init_label(mercury__io__read_3_0_i9);
	init_label(mercury__io__read_3_0_i8);
	init_label(mercury__io__read_3_0_i16);
	init_label(mercury__io__read_3_0_i13);
	init_label(mercury__io__read_3_0_i12);
BEGIN_CODE

/* code for predicate 'read'/3 in mode 0 */
Define_entry(mercury__io__read_3_0);
	incr_sp_push_msg(3, "io:read/3");
	detstackvar(3) = (Word) succip;
	detstackvar(1) = r1;
	r1 = r2;
	call_localret(ENTRY(mercury__parser__read_term_3_0),
		mercury__io__read_3_0_i2,
		ENTRY(mercury__io__read_3_0));
Define_label(mercury__io__read_3_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_3_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_3_0_i5);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__read_3_0_i5);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_3_0_i6);
	r3 = r1;
	tag_incr_hp(r1, mktag(2), (Integer) 2);
	field(mktag(2), r1, (Integer) 0) = const_field(mktag(1), r3, (Integer) 0);
	field(mktag(2), r1, (Integer) 1) = const_field(mktag(1), r3, (Integer) 1);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__read_3_0_i6);
	r3 = const_field(mktag(2), r1, (Integer) 1);
	r4 = detstackvar(1);
	detstackvar(1) = r3;
	detstackvar(2) = r2;
	r1 = r4;
	r2 = r3;
	call_localret(ENTRY(mercury__term__try_term_to_type_2_0),
		mercury__io__read_3_0_i9,
		ENTRY(mercury__io__read_3_0));
Define_label(mercury__io__read_3_0_i9);
	update_prof_current_proc(LABEL(mercury__io__read_3_0));
	if ((tag(r1) != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_3_0_i8);
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = const_field(mktag(0), r2, (Integer) 0);
	r2 = detstackvar(2);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__read_3_0_i8);
	{
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		IO0 = detstackvar(2);
#line 2398 "io.m"
{		
	LineNum = mercury_current_text_input->line_number;
	update_io(IO0, IO);
;}
#line 2819 "io.c"
		r1 = LineNum;
		r2 = IO;

	}
	if ((tag(detstackvar(1)) != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_3_0_i13);
	r3 = detstackvar(1);
	detstackvar(1) = r2;
	detstackvar(2) = r1;
	r1 = const_field(mktag(0), r3, (Integer) 1);
	call_localret(ENTRY(mercury__term__is_ground_2_1_0),
		mercury__io__read_3_0_i16,
		ENTRY(mercury__io__read_3_0));
Define_label(mercury__io__read_3_0_i16);
	update_prof_current_proc(LABEL(mercury__io__read_3_0));
	if (r1)
		GOTO_LABEL(mercury__io__read_3_0_i12);
	r2 = detstackvar(1);
	r1 = detstackvar(2);
Define_label(mercury__io__read_3_0_i13);
	r3 = r1;
	tag_incr_hp(r1, mktag(2), (Integer) 2);
	field(mktag(2), r1, (Integer) 0) = (Word) (const Word *) string_const("io__read: the term read was not a ground term", 45);
	field(mktag(2), r1, (Integer) 1) = r3;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__read_3_0_i12);
	r2 = detstackvar(1);
	r1 = detstackvar(2);
	r3 = r1;
	tag_incr_hp(r1, mktag(2), (Integer) 2);
	field(mktag(2), r1, (Integer) 0) = (Word) (const Word *) string_const("io__read: the term read did not have the right type", 51);
	field(mktag(2), r1, (Integer) 1) = r3;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module22)
	init_entry(mercury__io__read_4_0);
	init_label(mercury__io__read_4_0_i2);
BEGIN_CODE

/* code for predicate 'read'/4 in mode 0 */
Define_entry(mercury__io__read_4_0);
	incr_sp_push_msg(2, "io:read/4");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r3;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 2882 "io.c"
		r4 = OutStream;
		r5 = IO;

	}
	detstackvar(1) = r4;
	r2 = r5;
	call_localret(STATIC(mercury__io__read_3_0),
		mercury__io__read_4_0_i2,
		ENTRY(mercury__io__read_4_0));
Define_label(mercury__io__read_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_4_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r2;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 2907 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module23)
	init_entry(mercury__io__ignore_whitespace_3_0);
BEGIN_CODE

/* code for predicate 'ignore_whitespace'/3 in mode 0 */
Define_entry(mercury__io__ignore_whitespace_3_0);
	incr_sp_push_msg(1, "io:ignore_whitespace/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 2937 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__ignore_whitespace_4_0),
		ENTRY(mercury__io__ignore_whitespace_3_0));
END_MODULE

Declare_entry(mercury__char__is_whitespace_1_0);

BEGIN_MODULE(mercury__io_module24)
	init_entry(mercury__io__ignore_whitespace_4_0);
	init_label(mercury__io__ignore_whitespace_4_0_i1003);
	init_label(mercury__io__ignore_whitespace_4_0_i2);
	init_label(mercury__io__ignore_whitespace_4_0_i5);
	init_label(mercury__io__ignore_whitespace_4_0_i9);
	init_label(mercury__io__ignore_whitespace_4_0_i8);
	init_label(mercury__io__ignore_whitespace_4_0_i6);
BEGIN_CODE

/* code for predicate 'ignore_whitespace'/4 in mode 0 */
Define_entry(mercury__io__ignore_whitespace_4_0);
	incr_sp_push_msg(4, "io:ignore_whitespace/4");
	detstackvar(4) = (Word) succip;
Define_label(mercury__io__ignore_whitespace_4_0_i1003);
	detstackvar(1) = r1;
	call_localret(STATIC(mercury__io__read_char_4_0),
		mercury__io__ignore_whitespace_4_0_i2,
		ENTRY(mercury__io__ignore_whitespace_4_0));
Define_label(mercury__io__ignore_whitespace_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__ignore_whitespace_4_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__ignore_whitespace_4_0_i5);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 1));
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__ignore_whitespace_4_0_i5);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__ignore_whitespace_4_0_i6);
	r3 = const_field(mktag(1), r1, (Integer) 0);
	detstackvar(2) = r3;
	detstackvar(3) = r2;
	r1 = r3;
	call_localret(ENTRY(mercury__char__is_whitespace_1_0),
		mercury__io__ignore_whitespace_4_0_i9,
		ENTRY(mercury__io__ignore_whitespace_4_0));
Define_label(mercury__io__ignore_whitespace_4_0_i9);
	update_prof_current_proc(LABEL(mercury__io__ignore_whitespace_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__ignore_whitespace_4_0_i8);
	r1 = detstackvar(1);
	r2 = detstackvar(3);
	succip = (Code *) detstackvar(4);
	GOTO_LABEL(mercury__io__ignore_whitespace_4_0_i1003);
Define_label(mercury__io__ignore_whitespace_4_0_i8);
	r3 = detstackvar(2);
	r2 = detstackvar(3);
	{
		Word	File;
		Char	Character;
		Word	IO0;
		Word	IO;
		File = detstackvar(1);
		Character = r3;
		IO0 = r2;
#line 2168 "io.m"
{		{
	MercuryFile* mf = (MercuryFile *)File;
	if (Character == '\n') {
		mf->line_number--;
	}
	/* XXX should work even if ungetc() fails */
	if (ungetc(Character, mf->file) == EOF) {
		fatal_error("io__putback_char: ungetc failed");
	}
	update_io(IO0, IO);
};}
#line 3021 "io.c"
		r1 = IO;

	}
	r2 = r1;
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__ignore_whitespace_4_0_i6);
	r3 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = const_field(mktag(2), r3, (Integer) 0);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE

	extern const struct mercury_data_std_util__base_type_info_univ_0_struct
		mercury_data_std_util__base_type_info_univ_0;

BEGIN_MODULE(mercury__io_module25)
	init_entry(mercury__io__print_3_0);
	init_label(mercury__io__print_3_0_i2);
	init_label(mercury__io__print_3_0_i5);
	init_label(mercury__io__print_3_0_i8);
BEGIN_CODE

/* code for predicate 'print'/3 in mode 0 */
Define_entry(mercury__io__print_3_0);
	incr_sp_push_msg(3, "io:print/3");
	detstackvar(3) = (Word) succip;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 3064 "io.c"
		r4 = Univ;

	}
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data___base_type_info_string_0;
		Univ = r4;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 3087 "io.c"
		r2 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__print_3_0_i2);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) r2;
		IO0 = r3;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 3104 "io.c"
		r1 = IO;

	}
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__print_3_0_i2);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data___base_type_info_character_0;
		Univ = r4;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 3131 "io.c"
		r2 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__print_3_0_i5);
	{
		Char	Character;
		Word	IO0;
		Word	IO;
		Character = r2;
		IO0 = r3;
#line 2198 "io.m"
{		
	if (putc(Character, mercury_current_text_output->file) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	if (Character == '\n') {
		mercury_current_text_output->line_number++;
	}
	update_io(IO0, IO);
;}
#line 3153 "io.c"
		r1 = IO;

	}
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__print_3_0_i5);
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data_std_util__base_type_info_univ_0;
		Univ = r4;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 3180 "io.c"
		r2 = Type;

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__print_3_0_i8);
	r1 = r2;
	r2 = (Integer) 1201;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	tailcall(STATIC(mercury__io__write_univ_4_0),
		ENTRY(mercury__io__print_3_0));
Define_label(mercury__io__print_3_0_i8);
	r1 = r4;
	r2 = (Integer) 1201;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	tailcall(STATIC(mercury__io__write_univ_4_0),
		ENTRY(mercury__io__print_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module26)
	init_entry(mercury__io__print_4_0);
	init_label(mercury__io__print_4_0_i2);
BEGIN_CODE

/* code for predicate 'print'/4 in mode 0 */
Define_entry(mercury__io__print_4_0);
	incr_sp_push_msg(2, "io:print/4");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r4;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 3224 "io.c"
		r5 = OutStream;
		r6 = IO;

	}
	detstackvar(1) = r5;
	r2 = r3;
	r3 = r6;
	call_localret(STATIC(mercury__io__print_3_0),
		mercury__io__print_4_0_i2,
		ENTRY(mercury__io__print_4_0));
Define_label(mercury__io__print_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__print_4_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r1;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 3250 "io.c"
		r2 = OutStream;
		r3 = IO;

	}
	r1 = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module27)
	init_entry(mercury__io__write_3_0);
BEGIN_CODE

/* code for predicate 'write'/3 in mode 0 */
Define_entry(mercury__io__write_3_0);
	incr_sp_push_msg(1, "io:write/3");
	detstackvar(1) = (Word) succip;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 3281 "io.c"
		r4 = Univ;

	}
	r1 = r4;
	r2 = (Integer) 1201;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__write_univ_4_0),
		ENTRY(mercury__io__write_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module28)
	init_entry(mercury__io__write_4_0);
	init_label(mercury__io__write_4_0_i2);
BEGIN_CODE

/* code for predicate 'write'/4 in mode 0 */
Define_entry(mercury__io__write_4_0);
	incr_sp_push_msg(2, "io:write/4");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r4;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 3316 "io.c"
		r5 = OutStream;
		r6 = IO;

	}
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r3;
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 3332 "io.c"
		r2 = Univ;

	}
	detstackvar(1) = r5;
	r1 = r2;
	r2 = (Integer) 1201;
	r3 = r6;
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_4_0_i2,
		ENTRY(mercury__io__write_4_0));
Define_label(mercury__io__write_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__write_4_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r1;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 3358 "io.c"
		r2 = OutStream;
		r3 = IO;

	}
	r1 = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module29)
	init_entry(mercury__io__nl_2_0);
BEGIN_CODE

/* code for predicate 'nl'/2 in mode 0 */
Define_entry(mercury__io__nl_2_0);
	{
		Char	Character;
		Word	IO0;
		Word	IO;
		Character = (Integer) 10;
		IO0 = r1;
#line 2198 "io.m"
{		
	if (putc(Character, mercury_current_text_output->file) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	if (Character == '\n') {
		mercury_current_text_output->line_number++;
	}
	update_io(IO0, IO);
;}
#line 3392 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module30)
	init_entry(mercury__io__nl_3_0);
BEGIN_CODE

/* code for predicate 'nl'/3 in mode 0 */
Define_entry(mercury__io__nl_3_0);
	{
		Word	Stream;
		Char	Character;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Character = (Integer) 10;
		IO0 = r2;
#line 2292 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (putc(Character, stream->file) < 0) {
		mercury_output_error(stream);
	}
	if (Character == '\n') {
		stream->line_number++;
	}
	update_io(IO0, IO);
};}
#line 3426 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module31)
	init_entry(mercury__io__write_string_3_0);
BEGIN_CODE

/* code for predicate 'write_string'/3 in mode 0 */
Define_entry(mercury__io__write_string_3_0);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) r1;
		IO0 = r2;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 3452 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module32)
	init_entry(mercury__io__write_string_4_0);
BEGIN_CODE

/* code for predicate 'write_string'/4 in mode 0 */
Define_entry(mercury__io__write_string_4_0);
	{
		Word	Stream;
		String	Message;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Message = (String) r2;
		IO0 = r3;
#line 2285 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	mercury_print_string(stream, Message);
	update_io(IO0, IO);
};}
#line 3481 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module33)
	init_entry(mercury__io__write_strings_3_0);
BEGIN_CODE

/* code for predicate 'write_strings'/3 in mode 0 */
Define_entry(mercury__io__write_strings_3_0);
	incr_sp_push_msg(1, "io:write_strings/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 2383 "io.m"
{		
	Stream = (Word) mercury_current_text_output;
	update_io(IO0, IO);
;}
#line 3508 "io.c"
		r3 = Stream;
		r4 = IO;

	}
	r2 = r1;
	r1 = r3;
	r3 = r4;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__write_strings_4_0),
		ENTRY(mercury__io__write_strings_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module34)
	init_entry(mercury__io__write_strings_4_0);
	init_label(mercury__io__write_strings_4_0_i1001);
	init_label(mercury__io__write_strings_4_0_i3);
BEGIN_CODE

/* code for predicate 'write_strings'/4 in mode 0 */
Define_entry(mercury__io__write_strings_4_0);
	incr_sp_push_msg(1, "io:write_strings/4");
	detstackvar(1) = (Word) succip;
Define_label(mercury__io__write_strings_4_0_i1001);
	while (1) {
	if (((Integer) r2 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_strings_4_0_i3);
	{
		Word	Stream;
		String	Message;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Message = (String) const_field(mktag(1), r2, (Integer) 0);
		IO0 = r3;
#line 2285 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	mercury_print_string(stream, Message);
	update_io(IO0, IO);
};}
#line 3551 "io.c"
		r4 = IO;

	}
	r2 = const_field(mktag(1), r2, (Integer) 1);
	r3 = r4;
	succip = (Code *) detstackvar(1);
	/* continue */ } /* end while */
Define_label(mercury__io__write_strings_4_0_i3);
	r1 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module35)
	init_entry(mercury__io__write_char_3_0);
BEGIN_CODE

/* code for predicate 'write_char'/3 in mode 0 */
Define_entry(mercury__io__write_char_3_0);
	{
		Char	Character;
		Word	IO0;
		Word	IO;
		Character = r1;
		IO0 = r2;
#line 2198 "io.m"
{		
	if (putc(Character, mercury_current_text_output->file) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	if (Character == '\n') {
		mercury_current_text_output->line_number++;
	}
	update_io(IO0, IO);
;}
#line 3589 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module36)
	init_entry(mercury__io__write_char_4_0);
BEGIN_CODE

/* code for predicate 'write_char'/4 in mode 0 */
Define_entry(mercury__io__write_char_4_0);
	{
		Word	Stream;
		Char	Character;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Character = r2;
		IO0 = r3;
#line 2292 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (putc(Character, stream->file) < 0) {
		mercury_output_error(stream);
	}
	if (Character == '\n') {
		stream->line_number++;
	}
	update_io(IO0, IO);
};}
#line 3623 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module37)
	init_entry(mercury__io__write_int_3_0);
BEGIN_CODE

/* code for predicate 'write_int'/3 in mode 0 */
Define_entry(mercury__io__write_int_3_0);
	{
		Integer	Val;
		Word	IO0;
		Word	IO;
		Val = r1;
		IO0 = r2;
#line 2208 "io.m"
{		
	if (fprintf(mercury_current_text_output->file, "%ld", (long) Val) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	update_io(IO0, IO);
;}
#line 3651 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module38)
	init_entry(mercury__io__write_int_4_0);
BEGIN_CODE

/* code for predicate 'write_int'/4 in mode 0 */
Define_entry(mercury__io__write_int_4_0);
	{
		Word	Stream;
		Integer	Val;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Val = r2;
		IO0 = r3;
#line 2304 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (fprintf(stream->file, "%ld", (long) Val) < 0) {
		mercury_output_error(stream);
	}
	update_io(IO0, IO);
};}
#line 3682 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module39)
	init_entry(mercury__io__write_float_3_0);
BEGIN_CODE

/* code for predicate 'write_float'/3 in mode 0 */
Define_entry(mercury__io__write_float_3_0);
	{
		Float	Val;
		Word	IO0;
		Word	IO;
		Val = word_to_float(r1);
		IO0 = r2;
#line 2215 "io.m"
{		
	if (fprintf(mercury_current_text_output->file, "%#.15g", Val) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	update_io(IO0, IO);
;}
#line 3710 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module40)
	init_entry(mercury__io__write_float_4_0);
BEGIN_CODE

/* code for predicate 'write_float'/4 in mode 0 */
Define_entry(mercury__io__write_float_4_0);
	{
		Word	Stream;
		Float	Val;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Val = word_to_float(r2);
		IO0 = r3;
#line 2312 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (fprintf(stream->file, "%#.15g", Val) < 0) {
		mercury_output_error(stream);
	}
	update_io(IO0, IO);
};}
#line 3741 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE

Declare_entry(mercury__string__format_3_0);

BEGIN_MODULE(mercury__io_module41)
	init_entry(mercury__io__format_4_0);
	init_label(mercury__io__format_4_0_i2);
BEGIN_CODE

/* code for predicate 'format'/4 in mode 0 */
Define_entry(mercury__io__format_4_0);
	incr_sp_push_msg(3, "io:format/4");
	detstackvar(3) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r3;
#line 2383 "io.m"
{		
	Stream = (Word) mercury_current_text_output;
	update_io(IO0, IO);
;}
#line 3770 "io.c"
		r4 = Stream;
		r5 = IO;

	}
	detstackvar(1) = r4;
	detstackvar(2) = r5;
	call_localret(ENTRY(mercury__string__format_3_0),
		mercury__io__format_4_0_i2,
		ENTRY(mercury__io__format_4_0));
Define_label(mercury__io__format_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__format_4_0));
	{
		Word	Stream;
		String	Message;
		Word	IO0;
		Word	IO;
		Stream = detstackvar(1);
		Message = (String) r1;
		IO0 = detstackvar(2);
#line 2285 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	mercury_print_string(stream, Message);
	update_io(IO0, IO);
};}
#line 3796 "io.c"
		r2 = IO;

	}
	r1 = r2;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module42)
	init_entry(mercury__io__format_5_0);
	init_label(mercury__io__format_5_0_i2);
BEGIN_CODE

/* code for predicate 'format'/5 in mode 0 */
Define_entry(mercury__io__format_5_0);
	incr_sp_push_msg(3, "io:format/5");
	detstackvar(3) = (Word) succip;
	detstackvar(1) = r1;
	detstackvar(2) = r4;
	r1 = r2;
	r2 = r3;
	call_localret(ENTRY(mercury__string__format_3_0),
		mercury__io__format_5_0_i2,
		ENTRY(mercury__io__format_5_0));
Define_label(mercury__io__format_5_0_i2);
	update_prof_current_proc(LABEL(mercury__io__format_5_0));
	{
		Word	Stream;
		String	Message;
		Word	IO0;
		Word	IO;
		Stream = detstackvar(1);
		Message = (String) r1;
		IO0 = detstackvar(2);
#line 2285 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	mercury_print_string(stream, Message);
	update_io(IO0, IO);
};}
#line 3839 "io.c"
		r2 = IO;

	}
	r1 = r2;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module43)
	init_entry(mercury__io__write_many_3_0);
BEGIN_CODE

/* code for predicate 'write_many'/3 in mode 0 */
Define_entry(mercury__io__write_many_3_0);
	incr_sp_push_msg(1, "io:write_many/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 2383 "io.m"
{		
	Stream = (Word) mercury_current_text_output;
	update_io(IO0, IO);
;}
#line 3868 "io.c"
		r3 = Stream;
		r4 = IO;

	}
	r2 = r1;
	r1 = r3;
	r3 = r4;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__write_many_4_0),
		ENTRY(mercury__io__write_many_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module44)
	init_entry(mercury__io__write_many_4_0);
	init_label(mercury__io__write_many_4_0_i1004);
	init_label(mercury__io__write_many_4_0_i10);
	init_label(mercury__io__write_many_4_0_i8);
	init_label(mercury__io__write_many_4_0_i6);
	init_label(mercury__io__write_many_4_0_i3);
BEGIN_CODE

/* code for predicate 'write_many'/4 in mode 0 */
Define_entry(mercury__io__write_many_4_0);
	incr_sp_push_msg(1, "io:write_many/4");
	detstackvar(1) = (Word) succip;
Define_label(mercury__io__write_many_4_0_i1004);
	while (1) {
	if (((Integer) r2 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_many_4_0_i3);
	r4 = const_field(mktag(1), r2, (Integer) 0);
	if ((tag(r4) == mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__write_many_4_0_i6);
	if ((tag(r4) == mktag((Integer) 2)))
		GOTO_LABEL(mercury__io__write_many_4_0_i8);
	if ((tag(r4) == mktag((Integer) 3)))
		GOTO_LABEL(mercury__io__write_many_4_0_i10);
	{
		Word	Stream;
		Float	Val;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Val = word_to_float(const_field(mktag(0), r4, (Integer) 0));
		IO0 = r3;
#line 2312 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (fprintf(stream->file, "%#.15g", Val) < 0) {
		mercury_output_error(stream);
	}
	update_io(IO0, IO);
};}
#line 3923 "io.c"
		r5 = IO;

	}
	r2 = const_field(mktag(1), r2, (Integer) 1);
	r3 = r5;
	succip = (Code *) detstackvar(1);
	/* continue */ } /* end while */
Define_label(mercury__io__write_many_4_0_i10);
	{
		Word	Stream;
		Char	Character;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Character = const_field(mktag(3), r4, (Integer) 0);
		IO0 = r3;
#line 2292 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (putc(Character, stream->file) < 0) {
		mercury_output_error(stream);
	}
	if (Character == '\n') {
		stream->line_number++;
	}
	update_io(IO0, IO);
};}
#line 3951 "io.c"
		r5 = IO;

	}
	r2 = const_field(mktag(1), r2, (Integer) 1);
	r3 = r5;
	succip = (Code *) detstackvar(1);
	GOTO_LABEL(mercury__io__write_many_4_0_i1004);
Define_label(mercury__io__write_many_4_0_i8);
	{
		Word	Stream;
		String	Message;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Message = (String) const_field(mktag(2), r4, (Integer) 0);
		IO0 = r3;
#line 2285 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	mercury_print_string(stream, Message);
	update_io(IO0, IO);
};}
#line 3974 "io.c"
		r5 = IO;

	}
	r2 = const_field(mktag(1), r2, (Integer) 1);
	r3 = r5;
	succip = (Code *) detstackvar(1);
	GOTO_LABEL(mercury__io__write_many_4_0_i1004);
Define_label(mercury__io__write_many_4_0_i6);
	{
		Word	Stream;
		Integer	Val;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Val = const_field(mktag(1), r4, (Integer) 0);
		IO0 = r3;
#line 2304 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (fprintf(stream->file, "%ld", (long) Val) < 0) {
		mercury_output_error(stream);
	}
	update_io(IO0, IO);
};}
#line 3999 "io.c"
		r5 = IO;

	}
	r2 = const_field(mktag(1), r2, (Integer) 1);
	r3 = r5;
	succip = (Code *) detstackvar(1);
	GOTO_LABEL(mercury__io__write_many_4_0_i1004);
Define_label(mercury__io__write_many_4_0_i3);
	r1 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module45)
	init_entry(mercury__io__write_list_5_0);
BEGIN_CODE

/* code for predicate 'write_list'/5 in mode 0 */
Define_entry(mercury__io__write_list_5_0);
	r1 = r2;
	r2 = r3;
	r3 = r4;
	r4 = r5;
	tailcall(STATIC(mercury__io__write_list__ua10000_5_0),
		ENTRY(mercury__io__write_list_5_0));
END_MODULE


BEGIN_MODULE(mercury__io_module46)
	init_entry(mercury__io__write_list_6_0);
BEGIN_CODE

/* code for predicate 'write_list'/6 in mode 0 */
Define_entry(mercury__io__write_list_6_0);
	r1 = r2;
	r2 = r3;
	r3 = r4;
	r4 = r5;
	r5 = r6;
	tailcall(STATIC(mercury__io__write_list__ua10000_6_0),
		ENTRY(mercury__io__write_list_6_0));
END_MODULE


BEGIN_MODULE(mercury__io_module47)
	init_entry(mercury__io__flush_output_2_0);
BEGIN_CODE

/* code for predicate 'flush_output'/2 in mode 0 */
Define_entry(mercury__io__flush_output_2_0);
	{
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2236 "io.m"
{		
	if (fflush(mercury_current_text_output->file) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	update_io(IO0, IO);
;}
#line 4063 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module48)
	init_entry(mercury__io__flush_output_3_0);
BEGIN_CODE

/* code for predicate 'flush_output'/3 in mode 0 */
Define_entry(mercury__io__flush_output_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2335 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (fflush(stream->file) < 0) {
		mercury_output_error(stream);
	}
	update_io(IO0, IO);
};}
#line 4092 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module49)
	init_entry(mercury__io__see_4_0);
	init_label(mercury__io__see_4_0_i2);
	init_label(mercury__io__see_4_0_i4);
BEGIN_CODE

/* code for predicate 'see'/4 in mode 0 */
Define_entry(mercury__io__see_4_0);
	incr_sp_push_msg(1, "io:see/4");
	detstackvar(1) = (Word) succip;
	call_localret(STATIC(mercury__io__open_input_4_0),
		mercury__io__see_4_0_i2,
		ENTRY(mercury__io__see_4_0));
Define_label(mercury__io__see_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__see_4_0));
	if ((tag(r1) != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__see_4_0_i4);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = const_field(mktag(0), r1, (Integer) 0);
		IO0 = r2;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 4131 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r4;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__see_4_0_i4);
	r3 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = const_field(mktag(1), r3, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module50)
	init_entry(mercury__io__seen_2_0);
BEGIN_CODE

/* code for predicate 'seen'/2 in mode 0 */
Define_entry(mercury__io__seen_2_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2353 "io.m"
{		
	Stream = (Word) &mercury_stdin;
	update_io(IO0, IO);
;}
#line 4167 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r3;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 4185 "io.c"
		r1 = OutStream;
		r4 = IO;

	}
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r4;
#line 2501 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 4201 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE

Declare_entry(mercury__map__set_4_1);

BEGIN_MODULE(mercury__io_module51)
	init_entry(mercury__io__open_input_4_0);
	init_label(mercury__io__open_input_4_0_i7);
	init_label(mercury__io__open_input_4_0_i2);
BEGIN_CODE

/* code for predicate 'open_input'/4 in mode 0 */
Define_entry(mercury__io__open_input_4_0);
	incr_sp_push_msg(4, "io:open_input/4");
	detstackvar(4) = (Word) succip;
	{
		String	FileName;
		String	Mode;
		Integer	ResultCode;
		Word	Stream;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		Mode = (String) (Word) (const Word *) string_const("r", 1);
		IO0 = r2;
#line 2492 "io.m"
{		
	Stream = (Word) mercury_open(FileName, Mode);
	ResultCode = (Stream ? 0 : -1);
	update_io(IO0, IO);
;}
#line 4237 "io.c"
		r3 = ResultCode;
		r4 = Stream;
		r5 = IO;

	}
	if (((Integer) r3 == (Integer) -1))
		GOTO_LABEL(mercury__io__open_input_4_0_i2);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r5;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 4255 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	tag_incr_hp(detstackvar(1), mktag(0), (Integer) 1);
	field(mktag(0), detstackvar(1), (Integer) 0) = r4;
	detstackvar(3) = r2;
	r5 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__open_input_4_0_i7,
		ENTRY(mercury__io__open_input_4_0));
Define_label(mercury__io__open_input_4_0_i7);
	update_prof_current_proc(LABEL(mercury__io__open_input_4_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(3);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 4282 "io.c"
		r2 = IO;

	}
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__open_input_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_1);
	r2 = r5;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module52)
	init_entry(mercury__io__close_input_3_0);
BEGIN_CODE

/* code for predicate 'close_input'/3 in mode 0 */
Define_entry(mercury__io__close_input_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2501 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 4316 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module53)
	init_entry(mercury__io__input_stream_3_0);
BEGIN_CODE

/* code for predicate 'input_stream'/3 in mode 0 */
Define_entry(mercury__io__input_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 4341 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module54)
	init_entry(mercury__io__set_input_stream_4_0);
BEGIN_CODE

/* code for predicate 'set_input_stream'/4 in mode 0 */
Define_entry(mercury__io__set_input_stream_4_0);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r1;
		IO0 = r2;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 4371 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module55)
	init_entry(mercury__io__stdin_stream_3_0);
BEGIN_CODE

/* code for predicate 'stdin_stream'/3 in mode 0 */
Define_entry(mercury__io__stdin_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2353 "io.m"
{		
	Stream = (Word) &mercury_stdin;
	update_io(IO0, IO);
;}
#line 4398 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module56)
	init_entry(mercury__io__input_stream_name_3_0);
BEGIN_CODE

/* code for predicate 'input_stream_name'/3 in mode 0 */
Define_entry(mercury__io__input_stream_name_3_0);
	incr_sp_push_msg(1, "io:input_stream_name/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2378 "io.m"
{		
	Stream = (Word) mercury_current_text_input;
	update_io(IO0, IO);
;}
#line 4427 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__input_stream_name_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module57)
	init_entry(mercury__io__input_stream_name_4_0);
BEGIN_CODE

/* code for predicate 'input_stream_name'/4 in mode 0 */
Define_entry(mercury__io__input_stream_name_4_0);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__input_stream_name_4_0));
END_MODULE


BEGIN_MODULE(mercury__io_module58)
	init_entry(mercury__io__get_line_number_3_0);
BEGIN_CODE

/* code for predicate 'get_line_number'/3 in mode 0 */
Define_entry(mercury__io__get_line_number_3_0);
	{
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2398 "io.m"
{		
	LineNum = mercury_current_text_input->line_number;
	update_io(IO0, IO);
;}
#line 4468 "io.c"
		r2 = LineNum;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module59)
	init_entry(mercury__io__get_line_number_4_0);
BEGIN_CODE

/* code for predicate 'get_line_number'/4 in mode 0 */
Define_entry(mercury__io__get_line_number_4_0);
	{
		Word	Stream;
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2403 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	LineNum = stream->line_number;
	update_io(IO0, IO);
};}
#line 4498 "io.c"
		r3 = LineNum;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module60)
	init_entry(mercury__io__set_line_number_3_0);
BEGIN_CODE

/* code for predicate 'set_line_number'/3 in mode 0 */
Define_entry(mercury__io__set_line_number_3_0);
	{
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		LineNum = r1;
		IO0 = r2;
#line 2411 "io.m"
{		
	mercury_current_text_input->line_number = LineNum;
	update_io(IO0, IO);
;}
#line 4526 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module61)
	init_entry(mercury__io__set_line_number_4_0);
BEGIN_CODE

/* code for predicate 'set_line_number'/4 in mode 0 */
Define_entry(mercury__io__set_line_number_4_0);
	{
		Word	Stream;
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		Stream = r1;
		LineNum = r2;
		IO0 = r3;
#line 2416 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	stream->line_number = LineNum;
	update_io(IO0, IO);
};}
#line 4555 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module62)
	init_entry(mercury__io__tell_4_0);
	init_label(mercury__io__tell_4_0_i2);
	init_label(mercury__io__tell_4_0_i3);
BEGIN_CODE

/* code for predicate 'tell'/4 in mode 0 */
Define_entry(mercury__io__tell_4_0);
	incr_sp_push_msg(1, "io:tell/4");
	detstackvar(1) = (Word) succip;
	call_localret(STATIC(mercury__io__open_output_4_0),
		mercury__io__tell_4_0_i2,
		ENTRY(mercury__io__tell_4_0));
Define_label(mercury__io__tell_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__tell_4_0));
	if ((tag(r1) != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__tell_4_0_i3);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = const_field(mktag(0), r1, (Integer) 0);
		IO0 = r2;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 4594 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r4;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__tell_4_0_i3);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_2);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module63)
	init_entry(mercury__io__told_2_0);
BEGIN_CODE

/* code for predicate 'told'/2 in mode 0 */
Define_entry(mercury__io__told_2_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2358 "io.m"
{		
	Stream = (Word) &mercury_stdout;
	update_io(IO0, IO);
;}
#line 4628 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r3;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 4646 "io.c"
		r1 = OutStream;
		r4 = IO;

	}
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r4;
#line 2506 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 4662 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module64)
	init_entry(mercury__io__open_output_4_0);
	init_label(mercury__io__open_output_4_0_i7);
	init_label(mercury__io__open_output_4_0_i2);
BEGIN_CODE

/* code for predicate 'open_output'/4 in mode 0 */
Define_entry(mercury__io__open_output_4_0);
	incr_sp_push_msg(4, "io:open_output/4");
	detstackvar(4) = (Word) succip;
	{
		String	FileName;
		String	Mode;
		Integer	ResultCode;
		Word	Stream;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		Mode = (String) (Word) (const Word *) string_const("w", 1);
		IO0 = r2;
#line 2492 "io.m"
{		
	Stream = (Word) mercury_open(FileName, Mode);
	ResultCode = (Stream ? 0 : -1);
	update_io(IO0, IO);
;}
#line 4697 "io.c"
		r3 = ResultCode;
		r4 = Stream;
		r5 = IO;

	}
	if (((Integer) r3 == (Integer) -1))
		GOTO_LABEL(mercury__io__open_output_4_0_i2);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r5;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 4715 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	tag_incr_hp(detstackvar(1), mktag(0), (Integer) 1);
	field(mktag(0), detstackvar(1), (Integer) 0) = r4;
	detstackvar(3) = r2;
	r5 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__open_output_4_0_i7,
		ENTRY(mercury__io__open_output_4_0));
Define_label(mercury__io__open_output_4_0_i7);
	update_prof_current_proc(LABEL(mercury__io__open_output_4_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(3);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 4742 "io.c"
		r2 = IO;

	}
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__open_output_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_2);
	r2 = r5;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module65)
	init_entry(mercury__io__open_append_4_0);
	init_label(mercury__io__open_append_4_0_i7);
	init_label(mercury__io__open_append_4_0_i2);
BEGIN_CODE

/* code for predicate 'open_append'/4 in mode 0 */
Define_entry(mercury__io__open_append_4_0);
	incr_sp_push_msg(4, "io:open_append/4");
	detstackvar(4) = (Word) succip;
	{
		String	FileName;
		String	Mode;
		Integer	ResultCode;
		Word	Stream;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		Mode = (String) (Word) (const Word *) string_const("a", 1);
		IO0 = r2;
#line 2492 "io.m"
{		
	Stream = (Word) mercury_open(FileName, Mode);
	ResultCode = (Stream ? 0 : -1);
	update_io(IO0, IO);
;}
#line 4785 "io.c"
		r3 = ResultCode;
		r4 = Stream;
		r5 = IO;

	}
	if (((Integer) r3 == (Integer) -1))
		GOTO_LABEL(mercury__io__open_append_4_0_i2);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r5;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 4803 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	tag_incr_hp(detstackvar(1), mktag(0), (Integer) 1);
	field(mktag(0), detstackvar(1), (Integer) 0) = r4;
	detstackvar(3) = r2;
	r5 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__open_append_4_0_i7,
		ENTRY(mercury__io__open_append_4_0));
Define_label(mercury__io__open_append_4_0_i7);
	update_prof_current_proc(LABEL(mercury__io__open_append_4_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(3);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 4830 "io.c"
		r2 = IO;

	}
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__open_append_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_3);
	r2 = r5;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module66)
	init_entry(mercury__io__close_output_3_0);
BEGIN_CODE

/* code for predicate 'close_output'/3 in mode 0 */
Define_entry(mercury__io__close_output_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2506 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 4864 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module67)
	init_entry(mercury__io__output_stream_3_0);
BEGIN_CODE

/* code for predicate 'output_stream'/3 in mode 0 */
Define_entry(mercury__io__output_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2383 "io.m"
{		
	Stream = (Word) mercury_current_text_output;
	update_io(IO0, IO);
;}
#line 4889 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module68)
	init_entry(mercury__io__set_output_stream_4_0);
BEGIN_CODE

/* code for predicate 'set_output_stream'/4 in mode 0 */
Define_entry(mercury__io__set_output_stream_4_0);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r1;
		IO0 = r2;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 4919 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module69)
	init_entry(mercury__io__stdout_stream_3_0);
BEGIN_CODE

/* code for predicate 'stdout_stream'/3 in mode 0 */
Define_entry(mercury__io__stdout_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2358 "io.m"
{		
	Stream = (Word) &mercury_stdout;
	update_io(IO0, IO);
;}
#line 4946 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module70)
	init_entry(mercury__io__stderr_stream_3_0);
BEGIN_CODE

/* code for predicate 'stderr_stream'/3 in mode 0 */
Define_entry(mercury__io__stderr_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2363 "io.m"
{		
	Stream = (Word) &mercury_stderr;
	update_io(IO0, IO);
;}
#line 4973 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module71)
	init_entry(mercury__io__output_stream_name_3_0);
BEGIN_CODE

/* code for predicate 'output_stream_name'/3 in mode 0 */
Define_entry(mercury__io__output_stream_name_3_0);
	incr_sp_push_msg(1, "io:output_stream_name/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2383 "io.m"
{		
	Stream = (Word) mercury_current_text_output;
	update_io(IO0, IO);
;}
#line 5002 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__output_stream_name_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module72)
	init_entry(mercury__io__output_stream_name_4_0);
BEGIN_CODE

/* code for predicate 'output_stream_name'/4 in mode 0 */
Define_entry(mercury__io__output_stream_name_4_0);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__output_stream_name_4_0));
END_MODULE


BEGIN_MODULE(mercury__io_module73)
	init_entry(mercury__io__get_output_line_number_3_0);
BEGIN_CODE

/* code for predicate 'get_output_line_number'/3 in mode 0 */
Define_entry(mercury__io__get_output_line_number_3_0);
	{
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2424 "io.m"
{		
	LineNum = mercury_current_text_output->line_number;
	update_io(IO0, IO);
;}
#line 5043 "io.c"
		r2 = LineNum;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module74)
	init_entry(mercury__io__get_output_line_number_4_0);
BEGIN_CODE

/* code for predicate 'get_output_line_number'/4 in mode 0 */
Define_entry(mercury__io__get_output_line_number_4_0);
	{
		Word	Stream;
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2429 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	LineNum = stream->line_number;
	update_io(IO0, IO);
};}
#line 5073 "io.c"
		r3 = LineNum;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module75)
	init_entry(mercury__io__set_output_line_number_3_0);
BEGIN_CODE

/* code for predicate 'set_output_line_number'/3 in mode 0 */
Define_entry(mercury__io__set_output_line_number_3_0);
	{
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		LineNum = r1;
		IO0 = r2;
#line 2437 "io.m"
{		
	mercury_current_text_output->line_number = LineNum;
	update_io(IO0, IO);
;}
#line 5101 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module76)
	init_entry(mercury__io__set_output_line_number_4_0);
BEGIN_CODE

/* code for predicate 'set_output_line_number'/4 in mode 0 */
Define_entry(mercury__io__set_output_line_number_4_0);
	{
		Word	Stream;
		Integer	LineNum;
		Word	IO0;
		Word	IO;
		Stream = r1;
		LineNum = r2;
		IO0 = r3;
#line 2442 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	stream->line_number = LineNum;
	update_io(IO0, IO);
};}
#line 5130 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module77)
	init_entry(mercury__io__read_binary_3_0);
	init_label(mercury__io__read_binary_3_0_i2);
	init_label(mercury__io__read_binary_3_0_i5);
	init_label(mercury__io__read_binary_3_0_i6);
BEGIN_CODE

/* code for predicate 'read_binary'/3 in mode 0 */
Define_entry(mercury__io__read_binary_3_0);
	incr_sp_push_msg(2, "io:read_binary/3");
	detstackvar(2) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 2388 "io.m"
{		
	Stream = (Word) mercury_current_binary_input;
	update_io(IO0, IO);
;}
#line 5160 "io.c"
		r3 = Stream;
		r4 = IO;

	}
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r3;
		IO0 = r4;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5178 "io.c"
		r2 = OutStream;
		r5 = IO;

	}
	detstackvar(1) = r2;
	r2 = r5;
	call_localret(STATIC(mercury__io__read_3_0),
		mercury__io__read_binary_3_0_i2,
		ENTRY(mercury__io__read_binary_3_0));
Define_label(mercury__io__read_binary_3_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_binary_3_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r2;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5203 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r2 = tag(r1);
	if ((r2 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_binary_3_0_i5);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
Define_label(mercury__io__read_binary_3_0_i5);
	if ((r2 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_binary_3_0_i6);
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = const_field(mktag(1), r2, (Integer) 0);
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
Define_label(mercury__io__read_binary_3_0_i6);
	r2 = r1;
	tag_incr_hp(r1, mktag(2), (Integer) 1);
	field(mktag(2), r1, (Integer) 0) = const_field(mktag(2), r2, (Integer) 0);
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module78)
	init_entry(mercury__io__read_binary_4_0);
	init_label(mercury__io__read_binary_4_0_i2);
BEGIN_CODE

/* code for predicate 'read_binary'/4 in mode 0 */
Define_entry(mercury__io__read_binary_4_0);
	incr_sp_push_msg(2, "io:read_binary/4");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r3;
#line 2469 "io.m"
{		
	OutStream = (Word) mercury_current_binary_input;
	mercury_current_binary_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5259 "io.c"
		r4 = OutStream;
		r5 = IO;

	}
	detstackvar(1) = r4;
	r2 = r5;
	call_localret(STATIC(mercury__io__read_binary_3_0),
		mercury__io__read_binary_4_0_i2,
		ENTRY(mercury__io__read_binary_4_0));
Define_label(mercury__io__read_binary_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_binary_4_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r2;
#line 2469 "io.m"
{		
	OutStream = (Word) mercury_current_binary_input;
	mercury_current_binary_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5284 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module79)
	init_entry(mercury__io__read_byte_3_0);
BEGIN_CODE

/* code for predicate 'read_byte'/3 in mode 0 */
Define_entry(mercury__io__read_byte_3_0);
	incr_sp_push_msg(1, "io:read_byte/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2388 "io.m"
{		
	Stream = (Word) mercury_current_binary_input;
	update_io(IO0, IO);
;}
#line 5314 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__read_byte_4_0),
		ENTRY(mercury__io__read_byte_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module80)
	init_entry(mercury__io__read_byte_4_0);
	init_label(mercury__io__read_byte_4_0_i2);
	init_label(mercury__io__read_byte_4_0_i5);
BEGIN_CODE

/* code for predicate 'read_byte'/4 in mode 0 */
Define_entry(mercury__io__read_byte_4_0);
	{
		Word	File;
		Integer	CharCode;
		Word	IO0;
		Word	IO;
		File = r1;
		IO0 = r2;
#line 2162 "io.m"
{		
	CharCode = mercury_getc((MercuryFile*)File);
	update_io(IO0, IO);
;}
#line 5348 "io.c"
		r3 = CharCode;
		r4 = IO;

	}
	if (((Integer) r3 != (Integer) -1))
		GOTO_LABEL(mercury__io__read_byte_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r4;
	proceed();
Define_label(mercury__io__read_byte_4_0_i2);
	if (((Integer) r3 != (Integer) -2))
		GOTO_LABEL(mercury__io__read_byte_4_0_i5);
	r1 = (Word) (const Word *) mkword(mktag(2), (Word) (const Word *) &mercury_data_io__common_0);
	r2 = r4;
	proceed();
Define_label(mercury__io__read_byte_4_0_i5);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module81)
	init_entry(mercury__io__read_binary_file_3_0);
BEGIN_CODE

/* code for predicate 'read_binary_file'/3 in mode 0 */
Define_entry(mercury__io__read_binary_file_3_0);
	incr_sp_push_msg(1, "io:read_binary_file/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2388 "io.m"
{		
	Stream = (Word) mercury_current_binary_input;
	update_io(IO0, IO);
;}
#line 5390 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__read_binary_file_2_5_0),
		ENTRY(mercury__io__read_binary_file_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module82)
	init_entry(mercury__io__read_binary_file_4_0);
BEGIN_CODE

/* code for predicate 'read_binary_file'/4 in mode 0 */
Define_entry(mercury__io__read_binary_file_4_0);
	r3 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	tailcall(STATIC(mercury__io__read_binary_file_2_5_0),
		ENTRY(mercury__io__read_binary_file_4_0));
END_MODULE


BEGIN_MODULE(mercury__io_module83)
	init_entry(mercury__io__putback_byte_3_0);
BEGIN_CODE

/* code for predicate 'putback_byte'/3 in mode 0 */
Define_entry(mercury__io__putback_byte_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 2388 "io.m"
{		
	Stream = (Word) mercury_current_binary_input;
	update_io(IO0, IO);
;}
#line 5433 "io.c"
		r3 = Stream;
		r4 = IO;

	}
	{
		Word	File;
		Integer	Character;
		Word	IO0;
		Word	IO;
		File = r3;
		Character = r1;
		IO0 = r4;
#line 2181 "io.m"
{		{
	MercuryFile* mf = (MercuryFile *)File;
	/* XXX should work even if ungetc() fails */
	if (ungetc(Character, mf->file) == EOF) {
		fatal_error("io__putback_byte: ungetc failed");
	}
	update_io(IO0, IO);
};}
#line 5455 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module84)
	init_entry(mercury__io__putback_byte_4_0);
BEGIN_CODE

/* code for predicate 'putback_byte'/4 in mode 0 */
Define_entry(mercury__io__putback_byte_4_0);
	{
		Word	File;
		Integer	Character;
		Word	IO0;
		Word	IO;
		File = r1;
		Character = r2;
		IO0 = r3;
#line 2181 "io.m"
{		{
	MercuryFile* mf = (MercuryFile *)File;
	/* XXX should work even if ungetc() fails */
	if (ungetc(Character, mf->file) == EOF) {
		fatal_error("io__putback_byte: ungetc failed");
	}
	update_io(IO0, IO);
};}
#line 5487 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module85)
	init_entry(mercury__io__write_binary_3_0);
	init_label(mercury__io__write_binary_3_0_i2);
BEGIN_CODE

/* code for predicate 'write_binary'/3 in mode 0 */
Define_entry(mercury__io__write_binary_3_0);
	incr_sp_push_msg(3, "io:write_binary/3");
	detstackvar(3) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r3;
#line 2393 "io.m"
{		
	Stream = (Word) mercury_current_binary_output;
	update_io(IO0, IO);
;}
#line 5515 "io.c"
		r4 = Stream;
		r5 = IO;

	}
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r4;
		IO0 = r5;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5533 "io.c"
		r3 = OutStream;
		r6 = IO;

	}
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 5549 "io.c"
		r5 = Univ;

	}
	detstackvar(1) = r4;
	detstackvar(2) = r3;
	r1 = r5;
	r2 = (Integer) 1201;
	r3 = r6;
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_binary_3_0_i2,
		ENTRY(mercury__io__write_binary_3_0));
Define_label(mercury__io__write_binary_3_0_i2);
	update_prof_current_proc(LABEL(mercury__io__write_binary_3_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(2);
		IO0 = r1;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5576 "io.c"
		r2 = OutStream;
		r3 = IO;

	}
	{
		Word	Stream;
		String	Message;
		Word	IO0;
		Word	IO;
		Stream = detstackvar(1);
		Message = (String) (Word) (const Word *) string_const(".\n", 2);
		IO0 = r3;
#line 2285 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	mercury_print_string(stream, Message);
	update_io(IO0, IO);
};}
#line 5595 "io.c"
		r1 = IO;

	}
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module86)
	init_entry(mercury__io__write_binary_4_0);
	init_label(mercury__io__write_binary_4_0_i2);
BEGIN_CODE

/* code for predicate 'write_binary'/4 in mode 0 */
Define_entry(mercury__io__write_binary_4_0);
	incr_sp_push_msg(2, "io:write_binary/4");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r4;
#line 2478 "io.m"
{		
	OutStream = (Word) mercury_current_binary_output;
	mercury_current_binary_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5627 "io.c"
		r5 = OutStream;
		r6 = IO;

	}
	detstackvar(1) = r5;
	r2 = r3;
	r3 = r6;
	call_localret(STATIC(mercury__io__write_binary_3_0),
		mercury__io__write_binary_4_0_i2,
		ENTRY(mercury__io__write_binary_4_0));
Define_label(mercury__io__write_binary_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__write_binary_4_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r1;
#line 2478 "io.m"
{		
	OutStream = (Word) mercury_current_binary_output;
	mercury_current_binary_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5653 "io.c"
		r2 = OutStream;
		r3 = IO;

	}
	r1 = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module87)
	init_entry(mercury__io__write_byte_3_0);
BEGIN_CODE

/* code for predicate 'write_byte'/3 in mode 0 */
Define_entry(mercury__io__write_byte_3_0);
	{
		Integer	Byte;
		Word	IO0;
		Word	IO;
		Byte = r1;
		IO0 = r2;
#line 2222 "io.m"
{		
	/* call putc with a strictly non-negative byte-sized integer */
	if (putc((int) ((unsigned char) Byte),
			mercury_current_binary_output->file) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	update_io(IO0, IO);
;}
#line 5686 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module88)
	init_entry(mercury__io__write_byte_4_0);
BEGIN_CODE

/* code for predicate 'write_byte'/4 in mode 0 */
Define_entry(mercury__io__write_byte_4_0);
	{
		Word	Stream;
		Integer	Byte;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Byte = r2;
		IO0 = r3;
#line 2320 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	/* call putc with a strictly non-negative byte-sized integer */
	if (putc((int) ((unsigned char) Byte), stream->file) < 0) {
		mercury_output_error(stream);
	}
	update_io(IO0, IO);
};}
#line 5718 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module89)
	init_entry(mercury__io__write_bytes_3_0);
BEGIN_CODE

/* code for predicate 'write_bytes'/3 in mode 0 */
Define_entry(mercury__io__write_bytes_3_0);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) r1;
		IO0 = r2;
#line 2231 "io.m"
{		{
	mercury_print_binary_string(mercury_current_binary_output, Message);
	update_io(IO0, IO);
};}
#line 5744 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module90)
	init_entry(mercury__io__write_bytes_4_0);
BEGIN_CODE

/* code for predicate 'write_bytes'/4 in mode 0 */
Define_entry(mercury__io__write_bytes_4_0);
	{
		Word	Stream;
		String	Message;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Message = (String) r2;
		IO0 = r3;
#line 2329 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	mercury_print_binary_string(stream, Message);
	update_io(IO0, IO);
};}
#line 5773 "io.c"
		r4 = IO;

	}
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module91)
	init_entry(mercury__io__flush_binary_output_2_0);
BEGIN_CODE

/* code for predicate 'flush_binary_output'/2 in mode 0 */
Define_entry(mercury__io__flush_binary_output_2_0);
	{
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2243 "io.m"
{		
	if (fflush(mercury_current_binary_output->file) < 0) {
		mercury_output_error(mercury_current_binary_output);
	}
	update_io(IO0, IO);
;}
#line 5799 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module92)
	init_entry(mercury__io__flush_binary_output_3_0);
BEGIN_CODE

/* code for predicate 'flush_binary_output'/3 in mode 0 */
Define_entry(mercury__io__flush_binary_output_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2343 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	if (fflush(stream->file) < 0) {
		mercury_output_error(stream);
	}
	update_io(IO0, IO);
};}
#line 5828 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module93)
	init_entry(mercury__io__seek_binary_5_0);
	init_label(mercury__io__seek_binary_5_0_i3);
	init_label(mercury__io__seek_binary_5_0_i4);
	init_label(mercury__io__seek_binary_5_0_i2);
BEGIN_CODE

/* code for predicate 'seek_binary'/5 in mode 0 */
Define_entry(mercury__io__seek_binary_5_0);
	if (((Integer) r2 != (Integer) 0))
		GOTO_LABEL(mercury__io__seek_binary_5_0_i3);
	r2 = r3;
	r3 = r4;
	r4 = (Integer) 0;
	GOTO_LABEL(mercury__io__seek_binary_5_0_i2);
Define_label(mercury__io__seek_binary_5_0_i3);
	if (((Integer) r2 != (Integer) 1))
		GOTO_LABEL(mercury__io__seek_binary_5_0_i4);
	r2 = r3;
	r3 = r4;
	r4 = (Integer) 1;
	GOTO_LABEL(mercury__io__seek_binary_5_0_i2);
Define_label(mercury__io__seek_binary_5_0_i4);
	r2 = r3;
	r3 = r4;
	r4 = (Integer) 2;
Define_label(mercury__io__seek_binary_5_0_i2);
	{
		Word	Stream;
		Integer	Flag;
		Integer	Off;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Flag = r4;
		Off = r2;
		IO0 = r3;
#line 2265 "io.m"
{		{
	static const int seek_flags[] = { SEEK_SET, SEEK_CUR, SEEK_END };
	MercuryFile *stream = (MercuryFile *) Stream;
	fseek(stream->file, Off, seek_flags[Flag]);
	IO = IO0;
};}
#line 5881 "io.c"
		r5 = IO;

	}
	r1 = r5;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module94)
	init_entry(mercury__io__binary_stream_offset_4_0);
BEGIN_CODE

/* code for predicate 'binary_stream_offset'/4 in mode 0 */
Define_entry(mercury__io__binary_stream_offset_4_0);
	{
		Word	Stream;
		Integer	Offset;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2274 "io.m"
{		{
	MercuryFile *stream = (MercuryFile *) Stream;
	Offset = ftell(stream->file);
	IO = IO0;
};}
#line 5909 "io.c"
		r3 = Offset;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module95)
	init_entry(mercury__io__see_binary_4_0);
	init_label(mercury__io__see_binary_4_0_i2);
	init_label(mercury__io__see_binary_4_0_i4);
BEGIN_CODE

/* code for predicate 'see_binary'/4 in mode 0 */
Define_entry(mercury__io__see_binary_4_0);
	incr_sp_push_msg(1, "io:see_binary/4");
	detstackvar(1) = (Word) succip;
	call_localret(STATIC(mercury__io__open_binary_input_4_0),
		mercury__io__see_binary_4_0_i2,
		ENTRY(mercury__io__see_binary_4_0));
Define_label(mercury__io__see_binary_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__see_binary_4_0));
	if ((tag(r1) != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__see_binary_4_0_i4);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = const_field(mktag(0), r1, (Integer) 0);
		IO0 = r2;
#line 2469 "io.m"
{		
	OutStream = (Word) mercury_current_binary_input;
	mercury_current_binary_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 5950 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r4;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__see_binary_4_0_i4);
	r3 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = const_field(mktag(1), r3, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module96)
	init_entry(mercury__io__seen_binary_2_0);
BEGIN_CODE

/* code for predicate 'seen_binary'/2 in mode 0 */
Define_entry(mercury__io__seen_binary_2_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2368 "io.m"
{		
	Stream = (Word) &mercury_stdin;
	update_io(IO0, IO);
;}
#line 5986 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r3;
#line 2469 "io.m"
{		
	OutStream = (Word) mercury_current_binary_input;
	mercury_current_binary_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 6004 "io.c"
		r1 = OutStream;
		r4 = IO;

	}
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r4;
#line 2511 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 6020 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module97)
	init_entry(mercury__io__open_binary_input_4_0);
	init_label(mercury__io__open_binary_input_4_0_i7);
	init_label(mercury__io__open_binary_input_4_0_i2);
BEGIN_CODE

/* code for predicate 'open_binary_input'/4 in mode 0 */
Define_entry(mercury__io__open_binary_input_4_0);
	incr_sp_push_msg(4, "io:open_binary_input/4");
	detstackvar(4) = (Word) succip;
	{
		String	FileName;
		String	Mode;
		Integer	ResultCode;
		Word	Stream;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		Mode = (String) (Word) (const Word *) string_const("rb", 2);
		IO0 = r2;
#line 2492 "io.m"
{		
	Stream = (Word) mercury_open(FileName, Mode);
	ResultCode = (Stream ? 0 : -1);
	update_io(IO0, IO);
;}
#line 6055 "io.c"
		r3 = ResultCode;
		r4 = Stream;
		r5 = IO;

	}
	if (((Integer) r3 == (Integer) -1))
		GOTO_LABEL(mercury__io__open_binary_input_4_0_i2);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r5;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 6073 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	tag_incr_hp(detstackvar(1), mktag(0), (Integer) 1);
	field(mktag(0), detstackvar(1), (Integer) 0) = r4;
	detstackvar(3) = r2;
	r5 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__open_binary_input_4_0_i7,
		ENTRY(mercury__io__open_binary_input_4_0));
Define_label(mercury__io__open_binary_input_4_0_i7);
	update_prof_current_proc(LABEL(mercury__io__open_binary_input_4_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(3);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 6100 "io.c"
		r2 = IO;

	}
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__open_binary_input_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_1);
	r2 = r5;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module98)
	init_entry(mercury__io__close_binary_input_3_0);
BEGIN_CODE

/* code for predicate 'close_binary_input'/3 in mode 0 */
Define_entry(mercury__io__close_binary_input_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2511 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 6134 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module99)
	init_entry(mercury__io__binary_input_stream_3_0);
BEGIN_CODE

/* code for predicate 'binary_input_stream'/3 in mode 0 */
Define_entry(mercury__io__binary_input_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2388 "io.m"
{		
	Stream = (Word) mercury_current_binary_input;
	update_io(IO0, IO);
;}
#line 6159 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module100)
	init_entry(mercury__io__set_binary_input_stream_4_0);
BEGIN_CODE

/* code for predicate 'set_binary_input_stream'/4 in mode 0 */
Define_entry(mercury__io__set_binary_input_stream_4_0);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r1;
		IO0 = r2;
#line 2469 "io.m"
{		
	OutStream = (Word) mercury_current_binary_input;
	mercury_current_binary_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 6189 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module101)
	init_entry(mercury__io__stdin_binary_stream_3_0);
BEGIN_CODE

/* code for predicate 'stdin_binary_stream'/3 in mode 0 */
Define_entry(mercury__io__stdin_binary_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2368 "io.m"
{		
	Stream = (Word) &mercury_stdin;
	update_io(IO0, IO);
;}
#line 6216 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module102)
	init_entry(mercury__io__binary_input_stream_name_3_0);
BEGIN_CODE

/* code for predicate 'binary_input_stream_name'/3 in mode 0 */
Define_entry(mercury__io__binary_input_stream_name_3_0);
	incr_sp_push_msg(1, "io:binary_input_stream_name/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2388 "io.m"
{		
	Stream = (Word) mercury_current_binary_input;
	update_io(IO0, IO);
;}
#line 6245 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__binary_input_stream_name_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module103)
	init_entry(mercury__io__binary_input_stream_name_4_0);
BEGIN_CODE

/* code for predicate 'binary_input_stream_name'/4 in mode 0 */
Define_entry(mercury__io__binary_input_stream_name_4_0);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__binary_input_stream_name_4_0));
END_MODULE


BEGIN_MODULE(mercury__io_module104)
	init_entry(mercury__io__tell_binary_4_0);
	init_label(mercury__io__tell_binary_4_0_i2);
	init_label(mercury__io__tell_binary_4_0_i3);
BEGIN_CODE

/* code for predicate 'tell_binary'/4 in mode 0 */
Define_entry(mercury__io__tell_binary_4_0);
	incr_sp_push_msg(1, "io:tell_binary/4");
	detstackvar(1) = (Word) succip;
	call_localret(STATIC(mercury__io__open_binary_output_4_0),
		mercury__io__tell_binary_4_0_i2,
		ENTRY(mercury__io__tell_binary_4_0));
Define_label(mercury__io__tell_binary_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__tell_binary_4_0));
	if ((tag(r1) != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__tell_binary_4_0_i3);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = const_field(mktag(0), r1, (Integer) 0);
		IO0 = r2;
#line 2478 "io.m"
{		
	OutStream = (Word) mercury_current_binary_output;
	mercury_current_binary_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 6300 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r4;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__tell_binary_4_0_i3);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_2);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module105)
	init_entry(mercury__io__told_binary_2_0);
BEGIN_CODE

/* code for predicate 'told_binary'/2 in mode 0 */
Define_entry(mercury__io__told_binary_2_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2373 "io.m"
{		
	Stream = (Word) &mercury_stdout;
	update_io(IO0, IO);
;}
#line 6334 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r3;
#line 2478 "io.m"
{		
	OutStream = (Word) mercury_current_binary_output;
	mercury_current_binary_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 6352 "io.c"
		r1 = OutStream;
		r4 = IO;

	}
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r4;
#line 2516 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 6368 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module106)
	init_entry(mercury__io__open_binary_output_4_0);
	init_label(mercury__io__open_binary_output_4_0_i7);
	init_label(mercury__io__open_binary_output_4_0_i2);
BEGIN_CODE

/* code for predicate 'open_binary_output'/4 in mode 0 */
Define_entry(mercury__io__open_binary_output_4_0);
	incr_sp_push_msg(4, "io:open_binary_output/4");
	detstackvar(4) = (Word) succip;
	{
		String	FileName;
		String	Mode;
		Integer	ResultCode;
		Word	Stream;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		Mode = (String) (Word) (const Word *) string_const("wb", 2);
		IO0 = r2;
#line 2492 "io.m"
{		
	Stream = (Word) mercury_open(FileName, Mode);
	ResultCode = (Stream ? 0 : -1);
	update_io(IO0, IO);
;}
#line 6403 "io.c"
		r3 = ResultCode;
		r4 = Stream;
		r5 = IO;

	}
	if (((Integer) r3 == (Integer) -1))
		GOTO_LABEL(mercury__io__open_binary_output_4_0_i2);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r5;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 6421 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	tag_incr_hp(detstackvar(1), mktag(0), (Integer) 1);
	field(mktag(0), detstackvar(1), (Integer) 0) = r4;
	detstackvar(3) = r2;
	r5 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__open_binary_output_4_0_i7,
		ENTRY(mercury__io__open_binary_output_4_0));
Define_label(mercury__io__open_binary_output_4_0_i7);
	update_prof_current_proc(LABEL(mercury__io__open_binary_output_4_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(3);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 6448 "io.c"
		r2 = IO;

	}
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__open_binary_output_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_2);
	r2 = r5;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module107)
	init_entry(mercury__io__open_binary_append_4_0);
	init_label(mercury__io__open_binary_append_4_0_i7);
	init_label(mercury__io__open_binary_append_4_0_i2);
BEGIN_CODE

/* code for predicate 'open_binary_append'/4 in mode 0 */
Define_entry(mercury__io__open_binary_append_4_0);
	incr_sp_push_msg(4, "io:open_binary_append/4");
	detstackvar(4) = (Word) succip;
	{
		String	FileName;
		String	Mode;
		Integer	ResultCode;
		Word	Stream;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		Mode = (String) (Word) (const Word *) string_const("ab", 2);
		IO0 = r2;
#line 2492 "io.m"
{		
	Stream = (Word) mercury_open(FileName, Mode);
	ResultCode = (Stream ? 0 : -1);
	update_io(IO0, IO);
;}
#line 6491 "io.c"
		r3 = ResultCode;
		r4 = Stream;
		r5 = IO;

	}
	if (((Integer) r3 == (Integer) -1))
		GOTO_LABEL(mercury__io__open_binary_append_4_0_i2);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r5;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 6509 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	tag_incr_hp(detstackvar(1), mktag(0), (Integer) 1);
	field(mktag(0), detstackvar(1), (Integer) 0) = r4;
	detstackvar(3) = r2;
	r5 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__open_binary_append_4_0_i7,
		ENTRY(mercury__io__open_binary_append_4_0));
Define_label(mercury__io__open_binary_append_4_0_i7);
	update_prof_current_proc(LABEL(mercury__io__open_binary_append_4_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(3);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 6536 "io.c"
		r2 = IO;

	}
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__open_binary_append_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_3);
	r2 = r5;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module108)
	init_entry(mercury__io__close_binary_output_3_0);
BEGIN_CODE

/* code for predicate 'close_binary_output'/3 in mode 0 */
Define_entry(mercury__io__close_binary_output_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		Stream = r1;
		IO0 = r2;
#line 2516 "io.m"
{		
	mercury_close((MercuryFile*)Stream);
	update_io(IO0, IO);
;}
#line 6570 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module109)
	init_entry(mercury__io__binary_output_stream_3_0);
BEGIN_CODE

/* code for predicate 'binary_output_stream'/3 in mode 0 */
Define_entry(mercury__io__binary_output_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2393 "io.m"
{		
	Stream = (Word) mercury_current_binary_output;
	update_io(IO0, IO);
;}
#line 6595 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module110)
	init_entry(mercury__io__stdout_binary_stream_3_0);
BEGIN_CODE

/* code for predicate 'stdout_binary_stream'/3 in mode 0 */
Define_entry(mercury__io__stdout_binary_stream_3_0);
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2373 "io.m"
{		
	Stream = (Word) &mercury_stdout;
	update_io(IO0, IO);
;}
#line 6622 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module111)
	init_entry(mercury__io__set_binary_output_stream_4_0);
BEGIN_CODE

/* code for predicate 'set_binary_output_stream'/4 in mode 0 */
Define_entry(mercury__io__set_binary_output_stream_4_0);
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r1;
		IO0 = r2;
#line 2478 "io.m"
{		
	OutStream = (Word) mercury_current_binary_output;
	mercury_current_binary_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 6652 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module112)
	init_entry(mercury__io__binary_output_stream_name_3_0);
BEGIN_CODE

/* code for predicate 'binary_output_stream_name'/3 in mode 0 */
Define_entry(mercury__io__binary_output_stream_name_3_0);
	incr_sp_push_msg(1, "io:binary_output_stream_name/3");
	detstackvar(1) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2393 "io.m"
{		
	Stream = (Word) mercury_current_binary_output;
	update_io(IO0, IO);
;}
#line 6681 "io.c"
		r2 = Stream;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__binary_output_stream_name_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module113)
	init_entry(mercury__io__binary_output_stream_name_4_0);
BEGIN_CODE

/* code for predicate 'binary_output_stream_name'/4 in mode 0 */
Define_entry(mercury__io__binary_output_stream_name_4_0);
	tailcall(STATIC(mercury__io__stream_name_4_0),
		ENTRY(mercury__io__binary_output_stream_name_4_0));
END_MODULE


BEGIN_MODULE(mercury__io_module114)
	init_entry(mercury__io__progname_4_0);
BEGIN_CODE

/* code for predicate 'progname'/4 in mode 0 */
Define_entry(mercury__io__progname_4_0);
	{
		String	DefaultProgname;
		String	PrognameOut;
		Word	IO0;
		Word	IO;
		DefaultProgname = (String) r1;
		IO0 = r2;
#line 2523 "io.m"
{		
	if (progname) {
		/* The silly casting below is needed to avoid
		   a gcc warning about casting away const.
		   PrognameOut is of type `String' (char *);
		   it should be of type `ConstString' (const char *),
		   but fixing that requires a fair bit of work
		   on the compiler.  */
		make_aligned_string(LVALUE_CAST(ConstString, PrognameOut),
			progname);
	} else {
		PrognameOut = DefaultProgname;
	}
	update_io(IO0, IO);
;}
#line 6735 "io.c"
		r3 = (Word) PrognameOut;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE

Declare_entry(mercury__dir__split_name_3_0);

BEGIN_MODULE(mercury__io_module115)
	init_entry(mercury__io__progname_base_4_0);
	init_label(mercury__io__progname_base_4_0_i2);
BEGIN_CODE

/* code for predicate 'progname_base'/4 in mode 0 */
Define_entry(mercury__io__progname_base_4_0);
	incr_sp_push_msg(2, "io:progname_base/4");
	detstackvar(2) = (Word) succip;
	{
		String	DefaultProgname;
		String	PrognameOut;
		Word	IO0;
		Word	IO;
		DefaultProgname = (String) r1;
		IO0 = r2;
#line 2523 "io.m"
{		
	if (progname) {
		/* The silly casting below is needed to avoid
		   a gcc warning about casting away const.
		   PrognameOut is of type `String' (char *);
		   it should be of type `ConstString' (const char *),
		   but fixing that requires a fair bit of work
		   on the compiler.  */
		make_aligned_string(LVALUE_CAST(ConstString, PrognameOut),
			progname);
	} else {
		PrognameOut = DefaultProgname;
	}
	update_io(IO0, IO);
;}
#line 6779 "io.c"
		r3 = (Word) PrognameOut;
		r4 = IO;

	}
	detstackvar(1) = r4;
	r1 = r3;
	call_localret(ENTRY(mercury__dir__split_name_3_0),
		mercury__io__progname_base_4_0_i2,
		ENTRY(mercury__io__progname_base_4_0));
Define_label(mercury__io__progname_base_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__progname_base_4_0));
	r3 = r1;
	r1 = r2;
	r2 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module116)
	init_entry(mercury__io__command_line_arguments_3_0);
BEGIN_CODE

/* code for predicate 'command_line_arguments'/3 in mode 0 */
Define_entry(mercury__io__command_line_arguments_3_0);
	{
		Word	Args;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2541 "io.m"
{		
	/* convert mercury_argv from a vector to a list */
	{ int i = mercury_argc;
	  Args = list_empty();
	  while (--i >= 0) {
		Args = list_cons((Word) mercury_argv[i], Args);
	  }
	}
	update_io(IO0, IO);
;}
#line 6822 "io.c"
		r2 = Args;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module117)
	init_entry(mercury__io__get_exit_status_3_0);
BEGIN_CODE

/* code for predicate 'get_exit_status'/3 in mode 0 */
Define_entry(mercury__io__get_exit_status_3_0);
	{
		Integer	ExitStatus;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2552 "io.m"
{		
	ExitStatus = mercury_exit_status;
	update_io(IO0, IO);
;}
#line 6849 "io.c"
		r2 = ExitStatus;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module118)
	init_entry(mercury__io__set_exit_status_3_0);
BEGIN_CODE

/* code for predicate 'set_exit_status'/3 in mode 0 */
Define_entry(mercury__io__set_exit_status_3_0);
	{
		Integer	ExitStatus;
		Word	IO0;
		Word	IO;
		ExitStatus = r1;
		IO0 = r2;
#line 2557 "io.m"
{		
	mercury_exit_status = ExitStatus;
	update_io(IO0, IO);
;}
#line 6877 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module119)
	init_entry(mercury__io__get_globals_3_0);
BEGIN_CODE

/* code for predicate 'get_globals'/3 in mode 0 */
Define_entry(mercury__io__get_globals_3_0);
	{
		Word	Globals;
		Word	IOState0;
		Word	IOState;
		IOState0 = r1;
#line 1852 "io.m"
{		
	Globals = ML_io_user_globals;
	update_io(IOState0, IOState);
;}
#line 6902 "io.c"
		r2 = Globals;
		r3 = IOState;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module120)
	init_entry(mercury__io__set_globals_3_0);
BEGIN_CODE

/* code for predicate 'set_globals'/3 in mode 0 */
Define_entry(mercury__io__set_globals_3_0);
	{
		Word	Globals;
		Word	IOState0;
		Word	IOState;
		Globals = r1;
		IOState0 = r2;
#line 1857 "io.m"
{		
	ML_io_user_globals = Globals;
	update_io(IOState0, IOState);
;}
#line 6930 "io.c"
		r3 = IOState;

	}
	r1 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module121)
	init_entry(mercury__io__get_environment_var_4_0);
	init_label(mercury__io__get_environment_var_4_0_i2);
BEGIN_CODE

/* code for predicate 'get_environment_var'/4 in mode 0 */
Define_entry(mercury__io__get_environment_var_4_0);
	incr_sp_push_msg(1, "io:get_environment_var/4");
	r3 = r1;
	{
		String	Var;
		String	Value;
		Var = (String) r1;
#line 2608 "io.m"
{		{
	Value = getenv(Var);
	SUCCESS_INDICATOR = (Value != 0);
};}
#line 6957 "io.c"
		r4 = (Word) Value;

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__get_environment_var_4_0_i2);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r4;
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__get_environment_var_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module122)
	init_entry(mercury__io__set_environment_var_4_0);
	init_label(mercury__io__set_environment_var_4_0_i2);
	init_label(mercury__io__set_environment_var_4_0_i3);
	init_label(mercury__io__set_environment_var_4_0_i6);
BEGIN_CODE

/* code for predicate 'set_environment_var'/4 in mode 0 */
Define_entry(mercury__io__set_environment_var_4_0);
	incr_sp_push_msg(3, "io:set_environment_var/4");
	detstackvar(3) = (Word) succip;
	detstackvar(1) = r3;
	tag_incr_hp(detstackvar(2), mktag(2), (Integer) 1);
	field(mktag(2), detstackvar(2), (Integer) 0) = r1;
	r1 = (Word) (const Word *) string_const("%s=%s", 5);
	r5 = r2;
	tag_incr_hp(r2, mktag(1), (Integer) 2);
	field(mktag(1), r2, (Integer) 0) = detstackvar(2);
	tag_incr_hp(r6, mktag(1), (Integer) 2);
	tag_incr_hp(r7, mktag(2), (Integer) 1);
	field(mktag(2), r7, (Integer) 0) = r5;
	field(mktag(1), r6, (Integer) 0) = r7;
	field(mktag(1), r6, (Integer) 1) = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	field(mktag(1), r2, (Integer) 1) = r6;
	call_localret(ENTRY(mercury__string__format_3_0),
		mercury__io__set_environment_var_4_0_i2,
		ENTRY(mercury__io__set_environment_var_4_0));
Define_label(mercury__io__set_environment_var_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__set_environment_var_4_0));
	r2 = r1;
	{
		String	VarAndValue;
		VarAndValue = (String) r1;
#line 2613 "io.m"
{		
	SUCCESS_INDICATOR = (putenv(VarAndValue) == 0);
;}
#line 7011 "io.c"

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__set_environment_var_4_0_i3);
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__set_environment_var_4_0_i3);
	r1 = (Word) (const Word *) string_const("Could not set environment variable %s", 37);
	tag_incr_hp(r2, mktag(1), (Integer) 2);
	field(mktag(1), r2, (Integer) 0) = detstackvar(2);
	field(mktag(1), r2, (Integer) 1) = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__string__format_3_0),
		mercury__io__set_environment_var_4_0_i6,
		ENTRY(mercury__io__set_environment_var_4_0));
Define_label(mercury__io__set_environment_var_4_0_i6);
	update_prof_current_proc(LABEL(mercury__io__set_environment_var_4_0));
	{
		String	Message;
		Message = (String) r1;
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 7041 "io.c"

	}
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module123)
	init_entry(mercury__io__tmpnam_3_0);
	init_label(mercury__io__tmpnam_3_0_i4);
	init_label(mercury__io__tmpnam_3_0_i3);
BEGIN_CODE

/* code for predicate 'tmpnam'/3 in mode 0 */
Define_entry(mercury__io__tmpnam_3_0);
	incr_sp_push_msg(1, "io:tmpnam/3");
	r2 = r1;
	{
		String	Var;
		String	Value;
		Var = (String) (Word) (const Word *) string_const("TMPDIR", 6);
#line 2608 "io.m"
{		{
	Value = getenv(Var);
	SUCCESS_INDICATOR = (Value != 0);
};}
#line 7069 "io.c"
		r3 = (Word) Value;

	}
	if (r1)
		GOTO_LABEL(mercury__io__tmpnam_3_0_i4);
	detstackvar(1) = r2;
	GOTO_LABEL(mercury__io__tmpnam_3_0_i3);
Define_label(mercury__io__tmpnam_3_0_i4);
	{
		String	Dir;
		String	Prefix;
		String	FileName;
		Word	IO0;
		Word	IO;
		Dir = (String) r3;
		Prefix = (String) (Word) (const Word *) string_const("mtmp", 4);
		IO0 = r2;
#line 2664 "io.m"
{		{
#ifdef	IO_HAVE_TEMPNAM
	String tmp;

	tmp = tempnam(Dir, Prefix);
	if (tmp  == NULL) {
		fatal_error("unable to create temporary filename");
	}
	incr_saved_hp_atomic(LVALUE_CAST(Word *,FileName),
		(strlen(tmp) + sizeof(Word)) / sizeof(Word));
	strcpy(FileName, tmp);
	free(tmp);
	update_io(IO0, IO);
#else
	/*
	** tempnam was unavailable, so construct a temporary name by
	** concatenating Dir, `/', the first 5 chars of Prefix, and
	** a three digit number. The three digit number is generated
	** by starting with the pid of this process.
	** Stat is used to check that the file does not exist.
	*/
	int	len, err, num_tries;
	char	countstr[256];
	struct stat buf;

	len = strlen(Dir) + 1+ 5 + 3 + 1; /* Dir + / + Prefix + counter + \0 */
	incr_saved_hp_atomic(LVALUE_CAST(Word *,FileName),
		(len + sizeof(Word)) / sizeof(Word));
	if (ML_io_tempnam_counter == 0)
		ML_io_tempnam_counter = getpid();
	num_tries=0;
	do {
		sprintf(countstr, "%0d", ML_io_tempnam_counter % 1000);
		ML_io_tempnam_counter++;
		strcpy(FileName, Dir);
		strcat(FileName, "/");
		strncat(FileName, Prefix, 5);
		strncat(FileName, countstr, 3);
		err = stat(FileName, &buf);
		num_tries++;
	} while (err != -1 && errno != ENOENT
		&& num_tries < MAX_TEMPNAME_TRIES);
	if (err != -1 && errno != ENOENT) {
		fatal_error("unable to create temporary filename");
	}
	update_io(IO0, IO);
#endif
};}
#line 7136 "io.c"
		r1 = (Word) FileName;
		r4 = IO;

	}
	r2 = r4;
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury__io__tmpnam_3_0_i3);
	r1 = detstackvar(1);
	{
		String	FileName;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2634 "io.m"
{		{
	Word tmp;

	incr_hp_atomic(tmp, (L_tmpnam + sizeof(Word)) / sizeof(Word));
	if (tmpnam((char *)tmp) == NULL) {
		fatal_error("unable to create temporary filename");
	}
	FileName = (char *)tmp;
	update_io(IO0, IO);
};}
#line 7162 "io.c"
		r2 = (Word) FileName;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module124)
	init_entry(mercury__io__tmpnam_5_0);
BEGIN_CODE

/* code for predicate 'tmpnam'/5 in mode 0 */
Define_entry(mercury__io__tmpnam_5_0);
	{
		String	Dir;
		String	Prefix;
		String	FileName;
		Word	IO0;
		Word	IO;
		Dir = (String) r1;
		Prefix = (String) r2;
		IO0 = r3;
#line 2664 "io.m"
{		{
#ifdef	IO_HAVE_TEMPNAM
	String tmp;

	tmp = tempnam(Dir, Prefix);
	if (tmp  == NULL) {
		fatal_error("unable to create temporary filename");
	}
	incr_saved_hp_atomic(LVALUE_CAST(Word *,FileName),
		(strlen(tmp) + sizeof(Word)) / sizeof(Word));
	strcpy(FileName, tmp);
	free(tmp);
	update_io(IO0, IO);
#else
	/*
	** tempnam was unavailable, so construct a temporary name by
	** concatenating Dir, `/', the first 5 chars of Prefix, and
	** a three digit number. The three digit number is generated
	** by starting with the pid of this process.
	** Stat is used to check that the file does not exist.
	*/
	int	len, err, num_tries;
	char	countstr[256];
	struct stat buf;

	len = strlen(Dir) + 1+ 5 + 3 + 1; /* Dir + / + Prefix + counter + \0 */
	incr_saved_hp_atomic(LVALUE_CAST(Word *,FileName),
		(len + sizeof(Word)) / sizeof(Word));
	if (ML_io_tempnam_counter == 0)
		ML_io_tempnam_counter = getpid();
	num_tries=0;
	do {
		sprintf(countstr, "%0d", ML_io_tempnam_counter % 1000);
		ML_io_tempnam_counter++;
		strcpy(FileName, Dir);
		strcat(FileName, "/");
		strncat(FileName, Prefix, 5);
		strncat(FileName, countstr, 3);
		err = stat(FileName, &buf);
		num_tries++;
	} while (err != -1 && errno != ENOENT
		&& num_tries < MAX_TEMPNAME_TRIES);
	if (err != -1 && errno != ENOENT) {
		fatal_error("unable to create temporary filename");
	}
	update_io(IO0, IO);
#endif
};}
#line 7238 "io.c"
		r4 = (Word) FileName;
		r5 = IO;

	}
	r1 = r4;
	r2 = r5;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module125)
	init_entry(mercury__io__remove_file_4_0);
	init_label(mercury__io__remove_file_4_0_i2);
BEGIN_CODE

/* code for predicate 'remove_file'/4 in mode 0 */
Define_entry(mercury__io__remove_file_4_0);
	{
		String	FileName;
		Integer	RetVal;
		String	RetStr;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		IO0 = r2;
#line 2731 "io.m"
{		{
	Word tmp;
	char *buf;

	RetVal = remove(FileName);

	if (RetVal < 0) {
		buf = strerror(errno);
		incr_hp_atomic(tmp,(strlen(buf)+sizeof(Word)) / sizeof(Word));
		RetStr = (char *)tmp;
		strcpy(RetStr, (char *)tmp);
	} else {
		RetStr = NULL;
	}
	update_io(IO0, IO);
};}
#line 7281 "io.c"
		r3 = RetVal;
		r4 = (Word) RetStr;
		r5 = IO;

	}
	if (((Integer) r3 >= (Integer) 0))
		GOTO_LABEL(mercury__io__remove_file_4_0_i2);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r4;
	r2 = r5;
	proceed();
Define_label(mercury__io__remove_file_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r2 = r5;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module126)
	init_entry(mercury__io__report_stats_2_0);
BEGIN_CODE

/* code for predicate 'report_stats'/2 in mode 0 */
Define_entry(mercury__io__report_stats_2_0);
	{
{		
	int	time_at_prev_stat;

	time_at_prev_stat = time_at_last_stat;
	time_at_last_stat = MR_get_user_cpu_miliseconds();

	fprintf(stderr, 
		"[Time: +%.3fs, %.3fs, D Stack: %.3fk, ND Stack: %.3fk, ",
		(time_at_last_stat - time_at_prev_stat) / 1000.0,
		(time_at_last_stat - time_at_start) / 1000.0,
		((char *) sp - (char *) detstack_zone->min) / 1024.0,
		((char *) maxfr - (char *) nondetstack_zone->min) / 1024.0
	);

#ifdef CONSERVATIVE_GC
	fprintf(stderr, 
		"#GCs: %lu,\n"
		"Heap used since last GC: %.3fk, Total used: %.3fk]\n",
		(unsigned long) GC_gc_no,
		GC_get_bytes_since_gc() / 1024.0,
		GC_get_heap_size() / 1024.0
	);
#else
	fprintf(stderr, 
		"Heap: %.3fk]\n",
		((char *) hp - (char *) heap_zone->min) / 1024.0
	);
#endif
;}
#line 7336 "io.c"

	}
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module127)
	init_entry(mercury__io__preallocate_heap_space_3_0);
BEGIN_CODE

/* code for predicate 'preallocate_heap_space'/3 in mode 0 */
Define_entry(mercury__io__preallocate_heap_space_3_0);
	{
		Integer	HeapSpace;
		Word	IO0;
		Word	IO;
		HeapSpace = r1;
		IO0 = r2;
#line 2562 "io.m"
{		
	/* HeapSpace not used */
	/* don't do anything - preallocate_heap_space was just a
	   hack for NU-Prolog */
	update_io(IO0, IO);
;}
#line 7362 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE

Declare_entry(mercury__string__int_to_base_string_3_0);

BEGIN_MODULE(mercury__io_module128)
	init_entry(mercury__io__call_system_4_0);
	init_label(mercury__io__call_system_4_0_i2);
	init_label(mercury__io__call_system_4_0_i7);
	init_label(mercury__io__call_system_4_0_i5);
BEGIN_CODE

/* code for predicate 'call_system'/4 in mode 0 */
Define_entry(mercury__io__call_system_4_0);
	incr_sp_push_msg(2, "io:call_system/4");
	detstackvar(2) = (Word) succip;
	{
		String	Command;
		Integer	Status;
		Word	IO0;
		Word	IO;
		Command = (String) r1;
		IO0 = r2;
#line 2570 "io.m"
{		
	Status = system(Command);
	if ( Status == -1 || Status == 127 ) {
		/* 
		** Return values of 127 or -1 from system() indicate that
		** the system call failed.  Dont return -1, as -1 indicates
		** that the system call was killed by signal number 1. 
		*/
		Status = 127;
	} else {
		#if defined (WIFEXITED) && defined (WEXITSTATUS) && 			defined (WIFSIGNALED) && defined (WTERMSIG)
		if (WIFEXITED(Status))
			Status = WEXITSTATUS(Status);
		else if (WIFSIGNALED(Status))
			Status = -WTERMSIG(Status);
		else
			Status = 127;
	
		#else
		if (Status & 0xff != 0) 
			/* the process was killed by a signal */
			Status = -(Status & 0xff);
		else 
			/* the process terminated normally */
			Status = (Status & 0xff00) >> 8;
	
		#endif
	}
	update_io(IO0, IO);
;}
#line 7421 "io.c"
		r3 = Status;
		r4 = IO;

	}
	if (((Integer) r3 != (Integer) 127))
		GOTO_LABEL(mercury__io__call_system_4_0_i2);
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_4);
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
Define_label(mercury__io__call_system_4_0_i2);
	if (((Integer) r3 >= (Integer) 0))
		GOTO_LABEL(mercury__io__call_system_4_0_i5);
	detstackvar(1) = r4;
	r1 = ((Integer) 0 - (Integer) r3);
	r2 = (Integer) 10;
	call_localret(ENTRY(mercury__string__int_to_base_string_3_0),
		mercury__io__call_system_4_0_i7,
		ENTRY(mercury__io__call_system_4_0));
Define_label(mercury__io__call_system_4_0_i7);
	update_prof_current_proc(LABEL(mercury__io__call_system_4_0));
	{
		String	S1;
		String	S2;
		String	S3;
		S1 = (String) (Word) (const Word *) string_const("system command killed by signal number ", 39);
		S2 = (String) r1;
{		{
	size_t len_1, len_2;
	Word tmp;
	len_1 = strlen(S1);
	len_2 = strlen(S2);
	incr_hp_atomic(tmp, (len_1 + len_2 + sizeof(Word)) / sizeof(Word));
	S3 = (char *) tmp;
	strcpy(S3, S1);
	strcpy(S3 + len_1, S2);
};}
#line 7460 "io.c"
		r2 = (Word) S3;

	}
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r2;
	r2 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
Define_label(mercury__io__call_system_4_0_i5);
	tag_incr_hp(r1, mktag(0), (Integer) 1);
	field(mktag(0), r1, (Integer) 0) = r3;
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module129)
	init_entry(mercury__io__error_message_2_0);
BEGIN_CODE

/* code for predicate 'error_message'/2 in mode 0 */
Define_entry(mercury__io__error_message_2_0);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module130)
	init_entry(mercury__io__read_anything_3_0);
BEGIN_CODE

/* code for predicate 'read_anything'/3 in mode 0 */
Define_entry(mercury__io__read_anything_3_0);
	tailcall(STATIC(mercury__io__read_3_0),
		ENTRY(mercury__io__read_anything_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module131)
	init_entry(mercury__io__read_anything_4_0);
	init_label(mercury__io__read_anything_4_0_i2);
BEGIN_CODE

/* code for predicate 'read_anything'/4 in mode 0 */
Define_entry(mercury__io__read_anything_4_0);
	incr_sp_push_msg(2, "io:read_anything/4");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r3;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 7523 "io.c"
		r4 = OutStream;
		r5 = IO;

	}
	detstackvar(1) = r4;
	r2 = r5;
	call_localret(STATIC(mercury__io__read_3_0),
		mercury__io__read_anything_4_0_i2,
		ENTRY(mercury__io__read_anything_4_0));
Define_label(mercury__io__read_anything_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_anything_4_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r2;
#line 2453 "io.m"
{		
	OutStream = (Word) mercury_current_text_input;
	mercury_current_text_input = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 7548 "io.c"
		r3 = OutStream;
		r4 = IO;

	}
	r2 = r4;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module132)
	init_entry(mercury__io__write_anything_3_0);
BEGIN_CODE

/* code for predicate 'write_anything'/3 in mode 0 */
Define_entry(mercury__io__write_anything_3_0);
	incr_sp_push_msg(1, "io:write_anything/3");
	detstackvar(1) = (Word) succip;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r2;
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 7579 "io.c"
		r4 = Univ;

	}
	r1 = r4;
	r2 = (Integer) 1201;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(STATIC(mercury__io__write_univ_4_0),
		ENTRY(mercury__io__write_anything_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module133)
	init_entry(mercury__io__write_anything_4_0);
	init_label(mercury__io__write_anything_4_0_i2);
BEGIN_CODE

/* code for predicate 'write_anything'/4 in mode 0 */
Define_entry(mercury__io__write_anything_4_0);
	incr_sp_push_msg(2, "io:write_anything/4");
	detstackvar(2) = (Word) succip;
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = r2;
		IO0 = r4;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 7614 "io.c"
		r5 = OutStream;
		r6 = IO;

	}
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = r1;
		Type = r3;
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 7630 "io.c"
		r2 = Univ;

	}
	detstackvar(1) = r5;
	r1 = r2;
	r2 = (Integer) 1201;
	r3 = r6;
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_anything_4_0_i2,
		ENTRY(mercury__io__write_anything_4_0));
Define_label(mercury__io__write_anything_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__write_anything_4_0));
	{
		Word	NewStream;
		Word	OutStream;
		Word	IO0;
		Word	IO;
		NewStream = detstackvar(1);
		IO0 = r1;
#line 2461 "io.m"
{		
	OutStream = (Word) mercury_current_text_output;
	mercury_current_text_output = (MercuryFile*) NewStream;
	update_io(IO0, IO);
;}
#line 7656 "io.c"
		r2 = OutStream;
		r3 = IO;

	}
	r1 = r3;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module134)
	init_entry(mercury__io__get_op_table_3_0);
BEGIN_CODE

/* code for predicate 'get_op_table'/3 in mode 0 */
Define_entry(mercury__io__get_op_table_3_0);
	r2 = r1;
	r1 = (Integer) 0;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module135)
	init_entry(mercury__io__set_op_table_3_0);
BEGIN_CODE

/* code for predicate 'set_op_table'/3 in mode 0 */
Define_entry(mercury__io__set_op_table_3_0);
	r1 = r2;
	tailcall(STATIC(mercury__io__set_op_table__ua10000_3_0),
		ENTRY(mercury__io__set_op_table_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module136)
	init_entry(mercury__io__read_char_code_4_0);
BEGIN_CODE

/* code for predicate 'read_char_code'/4 in mode 0 */
Define_static(mercury__io__read_char_code_4_0);
	{
		Word	File;
		Integer	CharCode;
		Word	IO0;
		Word	IO;
		File = r1;
		IO0 = r2;
#line 2162 "io.m"
{		
	CharCode = mercury_getc((MercuryFile*)File);
	update_io(IO0, IO);
;}
#line 7710 "io.c"
		r3 = CharCode;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module137)
	init_entry(mercury__io__call_system_code_4_0);
BEGIN_CODE

/* code for predicate 'call_system_code'/4 in mode 0 */
Define_static(mercury__io__call_system_code_4_0);
	{
		String	Command;
		Integer	Status;
		Word	IO0;
		Word	IO;
		Command = (String) r1;
		IO0 = r2;
#line 2570 "io.m"
{		
	Status = system(Command);
	if ( Status == -1 || Status == 127 ) {
		/* 
		** Return values of 127 or -1 from system() indicate that
		** the system call failed.  Dont return -1, as -1 indicates
		** that the system call was killed by signal number 1. 
		*/
		Status = 127;
	} else {
		#if defined (WIFEXITED) && defined (WEXITSTATUS) && 			defined (WIFSIGNALED) && defined (WTERMSIG)
		if (WIFEXITED(Status))
			Status = WEXITSTATUS(Status);
		else if (WIFSIGNALED(Status))
			Status = -WTERMSIG(Status);
		else
			Status = 127;
	
		#else
		if (Status & 0xff != 0) 
			/* the process was killed by a signal */
			Status = -(Status & 0xff);
		else 
			/* the process terminated normally */
			Status = (Status & 0xff00) >> 8;
	
		#endif
	}
	update_io(IO0, IO);
;}
#line 7765 "io.c"
		r3 = Status;
		r4 = IO;

	}
	r1 = r3;
	r2 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module138)
	init_entry(mercury__io__do_open_6_0);
BEGIN_CODE

/* code for predicate 'do_open'/6 in mode 0 */
Define_static(mercury__io__do_open_6_0);
	{
		String	FileName;
		String	Mode;
		Integer	ResultCode;
		Word	Stream;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		Mode = (String) r2;
		IO0 = r3;
#line 2492 "io.m"
{		
	Stream = (Word) mercury_open(FileName, Mode);
	ResultCode = (Stream ? 0 : -1);
	update_io(IO0, IO);
;}
#line 7798 "io.c"
		r4 = ResultCode;
		r5 = Stream;
		r6 = IO;

	}
	r1 = r4;
	r2 = r5;
	r3 = r6;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module139)
	init_entry(mercury__io__getenv_2_0);
	init_label(mercury__io__getenv_2_0_i1);
BEGIN_CODE

/* code for predicate 'getenv'/2 in mode 0 */
Define_static(mercury__io__getenv_2_0);
	r2 = r1;
	{
		String	Var;
		String	Value;
		Var = (String) r1;
#line 2608 "io.m"
{		{
	Value = getenv(Var);
	SUCCESS_INDICATOR = (Value != 0);
};}
#line 7828 "io.c"
		r3 = (Word) Value;

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__getenv_2_0_i1);
	r2 = r3;
	r1 = TRUE;
	proceed();
Define_label(mercury__io__getenv_2_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module140)
	init_entry(mercury__io__putenv_1_0);
	init_label(mercury__io__putenv_1_0_i1);
BEGIN_CODE

/* code for predicate 'putenv'/1 in mode 0 */
Define_static(mercury__io__putenv_1_0);
	r2 = r1;
	{
		String	VarAndValue;
		VarAndValue = (String) r1;
#line 2613 "io.m"
{		
	SUCCESS_INDICATOR = (putenv(VarAndValue) == 0);
;}
#line 7858 "io.c"

	}
	if (!(r1))
		GOTO_LABEL(mercury__io__putenv_1_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury__io__putenv_1_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module141)
	init_entry(mercury__io__read_word_2_4_0);
	init_label(mercury__io__read_word_2_4_0_i2);
	init_label(mercury__io__read_word_2_4_0_i5);
	init_label(mercury__io__read_word_2_4_0_i9);
	init_label(mercury__io__read_word_2_4_0_i8);
	init_label(mercury__io__read_word_2_4_0_i11);
	init_label(mercury__io__read_word_2_4_0_i14);
	init_label(mercury__io__read_word_2_4_0_i3);
BEGIN_CODE

/* code for predicate 'read_word_2'/4 in mode 0 */
Define_static(mercury__io__read_word_2_4_0);
	incr_sp_push_msg(4, "io:read_word_2/4");
	detstackvar(4) = (Word) succip;
	detstackvar(1) = r1;
	call_localret(STATIC(mercury__io__read_char_4_0),
		mercury__io__read_word_2_4_0_i2,
		STATIC(mercury__io__read_word_2_4_0));
Define_label(mercury__io__read_word_2_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_word_2_4_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_word_2_4_0_i5);
	r1 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__read_word_2_4_0_i5);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_word_2_4_0_i3);
	r3 = const_field(mktag(1), r1, (Integer) 0);
	detstackvar(2) = r3;
	detstackvar(3) = r2;
	r1 = r3;
	call_localret(ENTRY(mercury__char__is_whitespace_1_0),
		mercury__io__read_word_2_4_0_i9,
		STATIC(mercury__io__read_word_2_4_0));
Define_label(mercury__io__read_word_2_4_0_i9);
	update_prof_current_proc(LABEL(mercury__io__read_word_2_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__read_word_2_4_0_i8);
	{
		Word	File;
		Char	Character;
		Word	IO0;
		Word	IO;
		File = detstackvar(1);
		Character = detstackvar(2);
		IO0 = detstackvar(3);
#line 2168 "io.m"
{		{
	MercuryFile* mf = (MercuryFile *)File;
	if (Character == '\n') {
		mf->line_number--;
	}
	/* XXX should work even if ungetc() fails */
	if (ungetc(Character, mf->file) == EOF) {
		fatal_error("io__putback_char: ungetc failed");
	}
	update_io(IO0, IO);
};}
#line 7933 "io.c"
		r2 = IO;

	}
	r1 = (Word) (const Word *) mkword(mktag(1), (Word) (const Word *) &mercury_data_io__common_5);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__read_word_2_4_0_i8);
	r3 = detstackvar(2);
	r2 = detstackvar(3);
	detstackvar(2) = r3;
	r1 = detstackvar(1);
	localcall(mercury__io__read_word_2_4_0,
		LABEL(mercury__io__read_word_2_4_0_i11),
		STATIC(mercury__io__read_word_2_4_0));
Define_label(mercury__io__read_word_2_4_0_i11);
	update_prof_current_proc(LABEL(mercury__io__read_word_2_4_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_word_2_4_0_i14);
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	tag_incr_hp(r3, mktag(1), (Integer) 2);
	field(mktag(1), r3, (Integer) 0) = detstackvar(2);
	field(mktag(1), r3, (Integer) 1) = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	field(mktag(1), r1, (Integer) 0) = r3;
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
Define_label(mercury__io__read_word_2_4_0_i14);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_word_2_4_0_i3);
	r3 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	tag_incr_hp(r4, mktag(1), (Integer) 2);
	field(mktag(1), r4, (Integer) 0) = detstackvar(2);
	field(mktag(1), r4, (Integer) 1) = const_field(mktag(1), r3, (Integer) 0);
	field(mktag(1), r1, (Integer) 0) = r4;
Define_label(mercury__io__read_word_2_4_0_i3);
	succip = (Code *) detstackvar(4);
	decr_sp_pop_msg(4);
	proceed();
END_MODULE

Declare_entry(mercury__list__reverse_2_3_0);

BEGIN_MODULE(mercury__io_module142)
	init_entry(mercury__io__read_file_2_5_0);
	init_label(mercury__io__read_file_2_5_0_i1002);
	init_label(mercury__io__read_file_2_5_0_i2);
	init_label(mercury__io__read_file_2_5_0_i6);
	init_label(mercury__io__read_file_2_5_0_i5);
	init_label(mercury__io__read_file_2_5_0_i3);
BEGIN_CODE

/* code for predicate 'read_file_2'/5 in mode 0 */
Define_entry(mercury__io__read_file_2_5_0);
	incr_sp_push_msg(3, "io:read_file_2/5");
	detstackvar(3) = (Word) succip;
Define_label(mercury__io__read_file_2_5_0_i1002);
	detstackvar(1) = r1;
	detstackvar(2) = r2;
	r2 = r3;
	call_localret(STATIC(mercury__io__read_char_4_0),
		mercury__io__read_file_2_5_0_i2,
		ENTRY(mercury__io__read_file_2_5_0));
Define_label(mercury__io__read_file_2_5_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_file_2_5_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_file_2_5_0_i5);
	detstackvar(1) = r2;
	r1 = (Word) (const Word *) &mercury_data___base_type_info_character_0;
	r2 = detstackvar(2);
	r3 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__list__reverse_2_3_0),
		mercury__io__read_file_2_5_0_i6,
		ENTRY(mercury__io__read_file_2_5_0));
Define_label(mercury__io__read_file_2_5_0_i6);
	update_prof_current_proc(LABEL(mercury__io__read_file_2_5_0));
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r2;
	r2 = detstackvar(1);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__read_file_2_5_0_i5);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_file_2_5_0_i3);
	r3 = r1;
	r1 = detstackvar(1);
	r4 = r2;
	tag_incr_hp(r2, mktag(1), (Integer) 2);
	field(mktag(1), r2, (Integer) 0) = const_field(mktag(1), r3, (Integer) 0);
	field(mktag(1), r2, (Integer) 1) = detstackvar(2);
	r3 = r4;
	succip = (Code *) detstackvar(3);
	GOTO_LABEL(mercury__io__read_file_2_5_0_i1002);
Define_label(mercury__io__read_file_2_5_0_i3);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module143)
	init_entry(mercury__io__read_binary_file_2_5_0);
	init_label(mercury__io__read_binary_file_2_5_0_i1002);
	init_label(mercury__io__read_binary_file_2_5_0_i2);
	init_label(mercury__io__read_binary_file_2_5_0_i6);
	init_label(mercury__io__read_binary_file_2_5_0_i5);
	init_label(mercury__io__read_binary_file_2_5_0_i3);
BEGIN_CODE

/* code for predicate 'read_binary_file_2'/5 in mode 0 */
Define_entry(mercury__io__read_binary_file_2_5_0);
	incr_sp_push_msg(3, "io:read_binary_file_2/5");
	detstackvar(3) = (Word) succip;
Define_label(mercury__io__read_binary_file_2_5_0_i1002);
	detstackvar(1) = r1;
	detstackvar(2) = r2;
	r2 = r3;
	call_localret(STATIC(mercury__io__read_byte_4_0),
		mercury__io__read_binary_file_2_5_0_i2,
		ENTRY(mercury__io__read_binary_file_2_5_0));
Define_label(mercury__io__read_binary_file_2_5_0_i2);
	update_prof_current_proc(LABEL(mercury__io__read_binary_file_2_5_0));
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury__io__read_binary_file_2_5_0_i5);
	detstackvar(1) = r2;
	r1 = (Word) (const Word *) &mercury_data___base_type_info_int_0;
	r2 = detstackvar(2);
	r3 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury__list__reverse_2_3_0),
		mercury__io__read_binary_file_2_5_0_i6,
		ENTRY(mercury__io__read_binary_file_2_5_0));
Define_label(mercury__io__read_binary_file_2_5_0_i6);
	update_prof_current_proc(LABEL(mercury__io__read_binary_file_2_5_0));
	r2 = r1;
	tag_incr_hp(r1, mktag(1), (Integer) 1);
	field(mktag(1), r1, (Integer) 0) = r2;
	r2 = detstackvar(1);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury__io__read_binary_file_2_5_0_i5);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury__io__read_binary_file_2_5_0_i3);
	r3 = r1;
	r1 = detstackvar(1);
	r4 = r2;
	tag_incr_hp(r2, mktag(1), (Integer) 2);
	field(mktag(1), r2, (Integer) 0) = const_field(mktag(1), r3, (Integer) 0);
	field(mktag(1), r2, (Integer) 1) = detstackvar(2);
	r3 = r4;
	succip = (Code *) detstackvar(3);
	GOTO_LABEL(mercury__io__read_binary_file_2_5_0_i1002);
Define_label(mercury__io__read_binary_file_2_5_0_i3);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module144)
	init_entry(mercury__io__write_univ_3_0);
BEGIN_CODE

/* code for predicate 'write_univ'/3 in mode 0 */
Define_entry(mercury__io__write_univ_3_0);
	r3 = r2;
	r2 = (Integer) 1201;
	tailcall(STATIC(mercury__io__write_univ_4_0),
		ENTRY(mercury__io__write_univ_3_0));
END_MODULE

Declare_entry(mercury__term_io__quote_string_3_0);
Declare_entry(mercury__term_io__quote_char_3_0);
	extern const struct mercury_data___base_type_info_float_0_struct
		mercury_data___base_type_info_float_0;
	extern const struct mercury_data_std_util__base_type_info_type_info_0_struct
		mercury_data_std_util__base_type_info_type_info_0;
Declare_entry(mercury__fn__std_util__type_name_1_0);
Declare_entry(mercury__std_util__univ_to_type_2_0);
Declare_entry(mercury__fn__std_util__type_ctor_1_0);
Declare_entry(mercury__fn__std_util__type_ctor_name_1_0);
Declare_entry(mercury__fn__std_util__type_ctor_module_name_1_0);
Declare_entry(mercury__term__univ_to_term_2_0);
Declare_entry(mercury__varset__init_1_0);
Declare_entry(mercury__term_io__write_term_4_0);

BEGIN_MODULE(mercury__io_module145)
	init_entry(mercury__io__write_univ_4_0);
	init_label(mercury__io__write_univ_4_0_i4);
	init_label(mercury__io__write_univ_4_0_i3);
	init_label(mercury__io__write_univ_4_0_i8);
	init_label(mercury__io__write_univ_4_0_i7);
	init_label(mercury__io__write_univ_4_0_i12);
	init_label(mercury__io__write_univ_4_0_i11);
	init_label(mercury__io__write_univ_4_0_i15);
	init_label(mercury__io__write_univ_4_0_i14);
	init_label(mercury__io__write_univ_4_0_i18);
	init_label(mercury__io__write_univ_4_0_i19);
	init_label(mercury__io__write_univ_4_0_i17);
	init_label(mercury__io__write_univ_4_0_i23);
	init_label(mercury__io__write_univ_4_0_i22);
	init_label(mercury__io__write_univ_4_0_i28);
	init_label(mercury__io__write_univ_4_0_i27);
	init_label(mercury__io__write_univ_4_0_i33);
	init_label(mercury__io__write_univ_4_0_i34);
	init_label(mercury__io__write_univ_4_0_i36);
	init_label(mercury__io__write_univ_4_0_i38);
	init_label(mercury__io__write_univ_4_0_i39);
	init_label(mercury__io__write_univ_4_0_i32);
BEGIN_CODE

/* code for predicate 'write_univ'/4 in mode 0 */
Define_static(mercury__io__write_univ_4_0);
	incr_sp_push_msg(5, "io:write_univ/4");
	detstackvar(5) = (Word) succip;
	r4 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data___base_type_info_string_0;
		Univ = r1;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 8175 "io.c"
		r5 = Type;

	}
	if (r1)
		GOTO_LABEL(mercury__io__write_univ_4_0_i4);
	detstackvar(1) = r4;
	detstackvar(2) = r2;
	detstackvar(3) = r3;
	GOTO_LABEL(mercury__io__write_univ_4_0_i3);
Define_label(mercury__io__write_univ_4_0_i4);
	r1 = r5;
	r2 = r3;
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(ENTRY(mercury__term_io__quote_string_3_0),
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i3);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	r3 = detstackvar(3);
	r4 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data___base_type_info_character_0;
		Univ = r1;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 8216 "io.c"
		r5 = Type;

	}
	if (r1)
		GOTO_LABEL(mercury__io__write_univ_4_0_i8);
	detstackvar(1) = r4;
	detstackvar(2) = r2;
	detstackvar(3) = r3;
	GOTO_LABEL(mercury__io__write_univ_4_0_i7);
Define_label(mercury__io__write_univ_4_0_i8);
	r1 = r5;
	r2 = r3;
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(ENTRY(mercury__term_io__quote_char_3_0),
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i7);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	r3 = detstackvar(3);
	r4 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data___base_type_info_int_0;
		Univ = r1;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 8257 "io.c"
		r5 = Type;

	}
	if (r1)
		GOTO_LABEL(mercury__io__write_univ_4_0_i12);
	detstackvar(1) = r4;
	detstackvar(2) = r2;
	detstackvar(3) = r3;
	GOTO_LABEL(mercury__io__write_univ_4_0_i11);
Define_label(mercury__io__write_univ_4_0_i12);
	{
		Integer	Val;
		Word	IO0;
		Word	IO;
		Val = r5;
		IO0 = r3;
#line 2208 "io.m"
{		
	if (fprintf(mercury_current_text_output->file, "%ld", (long) Val) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	update_io(IO0, IO);
;}
#line 8281 "io.c"
		r1 = IO;

	}
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	proceed();
Define_label(mercury__io__write_univ_4_0_i11);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	r3 = detstackvar(3);
	r4 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data___base_type_info_float_0;
		Univ = r1;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 8312 "io.c"
		r5 = Type;

	}
	if (r1)
		GOTO_LABEL(mercury__io__write_univ_4_0_i15);
	detstackvar(1) = r4;
	detstackvar(2) = r2;
	detstackvar(3) = r3;
	GOTO_LABEL(mercury__io__write_univ_4_0_i14);
Define_label(mercury__io__write_univ_4_0_i15);
	{
		Float	Val;
		Word	IO0;
		Word	IO;
		Val = word_to_float(r5);
		IO0 = r3;
#line 2215 "io.m"
{		
	if (fprintf(mercury_current_text_output->file, "%#.15g", Val) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	update_io(IO0, IO);
;}
#line 8336 "io.c"
		r1 = IO;

	}
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	proceed();
Define_label(mercury__io__write_univ_4_0_i14);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	r3 = detstackvar(3);
	r4 = r1;
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data_std_util__base_type_info_type_info_0;
		Univ = r1;
{		{
	Word univ_type_info = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
	int comp;
	save_transient_registers();
	comp = ML_compare_type_info(univ_type_info, TypeInfo_for_T);
	restore_transient_registers();
	if (comp == COMPARE_EQUAL) {
		Type = field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA);
		SUCCESS_INDICATOR = TRUE;
	} else {
		SUCCESS_INDICATOR = FALSE;
	}
};}
#line 8367 "io.c"
		r5 = Type;

	}
	if (r1)
		GOTO_LABEL(mercury__io__write_univ_4_0_i18);
	detstackvar(1) = r4;
	detstackvar(2) = r2;
	detstackvar(3) = r3;
	GOTO_LABEL(mercury__io__write_univ_4_0_i17);
Define_label(mercury__io__write_univ_4_0_i18);
	detstackvar(3) = r3;
	r1 = r5;
	call_localret(ENTRY(mercury__fn__std_util__type_name_1_0),
		mercury__io__write_univ_4_0_i19,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i19);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	r2 = detstackvar(3);
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(STATIC(mercury__io__write_string_3_0),
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i17);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	r3 = detstackvar(3);
	detstackvar(1) = r1;
	detstackvar(2) = r2;
	detstackvar(3) = r3;
	r1 = (Word) (const Word *) &mercury_data_std_util__base_type_info_univ_0;
	r2 = detstackvar(1);
	call_localret(ENTRY(mercury__std_util__univ_to_type_2_0),
		mercury__io__write_univ_4_0_i23,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i23);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_univ_4_0_i22);
	r1 = r2;
	r2 = detstackvar(3);
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(STATIC(mercury__io__write_univ_as_univ_3_0),
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i22);
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = detstackvar(1);
	call_localret(ENTRY(mercury__std_util__univ_to_type_2_0),
		mercury__io__write_univ_4_0_i28,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i28);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_univ_4_0_i27);
	r1 = detstackvar(3);
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(STATIC(mercury__io__write_c_pointer__ua10000_3_0),
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i27);
	{
		Word	Univ;
		Word	TypeInfo;
		Univ = detstackvar(1);
{		
	TypeInfo = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
;}
#line 8435 "io.c"
		r1 = TypeInfo;

	}
	call_localret(ENTRY(mercury__fn__std_util__type_ctor_1_0),
		mercury__io__write_univ_4_0_i33,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i33);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	detstackvar(4) = r1;
	call_localret(ENTRY(mercury__fn__std_util__type_ctor_name_1_0),
		mercury__io__write_univ_4_0_i34,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i34);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	if ((strcmp((char *)r1, (char *)(Word) (const Word *) string_const("array", 5)) != 0))
		GOTO_LABEL(mercury__io__write_univ_4_0_i32);
	r1 = detstackvar(4);
	call_localret(ENTRY(mercury__fn__std_util__type_ctor_module_name_1_0),
		mercury__io__write_univ_4_0_i36,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i36);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	if ((strcmp((char *)r1, (char *)(Word) (const Word *) string_const("array", 5)) != 0))
		GOTO_LABEL(mercury__io__write_univ_4_0_i32);
	r1 = detstackvar(1);
	call_localret(ENTRY(mercury__term__univ_to_term_2_0),
		mercury__io__write_univ_4_0_i38,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i38);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	detstackvar(4) = r1;
	call_localret(ENTRY(mercury__varset__init_1_0),
		mercury__io__write_univ_4_0_i39,
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i39);
	update_prof_current_proc(LABEL(mercury__io__write_univ_4_0));
	r2 = detstackvar(4);
	r3 = detstackvar(3);
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(ENTRY(mercury__term_io__write_term_4_0),
		STATIC(mercury__io__write_univ_4_0));
Define_label(mercury__io__write_univ_4_0_i32);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	r3 = detstackvar(3);
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(STATIC(mercury__io__write_ordinary_term_4_0),
		STATIC(mercury__io__write_univ_4_0));
END_MODULE


BEGIN_MODULE(mercury__io_module146)
	init_entry(mercury__io__write_univ_as_univ_3_0);
	init_label(mercury__io__write_univ_as_univ_3_0_i2);
	init_label(mercury__io__write_univ_as_univ_3_0_i3);
BEGIN_CODE

/* code for predicate 'write_univ_as_univ'/3 in mode 0 */
Define_static(mercury__io__write_univ_as_univ_3_0);
	incr_sp_push_msg(2, "io:write_univ_as_univ/3");
	detstackvar(2) = (Word) succip;
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) (Word) (const Word *) string_const("univ(", 5);
		IO0 = r2;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 8510 "io.c"
		r3 = IO;

	}
	detstackvar(1) = r1;
	r2 = (Integer) 1201;
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_univ_as_univ_3_0_i2,
		STATIC(mercury__io__write_univ_as_univ_3_0));
Define_label(mercury__io__write_univ_as_univ_3_0_i2);
	update_prof_current_proc(LABEL(mercury__io__write_univ_as_univ_3_0));
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) (Word) (const Word *) string_const(" : ", 3);
		IO0 = r1;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 8532 "io.c"
		r2 = IO;

	}
	{
		Word	Univ;
		Word	TypeInfo;
		Univ = detstackvar(1);
{		
	TypeInfo = field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO);
;}
#line 8543 "io.c"
		r1 = TypeInfo;

	}
	detstackvar(1) = r2;
	call_localret(ENTRY(mercury__fn__std_util__type_name_1_0),
		mercury__io__write_univ_as_univ_3_0_i3,
		STATIC(mercury__io__write_univ_as_univ_3_0));
Define_label(mercury__io__write_univ_as_univ_3_0_i3);
	update_prof_current_proc(LABEL(mercury__io__write_univ_as_univ_3_0));
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) r1;
		IO0 = detstackvar(1);
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 8564 "io.c"
		r2 = IO;

	}
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) (Word) (const Word *) string_const(")", 1);
		IO0 = r2;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 8579 "io.c"
		r1 = IO;

	}
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE

Declare_entry(mercury__std_util__deconstruct_4_0);
Declare_entry(mercury__ops__lookup_prefix_op_4_0);
Declare_entry(mercury__term_io__quote_atom_3_0);
Declare_entry(mercury__ops__lookup_postfix_op_4_0);
Declare_entry(mercury__ops__lookup_infix_op_5_0);
Declare_entry(mercury__ops__lookup_binary_prefix_op_5_0);
Declare_entry(mercury__ops__max_priority_1_0);

BEGIN_MODULE(mercury__io_module147)
	init_entry(mercury__io__write_ordinary_term_4_0);
	init_label(mercury__io__write_ordinary_term_4_0_i2);
	init_label(mercury__io__write_ordinary_term_4_0_i3);
	init_label(mercury__io__write_ordinary_term_4_0_i10);
	init_label(mercury__io__write_ordinary_term_4_0_i11);
	init_label(mercury__io__write_ordinary_term_4_0_i12);
	init_label(mercury__io__write_ordinary_term_4_0_i4);
	init_label(mercury__io__write_ordinary_term_4_0_i14);
	init_label(mercury__io__write_ordinary_term_4_0_i24);
	init_label(mercury__io__write_ordinary_term_4_0_i25);
	init_label(mercury__io__write_ordinary_term_4_0_i19);
	init_label(mercury__io__write_ordinary_term_4_0_i31);
	init_label(mercury__io__write_ordinary_term_4_0_i33);
	init_label(mercury__io__write_ordinary_term_4_0_i34);
	init_label(mercury__io__write_ordinary_term_4_0_i35);
	init_label(mercury__io__write_ordinary_term_4_0_i36);
	init_label(mercury__io__write_ordinary_term_4_0_i37);
	init_label(mercury__io__write_ordinary_term_4_0_i28);
	init_label(mercury__io__write_ordinary_term_4_0_i27);
	init_label(mercury__io__write_ordinary_term_4_0_i43);
	init_label(mercury__io__write_ordinary_term_4_0_i45);
	init_label(mercury__io__write_ordinary_term_4_0_i46);
	init_label(mercury__io__write_ordinary_term_4_0_i47);
	init_label(mercury__io__write_ordinary_term_4_0_i48);
	init_label(mercury__io__write_ordinary_term_4_0_i49);
	init_label(mercury__io__write_ordinary_term_4_0_i40);
	init_label(mercury__io__write_ordinary_term_4_0_i39);
	init_label(mercury__io__write_ordinary_term_4_0_i56);
	init_label(mercury__io__write_ordinary_term_4_0_i58);
	init_label(mercury__io__write_ordinary_term_4_0_i59);
	init_label(mercury__io__write_ordinary_term_4_0_i60);
	init_label(mercury__io__write_ordinary_term_4_0_i64);
	init_label(mercury__io__write_ordinary_term_4_0_i61);
	init_label(mercury__io__write_ordinary_term_4_0_i65);
	init_label(mercury__io__write_ordinary_term_4_0_i66);
	init_label(mercury__io__write_ordinary_term_4_0_i67);
	init_label(mercury__io__write_ordinary_term_4_0_i68);
	init_label(mercury__io__write_ordinary_term_4_0_i69);
	init_label(mercury__io__write_ordinary_term_4_0_i70);
	init_label(mercury__io__write_ordinary_term_4_0_i52);
	init_label(mercury__io__write_ordinary_term_4_0_i51);
	init_label(mercury__io__write_ordinary_term_4_0_i77);
	init_label(mercury__io__write_ordinary_term_4_0_i79);
	init_label(mercury__io__write_ordinary_term_4_0_i80);
	init_label(mercury__io__write_ordinary_term_4_0_i81);
	init_label(mercury__io__write_ordinary_term_4_0_i82);
	init_label(mercury__io__write_ordinary_term_4_0_i83);
	init_label(mercury__io__write_ordinary_term_4_0_i84);
	init_label(mercury__io__write_ordinary_term_4_0_i85);
	init_label(mercury__io__write_ordinary_term_4_0_i73);
	init_label(mercury__io__write_ordinary_term_4_0_i72);
	init_label(mercury__io__write_ordinary_term_4_0_i91);
	init_label(mercury__io__write_ordinary_term_4_0_i93);
	init_label(mercury__io__write_ordinary_term_4_0_i94);
	init_label(mercury__io__write_ordinary_term_4_0_i95);
	init_label(mercury__io__write_ordinary_term_4_0_i96);
	init_label(mercury__io__write_ordinary_term_4_0_i89);
	init_label(mercury__io__write_ordinary_term_4_0_i88);
	init_label(mercury__io__write_ordinary_term_4_0_i97);
	init_label(mercury__io__write_ordinary_term_4_0_i98);
	init_label(mercury__io__write_ordinary_term_4_0_i102);
	init_label(mercury__io__write_ordinary_term_4_0_i103);
	init_label(mercury__io__write_ordinary_term_4_0_i104);
	init_label(mercury__io__write_ordinary_term_4_0_i99);
BEGIN_CODE

/* code for predicate 'write_ordinary_term'/4 in mode 0 */
Define_static(mercury__io__write_ordinary_term_4_0);
	incr_sp_push_msg(11, "io:write_ordinary_term/4");
	detstackvar(11) = (Word) succip;
	detstackvar(1) = r2;
	r2 = r1;
	r1 = (Word) (const Word *) &mercury_data_std_util__base_type_info_univ_0;
	detstackvar(2) = r3;
	call_localret(ENTRY(mercury__std_util__deconstruct_4_0),
		mercury__io__write_ordinary_term_4_0_i2,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i2);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(2);
	detstackvar(2) = r2;
	detstackvar(3) = r3;
	call_localret(STATIC(mercury__io__get_op_table_3_0),
		mercury__io__write_ordinary_term_4_0_i3,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i3);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if ((strcmp((char *)detstackvar(2), (char *)(Word) (const Word *) string_const(".", 1)) != 0))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i4);
	if (((Integer) detstackvar(3) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i4);
	r3 = const_field(mktag(1), detstackvar(3), (Integer) 1);
	if (((Integer) r3 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i4);
	if (((Integer) const_field(mktag(1), r3, (Integer) 1) != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i4);
	detstackvar(1) = const_field(mktag(1), detstackvar(3), (Integer) 0);
	detstackvar(2) = const_field(mktag(1), r3, (Integer) 0);
	r1 = (Integer) 91;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i10,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i10);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(1);
	call_localret(STATIC(mercury__io__write_univ_3_0),
		mercury__io__write_ordinary_term_4_0_i11,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i11);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(2);
	call_localret(STATIC(mercury__io__write_list_tail_3_0),
		mercury__io__write_ordinary_term_4_0_i12,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i12);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 93;
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	tailcall(STATIC(mercury__io__write_char_3_0),
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i4);
	if ((strcmp((char *)detstackvar(2), (char *)(Word) (const Word *) string_const("[]", 2)) != 0))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i14);
	if (((Integer) detstackvar(3) != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i14);
	r1 = (Word) (const Word *) string_const("[]", 2);
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	tailcall(STATIC(mercury__io__write_string_3_0),
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i14);
	if ((strcmp((char *)detstackvar(2), (char *)(Word) (const Word *) string_const("{}", 2)) != 0))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i19);
	if (((Integer) detstackvar(3) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i19);
	r3 = const_field(mktag(1), detstackvar(3), (Integer) 1);
	if (((Integer) r3 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i19);
	detstackvar(1) = const_field(mktag(1), detstackvar(3), (Integer) 0);
	r1 = (Word) (const Word *) string_const("{ ", 2);
	call_localret(STATIC(mercury__io__write_string_3_0),
		mercury__io__write_ordinary_term_4_0_i24,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i24);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(1);
	call_localret(STATIC(mercury__io__write_univ_3_0),
		mercury__io__write_ordinary_term_4_0_i25,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i25);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Word) (const Word *) string_const(" }", 2);
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	tailcall(STATIC(mercury__io__write_string_3_0),
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i19);
	if (((Integer) detstackvar(3) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i27);
	r3 = const_field(mktag(1), detstackvar(3), (Integer) 1);
	if (((Integer) r3 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i27);
	detstackvar(4) = r1;
	detstackvar(5) = const_field(mktag(1), detstackvar(3), (Integer) 0);
	detstackvar(9) = r2;
	r2 = detstackvar(2);
	call_localret(ENTRY(mercury__ops__lookup_prefix_op_4_0),
		mercury__io__write_ordinary_term_4_0_i31,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i31);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i28);
	detstackvar(7) = r3;
	r3 = r2;
	detstackvar(6) = r2;
	r1 = (Integer) 40;
	r2 = detstackvar(1);
	r4 = detstackvar(9);
	call_localret(STATIC(mercury__io__maybe_write_char_5_0),
		mercury__io__write_ordinary_term_4_0_i33,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i33);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(2);
	call_localret(ENTRY(mercury__term_io__quote_atom_3_0),
		mercury__io__write_ordinary_term_4_0_i34,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i34);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 32;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i35,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i35);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = detstackvar(7);
	detstackvar(7) = r1;
	r1 = detstackvar(6);
	call_localret(STATIC(mercury__io__adjust_priority_3_0),
		mercury__io__write_ordinary_term_4_0_i36,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i36);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(5);
	r3 = detstackvar(7);
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_ordinary_term_4_0_i37,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i37);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r4 = r1;
	r1 = (Integer) 41;
	r2 = detstackvar(1);
	r3 = detstackvar(6);
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	tailcall(STATIC(mercury__io__maybe_write_char_5_0),
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i28);
	r1 = detstackvar(4);
	r2 = detstackvar(9);
Define_label(mercury__io__write_ordinary_term_4_0_i27);
	if (((Integer) detstackvar(3) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i39);
	r3 = const_field(mktag(1), detstackvar(3), (Integer) 1);
	if (((Integer) r3 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i39);
	detstackvar(4) = r1;
	detstackvar(5) = const_field(mktag(1), detstackvar(3), (Integer) 0);
	detstackvar(9) = r2;
	r2 = detstackvar(2);
	call_localret(ENTRY(mercury__ops__lookup_postfix_op_4_0),
		mercury__io__write_ordinary_term_4_0_i43,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i43);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i40);
	detstackvar(6) = r3;
	r3 = r2;
	detstackvar(7) = r2;
	r1 = (Integer) 40;
	r2 = detstackvar(1);
	r4 = detstackvar(9);
	call_localret(STATIC(mercury__io__maybe_write_char_5_0),
		mercury__io__write_ordinary_term_4_0_i45,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i45);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = detstackvar(6);
	detstackvar(6) = r1;
	r1 = detstackvar(7);
	call_localret(STATIC(mercury__io__adjust_priority_3_0),
		mercury__io__write_ordinary_term_4_0_i46,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i46);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(5);
	r3 = detstackvar(6);
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_ordinary_term_4_0_i47,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i47);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 32;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i48,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i48);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(2);
	call_localret(ENTRY(mercury__term_io__quote_atom_3_0),
		mercury__io__write_ordinary_term_4_0_i49,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i49);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r4 = r1;
	r1 = (Integer) 41;
	r2 = detstackvar(1);
	r3 = detstackvar(7);
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	tailcall(STATIC(mercury__io__maybe_write_char_5_0),
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i40);
	r1 = detstackvar(4);
	r2 = detstackvar(9);
Define_label(mercury__io__write_ordinary_term_4_0_i39);
	if (((Integer) detstackvar(3) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i51);
	r3 = const_field(mktag(1), detstackvar(3), (Integer) 1);
	if (((Integer) r3 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i51);
	if (((Integer) const_field(mktag(1), r3, (Integer) 1) != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i51);
	detstackvar(4) = r1;
	detstackvar(5) = const_field(mktag(1), detstackvar(3), (Integer) 0);
	detstackvar(6) = const_field(mktag(1), r3, (Integer) 0);
	detstackvar(9) = r2;
	r2 = detstackvar(2);
	call_localret(ENTRY(mercury__ops__lookup_infix_op_5_0),
		mercury__io__write_ordinary_term_4_0_i56,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i56);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i52);
	detstackvar(7) = r3;
	r3 = r2;
	detstackvar(8) = r4;
	detstackvar(10) = r2;
	r1 = (Integer) 40;
	r2 = detstackvar(1);
	r4 = detstackvar(9);
	call_localret(STATIC(mercury__io__maybe_write_char_5_0),
		mercury__io__write_ordinary_term_4_0_i58,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i58);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = detstackvar(7);
	detstackvar(7) = r1;
	r1 = detstackvar(10);
	call_localret(STATIC(mercury__io__adjust_priority_3_0),
		mercury__io__write_ordinary_term_4_0_i59,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i59);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(5);
	r3 = detstackvar(7);
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_ordinary_term_4_0_i60,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i60);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if ((strcmp((char *)detstackvar(2), (char *)(Word) (const Word *) string_const(",", 1)) != 0))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i61);
	r2 = r1;
	r1 = (Word) (const Word *) string_const(", ", 2);
	call_localret(STATIC(mercury__io__write_string_3_0),
		mercury__io__write_ordinary_term_4_0_i64,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i64);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r3 = detstackvar(1);
	r4 = detstackvar(6);
	r2 = detstackvar(8);
	r5 = r1;
	r1 = detstackvar(10);
	GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i68);
Define_label(mercury__io__write_ordinary_term_4_0_i61);
	r2 = r1;
	r1 = (Integer) 32;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i65,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i65);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(2);
	call_localret(ENTRY(mercury__term_io__quote_atom_3_0),
		mercury__io__write_ordinary_term_4_0_i66,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i66);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 32;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i67,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i67);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r3 = detstackvar(1);
	r4 = detstackvar(6);
	r2 = detstackvar(8);
	r5 = r1;
	r1 = detstackvar(10);
Define_label(mercury__io__write_ordinary_term_4_0_i68);
	detstackvar(1) = r3;
	detstackvar(6) = r4;
	detstackvar(5) = r5;
	detstackvar(10) = r1;
	call_localret(STATIC(mercury__io__adjust_priority_3_0),
		mercury__io__write_ordinary_term_4_0_i69,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i69);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(6);
	r3 = detstackvar(5);
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_ordinary_term_4_0_i70,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i70);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r4 = r1;
	r1 = (Integer) 41;
	r2 = detstackvar(1);
	r3 = detstackvar(10);
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	tailcall(STATIC(mercury__io__maybe_write_char_5_0),
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i52);
	r1 = detstackvar(4);
	r2 = detstackvar(9);
Define_label(mercury__io__write_ordinary_term_4_0_i51);
	if (((Integer) detstackvar(3) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i72);
	r3 = const_field(mktag(1), detstackvar(3), (Integer) 1);
	if (((Integer) r3 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i72);
	if (((Integer) const_field(mktag(1), r3, (Integer) 1) != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i72);
	detstackvar(9) = r2;
	detstackvar(7) = const_field(mktag(1), detstackvar(3), (Integer) 0);
	detstackvar(8) = const_field(mktag(1), r3, (Integer) 0);
	r2 = detstackvar(2);
	call_localret(ENTRY(mercury__ops__lookup_binary_prefix_op_5_0),
		mercury__io__write_ordinary_term_4_0_i77,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i77);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i73);
	detstackvar(4) = r3;
	r3 = r2;
	detstackvar(5) = r4;
	detstackvar(6) = r2;
	r1 = (Integer) 40;
	r2 = detstackvar(1);
	r4 = detstackvar(9);
	call_localret(STATIC(mercury__io__maybe_write_char_5_0),
		mercury__io__write_ordinary_term_4_0_i79,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i79);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(2);
	call_localret(ENTRY(mercury__term_io__quote_atom_3_0),
		mercury__io__write_ordinary_term_4_0_i80,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i80);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 32;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i81,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i81);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = detstackvar(4);
	detstackvar(4) = r1;
	r1 = detstackvar(6);
	call_localret(STATIC(mercury__io__adjust_priority_3_0),
		mercury__io__write_ordinary_term_4_0_i82,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i82);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(7);
	r3 = detstackvar(4);
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_ordinary_term_4_0_i83,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i83);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 32;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i84,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i84);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	detstackvar(4) = r1;
	r1 = detstackvar(6);
	r2 = detstackvar(5);
	call_localret(STATIC(mercury__io__adjust_priority_3_0),
		mercury__io__write_ordinary_term_4_0_i85,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i85);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(8);
	r3 = detstackvar(4);
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_ordinary_term_4_0_i37,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i73);
	r2 = detstackvar(9);
Define_label(mercury__io__write_ordinary_term_4_0_i72);
	if (((Integer) detstackvar(3) != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i88);
	detstackvar(9) = r2;
	r1 = detstackvar(2);
	call_localret(STATIC(mercury__io__ops__lookup_op__ua0_2_0),
		mercury__io__write_ordinary_term_4_0_i91,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i91);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i89);
	call_localret(ENTRY(mercury__ops__max_priority_1_0),
		mercury__io__write_ordinary_term_4_0_i93,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i93);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	if (((Integer) detstackvar(1) > (Integer) r1))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i89);
	r1 = (Integer) 40;
	r2 = detstackvar(9);
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i94,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i94);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(2);
	call_localret(ENTRY(mercury__term_io__quote_atom_3_0),
		mercury__io__write_ordinary_term_4_0_i95,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i95);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 41;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i96,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i96);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(3);
	GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i98);
Define_label(mercury__io__write_ordinary_term_4_0_i89);
	r2 = detstackvar(9);
Define_label(mercury__io__write_ordinary_term_4_0_i88);
	r1 = detstackvar(2);
	call_localret(ENTRY(mercury__term_io__quote_atom_3_0),
		mercury__io__write_ordinary_term_4_0_i97,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i97);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(3);
Define_label(mercury__io__write_ordinary_term_4_0_i98);
	if (((Integer) r1 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_ordinary_term_4_0_i99);
	detstackvar(1) = const_field(mktag(1), r1, (Integer) 0);
	detstackvar(4) = const_field(mktag(1), r1, (Integer) 1);
	r1 = (Integer) 40;
	call_localret(STATIC(mercury__io__write_char_3_0),
		mercury__io__write_ordinary_term_4_0_i102,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i102);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(1);
	call_localret(STATIC(mercury__io__write_univ_3_0),
		mercury__io__write_ordinary_term_4_0_i103,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i103);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = detstackvar(4);
	call_localret(STATIC(mercury__io__write_term_args_3_0),
		mercury__io__write_ordinary_term_4_0_i104,
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i104);
	update_prof_current_proc(LABEL(mercury__io__write_ordinary_term_4_0));
	r2 = r1;
	r1 = (Integer) 41;
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	tailcall(STATIC(mercury__io__write_char_3_0),
		STATIC(mercury__io__write_ordinary_term_4_0));
Define_label(mercury__io__write_ordinary_term_4_0_i99);
	r1 = r2;
	succip = (Code *) detstackvar(11);
	decr_sp_pop_msg(11);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module148)
	init_entry(mercury__io__maybe_write_char_5_0);
	init_label(mercury__io__maybe_write_char_5_0_i2);
BEGIN_CODE

/* code for predicate 'maybe_write_char'/5 in mode 0 */
Define_static(mercury__io__maybe_write_char_5_0);
	if (((Integer) r3 <= (Integer) r2))
		GOTO_LABEL(mercury__io__maybe_write_char_5_0_i2);
	{
		Char	Character;
		Word	IO0;
		Word	IO;
		Character = r1;
		IO0 = r4;
#line 2198 "io.m"
{		
	if (putc(Character, mercury_current_text_output->file) < 0) {
		mercury_output_error(mercury_current_text_output);
	}
	if (Character == '\n') {
		mercury_current_text_output->line_number++;
	}
	update_io(IO0, IO);
;}
#line 9219 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
Define_label(mercury__io__maybe_write_char_5_0_i2);
	r1 = r4;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module149)
	init_entry(mercury__io__adjust_priority_3_0);
	init_label(mercury__io__adjust_priority_3_0_i2);
BEGIN_CODE

/* code for predicate 'adjust_priority'/3 in mode 0 */
Define_static(mercury__io__adjust_priority_3_0);
	if (((Integer) r2 != (Integer) 0))
		GOTO_LABEL(mercury__io__adjust_priority_3_0_i2);
	r1 = ((Integer) r1 - (Integer) 1);
Define_label(mercury__io__adjust_priority_3_0_i2);
	proceed();
END_MODULE

Declare_entry(mercury____Unify___list__list_1_0);

BEGIN_MODULE(mercury__io_module150)
	init_entry(mercury__io__write_list_tail_3_0);
	init_label(mercury__io__write_list_tail_3_0_i1006);
	init_label(mercury__io__write_list_tail_3_0_i4);
	init_label(mercury__io__write_list_tail_3_0_i7);
	init_label(mercury__io__write_list_tail_3_0_i9);
	init_label(mercury__io__write_list_tail_3_0_i3);
	init_label(mercury__io__write_list_tail_3_0_i13);
	init_label(mercury__io__write_list_tail_3_0_i14);
	init_label(mercury__io__write_list_tail_3_0_i12);
BEGIN_CODE

/* code for predicate 'write_list_tail'/3 in mode 0 */
Define_static(mercury__io__write_list_tail_3_0);
	incr_sp_push_msg(5, "io:write_list_tail/3");
	detstackvar(5) = (Word) succip;
Define_label(mercury__io__write_list_tail_3_0_i1006);
	detstackvar(1) = r1;
	detstackvar(2) = r2;
	r1 = (Word) (const Word *) &mercury_data_std_util__base_type_info_univ_0;
	r2 = detstackvar(1);
	call_localret(ENTRY(mercury__std_util__deconstruct_4_0),
		mercury__io__write_list_tail_3_0_i4,
		STATIC(mercury__io__write_list_tail_3_0));
Define_label(mercury__io__write_list_tail_3_0_i4);
	update_prof_current_proc(LABEL(mercury__io__write_list_tail_3_0));
	if ((strcmp((char *)(Word) (const Word *) string_const(".", 1), (char *)r1) != 0))
		GOTO_LABEL(mercury__io__write_list_tail_3_0_i3);
	if (((Integer) r3 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_list_tail_3_0_i3);
	if (((Integer) const_field(mktag(1), r3, (Integer) 1) == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_list_tail_3_0_i3);
	detstackvar(3) = const_field(mktag(1), r3, (Integer) 0);
	detstackvar(4) = const_field(mktag(1), const_field(mktag(1), r3, (Integer) 1), (Integer) 0);
	r1 = (Word) (const Word *) &mercury_data_std_util__base_type_info_univ_0;
	r4 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	r3 = const_field(mktag(1), const_field(mktag(1), r3, (Integer) 1), (Integer) 1);
	call_localret(ENTRY(mercury____Unify___list__list_1_0),
		mercury__io__write_list_tail_3_0_i7,
		STATIC(mercury__io__write_list_tail_3_0));
Define_label(mercury__io__write_list_tail_3_0_i7);
	update_prof_current_proc(LABEL(mercury__io__write_list_tail_3_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_list_tail_3_0_i3);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) (Word) (const Word *) string_const(", ", 2);
		IO0 = detstackvar(2);
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 9303 "io.c"
		r3 = IO;

	}
	r1 = detstackvar(3);
	r2 = (Integer) 1201;
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_list_tail_3_0_i9,
		STATIC(mercury__io__write_list_tail_3_0));
Define_label(mercury__io__write_list_tail_3_0_i9);
	update_prof_current_proc(LABEL(mercury__io__write_list_tail_3_0));
	r2 = r1;
	r1 = detstackvar(4);
	succip = (Code *) detstackvar(5);
	GOTO_LABEL(mercury__io__write_list_tail_3_0_i1006);
Define_label(mercury__io__write_list_tail_3_0_i3);
	r1 = (Word) (const Word *) &mercury_data_std_util__base_type_info_univ_0;
	r2 = detstackvar(1);
	call_localret(ENTRY(mercury__std_util__deconstruct_4_0),
		mercury__io__write_list_tail_3_0_i13,
		STATIC(mercury__io__write_list_tail_3_0));
Define_label(mercury__io__write_list_tail_3_0_i13);
	update_prof_current_proc(LABEL(mercury__io__write_list_tail_3_0));
	if ((strcmp((char *)(Word) (const Word *) string_const("[]", 2), (char *)r1) != 0))
		GOTO_LABEL(mercury__io__write_list_tail_3_0_i12);
	r1 = (Word) (const Word *) &mercury_data_std_util__base_type_info_univ_0;
	r4 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), mkbody((Integer) 0));
	call_localret(ENTRY(mercury____Unify___list__list_1_0),
		mercury__io__write_list_tail_3_0_i14,
		STATIC(mercury__io__write_list_tail_3_0));
Define_label(mercury__io__write_list_tail_3_0_i14);
	update_prof_current_proc(LABEL(mercury__io__write_list_tail_3_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__write_list_tail_3_0_i12);
	r1 = detstackvar(2);
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	proceed();
Define_label(mercury__io__write_list_tail_3_0_i12);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) (Word) (const Word *) string_const(" | ", 3);
		IO0 = detstackvar(2);
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 9354 "io.c"
		r3 = IO;

	}
	r1 = detstackvar(1);
	r2 = (Integer) 1201;
	succip = (Code *) detstackvar(5);
	decr_sp_pop_msg(5);
	tailcall(STATIC(mercury__io__write_univ_4_0),
		STATIC(mercury__io__write_list_tail_3_0));
END_MODULE


BEGIN_MODULE(mercury__io_module151)
	init_entry(mercury__io__write_term_args_3_0);
	init_label(mercury__io__write_term_args_3_0_i1001);
	init_label(mercury__io__write_term_args_3_0_i4);
	init_label(mercury__io__write_term_args_3_0_i3);
BEGIN_CODE

/* code for predicate 'write_term_args'/3 in mode 0 */
Define_static(mercury__io__write_term_args_3_0);
	incr_sp_push_msg(2, "io:write_term_args/3");
	detstackvar(2) = (Word) succip;
Define_label(mercury__io__write_term_args_3_0_i1001);
	if (((Integer) r1 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury__io__write_term_args_3_0_i3);
	{
		String	Message;
		Word	IO0;
		Word	IO;
		Message = (String) (Word) (const Word *) string_const(", ", 2);
		IO0 = r2;
#line 2193 "io.m"
{		
	mercury_print_string(mercury_current_text_output, Message);
	update_io(IO0, IO);
;}
#line 9392 "io.c"
		r3 = IO;

	}
	detstackvar(1) = const_field(mktag(1), r1, (Integer) 1);
	r1 = const_field(mktag(1), r1, (Integer) 0);
	r2 = (Integer) 1201;
	call_localret(STATIC(mercury__io__write_univ_4_0),
		mercury__io__write_term_args_3_0_i4,
		STATIC(mercury__io__write_term_args_3_0));
Define_label(mercury__io__write_term_args_3_0_i4);
	update_prof_current_proc(LABEL(mercury__io__write_term_args_3_0));
	r2 = r1;
	r1 = detstackvar(1);
	succip = (Code *) detstackvar(2);
	GOTO_LABEL(mercury__io__write_term_args_3_0_i1001);
Define_label(mercury__io__write_term_args_3_0_i3);
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module152)
	init_entry(mercury__io__convert_read_result_2_0);
BEGIN_CODE

/* code for predicate 'convert_read_result'/2 in mode 0 */
Define_entry(mercury__io__convert_read_result_2_0);
	r1 = r2;
	tailcall(STATIC(mercury__io__convert_read_result__ua10000_2_0),
		ENTRY(mercury__io__convert_read_result_2_0));
END_MODULE

Declare_entry(mercury__tree234__search_3_0);

BEGIN_MODULE(mercury__io_module153)
	init_entry(mercury__io__stream_name_4_0);
	init_label(mercury__io__stream_name_4_0_i4);
	init_label(mercury__io__stream_name_4_0_i3);
	init_label(mercury__io__stream_name_4_0_i6);
BEGIN_CODE

/* code for predicate 'stream_name'/4 in mode 0 */
Define_entry(mercury__io__stream_name_4_0);
	incr_sp_push_msg(3, "io:stream_name/4");
	detstackvar(3) = (Word) succip;
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 9450 "io.c"
		r3 = StreamNames;
		r4 = IO;

	}
	detstackvar(1) = r3;
	detstackvar(2) = r4;
	r2 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r5 = r2;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	r4 = r5;
	call_localret(ENTRY(mercury__tree234__search_3_0),
		mercury__io__stream_name_4_0_i4,
		ENTRY(mercury__io__stream_name_4_0));
Define_label(mercury__io__stream_name_4_0_i4);
	update_prof_current_proc(LABEL(mercury__io__stream_name_4_0));
	if (!(r1))
		GOTO_LABEL(mercury__io__stream_name_4_0_i3);
	r1 = r2;
	r2 = detstackvar(1);
	r3 = detstackvar(2);
	GOTO_LABEL(mercury__io__stream_name_4_0_i6);
Define_label(mercury__io__stream_name_4_0_i3);
	r1 = (Word) (const Word *) string_const("<stream name unavailable>", 25);
	r2 = detstackvar(1);
	r3 = detstackvar(2);
Define_label(mercury__io__stream_name_4_0_i6);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r2;
		IO0 = r3;
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 9489 "io.c"
		r4 = IO;

	}
	r2 = r4;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module154)
	init_entry(mercury__io__get_stream_names_3_0);
BEGIN_CODE

/* code for predicate 'get_stream_names'/3 in mode 0 */
Define_static(mercury__io__get_stream_names_3_0);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 9516 "io.c"
		r2 = StreamNames;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module155)
	init_entry(mercury__io__set_stream_names_3_0);
BEGIN_CODE

/* code for predicate 'set_stream_names'/3 in mode 0 */
Define_static(mercury__io__set_stream_names_3_0);
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = r2;
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 9544 "io.c"
		r3 = IO;

	}
	r1 = r3;
	proceed();
END_MODULE

Declare_entry(mercury__tree234__init_1_0);

BEGIN_MODULE(mercury__io_module156)
	init_entry(mercury__io__init_state_2_0);
	init_label(mercury__io__init_state_2_0_i2);
BEGIN_CODE

/* code for predicate 'init_state'/2 in mode 0 */
Define_static(mercury__io__init_state_2_0);
	incr_sp_push_msg(2, "io:init_state/2");
	detstackvar(2) = (Word) succip;
	{
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 1943 "io.m"
{		
	/* for Windows DLLs, we need to call GC_INIT() from each DLL */
#ifdef CONSERVATIVE_GC
	GC_INIT();
#endif
	update_io(IO0, IO);
;}
#line 9575 "io.c"
		r2 = IO;

	}
	detstackvar(1) = r2;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	call_localret(ENTRY(mercury__tree234__init_1_0),
		mercury__io__init_state_2_0_i2,
		STATIC(mercury__io__init_state_2_0));
Define_label(mercury__io__init_state_2_0_i2);
	update_prof_current_proc(LABEL(mercury__io__init_state_2_0));
	{
		Word	TypeInfo_for_T;
		Word	Type;
		Word	Univ;
		TypeInfo_for_T = (Word) (const Word *) &mercury_data___base_type_info_string_0;
		Type = (Word) (const Word *) string_const("<globals>", 9);
{		
	incr_hp(Univ, 2);
	field(mktag(0), Univ, UNIV_OFFSET_FOR_TYPEINFO) = (Word) TypeInfo_for_T;
	field(mktag(0), Univ, UNIV_OFFSET_FOR_DATA) = (Word) Type;
;}
#line 9598 "io.c"
		r2 = Univ;

	}
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(1);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 9613 "io.c"
		r3 = IO;

	}
	{
		Word	Globals;
		Word	IOState0;
		Word	IOState;
		Globals = r2;
		IOState0 = r3;
#line 1857 "io.m"
{		
	ML_io_user_globals = Globals;
	update_io(IOState0, IOState);
;}
#line 9628 "io.c"
		r1 = IOState;

	}
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	tailcall(STATIC(mercury__io__insert_std_stream_names_2_0),
		STATIC(mercury__io__init_state_2_0));
END_MODULE


BEGIN_MODULE(mercury__io_module157)
	init_entry(mercury__io__finalize_state_2_0);
BEGIN_CODE

/* code for predicate 'finalize_state'/2 in mode 0 */
Define_static(mercury__io__finalize_state_2_0);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module158)
	init_entry(mercury__io__gc_init_2_0);
BEGIN_CODE

/* code for predicate 'gc_init'/2 in mode 0 */
Define_static(mercury__io__gc_init_2_0);
	{
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 1943 "io.m"
{		
	/* for Windows DLLs, we need to call GC_INIT() from each DLL */
#ifdef CONSERVATIVE_GC
	GC_INIT();
#endif
	update_io(IO0, IO);
;}
#line 9667 "io.c"
		r2 = IO;

	}
	r1 = r2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module159)
	init_entry(mercury__io__insert_std_stream_names_2_0);
	init_label(mercury__io__insert_std_stream_names_2_0_i2);
	init_label(mercury__io__insert_std_stream_names_2_0_i3);
	init_label(mercury__io__insert_std_stream_names_2_0_i4);
BEGIN_CODE

/* code for predicate 'insert_std_stream_names'/2 in mode 0 */
Define_static(mercury__io__insert_std_stream_names_2_0);
	incr_sp_push_msg(2, "io:insert_std_stream_names/2");
	detstackvar(2) = (Word) succip;
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2353 "io.m"
{		
	Stream = (Word) &mercury_stdin;
	update_io(IO0, IO);
;}
#line 9697 "io.c"
		r4 = Stream;
		r2 = IO;

	}
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 9712 "io.c"
		r3 = StreamNames;
		r1 = IO;

	}
	detstackvar(1) = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	r5 = (Word) (const Word *) string_const("<standard input>", 16);
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__insert_std_stream_names_2_0_i2,
		STATIC(mercury__io__insert_std_stream_names_2_0));
Define_label(mercury__io__insert_std_stream_names_2_0_i2);
	update_prof_current_proc(LABEL(mercury__io__insert_std_stream_names_2_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(1);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 9737 "io.c"
		r2 = IO;

	}
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 2358 "io.m"
{		
	Stream = (Word) &mercury_stdout;
	update_io(IO0, IO);
;}
#line 9751 "io.c"
		r4 = Stream;
		r1 = IO;

	}
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 9766 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	detstackvar(1) = r2;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	r5 = (Word) (const Word *) string_const("<standard output>", 17);
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__insert_std_stream_names_2_0_i3,
		STATIC(mercury__io__insert_std_stream_names_2_0));
Define_label(mercury__io__insert_std_stream_names_2_0_i3);
	update_prof_current_proc(LABEL(mercury__io__insert_std_stream_names_2_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(1);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 9791 "io.c"
		r2 = IO;

	}
	{
		Word	Stream;
		Word	IO0;
		Word	IO;
		IO0 = r2;
#line 2363 "io.m"
{		
	Stream = (Word) &mercury_stderr;
	update_io(IO0, IO);
;}
#line 9805 "io.c"
		r4 = Stream;
		r1 = IO;

	}
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 1815 "io.m"
{		
	StreamNames = ML_io_stream_names;
	update_io(IO0, IO);
;}
#line 9820 "io.c"
		r3 = StreamNames;
		r2 = IO;

	}
	detstackvar(1) = r2;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	r5 = (Word) (const Word *) string_const("<standard error>", 16);
	call_localret(ENTRY(mercury__map__set_4_1),
		mercury__io__insert_std_stream_names_2_0_i4,
		STATIC(mercury__io__insert_std_stream_names_2_0));
Define_label(mercury__io__insert_std_stream_names_2_0_i4);
	update_prof_current_proc(LABEL(mercury__io__insert_std_stream_names_2_0));
	{
		Word	StreamNames;
		Word	IO0;
		Word	IO;
		StreamNames = r1;
		IO0 = detstackvar(1);
#line 1823 "io.m"
{		
	ML_io_stream_names = StreamNames;
	update_io(IO0, IO);
;}
#line 9845 "io.c"
		r2 = IO;

	}
	r1 = r2;
	succip = (Code *) detstackvar(2);
	decr_sp_pop_msg(2);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module160)
	init_entry(mercury__io__whence_to_int_2_0);
	init_label(mercury__io__whence_to_int_2_0_i3);
	init_label(mercury__io__whence_to_int_2_0_i4);
BEGIN_CODE

/* code for predicate 'whence_to_int'/2 in mode 0 */
Define_entry(mercury__io__whence_to_int_2_0);
	if (((Integer) r1 != (Integer) 0))
		GOTO_LABEL(mercury__io__whence_to_int_2_0_i3);
	r1 = (Integer) 0;
	proceed();
Define_label(mercury__io__whence_to_int_2_0_i3);
	if (((Integer) r1 != (Integer) 1))
		GOTO_LABEL(mercury__io__whence_to_int_2_0_i4);
	r1 = (Integer) 1;
	proceed();
Define_label(mercury__io__whence_to_int_2_0_i4);
	r1 = (Integer) 2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module161)
	init_entry(mercury__io__seek_binary_2_5_0);
BEGIN_CODE

/* code for predicate 'seek_binary_2'/5 in mode 0 */
Define_entry(mercury__io__seek_binary_2_5_0);
	{
		Word	Stream;
		Integer	Flag;
		Integer	Off;
		Word	IO0;
		Word	IO;
		Stream = r1;
		Flag = r2;
		Off = r3;
		IO0 = r4;
#line 2265 "io.m"
{		{
	static const int seek_flags[] = { SEEK_SET, SEEK_CUR, SEEK_END };
	MercuryFile *stream = (MercuryFile *) Stream;
	fseek(stream->file, Off, seek_flags[Flag]);
	IO = IO0;
};}
#line 9902 "io.c"
		r5 = IO;

	}
	r1 = r5;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module162)
	init_entry(mercury__io__tmpnam_2_3_0);
BEGIN_CODE

/* code for predicate 'tmpnam_2'/3 in mode 0 */
Define_static(mercury__io__tmpnam_2_3_0);
	{
		String	FileName;
		Word	IO0;
		Word	IO;
		IO0 = r1;
#line 2634 "io.m"
{		{
	Word tmp;

	incr_hp_atomic(tmp, (L_tmpnam + sizeof(Word)) / sizeof(Word));
	if (tmpnam((char *)tmp) == NULL) {
		fatal_error("unable to create temporary filename");
	}
	FileName = (char *)tmp;
	update_io(IO0, IO);
};}
#line 9933 "io.c"
		r2 = (Word) FileName;
		r3 = IO;

	}
	r1 = r2;
	r2 = r3;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module163)
	init_entry(mercury__io__remove_file_2_5_0);
BEGIN_CODE

/* code for predicate 'remove_file_2'/5 in mode 0 */
Define_static(mercury__io__remove_file_2_5_0);
	{
		String	FileName;
		Integer	RetVal;
		String	RetStr;
		Word	IO0;
		Word	IO;
		FileName = (String) r1;
		IO0 = r2;
#line 2731 "io.m"
{		{
	Word tmp;
	char *buf;

	RetVal = remove(FileName);

	if (RetVal < 0) {
		buf = strerror(errno);
		incr_hp_atomic(tmp,(strlen(buf)+sizeof(Word)) / sizeof(Word));
		RetStr = (char *)tmp;
		strcpy(RetStr, (char *)tmp);
	} else {
		RetStr = NULL;
	}
	update_io(IO0, IO);
};}
#line 9975 "io.c"
		r3 = RetVal;
		r4 = (Word) RetStr;
		r5 = IO;

	}
	r1 = r3;
	r2 = r4;
	r3 = r5;
	proceed();
END_MODULE

Declare_entry(mercury____Unify___mercury_builtin__c_pointer_0_0);

BEGIN_MODULE(mercury__io_module164)
	init_entry(mercury____Unify___io__state_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__state_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Unify___io__state_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module165)
	init_entry(mercury____Index___io__state_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__state_0_0);
	tailcall(STATIC(mercury____Index___io__state_0__ua10000_2_0),
		ENTRY(mercury____Index___io__state_0_0));
END_MODULE

Declare_entry(mercury____Compare___mercury_builtin__c_pointer_0_0);

BEGIN_MODULE(mercury__io_module166)
	init_entry(mercury____Compare___io__state_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__state_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Compare___io__state_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module167)
	init_entry(mercury____Unify___io__input_stream_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__input_stream_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Unify___io__input_stream_0_0));
END_MODULE

Declare_entry(mercury____Index___mercury_builtin__c_pointer_0_0);

BEGIN_MODULE(mercury__io_module168)
	init_entry(mercury____Index___io__input_stream_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__input_stream_0_0);
	tailcall(ENTRY(mercury____Index___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Index___io__input_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module169)
	init_entry(mercury____Compare___io__input_stream_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__input_stream_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Compare___io__input_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module170)
	init_entry(mercury____Unify___io__output_stream_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__output_stream_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Unify___io__output_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module171)
	init_entry(mercury____Index___io__output_stream_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__output_stream_0_0);
	tailcall(ENTRY(mercury____Index___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Index___io__output_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module172)
	init_entry(mercury____Compare___io__output_stream_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__output_stream_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Compare___io__output_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module173)
	init_entry(mercury____Unify___io__binary_input_stream_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__binary_input_stream_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Unify___io__binary_input_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module174)
	init_entry(mercury____Index___io__binary_input_stream_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__binary_input_stream_0_0);
	tailcall(ENTRY(mercury____Index___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Index___io__binary_input_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module175)
	init_entry(mercury____Compare___io__binary_input_stream_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__binary_input_stream_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Compare___io__binary_input_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module176)
	init_entry(mercury____Unify___io__binary_output_stream_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__binary_output_stream_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Unify___io__binary_output_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module177)
	init_entry(mercury____Index___io__binary_output_stream_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__binary_output_stream_0_0);
	tailcall(ENTRY(mercury____Index___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Index___io__binary_output_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module178)
	init_entry(mercury____Compare___io__binary_output_stream_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__binary_output_stream_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Compare___io__binary_output_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module179)
	init_entry(mercury____Unify___io__binary_stream_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__binary_stream_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Unify___io__binary_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module180)
	init_entry(mercury____Index___io__binary_stream_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__binary_stream_0_0);
	tailcall(ENTRY(mercury____Index___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Index___io__binary_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module181)
	init_entry(mercury____Compare___io__binary_stream_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__binary_stream_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		ENTRY(mercury____Compare___io__binary_stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module182)
	init_entry(mercury____Unify___io__res_0_0);
	init_label(mercury____Unify___io__res_0_0_i3);
	init_label(mercury____Unify___io__res_0_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__res_0_0);
	if (((Integer) r1 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___io__res_0_0_i3);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___io__res_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__res_0_0_i3);
	if (((Integer) r2 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___io__res_0_0_i1);
	if ((strcmp((char *)const_field(mktag(1), r1, (Integer) 0), (char *)const_field(mktag(1), r2, (Integer) 0)) != 0))
		GOTO_LABEL(mercury____Unify___io__res_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__res_0_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module183)
	init_entry(mercury____Index___io__res_0_0);
	init_label(mercury____Index___io__res_0_0_i3);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__res_0_0);
	if (((Integer) r1 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Index___io__res_0_0_i3);
	r1 = (Integer) 0;
	proceed();
Define_label(mercury____Index___io__res_0_0_i3);
	r1 = (Integer) 1;
	proceed();
END_MODULE

Declare_entry(mercury__builtin_compare_string_3_0);

BEGIN_MODULE(mercury__io_module184)
	init_entry(mercury____Compare___io__res_0_0);
	init_label(mercury____Compare___io__res_0_0_i3);
	init_label(mercury____Compare___io__res_0_0_i2);
	init_label(mercury____Compare___io__res_0_0_i5);
	init_label(mercury____Compare___io__res_0_0_i4);
	init_label(mercury____Compare___io__res_0_0_i6);
	init_label(mercury____Compare___io__res_0_0_i8);
	init_label(mercury____Compare___io__res_0_0_i13);
	init_label(mercury____Compare___io__res_0_0_i10);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__res_0_0);
	if (((Integer) r1 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__res_0_0_i3);
	r3 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__res_0_0_i2);
Define_label(mercury____Compare___io__res_0_0_i3);
	r3 = (Integer) 1;
Define_label(mercury____Compare___io__res_0_0_i2);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__res_0_0_i5);
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
	r4 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__res_0_0_i4);
Define_label(mercury____Compare___io__res_0_0_i5);
	r4 = (Integer) 1;
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
Define_label(mercury____Compare___io__res_0_0_i4);
	if (((Integer) r3 >= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__res_0_0_i6);
	r1 = (Integer) 1;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__res_0_0_i6);
	if (((Integer) r3 <= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__res_0_0_i8);
	r1 = (Integer) 2;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__res_0_0_i8);
	if (((Integer) r1 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__res_0_0_i13);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__res_0_0_i10);
	r1 = (Integer) 0;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__res_0_0_i13);
	if (((Integer) r2 == (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__res_0_0_i10);
	r1 = const_field(mktag(1), r1, (Integer) 0);
	r2 = const_field(mktag(1), r2, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(ENTRY(mercury__builtin_compare_string_3_0),
		ENTRY(mercury____Compare___io__res_0_0));
Define_label(mercury____Compare___io__res_0_0_i10);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("internal error in compare/3", 27);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 10309 "io.c"

	}
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE

Declare_entry(mercury__unify_2_0);

BEGIN_MODULE(mercury__io_module185)
	init_entry(mercury____Unify___io__res_1_0);
	init_label(mercury____Unify___io__res_1_0_i3);
	init_label(mercury____Unify___io__res_1_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__res_1_0);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Unify___io__res_1_0_i3);
	if ((tag(r3) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Unify___io__res_1_0_i1);
	r2 = const_field(mktag(0), r2, (Integer) 0);
	r3 = const_field(mktag(0), r3, (Integer) 0);
	tailcall(ENTRY(mercury__unify_2_0),
		ENTRY(mercury____Unify___io__res_1_0));
Define_label(mercury____Unify___io__res_1_0_i3);
	if ((tag(r3) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Unify___io__res_1_0_i1);
	if ((strcmp((char *)const_field(mktag(1), r2, (Integer) 0), (char *)const_field(mktag(1), r3, (Integer) 0)) != 0))
		GOTO_LABEL(mercury____Unify___io__res_1_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__res_1_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module186)
	init_entry(mercury____Index___io__res_1_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__res_1_0);
	r1 = r2;
	tailcall(STATIC(mercury____Index___io__res_1__ua10000_2_0),
		ENTRY(mercury____Index___io__res_1_0));
END_MODULE

Declare_entry(mercury__compare_3_3);

BEGIN_MODULE(mercury__io_module187)
	init_entry(mercury____Compare___io__res_1_0);
	init_label(mercury____Compare___io__res_1_0_i3);
	init_label(mercury____Compare___io__res_1_0_i2);
	init_label(mercury____Compare___io__res_1_0_i5);
	init_label(mercury____Compare___io__res_1_0_i4);
	init_label(mercury____Compare___io__res_1_0_i6);
	init_label(mercury____Compare___io__res_1_0_i8);
	init_label(mercury____Compare___io__res_1_0_i13);
	init_label(mercury____Compare___io__res_1_0_i10);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__res_1_0);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__res_1_0_i3);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__res_1_0_i2);
Define_label(mercury____Compare___io__res_1_0_i3);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 1;
Define_label(mercury____Compare___io__res_1_0_i2);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__res_1_0_i5);
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
	r5 = r4;
	r4 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__res_1_0_i4);
Define_label(mercury____Compare___io__res_1_0_i5);
	r5 = r4;
	r4 = (Integer) 1;
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
Define_label(mercury____Compare___io__res_1_0_i4);
	if (((Integer) r3 >= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__res_1_0_i6);
	r1 = (Integer) 1;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__res_1_0_i6);
	if (((Integer) r3 <= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__res_1_0_i8);
	r1 = (Integer) 2;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__res_1_0_i8);
	if ((tag(r1) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__res_1_0_i13);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__res_1_0_i10);
	r3 = r1;
	r1 = r5;
	r4 = r2;
	r2 = const_field(mktag(0), r3, (Integer) 0);
	r3 = const_field(mktag(0), r4, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(ENTRY(mercury__compare_3_3),
		ENTRY(mercury____Compare___io__res_1_0));
Define_label(mercury____Compare___io__res_1_0_i13);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__res_1_0_i10);
	r1 = const_field(mktag(1), r1, (Integer) 0);
	r2 = const_field(mktag(1), r2, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(ENTRY(mercury__builtin_compare_string_3_0),
		ENTRY(mercury____Compare___io__res_1_0));
Define_label(mercury____Compare___io__res_1_0_i10);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("internal error in compare/3", 27);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 10449 "io.c"

	}
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module188)
	init_entry(mercury____Unify___io__result_0_0);
	init_label(mercury____Unify___io__result_0_0_i5);
	init_label(mercury____Unify___io__result_0_0_i4);
	init_label(mercury____Unify___io__result_0_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__result_0_0);
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Unify___io__result_0_0_i4);
	if (((Integer) unmkbody(r1) != (Integer) 0))
		GOTO_LABEL(mercury____Unify___io__result_0_0_i5);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___io__result_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__result_0_0_i5);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 1))))
		GOTO_LABEL(mercury____Unify___io__result_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__result_0_0_i4);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Unify___io__result_0_0_i1);
	if ((strcmp((char *)const_field(mktag(1), r1, (Integer) 0), (char *)const_field(mktag(1), r2, (Integer) 0)) != 0))
		GOTO_LABEL(mercury____Unify___io__result_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__result_0_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module189)
	init_entry(mercury____Index___io__result_0_0);
	init_label(mercury____Index___io__result_0_0_i5);
	init_label(mercury____Index___io__result_0_0_i4);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__result_0_0);
	r2 = tag(r1);
	if ((r2 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Index___io__result_0_0_i4);
	if (((Integer) unmkbody(r1) != (Integer) 0))
		GOTO_LABEL(mercury____Index___io__result_0_0_i5);
	r1 = (Integer) 0;
	proceed();
Define_label(mercury____Index___io__result_0_0_i5);
	r1 = (Integer) 1;
	proceed();
Define_label(mercury____Index___io__result_0_0_i4);
	r1 = (Integer) 2;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module190)
	init_entry(mercury____Compare___io__result_0_0);
	init_label(mercury____Compare___io__result_0_0_i5);
	init_label(mercury____Compare___io__result_0_0_i4);
	init_label(mercury____Compare___io__result_0_0_i2);
	init_label(mercury____Compare___io__result_0_0_i9);
	init_label(mercury____Compare___io__result_0_0_i8);
	init_label(mercury____Compare___io__result_0_0_i6);
	init_label(mercury____Compare___io__result_0_0_i10);
	init_label(mercury____Compare___io__result_0_0_i12);
	init_label(mercury____Compare___io__result_0_0_i19);
	init_label(mercury____Compare___io__result_0_0_i18);
	init_label(mercury____Compare___io__result_0_0_i14);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__result_0_0);
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i4);
	if (((Integer) unmkbody(r1) != (Integer) 0))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i5);
	r3 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__result_0_0_i2);
Define_label(mercury____Compare___io__result_0_0_i5);
	r3 = (Integer) 1;
	GOTO_LABEL(mercury____Compare___io__result_0_0_i2);
Define_label(mercury____Compare___io__result_0_0_i4);
	r3 = (Integer) 2;
Define_label(mercury____Compare___io__result_0_0_i2);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i8);
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
	if (((Integer) unmkbody(r2) != (Integer) 0))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i9);
	r4 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__result_0_0_i6);
Define_label(mercury____Compare___io__result_0_0_i9);
	r4 = (Integer) 1;
	GOTO_LABEL(mercury____Compare___io__result_0_0_i6);
Define_label(mercury____Compare___io__result_0_0_i8);
	r4 = (Integer) 2;
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
Define_label(mercury____Compare___io__result_0_0_i6);
	if (((Integer) r3 >= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i10);
	r1 = (Integer) 1;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__result_0_0_i10);
	if (((Integer) r3 <= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i12);
	r1 = (Integer) 2;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__result_0_0_i12);
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i18);
	if (((Integer) unmkbody(r1) != (Integer) 0))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i19);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i14);
	r1 = (Integer) 0;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__result_0_0_i19);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 1))))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i14);
	r1 = (Integer) 0;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__result_0_0_i18);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__result_0_0_i14);
	r1 = const_field(mktag(1), r1, (Integer) 0);
	r2 = const_field(mktag(1), r2, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(ENTRY(mercury__builtin_compare_string_3_0),
		ENTRY(mercury____Compare___io__result_0_0));
Define_label(mercury____Compare___io__result_0_0_i14);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("internal error in compare/3", 27);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 10617 "io.c"

	}
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module191)
	init_entry(mercury____Unify___io__result_1_0);
	init_label(mercury____Unify___io__result_1_0_i4);
	init_label(mercury____Unify___io__result_1_0_i6);
	init_label(mercury____Unify___io__result_1_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__result_1_0);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Unify___io__result_1_0_i4);
	if (((Integer) r3 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___io__result_1_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__result_1_0_i4);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Unify___io__result_1_0_i6);
	if ((tag(r3) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Unify___io__result_1_0_i1);
	r2 = const_field(mktag(1), r2, (Integer) 0);
	r3 = const_field(mktag(1), r3, (Integer) 0);
	tailcall(ENTRY(mercury__unify_2_0),
		ENTRY(mercury____Unify___io__result_1_0));
Define_label(mercury____Unify___io__result_1_0_i6);
	if ((tag(r3) != mktag((Integer) 2)))
		GOTO_LABEL(mercury____Unify___io__result_1_0_i1);
	if ((strcmp((char *)const_field(mktag(2), r2, (Integer) 0), (char *)const_field(mktag(2), r3, (Integer) 0)) != 0))
		GOTO_LABEL(mercury____Unify___io__result_1_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__result_1_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module192)
	init_entry(mercury____Index___io__result_1_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__result_1_0);
	r1 = r2;
	tailcall(STATIC(mercury____Index___io__result_1__ua10000_2_0),
		ENTRY(mercury____Index___io__result_1_0));
END_MODULE


BEGIN_MODULE(mercury__io_module193)
	init_entry(mercury____Compare___io__result_1_0);
	init_label(mercury____Compare___io__result_1_0_i4);
	init_label(mercury____Compare___io__result_1_0_i5);
	init_label(mercury____Compare___io__result_1_0_i2);
	init_label(mercury____Compare___io__result_1_0_i8);
	init_label(mercury____Compare___io__result_1_0_i9);
	init_label(mercury____Compare___io__result_1_0_i6);
	init_label(mercury____Compare___io__result_1_0_i10);
	init_label(mercury____Compare___io__result_1_0_i12);
	init_label(mercury____Compare___io__result_1_0_i18);
	init_label(mercury____Compare___io__result_1_0_i20);
	init_label(mercury____Compare___io__result_1_0_i14);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__result_1_0);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i4);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 1;
	GOTO_LABEL(mercury____Compare___io__result_1_0_i2);
Define_label(mercury____Compare___io__result_1_0_i4);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i5);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__result_1_0_i2);
Define_label(mercury____Compare___io__result_1_0_i5);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 2;
Define_label(mercury____Compare___io__result_1_0_i2);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i8);
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
	r5 = r4;
	r4 = (Integer) 1;
	GOTO_LABEL(mercury____Compare___io__result_1_0_i6);
Define_label(mercury____Compare___io__result_1_0_i8);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i9);
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
	r5 = r4;
	r4 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__result_1_0_i6);
Define_label(mercury____Compare___io__result_1_0_i9);
	r5 = r4;
	r4 = (Integer) 2;
	incr_sp_push_msg(1, "io:__Compare__/3");
	detstackvar(1) = (Word) succip;
Define_label(mercury____Compare___io__result_1_0_i6);
	if (((Integer) r3 >= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i10);
	r1 = (Integer) 1;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__result_1_0_i10);
	if (((Integer) r3 <= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i12);
	r1 = (Integer) 2;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__result_1_0_i12);
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i18);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i14);
	r1 = (Integer) 0;
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
Define_label(mercury____Compare___io__result_1_0_i18);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i20);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i14);
	r3 = r1;
	r1 = r5;
	r4 = r2;
	r2 = const_field(mktag(1), r3, (Integer) 0);
	r3 = const_field(mktag(1), r4, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(ENTRY(mercury__compare_3_3),
		ENTRY(mercury____Compare___io__result_1_0));
Define_label(mercury____Compare___io__result_1_0_i20);
	if ((tag(r2) != mktag((Integer) 2)))
		GOTO_LABEL(mercury____Compare___io__result_1_0_i14);
	r1 = const_field(mktag(2), r1, (Integer) 0);
	r2 = const_field(mktag(2), r2, (Integer) 0);
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	tailcall(ENTRY(mercury__builtin_compare_string_3_0),
		ENTRY(mercury____Compare___io__result_1_0));
Define_label(mercury____Compare___io__result_1_0_i14);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("internal error in compare/3", 27);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 10792 "io.c"

	}
	succip = (Code *) detstackvar(1);
	decr_sp_pop_msg(1);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module194)
	init_entry(mercury____Unify___io__read_result_1_0);
	init_label(mercury____Unify___io__read_result_1_0_i4);
	init_label(mercury____Unify___io__read_result_1_0_i6);
	init_label(mercury____Unify___io__read_result_1_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__read_result_1_0);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Unify___io__read_result_1_0_i4);
	if (((Integer) r3 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Unify___io__read_result_1_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__read_result_1_0_i4);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Unify___io__read_result_1_0_i6);
	if ((tag(r3) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Unify___io__read_result_1_0_i1);
	r2 = const_field(mktag(1), r2, (Integer) 0);
	r3 = const_field(mktag(1), r3, (Integer) 0);
	tailcall(ENTRY(mercury__unify_2_0),
		ENTRY(mercury____Unify___io__read_result_1_0));
Define_label(mercury____Unify___io__read_result_1_0_i6);
	if ((tag(r3) != mktag((Integer) 2)))
		GOTO_LABEL(mercury____Unify___io__read_result_1_0_i1);
	if ((strcmp((char *)const_field(mktag(2), r2, (Integer) 0), (char *)const_field(mktag(2), r3, (Integer) 0)) != 0))
		GOTO_LABEL(mercury____Unify___io__read_result_1_0_i1);
	if ((const_field(mktag(2), r2, (Integer) 1) != const_field(mktag(2), r3, (Integer) 1)))
		GOTO_LABEL(mercury____Unify___io__read_result_1_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__read_result_1_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module195)
	init_entry(mercury____Index___io__read_result_1_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__read_result_1_0);
	r1 = r2;
	tailcall(STATIC(mercury____Index___io__read_result_1__ua10000_2_0),
		ENTRY(mercury____Index___io__read_result_1_0));
END_MODULE

Declare_entry(mercury__builtin_compare_int_3_0);

BEGIN_MODULE(mercury__io_module196)
	init_entry(mercury____Compare___io__read_result_1_0);
	init_label(mercury____Compare___io__read_result_1_0_i4);
	init_label(mercury____Compare___io__read_result_1_0_i5);
	init_label(mercury____Compare___io__read_result_1_0_i2);
	init_label(mercury____Compare___io__read_result_1_0_i8);
	init_label(mercury____Compare___io__read_result_1_0_i9);
	init_label(mercury____Compare___io__read_result_1_0_i6);
	init_label(mercury____Compare___io__read_result_1_0_i10);
	init_label(mercury____Compare___io__read_result_1_0_i12);
	init_label(mercury____Compare___io__read_result_1_0_i18);
	init_label(mercury____Compare___io__read_result_1_0_i20);
	init_label(mercury____Compare___io__read_result_1_0_i26);
	init_label(mercury____Compare___io__read_result_1_0_i14);
	init_label(mercury____Compare___io__read_result_1_0_i34);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__read_result_1_0);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i4);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 1;
	GOTO_LABEL(mercury____Compare___io__read_result_1_0_i2);
Define_label(mercury____Compare___io__read_result_1_0_i4);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i5);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__read_result_1_0_i2);
Define_label(mercury____Compare___io__read_result_1_0_i5);
	r4 = r1;
	r1 = r2;
	r2 = r3;
	r3 = (Integer) 2;
Define_label(mercury____Compare___io__read_result_1_0_i2);
	if ((tag(r2) != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i8);
	incr_sp_push_msg(3, "io:__Compare__/3");
	detstackvar(3) = (Word) succip;
	r5 = r4;
	r4 = (Integer) 1;
	GOTO_LABEL(mercury____Compare___io__read_result_1_0_i6);
Define_label(mercury____Compare___io__read_result_1_0_i8);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i9);
	incr_sp_push_msg(3, "io:__Compare__/3");
	detstackvar(3) = (Word) succip;
	r5 = r4;
	r4 = (Integer) 0;
	GOTO_LABEL(mercury____Compare___io__read_result_1_0_i6);
Define_label(mercury____Compare___io__read_result_1_0_i9);
	r5 = r4;
	r4 = (Integer) 2;
	incr_sp_push_msg(3, "io:__Compare__/3");
	detstackvar(3) = (Word) succip;
Define_label(mercury____Compare___io__read_result_1_0_i6);
	if (((Integer) r3 >= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i10);
	r1 = (Integer) 1;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury____Compare___io__read_result_1_0_i10);
	if (((Integer) r3 <= (Integer) r4))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i12);
	r1 = (Integer) 2;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury____Compare___io__read_result_1_0_i12);
	r3 = tag(r1);
	if ((r3 != mktag((Integer) 0)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i18);
	if (((Integer) r2 != (Integer) (const Word *) mkword(mktag(0), mkbody((Integer) 0))))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i14);
	r1 = (Integer) 0;
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
Define_label(mercury____Compare___io__read_result_1_0_i18);
	if ((r3 != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i20);
	if ((tag(r2) != mktag((Integer) 1)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i14);
	r3 = r1;
	r1 = r5;
	r4 = r2;
	r2 = const_field(mktag(1), r3, (Integer) 0);
	r3 = const_field(mktag(1), r4, (Integer) 0);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	tailcall(ENTRY(mercury__compare_3_3),
		ENTRY(mercury____Compare___io__read_result_1_0));
Define_label(mercury____Compare___io__read_result_1_0_i20);
	if ((tag(r2) != mktag((Integer) 2)))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i14);
	r3 = const_field(mktag(2), r2, (Integer) 1);
	r4 = const_field(mktag(2), r1, (Integer) 1);
	detstackvar(1) = r4;
	detstackvar(2) = r3;
	r1 = const_field(mktag(2), r1, (Integer) 0);
	r2 = const_field(mktag(2), r2, (Integer) 0);
	call_localret(ENTRY(mercury__builtin_compare_string_3_0),
		mercury____Compare___io__read_result_1_0_i26,
		ENTRY(mercury____Compare___io__read_result_1_0));
Define_label(mercury____Compare___io__read_result_1_0_i26);
	update_prof_current_proc(LABEL(mercury____Compare___io__read_result_1_0));
	if (((Integer) r1 != (Integer) 0))
		GOTO_LABEL(mercury____Compare___io__read_result_1_0_i34);
	r1 = detstackvar(1);
	r2 = detstackvar(2);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	tailcall(ENTRY(mercury__builtin_compare_int_3_0),
		ENTRY(mercury____Compare___io__read_result_1_0));
Define_label(mercury____Compare___io__read_result_1_0_i14);
	{
		String	Message;
		Message = (String) (Word) (const Word *) string_const("internal error in compare/3", 27);
{		
	fflush(stdout);
	fprintf(stderr, "Software error: %s\n", Message);
	exit(1);
#ifndef USE_GCC_NONLOCAL_GOTOS
	return 0;	/* suppress some dumb warnings */
#endif
;}
#line 10985 "io.c"

	}
Define_label(mercury____Compare___io__read_result_1_0_i34);
	succip = (Code *) detstackvar(3);
	decr_sp_pop_msg(3);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module197)
	init_entry(mercury____Unify___io__error_0_0);
	init_label(mercury____Unify___io__error_0_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__error_0_0);
	if ((strcmp((char *)r1, (char *)r2) != 0))
		GOTO_LABEL(mercury____Unify___io__error_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__error_0_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module198)
	init_entry(mercury____Index___io__error_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__error_0_0);
	tailcall(STATIC(mercury____Index___io__error_0__ua10000_2_0),
		ENTRY(mercury____Index___io__error_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module199)
	init_entry(mercury____Compare___io__error_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__error_0_0);
	tailcall(ENTRY(mercury__builtin_compare_string_3_0),
		ENTRY(mercury____Compare___io__error_0_0));
END_MODULE

Declare_entry(mercury____Unify___string__poly_type_0_0);

BEGIN_MODULE(mercury__io_module200)
	init_entry(mercury____Unify___io__poly_type_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__poly_type_0_0);
	tailcall(ENTRY(mercury____Unify___string__poly_type_0_0),
		ENTRY(mercury____Unify___io__poly_type_0_0));
END_MODULE

Declare_entry(mercury____Index___string__poly_type_0_0);

BEGIN_MODULE(mercury__io_module201)
	init_entry(mercury____Index___io__poly_type_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__poly_type_0_0);
	tailcall(ENTRY(mercury____Index___string__poly_type_0_0),
		ENTRY(mercury____Index___io__poly_type_0_0));
END_MODULE

Declare_entry(mercury____Compare___string__poly_type_0_0);

BEGIN_MODULE(mercury__io_module202)
	init_entry(mercury____Compare___io__poly_type_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__poly_type_0_0);
	tailcall(ENTRY(mercury____Compare___string__poly_type_0_0),
		ENTRY(mercury____Compare___io__poly_type_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module203)
	init_entry(mercury____Unify___io__whence_0_0);
	init_label(mercury____Unify___io__whence_0_0_i1);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_entry(mercury____Unify___io__whence_0_0);
	if ((r1 != r2))
		GOTO_LABEL(mercury____Unify___io__whence_0_0_i1);
	r1 = TRUE;
	proceed();
Define_label(mercury____Unify___io__whence_0_0_i1);
	r1 = FALSE;
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module204)
	init_entry(mercury____Index___io__whence_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_entry(mercury____Index___io__whence_0_0);
	proceed();
END_MODULE


BEGIN_MODULE(mercury__io_module205)
	init_entry(mercury____Compare___io__whence_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_entry(mercury____Compare___io__whence_0_0);
	tailcall(ENTRY(mercury__builtin_compare_int_3_0),
		ENTRY(mercury____Compare___io__whence_0_0));
END_MODULE

Declare_entry(mercury____Unify___tree234__tree234_2_0);

BEGIN_MODULE(mercury__io_module206)
	init_entry(mercury____Unify___io__stream_names_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_static(mercury____Unify___io__stream_names_0_0);
	r3 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r4 = r2;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	tailcall(ENTRY(mercury____Unify___tree234__tree234_2_0),
		STATIC(mercury____Unify___io__stream_names_0_0));
END_MODULE

Declare_entry(mercury____Index___tree234__tree234_2_0);

BEGIN_MODULE(mercury__io_module207)
	init_entry(mercury____Index___io__stream_names_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_static(mercury____Index___io__stream_names_0_0);
	r3 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	tailcall(ENTRY(mercury____Index___tree234__tree234_2_0),
		STATIC(mercury____Index___io__stream_names_0_0));
END_MODULE

Declare_entry(mercury____Compare___tree234__tree234_2_0);

BEGIN_MODULE(mercury__io_module208)
	init_entry(mercury____Compare___io__stream_names_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_static(mercury____Compare___io__stream_names_0_0);
	r3 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r4 = r2;
	r2 = (Word) (const Word *) &mercury_data___base_type_info_string_0;
	tailcall(ENTRY(mercury____Compare___tree234__tree234_2_0),
		STATIC(mercury____Compare___io__stream_names_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module209)
	init_entry(mercury____Unify___io__stream_putback_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_static(mercury____Unify___io__stream_putback_0_0);
	r3 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r4 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_6);
	tailcall(ENTRY(mercury____Unify___tree234__tree234_2_0),
		STATIC(mercury____Unify___io__stream_putback_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module210)
	init_entry(mercury____Index___io__stream_putback_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_static(mercury____Index___io__stream_putback_0_0);
	r3 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r2 = (Word) (const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_6);
	tailcall(ENTRY(mercury____Index___tree234__tree234_2_0),
		STATIC(mercury____Index___io__stream_putback_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module211)
	init_entry(mercury____Compare___io__stream_putback_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_static(mercury____Compare___io__stream_putback_0_0);
	r3 = r1;
	r1 = (Word) (const Word *) &mercury_data_mercury_builtin__base_type_info_c_pointer_0;
	r4 = r2;
	r2 = (Word) (const Word *) mkword(mktag(0), (Word) (const Word *) &mercury_data_io__common_6);
	tailcall(ENTRY(mercury____Compare___tree234__tree234_2_0),
		STATIC(mercury____Compare___io__stream_putback_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module212)
	init_entry(mercury____Unify___io__stream_0_0);
BEGIN_CODE

/* code for predicate '__Unify__'/2 in mode 0 */
Define_static(mercury____Unify___io__stream_0_0);
	tailcall(ENTRY(mercury____Unify___mercury_builtin__c_pointer_0_0),
		STATIC(mercury____Unify___io__stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module213)
	init_entry(mercury____Index___io__stream_0_0);
BEGIN_CODE

/* code for predicate '__Index__'/2 in mode 0 */
Define_static(mercury____Index___io__stream_0_0);
	tailcall(ENTRY(mercury____Index___mercury_builtin__c_pointer_0_0),
		STATIC(mercury____Index___io__stream_0_0));
END_MODULE


BEGIN_MODULE(mercury__io_module214)
	init_entry(mercury____Compare___io__stream_0_0);
BEGIN_CODE

/* code for predicate '__Compare__'/3 in mode 0 */
Define_static(mercury____Compare___io__stream_0_0);
	tailcall(ENTRY(mercury____Compare___mercury_builtin__c_pointer_0_0),
		STATIC(mercury____Compare___io__stream_0_0));
END_MODULE

void
ML_io_finalize_state(void)
{
#if NUM_REAL_REGS > 0
	Word c_regs[NUM_REAL_REGS];
#endif

	save_regs_to_mem(c_regs);
	restore_registers();
	save_transient_registers();
	{
	Declare_entry(mercury__io__finalize_state_2_0);
	call_engine(ENTRY(mercury__io__finalize_state_2_0));
	}
	restore_transient_registers();
	restore_regs_from_mem(c_regs);
}


void
ML_io_init_state(void)
{
#if NUM_REAL_REGS > 0
	Word c_regs[NUM_REAL_REGS];
#endif

	save_regs_to_mem(c_regs);
	restore_registers();
	save_transient_registers();
	{
	Declare_entry(mercury__io__init_state_2_0);
	call_engine(ENTRY(mercury__io__init_state_2_0));
	}
	restore_transient_registers();
	restore_regs_from_mem(c_regs);
}


#if (defined(USE_GCC_NONLOCAL_GOTOS) && !defined(USE_ASM_LABELS)) \
	|| defined(PROFILE_CALLS) || defined(DEBUG_GOTOS) \
	|| defined(DEBUG_LABELS) || !defined(SPEED) \
	|| defined(NATIVE_GC) 

static void mercury__io_bunch_0(void)
{
	mercury__io_module0();
	mercury__io_module1();
	mercury__io_module2();
	mercury__io_module3();
	mercury__io_module4();
	mercury__io_module5();
	mercury__io_module6();
	mercury__io_module7();
	mercury__io_module8();
	mercury__io_module9();
	mercury__io_module10();
	mercury__io_module11();
	mercury__io_module12();
	mercury__io_module13();
	mercury__io_module14();
	mercury__io_module15();
	mercury__io_module16();
	mercury__io_module17();
	mercury__io_module18();
	mercury__io_module19();
	mercury__io_module20();
	mercury__io_module21();
	mercury__io_module22();
	mercury__io_module23();
	mercury__io_module24();
	mercury__io_module25();
	mercury__io_module26();
	mercury__io_module27();
	mercury__io_module28();
	mercury__io_module29();
	mercury__io_module30();
	mercury__io_module31();
	mercury__io_module32();
	mercury__io_module33();
	mercury__io_module34();
	mercury__io_module35();
	mercury__io_module36();
	mercury__io_module37();
	mercury__io_module38();
	mercury__io_module39();
	mercury__io_module40();
}

static void mercury__io_bunch_1(void)
{
	mercury__io_module41();
	mercury__io_module42();
	mercury__io_module43();
	mercury__io_module44();
	mercury__io_module45();
	mercury__io_module46();
	mercury__io_module47();
	mercury__io_module48();
	mercury__io_module49();
	mercury__io_module50();
	mercury__io_module51();
	mercury__io_module52();
	mercury__io_module53();
	mercury__io_module54();
	mercury__io_module55();
	mercury__io_module56();
	mercury__io_module57();
	mercury__io_module58();
	mercury__io_module59();
	mercury__io_module60();
	mercury__io_module61();
	mercury__io_module62();
	mercury__io_module63();
	mercury__io_module64();
	mercury__io_module65();
	mercury__io_module66();
	mercury__io_module67();
	mercury__io_module68();
	mercury__io_module69();
	mercury__io_module70();
	mercury__io_module71();
	mercury__io_module72();
	mercury__io_module73();
	mercury__io_module74();
	mercury__io_module75();
	mercury__io_module76();
	mercury__io_module77();
	mercury__io_module78();
	mercury__io_module79();
	mercury__io_module80();
	mercury__io_module81();
}

static void mercury__io_bunch_2(void)
{
	mercury__io_module82();
	mercury__io_module83();
	mercury__io_module84();
	mercury__io_module85();
	mercury__io_module86();
	mercury__io_module87();
	mercury__io_module88();
	mercury__io_module89();
	mercury__io_module90();
	mercury__io_module91();
	mercury__io_module92();
	mercury__io_module93();
	mercury__io_module94();
	mercury__io_module95();
	mercury__io_module96();
	mercury__io_module97();
	mercury__io_module98();
	mercury__io_module99();
	mercury__io_module100();
	mercury__io_module101();
	mercury__io_module102();
	mercury__io_module103();
	mercury__io_module104();
	mercury__io_module105();
	mercury__io_module106();
	mercury__io_module107();
	mercury__io_module108();
	mercury__io_module109();
	mercury__io_module110();
	mercury__io_module111();
	mercury__io_module112();
	mercury__io_module113();
	mercury__io_module114();
	mercury__io_module115();
	mercury__io_module116();
	mercury__io_module117();
	mercury__io_module118();
	mercury__io_module119();
	mercury__io_module120();
	mercury__io_module121();
	mercury__io_module122();
}

static void mercury__io_bunch_3(void)
{
	mercury__io_module123();
	mercury__io_module124();
	mercury__io_module125();
	mercury__io_module126();
	mercury__io_module127();
	mercury__io_module128();
	mercury__io_module129();
	mercury__io_module130();
	mercury__io_module131();
	mercury__io_module132();
	mercury__io_module133();
	mercury__io_module134();
	mercury__io_module135();
	mercury__io_module136();
	mercury__io_module137();
	mercury__io_module138();
	mercury__io_module139();
	mercury__io_module140();
	mercury__io_module141();
	mercury__io_module142();
	mercury__io_module143();
	mercury__io_module144();
	mercury__io_module145();
	mercury__io_module146();
	mercury__io_module147();
	mercury__io_module148();
	mercury__io_module149();
	mercury__io_module150();
	mercury__io_module151();
	mercury__io_module152();
	mercury__io_module153();
	mercury__io_module154();
	mercury__io_module155();
	mercury__io_module156();
	mercury__io_module157();
	mercury__io_module158();
	mercury__io_module159();
	mercury__io_module160();
	mercury__io_module161();
	mercury__io_module162();
	mercury__io_module163();
}

static void mercury__io_bunch_4(void)
{
	mercury__io_module164();
	mercury__io_module165();
	mercury__io_module166();
	mercury__io_module167();
	mercury__io_module168();
	mercury__io_module169();
	mercury__io_module170();
	mercury__io_module171();
	mercury__io_module172();
	mercury__io_module173();
	mercury__io_module174();
	mercury__io_module175();
	mercury__io_module176();
	mercury__io_module177();
	mercury__io_module178();
	mercury__io_module179();
	mercury__io_module180();
	mercury__io_module181();
	mercury__io_module182();
	mercury__io_module183();
	mercury__io_module184();
	mercury__io_module185();
	mercury__io_module186();
	mercury__io_module187();
	mercury__io_module188();
	mercury__io_module189();
	mercury__io_module190();
	mercury__io_module191();
	mercury__io_module192();
	mercury__io_module193();
	mercury__io_module194();
	mercury__io_module195();
	mercury__io_module196();
	mercury__io_module197();
	mercury__io_module198();
	mercury__io_module199();
	mercury__io_module200();
	mercury__io_module201();
	mercury__io_module202();
	mercury__io_module203();
	mercury__io_module204();
}

static void mercury__io_bunch_5(void)
{
	mercury__io_module205();
	mercury__io_module206();
	mercury__io_module207();
	mercury__io_module208();
	mercury__io_module209();
	mercury__io_module210();
	mercury__io_module211();
	mercury__io_module212();
	mercury__io_module213();
	mercury__io_module214();
}

#endif

void mercury__io__init(void);/* suppress gcc -Wmissing-decls warning */
void mercury__io__init(void)
{
#if (defined(USE_GCC_NONLOCAL_GOTOS) && !defined(USE_ASM_LABELS)) \
	|| defined(PROFILE_CALLS) || defined(DEBUG_GOTOS) \
	|| defined(DEBUG_LABELS) || !defined(SPEED) \
	|| defined(NATIVE_GC) 

	static bool done = FALSE;
	if (!done) {
		done = TRUE;
		mercury__io_bunch_0();
		mercury__io_bunch_1();
		mercury__io_bunch_2();
		mercury__io_bunch_3();
		mercury__io_bunch_4();
		mercury__io_bunch_5();
	}
#endif
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_binary_input_stream_0,
		io__binary_input_stream_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_binary_output_stream_0,
		io__binary_output_stream_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_binary_stream_0,
		io__binary_stream_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_error_0,
		io__error_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_input_stream_0,
		io__input_stream_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_output_stream_0,
		io__output_stream_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_poly_type_0,
		io__poly_type_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_read_result_1,
		io__read_result_1_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_res_0,
		io__res_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_res_1,
		io__res_1_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_result_0,
		io__result_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_result_1,
		io__result_1_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_state_0,
		io__state_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_stream_0,
		io__stream_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_stream_names_0,
		io__stream_names_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_stream_putback_0,
		io__stream_putback_0_0);
	MR_INIT_BASE_TYPE_INFO(
		mercury_data_io__base_type_info_whence_0,
		io__whence_0_0);
}

/* ensure everything is compiled with the same grade */
static const void *const MR_grade = &MR_GRADE_VAR;
