/*
   XRClipView.m

   Copyright (C) 1997 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>
   Date: October 1997
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: May 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <AppKit/NSGraphics.h>
#include <AppKit/NSColor.h>
#include <AppKit/PSMatrix.h>

#include <gnustep/xraw/XR.h>


extern NSRect XRCanvasRect();

//
// Class variables
//
static PSMatrix* _matrix = nil;
static NSWindow* retainedMatrixWindow = nil;
static BOOL isFlipped = NO;


@implementation XRClipView

- init
{
	[super init];
	_copiesOnScroll = YES;

	return self;
}

- (void)drawRect:(NSRect)rect
{
NSRect aRect = rect;					

	fprintf (stderr,
	"XRClipView: drawRect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
			rect.origin.x, rect.origin.y, 
			rect.size.width, rect.size.height);

										// scrolling moves the bounds origin
//	aRect.origin = NSZeroPoint;			// which results in the top bezel being
	[[self backgroundColor] set];		// overwritten during a fill, zeroing
	NSRectFill(aRect);					// the fill origin fixes this
			
	[window flushWindow];							// flush backing store
}

- (void)_freeMatrix									// called when mouse goes
{													// up in scroller.  if flag
	retainedMatrixWindow = nil;						// is nil matrix needs to 
	XRRemoveClipPath();								// be pre calc'd prior to
}													// scroll op

- (void)scrollToPoint:(NSPoint)point
{
NSRect start, slice, remainder, cSlice;
NSPoint dest;
static NSRect windowRect; 
static NSSize windowSize; 
static NSSize documentSize; 
NSRect destO; 
NSPoint srcO;
float offy;							  
PSMatrix* tmatrix;
static NSPoint clipOrigin;
													// avoid rounding errors by
	point.y = floor(point.y);						// constraining the scroll
	point.x = floor(point.x);						// to even numbers
	start = bounds;

//	point = [self constrainScrollPoint:point];
//	[self constrainScrollPoint:point];

//	[self setBoundsOrigin:NSMakePoint(point.x, point.y)];
	bounds.origin.x = point.x;
	bounds.origin.y = point.y;
									// translate the origin of the bounds in 
									// the oposite direction so that the new 
									// origin becomes the origin when viewed. 
	[boundsMatrix setFrameOrigin:NSMakePoint(-point.x, -point.y)];

	if(!_copiesOnScroll)								// if not copying the
		{												// portion of the  
		[_documentView setNeedsDisplay:YES];			// document that is
														// visible before and
		return;											// after scrolling 				
		}

	if(window != retainedMatrixWindow)					// precalculate matrix
		{												// prior to scrolling
		NSArray* path;									// release it after 
		NSView *cv = [window contentView];				// mouse goes up
														// precalc'd matrix
		if(_matrix)										// speeds up coordinate 
			[_matrix release];							// transformation calcs
		path = [cv _pathBetweenSubview:super_view toSuperview:cv];
		_matrix = [cv _concatenateMatricesInReverseOrderFromPath:path];
		[_matrix retain];
		[_matrix concatenateWith:self->frameMatrix];

		isFlipped = [_documentView isFlipped];
		documentSize = [_documentView bounds].size;
		windowSize = [window frame].size;
														// pre calc clip view's 
														// X window rectangle 
		windowRect = [self convertRect:bounds toView:nil];		
		windowRect.origin.y = windowSize.height - (windowRect.origin.y + 
								frame.size.height);
		fprintf(stderr, "XRClipView windowRect.origin.y (%1.2f)\n", 
					windowRect.origin.y);
		XRFocusLock((XRView *)_documentView, (XRWindow *)window);
		XRClipWindowRect(windowRect);      				// set clipping path
		windowRect.size.height += 2;

		retainedMatrixWindow = window;
									// calc clip view offset within the window
		clipOrigin = [_matrix pointInMatrixSpace:frame.origin];
		clipOrigin.y = windowSize.height - (frame.size.height + clipOrigin.y);
		}
	tmatrix = [_matrix copy];							// copy precalculated
	[tmatrix autorelease];								// matrix

	if(start.origin.y != point.y)		 				// scrolling the y axis	
		{												
		PSgsave();										// Save graphics state

		offy = clipOrigin.y;
		XRSetCanvasOrigin (clipOrigin);				
	
		[tmatrix concatenateWith:self->boundsMatrix];

		if(start.origin.y < point.y)		 			// scroll down document
			{											
			float amount = point.y - start.origin.y;	// calc area visible
														// before and after 
			NSDivideRect(bounds, &slice, &remainder, amount, NSMinYEdge);
			dest = remainder.origin;
			remainder.origin = bounds.origin;			// calc area of slice
														// needing redisplay
			slice.origin.y = bounds.size.height + bounds.origin.y - 
								slice.size.height;

			srcO = [tmatrix pointInMatrixSpace:dest];
			destO.origin = [tmatrix pointInMatrixSpace:remainder.origin];
			destO.size = remainder.size;
			}
		else											// scroll up document 
			{												
			float amount = start.origin.y - point.y;

			NSDivideRect(bounds, &slice, &remainder, amount, NSMinYEdge);
			srcO = [tmatrix pointInMatrixSpace:bounds.origin];
			destO.origin = [tmatrix pointInMatrixSpace:remainder.origin];
			destO.size = remainder.size;
			}

		if(!isFlipped)	
			{
			destO.origin.y = windowSize.height - destO.origin.y - 
								frame.size.height + slice.size.height;
			offy = srcO.y = windowSize.height - srcO.y - 
								frame.size.height + slice.size.height;
			}
		else
			XRSetFlipped();								// document is flipped
			 		
		XRCopyRectToPoint(destO, srcO);
		PSgrestore();									// Restore grphic state 

							  // emulate lockFocus using pre-calculated matrix
		PSgsave();										// Save graphics state
		srcO = [tmatrix pointInMatrixSpace:[_documentView frame].origin];
		if(isFlipped)	
			srcO.y += offy;
		XRSetCanvasOrigin (srcO);				
		XRFocusLock((XRView *)_documentView, (XRWindow *)window);

		if(isFlipped)
			{	
			XRSetFlipped();								// clip to the newly 
														// exposed slice
			cSlice.origin = [tmatrix pointInMatrixSpace:slice.origin];
			cSlice.size = slice.size;
			cSlice.origin.y += offy;
			XRClipWindowRect(cSlice);
			}
														// draw exposed slice
		[(XRView *)_documentView drawRect:slice];		// of the document view

		XRRemoveClipPath();								// remove clipping path

		PSgrestore();									// Restore grphic state 
		}
														// check x for movement	
	if(start.origin.x != point.x)		 		
		{												// scrolling the x axis
		PSgsave();										// Save graphics state

		offy = clipOrigin.y;
		XRSetCanvasOrigin (clipOrigin);				
	
		[tmatrix concatenateWith:self->boundsMatrix];
	
		if(start.origin.x < point.x)		 			// scroll doc right
			{											
			float amount = point.x - start.origin.x;	// calc area visible
														// before and after 
			NSDivideRect(bounds, &slice, &remainder, amount, NSMinXEdge);
			dest = remainder.origin;
			remainder.origin = bounds.origin;			// calc area of slice
														// needing redisplay
			slice.origin.x = bounds.size.width + bounds.origin.x - 
								slice.size.width;

			srcO = [tmatrix pointInMatrixSpace:dest];
			destO.origin = [tmatrix pointInMatrixSpace:remainder.origin];
			destO.size = remainder.size;
			}
		else											// scroll doc left
			{											
			float amount = start.origin.x - point.x;	

			NSDivideRect(bounds, &slice, &remainder, amount, NSMinXEdge);
			srcO = [tmatrix pointInMatrixSpace:bounds.origin];
			destO.origin = [tmatrix pointInMatrixSpace:remainder.origin];
			destO.size = remainder.size;
			}

		if(!isFlipped)	
			{			 		
			destO.origin.y = windowSize.height - destO.origin.y - 
								frame.size.height;
			offy = srcO.y = windowSize.height - srcO.y - frame.size.height;
			}
		else
			XRSetFlipped();								// document is flipped

		XRCopyRectToPoint(destO, srcO);
		PSgrestore();									// Restore grphic state 

							  // emulate lockFocus using pre-calculated matrix
		PSgsave();										// Save graphics state
		srcO = [tmatrix pointInMatrixSpace:[_documentView frame].origin];
		if(isFlipped)
			{	
			srcO.y += offy;
			XRSetCanvasOrigin (srcO);			// will be at top of frame
			XRSetFlipped();
			}
		else
			XRSetCanvasOrigin (srcO);			// will be at top of frame
		XRFocusLock((XRView *)_documentView, (XRWindow *)window);
													// fixes bug in NSMatrix
													// where otherwise limit 
		if(slice.size.height > documentSize.height)	// gets hit in _getRow: 
			slice.size.height = documentSize.height;	// method  FIX ME
		[(XRView *)_documentView drawRect:slice];
														// emulate unlockFocus
		PSgrestore();									// Restore grphic state 
		}													// end of x moved 

	[window _windowNeedsFlushInRect:windowRect];			// clip needs flush
	XRRemoveClipPath();										// remove clipping
}			

- (NSPoint)constrainScrollPoint:(NSPoint)proposedNewOrigin
{
NSRect documentFrame = [self documentRect];
NSPoint new = proposedNewOrigin;

	if (proposedNewOrigin.x < documentFrame.origin.x)
		new.x = documentFrame.origin.x;
	else 
		{
		if (proposedNewOrigin.x > documentFrame.size.width - bounds.size.width)
			new.x = documentFrame.size.width - bounds.size.width;
		}

fprintf(stderr,"XRClipView constrainScrollPoint proposedNewOrigin.y %f\n", 	
			proposedNewOrigin.y);
fprintf(stderr,"XRClipView constrainScrollPoint documentFrame.origin.y %f\n", 
			documentFrame.origin.y);			

	if (proposedNewOrigin.y < documentFrame.origin.y)
		{
//    new.y = documentFrame.origin.y;		// FAR moves view to bottom of clip
//    new.y = proposedNewOrigin.y;			// FAR while view display's at top
	if(isFlipped)
			{
			if([_documentView frame].size.height < bounds.size.height)
			new.y = documentFrame.origin.y - (bounds.size.height - 
				[_documentView frame].size.height);	
			else
			new.y = documentFrame.origin.y - (bounds.size.height - 
					[_documentView frame].size.height) - proposedNewOrigin.y;
			}
		else
			new.y = documentFrame.origin.y - (bounds.size.height - 
				[_documentView frame].size.height);	

#ifdef FAR_DEBUG
fprintf(stderr,"XRClipView constrainScrollPoint bounds.size.height %f\n",bounds.size.height);			
fprintf(stderr,"XRClipView constrainScrollPoint [_documentView frame].size.height %f\n",[_documentView frame].size.height);	
#endif																		
		
		}	
	else 
		{
fprintf(stderr,"XRClipView constrainScrollPoint  documentFrame.size.height %f bounds.size.height %f \n", documentFrame.size.height, bounds.size.height);

		if (proposedNewOrigin.y	> documentFrame.size.height - 
				bounds.size.height)
    		new.y = documentFrame.size.height - bounds.size.height;

		if(isFlipped)
			{
							// a doc view whose frame is smaller than clip
							// view's bounds will have an origin offset
							// to make it appear at the top of the clip view
			if([_documentView frame].size.height < bounds.size.height)
				new.y = documentFrame.origin.y - (bounds.size.height - 
						[_documentView frame].size.height);	
			else	
				{			// doc view is larger than the clip view's bounds
							// do not constrain proposed new origin if it is
							// less than the difference between the doc frame
							// and the clip view's bounds (this is the allowed  
							// range of the scrolling offset)
				if(proposedNewOrigin.y < ([_documentView frame].size.height - 
						bounds.size.height))
					new.y = proposedNewOrigin.y;
				}
			}
		}

fprintf(stderr,"XRClipView constrainScrollPoint x %f y %f \n", new.x, new.y);

	return new;
}

- (void)viewFrameChanged:(NSNotification*)aNotification
{
NSView* docView = [self documentView];
NSRect mr;
													// disable notifications to
	[docView setPostsFrameChangedNotifications:NO];	// prevent an infinite loop

	fprintf(stderr,"XRClipView viewFrameChanged \n");
	mr = [docView frame];						// A doc view smaller than the
												// clip view requires an origin
	if (mr.size.height < bounds.size.height)	// offset in order for it to
		mr.origin.y = bounds.size.height - mr.size.height;	
	else										// appear at the top of the	
		{										// clip view.
//		if(mr.origin.y > 0)			// A doc view's origin must be reset to 0
			mr.origin.y = 0;		// if it's height becomes greater than the
		}							// size of the clip view. This may occur
	mr.origin.x = 0;				// when the intitial doc view is resized.
	[docView setFrameOrigin:mr.origin];	

	[docView setPostsFrameChangedNotifications:YES];	// reenable frame
														// change notifications 
	[super viewFrameChanged:aNotification];
}

- (NSRect)visibleRect
{
	if (!super_view)
		return bounds;
	else 
		{
		NSRect svrect = [super_view visibleRect];
		NSRect csvrect = [self convertRect:svrect fromView:super_view];
		NSRect rect = NSIntersectionRect (csvrect, bounds);

#ifdef FAR_DEBUG
	fprintf (stderr,
"XRClipView bounds: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		bounds.origin.x, bounds.origin.y, 
		bounds.size.width, bounds.size.height);
	fprintf (stderr,
"XRClipView svrect: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		svrect.origin.x, svrect.origin.y, 
		svrect.size.width, svrect.size.height);
	fprintf (stderr,
"XRClipView csvrect: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		csvrect.origin.x, csvrect.origin.y, 
		csvrect.size.width, csvrect.size.height);
	fprintf (stderr,
"XRClipView visibleRect: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
				rect.origin.x, rect.origin.y, 
				rect.size.width, rect.size.height);
#endif																		

		return rect;
  		}
}

- (void)setDocumentView:(NSView*)aView
{											
	if (aView)
		{	
		if([aView respondsTo:@selector(backgroundColor)])								
  			[self setBackgroundColor:[aView backgroundColor]];
		}

	[super setDocumentView:aView];			
}

@end
