/* 
   EOAttributeOrdering.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <eoaccess/common.h>
#include <eoaccess/EOAttribute.h>
#include <eoaccess/EOAttributeOrdering.h>

@implementation EOAttributeOrdering

+ attributeOrderingWithAttribute:(EOAttribute*)_attribute 
  ordering:(EOOrdering)_ordering
{
    return [[[EOAttributeOrdering alloc] autorelease]
		initWithAttribute:_attribute ordering:_ordering];
}

- initWithAttribute:(EOAttribute*)_attribute
  ordering:(EOOrdering)_ordering
{
    ASSIGN(attribute, _attribute);
    ordering = _ordering;
    return self;
}

- (EOAttribute*)attribute	{ return attribute; }
- (EOOrdering)ordering		{ return ordering; }

@end /* EOAttributeOrdering */
