#ifndef SEARCHUSER_H
#define SEARCHUSER_H

// Search user code base written by Alan Penner (apenner@andrew.cmu.edu)
// modified by Graham Roff

#include <qdialog.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qlined.h>
#include <qchkbox.h>
#include <qlistview.h>
#include <qgrpbox.h>

#include "icq.h"
#include "user.h"


class SearchUserView : public QListView
{
   Q_OBJECT
public:
   SearchUserView(QWidget *parent = NULL, char *name = NULL);
   unsigned long currentUin(void);
};


class SearchItem : public QListViewItem
{
public:
   SearchItem(struct UserStatusline &, QListView *parent);  
   unsigned long uin();
protected:
   unsigned long uinVal;
};



class SearchUserDlg : public QDialog
{
   Q_OBJECT
public:
   SearchUserDlg (ICQ *s, QWidget *parent = NULL, const char *name = NULL);

protected:
   ICQ *server;
   QPushButton *btnSearch, *btnCancel;
   QLabel *lblEmail, *lblFirst, *lblLast, *lblNick;
   QLineEdit *edtEmail, *edtFirst, *edtLast, *edtNick;
   QGroupBox *OtherBox;

   unsigned long searchSequence;
   QPushButton *btnCancelSearch, *btnAdd;
   SearchUserView *foundView;
   QLabel *lblSearch;
  

public slots:
   virtual void show();
   void startSearch();
   void addUser();
   void userFound(struct UserStatusline &, unsigned long);
   void doneSearch(unsigned short, char);   
};


#endif
