#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef USE_KDE
#include "klicq.h"
#include "icon.xpm"

KLicq::KLicq(QWidget* parent) :QLabel(parent)
{

//Initilizing all the bit maps.... same once which are using on the licqgui

   char filename[1024];
 
   m_isDocked=false;

   sprintf(filename, "%s%s%s", BASE_DIR, DATA_DIR, "online.ppm");
   pmOnline = new QPixmap(filename);

   sprintf(filename, "%s%s%s", BASE_DIR, DATA_DIR, "offline.ppm");
   pmOffline = new QPixmap(filename);

   sprintf(filename, "%s%s%s", BASE_DIR, DATA_DIR, "away.ppm");
   pmAway = new QPixmap(filename);

   sprintf(filename, "%s%s%s", BASE_DIR, DATA_DIR, "na.ppm");
   pmNa = new QPixmap(filename);

   sprintf(filename, "%s%s%s", BASE_DIR, DATA_DIR, "occupied.ppm");
   pmOccupied = new QPixmap(filename);

   sprintf(filename, "%s%s%s", BASE_DIR, DATA_DIR, "dnd.ppm");
   pmDnd = new QPixmap(filename);

   sprintf(filename, "%s%s%s", BASE_DIR, DATA_DIR, "message.ppm");
   pmMessage = new QPixmap(filename);

   connect(this,SIGNAL(quitapp()),kapp,SLOT(quit()));
}

KLicq::~KLicq()
{
}

void KLicq::m_displayPixmap()
{
QPixmap pixmap(xpmIcon);
setPixmap(pixmap);
      switch (OwnerStatus)
      {
      case ICQ_STATUS_ONLINE:setPixmap((QPixmap &)*pmOnline);break;
      case ICQ_STATUS_AWAY: setPixmap((QPixmap &)*pmAway);break;
      case ICQ_STATUS_OCCUPIED: setPixmap((QPixmap &)*pmOccupied);break;
      case ICQ_STATUS_DND: setPixmap((QPixmap &)*pmDnd);break;
      case ICQ_STATUS_PRIVATE: setPixmap((QPixmap &)*pmOccupied);break;
      case ICQ_STATUS_NA: setPixmap((QPixmap &)*pmNa);break;
      case ICQ_STATUS_OFFLINE:break;
      default: setPixmap(pixmap);break;
      }
setFixedSize(20,20);
resize(20,20);
}


void KLicq::change_dock_status(unsigned short int stat)
{
 OwnerStatus=stat;
 reset();
 return;
}


void KLicq::popresult(int index)
{
switch (index)
	{
	case 0:emit change_status_from_dock(0);break;
	case 1:emit change_status_from_dock(6);break;
	case 2:emit change_status_from_dock(1);break;
	case 3:emit change_status_from_dock(2);break;
	case 4:emit change_status_from_dock(3);break;
	case 5:emit change_status_from_dock(4);break;
	case 6:emit change_status_from_dock(5);break;
	case 7:m_dock();break;
	case 9:emit quitapp();break;
	}
}


void KLicq::m_popupMenu(int,int)
{
// More functions have to added here... I'll do this later. 
// but this is enough to start KDE version ;-)

        QPopupMenu *popup = new QPopupMenu(0, "popup");

        popup->insertItem("&Online");
        popup->insertItem("O&ffline");
        popup->insertItem("&Away");
        popup->insertItem("&Not Available");
        popup->insertItem("O&ccupied");
        popup->insertItem("&Do not Disturb");
        popup->insertItem("&Private Invisible");
        if (m_isDocked == false)
                popup->insertItem("&Dock");
        else
                popup->insertItem("&UnDock");
        popup->insertItem("E&xit");

        connect(popup, SIGNAL(activated(int)), this, SLOT(popresult(int)));
	connect(this,SIGNAL(quitapp()),kapp,SLOT(quit()));
        popup->popup(QCursor::pos());
}


void KLicq::mousePressEvent(QMouseEvent *event)
{
        // check if this is a right click
	// Left click support to minimize and maximise licqgui would be 
	// a neat idea. However it would have to wait for now.

        if(event->button() == RightButton)
        {
                // popup the context menu
                m_popupMenu(event->x(), event->y());
        }

}


void KLicq::reset()
{
   	m_displayPixmap();
}


void KLicq::m_dock()
{
 // this is not being used... but would be used later
 if (m_isDocked) 
	{m_isDocked=false;emit raiseicq();} 
 else
 	{m_isDocked=true;emit lowericq();}  
}

#endif
