#    debsigs: Package signing/verification system, arf module
#    AR File manipulation libraries
#    Copyright (C) 2000   Progeny Linux Systems, Inc. <jgoerzen@progeny.com>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Debian::debsigs::arf;
use IO::Pipe;
use IO::Handle;
use Debian::debsigs::forktools ':all';
use Cwd;

my $CVSVERSION = '$Progeny: arf.pm,v 1.11 2001/05/09 11:21:52 epg Exp $'; #'
my ($VERSION) = $CVSVERSION =~ /^\$Progeny: .+,v ([0-9.]+) /;

sub new {
  my ($class, $filename) = @_;
  my $self = {};

  $self->{filename} = ($filename =~ m'^/') ? $filename : 
    getcwd() . "/$filename";
  $self->{ar} = '/usr/bin/ar';
  bless $self, $class;
  return $self;
}

sub getfiles {
  my ($self, @filenames) = @_;
  
  return forkreader(undef, $self->{ar}, "-p", $self->{filename},
			       @filenames);
}


# If a data fd is specified, assume that someone already has an fd
# that would like to use for piping in data.  Otherwise, generate
# a new one to let them print to.

sub setfile {
  my ($self, $filename) = @_;

  return(system($self->{ar}, "-r", 
		$self->{filename}, $filename));
}

# Delete the specified file.

sub delete {
  my ($self, $filename) = @_;

  return(system($self->{ar}, "-d",
		$self->{filename}, $filename));
}

#

sub contents {
  my ($self) = @_;
  my ($fd, $arpid) = 
    forkreader(undef, $self->{ar}, "-t", $self->{filename});
  
  my $line;
  my @retval;
  while (defined($line = <$fd>)) {
    chomp $line;
    push @retval, $line;
  }
  assertsuccess($arpid, 'ar -t');
  return @retval;
}


#  if ($datafd) {
#    return forktools::forkreader($datafd, $self->{ar}, "-r", $self->{filename},
#				 $filename);
#  } else {
#    return forktools::forkwriter(undef, $self->{ar}, "-r", $self->{filename},
#				 $filename);
#  }
#}

1;
