#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1324
#define LARGE_STATE_COUNT 95
#define SYMBOL_COUNT 429
#define ALIAS_COUNT 2
#define TOKEN_COUNT 224
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 38
#define MAX_ALIAS_SEQUENCE_LENGTH 11
#define PRODUCTION_ID_COUNT 78

enum ts_symbol_identifiers {
  sym_ident = 1,
  anon_sym_theory = 2,
  anon_sym_configuration = 3,
  anon_sym_COLON = 4,
  anon_sym_DQUOTE = 5,
  anon_sym_begin = 6,
  anon_sym_end = 7,
  aux_sym_theory_token1 = 8,
  anon_sym_DASH_DASHauto_DASHsources = 9,
  anon_sym_DASH_DASHstop_DASHon_DASHtrace = 10,
  anon_sym_EQ = 11,
  anon_sym_BFS = 12,
  anon_sym_DFS = 13,
  anon_sym_SEQDFS = 14,
  anon_sym_bfs = 15,
  anon_sym_dfs = 16,
  anon_sym_seqdfs = 17,
  anon_sym_POUNDifdef = 18,
  anon_sym_POUNDelse = 19,
  anon_sym_POUNDendif = 20,
  anon_sym_POUNDdefine = 21,
  anon_sym_POUNDinclude = 22,
  anon_sym_LPAREN = 23,
  anon_sym_RPAREN = 24,
  anon_sym_PIPE = 25,
  anon_sym_AMP = 26,
  anon_sym_not = 27,
  anon_sym_builtins = 28,
  anon_sym_COMMA = 29,
  anon_sym_diffie_DASHhellman = 30,
  anon_sym_hashing = 31,
  anon_sym_symmetric_DASHencryption = 32,
  anon_sym_asymmetric_DASHencryption = 33,
  anon_sym_signing = 34,
  anon_sym_bilinear_DASHpairing = 35,
  anon_sym_xor = 36,
  anon_sym_multiset = 37,
  anon_sym_natural_DASHnumbers = 38,
  anon_sym_revealing_DASHsigning = 39,
  anon_sym_locations_DASHreport = 40,
  anon_sym_reliable_DASHchannel = 41,
  anon_sym_dest_DASHpairing = 42,
  anon_sym_dest_DASHsigning = 43,
  anon_sym_dest_DASHsymmetric_DASHencryption = 44,
  anon_sym_dest_DASHasymmetric_DASHencryption = 45,
  anon_sym_functions = 46,
  anon_sym_SLASH = 47,
  anon_sym_LBRACK = 48,
  anon_sym_RBRACK = 49,
  anon_sym_private = 50,
  anon_sym_destructor = 51,
  anon_sym_equations = 52,
  anon_sym_convergent = 53,
  anon_sym_predicate = 54,
  anon_sym_predicates = 55,
  anon_sym_LT_EQ_GT = 56,
  anon_sym_options = 57,
  anon_sym_translation_DASHstate_DASHoptimisation = 58,
  anon_sym_translation_DASHprogress = 59,
  anon_sym_translation_DASHasynchronous_DASHchannels = 60,
  anon_sym_translation_DASHcompress_DASHevents = 61,
  anon_sym_translation_DASHallow_DASHpattern_DASHlookups = 62,
  anon_sym_heuristic = 63,
  sym_standard_goal_ranking = 64,
  anon_sym_O = 65,
  anon_sym_o = 66,
  anon_sym_LBRACE = 67,
  anon_sym_RBRACE = 68,
  anon_sym_tactic = 69,
  anon_sym_presort = 70,
  anon_sym_prio = 71,
  anon_sym_deprio = 72,
  anon_sym_smallest = 73,
  anon_sym_id = 74,
  anon_sym_regex = 75,
  anon_sym_isFactName = 76,
  anon_sym_isInFactTerms = 77,
  anon_sym_dhreNoise = 78,
  anon_sym_defaultNoise = 79,
  anon_sym_reasonableNoncesNoise = 80,
  anon_sym_nonAbsurdGoal = 81,
  anon_sym_process = 82,
  anon_sym_AT = 83,
  anon_sym_DASH_DASH_GT = 84,
  anon_sym_SEMI = 85,
  anon_sym_new = 86,
  anon_sym_out = 87,
  anon_sym_in = 88,
  anon_sym_if = 89,
  anon_sym_then = 90,
  anon_sym_else = 91,
  anon_sym_let = 92,
  anon_sym_PIPE_PIPE = 93,
  anon_sym_PLUS = 94,
  sym_null = 95,
  anon_sym_event = 96,
  anon_sym_BANG = 97,
  anon_sym_insert = 98,
  anon_sym_delete = 99,
  anon_sym_lookup = 100,
  anon_sym_as = 101,
  anon_sym_lock = 102,
  anon_sym_unlock = 103,
  anon_sym_EQ2 = 104,
  anon_sym_LPAREN_LT_RPAREN = 105,
  anon_sym_LT_LT = 106,
  anon_sym_export = 107,
  anon_sym_left = 108,
  anon_sym_right = 109,
  anon_sym_rule = 110,
  anon_sym_DASH_DASH_LBRACK = 111,
  anon_sym_RBRACK_DASH_GT = 112,
  anon_sym_variants = 113,
  anon_sym_modulo = 114,
  anon_sym_E = 115,
  anon_sym_AC = 116,
  anon_sym_no_derivcheck = 117,
  anon_sym_issapicrule = 118,
  anon_sym_color_EQ = 119,
  anon_sym_colour_EQ = 120,
  anon_sym_role = 121,
  anon_sym_macros = 122,
  anon_sym__restrict = 123,
  anon_sym_DASH = 124,
  anon_sym_no_precomp = 125,
  anon_sym_restriction = 126,
  anon_sym_axiom = 127,
  anon_sym_test = 128,
  anon_sym_lemma = 129,
  anon_sym_sources = 130,
  anon_sym_reuse = 131,
  anon_sym_use_induction = 132,
  anon_sym_output_EQ = 133,
  anon_sym_hide_lemma_EQ = 134,
  anon_sym_heuristic_EQ = 135,
  anon_sym_spthy = 136,
  anon_sym_spthytyped = 137,
  anon_sym_msr = 138,
  anon_sym_proverif = 139,
  anon_sym_deepsec = 140,
  anon_sym_diffLemma = 141,
  anon_sym_account = 142,
  anon_sym_accounts = 143,
  anon_sym_for = 144,
  anon_sym_equivLemma = 145,
  anon_sym_diffEquivLemma = 146,
  anon_sym_all_DASHtraces = 147,
  anon_sym_exists_DASHtrace = 148,
  sym_solved = 149,
  sym_mirrored = 150,
  anon_sym_by = 151,
  anon_sym_next = 152,
  anon_sym_qed = 153,
  anon_sym_case = 154,
  anon_sym_sorry = 155,
  anon_sym_simplify = 156,
  anon_sym_solve = 157,
  anon_sym_contradiction = 158,
  anon_sym_induction = 159,
  anon_sym_rule_DASHequivalence = 160,
  anon_sym_backward_DASHsearch = 161,
  anon_sym_ATTACK = 162,
  anon_sym_step = 163,
  anon_sym_u25b6 = 164,
  anon_sym_TILDE_TILDE_GT = 165,
  anon_sym_u2225 = 166,
  anon_sym_splitEqs = 167,
  anon_sym_LT = 168,
  anon_sym_GT = 169,
  anon_sym_PLUS_PLUS = 170,
  anon_sym_PERCENT_PLUS = 171,
  anon_sym_XOR = 172,
  anon_sym_u2295 = 173,
  anon_sym_STAR = 174,
  anon_sym_CARET = 175,
  anon_sym_DOLLAR = 176,
  anon_sym_DOT = 177,
  anon_sym_pub = 178,
  anon_sym_TILDE = 179,
  anon_sym_fresh = 180,
  anon_sym_msg = 181,
  anon_sym_POUND = 182,
  anon_sym_node = 183,
  anon_sym_PERCENT = 184,
  anon_sym_nat = 185,
  anon_sym_ANY = 186,
  anon_sym_temporal = 187,
  anon_sym_SQUOTE = 188,
  aux_sym_pub_name_token1 = 189,
  anon_sym_TILDE_SQUOTE = 190,
  anon_sym_u21d4 = 191,
  anon_sym_EQ_EQ_GT = 192,
  anon_sym_u21d2 = 193,
  anon_sym_u2228 = 194,
  anon_sym_u2227 = 195,
  anon_sym_u00ac = 196,
  anon_sym_last = 197,
  anon_sym_u228f = 198,
  anon_sym_Ex = 199,
  anon_sym_u2203 = 200,
  anon_sym_All = 201,
  anon_sym_u2200 = 202,
  anon_sym_u22a5 = 203,
  anon_sym_F = 204,
  anon_sym_u22a4 = 205,
  anon_sym_T = 206,
  aux_sym_hexcolor_token1 = 207,
  sym_param = 208,
  sym_export_query = 209,
  sym_natural = 210,
  anon_sym_u2080 = 211,
  anon_sym_u2081 = 212,
  anon_sym_u2082 = 213,
  anon_sym_u2083 = 214,
  anon_sym_u2084 = 215,
  anon_sym_u2085 = 216,
  anon_sym_u2086 = 217,
  anon_sym_u2087 = 218,
  anon_sym_u2088 = 219,
  anon_sym_u2089 = 220,
  aux_sym_formal_comment_token1 = 221,
  sym_multi_comment = 222,
  sym_single_comment = 223,
  sym_theory = 224,
  sym_commandline = 225,
  sym__search_strategy = 226,
  sym__body_item = 227,
  sym_preprocessor = 228,
  sym_ifdef = 229,
  sym_define = 230,
  sym_include = 231,
  sym__ifdef_formula = 232,
  sym_ifdef_nested = 233,
  sym_ifdef_or = 234,
  sym_ifdef_and = 235,
  sym_ifdef_not = 236,
  sym__signature_spec = 237,
  sym_built_ins = 238,
  sym_built_in = 239,
  sym_functions = 240,
  sym__function_sym = 241,
  sym_function_untyped = 242,
  sym_function_attribute = 243,
  sym_function_typed = 244,
  sym_equations = 245,
  sym_equation = 246,
  sym_predicates = 247,
  sym_predicate = 248,
  sym_predicate_def = 249,
  sym_options = 250,
  sym_option = 251,
  sym_global_heuristic = 252,
  sym__goal_ranking = 253,
  sym_oracle_goal_ranking = 254,
  sym_tactic_goal_ranking = 255,
  sym_tactic = 256,
  sym_presort = 257,
  sym_prio = 258,
  sym_deprio = 259,
  sym_post_ranking = 260,
  sym__function = 261,
  sym_or_function = 262,
  sym_and_function = 263,
  sym_not_function = 264,
  sym_std_function = 265,
  sym_function_name = 266,
  sym_process = 267,
  sym__process = 268,
  sym__elementary_process = 269,
  sym__extended_process = 270,
  sym__stateful_process = 271,
  sym_location_process = 272,
  sym_inline_msr_process = 273,
  sym__nested_process = 274,
  sym_predefined_process = 275,
  sym_binding = 276,
  sym_output = 277,
  sym_input = 278,
  sym_conditional = 279,
  sym_process_let = 280,
  sym_deterministic_choice = 281,
  sym_non_deterministic_choice = 282,
  sym_event = 283,
  sym_replication = 284,
  sym_set_state = 285,
  sym_delete_state = 286,
  sym_read_state = 287,
  sym_set_lock = 288,
  sym_remove_lock = 289,
  sym__condition = 290,
  sym_equality_check = 291,
  sym_lesser_check = 292,
  sym_let = 293,
  sym_export = 294,
  sym__rule = 295,
  sym_rule = 296,
  sym_diff_rule = 297,
  sym_simple_rule = 298,
  sym_premise = 299,
  sym_action_fact = 300,
  sym_conclusion = 301,
  sym_variants = 302,
  sym_modulo = 303,
  sym_rule_attrs = 304,
  sym_rule_attr = 305,
  sym_rule_attr_color = 306,
  sym_rule_role = 307,
  sym_rule_process = 308,
  sym_rule_let_block = 309,
  sym_rule_let_term = 310,
  sym_macros = 311,
  sym_macro = 312,
  sym_embedded_restriction = 313,
  sym__facts_restrictions = 314,
  sym__facts = 315,
  sym__fact = 316,
  sym_fact = 317,
  sym_fact_annotes = 318,
  sym_fact_annote = 319,
  sym_restriction = 320,
  sym_restriction_attr = 321,
  sym_case_test = 322,
  sym__lemma = 323,
  sym_lemma = 324,
  sym_lemma_attr = 325,
  sym_language = 326,
  sym_diff_lemma = 327,
  sym_diff_lemma_attrs = 328,
  sym_diff_lemma_attr = 329,
  sym_accountability_lemma = 330,
  sym_equiv_lemma = 331,
  sym_diff_equiv_lemma = 332,
  sym_trace_quantifier = 333,
  sym__proof_skeleton = 334,
  sym_by_method = 335,
  sym_method_skeleton = 336,
  sym_cases = 337,
  sym_case = 338,
  sym__proof_methods = 339,
  sym_proof_method = 340,
  sym_step = 341,
  sym_goal = 342,
  sym_premise_goal = 343,
  sym_action_goal = 344,
  sym_chain_goal = 345,
  sym_disjunction_split_goal = 346,
  sym_eq_split_goal = 347,
  sym__term = 348,
  sym_tuple_term = 349,
  sym_mset_term = 350,
  sym_nat_term = 351,
  sym_xor_term = 352,
  sym_mul_term = 353,
  sym_exp_term = 354,
  sym_nested_term = 355,
  sym_nullary_fun = 356,
  sym_binary_app = 357,
  sym_nary_app = 358,
  sym_arguments = 359,
  sym__literal = 360,
  sym__non_temporal_var = 361,
  sym_pub_var = 362,
  sym_fresh_var = 363,
  sym_msg_var_or_nullary_fun = 364,
  sym_temporal_var = 365,
  sym_nat_var = 366,
  sym_comp_var = 367,
  sym__custom_type_var = 368,
  sym_custom_var = 369,
  sym_any_var = 370,
  sym_temporal_var_optional_prefix = 371,
  sym_pub_name = 372,
  sym_fresh_name = 373,
  sym__formula = 374,
  sym_iff = 375,
  sym_imp = 376,
  sym_disjunction = 377,
  sym_conjunction = 378,
  sym_negation = 379,
  sym_nested_formula = 380,
  sym__temporal_variable_operation = 381,
  sym_temp_var_induction = 382,
  sym_temp_var_order = 383,
  sym_temp_var_eq = 384,
  sym_action_constraint = 385,
  sym_term_eq = 386,
  sym_subterm_rel = 387,
  sym_quantified_formula = 388,
  sym_atom = 389,
  sym__lvar = 390,
  sym_predicate_ref = 391,
  sym_pre_defined = 392,
  sym_hexcolor = 393,
  sym_natural_subscript = 394,
  sym_formal_comment = 395,
  aux_sym_theory_repeat1 = 396,
  aux_sym_theory_repeat2 = 397,
  aux_sym_commandline_repeat1 = 398,
  aux_sym_built_ins_repeat1 = 399,
  aux_sym_functions_repeat1 = 400,
  aux_sym_function_untyped_repeat1 = 401,
  aux_sym_equations_repeat1 = 402,
  aux_sym_predicates_repeat1 = 403,
  aux_sym_options_repeat1 = 404,
  aux_sym_global_heuristic_repeat1 = 405,
  aux_sym_tactic_repeat1 = 406,
  aux_sym_tactic_repeat2 = 407,
  aux_sym_prio_repeat1 = 408,
  aux_sym_std_function_repeat1 = 409,
  aux_sym_process_let_repeat1 = 410,
  aux_sym_variants_repeat1 = 411,
  aux_sym_rule_attrs_repeat1 = 412,
  aux_sym_rule_let_block_repeat1 = 413,
  aux_sym_macros_repeat1 = 414,
  aux_sym_macro_repeat1 = 415,
  aux_sym__facts_restrictions_repeat1 = 416,
  aux_sym__facts_repeat1 = 417,
  aux_sym_fact_annotes_repeat1 = 418,
  aux_sym_lemma_attr_repeat1 = 419,
  aux_sym_diff_lemma_attrs_repeat1 = 420,
  aux_sym_accountability_lemma_repeat1 = 421,
  aux_sym_cases_repeat1 = 422,
  aux_sym__proof_methods_repeat1 = 423,
  aux_sym_disjunction_split_goal_repeat1 = 424,
  aux_sym_tuple_term_repeat1 = 425,
  aux_sym_binary_app_repeat1 = 426,
  aux_sym_quantified_formula_repeat1 = 427,
  aux_sym_natural_subscript_repeat1 = 428,
  alias_sym_path = 429,
  alias_sym_persistent_fact = 430,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_ident] = "ident",
  [anon_sym_theory] = "theory",
  [anon_sym_configuration] = "configuration",
  [anon_sym_COLON] = ":",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_begin] = "begin",
  [anon_sym_end] = "end",
  [aux_sym_theory_token1] = "theory_token1",
  [anon_sym_DASH_DASHauto_DASHsources] = "--auto-sources",
  [anon_sym_DASH_DASHstop_DASHon_DASHtrace] = "--stop-on-trace",
  [anon_sym_EQ] = "=",
  [anon_sym_BFS] = "BFS",
  [anon_sym_DFS] = "DFS",
  [anon_sym_SEQDFS] = "SEQDFS",
  [anon_sym_bfs] = "bfs",
  [anon_sym_dfs] = "dfs",
  [anon_sym_seqdfs] = "seqdfs",
  [anon_sym_POUNDifdef] = "#ifdef",
  [anon_sym_POUNDelse] = "#else",
  [anon_sym_POUNDendif] = "#endif",
  [anon_sym_POUNDdefine] = "#define",
  [anon_sym_POUNDinclude] = "#include",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_not] = "not",
  [anon_sym_builtins] = "builtins",
  [anon_sym_COMMA] = ",",
  [anon_sym_diffie_DASHhellman] = "diffie-hellman",
  [anon_sym_hashing] = "hashing",
  [anon_sym_symmetric_DASHencryption] = "symmetric-encryption",
  [anon_sym_asymmetric_DASHencryption] = "asymmetric-encryption",
  [anon_sym_signing] = "signing",
  [anon_sym_bilinear_DASHpairing] = "bilinear-pairing",
  [anon_sym_xor] = "xor",
  [anon_sym_multiset] = "multiset",
  [anon_sym_natural_DASHnumbers] = "natural-numbers",
  [anon_sym_revealing_DASHsigning] = "revealing-signing",
  [anon_sym_locations_DASHreport] = "locations-report",
  [anon_sym_reliable_DASHchannel] = "reliable-channel",
  [anon_sym_dest_DASHpairing] = "dest-pairing",
  [anon_sym_dest_DASHsigning] = "dest-signing",
  [anon_sym_dest_DASHsymmetric_DASHencryption] = "dest-symmetric-encryption",
  [anon_sym_dest_DASHasymmetric_DASHencryption] = "dest-asymmetric-encryption",
  [anon_sym_functions] = "functions",
  [anon_sym_SLASH] = "/",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_private] = "private",
  [anon_sym_destructor] = "destructor",
  [anon_sym_equations] = "equations",
  [anon_sym_convergent] = "convergent",
  [anon_sym_predicate] = "predicate",
  [anon_sym_predicates] = "predicates",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_options] = "options",
  [anon_sym_translation_DASHstate_DASHoptimisation] = "translation-state-optimisation",
  [anon_sym_translation_DASHprogress] = "translation-progress",
  [anon_sym_translation_DASHasynchronous_DASHchannels] = "translation-asynchronous-channels",
  [anon_sym_translation_DASHcompress_DASHevents] = "translation-compress-events",
  [anon_sym_translation_DASHallow_DASHpattern_DASHlookups] = "translation-allow-pattern-lookups",
  [anon_sym_heuristic] = "heuristic",
  [sym_standard_goal_ranking] = "standard_goal_ranking",
  [anon_sym_O] = "O",
  [anon_sym_o] = "o",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_tactic] = "tactic",
  [anon_sym_presort] = "presort",
  [anon_sym_prio] = "prio",
  [anon_sym_deprio] = "deprio",
  [anon_sym_smallest] = "smallest",
  [anon_sym_id] = "id",
  [anon_sym_regex] = "regex",
  [anon_sym_isFactName] = "isFactName",
  [anon_sym_isInFactTerms] = "isInFactTerms",
  [anon_sym_dhreNoise] = "dhreNoise",
  [anon_sym_defaultNoise] = "defaultNoise",
  [anon_sym_reasonableNoncesNoise] = "reasonableNoncesNoise",
  [anon_sym_nonAbsurdGoal] = "nonAbsurdGoal",
  [anon_sym_process] = "process",
  [anon_sym_AT] = "@",
  [anon_sym_DASH_DASH_GT] = "-->",
  [anon_sym_SEMI] = ";",
  [anon_sym_new] = "new",
  [anon_sym_out] = "out",
  [anon_sym_in] = "in",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_let] = "let",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [sym_null] = "null",
  [anon_sym_event] = "event",
  [anon_sym_BANG] = "!",
  [anon_sym_insert] = "insert",
  [anon_sym_delete] = "delete",
  [anon_sym_lookup] = "lookup",
  [anon_sym_as] = "as",
  [anon_sym_lock] = "lock",
  [anon_sym_unlock] = "unlock",
  [anon_sym_EQ2] = "=",
  [anon_sym_LPAREN_LT_RPAREN] = "(<)",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_export] = "export",
  [anon_sym_left] = "left",
  [anon_sym_right] = "right",
  [anon_sym_rule] = "rule",
  [anon_sym_DASH_DASH_LBRACK] = "--[",
  [anon_sym_RBRACK_DASH_GT] = "]->",
  [anon_sym_variants] = "variants",
  [anon_sym_modulo] = "modulo",
  [anon_sym_E] = "E",
  [anon_sym_AC] = "AC",
  [anon_sym_no_derivcheck] = "no_derivcheck",
  [anon_sym_issapicrule] = "issapicrule",
  [anon_sym_color_EQ] = "color=",
  [anon_sym_colour_EQ] = "colour=",
  [anon_sym_role] = "role",
  [anon_sym_macros] = "macros",
  [anon_sym__restrict] = "_restrict",
  [anon_sym_DASH] = "-",
  [anon_sym_no_precomp] = "no_precomp",
  [anon_sym_restriction] = "restriction",
  [anon_sym_axiom] = "axiom",
  [anon_sym_test] = "test",
  [anon_sym_lemma] = "lemma",
  [anon_sym_sources] = "sources",
  [anon_sym_reuse] = "reuse",
  [anon_sym_use_induction] = "use_induction",
  [anon_sym_output_EQ] = "output=",
  [anon_sym_hide_lemma_EQ] = "hide_lemma=",
  [anon_sym_heuristic_EQ] = "heuristic=",
  [anon_sym_spthy] = "spthy",
  [anon_sym_spthytyped] = "spthytyped",
  [anon_sym_msr] = "msr",
  [anon_sym_proverif] = "proverif",
  [anon_sym_deepsec] = "deepsec",
  [anon_sym_diffLemma] = "diffLemma",
  [anon_sym_account] = "account",
  [anon_sym_accounts] = "accounts",
  [anon_sym_for] = "for",
  [anon_sym_equivLemma] = "equivLemma",
  [anon_sym_diffEquivLemma] = "diffEquivLemma",
  [anon_sym_all_DASHtraces] = "all-traces",
  [anon_sym_exists_DASHtrace] = "exists-trace",
  [sym_solved] = "solved",
  [sym_mirrored] = "mirrored",
  [anon_sym_by] = "by",
  [anon_sym_next] = "next",
  [anon_sym_qed] = "qed",
  [anon_sym_case] = "case",
  [anon_sym_sorry] = "sorry",
  [anon_sym_simplify] = "simplify",
  [anon_sym_solve] = "solve",
  [anon_sym_contradiction] = "contradiction",
  [anon_sym_induction] = "induction",
  [anon_sym_rule_DASHequivalence] = "rule-equivalence",
  [anon_sym_backward_DASHsearch] = "backward-search",
  [anon_sym_ATTACK] = "ATTACK",
  [anon_sym_step] = "step",
  [anon_sym_u25b6] = "\u25b6",
  [anon_sym_TILDE_TILDE_GT] = "~~>",
  [anon_sym_u2225] = "\u2225",
  [anon_sym_splitEqs] = "splitEqs",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_PERCENT_PLUS] = "%+",
  [anon_sym_XOR] = "XOR",
  [anon_sym_u2295] = "\u2295",
  [anon_sym_STAR] = "*",
  [anon_sym_CARET] = "^",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_DOT] = ".",
  [anon_sym_pub] = "pub",
  [anon_sym_TILDE] = "~",
  [anon_sym_fresh] = "fresh",
  [anon_sym_msg] = "msg",
  [anon_sym_POUND] = "#",
  [anon_sym_node] = "node",
  [anon_sym_PERCENT] = "%",
  [anon_sym_nat] = "nat",
  [anon_sym_ANY] = "ANY",
  [anon_sym_temporal] = "temporal",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_pub_name_token1] = "pub_name_token1",
  [anon_sym_TILDE_SQUOTE] = "~'",
  [anon_sym_u21d4] = "\u21d4",
  [anon_sym_EQ_EQ_GT] = "==>",
  [anon_sym_u21d2] = "\u21d2",
  [anon_sym_u2228] = "\u2228",
  [anon_sym_u2227] = "\u2227",
  [anon_sym_u00ac] = "\u00ac",
  [anon_sym_last] = "last",
  [anon_sym_u228f] = "\u228f",
  [anon_sym_Ex] = "Ex",
  [anon_sym_u2203] = "\u2203",
  [anon_sym_All] = "All",
  [anon_sym_u2200] = "\u2200",
  [anon_sym_u22a5] = "\u22a5",
  [anon_sym_F] = "F",
  [anon_sym_u22a4] = "\u22a4",
  [anon_sym_T] = "T",
  [aux_sym_hexcolor_token1] = "hexcolor_token1",
  [sym_param] = "param",
  [sym_export_query] = "export_query",
  [sym_natural] = "natural",
  [anon_sym_u2080] = "\u2080",
  [anon_sym_u2081] = "\u2081",
  [anon_sym_u2082] = "\u2082",
  [anon_sym_u2083] = "\u2083",
  [anon_sym_u2084] = "\u2084",
  [anon_sym_u2085] = "\u2085",
  [anon_sym_u2086] = "\u2086",
  [anon_sym_u2087] = "\u2087",
  [anon_sym_u2088] = "\u2088",
  [anon_sym_u2089] = "\u2089",
  [aux_sym_formal_comment_token1] = "formal_comment_token1",
  [sym_multi_comment] = "multi_comment",
  [sym_single_comment] = "single_comment",
  [sym_theory] = "theory",
  [sym_commandline] = "commandline",
  [sym__search_strategy] = "_search_strategy",
  [sym__body_item] = "_body_item",
  [sym_preprocessor] = "preprocessor",
  [sym_ifdef] = "ifdef",
  [sym_define] = "define",
  [sym_include] = "include",
  [sym__ifdef_formula] = "_ifdef_formula",
  [sym_ifdef_nested] = "ifdef_nested",
  [sym_ifdef_or] = "ifdef_or",
  [sym_ifdef_and] = "ifdef_and",
  [sym_ifdef_not] = "ifdef_not",
  [sym__signature_spec] = "_signature_spec",
  [sym_built_ins] = "built_ins",
  [sym_built_in] = "built_in",
  [sym_functions] = "functions",
  [sym__function_sym] = "_function_sym",
  [sym_function_untyped] = "function_untyped",
  [sym_function_attribute] = "function_attribute",
  [sym_function_typed] = "function_typed",
  [sym_equations] = "equations",
  [sym_equation] = "equation",
  [sym_predicates] = "predicates",
  [sym_predicate] = "predicate",
  [sym_predicate_def] = "",
  [sym_options] = "options",
  [sym_option] = "option",
  [sym_global_heuristic] = "global_heuristic",
  [sym__goal_ranking] = "_goal_ranking",
  [sym_oracle_goal_ranking] = "oracle_goal_ranking",
  [sym_tactic_goal_ranking] = "tactic_goal_ranking",
  [sym_tactic] = "tactic",
  [sym_presort] = "presort",
  [sym_prio] = "prio",
  [sym_deprio] = "deprio",
  [sym_post_ranking] = "post_ranking",
  [sym__function] = "_function",
  [sym_or_function] = "or_function",
  [sym_and_function] = "and_function",
  [sym_not_function] = "not_function",
  [sym_std_function] = "std_function",
  [sym_function_name] = "function_name",
  [sym_process] = "process",
  [sym__process] = "_process",
  [sym__elementary_process] = "_elementary_process",
  [sym__extended_process] = "_extended_process",
  [sym__stateful_process] = "_stateful_process",
  [sym_location_process] = "location_process",
  [sym_inline_msr_process] = "inline_msr_process",
  [sym__nested_process] = "_nested_process",
  [sym_predefined_process] = "predefined_process",
  [sym_binding] = "binding",
  [sym_output] = "output",
  [sym_input] = "input",
  [sym_conditional] = "conditional",
  [sym_process_let] = "process_let",
  [sym_deterministic_choice] = "deterministic_choice",
  [sym_non_deterministic_choice] = "non_deterministic_choice",
  [sym_event] = "event",
  [sym_replication] = "replication",
  [sym_set_state] = "set_state",
  [sym_delete_state] = "delete_state",
  [sym_read_state] = "read_state",
  [sym_set_lock] = "set_lock",
  [sym_remove_lock] = "remove_lock",
  [sym__condition] = "_condition",
  [sym_equality_check] = "equality_check",
  [sym_lesser_check] = "lesser_check",
  [sym_let] = "let",
  [sym_export] = "export",
  [sym__rule] = "_rule",
  [sym_rule] = "rule",
  [sym_diff_rule] = "diff_rule",
  [sym_simple_rule] = "simple_rule",
  [sym_premise] = "premise",
  [sym_action_fact] = "action_fact",
  [sym_conclusion] = "conclusion",
  [sym_variants] = "variants",
  [sym_modulo] = "modulo",
  [sym_rule_attrs] = "rule_attrs",
  [sym_rule_attr] = "rule_attr",
  [sym_rule_attr_color] = "rule_attr_color",
  [sym_rule_role] = "rule_role",
  [sym_rule_process] = "rule_process",
  [sym_rule_let_block] = "rule_let_block",
  [sym_rule_let_term] = "rule_let_term",
  [sym_macros] = "macros",
  [sym_macro] = "macro",
  [sym_embedded_restriction] = "embedded_restriction",
  [sym__facts_restrictions] = "_facts_restrictions",
  [sym__facts] = "_facts",
  [sym__fact] = "_fact",
  [sym_fact] = "linear_fact",
  [sym_fact_annotes] = "fact_annotes",
  [sym_fact_annote] = "fact_annote",
  [sym_restriction] = "restriction",
  [sym_restriction_attr] = "restriction_attr",
  [sym_case_test] = "case_test",
  [sym__lemma] = "_lemma",
  [sym_lemma] = "lemma",
  [sym_lemma_attr] = "lemma_attr",
  [sym_language] = "language",
  [sym_diff_lemma] = "diff_lemma",
  [sym_diff_lemma_attrs] = "diff_lemma_attrs",
  [sym_diff_lemma_attr] = "diff_lemma_attr",
  [sym_accountability_lemma] = "accountability_lemma",
  [sym_equiv_lemma] = "equiv_lemma",
  [sym_diff_equiv_lemma] = "diff_equiv_lemma",
  [sym_trace_quantifier] = "trace_quantifier",
  [sym__proof_skeleton] = "_proof_skeleton",
  [sym_by_method] = "by_method",
  [sym_method_skeleton] = "method_skeleton",
  [sym_cases] = "cases",
  [sym_case] = "case",
  [sym__proof_methods] = "_proof_methods",
  [sym_proof_method] = "proof_method",
  [sym_step] = "step",
  [sym_goal] = "goal",
  [sym_premise_goal] = "premise_goal",
  [sym_action_goal] = "action_goal",
  [sym_chain_goal] = "chain_goal",
  [sym_disjunction_split_goal] = "disjunction_split_goal",
  [sym_eq_split_goal] = "eq_split_goal",
  [sym__term] = "_term",
  [sym_tuple_term] = "tuple_term",
  [sym_mset_term] = "mset_term",
  [sym_nat_term] = "nat_term",
  [sym_xor_term] = "xor_term",
  [sym_mul_term] = "mul_term",
  [sym_exp_term] = "exp_term",
  [sym_nested_term] = "nested_term",
  [sym_nullary_fun] = "nullary_fun",
  [sym_binary_app] = "binary_app",
  [sym_nary_app] = "nary_app",
  [sym_arguments] = "arguments",
  [sym__literal] = "_literal",
  [sym__non_temporal_var] = "_non_temporal_var",
  [sym_pub_var] = "pub_var",
  [sym_fresh_var] = "fresh_var",
  [sym_msg_var_or_nullary_fun] = "msg_var_or_nullary_fun",
  [sym_temporal_var] = "temporal_var",
  [sym_nat_var] = "nat_var",
  [sym_comp_var] = "comp_var",
  [sym__custom_type_var] = "_custom_type_var",
  [sym_custom_var] = "custom_var",
  [sym_any_var] = "any_var",
  [sym_temporal_var_optional_prefix] = "temporal_var",
  [sym_pub_name] = "pub_name",
  [sym_fresh_name] = "fresh_name",
  [sym__formula] = "_formula",
  [sym_iff] = "iff",
  [sym_imp] = "imp",
  [sym_disjunction] = "disjunction",
  [sym_conjunction] = "conjunction",
  [sym_negation] = "negation",
  [sym_nested_formula] = "nested_formula",
  [sym__temporal_variable_operation] = "_temporal_variable_operation",
  [sym_temp_var_induction] = "temp_var_induction",
  [sym_temp_var_order] = "temp_var_order",
  [sym_temp_var_eq] = "temp_var_eq",
  [sym_action_constraint] = "action_constraint",
  [sym_term_eq] = "term_eq",
  [sym_subterm_rel] = "subterm_rel",
  [sym_quantified_formula] = "quantified_formula",
  [sym_atom] = "atom",
  [sym__lvar] = "_lvar",
  [sym_predicate_ref] = "predicate_ref",
  [sym_pre_defined] = "pre_defined",
  [sym_hexcolor] = "hexcolor",
  [sym_natural_subscript] = "natural_subscript",
  [sym_formal_comment] = "formal_comment",
  [aux_sym_theory_repeat1] = "theory_repeat1",
  [aux_sym_theory_repeat2] = "theory_repeat2",
  [aux_sym_commandline_repeat1] = "commandline_repeat1",
  [aux_sym_built_ins_repeat1] = "built_ins_repeat1",
  [aux_sym_functions_repeat1] = "functions_repeat1",
  [aux_sym_function_untyped_repeat1] = "function_untyped_repeat1",
  [aux_sym_equations_repeat1] = "equations_repeat1",
  [aux_sym_predicates_repeat1] = "predicates_repeat1",
  [aux_sym_options_repeat1] = "options_repeat1",
  [aux_sym_global_heuristic_repeat1] = "global_heuristic_repeat1",
  [aux_sym_tactic_repeat1] = "tactic_repeat1",
  [aux_sym_tactic_repeat2] = "tactic_repeat2",
  [aux_sym_prio_repeat1] = "prio_repeat1",
  [aux_sym_std_function_repeat1] = "std_function_repeat1",
  [aux_sym_process_let_repeat1] = "process_let_repeat1",
  [aux_sym_variants_repeat1] = "variants_repeat1",
  [aux_sym_rule_attrs_repeat1] = "rule_attrs_repeat1",
  [aux_sym_rule_let_block_repeat1] = "rule_let_block_repeat1",
  [aux_sym_macros_repeat1] = "macros_repeat1",
  [aux_sym_macro_repeat1] = "macro_repeat1",
  [aux_sym__facts_restrictions_repeat1] = "_facts_restrictions_repeat1",
  [aux_sym__facts_repeat1] = "_facts_repeat1",
  [aux_sym_fact_annotes_repeat1] = "fact_annotes_repeat1",
  [aux_sym_lemma_attr_repeat1] = "lemma_attr_repeat1",
  [aux_sym_diff_lemma_attrs_repeat1] = "diff_lemma_attrs_repeat1",
  [aux_sym_accountability_lemma_repeat1] = "accountability_lemma_repeat1",
  [aux_sym_cases_repeat1] = "cases_repeat1",
  [aux_sym__proof_methods_repeat1] = "_proof_methods_repeat1",
  [aux_sym_disjunction_split_goal_repeat1] = "disjunction_split_goal_repeat1",
  [aux_sym_tuple_term_repeat1] = "tuple_term_repeat1",
  [aux_sym_binary_app_repeat1] = "binary_app_repeat1",
  [aux_sym_quantified_formula_repeat1] = "quantified_formula_repeat1",
  [aux_sym_natural_subscript_repeat1] = "natural_subscript_repeat1",
  [alias_sym_path] = "path",
  [alias_sym_persistent_fact] = "persistent_fact",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_ident] = sym_ident,
  [anon_sym_theory] = anon_sym_theory,
  [anon_sym_configuration] = anon_sym_configuration,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_begin] = anon_sym_begin,
  [anon_sym_end] = anon_sym_end,
  [aux_sym_theory_token1] = aux_sym_theory_token1,
  [anon_sym_DASH_DASHauto_DASHsources] = anon_sym_DASH_DASHauto_DASHsources,
  [anon_sym_DASH_DASHstop_DASHon_DASHtrace] = anon_sym_DASH_DASHstop_DASHon_DASHtrace,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_BFS] = anon_sym_BFS,
  [anon_sym_DFS] = anon_sym_DFS,
  [anon_sym_SEQDFS] = anon_sym_SEQDFS,
  [anon_sym_bfs] = anon_sym_bfs,
  [anon_sym_dfs] = anon_sym_dfs,
  [anon_sym_seqdfs] = anon_sym_seqdfs,
  [anon_sym_POUNDifdef] = anon_sym_POUNDifdef,
  [anon_sym_POUNDelse] = anon_sym_POUNDelse,
  [anon_sym_POUNDendif] = anon_sym_POUNDendif,
  [anon_sym_POUNDdefine] = anon_sym_POUNDdefine,
  [anon_sym_POUNDinclude] = anon_sym_POUNDinclude,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_builtins] = anon_sym_builtins,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_diffie_DASHhellman] = anon_sym_diffie_DASHhellman,
  [anon_sym_hashing] = anon_sym_hashing,
  [anon_sym_symmetric_DASHencryption] = anon_sym_symmetric_DASHencryption,
  [anon_sym_asymmetric_DASHencryption] = anon_sym_asymmetric_DASHencryption,
  [anon_sym_signing] = anon_sym_signing,
  [anon_sym_bilinear_DASHpairing] = anon_sym_bilinear_DASHpairing,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_multiset] = anon_sym_multiset,
  [anon_sym_natural_DASHnumbers] = anon_sym_natural_DASHnumbers,
  [anon_sym_revealing_DASHsigning] = anon_sym_revealing_DASHsigning,
  [anon_sym_locations_DASHreport] = anon_sym_locations_DASHreport,
  [anon_sym_reliable_DASHchannel] = anon_sym_reliable_DASHchannel,
  [anon_sym_dest_DASHpairing] = anon_sym_dest_DASHpairing,
  [anon_sym_dest_DASHsigning] = anon_sym_dest_DASHsigning,
  [anon_sym_dest_DASHsymmetric_DASHencryption] = anon_sym_dest_DASHsymmetric_DASHencryption,
  [anon_sym_dest_DASHasymmetric_DASHencryption] = anon_sym_dest_DASHasymmetric_DASHencryption,
  [anon_sym_functions] = anon_sym_functions,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_destructor] = anon_sym_destructor,
  [anon_sym_equations] = anon_sym_equations,
  [anon_sym_convergent] = anon_sym_convergent,
  [anon_sym_predicate] = anon_sym_predicate,
  [anon_sym_predicates] = anon_sym_predicates,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_options] = anon_sym_options,
  [anon_sym_translation_DASHstate_DASHoptimisation] = anon_sym_translation_DASHstate_DASHoptimisation,
  [anon_sym_translation_DASHprogress] = anon_sym_translation_DASHprogress,
  [anon_sym_translation_DASHasynchronous_DASHchannels] = anon_sym_translation_DASHasynchronous_DASHchannels,
  [anon_sym_translation_DASHcompress_DASHevents] = anon_sym_translation_DASHcompress_DASHevents,
  [anon_sym_translation_DASHallow_DASHpattern_DASHlookups] = anon_sym_translation_DASHallow_DASHpattern_DASHlookups,
  [anon_sym_heuristic] = anon_sym_heuristic,
  [sym_standard_goal_ranking] = sym_standard_goal_ranking,
  [anon_sym_O] = anon_sym_O,
  [anon_sym_o] = anon_sym_o,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_tactic] = anon_sym_tactic,
  [anon_sym_presort] = anon_sym_presort,
  [anon_sym_prio] = anon_sym_prio,
  [anon_sym_deprio] = anon_sym_deprio,
  [anon_sym_smallest] = anon_sym_smallest,
  [anon_sym_id] = anon_sym_id,
  [anon_sym_regex] = anon_sym_regex,
  [anon_sym_isFactName] = anon_sym_isFactName,
  [anon_sym_isInFactTerms] = anon_sym_isInFactTerms,
  [anon_sym_dhreNoise] = anon_sym_dhreNoise,
  [anon_sym_defaultNoise] = anon_sym_defaultNoise,
  [anon_sym_reasonableNoncesNoise] = anon_sym_reasonableNoncesNoise,
  [anon_sym_nonAbsurdGoal] = anon_sym_nonAbsurdGoal,
  [anon_sym_process] = anon_sym_process,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_DASH_DASH_GT] = anon_sym_DASH_DASH_GT,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_out] = anon_sym_out,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [sym_null] = sym_null,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_insert] = anon_sym_insert,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_lookup] = anon_sym_lookup,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_lock] = anon_sym_lock,
  [anon_sym_unlock] = anon_sym_unlock,
  [anon_sym_EQ2] = anon_sym_EQ,
  [anon_sym_LPAREN_LT_RPAREN] = anon_sym_LPAREN_LT_RPAREN,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_left] = anon_sym_left,
  [anon_sym_right] = anon_sym_right,
  [anon_sym_rule] = anon_sym_rule,
  [anon_sym_DASH_DASH_LBRACK] = anon_sym_DASH_DASH_LBRACK,
  [anon_sym_RBRACK_DASH_GT] = anon_sym_RBRACK_DASH_GT,
  [anon_sym_variants] = anon_sym_variants,
  [anon_sym_modulo] = anon_sym_modulo,
  [anon_sym_E] = anon_sym_E,
  [anon_sym_AC] = anon_sym_AC,
  [anon_sym_no_derivcheck] = anon_sym_no_derivcheck,
  [anon_sym_issapicrule] = anon_sym_issapicrule,
  [anon_sym_color_EQ] = anon_sym_color_EQ,
  [anon_sym_colour_EQ] = anon_sym_colour_EQ,
  [anon_sym_role] = anon_sym_role,
  [anon_sym_macros] = anon_sym_macros,
  [anon_sym__restrict] = anon_sym__restrict,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_no_precomp] = anon_sym_no_precomp,
  [anon_sym_restriction] = anon_sym_restriction,
  [anon_sym_axiom] = anon_sym_axiom,
  [anon_sym_test] = anon_sym_test,
  [anon_sym_lemma] = anon_sym_lemma,
  [anon_sym_sources] = anon_sym_sources,
  [anon_sym_reuse] = anon_sym_reuse,
  [anon_sym_use_induction] = anon_sym_use_induction,
  [anon_sym_output_EQ] = anon_sym_output_EQ,
  [anon_sym_hide_lemma_EQ] = anon_sym_hide_lemma_EQ,
  [anon_sym_heuristic_EQ] = anon_sym_heuristic_EQ,
  [anon_sym_spthy] = anon_sym_spthy,
  [anon_sym_spthytyped] = anon_sym_spthytyped,
  [anon_sym_msr] = anon_sym_msr,
  [anon_sym_proverif] = anon_sym_proverif,
  [anon_sym_deepsec] = anon_sym_deepsec,
  [anon_sym_diffLemma] = anon_sym_diffLemma,
  [anon_sym_account] = anon_sym_account,
  [anon_sym_accounts] = anon_sym_accounts,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_equivLemma] = anon_sym_equivLemma,
  [anon_sym_diffEquivLemma] = anon_sym_diffEquivLemma,
  [anon_sym_all_DASHtraces] = anon_sym_all_DASHtraces,
  [anon_sym_exists_DASHtrace] = anon_sym_exists_DASHtrace,
  [sym_solved] = sym_solved,
  [sym_mirrored] = sym_mirrored,
  [anon_sym_by] = anon_sym_by,
  [anon_sym_next] = anon_sym_next,
  [anon_sym_qed] = anon_sym_qed,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_sorry] = anon_sym_sorry,
  [anon_sym_simplify] = anon_sym_simplify,
  [anon_sym_solve] = anon_sym_solve,
  [anon_sym_contradiction] = anon_sym_contradiction,
  [anon_sym_induction] = anon_sym_induction,
  [anon_sym_rule_DASHequivalence] = anon_sym_rule_DASHequivalence,
  [anon_sym_backward_DASHsearch] = anon_sym_backward_DASHsearch,
  [anon_sym_ATTACK] = anon_sym_ATTACK,
  [anon_sym_step] = anon_sym_step,
  [anon_sym_u25b6] = anon_sym_u25b6,
  [anon_sym_TILDE_TILDE_GT] = anon_sym_TILDE_TILDE_GT,
  [anon_sym_u2225] = anon_sym_u2225,
  [anon_sym_splitEqs] = anon_sym_splitEqs,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_PERCENT_PLUS] = anon_sym_PERCENT_PLUS,
  [anon_sym_XOR] = anon_sym_XOR,
  [anon_sym_u2295] = anon_sym_u2295,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_pub] = anon_sym_pub,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_fresh] = anon_sym_fresh,
  [anon_sym_msg] = anon_sym_msg,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_node] = anon_sym_node,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_nat] = anon_sym_nat,
  [anon_sym_ANY] = anon_sym_ANY,
  [anon_sym_temporal] = anon_sym_temporal,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_pub_name_token1] = aux_sym_pub_name_token1,
  [anon_sym_TILDE_SQUOTE] = anon_sym_TILDE_SQUOTE,
  [anon_sym_u21d4] = anon_sym_u21d4,
  [anon_sym_EQ_EQ_GT] = anon_sym_EQ_EQ_GT,
  [anon_sym_u21d2] = anon_sym_u21d2,
  [anon_sym_u2228] = anon_sym_u2228,
  [anon_sym_u2227] = anon_sym_u2227,
  [anon_sym_u00ac] = anon_sym_u00ac,
  [anon_sym_last] = anon_sym_last,
  [anon_sym_u228f] = anon_sym_u228f,
  [anon_sym_Ex] = anon_sym_Ex,
  [anon_sym_u2203] = anon_sym_u2203,
  [anon_sym_All] = anon_sym_All,
  [anon_sym_u2200] = anon_sym_u2200,
  [anon_sym_u22a5] = anon_sym_u22a5,
  [anon_sym_F] = anon_sym_F,
  [anon_sym_u22a4] = anon_sym_u22a4,
  [anon_sym_T] = anon_sym_T,
  [aux_sym_hexcolor_token1] = aux_sym_hexcolor_token1,
  [sym_param] = sym_param,
  [sym_export_query] = sym_export_query,
  [sym_natural] = sym_natural,
  [anon_sym_u2080] = anon_sym_u2080,
  [anon_sym_u2081] = anon_sym_u2081,
  [anon_sym_u2082] = anon_sym_u2082,
  [anon_sym_u2083] = anon_sym_u2083,
  [anon_sym_u2084] = anon_sym_u2084,
  [anon_sym_u2085] = anon_sym_u2085,
  [anon_sym_u2086] = anon_sym_u2086,
  [anon_sym_u2087] = anon_sym_u2087,
  [anon_sym_u2088] = anon_sym_u2088,
  [anon_sym_u2089] = anon_sym_u2089,
  [aux_sym_formal_comment_token1] = aux_sym_formal_comment_token1,
  [sym_multi_comment] = sym_multi_comment,
  [sym_single_comment] = sym_single_comment,
  [sym_theory] = sym_theory,
  [sym_commandline] = sym_commandline,
  [sym__search_strategy] = sym__search_strategy,
  [sym__body_item] = sym__body_item,
  [sym_preprocessor] = sym_preprocessor,
  [sym_ifdef] = sym_ifdef,
  [sym_define] = sym_define,
  [sym_include] = sym_include,
  [sym__ifdef_formula] = sym__ifdef_formula,
  [sym_ifdef_nested] = sym_ifdef_nested,
  [sym_ifdef_or] = sym_ifdef_or,
  [sym_ifdef_and] = sym_ifdef_and,
  [sym_ifdef_not] = sym_ifdef_not,
  [sym__signature_spec] = sym__signature_spec,
  [sym_built_ins] = sym_built_ins,
  [sym_built_in] = sym_built_in,
  [sym_functions] = sym_functions,
  [sym__function_sym] = sym__function_sym,
  [sym_function_untyped] = sym_function_untyped,
  [sym_function_attribute] = sym_function_attribute,
  [sym_function_typed] = sym_function_typed,
  [sym_equations] = sym_equations,
  [sym_equation] = sym_equation,
  [sym_predicates] = sym_predicates,
  [sym_predicate] = sym_predicate,
  [sym_predicate_def] = sym_predicate_def,
  [sym_options] = sym_options,
  [sym_option] = sym_option,
  [sym_global_heuristic] = sym_global_heuristic,
  [sym__goal_ranking] = sym__goal_ranking,
  [sym_oracle_goal_ranking] = sym_oracle_goal_ranking,
  [sym_tactic_goal_ranking] = sym_tactic_goal_ranking,
  [sym_tactic] = sym_tactic,
  [sym_presort] = sym_presort,
  [sym_prio] = sym_prio,
  [sym_deprio] = sym_deprio,
  [sym_post_ranking] = sym_post_ranking,
  [sym__function] = sym__function,
  [sym_or_function] = sym_or_function,
  [sym_and_function] = sym_and_function,
  [sym_not_function] = sym_not_function,
  [sym_std_function] = sym_std_function,
  [sym_function_name] = sym_function_name,
  [sym_process] = sym_process,
  [sym__process] = sym__process,
  [sym__elementary_process] = sym__elementary_process,
  [sym__extended_process] = sym__extended_process,
  [sym__stateful_process] = sym__stateful_process,
  [sym_location_process] = sym_location_process,
  [sym_inline_msr_process] = sym_inline_msr_process,
  [sym__nested_process] = sym__nested_process,
  [sym_predefined_process] = sym_predefined_process,
  [sym_binding] = sym_binding,
  [sym_output] = sym_output,
  [sym_input] = sym_input,
  [sym_conditional] = sym_conditional,
  [sym_process_let] = sym_process_let,
  [sym_deterministic_choice] = sym_deterministic_choice,
  [sym_non_deterministic_choice] = sym_non_deterministic_choice,
  [sym_event] = sym_event,
  [sym_replication] = sym_replication,
  [sym_set_state] = sym_set_state,
  [sym_delete_state] = sym_delete_state,
  [sym_read_state] = sym_read_state,
  [sym_set_lock] = sym_set_lock,
  [sym_remove_lock] = sym_remove_lock,
  [sym__condition] = sym__condition,
  [sym_equality_check] = sym_equality_check,
  [sym_lesser_check] = sym_lesser_check,
  [sym_let] = sym_let,
  [sym_export] = sym_export,
  [sym__rule] = sym__rule,
  [sym_rule] = sym_rule,
  [sym_diff_rule] = sym_diff_rule,
  [sym_simple_rule] = sym_simple_rule,
  [sym_premise] = sym_premise,
  [sym_action_fact] = sym_action_fact,
  [sym_conclusion] = sym_conclusion,
  [sym_variants] = sym_variants,
  [sym_modulo] = sym_modulo,
  [sym_rule_attrs] = sym_rule_attrs,
  [sym_rule_attr] = sym_rule_attr,
  [sym_rule_attr_color] = sym_rule_attr_color,
  [sym_rule_role] = sym_rule_role,
  [sym_rule_process] = sym_rule_process,
  [sym_rule_let_block] = sym_rule_let_block,
  [sym_rule_let_term] = sym_rule_let_term,
  [sym_macros] = sym_macros,
  [sym_macro] = sym_macro,
  [sym_embedded_restriction] = sym_embedded_restriction,
  [sym__facts_restrictions] = sym__facts_restrictions,
  [sym__facts] = sym__facts,
  [sym__fact] = sym__fact,
  [sym_fact] = sym_fact,
  [sym_fact_annotes] = sym_fact_annotes,
  [sym_fact_annote] = sym_fact_annote,
  [sym_restriction] = sym_restriction,
  [sym_restriction_attr] = sym_restriction_attr,
  [sym_case_test] = sym_case_test,
  [sym__lemma] = sym__lemma,
  [sym_lemma] = sym_lemma,
  [sym_lemma_attr] = sym_lemma_attr,
  [sym_language] = sym_language,
  [sym_diff_lemma] = sym_diff_lemma,
  [sym_diff_lemma_attrs] = sym_diff_lemma_attrs,
  [sym_diff_lemma_attr] = sym_diff_lemma_attr,
  [sym_accountability_lemma] = sym_accountability_lemma,
  [sym_equiv_lemma] = sym_equiv_lemma,
  [sym_diff_equiv_lemma] = sym_diff_equiv_lemma,
  [sym_trace_quantifier] = sym_trace_quantifier,
  [sym__proof_skeleton] = sym__proof_skeleton,
  [sym_by_method] = sym_by_method,
  [sym_method_skeleton] = sym_method_skeleton,
  [sym_cases] = sym_cases,
  [sym_case] = sym_case,
  [sym__proof_methods] = sym__proof_methods,
  [sym_proof_method] = sym_proof_method,
  [sym_step] = sym_step,
  [sym_goal] = sym_goal,
  [sym_premise_goal] = sym_premise_goal,
  [sym_action_goal] = sym_action_goal,
  [sym_chain_goal] = sym_chain_goal,
  [sym_disjunction_split_goal] = sym_disjunction_split_goal,
  [sym_eq_split_goal] = sym_eq_split_goal,
  [sym__term] = sym__term,
  [sym_tuple_term] = sym_tuple_term,
  [sym_mset_term] = sym_mset_term,
  [sym_nat_term] = sym_nat_term,
  [sym_xor_term] = sym_xor_term,
  [sym_mul_term] = sym_mul_term,
  [sym_exp_term] = sym_exp_term,
  [sym_nested_term] = sym_nested_term,
  [sym_nullary_fun] = sym_nullary_fun,
  [sym_binary_app] = sym_binary_app,
  [sym_nary_app] = sym_nary_app,
  [sym_arguments] = sym_arguments,
  [sym__literal] = sym__literal,
  [sym__non_temporal_var] = sym__non_temporal_var,
  [sym_pub_var] = sym_pub_var,
  [sym_fresh_var] = sym_fresh_var,
  [sym_msg_var_or_nullary_fun] = sym_msg_var_or_nullary_fun,
  [sym_temporal_var] = sym_temporal_var,
  [sym_nat_var] = sym_nat_var,
  [sym_comp_var] = sym_comp_var,
  [sym__custom_type_var] = sym__custom_type_var,
  [sym_custom_var] = sym_custom_var,
  [sym_any_var] = sym_any_var,
  [sym_temporal_var_optional_prefix] = sym_temporal_var,
  [sym_pub_name] = sym_pub_name,
  [sym_fresh_name] = sym_fresh_name,
  [sym__formula] = sym__formula,
  [sym_iff] = sym_iff,
  [sym_imp] = sym_imp,
  [sym_disjunction] = sym_disjunction,
  [sym_conjunction] = sym_conjunction,
  [sym_negation] = sym_negation,
  [sym_nested_formula] = sym_nested_formula,
  [sym__temporal_variable_operation] = sym__temporal_variable_operation,
  [sym_temp_var_induction] = sym_temp_var_induction,
  [sym_temp_var_order] = sym_temp_var_order,
  [sym_temp_var_eq] = sym_temp_var_eq,
  [sym_action_constraint] = sym_action_constraint,
  [sym_term_eq] = sym_term_eq,
  [sym_subterm_rel] = sym_subterm_rel,
  [sym_quantified_formula] = sym_quantified_formula,
  [sym_atom] = sym_atom,
  [sym__lvar] = sym__lvar,
  [sym_predicate_ref] = sym_predicate_ref,
  [sym_pre_defined] = sym_pre_defined,
  [sym_hexcolor] = sym_hexcolor,
  [sym_natural_subscript] = sym_natural_subscript,
  [sym_formal_comment] = sym_formal_comment,
  [aux_sym_theory_repeat1] = aux_sym_theory_repeat1,
  [aux_sym_theory_repeat2] = aux_sym_theory_repeat2,
  [aux_sym_commandline_repeat1] = aux_sym_commandline_repeat1,
  [aux_sym_built_ins_repeat1] = aux_sym_built_ins_repeat1,
  [aux_sym_functions_repeat1] = aux_sym_functions_repeat1,
  [aux_sym_function_untyped_repeat1] = aux_sym_function_untyped_repeat1,
  [aux_sym_equations_repeat1] = aux_sym_equations_repeat1,
  [aux_sym_predicates_repeat1] = aux_sym_predicates_repeat1,
  [aux_sym_options_repeat1] = aux_sym_options_repeat1,
  [aux_sym_global_heuristic_repeat1] = aux_sym_global_heuristic_repeat1,
  [aux_sym_tactic_repeat1] = aux_sym_tactic_repeat1,
  [aux_sym_tactic_repeat2] = aux_sym_tactic_repeat2,
  [aux_sym_prio_repeat1] = aux_sym_prio_repeat1,
  [aux_sym_std_function_repeat1] = aux_sym_std_function_repeat1,
  [aux_sym_process_let_repeat1] = aux_sym_process_let_repeat1,
  [aux_sym_variants_repeat1] = aux_sym_variants_repeat1,
  [aux_sym_rule_attrs_repeat1] = aux_sym_rule_attrs_repeat1,
  [aux_sym_rule_let_block_repeat1] = aux_sym_rule_let_block_repeat1,
  [aux_sym_macros_repeat1] = aux_sym_macros_repeat1,
  [aux_sym_macro_repeat1] = aux_sym_macro_repeat1,
  [aux_sym__facts_restrictions_repeat1] = aux_sym__facts_restrictions_repeat1,
  [aux_sym__facts_repeat1] = aux_sym__facts_repeat1,
  [aux_sym_fact_annotes_repeat1] = aux_sym_fact_annotes_repeat1,
  [aux_sym_lemma_attr_repeat1] = aux_sym_lemma_attr_repeat1,
  [aux_sym_diff_lemma_attrs_repeat1] = aux_sym_diff_lemma_attrs_repeat1,
  [aux_sym_accountability_lemma_repeat1] = aux_sym_accountability_lemma_repeat1,
  [aux_sym_cases_repeat1] = aux_sym_cases_repeat1,
  [aux_sym__proof_methods_repeat1] = aux_sym__proof_methods_repeat1,
  [aux_sym_disjunction_split_goal_repeat1] = aux_sym_disjunction_split_goal_repeat1,
  [aux_sym_tuple_term_repeat1] = aux_sym_tuple_term_repeat1,
  [aux_sym_binary_app_repeat1] = aux_sym_binary_app_repeat1,
  [aux_sym_quantified_formula_repeat1] = aux_sym_quantified_formula_repeat1,
  [aux_sym_natural_subscript_repeat1] = aux_sym_natural_subscript_repeat1,
  [alias_sym_path] = alias_sym_path,
  [alias_sym_persistent_fact] = alias_sym_persistent_fact,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_ident] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_theory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_configuration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_begin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_theory_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DASH_DASHauto_DASHsources] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASHstop_DASHon_DASHtrace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEQDFS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bfs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dfs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_seqdfs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDifdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDelse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDendif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDdefine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUNDinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_builtins] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_diffie_DASHhellman] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hashing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_symmetric_DASHencryption] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asymmetric_DASHencryption] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bilinear_DASHpairing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_multiset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_natural_DASHnumbers] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_revealing_DASHsigning] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_locations_DASHreport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reliable_DASHchannel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dest_DASHpairing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dest_DASHsigning] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dest_DASHsymmetric_DASHencryption] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dest_DASHasymmetric_DASHencryption] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_functions] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_destructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_equations] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_convergent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_predicate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_predicates] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_options] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_translation_DASHstate_DASHoptimisation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_translation_DASHprogress] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_translation_DASHasynchronous_DASHchannels] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_translation_DASHcompress_DASHevents] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_translation_DASHallow_DASHpattern_DASHlookups] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_heuristic] = {
    .visible = true,
    .named = false,
  },
  [sym_standard_goal_ranking] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_O] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_o] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tactic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_presort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prio] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deprio] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smallest] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_id] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_regex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_isFactName] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_isInFactTerms] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dhreNoise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defaultNoise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reasonableNoncesNoise] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonAbsurdGoal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_process] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_out] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_insert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lookup] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lock] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unlock] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN_LT_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_left] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_right] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rule] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_variants] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_modulo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_E] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AC] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_no_derivcheck] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_issapicrule] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_color_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_colour_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_role] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macros] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__restrict] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_no_precomp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_restriction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_axiom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_test] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lemma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sources] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_reuse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_use_induction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_output_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hide_lemma_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_heuristic_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_spthy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_spthytyped] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_msr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_proverif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_deepsec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_diffLemma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_account] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_accounts] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_equivLemma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_diffEquivLemma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_all_DASHtraces] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exists_DASHtrace] = {
    .visible = true,
    .named = false,
  },
  [sym_solved] = {
    .visible = true,
    .named = true,
  },
  [sym_mirrored] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_by] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_next] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_qed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sorry] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_simplify] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_solve] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contradiction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_induction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rule_DASHequivalence] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_backward_DASHsearch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATTACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_step] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u25b6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_TILDE_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2225] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_splitEqs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_XOR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2295] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fresh] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_msg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_node] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ANY] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_temporal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_pub_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_TILDE_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2228] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2227] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00ac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_last] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u228f] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Ex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2203] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_All] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_F] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_T] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_hexcolor_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_param] = {
    .visible = true,
    .named = true,
  },
  [sym_export_query] = {
    .visible = true,
    .named = true,
  },
  [sym_natural] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u2080] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2081] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2082] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2083] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2084] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2085] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2086] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2087] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2088] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2089] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_formal_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_multi_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_single_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_theory] = {
    .visible = true,
    .named = true,
  },
  [sym_commandline] = {
    .visible = true,
    .named = true,
  },
  [sym__search_strategy] = {
    .visible = false,
    .named = true,
  },
  [sym__body_item] = {
    .visible = false,
    .named = true,
  },
  [sym_preprocessor] = {
    .visible = true,
    .named = true,
  },
  [sym_ifdef] = {
    .visible = true,
    .named = true,
  },
  [sym_define] = {
    .visible = true,
    .named = true,
  },
  [sym_include] = {
    .visible = true,
    .named = true,
  },
  [sym__ifdef_formula] = {
    .visible = false,
    .named = true,
  },
  [sym_ifdef_nested] = {
    .visible = true,
    .named = true,
  },
  [sym_ifdef_or] = {
    .visible = true,
    .named = true,
  },
  [sym_ifdef_and] = {
    .visible = true,
    .named = true,
  },
  [sym_ifdef_not] = {
    .visible = true,
    .named = true,
  },
  [sym__signature_spec] = {
    .visible = false,
    .named = true,
  },
  [sym_built_ins] = {
    .visible = true,
    .named = true,
  },
  [sym_built_in] = {
    .visible = true,
    .named = true,
  },
  [sym_functions] = {
    .visible = true,
    .named = true,
  },
  [sym__function_sym] = {
    .visible = false,
    .named = true,
  },
  [sym_function_untyped] = {
    .visible = true,
    .named = true,
  },
  [sym_function_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_function_typed] = {
    .visible = true,
    .named = true,
  },
  [sym_equations] = {
    .visible = true,
    .named = true,
  },
  [sym_equation] = {
    .visible = true,
    .named = true,
  },
  [sym_predicates] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate_def] = {
    .visible = true,
    .named = false,
  },
  [sym_options] = {
    .visible = true,
    .named = true,
  },
  [sym_option] = {
    .visible = true,
    .named = true,
  },
  [sym_global_heuristic] = {
    .visible = true,
    .named = true,
  },
  [sym__goal_ranking] = {
    .visible = false,
    .named = true,
  },
  [sym_oracle_goal_ranking] = {
    .visible = true,
    .named = true,
  },
  [sym_tactic_goal_ranking] = {
    .visible = true,
    .named = true,
  },
  [sym_tactic] = {
    .visible = true,
    .named = true,
  },
  [sym_presort] = {
    .visible = true,
    .named = true,
  },
  [sym_prio] = {
    .visible = true,
    .named = true,
  },
  [sym_deprio] = {
    .visible = true,
    .named = true,
  },
  [sym_post_ranking] = {
    .visible = true,
    .named = true,
  },
  [sym__function] = {
    .visible = false,
    .named = true,
  },
  [sym_or_function] = {
    .visible = true,
    .named = true,
  },
  [sym_and_function] = {
    .visible = true,
    .named = true,
  },
  [sym_not_function] = {
    .visible = true,
    .named = true,
  },
  [sym_std_function] = {
    .visible = true,
    .named = true,
  },
  [sym_function_name] = {
    .visible = true,
    .named = true,
  },
  [sym_process] = {
    .visible = true,
    .named = true,
  },
  [sym__process] = {
    .visible = false,
    .named = true,
  },
  [sym__elementary_process] = {
    .visible = false,
    .named = true,
  },
  [sym__extended_process] = {
    .visible = false,
    .named = true,
  },
  [sym__stateful_process] = {
    .visible = false,
    .named = true,
  },
  [sym_location_process] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_msr_process] = {
    .visible = true,
    .named = true,
  },
  [sym__nested_process] = {
    .visible = false,
    .named = true,
  },
  [sym_predefined_process] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_output] = {
    .visible = true,
    .named = true,
  },
  [sym_input] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional] = {
    .visible = true,
    .named = true,
  },
  [sym_process_let] = {
    .visible = true,
    .named = true,
  },
  [sym_deterministic_choice] = {
    .visible = true,
    .named = true,
  },
  [sym_non_deterministic_choice] = {
    .visible = true,
    .named = true,
  },
  [sym_event] = {
    .visible = true,
    .named = true,
  },
  [sym_replication] = {
    .visible = true,
    .named = true,
  },
  [sym_set_state] = {
    .visible = true,
    .named = true,
  },
  [sym_delete_state] = {
    .visible = true,
    .named = true,
  },
  [sym_read_state] = {
    .visible = true,
    .named = true,
  },
  [sym_set_lock] = {
    .visible = true,
    .named = true,
  },
  [sym_remove_lock] = {
    .visible = true,
    .named = true,
  },
  [sym__condition] = {
    .visible = false,
    .named = true,
  },
  [sym_equality_check] = {
    .visible = true,
    .named = true,
  },
  [sym_lesser_check] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_export] = {
    .visible = true,
    .named = true,
  },
  [sym__rule] = {
    .visible = false,
    .named = true,
  },
  [sym_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_diff_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_premise] = {
    .visible = true,
    .named = true,
  },
  [sym_action_fact] = {
    .visible = true,
    .named = true,
  },
  [sym_conclusion] = {
    .visible = true,
    .named = true,
  },
  [sym_variants] = {
    .visible = true,
    .named = true,
  },
  [sym_modulo] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_attr] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_attr_color] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_role] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_process] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_let_block] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_let_term] = {
    .visible = true,
    .named = true,
  },
  [sym_macros] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_embedded_restriction] = {
    .visible = true,
    .named = true,
  },
  [sym__facts_restrictions] = {
    .visible = false,
    .named = true,
  },
  [sym__facts] = {
    .visible = false,
    .named = true,
  },
  [sym__fact] = {
    .visible = false,
    .named = true,
  },
  [sym_fact] = {
    .visible = true,
    .named = true,
  },
  [sym_fact_annotes] = {
    .visible = true,
    .named = true,
  },
  [sym_fact_annote] = {
    .visible = true,
    .named = true,
  },
  [sym_restriction] = {
    .visible = true,
    .named = true,
  },
  [sym_restriction_attr] = {
    .visible = true,
    .named = true,
  },
  [sym_case_test] = {
    .visible = true,
    .named = true,
  },
  [sym__lemma] = {
    .visible = false,
    .named = true,
  },
  [sym_lemma] = {
    .visible = true,
    .named = true,
  },
  [sym_lemma_attr] = {
    .visible = true,
    .named = true,
  },
  [sym_language] = {
    .visible = true,
    .named = true,
  },
  [sym_diff_lemma] = {
    .visible = true,
    .named = true,
  },
  [sym_diff_lemma_attrs] = {
    .visible = true,
    .named = true,
  },
  [sym_diff_lemma_attr] = {
    .visible = true,
    .named = true,
  },
  [sym_accountability_lemma] = {
    .visible = true,
    .named = true,
  },
  [sym_equiv_lemma] = {
    .visible = true,
    .named = true,
  },
  [sym_diff_equiv_lemma] = {
    .visible = true,
    .named = true,
  },
  [sym_trace_quantifier] = {
    .visible = true,
    .named = true,
  },
  [sym__proof_skeleton] = {
    .visible = false,
    .named = true,
  },
  [sym_by_method] = {
    .visible = true,
    .named = true,
  },
  [sym_method_skeleton] = {
    .visible = true,
    .named = true,
  },
  [sym_cases] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym__proof_methods] = {
    .visible = false,
    .named = true,
  },
  [sym_proof_method] = {
    .visible = true,
    .named = true,
  },
  [sym_step] = {
    .visible = true,
    .named = true,
  },
  [sym_goal] = {
    .visible = true,
    .named = true,
  },
  [sym_premise_goal] = {
    .visible = true,
    .named = true,
  },
  [sym_action_goal] = {
    .visible = true,
    .named = true,
  },
  [sym_chain_goal] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction_split_goal] = {
    .visible = true,
    .named = true,
  },
  [sym_eq_split_goal] = {
    .visible = true,
    .named = true,
  },
  [sym__term] = {
    .visible = false,
    .named = true,
  },
  [sym_tuple_term] = {
    .visible = true,
    .named = true,
  },
  [sym_mset_term] = {
    .visible = true,
    .named = true,
  },
  [sym_nat_term] = {
    .visible = true,
    .named = true,
  },
  [sym_xor_term] = {
    .visible = true,
    .named = true,
  },
  [sym_mul_term] = {
    .visible = true,
    .named = true,
  },
  [sym_exp_term] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_term] = {
    .visible = true,
    .named = true,
  },
  [sym_nullary_fun] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_app] = {
    .visible = true,
    .named = true,
  },
  [sym_nary_app] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym__non_temporal_var] = {
    .visible = false,
    .named = true,
  },
  [sym_pub_var] = {
    .visible = true,
    .named = true,
  },
  [sym_fresh_var] = {
    .visible = true,
    .named = true,
  },
  [sym_msg_var_or_nullary_fun] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_var] = {
    .visible = true,
    .named = true,
  },
  [sym_nat_var] = {
    .visible = true,
    .named = true,
  },
  [sym_comp_var] = {
    .visible = true,
    .named = true,
  },
  [sym__custom_type_var] = {
    .visible = false,
    .named = true,
  },
  [sym_custom_var] = {
    .visible = true,
    .named = true,
  },
  [sym_any_var] = {
    .visible = true,
    .named = true,
  },
  [sym_temporal_var_optional_prefix] = {
    .visible = true,
    .named = true,
  },
  [sym_pub_name] = {
    .visible = true,
    .named = true,
  },
  [sym_fresh_name] = {
    .visible = true,
    .named = true,
  },
  [sym__formula] = {
    .visible = false,
    .named = true,
  },
  [sym_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_imp] = {
    .visible = true,
    .named = true,
  },
  [sym_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_formula] = {
    .visible = true,
    .named = true,
  },
  [sym__temporal_variable_operation] = {
    .visible = false,
    .named = true,
  },
  [sym_temp_var_induction] = {
    .visible = true,
    .named = true,
  },
  [sym_temp_var_order] = {
    .visible = true,
    .named = true,
  },
  [sym_temp_var_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_action_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_term_eq] = {
    .visible = true,
    .named = true,
  },
  [sym_subterm_rel] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_formula] = {
    .visible = true,
    .named = true,
  },
  [sym_atom] = {
    .visible = true,
    .named = true,
  },
  [sym__lvar] = {
    .visible = false,
    .named = true,
  },
  [sym_predicate_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_pre_defined] = {
    .visible = true,
    .named = true,
  },
  [sym_hexcolor] = {
    .visible = true,
    .named = true,
  },
  [sym_natural_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_comment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_theory_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_theory_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_commandline_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_built_ins_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_functions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_untyped_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_equations_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_predicates_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_options_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_heuristic_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tactic_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tactic_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_prio_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_std_function_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_process_let_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variants_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rule_attrs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rule_let_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_macros_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_macro_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__facts_restrictions_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__facts_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fact_annotes_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lemma_attr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_diff_lemma_attrs_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_accountability_lemma_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cases_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__proof_methods_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_disjunction_split_goal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_term_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_binary_app_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quantified_formula_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_natural_subscript_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_path] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_persistent_fact] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_arity = 2,
  field_base = 3,
  field_case_identifier = 4,
  field_comment_identifier = 5,
  field_condition = 6,
  field_else = 7,
  field_exponent = 8,
  field_export_identifier = 9,
  field_fact = 10,
  field_fact_identifier = 11,
  field_first = 12,
  field_formula = 13,
  field_from = 14,
  field_function_identifier = 15,
  field_function_type = 16,
  field_goal_ranking = 17,
  field_in = 18,
  field_left = 19,
  field_lemma_identifier = 20,
  field_let_identifier = 21,
  field_location_identifier = 22,
  field_macro_identifier = 23,
  field_predicate_identifier = 24,
  field_proof_skeleton = 25,
  field_restriction_identifier = 26,
  field_right = 27,
  field_role_identifier = 28,
  field_rule_identifier = 29,
  field_second = 30,
  field_term = 31,
  field_test_identifier = 32,
  field_then = 33,
  field_theory_name = 34,
  field_to = 35,
  field_variable = 36,
  field_variable_identifier = 37,
  field_variable_type = 38,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_arity] = "arity",
  [field_base] = "base",
  [field_case_identifier] = "case_identifier",
  [field_comment_identifier] = "comment_identifier",
  [field_condition] = "condition",
  [field_else] = "else",
  [field_exponent] = "exponent",
  [field_export_identifier] = "export_identifier",
  [field_fact] = "fact",
  [field_fact_identifier] = "fact_identifier",
  [field_first] = "first",
  [field_formula] = "formula",
  [field_from] = "from",
  [field_function_identifier] = "function_identifier",
  [field_function_type] = "function_type",
  [field_goal_ranking] = "goal_ranking",
  [field_in] = "in",
  [field_left] = "left",
  [field_lemma_identifier] = "lemma_identifier",
  [field_let_identifier] = "let_identifier",
  [field_location_identifier] = "location_identifier",
  [field_macro_identifier] = "macro_identifier",
  [field_predicate_identifier] = "predicate_identifier",
  [field_proof_skeleton] = "proof_skeleton",
  [field_restriction_identifier] = "restriction_identifier",
  [field_right] = "right",
  [field_role_identifier] = "role_identifier",
  [field_rule_identifier] = "rule_identifier",
  [field_second] = "second",
  [field_term] = "term",
  [field_test_identifier] = "test_identifier",
  [field_then] = "then",
  [field_theory_name] = "theory_name",
  [field_to] = "to",
  [field_variable] = "variable",
  [field_variable_identifier] = "variable_identifier",
  [field_variable_type] = "variable_type",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 1},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 1},
  [9] = {.index = 7, .length = 1},
  [10] = {.index = 8, .length = 1},
  [11] = {.index = 9, .length = 1},
  [12] = {.index = 10, .length = 2},
  [13] = {.index = 12, .length = 2},
  [14] = {.index = 14, .length = 1},
  [15] = {.index = 15, .length = 2},
  [16] = {.index = 17, .length = 1},
  [17] = {.index = 18, .length = 2},
  [18] = {.index = 20, .length = 2},
  [19] = {.index = 22, .length = 1},
  [20] = {.index = 23, .length = 1},
  [22] = {.index = 24, .length = 1},
  [23] = {.index = 25, .length = 2},
  [24] = {.index = 27, .length = 2},
  [25] = {.index = 29, .length = 2},
  [26] = {.index = 31, .length = 1},
  [27] = {.index = 32, .length = 1},
  [28] = {.index = 33, .length = 2},
  [29] = {.index = 35, .length = 2},
  [30] = {.index = 37, .length = 2},
  [31] = {.index = 39, .length = 1},
  [32] = {.index = 40, .length = 2},
  [33] = {.index = 42, .length = 2},
  [34] = {.index = 44, .length = 1},
  [35] = {.index = 45, .length = 2},
  [36] = {.index = 47, .length = 1},
  [37] = {.index = 48, .length = 2},
  [38] = {.index = 50, .length = 3},
  [39] = {.index = 53, .length = 1},
  [40] = {.index = 54, .length = 1},
  [41] = {.index = 55, .length = 2},
  [42] = {.index = 57, .length = 2},
  [43] = {.index = 59, .length = 2},
  [44] = {.index = 61, .length = 1},
  [45] = {.index = 62, .length = 2},
  [46] = {.index = 64, .length = 2},
  [47] = {.index = 66, .length = 2},
  [48] = {.index = 68, .length = 2},
  [49] = {.index = 70, .length = 1},
  [50] = {.index = 71, .length = 2},
  [51] = {.index = 73, .length = 4},
  [52] = {.index = 77, .length = 1},
  [53] = {.index = 78, .length = 2},
  [54] = {.index = 80, .length = 2},
  [55] = {.index = 82, .length = 3},
  [56] = {.index = 85, .length = 2},
  [57] = {.index = 87, .length = 2},
  [58] = {.index = 89, .length = 2},
  [59] = {.index = 91, .length = 2},
  [60] = {.index = 93, .length = 3},
  [61] = {.index = 96, .length = 2},
  [62] = {.index = 98, .length = 3},
  [63] = {.index = 101, .length = 1},
  [64] = {.index = 102, .length = 2},
  [65] = {.index = 104, .length = 3},
  [66] = {.index = 107, .length = 2},
  [67] = {.index = 109, .length = 3},
  [68] = {.index = 112, .length = 2},
  [69] = {.index = 114, .length = 2},
  [70] = {.index = 116, .length = 2},
  [71] = {.index = 118, .length = 3},
  [72] = {.index = 121, .length = 3},
  [73] = {.index = 124, .length = 3},
  [74] = {.index = 127, .length = 2},
  [75] = {.index = 129, .length = 4},
  [76] = {.index = 133, .length = 4},
  [77] = {.index = 137, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_theory_name, 1},
  [1] =
    {field_function_identifier, 0},
  [2] =
    {field_variable_identifier, 0},
  [3] =
    {field_comment_identifier, 0},
  [4] =
    {field_goal_ranking, 2},
  [5] =
    {field_variable_identifier, 1},
  [6] =
    {field_lemma_identifier, 1},
  [7] =
    {field_term, 1},
  [8] =
    {field_argument, 0},
  [9] =
    {field_let_identifier, 1},
  [10] =
    {field_left, 0},
    {field_right, 2},
  [12] =
    {field_base, 0},
    {field_exponent, 2},
  [14] =
    {field_variable_type, 2},
  [15] =
    {field_lemma_identifier, 1},
    {field_proof_skeleton, 3},
  [17] =
    {field_lemma_identifier, 2},
  [18] =
    {field_first, 2},
    {field_second, 3},
  [20] =
    {field_arity, 2},
    {field_function_identifier, 0},
  [22] =
    {field_predicate_identifier, 0},
  [23] =
    {field_formula, 2},
  [24] =
    {field_formula, 1},
  [25] =
    {field_term, 1},
    {field_term, 2, .inherited = true},
  [27] =
    {field_term, 0, .inherited = true},
    {field_term, 1, .inherited = true},
  [29] =
    {field_argument, 0},
    {field_argument, 1, .inherited = true},
  [31] =
    {field_goal_ranking, 1},
  [32] =
    {field_proof_skeleton, 1},
  [33] =
    {field_lemma_identifier, 1},
    {field_proof_skeleton, 4},
  [35] =
    {field_lemma_identifier, 2},
    {field_proof_skeleton, 4},
  [37] =
    {field_left, 2},
    {field_right, 4},
  [39] =
    {field_fact_identifier, 0},
  [40] =
    {field_condition, 1},
    {field_then, 3},
  [42] =
    {field_fact, 0},
    {field_variable, 2},
  [44] =
    {field_in, 3},
  [45] =
    {field_from, 1},
    {field_to, 3},
  [47] =
    {field_argument, 1},
  [48] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [50] =
    {field_argument, 2},
    {field_argument, 4},
    {field_function_identifier, 0},
  [53] =
    {field_export_identifier, 1},
  [54] =
    {field_rule_identifier, 1},
  [55] =
    {field_formula, 4},
    {field_restriction_identifier, 1},
  [57] =
    {field_formula, 4},
    {field_test_identifier, 1},
  [59] =
    {field_formula, 4},
    {field_lemma_identifier, 1},
  [61] =
    {field_test_identifier, 1},
  [62] =
    {field_test_identifier, 0, .inherited = true},
    {field_test_identifier, 1, .inherited = true},
  [64] =
    {field_case_identifier, 1},
    {field_proof_skeleton, 2},
  [66] =
    {field_lemma_identifier, 2},
    {field_proof_skeleton, 5},
  [68] =
    {field_function_identifier, 0},
    {field_function_type, 4},
  [70] =
    {field_location_identifier, 4},
  [71] =
    {field_formula, 3},
    {field_variable, 1},
  [73] =
    {field_argument, 2},
    {field_argument, 3, .inherited = true},
    {field_argument, 5},
    {field_function_identifier, 0},
  [77] =
    {field_rule_identifier, 2},
  [78] =
    {field_macro_identifier, 0},
    {field_term, 4},
  [80] =
    {field_formula, 5},
    {field_restriction_identifier, 1},
  [82] =
    {field_formula, 4},
    {field_lemma_identifier, 1},
    {field_proof_skeleton, 6},
  [85] =
    {field_formula, 5},
    {field_lemma_identifier, 1},
  [87] =
    {field_formula, 5},
    {field_lemma_identifier, 2},
  [89] =
    {field_formula, 0},
    {field_formula, 1, .inherited = true},
  [91] =
    {field_function_identifier, 0},
    {field_function_type, 5},
  [93] =
    {field_condition, 1},
    {field_else, 5},
    {field_then, 3},
  [96] =
    {field_else, 5},
    {field_in, 3},
  [98] =
    {field_from, 1},
    {field_in, 5},
    {field_to, 3},
  [101] =
    {field_role_identifier, 3},
  [102] =
    {field_macro_identifier, 0},
    {field_term, 5},
  [104] =
    {field_formula, 5},
    {field_lemma_identifier, 1},
    {field_proof_skeleton, 7},
  [107] =
    {field_formula, 6},
    {field_lemma_identifier, 1},
  [109] =
    {field_formula, 5},
    {field_lemma_identifier, 2},
    {field_proof_skeleton, 7},
  [112] =
    {field_formula, 6},
    {field_lemma_identifier, 2},
  [114] =
    {field_formula, 0, .inherited = true},
    {field_formula, 1, .inherited = true},
  [116] =
    {field_macro_identifier, 0},
    {field_term, 6},
  [118] =
    {field_formula, 7},
    {field_lemma_identifier, 1},
    {field_test_identifier, 3},
  [121] =
    {field_formula, 6},
    {field_lemma_identifier, 1},
    {field_proof_skeleton, 8},
  [124] =
    {field_formula, 6},
    {field_lemma_identifier, 2},
    {field_proof_skeleton, 8},
  [127] =
    {field_formula, 7},
    {field_lemma_identifier, 2},
  [129] =
    {field_else, 7},
    {field_from, 1},
    {field_in, 5},
    {field_to, 3},
  [133] =
    {field_formula, 8},
    {field_lemma_identifier, 1},
    {field_test_identifier, 3},
    {field_test_identifier, 4, .inherited = true},
  [137] =
    {field_formula, 7},
    {field_lemma_identifier, 2},
    {field_proof_skeleton, 9},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [8] = {
    [2] = alias_sym_path,
  },
  [21] = {
    [1] = alias_sym_persistent_fact,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_fact, 2,
    sym_fact,
    alias_sym_persistent_fact,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 5,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 8,
  [23] = 23,
  [24] = 7,
  [25] = 25,
  [26] = 11,
  [27] = 13,
  [28] = 15,
  [29] = 19,
  [30] = 30,
  [31] = 31,
  [32] = 20,
  [33] = 6,
  [34] = 23,
  [35] = 30,
  [36] = 31,
  [37] = 37,
  [38] = 37,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 42,
  [44] = 4,
  [45] = 45,
  [46] = 9,
  [47] = 47,
  [48] = 21,
  [49] = 49,
  [50] = 14,
  [51] = 25,
  [52] = 41,
  [53] = 12,
  [54] = 40,
  [55] = 39,
  [56] = 17,
  [57] = 16,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 62,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 69,
  [74] = 68,
  [75] = 69,
  [76] = 70,
  [77] = 67,
  [78] = 66,
  [79] = 79,
  [80] = 65,
  [81] = 62,
  [82] = 82,
  [83] = 65,
  [84] = 66,
  [85] = 67,
  [86] = 86,
  [87] = 68,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 115,
  [121] = 117,
  [122] = 116,
  [123] = 119,
  [124] = 118,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 131,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 126,
  [144] = 133,
  [145] = 132,
  [146] = 135,
  [147] = 138,
  [148] = 136,
  [149] = 140,
  [150] = 137,
  [151] = 151,
  [152] = 139,
  [153] = 153,
  [154] = 154,
  [155] = 154,
  [156] = 153,
  [157] = 151,
  [158] = 130,
  [159] = 129,
  [160] = 128,
  [161] = 142,
  [162] = 127,
  [163] = 125,
  [164] = 141,
  [165] = 114,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 174,
  [184] = 173,
  [185] = 113,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 175,
  [190] = 190,
  [191] = 166,
  [192] = 192,
  [193] = 181,
  [194] = 187,
  [195] = 186,
  [196] = 192,
  [197] = 190,
  [198] = 188,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 115,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 253,
  [255] = 255,
  [256] = 256,
  [257] = 253,
  [258] = 255,
  [259] = 118,
  [260] = 260,
  [261] = 261,
  [262] = 253,
  [263] = 255,
  [264] = 264,
  [265] = 119,
  [266] = 116,
  [267] = 117,
  [268] = 256,
  [269] = 256,
  [270] = 253,
  [271] = 255,
  [272] = 130,
  [273] = 273,
  [274] = 129,
  [275] = 128,
  [276] = 127,
  [277] = 141,
  [278] = 125,
  [279] = 142,
  [280] = 280,
  [281] = 281,
  [282] = 131,
  [283] = 133,
  [284] = 153,
  [285] = 137,
  [286] = 286,
  [287] = 136,
  [288] = 139,
  [289] = 151,
  [290] = 290,
  [291] = 138,
  [292] = 292,
  [293] = 154,
  [294] = 126,
  [295] = 295,
  [296] = 140,
  [297] = 132,
  [298] = 135,
  [299] = 280,
  [300] = 300,
  [301] = 301,
  [302] = 114,
  [303] = 235,
  [304] = 166,
  [305] = 233,
  [306] = 181,
  [307] = 175,
  [308] = 186,
  [309] = 113,
  [310] = 240,
  [311] = 237,
  [312] = 192,
  [313] = 187,
  [314] = 188,
  [315] = 190,
  [316] = 173,
  [317] = 236,
  [318] = 318,
  [319] = 174,
  [320] = 318,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 364,
  [371] = 365,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 368,
  [376] = 376,
  [377] = 377,
  [378] = 364,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 372,
  [384] = 368,
  [385] = 385,
  [386] = 386,
  [387] = 373,
  [388] = 374,
  [389] = 366,
  [390] = 367,
  [391] = 391,
  [392] = 392,
  [393] = 382,
  [394] = 385,
  [395] = 385,
  [396] = 396,
  [397] = 364,
  [398] = 391,
  [399] = 399,
  [400] = 365,
  [401] = 401,
  [402] = 372,
  [403] = 377,
  [404] = 373,
  [405] = 382,
  [406] = 362,
  [407] = 382,
  [408] = 373,
  [409] = 372,
  [410] = 365,
  [411] = 385,
  [412] = 374,
  [413] = 366,
  [414] = 414,
  [415] = 367,
  [416] = 368,
  [417] = 366,
  [418] = 374,
  [419] = 367,
  [420] = 361,
  [421] = 421,
  [422] = 421,
  [423] = 368,
  [424] = 369,
  [425] = 425,
  [426] = 374,
  [427] = 427,
  [428] = 367,
  [429] = 366,
  [430] = 386,
  [431] = 431,
  [432] = 374,
  [433] = 385,
  [434] = 401,
  [435] = 399,
  [436] = 364,
  [437] = 382,
  [438] = 368,
  [439] = 373,
  [440] = 372,
  [441] = 365,
  [442] = 442,
  [443] = 364,
  [444] = 427,
  [445] = 382,
  [446] = 446,
  [447] = 385,
  [448] = 373,
  [449] = 372,
  [450] = 365,
  [451] = 425,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 249,
  [462] = 250,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 248,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 245,
  [473] = 473,
  [474] = 251,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 243,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 322,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 301,
  [506] = 506,
  [507] = 507,
  [508] = 234,
  [509] = 509,
  [510] = 510,
  [511] = 321,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 341,
  [517] = 325,
  [518] = 324,
  [519] = 519,
  [520] = 343,
  [521] = 346,
  [522] = 347,
  [523] = 523,
  [524] = 524,
  [525] = 349,
  [526] = 526,
  [527] = 350,
  [528] = 351,
  [529] = 332,
  [530] = 252,
  [531] = 531,
  [532] = 358,
  [533] = 533,
  [534] = 323,
  [535] = 354,
  [536] = 344,
  [537] = 537,
  [538] = 247,
  [539] = 329,
  [540] = 328,
  [541] = 327,
  [542] = 340,
  [543] = 348,
  [544] = 544,
  [545] = 545,
  [546] = 353,
  [547] = 547,
  [548] = 339,
  [549] = 355,
  [550] = 550,
  [551] = 359,
  [552] = 356,
  [553] = 326,
  [554] = 335,
  [555] = 342,
  [556] = 336,
  [557] = 334,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 333,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 104,
  [589] = 112,
  [590] = 104,
  [591] = 104,
  [592] = 112,
  [593] = 593,
  [594] = 111,
  [595] = 595,
  [596] = 596,
  [597] = 112,
  [598] = 598,
  [599] = 598,
  [600] = 115,
  [601] = 130,
  [602] = 142,
  [603] = 117,
  [604] = 116,
  [605] = 119,
  [606] = 118,
  [607] = 607,
  [608] = 608,
  [609] = 607,
  [610] = 608,
  [611] = 151,
  [612] = 129,
  [613] = 128,
  [614] = 608,
  [615] = 608,
  [616] = 127,
  [617] = 608,
  [618] = 125,
  [619] = 141,
  [620] = 135,
  [621] = 136,
  [622] = 137,
  [623] = 139,
  [624] = 141,
  [625] = 153,
  [626] = 128,
  [627] = 129,
  [628] = 138,
  [629] = 140,
  [630] = 131,
  [631] = 130,
  [632] = 127,
  [633] = 151,
  [634] = 125,
  [635] = 142,
  [636] = 154,
  [637] = 133,
  [638] = 139,
  [639] = 137,
  [640] = 126,
  [641] = 132,
  [642] = 135,
  [643] = 136,
  [644] = 644,
  [645] = 645,
  [646] = 175,
  [647] = 181,
  [648] = 173,
  [649] = 178,
  [650] = 186,
  [651] = 166,
  [652] = 652,
  [653] = 192,
  [654] = 190,
  [655] = 174,
  [656] = 188,
  [657] = 187,
  [658] = 115,
  [659] = 659,
  [660] = 660,
  [661] = 115,
  [662] = 662,
  [663] = 663,
  [664] = 117,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 666,
  [669] = 669,
  [670] = 670,
  [671] = 118,
  [672] = 672,
  [673] = 667,
  [674] = 116,
  [675] = 667,
  [676] = 119,
  [677] = 131,
  [678] = 678,
  [679] = 140,
  [680] = 153,
  [681] = 154,
  [682] = 682,
  [683] = 683,
  [684] = 138,
  [685] = 132,
  [686] = 678,
  [687] = 687,
  [688] = 126,
  [689] = 133,
  [690] = 690,
  [691] = 691,
  [692] = 678,
  [693] = 166,
  [694] = 173,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 114,
  [699] = 181,
  [700] = 186,
  [701] = 187,
  [702] = 188,
  [703] = 190,
  [704] = 186,
  [705] = 175,
  [706] = 192,
  [707] = 113,
  [708] = 241,
  [709] = 192,
  [710] = 187,
  [711] = 242,
  [712] = 712,
  [713] = 114,
  [714] = 188,
  [715] = 695,
  [716] = 174,
  [717] = 244,
  [718] = 718,
  [719] = 190,
  [720] = 113,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 730,
  [732] = 732,
  [733] = 732,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 732,
  [740] = 734,
  [741] = 732,
  [742] = 281,
  [743] = 732,
  [744] = 744,
  [745] = 734,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 732,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 734,
  [755] = 734,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 241,
  [778] = 242,
  [779] = 244,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 767,
  [784] = 784,
  [785] = 766,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 787,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 789,
  [799] = 799,
  [800] = 800,
  [801] = 790,
  [802] = 799,
  [803] = 803,
  [804] = 804,
  [805] = 789,
  [806] = 806,
  [807] = 789,
  [808] = 808,
  [809] = 789,
  [810] = 810,
  [811] = 808,
  [812] = 812,
  [813] = 752,
  [814] = 140,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 118,
  [819] = 363,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 452,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 118,
  [829] = 119,
  [830] = 830,
  [831] = 831,
  [832] = 116,
  [833] = 833,
  [834] = 830,
  [835] = 456,
  [836] = 836,
  [837] = 140,
  [838] = 838,
  [839] = 839,
  [840] = 836,
  [841] = 839,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 696,
  [849] = 849,
  [850] = 845,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 847,
  [855] = 844,
  [856] = 856,
  [857] = 827,
  [858] = 847,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 844,
  [863] = 117,
  [864] = 844,
  [865] = 865,
  [866] = 847,
  [867] = 867,
  [868] = 860,
  [869] = 243,
  [870] = 870,
  [871] = 871,
  [872] = 844,
  [873] = 847,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 879,
  [880] = 234,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 878,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 815,
  [892] = 889,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 900,
  [902] = 902,
  [903] = 903,
  [904] = 889,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 905,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 900,
  [919] = 726,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 889,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 930,
  [940] = 940,
  [941] = 900,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 900,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 889,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 931,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 900,
  [970] = 970,
  [971] = 971,
  [972] = 210,
  [973] = 138,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 979,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 984,
  [985] = 983,
  [986] = 986,
  [987] = 987,
  [988] = 988,
  [989] = 217,
  [990] = 990,
  [991] = 991,
  [992] = 992,
  [993] = 993,
  [994] = 994,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 995,
  [1003] = 752,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 1007,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 995,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 225,
  [1022] = 1000,
  [1023] = 1023,
  [1024] = 1024,
  [1025] = 1025,
  [1026] = 983,
  [1027] = 1027,
  [1028] = 1028,
  [1029] = 995,
  [1030] = 995,
  [1031] = 1031,
  [1032] = 221,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1040,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 1092,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1116,
  [1120] = 1120,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1126,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1111,
  [1135] = 1135,
  [1136] = 1091,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1101,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1138,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1098,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1079,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1108,
  [1172] = 1172,
  [1173] = 1107,
  [1174] = 1106,
  [1175] = 1175,
  [1176] = 1106,
  [1177] = 1107,
  [1178] = 1108,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1112,
  [1182] = 1113,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1116,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1113,
  [1189] = 1129,
  [1190] = 1130,
  [1191] = 1131,
  [1192] = 1132,
  [1193] = 1111,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1138,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1053,
  [1204] = 1133,
  [1205] = 1154,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1160,
  [1210] = 1210,
  [1211] = 1106,
  [1212] = 1107,
  [1213] = 1108,
  [1214] = 1214,
  [1215] = 1132,
  [1216] = 1112,
  [1217] = 1113,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1116,
  [1221] = 1131,
  [1222] = 1130,
  [1223] = 1129,
  [1224] = 1130,
  [1225] = 1131,
  [1226] = 1132,
  [1227] = 1111,
  [1228] = 1129,
  [1229] = 1229,
  [1230] = 1230,
  [1231] = 1154,
  [1232] = 1160,
  [1233] = 1233,
  [1234] = 1106,
  [1235] = 1107,
  [1236] = 1108,
  [1237] = 1237,
  [1238] = 1238,
  [1239] = 1112,
  [1240] = 1113,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1116,
  [1244] = 1124,
  [1245] = 1245,
  [1246] = 1129,
  [1247] = 1130,
  [1248] = 1131,
  [1249] = 1132,
  [1250] = 1111,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1253,
  [1254] = 1160,
  [1255] = 1106,
  [1256] = 1107,
  [1257] = 1108,
  [1258] = 1116,
  [1259] = 1132,
  [1260] = 1108,
  [1261] = 1132,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1170,
  [1265] = 1169,
  [1266] = 1266,
  [1267] = 1063,
  [1268] = 1268,
  [1269] = 1160,
  [1270] = 1270,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1159,
  [1276] = 1158,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1279,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 1282,
  [1283] = 1283,
  [1284] = 1284,
  [1285] = 1123,
  [1286] = 1286,
  [1287] = 1287,
  [1288] = 1154,
  [1289] = 1289,
  [1290] = 1112,
  [1291] = 1291,
  [1292] = 1292,
  [1293] = 1293,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1296,
  [1297] = 1279,
  [1298] = 1298,
  [1299] = 1170,
  [1300] = 1169,
  [1301] = 1301,
  [1302] = 1280,
  [1303] = 1118,
  [1304] = 1304,
  [1305] = 1305,
  [1306] = 1170,
  [1307] = 1169,
  [1308] = 1152,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1170,
  [1312] = 1169,
  [1313] = 1313,
  [1314] = 1059,
  [1315] = 1058,
  [1316] = 1053,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1280,
  [1321] = 1321,
  [1322] = 1322,
  [1323] = 1323,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(324);
      ADVANCE_MAP(
        '!', 375,
        '"', 326,
        '#', 411,
        '$', 406,
        '%', 412,
        '&', 343,
        '\'', 413,
        '(', 339,
        ')', 340,
        '*', 404,
        '+', 373,
        ',', 344,
        '-', 386,
        '.', 407,
        '/', 357,
        '0', 374,
        ':', 325,
        ';', 371,
        '<', 399,
        '=', 377,
        '>', 400,
        '@', 369,
        '[', 358,
      );
      if (lookahead == '\\') SKIP(322);
      if (lookahead == ']') ADVANCE(359);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '_') ADVANCE(242);
      if (lookahead == 'a') ADVANCE(503);
      if (lookahead == 'b') ADVANCE(455);
      if (lookahead == 'd') ADVANCE(474);
      if (lookahead == 'e') ADVANCE(561);
      if (lookahead == 'h') ADVANCE(475);
      if (lookahead == 'l') ADVANCE(525);
      if (lookahead == 'r') ADVANCE(476);
      if (lookahead == 't') ADVANCE(530);
      if (lookahead == '{') ADVANCE(367);
      if (lookahead == '|') ADVANCE(342);
      if (lookahead == '}') ADVANCE(368);
      if (lookahead == '~') ADVANCE(410);
      if (lookahead == 0xac) ADVANCE(423);
      if (lookahead == 0x2080) ADVANCE(575);
      if (lookahead == 0x2081) ADVANCE(576);
      if (lookahead == 0x2082) ADVANCE(577);
      if (lookahead == 0x2083) ADVANCE(578);
      if (lookahead == 0x2084) ADVANCE(579);
      if (lookahead == 0x2085) ADVANCE(580);
      if (lookahead == 0x2086) ADVANCE(581);
      if (lookahead == 0x2087) ADVANCE(582);
      if (lookahead == 0x2088) ADVANCE(583);
      if (lookahead == 0x2089) ADVANCE(584);
      if (lookahead == 0x21d2) ADVANCE(420);
      if (lookahead == 0x21d4) ADVANCE(418);
      if (lookahead == 0x2200) ADVANCE(426);
      if (lookahead == 0x2203) ADVANCE(425);
      if (lookahead == 0x2225) ADVANCE(396);
      if (lookahead == 0x2227) ADVANCE(422);
      if (lookahead == 0x2228) ADVANCE(421);
      if (lookahead == 0x228f) ADVANCE(424);
      if (lookahead == 0x2295) ADVANCE(403);
      if (lookahead == 0x22a4) ADVANCE(428);
      if (lookahead == 0x22a5) ADVANCE(427);
      if (lookahead == 0x25b6) ADVANCE(394);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(0);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(26);
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(26);
      if (lookahead == '\r') SKIP(1);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(28);
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(28);
      if (lookahead == '\r') SKIP(3);
      END_STATE();
    case 5:
      if (lookahead == '\n') SKIP(29);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(29);
      if (lookahead == '\r') SKIP(5);
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(27);
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(27);
      if (lookahead == '\r') SKIP(7);
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(30);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(30);
      if (lookahead == '\r') SKIP(9);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(33);
      END_STATE();
    case 12:
      if (lookahead == '\n') SKIP(33);
      if (lookahead == '\r') SKIP(11);
      END_STATE();
    case 13:
      if (lookahead == '\n') SKIP(34);
      END_STATE();
    case 14:
      if (lookahead == '\n') SKIP(34);
      if (lookahead == '\r') SKIP(13);
      END_STATE();
    case 15:
      if (lookahead == '\n') SKIP(31);
      END_STATE();
    case 16:
      if (lookahead == '\n') SKIP(31);
      if (lookahead == '\r') SKIP(15);
      END_STATE();
    case 17:
      if (lookahead == '\n') SKIP(57);
      END_STATE();
    case 18:
      if (lookahead == '\n') SKIP(57);
      if (lookahead == '\r') SKIP(17);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(58);
      END_STATE();
    case 20:
      if (lookahead == '\n') SKIP(58);
      if (lookahead == '\r') SKIP(19);
      END_STATE();
    case 21:
      if (lookahead == '\n') SKIP(32);
      END_STATE();
    case 22:
      if (lookahead == '\n') SKIP(32);
      if (lookahead == '\r') SKIP(21);
      END_STATE();
    case 23:
      if (lookahead == '\n') SKIP(59);
      END_STATE();
    case 24:
      if (lookahead == '\n') SKIP(59);
      if (lookahead == '\r') SKIP(23);
      END_STATE();
    case 25:
      if (lookahead == '\n') SKIP(25);
      if (lookahead == '\\') ADVANCE(414);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(415);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(416);
      END_STATE();
    case 26:
      ADVANCE_MAP(
        '!', 375,
        '"', 326,
        '#', 411,
        '$', 406,
        '%', 412,
        '\'', 413,
        '(', 338,
        ')', 340,
        '*', 404,
        '+', 373,
        ',', 344,
        '-', 385,
        '.', 407,
        '/', 357,
        ':', 325,
        '<', 397,
        '=', 331,
        '>', 400,
        '[', 358,
      );
      if (lookahead == '\\') SKIP(2);
      if (lookahead == ']') ADVANCE(359);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '_') ADVANCE(242);
      if (lookahead == 'a') ADVANCE(502);
      if (lookahead == 'b') ADVANCE(455);
      if (lookahead == 'd') ADVANCE(474);
      if (lookahead == 'e') ADVANCE(561);
      if (lookahead == 'l') ADVANCE(525);
      if (lookahead == 'n') ADVANCE(462);
      if (lookahead == 'r') ADVANCE(476);
      if (lookahead == 's') ADVANCE(562);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '|') ADVANCE(342);
      if (lookahead == '}') ADVANCE(368);
      if (lookahead == '~') ADVANCE(409);
      if (lookahead == 0xac) ADVANCE(423);
      if (lookahead == 0x2080) ADVANCE(575);
      if (lookahead == 0x2081) ADVANCE(576);
      if (lookahead == 0x2082) ADVANCE(577);
      if (lookahead == 0x2083) ADVANCE(578);
      if (lookahead == 0x2084) ADVANCE(579);
      if (lookahead == 0x2085) ADVANCE(580);
      if (lookahead == 0x2086) ADVANCE(581);
      if (lookahead == 0x2087) ADVANCE(582);
      if (lookahead == 0x2088) ADVANCE(583);
      if (lookahead == 0x2089) ADVANCE(584);
      if (lookahead == 0x2200) ADVANCE(426);
      if (lookahead == 0x2203) ADVANCE(425);
      if (lookahead == 0x2295) ADVANCE(403);
      if (lookahead == 0x22a4) ADVANCE(428);
      if (lookahead == 0x22a5) ADVANCE(427);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(26);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        '!', 375,
        '"', 326,
        '#', 94,
        '%', 39,
        '&', 343,
        '(', 338,
        ')', 340,
        '*', 404,
        '+', 373,
        ',', 344,
        '.', 407,
        ':', 325,
        '<', 399,
        '=', 332,
        '@', 369,
        '[', 358,
      );
      if (lookahead == '\\') SKIP(8);
      if (lookahead == ']') ADVANCE(43);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '_') ADVANCE(242);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '|') ADVANCE(342);
      if (lookahead == '~') ADVANCE(320);
      if (lookahead == 0x21d2) ADVANCE(420);
      if (lookahead == 0x21d4) ADVANCE(418);
      if (lookahead == 0x2225) ADVANCE(396);
      if (lookahead == 0x2227) ADVANCE(422);
      if (lookahead == 0x2228) ADVANCE(421);
      if (lookahead == 0x228f) ADVANCE(424);
      if (lookahead == 0x2295) ADVANCE(403);
      if (lookahead == 0x25b6) ADVANCE(394);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(27);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 28:
      ADVANCE_MAP(
        '!', 375,
        '"', 326,
        '$', 406,
        '%', 412,
        '\'', 413,
        '(', 338,
        '*', 404,
        '+', 373,
        ',', 344,
        '-', 40,
        '.', 407,
        '0', 374,
        ':', 325,
        ';', 371,
        '<', 397,
        '=', 331,
        '@', 369,
        '[', 358,
      );
      if (lookahead == '\\') SKIP(4);
      if (lookahead == ']') ADVANCE(43);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '|') ADVANCE(342);
      if (lookahead == '~') ADVANCE(409);
      if (lookahead == 0x2295) ADVANCE(403);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(28);
      if (('1' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 29:
      ADVANCE_MAP(
        '"', 326,
        '#', 94,
        '$', 406,
        '%', 412,
        '&', 343,
        '\'', 413,
        '(', 338,
        ')', 340,
        '*', 404,
        '+', 373,
        ',', 344,
        '.', 407,
        ':', 325,
        ';', 371,
        '<', 397,
        '=', 331,
        '>', 400,
        '@', 369,
        '[', 358,
      );
      if (lookahead == '\\') SKIP(6);
      if (lookahead == ']') ADVANCE(359);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == 'a') ADVANCE(545);
      if (lookahead == 'b') ADVANCE(455);
      if (lookahead == 'd') ADVANCE(474);
      if (lookahead == 'l') ADVANCE(525);
      if (lookahead == 'n') ADVANCE(462);
      if (lookahead == 'r') ADVANCE(476);
      if (lookahead == 's') ADVANCE(562);
      if (lookahead == 't') ADVANCE(530);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '|') ADVANCE(342);
      if (lookahead == '}') ADVANCE(368);
      if (lookahead == '~') ADVANCE(409);
      if (lookahead == 0x2295) ADVANCE(403);
      if (lookahead == 0x25b6) ADVANCE(394);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(29);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('c' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 30:
      ADVANCE_MAP(
        '"', 326,
        '#', 94,
        '%', 39,
        '&', 343,
        '(', 338,
        ')', 340,
        '*', 404,
        '+', 373,
        ',', 344,
        '.', 407,
        ':', 325,
        '<', 399,
        '=', 377,
        '@', 369,
        '[', 358,
      );
      if (lookahead == '\\') SKIP(10);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '|') ADVANCE(342);
      if (lookahead == 0x21d2) ADVANCE(420);
      if (lookahead == 0x21d4) ADVANCE(418);
      if (lookahead == 0x2225) ADVANCE(396);
      if (lookahead == 0x2227) ADVANCE(422);
      if (lookahead == 0x2228) ADVANCE(421);
      if (lookahead == 0x228f) ADVANCE(424);
      if (lookahead == 0x2295) ADVANCE(403);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(30);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 31:
      ADVANCE_MAP(
        '#', 411,
        '$', 406,
        '%', 412,
        '(', 339,
        '*', 404,
        '+', 373,
        '.', 407,
        ':', 325,
        '<', 398,
        '=', 376,
      );
      if (lookahead == '\\') SKIP(16);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '~') ADVANCE(408);
      if (lookahead == 0x228f) ADVANCE(424);
      if (lookahead == 0x2295) ADVANCE(403);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(31);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 32:
      if (lookahead == '#') ADVANCE(411);
      if (lookahead == '\'') ADVANCE(413);
      if (lookahead == '\\') SKIP(22);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(32);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(434);
      END_STATE();
    case 33:
      ADVANCE_MAP(
        '#', 94,
        '%', 412,
        '(', 338,
        ')', 340,
        '*', 404,
        '+', 373,
        ',', 344,
        '.', 407,
        ':', 325,
        ';', 371,
        '<', 398,
        '=', 331,
        '>', 400,
      );
      if (lookahead == '\\') SKIP(12);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '|') ADVANCE(342);
      if (lookahead == '}') ADVANCE(368);
      if (lookahead == 0x228f) ADVANCE(424);
      if (lookahead == 0x2295) ADVANCE(403);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(33);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 34:
      ADVANCE_MAP(
        '%', 39,
        '&', 343,
        '(', 339,
        '*', 404,
        '+', 373,
        '.', 407,
        ':', 325,
        '<', 399,
        '=', 377,
        '@', 369,
        '[', 358,
      );
      if (lookahead == '\\') SKIP(14);
      if (lookahead == '^') ADVANCE(405);
      if (lookahead == '{') ADVANCE(366);
      if (lookahead == '|') ADVANCE(341);
      if (lookahead == 0x21d2) ADVANCE(420);
      if (lookahead == 0x21d4) ADVANCE(418);
      if (lookahead == 0x2227) ADVANCE(422);
      if (lookahead == 0x2228) ADVANCE(421);
      if (lookahead == 0x228f) ADVANCE(424);
      if (lookahead == 0x2295) ADVANCE(403);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(34);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 35:
      if (lookahead == ')') ADVANCE(378);
      END_STATE();
    case 36:
      if (lookahead == '*') ADVANCE(38);
      END_STATE();
    case 37:
      if (lookahead == '*') ADVANCE(37);
      if (lookahead == '}') ADVANCE(585);
      if (lookahead != 0) ADVANCE(38);
      END_STATE();
    case 38:
      if (lookahead == '*') ADVANCE(37);
      if (lookahead != 0) ADVANCE(38);
      END_STATE();
    case 39:
      if (lookahead == '+') ADVANCE(402);
      END_STATE();
    case 40:
      if (lookahead == '-') ADVANCE(52);
      END_STATE();
    case 41:
      if (lookahead == '-') ADVANCE(274);
      END_STATE();
    case 42:
      if (lookahead == '-') ADVANCE(214);
      END_STATE();
    case 43:
      if (lookahead == '-') ADVANCE(56);
      END_STATE();
    case 44:
      if (lookahead == '-') ADVANCE(107);
      END_STATE();
    case 45:
      if (lookahead == '-') ADVANCE(220);
      END_STATE();
    case 46:
      if (lookahead == '-') ADVANCE(235);
      END_STATE();
    case 47:
      if (lookahead == '-') ADVANCE(173);
      END_STATE();
    case 48:
      if (lookahead == '-') ADVANCE(120);
      END_STATE();
    case 49:
      if (lookahead == '-') ADVANCE(298);
      END_STATE();
    case 50:
      if (lookahead == '-') ADVANCE(91);
      END_STATE();
    case 51:
      if (lookahead == '-') ADVANCE(124);
      END_STATE();
    case 52:
      if (lookahead == '>') ADVANCE(370);
      if (lookahead == '[') ADVANCE(380);
      if (lookahead == 'a') ADVANCE(309);
      if (lookahead == 's') ADVANCE(283);
      END_STATE();
    case 53:
      if (lookahead == '>') ADVANCE(360);
      END_STATE();
    case 54:
      if (lookahead == '>') ADVANCE(419);
      END_STATE();
    case 55:
      if (lookahead == '>') ADVANCE(395);
      END_STATE();
    case 56:
      if (lookahead == '>') ADVANCE(381);
      END_STATE();
    case 57:
      if (lookahead == '\\') SKIP(18);
      if (lookahead == ']') ADVANCE(359);
      if (lookahead == 'h') ADVANCE(475);
      if (lookahead == 'o') ADVANCE(557);
      if (lookahead == '{') ADVANCE(36);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 58:
      if (lookahead == '\\') SKIP(20);
      if (lookahead == ']') ADVANCE(359);
      if (lookahead == 'c') ADVANCE(527);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 59:
      if (lookahead == '\\') SKIP(24);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(59);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(574);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(169);
      if (lookahead == 'c') ADVANCE(219);
      if (lookahead == 'p') ADVANCE(250);
      if (lookahead == 's') ADVANCE(289);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(265);
      if (lookahead == 'p') ADVANCE(62);
      if (lookahead == 's') ADVANCE(145);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(149);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(171);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(81);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(198);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(247);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(184);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(292);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(297);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(84);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(156);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(207);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(300);
      END_STATE();
    case 75:
      if (lookahead == 'b') ADVANCE(119);
      END_STATE();
    case 76:
      if (lookahead == 'c') ADVANCE(141);
      END_STATE();
    case 77:
      if (lookahead == 'c') ADVANCE(139);
      END_STATE();
    case 78:
      if (lookahead == 'c') ADVANCE(284);
      END_STATE();
    case 79:
      if (lookahead == 'c') ADVANCE(48);
      END_STATE();
    case 80:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 81:
      if (lookahead == 'c') ADVANCE(100);
      END_STATE();
    case 82:
      if (lookahead == 'c') ADVANCE(170);
      END_STATE();
    case 83:
      if (lookahead == 'c') ADVANCE(245);
      END_STATE();
    case 84:
      if (lookahead == 'c') ADVANCE(101);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(102);
      END_STATE();
    case 86:
      if (lookahead == 'c') ADVANCE(110);
      END_STATE();
    case 87:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(261);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(262);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(263);
      END_STATE();
    case 91:
      if (lookahead == 'c') ADVANCE(143);
      END_STATE();
    case 92:
      if (lookahead == 'c') ADVANCE(51);
      END_STATE();
    case 93:
      if (lookahead == 'd') ADVANCE(147);
      END_STATE();
    case 94:
      if (lookahead == 'd') ADVANCE(103);
      if (lookahead == 'e') ADVANCE(175);
      if (lookahead == 'i') ADVANCE(130);
      END_STATE();
    case 95:
      if (lookahead == 'd') ADVANCE(109);
      END_STATE();
    case 96:
      if (lookahead == 'd') ADVANCE(106);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 98:
      if (lookahead == 'e') ADVANCE(241);
      END_STATE();
    case 99:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(391);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(330);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(392);
      END_STATE();
    case 103:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 106:
      if (lookahead == 'e') ADVANCE(337);
      END_STATE();
    case 107:
      if (lookahead == 'e') ADVANCE(312);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(266);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 112:
      if (lookahead == 'e') ADVANCE(166);
      END_STATE();
    case 113:
      if (lookahead == 'e') ADVANCE(45);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 115:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 116:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(208);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(256);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(203);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(279);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(211);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(303);
      END_STATE();
    case 128:
      if (lookahead == 'f') ADVANCE(335);
      END_STATE();
    case 129:
      if (lookahead == 'f') ADVANCE(333);
      END_STATE();
    case 130:
      if (lookahead == 'f') ADVANCE(95);
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 131:
      if (lookahead == 'f') ADVANCE(158);
      END_STATE();
    case 132:
      if (lookahead == 'g') ADVANCE(353);
      END_STATE();
    case 133:
      if (lookahead == 'g') ADVANCE(354);
      END_STATE();
    case 134:
      if (lookahead == 'g') ADVANCE(348);
      END_STATE();
    case 135:
      if (lookahead == 'g') ADVANCE(350);
      END_STATE();
    case 136:
      if (lookahead == 'g') ADVANCE(194);
      END_STATE();
    case 137:
      if (lookahead == 'g') ADVANCE(206);
      END_STATE();
    case 138:
      if (lookahead == 'g') ADVANCE(259);
      END_STATE();
    case 139:
      if (lookahead == 'h') ADVANCE(393);
      END_STATE();
    case 140:
      if (lookahead == 'h') ADVANCE(99);
      END_STATE();
    case 141:
      if (lookahead == 'h') ADVANCE(66);
      END_STATE();
    case 142:
      if (lookahead == 'h') ADVANCE(252);
      END_STATE();
    case 143:
      if (lookahead == 'h') ADVANCE(73);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 145:
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'y') ADVANCE(177);
      END_STATE();
    case 146:
      if (lookahead == 'i') ADVANCE(311);
      END_STATE();
    case 147:
      if (lookahead == 'i') ADVANCE(128);
      END_STATE();
    case 148:
      if (lookahead == 'i') ADVANCE(190);
      END_STATE();
    case 149:
      if (lookahead == 'i') ADVANCE(246);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(192);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(180);
      END_STATE();
    case 152:
      if (lookahead == 'i') ADVANCE(79);
      END_STATE();
    case 153:
      if (lookahead == 'i') ADVANCE(193);
      END_STATE();
    case 154:
      if (lookahead == 'i') ADVANCE(196);
      END_STATE();
    case 155:
      if (lookahead == 'i') ADVANCE(282);
      END_STATE();
    case 156:
      if (lookahead == 'i') ADVANCE(251);
      END_STATE();
    case 157:
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 158:
      if (lookahead == 'i') ADVANCE(205);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 160:
      if (lookahead == 'i') ADVANCE(227);
      END_STATE();
    case 161:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 162:
      if (lookahead == 'i') ADVANCE(229);
      END_STATE();
    case 163:
      if (lookahead == 'i') ADVANCE(137);
      END_STATE();
    case 164:
      if (lookahead == 'i') ADVANCE(92);
      END_STATE();
    case 165:
      if (lookahead == 'k') ADVANCE(306);
      END_STATE();
    case 166:
      if (lookahead == 'l') ADVANCE(352);
      END_STATE();
    case 167:
      if (lookahead == 'l') ADVANCE(168);
      END_STATE();
    case 168:
      if (lookahead == 'l') ADVANCE(181);
      END_STATE();
    case 169:
      if (lookahead == 'l') ADVANCE(172);
      if (lookahead == 's') ADVANCE(314);
      END_STATE();
    case 170:
      if (lookahead == 'l') ADVANCE(310);
      END_STATE();
    case 171:
      if (lookahead == 'l') ADVANCE(117);
      END_STATE();
    case 172:
      if (lookahead == 'l') ADVANCE(215);
      END_STATE();
    case 173:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 174:
      if (lookahead == 'l') ADVANCE(271);
      END_STATE();
    case 175:
      if (lookahead == 'l') ADVANCE(280);
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 176:
      if (lookahead == 'm') ADVANCE(75);
      END_STATE();
    case 177:
      if (lookahead == 'm') ADVANCE(178);
      END_STATE();
    case 178:
      if (lookahead == 'm') ADVANCE(122);
      END_STATE();
    case 179:
      if (lookahead == 'm') ADVANCE(236);
      END_STATE();
    case 180:
      if (lookahead == 'm') ADVANCE(155);
      END_STATE();
    case 181:
      if (lookahead == 'm') ADVANCE(68);
      END_STATE();
    case 182:
      if (lookahead == 'm') ADVANCE(127);
      END_STATE();
    case 183:
      if (lookahead == 'm') ADVANCE(182);
      END_STATE();
    case 184:
      if (lookahead == 'n') ADVANCE(345);
      END_STATE();
    case 185:
      if (lookahead == 'n') ADVANCE(355);
      END_STATE();
    case 186:
      if (lookahead == 'n') ADVANCE(356);
      END_STATE();
    case 187:
      if (lookahead == 'n') ADVANCE(361);
      END_STATE();
    case 188:
      if (lookahead == 'n') ADVANCE(346);
      END_STATE();
    case 189:
      if (lookahead == 'n') ADVANCE(347);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(132);
      END_STATE();
    case 191:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 192:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 193:
      if (lookahead == 'n') ADVANCE(134);
      END_STATE();
    case 194:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 195:
      if (lookahead == 'n') ADVANCE(307);
      END_STATE();
    case 196:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 197:
      if (lookahead == 'n') ADVANCE(80);
      END_STATE();
    case 198:
      if (lookahead == 'n') ADVANCE(201);
      END_STATE();
    case 199:
      if (lookahead == 'n') ADVANCE(47);
      END_STATE();
    case 200:
      if (lookahead == 'n') ADVANCE(83);
      END_STATE();
    case 201:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 202:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(293);
      END_STATE();
    case 204:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 205:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 206:
      if (lookahead == 'n') ADVANCE(154);
      END_STATE();
    case 207:
      if (lookahead == 'n') ADVANCE(204);
      END_STATE();
    case 208:
      if (lookahead == 'n') ADVANCE(85);
      END_STATE();
    case 209:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 210:
      if (lookahead == 'n') ADVANCE(89);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 212:
      if (lookahead == 'o') ADVANCE(230);
      END_STATE();
    case 213:
      if (lookahead == 'o') ADVANCE(41);
      END_STATE();
    case 214:
      if (lookahead == 'o') ADVANCE(191);
      END_STATE();
    case 215:
      if (lookahead == 'o') ADVANCE(313);
      END_STATE();
    case 216:
      if (lookahead == 'o') ADVANCE(165);
      END_STATE();
    case 217:
      if (lookahead == 'o') ADVANCE(305);
      END_STATE();
    case 218:
      if (lookahead == 'o') ADVANCE(308);
      END_STATE();
    case 219:
      if (lookahead == 'o') ADVANCE(179);
      END_STATE();
    case 220:
      if (lookahead == 'o') ADVANCE(232);
      END_STATE();
    case 221:
      if (lookahead == 'o') ADVANCE(138);
      END_STATE();
    case 222:
      if (lookahead == 'o') ADVANCE(248);
      END_STATE();
    case 223:
      if (lookahead == 'o') ADVANCE(216);
      END_STATE();
    case 224:
      if (lookahead == 'o') ADVANCE(202);
      END_STATE();
    case 225:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 226:
      if (lookahead == 'o') ADVANCE(186);
      END_STATE();
    case 227:
      if (lookahead == 'o') ADVANCE(187);
      END_STATE();
    case 228:
      if (lookahead == 'o') ADVANCE(188);
      END_STATE();
    case 229:
      if (lookahead == 'o') ADVANCE(189);
      END_STATE();
    case 230:
      if (lookahead == 'p') ADVANCE(42);
      END_STATE();
    case 231:
      if (lookahead == 'p') ADVANCE(222);
      END_STATE();
    case 232:
      if (lookahead == 'p') ADVANCE(290);
      END_STATE();
    case 233:
      if (lookahead == 'p') ADVANCE(291);
      END_STATE();
    case 234:
      if (lookahead == 'p') ADVANCE(270);
      END_STATE();
    case 235:
      if (lookahead == 'p') ADVANCE(70);
      END_STATE();
    case 236:
      if (lookahead == 'p') ADVANCE(258);
      END_STATE();
    case 237:
      if (lookahead == 'p') ADVANCE(72);
      END_STATE();
    case 238:
      if (lookahead == 'p') ADVANCE(299);
      END_STATE();
    case 239:
      if (lookahead == 'p') ADVANCE(301);
      END_STATE();
    case 240:
      if (lookahead == 'p') ADVANCE(302);
      END_STATE();
    case 241:
      if (lookahead == 'q') ADVANCE(304);
      END_STATE();
    case 242:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 243:
      if (lookahead == 'r') ADVANCE(144);
      END_STATE();
    case 244:
      if (lookahead == 'r') ADVANCE(63);
      END_STATE();
    case 245:
      if (lookahead == 'r') ADVANCE(315);
      END_STATE();
    case 246:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 247:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 248:
      if (lookahead == 'r') ADVANCE(285);
      END_STATE();
    case 249:
      if (lookahead == 'r') ADVANCE(108);
      END_STATE();
    case 250:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 251:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 252:
      if (lookahead == 'r') ADVANCE(224);
      END_STATE();
    case 253:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 254:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 255:
      if (lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 256:
      if (lookahead == 'r') ADVANCE(199);
      END_STATE();
    case 257:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 258:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 259:
      if (lookahead == 'r') ADVANCE(123);
      END_STATE();
    case 260:
      if (lookahead == 'r') ADVANCE(87);
      END_STATE();
    case 261:
      if (lookahead == 'r') ADVANCE(316);
      END_STATE();
    case 262:
      if (lookahead == 'r') ADVANCE(317);
      END_STATE();
    case 263:
      if (lookahead == 'r') ADVANCE(318);
      END_STATE();
    case 264:
      if (lookahead == 'r') ADVANCE(164);
      END_STATE();
    case 265:
      if (lookahead == 's') ADVANCE(319);
      END_STATE();
    case 266:
      if (lookahead == 's') ADVANCE(390);
      END_STATE();
    case 267:
      if (lookahead == 's') ADVANCE(329);
      END_STATE();
    case 268:
      if (lookahead == 's') ADVANCE(362);
      END_STATE();
    case 269:
      if (lookahead == 's') ADVANCE(364);
      END_STATE();
    case 270:
      if (lookahead == 's') ADVANCE(365);
      END_STATE();
    case 271:
      if (lookahead == 's') ADVANCE(363);
      END_STATE();
    case 272:
      if (lookahead == 's') ADVANCE(349);
      END_STATE();
    case 273:
      if (lookahead == 's') ADVANCE(286);
      END_STATE();
    case 274:
      if (lookahead == 's') ADVANCE(217);
      END_STATE();
    case 275:
      if (lookahead == 's') ADVANCE(111);
      END_STATE();
    case 276:
      if (lookahead == 's') ADVANCE(163);
      END_STATE();
    case 277:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 278:
      if (lookahead == 's') ADVANCE(281);
      END_STATE();
    case 279:
      if (lookahead == 's') ADVANCE(268);
      END_STATE();
    case 280:
      if (lookahead == 's') ADVANCE(104);
      END_STATE();
    case 281:
      if (lookahead == 's') ADVANCE(44);
      END_STATE();
    case 282:
      if (lookahead == 's') ADVANCE(74);
      END_STATE();
    case 283:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 284:
      if (lookahead == 't') ADVANCE(384);
      END_STATE();
    case 285:
      if (lookahead == 't') ADVANCE(351);
      END_STATE();
    case 286:
      if (lookahead == 't') ADVANCE(243);
      END_STATE();
    case 287:
      if (lookahead == 't') ADVANCE(213);
      END_STATE();
    case 288:
      if (lookahead == 't') ADVANCE(244);
      END_STATE();
    case 289:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 290:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 291:
      if (lookahead == 't') ADVANCE(157);
      END_STATE();
    case 292:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 293:
      if (lookahead == 't') ADVANCE(269);
      END_STATE();
    case 294:
      if (lookahead == 't') ADVANCE(118);
      END_STATE();
    case 295:
      if (lookahead == 't') ADVANCE(254);
      END_STATE();
    case 296:
      if (lookahead == 't') ADVANCE(255);
      END_STATE();
    case 297:
      if (lookahead == 't') ADVANCE(294);
      END_STATE();
    case 298:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 299:
      if (lookahead == 't') ADVANCE(159);
      END_STATE();
    case 300:
      if (lookahead == 't') ADVANCE(160);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 302:
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 303:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 304:
      if (lookahead == 'u') ADVANCE(146);
      END_STATE();
    case 305:
      if (lookahead == 'u') ADVANCE(260);
      END_STATE();
    case 306:
      if (lookahead == 'u') ADVANCE(234);
      END_STATE();
    case 307:
      if (lookahead == 'u') ADVANCE(176);
      END_STATE();
    case 308:
      if (lookahead == 'u') ADVANCE(277);
      END_STATE();
    case 309:
      if (lookahead == 'u') ADVANCE(287);
      END_STATE();
    case 310:
      if (lookahead == 'u') ADVANCE(96);
      END_STATE();
    case 311:
      if (lookahead == 'v') ADVANCE(64);
      END_STATE();
    case 312:
      if (lookahead == 'v') ADVANCE(121);
      END_STATE();
    case 313:
      if (lookahead == 'w') ADVANCE(46);
      END_STATE();
    case 314:
      if (lookahead == 'y') ADVANCE(197);
      END_STATE();
    case 315:
      if (lookahead == 'y') ADVANCE(233);
      END_STATE();
    case 316:
      if (lookahead == 'y') ADVANCE(238);
      END_STATE();
    case 317:
      if (lookahead == 'y') ADVANCE(239);
      END_STATE();
    case 318:
      if (lookahead == 'y') ADVANCE(240);
      END_STATE();
    case 319:
      if (lookahead == 'y') ADVANCE(183);
      END_STATE();
    case 320:
      if (lookahead == '~') ADVANCE(55);
      END_STATE();
    case 321:
      if (eof) ADVANCE(324);
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 322:
      if (eof) ADVANCE(324);
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(321);
      END_STATE();
    case 323:
      if (eof) ADVANCE(324);
      if (lookahead == '\n') SKIP(323);
      if (lookahead == '\\') ADVANCE(327);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(328);
      if (lookahead != 0) ADVANCE(327);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(aux_sym_theory_token1);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(aux_sym_theory_token1);
      if (lookahead == '\\') ADVANCE(327);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(328);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(327);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_DASH_DASHauto_DASHsources);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_DASH_DASHstop_DASHon_DASHtrace);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(54);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_POUNDifdef);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_POUNDelse);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_POUNDendif);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_POUNDdefine);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(anon_sym_POUNDinclude);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      if (lookahead == '<') ADVANCE(35);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(372);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_diffie_DASHhellman);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(anon_sym_symmetric_DASHencryption);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(anon_sym_asymmetric_DASHencryption);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(anon_sym_bilinear_DASHpairing);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(anon_sym_natural_DASHnumbers);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_revealing_DASHsigning);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_locations_DASHreport);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_reliable_DASHchannel);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(anon_sym_dest_DASHpairing);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_dest_DASHsigning);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_dest_DASHsymmetric_DASHencryption);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_dest_DASHasymmetric_DASHencryption);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_translation_DASHstate_DASHoptimisation);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_translation_DASHprogress);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(anon_sym_translation_DASHasynchronous_DASHchannels);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_translation_DASHcompress_DASHevents);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_translation_DASHallow_DASHpattern_DASHlookups);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '*') ADVANCE(38);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_GT);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(401);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_null);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(anon_sym_EQ2);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(anon_sym_EQ2);
      if (lookahead == '=') ADVANCE(54);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_LPAREN_LT_RPAREN);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_DASH_DASH_LBRACK);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(anon_sym_RBRACK_DASH_GT);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(anon_sym_color_EQ);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_colour_EQ);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym__restrict);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(52);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_output_EQ);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_hide_lemma_EQ);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(anon_sym_heuristic_EQ);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_all_DASHtraces);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(anon_sym_exists_DASHtrace);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_rule_DASHequivalence);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_backward_DASHsearch);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_u25b6);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_TILDE_TILDE_GT);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(anon_sym_u2225);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(379);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(379);
      if (lookahead == '=') ADVANCE(53);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_PERCENT_PLUS);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_u2295);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '\'') ADVANCE(417);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '\'') ADVANCE(417);
      if (lookahead == '~') ADVANCE(55);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '+') ADVANCE(402);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(aux_sym_pub_name_token1);
      if (lookahead == '\r') ADVANCE(416);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(416);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(aux_sym_pub_name_token1);
      if (lookahead == '\\') ADVANCE(414);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(415);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'') ADVANCE(416);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(aux_sym_pub_name_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'') ADVANCE(416);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(anon_sym_TILDE_SQUOTE);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_u21d4);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_GT);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_u21d2);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_u2228);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_u2227);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_u00ac);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_u228f);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_u2203);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(anon_sym_u2200);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(anon_sym_u22a5);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_u22a4);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(aux_sym_hexcolor_token1);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(aux_sym_hexcolor_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(429);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(aux_sym_hexcolor_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(430);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(aux_sym_hexcolor_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(431);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(aux_sym_hexcolor_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(432);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(aux_sym_hexcolor_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(433);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(237);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(276);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(195);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(249);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '-') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '=') ADVANCE(389);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '=') ADVANCE(388);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '=') ADVANCE(387);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '=') ADVANCE(382);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '=') ADVANCE(383);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == '_') ADVANCE(508);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(467);
      if (lookahead == 'i') ADVANCE(504);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(520);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(466);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(450);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(531);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(552);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(534);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(547);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(510);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(511);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'a') ADVANCE(554);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'b') ADVANCE(509);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(500);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(449);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(460);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(447);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'c') ADVANCE(448);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'd') ADVANCE(477);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'd') ADVANCE(442);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(539);
      if (lookahead == 'i') ADVANCE(486);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(472);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(505);
      if (lookahead == 'u') ADVANCE(506);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(454);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(513);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(438);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(464);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(436);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(551);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(461);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(441);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'e') ADVANCE(555);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'f') ADVANCE(487);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'f') ADVANCE(496);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'g') ADVANCE(443);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(528);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(523);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(526);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(468);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(457);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(519);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(470);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(481);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(540);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(543);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'i') ADVANCE(471);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'k') ADVANCE(560);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(440);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(501);
      if (lookahead == 's') ADVANCE(563);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(501);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(490);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(493);
      if (lookahead == 'v') ADVANCE(480);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(479);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(524);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(478);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(484);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(444);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(494);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'l') ADVANCE(465);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(515);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(516);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(458);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(482);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(485);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'm') ADVANCE(517);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(488);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(541);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(542);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(437);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'n') ADVANCE(483);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(532);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(469);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(522);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(507);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'o') ADVANCE(521);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'p') ADVANCE(558);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(456);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(473);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(452);
      if (lookahead == 'u') ADVANCE(533);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(453);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(439);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(495);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(463);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(498);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'r') ADVANCE(499);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(548);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(549);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(512);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(445);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(553);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(446);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 's') ADVANCE(563);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(529);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(559);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(435);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(544);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(451);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(535);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(489);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(492);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(491);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 't') ADVANCE(538);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(537);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(546);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(550);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'u') ADVANCE(536);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'w') ADVANCE(459);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'x') ADVANCE(497);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(514);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_ident);
      if (lookahead == 'y') ADVANCE(518);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_ident);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(564);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_param);
      if (lookahead == '\n') ADVANCE(567);
      if (lookahead == '\r') ADVANCE(566);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(568);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_param);
      if (lookahead == '\n') ADVANCE(567);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(568);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_param);
      if (lookahead == '\\') ADVANCE(565);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(567);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(568);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_param);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(568);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_export_query);
      if (lookahead == '\n') ADVANCE(571);
      if (lookahead == '\r') ADVANCE(570);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead != 0) ADVANCE(572);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_export_query);
      if (lookahead == '\n') ADVANCE(571);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(572);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_export_query);
      if (lookahead == '\\') ADVANCE(569);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) ADVANCE(571);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(572);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_export_query);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(572);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_export_query);
      if (lookahead == '\\') ADVANCE(573);
      if (lookahead != 0) ADVANCE(572);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_natural);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(574);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(anon_sym_u2080);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(anon_sym_u2081);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_u2082);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_u2083);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_u2084);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_u2085);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(anon_sym_u2086);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(anon_sym_u2087);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(anon_sym_u2088);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(anon_sym_u2089);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(aux_sym_formal_comment_token1);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'A', 1,
        'B', 2,
        'D', 3,
        'E', 4,
        'F', 5,
        'M', 6,
        'O', 7,
        'S', 8,
        'T', 9,
        'X', 10,
      );
      if (lookahead == '\\') SKIP(11);
      if (lookahead == 'a') ADVANCE(12);
      if (lookahead == 'b') ADVANCE(13);
      if (lookahead == 'c') ADVANCE(14);
      if (lookahead == 'd') ADVANCE(15);
      if (lookahead == 'e') ADVANCE(16);
      if (lookahead == 'f') ADVANCE(17);
      if (lookahead == 'h') ADVANCE(18);
      if (lookahead == 'i') ADVANCE(19);
      if (lookahead == 'l') ADVANCE(20);
      if (lookahead == 'm') ADVANCE(21);
      if (lookahead == 'n') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'p') ADVANCE(24);
      if (lookahead == 'q') ADVANCE(25);
      if (lookahead == 'r') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      if (lookahead == 't') ADVANCE(28);
      if (lookahead == 'u') ADVANCE(29);
      if (lookahead == 'v') ADVANCE(30);
      if (lookahead == 'x') ADVANCE(31);
      if (lookahead == 'C' ||
          lookahead == 'I' ||
          lookahead == 'P') ADVANCE(32);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'C') ADVANCE(33);
      if (lookahead == 'N') ADVANCE(34);
      if (lookahead == 'T') ADVANCE(35);
      if (lookahead == 'l') ADVANCE(36);
      END_STATE();
    case 2:
      if (lookahead == 'F') ADVANCE(37);
      END_STATE();
    case 3:
      if (lookahead == 'F') ADVANCE(38);
      END_STATE();
    case 4:
      ACCEPT_TOKEN(anon_sym_E);
      if (lookahead == 'x') ADVANCE(39);
      END_STATE();
    case 5:
      ACCEPT_TOKEN(anon_sym_F);
      END_STATE();
    case 6:
      if (lookahead == 'I') ADVANCE(40);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(anon_sym_O);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'E', 41,
        'O', 42,
        'C', 43,
        'I', 43,
        'P', 43,
        'S', 43,
        'c', 43,
        'i', 43,
        'p', 43,
        's', 43,
      );
      END_STATE();
    case 9:
      ACCEPT_TOKEN(anon_sym_T);
      END_STATE();
    case 10:
      if (lookahead == 'O') ADVANCE(44);
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(0);
      if (lookahead == '\r') SKIP(45);
      END_STATE();
    case 12:
      if (lookahead == 'c') ADVANCE(46);
      if (lookahead == 's') ADVANCE(47);
      if (lookahead == 'x') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(49);
      if (lookahead == 'f') ADVANCE(50);
      if (lookahead == 'u') ADVANCE(51);
      if (lookahead == 'y') ADVANCE(52);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'a', 53,
        'o', 54,
        'C', 43,
        'I', 43,
        'P', 43,
        'S', 43,
        'c', 43,
        'i', 43,
        'p', 43,
        's', 43,
      );
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'h') ADVANCE(57);
      if (lookahead == 'i') ADVANCE(58);
      END_STATE();
    case 16:
      if (lookahead == 'l') ADVANCE(59);
      if (lookahead == 'n') ADVANCE(60);
      if (lookahead == 'q') ADVANCE(61);
      if (lookahead == 'v') ADVANCE(62);
      if (lookahead == 'x') ADVANCE(63);
      END_STATE();
    case 17:
      if (lookahead == 'o') ADVANCE(64);
      if (lookahead == 'r') ADVANCE(65);
      if (lookahead == 'u') ADVANCE(66);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(67);
      if (lookahead == 'e') ADVANCE(68);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'd', 69,
        'f', 70,
        'n', 71,
        's', 72,
        'C', 43,
        'I', 43,
        'P', 43,
        'S', 43,
        'c', 43,
        'i', 43,
        'p', 43,
      );
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(73);
      if (lookahead == 'e') ADVANCE(74);
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(76);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == 's') ADVANCE(78);
      if (lookahead == 'u') ADVANCE(79);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(80);
      if (lookahead == 'e') ADVANCE(81);
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_o);
      if (lookahead == 'p') ADVANCE(83);
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'r', 85,
        'u', 86,
        'C', 43,
        'I', 43,
        'P', 43,
        'S', 43,
        'c', 43,
        'i', 43,
        'p', 43,
        's', 43,
      );
      END_STATE();
    case 25:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 26:
      if (lookahead == 'e') ADVANCE(88);
      if (lookahead == 'i') ADVANCE(89);
      if (lookahead == 'o') ADVANCE(90);
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'e', 92,
        'i', 93,
        'm', 94,
        'o', 95,
        'p', 96,
        't', 97,
        'C', 43,
        'I', 43,
        'P', 43,
        'S', 43,
        'c', 43,
        's', 43,
      );
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(98);
      if (lookahead == 'e') ADVANCE(99);
      if (lookahead == 'h') ADVANCE(100);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(101);
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 30:
      if (lookahead == 'a') ADVANCE(103);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(104);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'C', 43,
        'I', 43,
        'P', 43,
        'S', 43,
        'c', 43,
        'i', 43,
        'p', 43,
        's', 43,
      );
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_AC);
      END_STATE();
    case 34:
      if (lookahead == 'Y') ADVANCE(105);
      END_STATE();
    case 35:
      if (lookahead == 'T') ADVANCE(106);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 37:
      if (lookahead == 'S') ADVANCE(108);
      END_STATE();
    case 38:
      if (lookahead == 'S') ADVANCE(109);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_Ex);
      END_STATE();
    case 40:
      if (lookahead == 'R') ADVANCE(110);
      END_STATE();
    case 41:
      if (lookahead == 'Q') ADVANCE(111);
      END_STATE();
    case 42:
      if (lookahead == 'L') ADVANCE(112);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'C', 113,
        'I', 113,
        'P', 113,
        'S', 113,
        'c', 113,
        'i', 113,
        'p', 113,
        's', 113,
      );
      END_STATE();
    case 44:
      if (lookahead == 'R') ADVANCE(114);
      END_STATE();
    case 45:
      if (lookahead == '\n') SKIP(0);
      END_STATE();
    case 46:
      if (lookahead == 'c') ADVANCE(115);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 48:
      if (lookahead == 'i') ADVANCE(116);
      END_STATE();
    case 49:
      if (lookahead == 'g') ADVANCE(117);
      END_STATE();
    case 50:
      if (lookahead == 's') ADVANCE(118);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(119);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_by);
      END_STATE();
    case 53:
      if (lookahead == 's') ADVANCE(120);
      END_STATE();
    case 54:
      if (lookahead == 'n') ADVANCE(121);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(122);
      if (lookahead == 'f') ADVANCE(123);
      if (lookahead == 'l') ADVANCE(124);
      if (lookahead == 'p') ADVANCE(125);
      if (lookahead == 's') ADVANCE(126);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(127);
      END_STATE();
    case 57:
      if (lookahead == 'r') ADVANCE(128);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(129);
      END_STATE();
    case 59:
      if (lookahead == 's') ADVANCE(130);
      END_STATE();
    case 60:
      if (lookahead == 'd') ADVANCE(131);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(132);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(133);
      END_STATE();
    case 63:
      if (lookahead == 'p') ADVANCE(134);
      END_STATE();
    case 64:
      if (lookahead == 'r') ADVANCE(135);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(136);
      END_STATE();
    case 66:
      if (lookahead == 'n') ADVANCE(137);
      END_STATE();
    case 67:
      if (lookahead == 's') ADVANCE(138);
      END_STATE();
    case 68:
      if (lookahead == 'u') ADVANCE(139);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_id);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'd') ADVANCE(140);
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'F', 142,
        'I', 143,
        's', 144,
        'C', 113,
        'P', 113,
        'S', 113,
        'c', 113,
        'i', 113,
        'p', 113,
      );
      END_STATE();
    case 73:
      if (lookahead == 's') ADVANCE(145);
      END_STATE();
    case 74:
      if (lookahead == 'f') ADVANCE(146);
      if (lookahead == 'm') ADVANCE(147);
      if (lookahead == 't') ADVANCE(148);
      END_STATE();
    case 75:
      if (lookahead == 'c') ADVANCE(149);
      if (lookahead == 'o') ADVANCE(150);
      END_STATE();
    case 76:
      if (lookahead == 'c') ADVANCE(151);
      END_STATE();
    case 77:
      if (lookahead == 'd') ADVANCE(152);
      END_STATE();
    case 78:
      if (lookahead == 'g') ADVANCE(153);
      if (lookahead == 'r') ADVANCE(154);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(155);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(156);
      END_STATE();
    case 81:
      if (lookahead == 'w') ADVANCE(157);
      if (lookahead == 'x') ADVANCE(158);
      END_STATE();
    case 82:
      if (lookahead == '_') ADVANCE(159);
      if (lookahead == 'd') ADVANCE(160);
      if (lookahead == 'n') ADVANCE(161);
      if (lookahead == 't') ADVANCE(162);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(165);
      if (lookahead == 'i') ADVANCE(166);
      if (lookahead == 'o') ADVANCE(167);
      END_STATE();
    case 86:
      if (lookahead == 'b') ADVANCE(168);
      END_STATE();
    case 87:
      if (lookahead == 'd') ADVANCE(169);
      END_STATE();
    case 88:
      if (lookahead == 'a') ADVANCE(170);
      if (lookahead == 'g') ADVANCE(171);
      if (lookahead == 's') ADVANCE(172);
      if (lookahead == 'u') ADVANCE(173);
      END_STATE();
    case 89:
      if (lookahead == 'g') ADVANCE(174);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 91:
      if (lookahead == 'l') ADVANCE(176);
      END_STATE();
    case 92:
      if (lookahead == 'q') ADVANCE(177);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'g', 178,
        'm', 179,
        'C', 113,
        'I', 113,
        'P', 113,
        'S', 113,
        'c', 113,
        'i', 113,
        'p', 113,
        's', 113,
      );
      END_STATE();
    case 94:
      if (lookahead == 'a') ADVANCE(180);
      END_STATE();
    case 95:
      if (lookahead == 'l') ADVANCE(181);
      if (lookahead == 'r') ADVANCE(182);
      if (lookahead == 'u') ADVANCE(183);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'l', 184,
        't', 185,
        'C', 113,
        'I', 113,
        'P', 113,
        'S', 113,
        'c', 113,
        'i', 113,
        'p', 113,
        's', 113,
      );
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(187);
      END_STATE();
    case 99:
      if (lookahead == 'm') ADVANCE(188);
      if (lookahead == 's') ADVANCE(189);
      END_STATE();
    case 100:
      if (lookahead == 'e') ADVANCE(190);
      END_STATE();
    case 101:
      if (lookahead == 'l') ADVANCE(191);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(192);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(193);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(194);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_ANY);
      END_STATE();
    case 106:
      if (lookahead == 'A') ADVANCE(195);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_All);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_BFS);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_DFS);
      END_STATE();
    case 110:
      if (lookahead == 'R') ADVANCE(196);
      END_STATE();
    case 111:
      if (lookahead == 'D') ADVANCE(197);
      END_STATE();
    case 112:
      if (lookahead == 'V') ADVANCE(198);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'C', 199,
        'I', 199,
        'P', 199,
        'S', 199,
        'c', 199,
        'i', 199,
        'p', 199,
        's', 199,
      );
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_XOR);
      END_STATE();
    case 115:
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 116:
      if (lookahead == 'o') ADVANCE(201);
      END_STATE();
    case 117:
      if (lookahead == 'i') ADVANCE(202);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_bfs);
      END_STATE();
    case 119:
      if (lookahead == 'l') ADVANCE(203);
      END_STATE();
    case 120:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 121:
      if (lookahead == 'f') ADVANCE(205);
      if (lookahead == 't') ADVANCE(206);
      if (lookahead == 'v') ADVANCE(207);
      END_STATE();
    case 122:
      if (lookahead == 'p') ADVANCE(208);
      END_STATE();
    case 123:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(210);
      END_STATE();
    case 125:
      if (lookahead == 'r') ADVANCE(211);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(212);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_dfs);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(213);
      END_STATE();
    case 129:
      if (lookahead == 'f') ADVANCE(214);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(215);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(216);
      if (lookahead == 'i') ADVANCE(217);
      END_STATE();
    case 133:
      if (lookahead == 'n') ADVANCE(218);
      END_STATE();
    case 134:
      if (lookahead == 'o') ADVANCE(219);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 136:
      if (lookahead == 's') ADVANCE(220);
      END_STATE();
    case 137:
      if (lookahead == 'c') ADVANCE(221);
      END_STATE();
    case 138:
      if (lookahead == 'h') ADVANCE(222);
      END_STATE();
    case 139:
      if (lookahead == 'r') ADVANCE(223);
      END_STATE();
    case 140:
      if (lookahead == 'u') ADVANCE(224);
      END_STATE();
    case 141:
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 142:
      if (lookahead == 'a') ADVANCE(226);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'n', 227,
        'C', 199,
        'I', 199,
        'P', 199,
        'S', 199,
        'c', 199,
        'i', 199,
        'p', 199,
        's', 199,
      );
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      ADVANCE_MAP(
        'a', 228,
        'C', 199,
        'I', 199,
        'P', 199,
        'S', 199,
        'c', 199,
        'i', 199,
        'p', 199,
        's', 199,
      );
      END_STATE();
    case 145:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 146:
      if (lookahead == 't') ADVANCE(230);
      END_STATE();
    case 147:
      if (lookahead == 'm') ADVANCE(231);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 149:
      if (lookahead == 'k') ADVANCE(232);
      END_STATE();
    case 150:
      if (lookahead == 'k') ADVANCE(233);
      END_STATE();
    case 151:
      if (lookahead == 'r') ADVANCE(234);
      END_STATE();
    case 152:
      if (lookahead == 'u') ADVANCE(235);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_msg);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_msr);
      END_STATE();
    case 155:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_nat);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(237);
      END_STATE();
    case 159:
      if (lookahead == 'd') ADVANCE(238);
      if (lookahead == 'p') ADVANCE(239);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 161:
      if (lookahead == 'A') ADVANCE(241);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 163:
      if (lookahead == 'i') ADVANCE(242);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_out);
      END_STATE();
    case 165:
      if (lookahead == 'd') ADVANCE(243);
      if (lookahead == 's') ADVANCE(244);
      END_STATE();
    case 166:
      if (lookahead == 'o') ADVANCE(245);
      if (lookahead == 'v') ADVANCE(246);
      END_STATE();
    case 167:
      if (lookahead == 'c') ADVANCE(247);
      if (lookahead == 'v') ADVANCE(248);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_pub);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_qed);
      END_STATE();
    case 170:
      if (lookahead == 's') ADVANCE(249);
      END_STATE();
    case 171:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 172:
      if (lookahead == 't') ADVANCE(251);
      END_STATE();
    case 173:
      if (lookahead == 's') ADVANCE(252);
      END_STATE();
    case 174:
      if (lookahead == 'h') ADVANCE(253);
      END_STATE();
    case 175:
      if (lookahead == 'e') ADVANCE(254);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(255);
      END_STATE();
    case 177:
      if (lookahead == 'd') ADVANCE(256);
      END_STATE();
    case 178:
      if (lookahead == 'n') ADVANCE(257);
      END_STATE();
    case 179:
      if (lookahead == 'p') ADVANCE(258);
      END_STATE();
    case 180:
      if (lookahead == 'l') ADVANCE(259);
      END_STATE();
    case 181:
      if (lookahead == 'v') ADVANCE(260);
      END_STATE();
    case 182:
      if (lookahead == 'r') ADVANCE(261);
      END_STATE();
    case 183:
      if (lookahead == 'r') ADVANCE(262);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(263);
      END_STATE();
    case 185:
      if (lookahead == 'h') ADVANCE(264);
      END_STATE();
    case 186:
      if (lookahead == 'p') ADVANCE(265);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(266);
      END_STATE();
    case 188:
      if (lookahead == 'p') ADVANCE(267);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(268);
      END_STATE();
    case 190:
      if (lookahead == 'n') ADVANCE(269);
      if (lookahead == 'o') ADVANCE(270);
      END_STATE();
    case 191:
      if (lookahead == 'o') ADVANCE(271);
      END_STATE();
    case 192:
      if (lookahead == '_') ADVANCE(272);
      END_STATE();
    case 193:
      if (lookahead == 'i') ADVANCE(273);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 195:
      if (lookahead == 'C') ADVANCE(274);
      END_STATE();
    case 196:
      if (lookahead == 'O') ADVANCE(275);
      END_STATE();
    case 197:
      if (lookahead == 'F') ADVANCE(276);
      END_STATE();
    case 198:
      if (lookahead == 'E') ADVANCE(277);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_standard_goal_ranking);
      END_STATE();
    case 200:
      if (lookahead == 'u') ADVANCE(278);
      END_STATE();
    case 201:
      if (lookahead == 'm') ADVANCE(279);
      END_STATE();
    case 202:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(281);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(282);
      END_STATE();
    case 206:
      if (lookahead == 'r') ADVANCE(283);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 208:
      if (lookahead == 's') ADVANCE(285);
      END_STATE();
    case 209:
      if (lookahead == 'u') ADVANCE(286);
      END_STATE();
    case 210:
      if (lookahead == 't') ADVANCE(287);
      END_STATE();
    case 211:
      if (lookahead == 'i') ADVANCE(288);
      END_STATE();
    case 212:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 213:
      if (lookahead == 'N') ADVANCE(290);
      END_STATE();
    case 214:
      if (lookahead == 'E') ADVANCE(291);
      if (lookahead == 'L') ADVANCE(292);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 216:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 217:
      if (lookahead == 'v') ADVANCE(294);
      END_STATE();
    case 218:
      if (lookahead == 't') ADVANCE(295);
      END_STATE();
    case 219:
      if (lookahead == 'r') ADVANCE(296);
      END_STATE();
    case 220:
      if (lookahead == 'h') ADVANCE(297);
      END_STATE();
    case 221:
      if (lookahead == 't') ADVANCE(298);
      END_STATE();
    case 222:
      if (lookahead == 'i') ADVANCE(299);
      END_STATE();
    case 223:
      if (lookahead == 'i') ADVANCE(300);
      END_STATE();
    case 224:
      if (lookahead == 'c') ADVANCE(301);
      END_STATE();
    case 225:
      if (lookahead == 'r') ADVANCE(302);
      END_STATE();
    case 226:
      if (lookahead == 'c') ADVANCE(303);
      END_STATE();
    case 227:
      if (lookahead == 'F') ADVANCE(304);
      END_STATE();
    case 228:
      if (lookahead == 'p') ADVANCE(305);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_last);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_left);
      END_STATE();
    case 231:
      if (lookahead == 'a') ADVANCE(306);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_lock);
      END_STATE();
    case 233:
      if (lookahead == 'u') ADVANCE(307);
      END_STATE();
    case 234:
      if (lookahead == 'o') ADVANCE(308);
      END_STATE();
    case 235:
      if (lookahead == 'l') ADVANCE(309);
      END_STATE();
    case 236:
      if (lookahead == 'i') ADVANCE(310);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(anon_sym_next);
      END_STATE();
    case 238:
      if (lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 239:
      if (lookahead == 'r') ADVANCE(312);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_node);
      END_STATE();
    case 241:
      if (lookahead == 'b') ADVANCE(313);
      END_STATE();
    case 242:
      if (lookahead == 'o') ADVANCE(314);
      END_STATE();
    case 243:
      if (lookahead == 'i') ADVANCE(315);
      END_STATE();
    case 244:
      if (lookahead == 'o') ADVANCE(316);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_prio);
      END_STATE();
    case 246:
      if (lookahead == 'a') ADVANCE(317);
      END_STATE();
    case 247:
      if (lookahead == 'e') ADVANCE(318);
      END_STATE();
    case 248:
      if (lookahead == 'e') ADVANCE(319);
      END_STATE();
    case 249:
      if (lookahead == 'o') ADVANCE(320);
      END_STATE();
    case 250:
      if (lookahead == 'x') ADVANCE(321);
      END_STATE();
    case 251:
      if (lookahead == 'r') ADVANCE(322);
      END_STATE();
    case 252:
      if (lookahead == 'e') ADVANCE(323);
      END_STATE();
    case 253:
      if (lookahead == 't') ADVANCE(324);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_role);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_rule);
      END_STATE();
    case 256:
      if (lookahead == 'f') ADVANCE(325);
      END_STATE();
    case 257:
      if (lookahead == 'i') ADVANCE(326);
      END_STATE();
    case 258:
      if (lookahead == 'l') ADVANCE(327);
      END_STATE();
    case 259:
      if (lookahead == 'l') ADVANCE(328);
      END_STATE();
    case 260:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 261:
      if (lookahead == 'y') ADVANCE(330);
      END_STATE();
    case 262:
      if (lookahead == 'c') ADVANCE(331);
      END_STATE();
    case 263:
      if (lookahead == 't') ADVANCE(332);
      END_STATE();
    case 264:
      if (lookahead == 'y') ADVANCE(333);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_step);
      END_STATE();
    case 266:
      if (lookahead == 'i') ADVANCE(334);
      END_STATE();
    case 267:
      if (lookahead == 'o') ADVANCE(335);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_test);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 270:
      if (lookahead == 'r') ADVANCE(336);
      END_STATE();
    case 271:
      if (lookahead == 'c') ADVANCE(337);
      END_STATE();
    case 272:
      if (lookahead == 'i') ADVANCE(338);
      END_STATE();
    case 273:
      if (lookahead == 'a') ADVANCE(339);
      END_STATE();
    case 274:
      if (lookahead == 'K') ADVANCE(340);
      END_STATE();
    case 275:
      if (lookahead == 'R') ADVANCE(341);
      END_STATE();
    case 276:
      if (lookahead == 'S') ADVANCE(342);
      END_STATE();
    case 277:
      if (lookahead == 'D') ADVANCE(343);
      END_STATE();
    case 278:
      if (lookahead == 'n') ADVANCE(344);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(anon_sym_axiom);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_begin);
      END_STATE();
    case 281:
      if (lookahead == 'i') ADVANCE(345);
      END_STATE();
    case 282:
      if (lookahead == 'g') ADVANCE(346);
      END_STATE();
    case 283:
      if (lookahead == 'a') ADVANCE(347);
      END_STATE();
    case 284:
      if (lookahead == 'r') ADVANCE(348);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(349);
      END_STATE();
    case 286:
      if (lookahead == 'l') ADVANCE(350);
      END_STATE();
    case 287:
      if (lookahead == 'e') ADVANCE(351);
      END_STATE();
    case 288:
      if (lookahead == 'o') ADVANCE(352);
      END_STATE();
    case 289:
      if (lookahead == 'u') ADVANCE(353);
      END_STATE();
    case 290:
      if (lookahead == 'o') ADVANCE(354);
      END_STATE();
    case 291:
      if (lookahead == 'q') ADVANCE(355);
      END_STATE();
    case 292:
      if (lookahead == 'e') ADVANCE(356);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(357);
      END_STATE();
    case 294:
      if (lookahead == 'L') ADVANCE(358);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 296:
      if (lookahead == 't') ADVANCE(359);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_fresh);
      END_STATE();
    case 298:
      if (lookahead == 'i') ADVANCE(360);
      END_STATE();
    case 299:
      if (lookahead == 'n') ADVANCE(361);
      END_STATE();
    case 300:
      if (lookahead == 's') ADVANCE(362);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(363);
      END_STATE();
    case 302:
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 303:
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 304:
      if (lookahead == 'a') ADVANCE(366);
      END_STATE();
    case 305:
      if (lookahead == 'i') ADVANCE(367);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_lemma);
      END_STATE();
    case 307:
      if (lookahead == 'p') ADVANCE(368);
      END_STATE();
    case 308:
      if (lookahead == 's') ADVANCE(369);
      END_STATE();
    case 309:
      if (lookahead == 'o') ADVANCE(370);
      END_STATE();
    case 310:
      if (lookahead == 's') ADVANCE(371);
      END_STATE();
    case 311:
      if (lookahead == 'r') ADVANCE(372);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(373);
      END_STATE();
    case 313:
      if (lookahead == 's') ADVANCE(374);
      END_STATE();
    case 314:
      if (lookahead == 'n') ADVANCE(375);
      END_STATE();
    case 315:
      if (lookahead == 'c') ADVANCE(376);
      END_STATE();
    case 316:
      if (lookahead == 'r') ADVANCE(377);
      END_STATE();
    case 317:
      if (lookahead == 't') ADVANCE(378);
      END_STATE();
    case 318:
      if (lookahead == 's') ADVANCE(379);
      END_STATE();
    case 319:
      if (lookahead == 'r') ADVANCE(380);
      END_STATE();
    case 320:
      if (lookahead == 'n') ADVANCE(381);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(anon_sym_regex);
      END_STATE();
    case 322:
      if (lookahead == 'i') ADVANCE(382);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_reuse);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(anon_sym_right);
      END_STATE();
    case 325:
      if (lookahead == 's') ADVANCE(383);
      END_STATE();
    case 326:
      if (lookahead == 'n') ADVANCE(384);
      END_STATE();
    case 327:
      if (lookahead == 'i') ADVANCE(385);
      END_STATE();
    case 328:
      if (lookahead == 'e') ADVANCE(386);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_solve);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_sorry);
      END_STATE();
    case 331:
      if (lookahead == 'e') ADVANCE(387);
      END_STATE();
    case 332:
      if (lookahead == 'E') ADVANCE(388);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_spthy);
      if (lookahead == 't') ADVANCE(389);
      END_STATE();
    case 334:
      if (lookahead == 'c') ADVANCE(390);
      END_STATE();
    case 335:
      if (lookahead == 'r') ADVANCE(391);
      END_STATE();
    case 336:
      if (lookahead == 'y') ADVANCE(392);
      END_STATE();
    case 337:
      if (lookahead == 'k') ADVANCE(393);
      END_STATE();
    case 338:
      if (lookahead == 'n') ADVANCE(394);
      END_STATE();
    case 339:
      if (lookahead == 'n') ADVANCE(395);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_ATTACK);
      END_STATE();
    case 341:
      if (lookahead == 'E') ADVANCE(396);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(anon_sym_SEQDFS);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_solved);
      END_STATE();
    case 344:
      if (lookahead == 't') ADVANCE(397);
      END_STATE();
    case 345:
      if (lookahead == 'n') ADVANCE(398);
      END_STATE();
    case 346:
      if (lookahead == 'u') ADVANCE(399);
      END_STATE();
    case 347:
      if (lookahead == 'd') ADVANCE(400);
      END_STATE();
    case 348:
      if (lookahead == 'g') ADVANCE(401);
      END_STATE();
    case 349:
      if (lookahead == 'c') ADVANCE(402);
      END_STATE();
    case 350:
      if (lookahead == 't') ADVANCE(403);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(anon_sym_deprio);
      END_STATE();
    case 353:
      if (lookahead == 'c') ADVANCE(404);
      END_STATE();
    case 354:
      if (lookahead == 'i') ADVANCE(405);
      END_STATE();
    case 355:
      if (lookahead == 'u') ADVANCE(406);
      END_STATE();
    case 356:
      if (lookahead == 'm') ADVANCE(407);
      END_STATE();
    case 357:
      if (lookahead == 'o') ADVANCE(408);
      END_STATE();
    case 358:
      if (lookahead == 'e') ADVANCE(409);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 360:
      if (lookahead == 'o') ADVANCE(410);
      END_STATE();
    case 361:
      if (lookahead == 'g') ADVANCE(411);
      END_STATE();
    case 362:
      if (lookahead == 't') ADVANCE(412);
      END_STATE();
    case 363:
      if (lookahead == 'i') ADVANCE(413);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(anon_sym_insert);
      END_STATE();
    case 365:
      if (lookahead == 'N') ADVANCE(414);
      END_STATE();
    case 366:
      if (lookahead == 'c') ADVANCE(415);
      END_STATE();
    case 367:
      if (lookahead == 'c') ADVANCE(416);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(anon_sym_lookup);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(anon_sym_macros);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_modulo);
      END_STATE();
    case 371:
      if (lookahead == 'e') ADVANCE(417);
      END_STATE();
    case 372:
      if (lookahead == 'i') ADVANCE(418);
      END_STATE();
    case 373:
      if (lookahead == 'c') ADVANCE(419);
      END_STATE();
    case 374:
      if (lookahead == 'u') ADVANCE(420);
      END_STATE();
    case 375:
      if (lookahead == 's') ADVANCE(421);
      END_STATE();
    case 376:
      if (lookahead == 'a') ADVANCE(422);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(423);
      END_STATE();
    case 378:
      if (lookahead == 'e') ADVANCE(424);
      END_STATE();
    case 379:
      if (lookahead == 's') ADVANCE(425);
      END_STATE();
    case 380:
      if (lookahead == 'i') ADVANCE(426);
      END_STATE();
    case 381:
      if (lookahead == 'a') ADVANCE(427);
      END_STATE();
    case 382:
      if (lookahead == 'c') ADVANCE(428);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(anon_sym_seqdfs);
      END_STATE();
    case 384:
      if (lookahead == 'g') ADVANCE(429);
      END_STATE();
    case 385:
      if (lookahead == 'f') ADVANCE(430);
      END_STATE();
    case 386:
      if (lookahead == 's') ADVANCE(431);
      END_STATE();
    case 387:
      if (lookahead == 's') ADVANCE(432);
      END_STATE();
    case 388:
      if (lookahead == 'q') ADVANCE(433);
      END_STATE();
    case 389:
      if (lookahead == 'y') ADVANCE(434);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(anon_sym_tactic);
      END_STATE();
    case 391:
      if (lookahead == 'a') ADVANCE(435);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(anon_sym_theory);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_unlock);
      END_STATE();
    case 394:
      if (lookahead == 'd') ADVANCE(436);
      END_STATE();
    case 395:
      if (lookahead == 't') ADVANCE(437);
      END_STATE();
    case 396:
      if (lookahead == 'D') ADVANCE(438);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(anon_sym_account);
      if (lookahead == 's') ADVANCE(439);
      END_STATE();
    case 398:
      if (lookahead == 's') ADVANCE(440);
      END_STATE();
    case 399:
      if (lookahead == 'r') ADVANCE(441);
      END_STATE();
    case 400:
      if (lookahead == 'i') ADVANCE(442);
      END_STATE();
    case 401:
      if (lookahead == 'e') ADVANCE(443);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_deepsec);
      END_STATE();
    case 403:
      if (lookahead == 'N') ADVANCE(444);
      END_STATE();
    case 404:
      if (lookahead == 't') ADVANCE(445);
      END_STATE();
    case 405:
      if (lookahead == 's') ADVANCE(446);
      END_STATE();
    case 406:
      if (lookahead == 'i') ADVANCE(447);
      END_STATE();
    case 407:
      if (lookahead == 'm') ADVANCE(448);
      END_STATE();
    case 408:
      if (lookahead == 'n') ADVANCE(449);
      END_STATE();
    case 409:
      if (lookahead == 'm') ADVANCE(450);
      END_STATE();
    case 410:
      if (lookahead == 'n') ADVANCE(451);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_hashing);
      END_STATE();
    case 412:
      if (lookahead == 'i') ADVANCE(452);
      END_STATE();
    case 413:
      if (lookahead == 'o') ADVANCE(453);
      END_STATE();
    case 414:
      if (lookahead == 'a') ADVANCE(454);
      END_STATE();
    case 415:
      if (lookahead == 't') ADVANCE(455);
      END_STATE();
    case 416:
      if (lookahead == 'r') ADVANCE(456);
      END_STATE();
    case 417:
      if (lookahead == 't') ADVANCE(457);
      END_STATE();
    case 418:
      if (lookahead == 'v') ADVANCE(458);
      END_STATE();
    case 419:
      if (lookahead == 'o') ADVANCE(459);
      END_STATE();
    case 420:
      if (lookahead == 'r') ADVANCE(460);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(anon_sym_options);
      END_STATE();
    case 422:
      if (lookahead == 't') ADVANCE(461);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_presort);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_process);
      END_STATE();
    case 426:
      if (lookahead == 'f') ADVANCE(462);
      END_STATE();
    case 427:
      if (lookahead == 'b') ADVANCE(463);
      END_STATE();
    case 428:
      if (lookahead == 't') ADVANCE(464);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_signing);
      END_STATE();
    case 430:
      if (lookahead == 'y') ADVANCE(465);
      END_STATE();
    case 431:
      if (lookahead == 't') ADVANCE(466);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_sources);
      END_STATE();
    case 433:
      if (lookahead == 's') ADVANCE(467);
      END_STATE();
    case 434:
      if (lookahead == 'p') ADVANCE(468);
      END_STATE();
    case 435:
      if (lookahead == 'l') ADVANCE(469);
      END_STATE();
    case 436:
      if (lookahead == 'u') ADVANCE(470);
      END_STATE();
    case 437:
      if (lookahead == 's') ADVANCE(471);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_mirrored);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_accounts);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_builtins);
      END_STATE();
    case 441:
      if (lookahead == 'a') ADVANCE(472);
      END_STATE();
    case 442:
      if (lookahead == 'c') ADVANCE(473);
      END_STATE();
    case 443:
      if (lookahead == 'n') ADVANCE(474);
      END_STATE();
    case 444:
      if (lookahead == 'o') ADVANCE(475);
      END_STATE();
    case 445:
      if (lookahead == 'o') ADVANCE(476);
      END_STATE();
    case 446:
      if (lookahead == 'e') ADVANCE(477);
      END_STATE();
    case 447:
      if (lookahead == 'v') ADVANCE(478);
      END_STATE();
    case 448:
      if (lookahead == 'a') ADVANCE(479);
      END_STATE();
    case 449:
      if (lookahead == 's') ADVANCE(480);
      END_STATE();
    case 450:
      if (lookahead == 'm') ADVANCE(481);
      END_STATE();
    case 451:
      if (lookahead == 's') ADVANCE(482);
      END_STATE();
    case 452:
      if (lookahead == 'c') ADVANCE(483);
      END_STATE();
    case 453:
      if (lookahead == 'n') ADVANCE(484);
      END_STATE();
    case 454:
      if (lookahead == 'm') ADVANCE(485);
      END_STATE();
    case 455:
      if (lookahead == 'T') ADVANCE(486);
      END_STATE();
    case 456:
      if (lookahead == 'u') ADVANCE(487);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_multiset);
      END_STATE();
    case 458:
      if (lookahead == 'c') ADVANCE(488);
      END_STATE();
    case 459:
      if (lookahead == 'm') ADVANCE(489);
      END_STATE();
    case 460:
      if (lookahead == 'd') ADVANCE(490);
      END_STATE();
    case 461:
      if (lookahead == 'e') ADVANCE(491);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_proverif);
      END_STATE();
    case 463:
      if (lookahead == 'l') ADVANCE(492);
      END_STATE();
    case 464:
      if (lookahead == 'i') ADVANCE(493);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_simplify);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_smallest);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_splitEqs);
      END_STATE();
    case 468:
      if (lookahead == 'e') ADVANCE(494);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_temporal);
      END_STATE();
    case 470:
      if (lookahead == 'c') ADVANCE(495);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_variants);
      END_STATE();
    case 472:
      if (lookahead == 't') ADVANCE(496);
      END_STATE();
    case 473:
      if (lookahead == 't') ADVANCE(497);
      END_STATE();
    case 474:
      if (lookahead == 't') ADVANCE(498);
      END_STATE();
    case 475:
      if (lookahead == 'i') ADVANCE(499);
      END_STATE();
    case 476:
      if (lookahead == 'r') ADVANCE(500);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_dhreNoise);
      END_STATE();
    case 478:
      if (lookahead == 'L') ADVANCE(501);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_diffLemma);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_equations);
      END_STATE();
    case 481:
      if (lookahead == 'a') ADVANCE(502);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_functions);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_heuristic);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_induction);
      END_STATE();
    case 485:
      if (lookahead == 'e') ADVANCE(503);
      END_STATE();
    case 486:
      if (lookahead == 'e') ADVANCE(504);
      END_STATE();
    case 487:
      if (lookahead == 'l') ADVANCE(505);
      END_STATE();
    case 488:
      if (lookahead == 'h') ADVANCE(506);
      END_STATE();
    case 489:
      if (lookahead == 'p') ADVANCE(507);
      END_STATE();
    case 490:
      if (lookahead == 'G') ADVANCE(508);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_predicate);
      if (lookahead == 's') ADVANCE(509);
      END_STATE();
    case 492:
      if (lookahead == 'e') ADVANCE(510);
      END_STATE();
    case 493:
      if (lookahead == 'o') ADVANCE(511);
      END_STATE();
    case 494:
      if (lookahead == 'd') ADVANCE(512);
      END_STATE();
    case 495:
      if (lookahead == 't') ADVANCE(513);
      END_STATE();
    case 496:
      if (lookahead == 'i') ADVANCE(514);
      END_STATE();
    case 497:
      if (lookahead == 'i') ADVANCE(515);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_convergent);
      END_STATE();
    case 499:
      if (lookahead == 's') ADVANCE(516);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_destructor);
      END_STATE();
    case 501:
      if (lookahead == 'e') ADVANCE(517);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_equivLemma);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_isFactName);
      END_STATE();
    case 504:
      if (lookahead == 'r') ADVANCE(518);
      END_STATE();
    case 505:
      if (lookahead == 'e') ADVANCE(519);
      END_STATE();
    case 506:
      if (lookahead == 'e') ADVANCE(520);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_no_precomp);
      END_STATE();
    case 508:
      if (lookahead == 'o') ADVANCE(521);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_predicates);
      END_STATE();
    case 510:
      if (lookahead == 'N') ADVANCE(522);
      END_STATE();
    case 511:
      if (lookahead == 'n') ADVANCE(523);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_spthytyped);
      END_STATE();
    case 513:
      if (lookahead == 'i') ADVANCE(524);
      END_STATE();
    case 514:
      if (lookahead == 'o') ADVANCE(525);
      END_STATE();
    case 515:
      if (lookahead == 'o') ADVANCE(526);
      END_STATE();
    case 516:
      if (lookahead == 'e') ADVANCE(527);
      END_STATE();
    case 517:
      if (lookahead == 'm') ADVANCE(528);
      END_STATE();
    case 518:
      if (lookahead == 'm') ADVANCE(529);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_issapicrule);
      END_STATE();
    case 520:
      if (lookahead == 'c') ADVANCE(530);
      END_STATE();
    case 521:
      if (lookahead == 'a') ADVANCE(531);
      END_STATE();
    case 522:
      if (lookahead == 'o') ADVANCE(532);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_restriction);
      END_STATE();
    case 524:
      if (lookahead == 'o') ADVANCE(533);
      END_STATE();
    case 525:
      if (lookahead == 'n') ADVANCE(534);
      END_STATE();
    case 526:
      if (lookahead == 'n') ADVANCE(535);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_defaultNoise);
      END_STATE();
    case 528:
      if (lookahead == 'm') ADVANCE(536);
      END_STATE();
    case 529:
      if (lookahead == 's') ADVANCE(537);
      END_STATE();
    case 530:
      if (lookahead == 'k') ADVANCE(538);
      END_STATE();
    case 531:
      if (lookahead == 'l') ADVANCE(539);
      END_STATE();
    case 532:
      if (lookahead == 'n') ADVANCE(540);
      END_STATE();
    case 533:
      if (lookahead == 'n') ADVANCE(541);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_configuration);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_contradiction);
      END_STATE();
    case 536:
      if (lookahead == 'a') ADVANCE(542);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(anon_sym_isInFactTerms);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_no_derivcheck);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_nonAbsurdGoal);
      END_STATE();
    case 540:
      if (lookahead == 'c') ADVANCE(543);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(anon_sym_use_induction);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_diffEquivLemma);
      END_STATE();
    case 543:
      if (lookahead == 'e') ADVANCE(544);
      END_STATE();
    case 544:
      if (lookahead == 's') ADVANCE(545);
      END_STATE();
    case 545:
      if (lookahead == 'N') ADVANCE(546);
      END_STATE();
    case 546:
      if (lookahead == 'o') ADVANCE(547);
      END_STATE();
    case 547:
      if (lookahead == 'i') ADVANCE(548);
      END_STATE();
    case 548:
      if (lookahead == 's') ADVANCE(549);
      END_STATE();
    case 549:
      if (lookahead == 'e') ADVANCE(550);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_reasonableNoncesNoise);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 26, .external_lex_state = 1},
  [2] = {.lex_state = 26, .external_lex_state = 1},
  [3] = {.lex_state = 28, .external_lex_state = 1},
  [4] = {.lex_state = 28, .external_lex_state = 1},
  [5] = {.lex_state = 28, .external_lex_state = 1},
  [6] = {.lex_state = 28, .external_lex_state = 1},
  [7] = {.lex_state = 28, .external_lex_state = 1},
  [8] = {.lex_state = 28, .external_lex_state = 1},
  [9] = {.lex_state = 28, .external_lex_state = 1},
  [10] = {.lex_state = 28, .external_lex_state = 1},
  [11] = {.lex_state = 28, .external_lex_state = 1},
  [12] = {.lex_state = 28, .external_lex_state = 1},
  [13] = {.lex_state = 28, .external_lex_state = 1},
  [14] = {.lex_state = 26, .external_lex_state = 1},
  [15] = {.lex_state = 28, .external_lex_state = 1},
  [16] = {.lex_state = 28, .external_lex_state = 1},
  [17] = {.lex_state = 28, .external_lex_state = 1},
  [18] = {.lex_state = 28, .external_lex_state = 1},
  [19] = {.lex_state = 28, .external_lex_state = 1},
  [20] = {.lex_state = 28, .external_lex_state = 1},
  [21] = {.lex_state = 28, .external_lex_state = 1},
  [22] = {.lex_state = 28, .external_lex_state = 1},
  [23] = {.lex_state = 28, .external_lex_state = 1},
  [24] = {.lex_state = 28, .external_lex_state = 1},
  [25] = {.lex_state = 28, .external_lex_state = 1},
  [26] = {.lex_state = 28, .external_lex_state = 1},
  [27] = {.lex_state = 28, .external_lex_state = 1},
  [28] = {.lex_state = 28, .external_lex_state = 1},
  [29] = {.lex_state = 28, .external_lex_state = 1},
  [30] = {.lex_state = 28, .external_lex_state = 1},
  [31] = {.lex_state = 28, .external_lex_state = 1},
  [32] = {.lex_state = 28, .external_lex_state = 1},
  [33] = {.lex_state = 28, .external_lex_state = 1},
  [34] = {.lex_state = 28, .external_lex_state = 1},
  [35] = {.lex_state = 28, .external_lex_state = 1},
  [36] = {.lex_state = 28, .external_lex_state = 1},
  [37] = {.lex_state = 28, .external_lex_state = 1},
  [38] = {.lex_state = 28, .external_lex_state = 1},
  [39] = {.lex_state = 28, .external_lex_state = 1},
  [40] = {.lex_state = 28, .external_lex_state = 1},
  [41] = {.lex_state = 28, .external_lex_state = 1},
  [42] = {.lex_state = 28, .external_lex_state = 1},
  [43] = {.lex_state = 28, .external_lex_state = 1},
  [44] = {.lex_state = 28, .external_lex_state = 1},
  [45] = {.lex_state = 28, .external_lex_state = 1},
  [46] = {.lex_state = 28, .external_lex_state = 1},
  [47] = {.lex_state = 28, .external_lex_state = 1},
  [48] = {.lex_state = 28, .external_lex_state = 1},
  [49] = {.lex_state = 28, .external_lex_state = 1},
  [50] = {.lex_state = 26, .external_lex_state = 1},
  [51] = {.lex_state = 28, .external_lex_state = 1},
  [52] = {.lex_state = 28, .external_lex_state = 1},
  [53] = {.lex_state = 28, .external_lex_state = 1},
  [54] = {.lex_state = 28, .external_lex_state = 1},
  [55] = {.lex_state = 28, .external_lex_state = 1},
  [56] = {.lex_state = 28, .external_lex_state = 1},
  [57] = {.lex_state = 28, .external_lex_state = 1},
  [58] = {.lex_state = 26, .external_lex_state = 1},
  [59] = {.lex_state = 26, .external_lex_state = 1},
  [60] = {.lex_state = 26, .external_lex_state = 1},
  [61] = {.lex_state = 26, .external_lex_state = 1},
  [62] = {.lex_state = 26, .external_lex_state = 1},
  [63] = {.lex_state = 26, .external_lex_state = 1},
  [64] = {.lex_state = 26, .external_lex_state = 1},
  [65] = {.lex_state = 26, .external_lex_state = 1},
  [66] = {.lex_state = 26, .external_lex_state = 1},
  [67] = {.lex_state = 26, .external_lex_state = 1},
  [68] = {.lex_state = 26, .external_lex_state = 1},
  [69] = {.lex_state = 26, .external_lex_state = 1},
  [70] = {.lex_state = 26, .external_lex_state = 1},
  [71] = {.lex_state = 26, .external_lex_state = 1},
  [72] = {.lex_state = 26, .external_lex_state = 1},
  [73] = {.lex_state = 26, .external_lex_state = 1},
  [74] = {.lex_state = 26, .external_lex_state = 1},
  [75] = {.lex_state = 26, .external_lex_state = 1},
  [76] = {.lex_state = 26, .external_lex_state = 1},
  [77] = {.lex_state = 26, .external_lex_state = 1},
  [78] = {.lex_state = 26, .external_lex_state = 1},
  [79] = {.lex_state = 26, .external_lex_state = 1},
  [80] = {.lex_state = 26, .external_lex_state = 1},
  [81] = {.lex_state = 26, .external_lex_state = 1},
  [82] = {.lex_state = 26, .external_lex_state = 1},
  [83] = {.lex_state = 26, .external_lex_state = 1},
  [84] = {.lex_state = 26, .external_lex_state = 1},
  [85] = {.lex_state = 26, .external_lex_state = 1},
  [86] = {.lex_state = 26, .external_lex_state = 1},
  [87] = {.lex_state = 26, .external_lex_state = 1},
  [88] = {.lex_state = 26, .external_lex_state = 1},
  [89] = {.lex_state = 26, .external_lex_state = 1},
  [90] = {.lex_state = 26, .external_lex_state = 1},
  [91] = {.lex_state = 26, .external_lex_state = 1},
  [92] = {.lex_state = 26, .external_lex_state = 1},
  [93] = {.lex_state = 26, .external_lex_state = 1},
  [94] = {.lex_state = 26, .external_lex_state = 1},
  [95] = {.lex_state = 29, .external_lex_state = 1},
  [96] = {.lex_state = 29, .external_lex_state = 1},
  [97] = {.lex_state = 29, .external_lex_state = 1},
  [98] = {.lex_state = 29, .external_lex_state = 1},
  [99] = {.lex_state = 29, .external_lex_state = 1},
  [100] = {.lex_state = 29, .external_lex_state = 1},
  [101] = {.lex_state = 29, .external_lex_state = 1},
  [102] = {.lex_state = 29, .external_lex_state = 1},
  [103] = {.lex_state = 29, .external_lex_state = 1},
  [104] = {.lex_state = 27, .external_lex_state = 1},
  [105] = {.lex_state = 29, .external_lex_state = 1},
  [106] = {.lex_state = 29, .external_lex_state = 1},
  [107] = {.lex_state = 29, .external_lex_state = 1},
  [108] = {.lex_state = 29, .external_lex_state = 1},
  [109] = {.lex_state = 29, .external_lex_state = 1},
  [110] = {.lex_state = 29, .external_lex_state = 1},
  [111] = {.lex_state = 27, .external_lex_state = 1},
  [112] = {.lex_state = 27, .external_lex_state = 1},
  [113] = {.lex_state = 29, .external_lex_state = 1},
  [114] = {.lex_state = 29, .external_lex_state = 1},
  [115] = {.lex_state = 30, .external_lex_state = 1},
  [116] = {.lex_state = 30, .external_lex_state = 1},
  [117] = {.lex_state = 30, .external_lex_state = 1},
  [118] = {.lex_state = 30, .external_lex_state = 1},
  [119] = {.lex_state = 30, .external_lex_state = 1},
  [120] = {.lex_state = 29, .external_lex_state = 1},
  [121] = {.lex_state = 33, .external_lex_state = 1},
  [122] = {.lex_state = 33, .external_lex_state = 1},
  [123] = {.lex_state = 33, .external_lex_state = 1},
  [124] = {.lex_state = 33, .external_lex_state = 1},
  [125] = {.lex_state = 33, .external_lex_state = 1},
  [126] = {.lex_state = 33, .external_lex_state = 1},
  [127] = {.lex_state = 33, .external_lex_state = 1},
  [128] = {.lex_state = 33, .external_lex_state = 1},
  [129] = {.lex_state = 33, .external_lex_state = 1},
  [130] = {.lex_state = 33, .external_lex_state = 1},
  [131] = {.lex_state = 33, .external_lex_state = 1},
  [132] = {.lex_state = 33, .external_lex_state = 1},
  [133] = {.lex_state = 30, .external_lex_state = 1},
  [134] = {.lex_state = 30, .external_lex_state = 1},
  [135] = {.lex_state = 33, .external_lex_state = 1},
  [136] = {.lex_state = 33, .external_lex_state = 1},
  [137] = {.lex_state = 33, .external_lex_state = 1},
  [138] = {.lex_state = 30, .external_lex_state = 1},
  [139] = {.lex_state = 33, .external_lex_state = 1},
  [140] = {.lex_state = 33, .external_lex_state = 1},
  [141] = {.lex_state = 33, .external_lex_state = 1},
  [142] = {.lex_state = 33, .external_lex_state = 1},
  [143] = {.lex_state = 30, .external_lex_state = 1},
  [144] = {.lex_state = 33, .external_lex_state = 1},
  [145] = {.lex_state = 30, .external_lex_state = 1},
  [146] = {.lex_state = 30, .external_lex_state = 1},
  [147] = {.lex_state = 33, .external_lex_state = 1},
  [148] = {.lex_state = 30, .external_lex_state = 1},
  [149] = {.lex_state = 30, .external_lex_state = 1},
  [150] = {.lex_state = 30, .external_lex_state = 1},
  [151] = {.lex_state = 33, .external_lex_state = 1},
  [152] = {.lex_state = 30, .external_lex_state = 1},
  [153] = {.lex_state = 33, .external_lex_state = 1},
  [154] = {.lex_state = 30, .external_lex_state = 1},
  [155] = {.lex_state = 33, .external_lex_state = 1},
  [156] = {.lex_state = 30, .external_lex_state = 1},
  [157] = {.lex_state = 30, .external_lex_state = 1},
  [158] = {.lex_state = 30, .external_lex_state = 1},
  [159] = {.lex_state = 30, .external_lex_state = 1},
  [160] = {.lex_state = 30, .external_lex_state = 1},
  [161] = {.lex_state = 30, .external_lex_state = 1},
  [162] = {.lex_state = 30, .external_lex_state = 1},
  [163] = {.lex_state = 30, .external_lex_state = 1},
  [164] = {.lex_state = 30, .external_lex_state = 1},
  [165] = {.lex_state = 30, .external_lex_state = 1},
  [166] = {.lex_state = 33, .external_lex_state = 1},
  [167] = {.lex_state = 29, .external_lex_state = 1},
  [168] = {.lex_state = 29, .external_lex_state = 1},
  [169] = {.lex_state = 29, .external_lex_state = 1},
  [170] = {.lex_state = 29, .external_lex_state = 1},
  [171] = {.lex_state = 29, .external_lex_state = 1},
  [172] = {.lex_state = 29, .external_lex_state = 1},
  [173] = {.lex_state = 30, .external_lex_state = 1},
  [174] = {.lex_state = 30, .external_lex_state = 1},
  [175] = {.lex_state = 33, .external_lex_state = 1},
  [176] = {.lex_state = 29, .external_lex_state = 1},
  [177] = {.lex_state = 29, .external_lex_state = 1},
  [178] = {.lex_state = 30, .external_lex_state = 1},
  [179] = {.lex_state = 30, .external_lex_state = 1},
  [180] = {.lex_state = 29, .external_lex_state = 1},
  [181] = {.lex_state = 30, .external_lex_state = 1},
  [182] = {.lex_state = 29, .external_lex_state = 1},
  [183] = {.lex_state = 33, .external_lex_state = 1},
  [184] = {.lex_state = 33, .external_lex_state = 1},
  [185] = {.lex_state = 30, .external_lex_state = 1},
  [186] = {.lex_state = 30, .external_lex_state = 1},
  [187] = {.lex_state = 30, .external_lex_state = 1},
  [188] = {.lex_state = 30, .external_lex_state = 1},
  [189] = {.lex_state = 30, .external_lex_state = 1},
  [190] = {.lex_state = 30, .external_lex_state = 1},
  [191] = {.lex_state = 30, .external_lex_state = 1},
  [192] = {.lex_state = 30, .external_lex_state = 1},
  [193] = {.lex_state = 33, .external_lex_state = 1},
  [194] = {.lex_state = 29, .external_lex_state = 1},
  [195] = {.lex_state = 29, .external_lex_state = 1},
  [196] = {.lex_state = 29, .external_lex_state = 1},
  [197] = {.lex_state = 29, .external_lex_state = 1},
  [198] = {.lex_state = 29, .external_lex_state = 1},
  [199] = {.lex_state = 29, .external_lex_state = 1},
  [200] = {.lex_state = 29, .external_lex_state = 1},
  [201] = {.lex_state = 29, .external_lex_state = 1},
  [202] = {.lex_state = 29, .external_lex_state = 1},
  [203] = {.lex_state = 29, .external_lex_state = 1},
  [204] = {.lex_state = 29, .external_lex_state = 1},
  [205] = {.lex_state = 30, .external_lex_state = 1},
  [206] = {.lex_state = 29, .external_lex_state = 1},
  [207] = {.lex_state = 30, .external_lex_state = 1},
  [208] = {.lex_state = 29, .external_lex_state = 1},
  [209] = {.lex_state = 29, .external_lex_state = 1},
  [210] = {.lex_state = 30, .external_lex_state = 1},
  [211] = {.lex_state = 29, .external_lex_state = 1},
  [212] = {.lex_state = 29, .external_lex_state = 1},
  [213] = {.lex_state = 30, .external_lex_state = 1},
  [214] = {.lex_state = 30, .external_lex_state = 1},
  [215] = {.lex_state = 30, .external_lex_state = 1},
  [216] = {.lex_state = 30, .external_lex_state = 1},
  [217] = {.lex_state = 30, .external_lex_state = 1},
  [218] = {.lex_state = 30, .external_lex_state = 1},
  [219] = {.lex_state = 30, .external_lex_state = 1},
  [220] = {.lex_state = 30, .external_lex_state = 1},
  [221] = {.lex_state = 30, .external_lex_state = 1},
  [222] = {.lex_state = 29, .external_lex_state = 1},
  [223] = {.lex_state = 30, .external_lex_state = 1},
  [224] = {.lex_state = 30, .external_lex_state = 1},
  [225] = {.lex_state = 30, .external_lex_state = 1},
  [226] = {.lex_state = 29, .external_lex_state = 1},
  [227] = {.lex_state = 29, .external_lex_state = 1},
  [228] = {.lex_state = 29, .external_lex_state = 1},
  [229] = {.lex_state = 29, .external_lex_state = 1},
  [230] = {.lex_state = 29, .external_lex_state = 1},
  [231] = {.lex_state = 29, .external_lex_state = 1},
  [232] = {.lex_state = 29, .external_lex_state = 1},
  [233] = {.lex_state = 29, .external_lex_state = 1},
  [234] = {.lex_state = 29, .external_lex_state = 1},
  [235] = {.lex_state = 29, .external_lex_state = 1},
  [236] = {.lex_state = 29, .external_lex_state = 1},
  [237] = {.lex_state = 29, .external_lex_state = 1},
  [238] = {.lex_state = 29, .external_lex_state = 1},
  [239] = {.lex_state = 29, .external_lex_state = 1},
  [240] = {.lex_state = 29, .external_lex_state = 1},
  [241] = {.lex_state = 27, .external_lex_state = 1},
  [242] = {.lex_state = 27, .external_lex_state = 1},
  [243] = {.lex_state = 29, .external_lex_state = 1},
  [244] = {.lex_state = 27, .external_lex_state = 1},
  [245] = {.lex_state = 29, .external_lex_state = 1},
  [246] = {.lex_state = 28, .external_lex_state = 1},
  [247] = {.lex_state = 29, .external_lex_state = 1},
  [248] = {.lex_state = 29, .external_lex_state = 1},
  [249] = {.lex_state = 29, .external_lex_state = 1},
  [250] = {.lex_state = 29, .external_lex_state = 1},
  [251] = {.lex_state = 29, .external_lex_state = 1},
  [252] = {.lex_state = 29, .external_lex_state = 1},
  [253] = {.lex_state = 26, .external_lex_state = 1},
  [254] = {.lex_state = 26, .external_lex_state = 1},
  [255] = {.lex_state = 26, .external_lex_state = 1},
  [256] = {.lex_state = 26, .external_lex_state = 1},
  [257] = {.lex_state = 26, .external_lex_state = 1},
  [258] = {.lex_state = 26, .external_lex_state = 1},
  [259] = {.lex_state = 28, .external_lex_state = 1},
  [260] = {.lex_state = 26, .external_lex_state = 1},
  [261] = {.lex_state = 27, .external_lex_state = 1},
  [262] = {.lex_state = 26, .external_lex_state = 1},
  [263] = {.lex_state = 26, .external_lex_state = 1},
  [264] = {.lex_state = 26, .external_lex_state = 1},
  [265] = {.lex_state = 28, .external_lex_state = 1},
  [266] = {.lex_state = 28, .external_lex_state = 1},
  [267] = {.lex_state = 28, .external_lex_state = 1},
  [268] = {.lex_state = 26, .external_lex_state = 1},
  [269] = {.lex_state = 26, .external_lex_state = 1},
  [270] = {.lex_state = 26, .external_lex_state = 1},
  [271] = {.lex_state = 26, .external_lex_state = 1},
  [272] = {.lex_state = 28, .external_lex_state = 1},
  [273] = {.lex_state = 29, .external_lex_state = 1},
  [274] = {.lex_state = 28, .external_lex_state = 1},
  [275] = {.lex_state = 28, .external_lex_state = 1},
  [276] = {.lex_state = 28, .external_lex_state = 1},
  [277] = {.lex_state = 28, .external_lex_state = 1},
  [278] = {.lex_state = 28, .external_lex_state = 1},
  [279] = {.lex_state = 28, .external_lex_state = 1},
  [280] = {.lex_state = 26, .external_lex_state = 1},
  [281] = {.lex_state = 29, .external_lex_state = 1},
  [282] = {.lex_state = 28, .external_lex_state = 1},
  [283] = {.lex_state = 28, .external_lex_state = 1},
  [284] = {.lex_state = 28, .external_lex_state = 1},
  [285] = {.lex_state = 28, .external_lex_state = 1},
  [286] = {.lex_state = 29, .external_lex_state = 1},
  [287] = {.lex_state = 28, .external_lex_state = 1},
  [288] = {.lex_state = 28, .external_lex_state = 1},
  [289] = {.lex_state = 28, .external_lex_state = 1},
  [290] = {.lex_state = 26, .external_lex_state = 1},
  [291] = {.lex_state = 28, .external_lex_state = 1},
  [292] = {.lex_state = 29, .external_lex_state = 1},
  [293] = {.lex_state = 28, .external_lex_state = 1},
  [294] = {.lex_state = 28, .external_lex_state = 1},
  [295] = {.lex_state = 29, .external_lex_state = 1},
  [296] = {.lex_state = 28, .external_lex_state = 1},
  [297] = {.lex_state = 28, .external_lex_state = 1},
  [298] = {.lex_state = 28, .external_lex_state = 1},
  [299] = {.lex_state = 26, .external_lex_state = 1},
  [300] = {.lex_state = 29, .external_lex_state = 1},
  [301] = {.lex_state = 29, .external_lex_state = 1},
  [302] = {.lex_state = 28, .external_lex_state = 1},
  [303] = {.lex_state = 28, .external_lex_state = 1},
  [304] = {.lex_state = 28, .external_lex_state = 1},
  [305] = {.lex_state = 28, .external_lex_state = 1},
  [306] = {.lex_state = 28, .external_lex_state = 1},
  [307] = {.lex_state = 28, .external_lex_state = 1},
  [308] = {.lex_state = 28, .external_lex_state = 1},
  [309] = {.lex_state = 28, .external_lex_state = 1},
  [310] = {.lex_state = 28, .external_lex_state = 1},
  [311] = {.lex_state = 28, .external_lex_state = 1},
  [312] = {.lex_state = 28, .external_lex_state = 1},
  [313] = {.lex_state = 28, .external_lex_state = 1},
  [314] = {.lex_state = 28, .external_lex_state = 1},
  [315] = {.lex_state = 28, .external_lex_state = 1},
  [316] = {.lex_state = 28, .external_lex_state = 1},
  [317] = {.lex_state = 28, .external_lex_state = 1},
  [318] = {.lex_state = 26, .external_lex_state = 1},
  [319] = {.lex_state = 28, .external_lex_state = 1},
  [320] = {.lex_state = 26, .external_lex_state = 1},
  [321] = {.lex_state = 29, .external_lex_state = 1},
  [322] = {.lex_state = 29, .external_lex_state = 1},
  [323] = {.lex_state = 29, .external_lex_state = 1},
  [324] = {.lex_state = 29, .external_lex_state = 1},
  [325] = {.lex_state = 29, .external_lex_state = 1},
  [326] = {.lex_state = 29, .external_lex_state = 1},
  [327] = {.lex_state = 29, .external_lex_state = 1},
  [328] = {.lex_state = 29, .external_lex_state = 1},
  [329] = {.lex_state = 29, .external_lex_state = 1},
  [330] = {.lex_state = 26, .external_lex_state = 1},
  [331] = {.lex_state = 29, .external_lex_state = 1},
  [332] = {.lex_state = 29, .external_lex_state = 1},
  [333] = {.lex_state = 29, .external_lex_state = 1},
  [334] = {.lex_state = 29, .external_lex_state = 1},
  [335] = {.lex_state = 29, .external_lex_state = 1},
  [336] = {.lex_state = 29, .external_lex_state = 1},
  [337] = {.lex_state = 29, .external_lex_state = 1},
  [338] = {.lex_state = 26, .external_lex_state = 1},
  [339] = {.lex_state = 29, .external_lex_state = 1},
  [340] = {.lex_state = 29, .external_lex_state = 1},
  [341] = {.lex_state = 29, .external_lex_state = 1},
  [342] = {.lex_state = 29, .external_lex_state = 1},
  [343] = {.lex_state = 29, .external_lex_state = 1},
  [344] = {.lex_state = 29, .external_lex_state = 1},
  [345] = {.lex_state = 29, .external_lex_state = 1},
  [346] = {.lex_state = 29, .external_lex_state = 1},
  [347] = {.lex_state = 29, .external_lex_state = 1},
  [348] = {.lex_state = 29, .external_lex_state = 1},
  [349] = {.lex_state = 29, .external_lex_state = 1},
  [350] = {.lex_state = 29, .external_lex_state = 1},
  [351] = {.lex_state = 29, .external_lex_state = 1},
  [352] = {.lex_state = 29, .external_lex_state = 1},
  [353] = {.lex_state = 29, .external_lex_state = 1},
  [354] = {.lex_state = 29, .external_lex_state = 1},
  [355] = {.lex_state = 29, .external_lex_state = 1},
  [356] = {.lex_state = 29, .external_lex_state = 1},
  [357] = {.lex_state = 26, .external_lex_state = 1},
  [358] = {.lex_state = 29, .external_lex_state = 1},
  [359] = {.lex_state = 29, .external_lex_state = 1},
  [360] = {.lex_state = 26, .external_lex_state = 1},
  [361] = {.lex_state = 26, .external_lex_state = 1},
  [362] = {.lex_state = 26, .external_lex_state = 1},
  [363] = {.lex_state = 29, .external_lex_state = 1},
  [364] = {.lex_state = 26, .external_lex_state = 1},
  [365] = {.lex_state = 26, .external_lex_state = 1},
  [366] = {.lex_state = 26, .external_lex_state = 1},
  [367] = {.lex_state = 26, .external_lex_state = 1},
  [368] = {.lex_state = 26, .external_lex_state = 1},
  [369] = {.lex_state = 26, .external_lex_state = 1},
  [370] = {.lex_state = 26, .external_lex_state = 1},
  [371] = {.lex_state = 26, .external_lex_state = 1},
  [372] = {.lex_state = 26, .external_lex_state = 1},
  [373] = {.lex_state = 26, .external_lex_state = 1},
  [374] = {.lex_state = 26, .external_lex_state = 1},
  [375] = {.lex_state = 26, .external_lex_state = 1},
  [376] = {.lex_state = 26, .external_lex_state = 1},
  [377] = {.lex_state = 26, .external_lex_state = 1},
  [378] = {.lex_state = 26, .external_lex_state = 1},
  [379] = {.lex_state = 26, .external_lex_state = 1},
  [380] = {.lex_state = 26, .external_lex_state = 1},
  [381] = {.lex_state = 26, .external_lex_state = 1},
  [382] = {.lex_state = 26, .external_lex_state = 1},
  [383] = {.lex_state = 26, .external_lex_state = 1},
  [384] = {.lex_state = 26, .external_lex_state = 1},
  [385] = {.lex_state = 26, .external_lex_state = 1},
  [386] = {.lex_state = 26, .external_lex_state = 1},
  [387] = {.lex_state = 26, .external_lex_state = 1},
  [388] = {.lex_state = 26, .external_lex_state = 1},
  [389] = {.lex_state = 26, .external_lex_state = 1},
  [390] = {.lex_state = 26, .external_lex_state = 1},
  [391] = {.lex_state = 26, .external_lex_state = 1},
  [392] = {.lex_state = 26, .external_lex_state = 1},
  [393] = {.lex_state = 26, .external_lex_state = 1},
  [394] = {.lex_state = 26, .external_lex_state = 1},
  [395] = {.lex_state = 26, .external_lex_state = 1},
  [396] = {.lex_state = 26, .external_lex_state = 1},
  [397] = {.lex_state = 26, .external_lex_state = 1},
  [398] = {.lex_state = 26, .external_lex_state = 1},
  [399] = {.lex_state = 26, .external_lex_state = 1},
  [400] = {.lex_state = 26, .external_lex_state = 1},
  [401] = {.lex_state = 26, .external_lex_state = 1},
  [402] = {.lex_state = 26, .external_lex_state = 1},
  [403] = {.lex_state = 26, .external_lex_state = 1},
  [404] = {.lex_state = 26, .external_lex_state = 1},
  [405] = {.lex_state = 26, .external_lex_state = 1},
  [406] = {.lex_state = 26, .external_lex_state = 1},
  [407] = {.lex_state = 26, .external_lex_state = 1},
  [408] = {.lex_state = 26, .external_lex_state = 1},
  [409] = {.lex_state = 26, .external_lex_state = 1},
  [410] = {.lex_state = 26, .external_lex_state = 1},
  [411] = {.lex_state = 26, .external_lex_state = 1},
  [412] = {.lex_state = 26, .external_lex_state = 1},
  [413] = {.lex_state = 26, .external_lex_state = 1},
  [414] = {.lex_state = 26, .external_lex_state = 1},
  [415] = {.lex_state = 26, .external_lex_state = 1},
  [416] = {.lex_state = 26, .external_lex_state = 1},
  [417] = {.lex_state = 26, .external_lex_state = 1},
  [418] = {.lex_state = 26, .external_lex_state = 1},
  [419] = {.lex_state = 26, .external_lex_state = 1},
  [420] = {.lex_state = 26, .external_lex_state = 1},
  [421] = {.lex_state = 26, .external_lex_state = 1},
  [422] = {.lex_state = 26, .external_lex_state = 1},
  [423] = {.lex_state = 26, .external_lex_state = 1},
  [424] = {.lex_state = 26, .external_lex_state = 1},
  [425] = {.lex_state = 26, .external_lex_state = 1},
  [426] = {.lex_state = 26, .external_lex_state = 1},
  [427] = {.lex_state = 26, .external_lex_state = 1},
  [428] = {.lex_state = 26, .external_lex_state = 1},
  [429] = {.lex_state = 26, .external_lex_state = 1},
  [430] = {.lex_state = 26, .external_lex_state = 1},
  [431] = {.lex_state = 26, .external_lex_state = 1},
  [432] = {.lex_state = 26, .external_lex_state = 1},
  [433] = {.lex_state = 26, .external_lex_state = 1},
  [434] = {.lex_state = 26, .external_lex_state = 1},
  [435] = {.lex_state = 26, .external_lex_state = 1},
  [436] = {.lex_state = 26, .external_lex_state = 1},
  [437] = {.lex_state = 26, .external_lex_state = 1},
  [438] = {.lex_state = 26, .external_lex_state = 1},
  [439] = {.lex_state = 26, .external_lex_state = 1},
  [440] = {.lex_state = 26, .external_lex_state = 1},
  [441] = {.lex_state = 26, .external_lex_state = 1},
  [442] = {.lex_state = 26, .external_lex_state = 1},
  [443] = {.lex_state = 26, .external_lex_state = 1},
  [444] = {.lex_state = 26, .external_lex_state = 1},
  [445] = {.lex_state = 26, .external_lex_state = 1},
  [446] = {.lex_state = 26, .external_lex_state = 1},
  [447] = {.lex_state = 26, .external_lex_state = 1},
  [448] = {.lex_state = 26, .external_lex_state = 1},
  [449] = {.lex_state = 26, .external_lex_state = 1},
  [450] = {.lex_state = 26, .external_lex_state = 1},
  [451] = {.lex_state = 26, .external_lex_state = 1},
  [452] = {.lex_state = 29, .external_lex_state = 1},
  [453] = {.lex_state = 29, .external_lex_state = 1},
  [454] = {.lex_state = 29, .external_lex_state = 1},
  [455] = {.lex_state = 29, .external_lex_state = 1},
  [456] = {.lex_state = 29, .external_lex_state = 1},
  [457] = {.lex_state = 29, .external_lex_state = 1},
  [458] = {.lex_state = 29, .external_lex_state = 1},
  [459] = {.lex_state = 29, .external_lex_state = 1},
  [460] = {.lex_state = 29, .external_lex_state = 1},
  [461] = {.lex_state = 28, .external_lex_state = 1},
  [462] = {.lex_state = 28, .external_lex_state = 1},
  [463] = {.lex_state = 29, .external_lex_state = 1},
  [464] = {.lex_state = 29, .external_lex_state = 1},
  [465] = {.lex_state = 29, .external_lex_state = 1},
  [466] = {.lex_state = 28, .external_lex_state = 1},
  [467] = {.lex_state = 29, .external_lex_state = 1},
  [468] = {.lex_state = 29, .external_lex_state = 1},
  [469] = {.lex_state = 29, .external_lex_state = 1},
  [470] = {.lex_state = 29, .external_lex_state = 1},
  [471] = {.lex_state = 29, .external_lex_state = 1},
  [472] = {.lex_state = 28, .external_lex_state = 1},
  [473] = {.lex_state = 29, .external_lex_state = 1},
  [474] = {.lex_state = 28, .external_lex_state = 1},
  [475] = {.lex_state = 29, .external_lex_state = 1},
  [476] = {.lex_state = 29, .external_lex_state = 1},
  [477] = {.lex_state = 29, .external_lex_state = 1},
  [478] = {.lex_state = 29, .external_lex_state = 1},
  [479] = {.lex_state = 29, .external_lex_state = 1},
  [480] = {.lex_state = 29, .external_lex_state = 1},
  [481] = {.lex_state = 29, .external_lex_state = 1},
  [482] = {.lex_state = 28, .external_lex_state = 1},
  [483] = {.lex_state = 29, .external_lex_state = 1},
  [484] = {.lex_state = 29, .external_lex_state = 1},
  [485] = {.lex_state = 29, .external_lex_state = 1},
  [486] = {.lex_state = 29, .external_lex_state = 1},
  [487] = {.lex_state = 29, .external_lex_state = 1},
  [488] = {.lex_state = 29, .external_lex_state = 1},
  [489] = {.lex_state = 29, .external_lex_state = 1},
  [490] = {.lex_state = 29, .external_lex_state = 1},
  [491] = {.lex_state = 29, .external_lex_state = 1},
  [492] = {.lex_state = 29, .external_lex_state = 1},
  [493] = {.lex_state = 28, .external_lex_state = 1},
  [494] = {.lex_state = 29, .external_lex_state = 1},
  [495] = {.lex_state = 29, .external_lex_state = 1},
  [496] = {.lex_state = 29, .external_lex_state = 1},
  [497] = {.lex_state = 29, .external_lex_state = 1},
  [498] = {.lex_state = 29, .external_lex_state = 1},
  [499] = {.lex_state = 29, .external_lex_state = 1},
  [500] = {.lex_state = 29, .external_lex_state = 1},
  [501] = {.lex_state = 29, .external_lex_state = 1},
  [502] = {.lex_state = 29, .external_lex_state = 1},
  [503] = {.lex_state = 29, .external_lex_state = 1},
  [504] = {.lex_state = 29, .external_lex_state = 1},
  [505] = {.lex_state = 28, .external_lex_state = 1},
  [506] = {.lex_state = 29, .external_lex_state = 1},
  [507] = {.lex_state = 29, .external_lex_state = 1},
  [508] = {.lex_state = 28, .external_lex_state = 1},
  [509] = {.lex_state = 29, .external_lex_state = 1},
  [510] = {.lex_state = 29, .external_lex_state = 1},
  [511] = {.lex_state = 28, .external_lex_state = 1},
  [512] = {.lex_state = 29, .external_lex_state = 1},
  [513] = {.lex_state = 29, .external_lex_state = 1},
  [514] = {.lex_state = 29, .external_lex_state = 1},
  [515] = {.lex_state = 29, .external_lex_state = 1},
  [516] = {.lex_state = 28, .external_lex_state = 1},
  [517] = {.lex_state = 28, .external_lex_state = 1},
  [518] = {.lex_state = 28, .external_lex_state = 1},
  [519] = {.lex_state = 29, .external_lex_state = 1},
  [520] = {.lex_state = 28, .external_lex_state = 1},
  [521] = {.lex_state = 28, .external_lex_state = 1},
  [522] = {.lex_state = 28, .external_lex_state = 1},
  [523] = {.lex_state = 29, .external_lex_state = 1},
  [524] = {.lex_state = 29, .external_lex_state = 1},
  [525] = {.lex_state = 28, .external_lex_state = 1},
  [526] = {.lex_state = 29, .external_lex_state = 1},
  [527] = {.lex_state = 28, .external_lex_state = 1},
  [528] = {.lex_state = 28, .external_lex_state = 1},
  [529] = {.lex_state = 28, .external_lex_state = 1},
  [530] = {.lex_state = 28, .external_lex_state = 1},
  [531] = {.lex_state = 29, .external_lex_state = 1},
  [532] = {.lex_state = 28, .external_lex_state = 1},
  [533] = {.lex_state = 29, .external_lex_state = 1},
  [534] = {.lex_state = 28, .external_lex_state = 1},
  [535] = {.lex_state = 28, .external_lex_state = 1},
  [536] = {.lex_state = 28, .external_lex_state = 1},
  [537] = {.lex_state = 29, .external_lex_state = 1},
  [538] = {.lex_state = 28, .external_lex_state = 1},
  [539] = {.lex_state = 28, .external_lex_state = 1},
  [540] = {.lex_state = 28, .external_lex_state = 1},
  [541] = {.lex_state = 28, .external_lex_state = 1},
  [542] = {.lex_state = 28, .external_lex_state = 1},
  [543] = {.lex_state = 28, .external_lex_state = 1},
  [544] = {.lex_state = 29, .external_lex_state = 1},
  [545] = {.lex_state = 29, .external_lex_state = 1},
  [546] = {.lex_state = 28, .external_lex_state = 1},
  [547] = {.lex_state = 29, .external_lex_state = 1},
  [548] = {.lex_state = 28, .external_lex_state = 1},
  [549] = {.lex_state = 28, .external_lex_state = 1},
  [550] = {.lex_state = 29, .external_lex_state = 1},
  [551] = {.lex_state = 28, .external_lex_state = 1},
  [552] = {.lex_state = 28, .external_lex_state = 1},
  [553] = {.lex_state = 28, .external_lex_state = 1},
  [554] = {.lex_state = 28, .external_lex_state = 1},
  [555] = {.lex_state = 28, .external_lex_state = 1},
  [556] = {.lex_state = 28, .external_lex_state = 1},
  [557] = {.lex_state = 28, .external_lex_state = 1},
  [558] = {.lex_state = 29, .external_lex_state = 1},
  [559] = {.lex_state = 29, .external_lex_state = 1},
  [560] = {.lex_state = 29, .external_lex_state = 1},
  [561] = {.lex_state = 28, .external_lex_state = 1},
  [562] = {.lex_state = 29, .external_lex_state = 1},
  [563] = {.lex_state = 29, .external_lex_state = 1},
  [564] = {.lex_state = 29, .external_lex_state = 1},
  [565] = {.lex_state = 29, .external_lex_state = 1},
  [566] = {.lex_state = 29, .external_lex_state = 1},
  [567] = {.lex_state = 29, .external_lex_state = 1},
  [568] = {.lex_state = 29, .external_lex_state = 1},
  [569] = {.lex_state = 29, .external_lex_state = 1},
  [570] = {.lex_state = 29, .external_lex_state = 1},
  [571] = {.lex_state = 29, .external_lex_state = 1},
  [572] = {.lex_state = 29, .external_lex_state = 1},
  [573] = {.lex_state = 29, .external_lex_state = 1},
  [574] = {.lex_state = 29, .external_lex_state = 1},
  [575] = {.lex_state = 29, .external_lex_state = 1},
  [576] = {.lex_state = 29, .external_lex_state = 1},
  [577] = {.lex_state = 29, .external_lex_state = 1},
  [578] = {.lex_state = 29, .external_lex_state = 1},
  [579] = {.lex_state = 29, .external_lex_state = 1},
  [580] = {.lex_state = 29, .external_lex_state = 1},
  [581] = {.lex_state = 29, .external_lex_state = 1},
  [582] = {.lex_state = 29, .external_lex_state = 1},
  [583] = {.lex_state = 29, .external_lex_state = 1},
  [584] = {.lex_state = 29, .external_lex_state = 1},
  [585] = {.lex_state = 29, .external_lex_state = 1},
  [586] = {.lex_state = 29, .external_lex_state = 1},
  [587] = {.lex_state = 29, .external_lex_state = 1},
  [588] = {.lex_state = 27, .external_lex_state = 1},
  [589] = {.lex_state = 27, .external_lex_state = 1},
  [590] = {.lex_state = 34, .external_lex_state = 1},
  [591] = {.lex_state = 30, .external_lex_state = 1},
  [592] = {.lex_state = 34, .external_lex_state = 1},
  [593] = {.lex_state = 27, .external_lex_state = 1},
  [594] = {.lex_state = 34, .external_lex_state = 1},
  [595] = {.lex_state = 26, .external_lex_state = 1},
  [596] = {.lex_state = 26, .external_lex_state = 1},
  [597] = {.lex_state = 30, .external_lex_state = 1},
  [598] = {.lex_state = 26, .external_lex_state = 1},
  [599] = {.lex_state = 26, .external_lex_state = 1},
  [600] = {.lex_state = 26, .external_lex_state = 1},
  [601] = {.lex_state = 31, .external_lex_state = 1},
  [602] = {.lex_state = 31, .external_lex_state = 1},
  [603] = {.lex_state = 26, .external_lex_state = 1},
  [604] = {.lex_state = 26, .external_lex_state = 1},
  [605] = {.lex_state = 26, .external_lex_state = 1},
  [606] = {.lex_state = 26, .external_lex_state = 1},
  [607] = {.lex_state = 26, .external_lex_state = 1},
  [608] = {.lex_state = 26, .external_lex_state = 1},
  [609] = {.lex_state = 26, .external_lex_state = 1},
  [610] = {.lex_state = 26, .external_lex_state = 1},
  [611] = {.lex_state = 31, .external_lex_state = 1},
  [612] = {.lex_state = 31, .external_lex_state = 1},
  [613] = {.lex_state = 31, .external_lex_state = 1},
  [614] = {.lex_state = 26, .external_lex_state = 1},
  [615] = {.lex_state = 26, .external_lex_state = 1},
  [616] = {.lex_state = 31, .external_lex_state = 1},
  [617] = {.lex_state = 26, .external_lex_state = 1},
  [618] = {.lex_state = 31, .external_lex_state = 1},
  [619] = {.lex_state = 31, .external_lex_state = 1},
  [620] = {.lex_state = 31, .external_lex_state = 1},
  [621] = {.lex_state = 31, .external_lex_state = 1},
  [622] = {.lex_state = 31, .external_lex_state = 1},
  [623] = {.lex_state = 31, .external_lex_state = 1},
  [624] = {.lex_state = 26, .external_lex_state = 1},
  [625] = {.lex_state = 26, .external_lex_state = 1},
  [626] = {.lex_state = 26, .external_lex_state = 1},
  [627] = {.lex_state = 26, .external_lex_state = 1},
  [628] = {.lex_state = 26, .external_lex_state = 1},
  [629] = {.lex_state = 26, .external_lex_state = 1},
  [630] = {.lex_state = 26, .external_lex_state = 1},
  [631] = {.lex_state = 26, .external_lex_state = 1},
  [632] = {.lex_state = 26, .external_lex_state = 1},
  [633] = {.lex_state = 26, .external_lex_state = 1},
  [634] = {.lex_state = 26, .external_lex_state = 1},
  [635] = {.lex_state = 26, .external_lex_state = 1},
  [636] = {.lex_state = 26, .external_lex_state = 1},
  [637] = {.lex_state = 26, .external_lex_state = 1},
  [638] = {.lex_state = 26, .external_lex_state = 1},
  [639] = {.lex_state = 26, .external_lex_state = 1},
  [640] = {.lex_state = 26, .external_lex_state = 1},
  [641] = {.lex_state = 26, .external_lex_state = 1},
  [642] = {.lex_state = 26, .external_lex_state = 1},
  [643] = {.lex_state = 26, .external_lex_state = 1},
  [644] = {.lex_state = 26, .external_lex_state = 1},
  [645] = {.lex_state = 30, .external_lex_state = 1},
  [646] = {.lex_state = 26, .external_lex_state = 1},
  [647] = {.lex_state = 26, .external_lex_state = 1},
  [648] = {.lex_state = 26, .external_lex_state = 1},
  [649] = {.lex_state = 26, .external_lex_state = 1},
  [650] = {.lex_state = 26, .external_lex_state = 1},
  [651] = {.lex_state = 26, .external_lex_state = 1},
  [652] = {.lex_state = 26, .external_lex_state = 1},
  [653] = {.lex_state = 26, .external_lex_state = 1},
  [654] = {.lex_state = 26, .external_lex_state = 1},
  [655] = {.lex_state = 26, .external_lex_state = 1},
  [656] = {.lex_state = 26, .external_lex_state = 1},
  [657] = {.lex_state = 26, .external_lex_state = 1},
  [658] = {.lex_state = 31, .external_lex_state = 1},
  [659] = {.lex_state = 26, .external_lex_state = 1},
  [660] = {.lex_state = 26, .external_lex_state = 1},
  [661] = {.lex_state = 33, .external_lex_state = 1},
  [662] = {.lex_state = 26, .external_lex_state = 1},
  [663] = {.lex_state = 26, .external_lex_state = 1},
  [664] = {.lex_state = 31, .external_lex_state = 1},
  [665] = {.lex_state = 26, .external_lex_state = 1},
  [666] = {.lex_state = 31, .external_lex_state = 1},
  [667] = {.lex_state = 26, .external_lex_state = 1},
  [668] = {.lex_state = 33, .external_lex_state = 1},
  [669] = {.lex_state = 26, .external_lex_state = 1},
  [670] = {.lex_state = 26, .external_lex_state = 1},
  [671] = {.lex_state = 31, .external_lex_state = 1},
  [672] = {.lex_state = 26, .external_lex_state = 1},
  [673] = {.lex_state = 26, .external_lex_state = 1},
  [674] = {.lex_state = 31, .external_lex_state = 1},
  [675] = {.lex_state = 26, .external_lex_state = 1},
  [676] = {.lex_state = 31, .external_lex_state = 1},
  [677] = {.lex_state = 31, .external_lex_state = 1},
  [678] = {.lex_state = 26, .external_lex_state = 1},
  [679] = {.lex_state = 31, .external_lex_state = 1},
  [680] = {.lex_state = 31, .external_lex_state = 1},
  [681] = {.lex_state = 31, .external_lex_state = 1},
  [682] = {.lex_state = 26, .external_lex_state = 1},
  [683] = {.lex_state = 26, .external_lex_state = 1},
  [684] = {.lex_state = 31, .external_lex_state = 1},
  [685] = {.lex_state = 31, .external_lex_state = 1},
  [686] = {.lex_state = 26, .external_lex_state = 1},
  [687] = {.lex_state = 26, .external_lex_state = 1},
  [688] = {.lex_state = 31, .external_lex_state = 1},
  [689] = {.lex_state = 31, .external_lex_state = 1},
  [690] = {.lex_state = 26, .external_lex_state = 1},
  [691] = {.lex_state = 33, .external_lex_state = 1},
  [692] = {.lex_state = 26, .external_lex_state = 1},
  [693] = {.lex_state = 31, .external_lex_state = 1},
  [694] = {.lex_state = 31, .external_lex_state = 1},
  [695] = {.lex_state = 26, .external_lex_state = 1},
  [696] = {.lex_state = 0, .external_lex_state = 1},
  [697] = {.lex_state = 0, .external_lex_state = 1},
  [698] = {.lex_state = 33, .external_lex_state = 1},
  [699] = {.lex_state = 31, .external_lex_state = 1},
  [700] = {.lex_state = 31, .external_lex_state = 1},
  [701] = {.lex_state = 31, .external_lex_state = 1},
  [702] = {.lex_state = 31, .external_lex_state = 1},
  [703] = {.lex_state = 31, .external_lex_state = 1},
  [704] = {.lex_state = 33, .external_lex_state = 1},
  [705] = {.lex_state = 31, .external_lex_state = 1},
  [706] = {.lex_state = 31, .external_lex_state = 1},
  [707] = {.lex_state = 31, .external_lex_state = 1},
  [708] = {.lex_state = 27, .external_lex_state = 1},
  [709] = {.lex_state = 33, .external_lex_state = 1},
  [710] = {.lex_state = 33, .external_lex_state = 1},
  [711] = {.lex_state = 27, .external_lex_state = 1},
  [712] = {.lex_state = 0, .external_lex_state = 1},
  [713] = {.lex_state = 31, .external_lex_state = 1},
  [714] = {.lex_state = 33, .external_lex_state = 1},
  [715] = {.lex_state = 26, .external_lex_state = 1},
  [716] = {.lex_state = 31, .external_lex_state = 1},
  [717] = {.lex_state = 27, .external_lex_state = 1},
  [718] = {.lex_state = 31, .external_lex_state = 1},
  [719] = {.lex_state = 33, .external_lex_state = 1},
  [720] = {.lex_state = 33, .external_lex_state = 1},
  [721] = {.lex_state = 57, .external_lex_state = 1},
  [722] = {.lex_state = 0, .external_lex_state = 1},
  [723] = {.lex_state = 33, .external_lex_state = 1},
  [724] = {.lex_state = 57, .external_lex_state = 1},
  [725] = {.lex_state = 0, .external_lex_state = 1},
  [726] = {.lex_state = 0, .external_lex_state = 1},
  [727] = {.lex_state = 58, .external_lex_state = 1},
  [728] = {.lex_state = 0, .external_lex_state = 1},
  [729] = {.lex_state = 58, .external_lex_state = 1},
  [730] = {.lex_state = 33, .external_lex_state = 1},
  [731] = {.lex_state = 33, .external_lex_state = 1},
  [732] = {.lex_state = 26, .external_lex_state = 1},
  [733] = {.lex_state = 26, .external_lex_state = 1},
  [734] = {.lex_state = 26, .external_lex_state = 1},
  [735] = {.lex_state = 57, .external_lex_state = 1},
  [736] = {.lex_state = 33, .external_lex_state = 1},
  [737] = {.lex_state = 30, .external_lex_state = 1},
  [738] = {.lex_state = 26, .external_lex_state = 1},
  [739] = {.lex_state = 26, .external_lex_state = 1},
  [740] = {.lex_state = 26, .external_lex_state = 1},
  [741] = {.lex_state = 26, .external_lex_state = 1},
  [742] = {.lex_state = 26, .external_lex_state = 1},
  [743] = {.lex_state = 26, .external_lex_state = 1},
  [744] = {.lex_state = 26, .external_lex_state = 1},
  [745] = {.lex_state = 26, .external_lex_state = 1},
  [746] = {.lex_state = 57, .external_lex_state = 1},
  [747] = {.lex_state = 26, .external_lex_state = 1},
  [748] = {.lex_state = 26, .external_lex_state = 1},
  [749] = {.lex_state = 26, .external_lex_state = 1},
  [750] = {.lex_state = 26, .external_lex_state = 1},
  [751] = {.lex_state = 58, .external_lex_state = 1},
  [752] = {.lex_state = 26, .external_lex_state = 1},
  [753] = {.lex_state = 58, .external_lex_state = 1},
  [754] = {.lex_state = 26, .external_lex_state = 1},
  [755] = {.lex_state = 26, .external_lex_state = 1},
  [756] = {.lex_state = 26, .external_lex_state = 1},
  [757] = {.lex_state = 0, .external_lex_state = 1},
  [758] = {.lex_state = 0, .external_lex_state = 1},
  [759] = {.lex_state = 0, .external_lex_state = 1},
  [760] = {.lex_state = 0, .external_lex_state = 1},
  [761] = {.lex_state = 26, .external_lex_state = 1},
  [762] = {.lex_state = 0, .external_lex_state = 1},
  [763] = {.lex_state = 26, .external_lex_state = 1},
  [764] = {.lex_state = 26, .external_lex_state = 1},
  [765] = {.lex_state = 0, .external_lex_state = 1},
  [766] = {.lex_state = 26, .external_lex_state = 1},
  [767] = {.lex_state = 26, .external_lex_state = 1},
  [768] = {.lex_state = 0, .external_lex_state = 1},
  [769] = {.lex_state = 26, .external_lex_state = 1},
  [770] = {.lex_state = 0, .external_lex_state = 1},
  [771] = {.lex_state = 0, .external_lex_state = 1},
  [772] = {.lex_state = 26, .external_lex_state = 1},
  [773] = {.lex_state = 0, .external_lex_state = 1},
  [774] = {.lex_state = 0, .external_lex_state = 1},
  [775] = {.lex_state = 0, .external_lex_state = 1},
  [776] = {.lex_state = 26, .external_lex_state = 1},
  [777] = {.lex_state = 0, .external_lex_state = 1},
  [778] = {.lex_state = 0, .external_lex_state = 1},
  [779] = {.lex_state = 0, .external_lex_state = 1},
  [780] = {.lex_state = 27, .external_lex_state = 1},
  [781] = {.lex_state = 0, .external_lex_state = 1},
  [782] = {.lex_state = 0, .external_lex_state = 1},
  [783] = {.lex_state = 26, .external_lex_state = 1},
  [784] = {.lex_state = 0, .external_lex_state = 1},
  [785] = {.lex_state = 26, .external_lex_state = 1},
  [786] = {.lex_state = 27, .external_lex_state = 1},
  [787] = {.lex_state = 26, .external_lex_state = 1},
  [788] = {.lex_state = 26, .external_lex_state = 1},
  [789] = {.lex_state = 26, .external_lex_state = 1},
  [790] = {.lex_state = 26, .external_lex_state = 1},
  [791] = {.lex_state = 26, .external_lex_state = 1},
  [792] = {.lex_state = 26, .external_lex_state = 1},
  [793] = {.lex_state = 26, .external_lex_state = 1},
  [794] = {.lex_state = 26, .external_lex_state = 1},
  [795] = {.lex_state = 26, .external_lex_state = 1},
  [796] = {.lex_state = 26, .external_lex_state = 1},
  [797] = {.lex_state = 26, .external_lex_state = 1},
  [798] = {.lex_state = 26, .external_lex_state = 1},
  [799] = {.lex_state = 26, .external_lex_state = 1},
  [800] = {.lex_state = 26, .external_lex_state = 1},
  [801] = {.lex_state = 26, .external_lex_state = 1},
  [802] = {.lex_state = 26, .external_lex_state = 1},
  [803] = {.lex_state = 26, .external_lex_state = 1},
  [804] = {.lex_state = 26, .external_lex_state = 1},
  [805] = {.lex_state = 26, .external_lex_state = 1},
  [806] = {.lex_state = 26, .external_lex_state = 1},
  [807] = {.lex_state = 26, .external_lex_state = 1},
  [808] = {.lex_state = 26, .external_lex_state = 1},
  [809] = {.lex_state = 26, .external_lex_state = 1},
  [810] = {.lex_state = 26, .external_lex_state = 1},
  [811] = {.lex_state = 26, .external_lex_state = 1},
  [812] = {.lex_state = 26, .external_lex_state = 1},
  [813] = {.lex_state = 26, .external_lex_state = 1},
  [814] = {.lex_state = 26, .external_lex_state = 1},
  [815] = {.lex_state = 26, .external_lex_state = 1},
  [816] = {.lex_state = 26, .external_lex_state = 1},
  [817] = {.lex_state = 26, .external_lex_state = 1},
  [818] = {.lex_state = 26, .external_lex_state = 1},
  [819] = {.lex_state = 26, .external_lex_state = 1},
  [820] = {.lex_state = 0, .external_lex_state = 1},
  [821] = {.lex_state = 26, .external_lex_state = 1},
  [822] = {.lex_state = 26, .external_lex_state = 1},
  [823] = {.lex_state = 26, .external_lex_state = 1},
  [824] = {.lex_state = 26, .external_lex_state = 1},
  [825] = {.lex_state = 26, .external_lex_state = 1},
  [826] = {.lex_state = 26, .external_lex_state = 1},
  [827] = {.lex_state = 26, .external_lex_state = 1},
  [828] = {.lex_state = 26, .external_lex_state = 1},
  [829] = {.lex_state = 26, .external_lex_state = 1},
  [830] = {.lex_state = 26, .external_lex_state = 1},
  [831] = {.lex_state = 0, .external_lex_state = 1},
  [832] = {.lex_state = 26, .external_lex_state = 1},
  [833] = {.lex_state = 26, .external_lex_state = 1},
  [834] = {.lex_state = 26, .external_lex_state = 1},
  [835] = {.lex_state = 26, .external_lex_state = 1},
  [836] = {.lex_state = 26, .external_lex_state = 1},
  [837] = {.lex_state = 26, .external_lex_state = 1},
  [838] = {.lex_state = 26, .external_lex_state = 1},
  [839] = {.lex_state = 26, .external_lex_state = 1},
  [840] = {.lex_state = 26, .external_lex_state = 1},
  [841] = {.lex_state = 26, .external_lex_state = 1},
  [842] = {.lex_state = 26, .external_lex_state = 1},
  [843] = {.lex_state = 26, .external_lex_state = 1},
  [844] = {.lex_state = 26, .external_lex_state = 1},
  [845] = {.lex_state = 26, .external_lex_state = 1},
  [846] = {.lex_state = 26, .external_lex_state = 1},
  [847] = {.lex_state = 26, .external_lex_state = 1},
  [848] = {.lex_state = 26, .external_lex_state = 1},
  [849] = {.lex_state = 28, .external_lex_state = 1},
  [850] = {.lex_state = 26, .external_lex_state = 1},
  [851] = {.lex_state = 26, .external_lex_state = 1},
  [852] = {.lex_state = 26, .external_lex_state = 1},
  [853] = {.lex_state = 0, .external_lex_state = 1},
  [854] = {.lex_state = 26, .external_lex_state = 1},
  [855] = {.lex_state = 26, .external_lex_state = 1},
  [856] = {.lex_state = 0, .external_lex_state = 1},
  [857] = {.lex_state = 26, .external_lex_state = 1},
  [858] = {.lex_state = 26, .external_lex_state = 1},
  [859] = {.lex_state = 32, .external_lex_state = 1},
  [860] = {.lex_state = 0, .external_lex_state = 1},
  [861] = {.lex_state = 26, .external_lex_state = 1},
  [862] = {.lex_state = 26, .external_lex_state = 1},
  [863] = {.lex_state = 0, .external_lex_state = 1},
  [864] = {.lex_state = 26, .external_lex_state = 1},
  [865] = {.lex_state = 26, .external_lex_state = 1},
  [866] = {.lex_state = 26, .external_lex_state = 1},
  [867] = {.lex_state = 26, .external_lex_state = 1},
  [868] = {.lex_state = 0, .external_lex_state = 1},
  [869] = {.lex_state = 28, .external_lex_state = 1},
  [870] = {.lex_state = 26, .external_lex_state = 1},
  [871] = {.lex_state = 28, .external_lex_state = 1},
  [872] = {.lex_state = 26, .external_lex_state = 1},
  [873] = {.lex_state = 26, .external_lex_state = 1},
  [874] = {.lex_state = 26, .external_lex_state = 1},
  [875] = {.lex_state = 28, .external_lex_state = 1},
  [876] = {.lex_state = 26, .external_lex_state = 1},
  [877] = {.lex_state = 26, .external_lex_state = 1},
  [878] = {.lex_state = 26, .external_lex_state = 1},
  [879] = {.lex_state = 0, .external_lex_state = 1},
  [880] = {.lex_state = 28, .external_lex_state = 1},
  [881] = {.lex_state = 0, .external_lex_state = 1},
  [882] = {.lex_state = 26, .external_lex_state = 1},
  [883] = {.lex_state = 0, .external_lex_state = 1},
  [884] = {.lex_state = 26, .external_lex_state = 1},
  [885] = {.lex_state = 26, .external_lex_state = 1},
  [886] = {.lex_state = 0, .external_lex_state = 1},
  [887] = {.lex_state = 26, .external_lex_state = 1},
  [888] = {.lex_state = 28, .external_lex_state = 1},
  [889] = {.lex_state = 0, .external_lex_state = 1},
  [890] = {.lex_state = 28, .external_lex_state = 1},
  [891] = {.lex_state = 26, .external_lex_state = 1},
  [892] = {.lex_state = 0, .external_lex_state = 1},
  [893] = {.lex_state = 0, .external_lex_state = 1},
  [894] = {.lex_state = 0, .external_lex_state = 1},
  [895] = {.lex_state = 0, .external_lex_state = 1},
  [896] = {.lex_state = 0, .external_lex_state = 1},
  [897] = {.lex_state = 28, .external_lex_state = 1},
  [898] = {.lex_state = 0, .external_lex_state = 1},
  [899] = {.lex_state = 323, .external_lex_state = 1},
  [900] = {.lex_state = 0, .external_lex_state = 1},
  [901] = {.lex_state = 0, .external_lex_state = 1},
  [902] = {.lex_state = 323, .external_lex_state = 1},
  [903] = {.lex_state = 0, .external_lex_state = 1},
  [904] = {.lex_state = 0, .external_lex_state = 1},
  [905] = {.lex_state = 28, .external_lex_state = 1},
  [906] = {.lex_state = 28, .external_lex_state = 1},
  [907] = {.lex_state = 0, .external_lex_state = 1},
  [908] = {.lex_state = 0, .external_lex_state = 1},
  [909] = {.lex_state = 28, .external_lex_state = 1},
  [910] = {.lex_state = 0, .external_lex_state = 1},
  [911] = {.lex_state = 26, .external_lex_state = 1},
  [912] = {.lex_state = 26, .external_lex_state = 1},
  [913] = {.lex_state = 26, .external_lex_state = 1},
  [914] = {.lex_state = 26, .external_lex_state = 1},
  [915] = {.lex_state = 0, .external_lex_state = 1},
  [916] = {.lex_state = 26, .external_lex_state = 1},
  [917] = {.lex_state = 0, .external_lex_state = 1},
  [918] = {.lex_state = 0, .external_lex_state = 1},
  [919] = {.lex_state = 26, .external_lex_state = 1},
  [920] = {.lex_state = 26, .external_lex_state = 1},
  [921] = {.lex_state = 0, .external_lex_state = 1},
  [922] = {.lex_state = 26, .external_lex_state = 1},
  [923] = {.lex_state = 0, .external_lex_state = 1},
  [924] = {.lex_state = 0, .external_lex_state = 1},
  [925] = {.lex_state = 28, .external_lex_state = 1},
  [926] = {.lex_state = 26, .external_lex_state = 1},
  [927] = {.lex_state = 26, .external_lex_state = 1},
  [928] = {.lex_state = 323, .external_lex_state = 1},
  [929] = {.lex_state = 323, .external_lex_state = 1},
  [930] = {.lex_state = 0, .external_lex_state = 1},
  [931] = {.lex_state = 0, .external_lex_state = 1},
  [932] = {.lex_state = 0, .external_lex_state = 1},
  [933] = {.lex_state = 26, .external_lex_state = 1},
  [934] = {.lex_state = 28, .external_lex_state = 1},
  [935] = {.lex_state = 26, .external_lex_state = 1},
  [936] = {.lex_state = 0, .external_lex_state = 1},
  [937] = {.lex_state = 323, .external_lex_state = 1},
  [938] = {.lex_state = 28, .external_lex_state = 1},
  [939] = {.lex_state = 0, .external_lex_state = 1},
  [940] = {.lex_state = 0, .external_lex_state = 1},
  [941] = {.lex_state = 0, .external_lex_state = 1},
  [942] = {.lex_state = 0, .external_lex_state = 1},
  [943] = {.lex_state = 0, .external_lex_state = 1},
  [944] = {.lex_state = 26, .external_lex_state = 1},
  [945] = {.lex_state = 0, .external_lex_state = 1},
  [946] = {.lex_state = 0, .external_lex_state = 1},
  [947] = {.lex_state = 0, .external_lex_state = 1},
  [948] = {.lex_state = 0, .external_lex_state = 1},
  [949] = {.lex_state = 0, .external_lex_state = 1},
  [950] = {.lex_state = 0, .external_lex_state = 1},
  [951] = {.lex_state = 0, .external_lex_state = 1},
  [952] = {.lex_state = 323, .external_lex_state = 1},
  [953] = {.lex_state = 26, .external_lex_state = 1},
  [954] = {.lex_state = 26, .external_lex_state = 1},
  [955] = {.lex_state = 0, .external_lex_state = 1},
  [956] = {.lex_state = 0, .external_lex_state = 1},
  [957] = {.lex_state = 0, .external_lex_state = 1},
  [958] = {.lex_state = 0, .external_lex_state = 1},
  [959] = {.lex_state = 28, .external_lex_state = 1},
  [960] = {.lex_state = 26, .external_lex_state = 1},
  [961] = {.lex_state = 28, .external_lex_state = 1},
  [962] = {.lex_state = 323, .external_lex_state = 1},
  [963] = {.lex_state = 0, .external_lex_state = 1},
  [964] = {.lex_state = 0, .external_lex_state = 1},
  [965] = {.lex_state = 0, .external_lex_state = 1},
  [966] = {.lex_state = 26, .external_lex_state = 1},
  [967] = {.lex_state = 26, .external_lex_state = 1},
  [968] = {.lex_state = 323, .external_lex_state = 1},
  [969] = {.lex_state = 0, .external_lex_state = 1},
  [970] = {.lex_state = 323, .external_lex_state = 1},
  [971] = {.lex_state = 26, .external_lex_state = 1},
  [972] = {.lex_state = 26, .external_lex_state = 1},
  [973] = {.lex_state = 0, .external_lex_state = 1},
  [974] = {.lex_state = 26, .external_lex_state = 1},
  [975] = {.lex_state = 0, .external_lex_state = 1},
  [976] = {.lex_state = 0, .external_lex_state = 1},
  [977] = {.lex_state = 26, .external_lex_state = 1},
  [978] = {.lex_state = 26, .external_lex_state = 1},
  [979] = {.lex_state = 28, .external_lex_state = 1},
  [980] = {.lex_state = 0, .external_lex_state = 1},
  [981] = {.lex_state = 26, .external_lex_state = 1},
  [982] = {.lex_state = 26, .external_lex_state = 1},
  [983] = {.lex_state = 26, .external_lex_state = 1},
  [984] = {.lex_state = 26, .external_lex_state = 1},
  [985] = {.lex_state = 26, .external_lex_state = 1},
  [986] = {.lex_state = 0, .external_lex_state = 1},
  [987] = {.lex_state = 0, .external_lex_state = 1},
  [988] = {.lex_state = 0, .external_lex_state = 1},
  [989] = {.lex_state = 26, .external_lex_state = 1},
  [990] = {.lex_state = 28, .external_lex_state = 1},
  [991] = {.lex_state = 0, .external_lex_state = 1},
  [992] = {.lex_state = 0, .external_lex_state = 1},
  [993] = {.lex_state = 0, .external_lex_state = 1},
  [994] = {.lex_state = 26, .external_lex_state = 1},
  [995] = {.lex_state = 26, .external_lex_state = 1},
  [996] = {.lex_state = 0, .external_lex_state = 1},
  [997] = {.lex_state = 0, .external_lex_state = 1},
  [998] = {.lex_state = 0, .external_lex_state = 1},
  [999] = {.lex_state = 26, .external_lex_state = 1},
  [1000] = {.lex_state = 0, .external_lex_state = 1},
  [1001] = {.lex_state = 0, .external_lex_state = 1},
  [1002] = {.lex_state = 26, .external_lex_state = 1},
  [1003] = {.lex_state = 26, .external_lex_state = 1},
  [1004] = {.lex_state = 0, .external_lex_state = 1},
  [1005] = {.lex_state = 0, .external_lex_state = 1},
  [1006] = {.lex_state = 0, .external_lex_state = 1},
  [1007] = {.lex_state = 0, .external_lex_state = 1},
  [1008] = {.lex_state = 0, .external_lex_state = 1},
  [1009] = {.lex_state = 32, .external_lex_state = 1},
  [1010] = {.lex_state = 26, .external_lex_state = 1},
  [1011] = {.lex_state = 26, .external_lex_state = 1},
  [1012] = {.lex_state = 0, .external_lex_state = 1},
  [1013] = {.lex_state = 0, .external_lex_state = 1},
  [1014] = {.lex_state = 26, .external_lex_state = 1},
  [1015] = {.lex_state = 26, .external_lex_state = 1},
  [1016] = {.lex_state = 0, .external_lex_state = 1},
  [1017] = {.lex_state = 26, .external_lex_state = 1},
  [1018] = {.lex_state = 0, .external_lex_state = 1},
  [1019] = {.lex_state = 0, .external_lex_state = 1},
  [1020] = {.lex_state = 26, .external_lex_state = 1},
  [1021] = {.lex_state = 26, .external_lex_state = 1},
  [1022] = {.lex_state = 0, .external_lex_state = 1},
  [1023] = {.lex_state = 28, .external_lex_state = 1},
  [1024] = {.lex_state = 26, .external_lex_state = 1},
  [1025] = {.lex_state = 26, .external_lex_state = 1},
  [1026] = {.lex_state = 26, .external_lex_state = 1},
  [1027] = {.lex_state = 26, .external_lex_state = 1},
  [1028] = {.lex_state = 26, .external_lex_state = 1},
  [1029] = {.lex_state = 26, .external_lex_state = 1},
  [1030] = {.lex_state = 26, .external_lex_state = 1},
  [1031] = {.lex_state = 0, .external_lex_state = 1},
  [1032] = {.lex_state = 26, .external_lex_state = 1},
  [1033] = {.lex_state = 0, .external_lex_state = 1},
  [1034] = {.lex_state = 0, .external_lex_state = 1},
  [1035] = {.lex_state = 0, .external_lex_state = 1},
  [1036] = {.lex_state = 0, .external_lex_state = 1},
  [1037] = {.lex_state = 0, .external_lex_state = 1},
  [1038] = {.lex_state = 0, .external_lex_state = 1},
  [1039] = {.lex_state = 0, .external_lex_state = 1},
  [1040] = {.lex_state = 26, .external_lex_state = 1},
  [1041] = {.lex_state = 0, .external_lex_state = 1},
  [1042] = {.lex_state = 0, .external_lex_state = 1},
  [1043] = {.lex_state = 28, .external_lex_state = 1},
  [1044] = {.lex_state = 0, .external_lex_state = 1},
  [1045] = {.lex_state = 26, .external_lex_state = 1},
  [1046] = {.lex_state = 0, .external_lex_state = 1},
  [1047] = {.lex_state = 0, .external_lex_state = 1},
  [1048] = {.lex_state = 26, .external_lex_state = 1},
  [1049] = {.lex_state = 26, .external_lex_state = 1},
  [1050] = {.lex_state = 0, .external_lex_state = 1},
  [1051] = {.lex_state = 28, .external_lex_state = 1},
  [1052] = {.lex_state = 0, .external_lex_state = 1},
  [1053] = {.lex_state = 0, .external_lex_state = 1},
  [1054] = {.lex_state = 0, .external_lex_state = 1},
  [1055] = {.lex_state = 0, .external_lex_state = 1},
  [1056] = {.lex_state = 0, .external_lex_state = 1},
  [1057] = {.lex_state = 26, .external_lex_state = 1},
  [1058] = {.lex_state = 26, .external_lex_state = 1},
  [1059] = {.lex_state = 26, .external_lex_state = 1},
  [1060] = {.lex_state = 0, .external_lex_state = 1},
  [1061] = {.lex_state = 0, .external_lex_state = 1},
  [1062] = {.lex_state = 59, .external_lex_state = 1},
  [1063] = {.lex_state = 26, .external_lex_state = 1},
  [1064] = {.lex_state = 0, .external_lex_state = 1},
  [1065] = {.lex_state = 0, .external_lex_state = 1},
  [1066] = {.lex_state = 26, .external_lex_state = 1},
  [1067] = {.lex_state = 26, .external_lex_state = 1},
  [1068] = {.lex_state = 0, .external_lex_state = 1},
  [1069] = {.lex_state = 27, .external_lex_state = 1},
  [1070] = {.lex_state = 0, .external_lex_state = 1},
  [1071] = {.lex_state = 26, .external_lex_state = 1},
  [1072] = {.lex_state = 26, .external_lex_state = 1},
  [1073] = {.lex_state = 26, .external_lex_state = 1},
  [1074] = {.lex_state = 0, .external_lex_state = 1},
  [1075] = {.lex_state = 0, .external_lex_state = 1},
  [1076] = {.lex_state = 59, .external_lex_state = 1},
  [1077] = {.lex_state = 0, .external_lex_state = 1},
  [1078] = {.lex_state = 0, .external_lex_state = 1},
  [1079] = {.lex_state = 59, .external_lex_state = 1},
  [1080] = {.lex_state = 0, .external_lex_state = 1},
  [1081] = {.lex_state = 26, .external_lex_state = 1},
  [1082] = {.lex_state = 0, .external_lex_state = 1},
  [1083] = {.lex_state = 0, .external_lex_state = 1},
  [1084] = {.lex_state = 0, .external_lex_state = 1},
  [1085] = {.lex_state = 0, .external_lex_state = 1},
  [1086] = {.lex_state = 59, .external_lex_state = 1},
  [1087] = {.lex_state = 59, .external_lex_state = 1},
  [1088] = {.lex_state = 0, .external_lex_state = 1},
  [1089] = {.lex_state = 0, .external_lex_state = 1},
  [1090] = {.lex_state = 0, .external_lex_state = 1},
  [1091] = {.lex_state = 0, .external_lex_state = 1},
  [1092] = {.lex_state = 0, .external_lex_state = 1},
  [1093] = {.lex_state = 0, .external_lex_state = 1},
  [1094] = {.lex_state = 26, .external_lex_state = 1},
  [1095] = {.lex_state = 0, .external_lex_state = 1},
  [1096] = {.lex_state = 59, .external_lex_state = 1},
  [1097] = {.lex_state = 0, .external_lex_state = 1},
  [1098] = {.lex_state = 26, .external_lex_state = 1},
  [1099] = {.lex_state = 0, .external_lex_state = 1},
  [1100] = {.lex_state = 0, .external_lex_state = 1},
  [1101] = {.lex_state = 59, .external_lex_state = 1},
  [1102] = {.lex_state = 0, .external_lex_state = 1},
  [1103] = {.lex_state = 26, .external_lex_state = 1},
  [1104] = {.lex_state = 0, .external_lex_state = 1},
  [1105] = {.lex_state = 26, .external_lex_state = 1},
  [1106] = {.lex_state = 26, .external_lex_state = 1},
  [1107] = {.lex_state = 26, .external_lex_state = 1},
  [1108] = {.lex_state = 26, .external_lex_state = 1},
  [1109] = {.lex_state = 0, .external_lex_state = 1},
  [1110] = {.lex_state = 0, .external_lex_state = 1},
  [1111] = {.lex_state = 0, .external_lex_state = 1},
  [1112] = {.lex_state = 0, .external_lex_state = 1},
  [1113] = {.lex_state = 0, .external_lex_state = 1},
  [1114] = {.lex_state = 0, .external_lex_state = 1},
  [1115] = {.lex_state = 0, .external_lex_state = 1},
  [1116] = {.lex_state = 59, .external_lex_state = 1},
  [1117] = {.lex_state = 0, .external_lex_state = 1},
  [1118] = {.lex_state = 0, .external_lex_state = 1},
  [1119] = {.lex_state = 59, .external_lex_state = 1},
  [1120] = {.lex_state = 0, .external_lex_state = 1},
  [1121] = {.lex_state = 0, .external_lex_state = 1},
  [1122] = {.lex_state = 0, .external_lex_state = 1},
  [1123] = {.lex_state = 26, .external_lex_state = 1},
  [1124] = {.lex_state = 26, .external_lex_state = 1},
  [1125] = {.lex_state = 26, .external_lex_state = 1},
  [1126] = {.lex_state = 0, .external_lex_state = 1},
  [1127] = {.lex_state = 0, .external_lex_state = 1},
  [1128] = {.lex_state = 28, .external_lex_state = 1},
  [1129] = {.lex_state = 59, .external_lex_state = 1},
  [1130] = {.lex_state = 59, .external_lex_state = 1},
  [1131] = {.lex_state = 26, .external_lex_state = 1},
  [1132] = {.lex_state = 59, .external_lex_state = 1},
  [1133] = {.lex_state = 26, .external_lex_state = 1},
  [1134] = {.lex_state = 0, .external_lex_state = 1},
  [1135] = {.lex_state = 59, .external_lex_state = 1},
  [1136] = {.lex_state = 0, .external_lex_state = 1},
  [1137] = {.lex_state = 26, .external_lex_state = 1},
  [1138] = {.lex_state = 59, .external_lex_state = 1},
  [1139] = {.lex_state = 59, .external_lex_state = 1},
  [1140] = {.lex_state = 26, .external_lex_state = 1},
  [1141] = {.lex_state = 59, .external_lex_state = 1},
  [1142] = {.lex_state = 26, .external_lex_state = 1},
  [1143] = {.lex_state = 26, .external_lex_state = 1},
  [1144] = {.lex_state = 0, .external_lex_state = 1},
  [1145] = {.lex_state = 0, .external_lex_state = 1},
  [1146] = {.lex_state = 0, .external_lex_state = 1},
  [1147] = {.lex_state = 26, .external_lex_state = 1},
  [1148] = {.lex_state = 59, .external_lex_state = 1},
  [1149] = {.lex_state = 0, .external_lex_state = 1},
  [1150] = {.lex_state = 26, .external_lex_state = 1},
  [1151] = {.lex_state = 0, .external_lex_state = 1},
  [1152] = {.lex_state = 59, .external_lex_state = 1},
  [1153] = {.lex_state = 26, .external_lex_state = 1},
  [1154] = {.lex_state = 0, .external_lex_state = 1},
  [1155] = {.lex_state = 26, .external_lex_state = 1},
  [1156] = {.lex_state = 567, .external_lex_state = 1},
  [1157] = {.lex_state = 26, .external_lex_state = 1},
  [1158] = {.lex_state = 26, .external_lex_state = 1},
  [1159] = {.lex_state = 0, .external_lex_state = 1},
  [1160] = {.lex_state = 26, .external_lex_state = 1},
  [1161] = {.lex_state = 0, .external_lex_state = 1},
  [1162] = {.lex_state = 0, .external_lex_state = 1},
  [1163] = {.lex_state = 26, .external_lex_state = 1},
  [1164] = {.lex_state = 26, .external_lex_state = 1},
  [1165] = {.lex_state = 0, .external_lex_state = 1},
  [1166] = {.lex_state = 59, .external_lex_state = 1},
  [1167] = {.lex_state = 0, .external_lex_state = 1},
  [1168] = {.lex_state = 26, .external_lex_state = 1},
  [1169] = {.lex_state = 25, .external_lex_state = 1},
  [1170] = {.lex_state = 25, .external_lex_state = 1},
  [1171] = {.lex_state = 26, .external_lex_state = 1},
  [1172] = {.lex_state = 0, .external_lex_state = 1},
  [1173] = {.lex_state = 26, .external_lex_state = 1},
  [1174] = {.lex_state = 26, .external_lex_state = 1},
  [1175] = {.lex_state = 0, .external_lex_state = 1},
  [1176] = {.lex_state = 26, .external_lex_state = 1},
  [1177] = {.lex_state = 26, .external_lex_state = 1},
  [1178] = {.lex_state = 26, .external_lex_state = 1},
  [1179] = {.lex_state = 0, .external_lex_state = 1},
  [1180] = {.lex_state = 0, .external_lex_state = 1},
  [1181] = {.lex_state = 0, .external_lex_state = 1},
  [1182] = {.lex_state = 0, .external_lex_state = 1},
  [1183] = {.lex_state = 26, .external_lex_state = 1},
  [1184] = {.lex_state = 26, .external_lex_state = 1},
  [1185] = {.lex_state = 59, .external_lex_state = 1},
  [1186] = {.lex_state = 26, .external_lex_state = 1},
  [1187] = {.lex_state = 26, .external_lex_state = 1},
  [1188] = {.lex_state = 0, .external_lex_state = 1},
  [1189] = {.lex_state = 59, .external_lex_state = 1},
  [1190] = {.lex_state = 59, .external_lex_state = 1},
  [1191] = {.lex_state = 26, .external_lex_state = 1},
  [1192] = {.lex_state = 59, .external_lex_state = 1},
  [1193] = {.lex_state = 0, .external_lex_state = 1},
  [1194] = {.lex_state = 571, .external_lex_state = 1},
  [1195] = {.lex_state = 0, .external_lex_state = 1},
  [1196] = {.lex_state = 26, .external_lex_state = 1},
  [1197] = {.lex_state = 32, .external_lex_state = 1},
  [1198] = {.lex_state = 26, .external_lex_state = 1},
  [1199] = {.lex_state = 0, .external_lex_state = 1},
  [1200] = {.lex_state = 59, .external_lex_state = 1},
  [1201] = {.lex_state = 0, .external_lex_state = 1},
  [1202] = {.lex_state = 0, .external_lex_state = 1},
  [1203] = {.lex_state = 0, .external_lex_state = 1},
  [1204] = {.lex_state = 26, .external_lex_state = 1},
  [1205] = {.lex_state = 0, .external_lex_state = 1},
  [1206] = {.lex_state = 26, .external_lex_state = 1},
  [1207] = {.lex_state = 26, .external_lex_state = 1},
  [1208] = {.lex_state = 0, .external_lex_state = 1},
  [1209] = {.lex_state = 26, .external_lex_state = 1},
  [1210] = {.lex_state = 0, .external_lex_state = 1},
  [1211] = {.lex_state = 26, .external_lex_state = 1},
  [1212] = {.lex_state = 26, .external_lex_state = 1},
  [1213] = {.lex_state = 26, .external_lex_state = 1},
  [1214] = {.lex_state = 26, .external_lex_state = 1},
  [1215] = {.lex_state = 59, .external_lex_state = 1},
  [1216] = {.lex_state = 0, .external_lex_state = 1},
  [1217] = {.lex_state = 0, .external_lex_state = 1},
  [1218] = {.lex_state = 26, .external_lex_state = 1},
  [1219] = {.lex_state = 567, .external_lex_state = 1},
  [1220] = {.lex_state = 59, .external_lex_state = 1},
  [1221] = {.lex_state = 26, .external_lex_state = 1},
  [1222] = {.lex_state = 59, .external_lex_state = 1},
  [1223] = {.lex_state = 59, .external_lex_state = 1},
  [1224] = {.lex_state = 59, .external_lex_state = 1},
  [1225] = {.lex_state = 26, .external_lex_state = 1},
  [1226] = {.lex_state = 59, .external_lex_state = 1},
  [1227] = {.lex_state = 0, .external_lex_state = 1},
  [1228] = {.lex_state = 59, .external_lex_state = 1},
  [1229] = {.lex_state = 0, .external_lex_state = 1},
  [1230] = {.lex_state = 26, .external_lex_state = 1},
  [1231] = {.lex_state = 0, .external_lex_state = 1},
  [1232] = {.lex_state = 26, .external_lex_state = 1},
  [1233] = {.lex_state = 0, .external_lex_state = 1},
  [1234] = {.lex_state = 26, .external_lex_state = 1},
  [1235] = {.lex_state = 26, .external_lex_state = 1},
  [1236] = {.lex_state = 26, .external_lex_state = 1},
  [1237] = {.lex_state = 32, .external_lex_state = 1},
  [1238] = {.lex_state = 26, .external_lex_state = 1},
  [1239] = {.lex_state = 0, .external_lex_state = 1},
  [1240] = {.lex_state = 0, .external_lex_state = 1},
  [1241] = {.lex_state = 26, .external_lex_state = 1},
  [1242] = {.lex_state = 0, .external_lex_state = 1},
  [1243] = {.lex_state = 59, .external_lex_state = 1},
  [1244] = {.lex_state = 26, .external_lex_state = 1},
  [1245] = {.lex_state = 0, .external_lex_state = 1},
  [1246] = {.lex_state = 59, .external_lex_state = 1},
  [1247] = {.lex_state = 59, .external_lex_state = 1},
  [1248] = {.lex_state = 26, .external_lex_state = 1},
  [1249] = {.lex_state = 59, .external_lex_state = 1},
  [1250] = {.lex_state = 0, .external_lex_state = 1},
  [1251] = {.lex_state = 0, .external_lex_state = 1},
  [1252] = {.lex_state = 59, .external_lex_state = 1},
  [1253] = {.lex_state = 0, .external_lex_state = 1},
  [1254] = {.lex_state = 26, .external_lex_state = 1},
  [1255] = {.lex_state = 26, .external_lex_state = 1},
  [1256] = {.lex_state = 26, .external_lex_state = 1},
  [1257] = {.lex_state = 26, .external_lex_state = 1},
  [1258] = {.lex_state = 59, .external_lex_state = 1},
  [1259] = {.lex_state = 59, .external_lex_state = 1},
  [1260] = {.lex_state = 26, .external_lex_state = 1},
  [1261] = {.lex_state = 59, .external_lex_state = 1},
  [1262] = {.lex_state = 0, .external_lex_state = 1},
  [1263] = {.lex_state = 0, .external_lex_state = 1},
  [1264] = {.lex_state = 25, .external_lex_state = 1},
  [1265] = {.lex_state = 25, .external_lex_state = 1},
  [1266] = {.lex_state = 26, .external_lex_state = 1},
  [1267] = {.lex_state = 26, .external_lex_state = 1},
  [1268] = {.lex_state = 59, .external_lex_state = 1},
  [1269] = {.lex_state = 26, .external_lex_state = 1},
  [1270] = {.lex_state = 0, .external_lex_state = 1},
  [1271] = {.lex_state = 57, .external_lex_state = 1},
  [1272] = {.lex_state = 26, .external_lex_state = 1},
  [1273] = {.lex_state = 0, .external_lex_state = 1},
  [1274] = {.lex_state = 0, .external_lex_state = 1},
  [1275] = {.lex_state = 0, .external_lex_state = 1},
  [1276] = {.lex_state = 26, .external_lex_state = 1},
  [1277] = {.lex_state = 26, .external_lex_state = 1},
  [1278] = {.lex_state = 26, .external_lex_state = 1},
  [1279] = {.lex_state = 567, .external_lex_state = 1},
  [1280] = {.lex_state = 26, .external_lex_state = 1},
  [1281] = {.lex_state = 0, .external_lex_state = 1},
  [1282] = {.lex_state = 0, .external_lex_state = 1},
  [1283] = {.lex_state = 26, .external_lex_state = 1},
  [1284] = {.lex_state = 26, .external_lex_state = 1},
  [1285] = {.lex_state = 26, .external_lex_state = 1},
  [1286] = {.lex_state = 0, .external_lex_state = 1},
  [1287] = {.lex_state = 0, .external_lex_state = 1},
  [1288] = {.lex_state = 0, .external_lex_state = 1},
  [1289] = {.lex_state = 26, .external_lex_state = 1},
  [1290] = {.lex_state = 0, .external_lex_state = 1},
  [1291] = {.lex_state = 0, .external_lex_state = 1},
  [1292] = {.lex_state = 0, .external_lex_state = 1},
  [1293] = {.lex_state = 0, .external_lex_state = 1},
  [1294] = {.lex_state = 0, .external_lex_state = 1},
  [1295] = {.lex_state = 0, .external_lex_state = 1},
  [1296] = {.lex_state = 0, .external_lex_state = 1},
  [1297] = {.lex_state = 567, .external_lex_state = 1},
  [1298] = {.lex_state = 0, .external_lex_state = 1},
  [1299] = {.lex_state = 25, .external_lex_state = 1},
  [1300] = {.lex_state = 25, .external_lex_state = 1},
  [1301] = {.lex_state = 0, .external_lex_state = 1},
  [1302] = {.lex_state = 26, .external_lex_state = 1},
  [1303] = {.lex_state = 0, .external_lex_state = 1},
  [1304] = {.lex_state = 0, .external_lex_state = 1},
  [1305] = {.lex_state = 26, .external_lex_state = 1},
  [1306] = {.lex_state = 25, .external_lex_state = 1},
  [1307] = {.lex_state = 25, .external_lex_state = 1},
  [1308] = {.lex_state = 59, .external_lex_state = 1},
  [1309] = {.lex_state = 0, .external_lex_state = 1},
  [1310] = {.lex_state = 0, .external_lex_state = 1},
  [1311] = {.lex_state = 25, .external_lex_state = 1},
  [1312] = {.lex_state = 25, .external_lex_state = 1},
  [1313] = {.lex_state = 0, .external_lex_state = 1},
  [1314] = {.lex_state = 26, .external_lex_state = 1},
  [1315] = {.lex_state = 26, .external_lex_state = 1},
  [1316] = {.lex_state = 0, .external_lex_state = 1},
  [1317] = {.lex_state = 0, .external_lex_state = 1},
  [1318] = {.lex_state = 0, .external_lex_state = 1},
  [1319] = {.lex_state = 0, .external_lex_state = 1},
  [1320] = {.lex_state = 26, .external_lex_state = 1},
  [1321] = {.lex_state = 26, .external_lex_state = 1},
  [1322] = {.lex_state = 59, .external_lex_state = 1},
  [1323] = {.lex_state = 0, .external_lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_ident] = ACTIONS(1),
    [anon_sym_theory] = ACTIONS(1),
    [anon_sym_configuration] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_begin] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_DASH_DASHauto_DASHsources] = ACTIONS(1),
    [anon_sym_DASH_DASHstop_DASHon_DASHtrace] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_BFS] = ACTIONS(1),
    [anon_sym_DFS] = ACTIONS(1),
    [anon_sym_SEQDFS] = ACTIONS(1),
    [anon_sym_bfs] = ACTIONS(1),
    [anon_sym_dfs] = ACTIONS(1),
    [anon_sym_seqdfs] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_builtins] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_diffie_DASHhellman] = ACTIONS(1),
    [anon_sym_hashing] = ACTIONS(1),
    [anon_sym_signing] = ACTIONS(1),
    [anon_sym_bilinear_DASHpairing] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_multiset] = ACTIONS(1),
    [anon_sym_revealing_DASHsigning] = ACTIONS(1),
    [anon_sym_locations_DASHreport] = ACTIONS(1),
    [anon_sym_reliable_DASHchannel] = ACTIONS(1),
    [anon_sym_dest_DASHpairing] = ACTIONS(1),
    [anon_sym_dest_DASHsigning] = ACTIONS(1),
    [anon_sym_dest_DASHsymmetric_DASHencryption] = ACTIONS(1),
    [anon_sym_dest_DASHasymmetric_DASHencryption] = ACTIONS(1),
    [anon_sym_functions] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_destructor] = ACTIONS(1),
    [anon_sym_equations] = ACTIONS(1),
    [anon_sym_convergent] = ACTIONS(1),
    [anon_sym_predicate] = ACTIONS(1),
    [anon_sym_predicates] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_options] = ACTIONS(1),
    [anon_sym_translation_DASHstate_DASHoptimisation] = ACTIONS(1),
    [anon_sym_translation_DASHprogress] = ACTIONS(1),
    [anon_sym_translation_DASHasynchronous_DASHchannels] = ACTIONS(1),
    [anon_sym_translation_DASHcompress_DASHevents] = ACTIONS(1),
    [anon_sym_translation_DASHallow_DASHpattern_DASHlookups] = ACTIONS(1),
    [anon_sym_heuristic] = ACTIONS(1),
    [sym_standard_goal_ranking] = ACTIONS(1),
    [anon_sym_O] = ACTIONS(1),
    [anon_sym_o] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_tactic] = ACTIONS(1),
    [anon_sym_presort] = ACTIONS(1),
    [anon_sym_prio] = ACTIONS(1),
    [anon_sym_deprio] = ACTIONS(1),
    [anon_sym_smallest] = ACTIONS(1),
    [anon_sym_id] = ACTIONS(1),
    [anon_sym_regex] = ACTIONS(1),
    [anon_sym_isFactName] = ACTIONS(1),
    [anon_sym_isInFactTerms] = ACTIONS(1),
    [anon_sym_dhreNoise] = ACTIONS(1),
    [anon_sym_defaultNoise] = ACTIONS(1),
    [anon_sym_reasonableNoncesNoise] = ACTIONS(1),
    [anon_sym_nonAbsurdGoal] = ACTIONS(1),
    [anon_sym_process] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_DASH_DASH_GT] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_out] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_insert] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_lookup] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_lock] = ACTIONS(1),
    [anon_sym_unlock] = ACTIONS(1),
    [anon_sym_EQ2] = ACTIONS(1),
    [anon_sym_LPAREN_LT_RPAREN] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_left] = ACTIONS(1),
    [anon_sym_right] = ACTIONS(1),
    [anon_sym_rule] = ACTIONS(1),
    [anon_sym_DASH_DASH_LBRACK] = ACTIONS(1),
    [anon_sym_variants] = ACTIONS(1),
    [anon_sym_modulo] = ACTIONS(1),
    [anon_sym_E] = ACTIONS(1),
    [anon_sym_AC] = ACTIONS(1),
    [anon_sym_no_derivcheck] = ACTIONS(1),
    [anon_sym_issapicrule] = ACTIONS(1),
    [anon_sym_role] = ACTIONS(1),
    [anon_sym_macros] = ACTIONS(1),
    [anon_sym__restrict] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_no_precomp] = ACTIONS(1),
    [anon_sym_restriction] = ACTIONS(1),
    [anon_sym_axiom] = ACTIONS(1),
    [anon_sym_test] = ACTIONS(1),
    [anon_sym_lemma] = ACTIONS(1),
    [anon_sym_sources] = ACTIONS(1),
    [anon_sym_reuse] = ACTIONS(1),
    [anon_sym_use_induction] = ACTIONS(1),
    [anon_sym_hide_lemma_EQ] = ACTIONS(1),
    [anon_sym_heuristic_EQ] = ACTIONS(1),
    [anon_sym_spthy] = ACTIONS(1),
    [anon_sym_spthytyped] = ACTIONS(1),
    [anon_sym_msr] = ACTIONS(1),
    [anon_sym_proverif] = ACTIONS(1),
    [anon_sym_deepsec] = ACTIONS(1),
    [anon_sym_diffLemma] = ACTIONS(1),
    [anon_sym_account] = ACTIONS(1),
    [anon_sym_accounts] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_equivLemma] = ACTIONS(1),
    [anon_sym_diffEquivLemma] = ACTIONS(1),
    [anon_sym_all_DASHtraces] = ACTIONS(1),
    [anon_sym_exists_DASHtrace] = ACTIONS(1),
    [sym_solved] = ACTIONS(1),
    [sym_mirrored] = ACTIONS(1),
    [anon_sym_by] = ACTIONS(1),
    [anon_sym_next] = ACTIONS(1),
    [anon_sym_qed] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_sorry] = ACTIONS(1),
    [anon_sym_simplify] = ACTIONS(1),
    [anon_sym_solve] = ACTIONS(1),
    [anon_sym_contradiction] = ACTIONS(1),
    [anon_sym_induction] = ACTIONS(1),
    [anon_sym_rule_DASHequivalence] = ACTIONS(1),
    [anon_sym_backward_DASHsearch] = ACTIONS(1),
    [anon_sym_ATTACK] = ACTIONS(1),
    [anon_sym_step] = ACTIONS(1),
    [anon_sym_u25b6] = ACTIONS(1),
    [anon_sym_TILDE_TILDE_GT] = ACTIONS(1),
    [anon_sym_u2225] = ACTIONS(1),
    [anon_sym_splitEqs] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_PERCENT_PLUS] = ACTIONS(1),
    [anon_sym_XOR] = ACTIONS(1),
    [anon_sym_u2295] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_pub] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_fresh] = ACTIONS(1),
    [anon_sym_msg] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_node] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_nat] = ACTIONS(1),
    [anon_sym_ANY] = ACTIONS(1),
    [anon_sym_temporal] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(1),
    [anon_sym_u21d4] = ACTIONS(1),
    [anon_sym_EQ_EQ_GT] = ACTIONS(1),
    [anon_sym_u21d2] = ACTIONS(1),
    [anon_sym_u2228] = ACTIONS(1),
    [anon_sym_u2227] = ACTIONS(1),
    [anon_sym_u00ac] = ACTIONS(1),
    [anon_sym_last] = ACTIONS(1),
    [anon_sym_u228f] = ACTIONS(1),
    [anon_sym_Ex] = ACTIONS(1),
    [anon_sym_u2203] = ACTIONS(1),
    [anon_sym_All] = ACTIONS(1),
    [anon_sym_u2200] = ACTIONS(1),
    [anon_sym_u22a5] = ACTIONS(1),
    [anon_sym_F] = ACTIONS(1),
    [anon_sym_u22a4] = ACTIONS(1),
    [anon_sym_T] = ACTIONS(1),
    [anon_sym_u2080] = ACTIONS(1),
    [anon_sym_u2081] = ACTIONS(1),
    [anon_sym_u2082] = ACTIONS(1),
    [anon_sym_u2083] = ACTIONS(1),
    [anon_sym_u2084] = ACTIONS(1),
    [anon_sym_u2085] = ACTIONS(1),
    [anon_sym_u2086] = ACTIONS(1),
    [anon_sym_u2087] = ACTIONS(1),
    [anon_sym_u2088] = ACTIONS(1),
    [anon_sym_u2089] = ACTIONS(1),
    [aux_sym_formal_comment_token1] = ACTIONS(1),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_theory] = STATE(1323),
    [anon_sym_theory] = ACTIONS(5),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__fact] = STATE(1012),
    [sym_fact] = STATE(1012),
    [sym_goal] = STATE(1180),
    [sym_premise_goal] = STATE(1179),
    [sym_action_goal] = STATE(1179),
    [sym_chain_goal] = STATE(1179),
    [sym_disjunction_split_goal] = STATE(1179),
    [sym_eq_split_goal] = STATE(1179),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(722),
    [sym_iff] = STATE(722),
    [sym_imp] = STATE(722),
    [sym_disjunction] = STATE(722),
    [sym_conjunction] = STATE(722),
    [sym_negation] = STATE(722),
    [sym_nested_formula] = STATE(722),
    [sym__temporal_variable_operation] = STATE(722),
    [sym_temp_var_induction] = STATE(722),
    [sym_temp_var_order] = STATE(722),
    [sym_temp_var_eq] = STATE(722),
    [sym_action_constraint] = STATE(722),
    [sym_term_eq] = STATE(722),
    [sym_subterm_rel] = STATE(722),
    [sym_quantified_formula] = STATE(722),
    [sym_atom] = STATE(722),
    [sym_predicate_ref] = STATE(722),
    [sym_pre_defined] = STATE(722),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_splitEqs] = ACTIONS(17),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__process] = STATE(467),
    [sym__elementary_process] = STATE(467),
    [sym__extended_process] = STATE(467),
    [sym__stateful_process] = STATE(467),
    [sym_location_process] = STATE(467),
    [sym_inline_msr_process] = STATE(467),
    [sym__nested_process] = STATE(467),
    [sym_predefined_process] = STATE(467),
    [sym_binding] = STATE(467),
    [sym_output] = STATE(467),
    [sym_input] = STATE(467),
    [sym_conditional] = STATE(467),
    [sym_process_let] = STATE(467),
    [sym_deterministic_choice] = STATE(467),
    [sym_non_deterministic_choice] = STATE(467),
    [sym_event] = STATE(467),
    [sym_replication] = STATE(467),
    [sym_set_state] = STATE(467),
    [sym_delete_state] = STATE(467),
    [sym_read_state] = STATE(467),
    [sym_set_lock] = STATE(467),
    [sym_remove_lock] = STATE(467),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_PIPE] = ACTIONS(49),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [anon_sym_PIPE_PIPE] = ACTIONS(63),
    [anon_sym_PLUS] = ACTIONS(65),
    [sym_null] = ACTIONS(67),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__process] = STATE(540),
    [sym__elementary_process] = STATE(540),
    [sym__extended_process] = STATE(540),
    [sym__stateful_process] = STATE(540),
    [sym_location_process] = STATE(540),
    [sym_inline_msr_process] = STATE(540),
    [sym__nested_process] = STATE(540),
    [sym_predefined_process] = STATE(540),
    [sym_binding] = STATE(540),
    [sym_output] = STATE(540),
    [sym_input] = STATE(540),
    [sym_conditional] = STATE(540),
    [sym_process_let] = STATE(540),
    [sym_deterministic_choice] = STATE(540),
    [sym_non_deterministic_choice] = STATE(540),
    [sym_event] = STATE(540),
    [sym_replication] = STATE(540),
    [sym_set_state] = STATE(540),
    [sym_delete_state] = STATE(540),
    [sym_read_state] = STATE(540),
    [sym_set_lock] = STATE(540),
    [sym_remove_lock] = STATE(540),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(99),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__process] = STATE(349),
    [sym__elementary_process] = STATE(349),
    [sym__extended_process] = STATE(349),
    [sym__stateful_process] = STATE(349),
    [sym_location_process] = STATE(349),
    [sym_inline_msr_process] = STATE(349),
    [sym__nested_process] = STATE(349),
    [sym_predefined_process] = STATE(349),
    [sym_binding] = STATE(349),
    [sym_output] = STATE(349),
    [sym_input] = STATE(349),
    [sym_conditional] = STATE(349),
    [sym_process_let] = STATE(349),
    [sym_deterministic_choice] = STATE(349),
    [sym_non_deterministic_choice] = STATE(349),
    [sym_event] = STATE(349),
    [sym_replication] = STATE(349),
    [sym_set_state] = STATE(349),
    [sym_delete_state] = STATE(349),
    [sym_read_state] = STATE(349),
    [sym_set_lock] = STATE(349),
    [sym_remove_lock] = STATE(349),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(127),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__process] = STATE(336),
    [sym__elementary_process] = STATE(336),
    [sym__extended_process] = STATE(336),
    [sym__stateful_process] = STATE(336),
    [sym_location_process] = STATE(336),
    [sym_inline_msr_process] = STATE(336),
    [sym__nested_process] = STATE(336),
    [sym_predefined_process] = STATE(336),
    [sym_binding] = STATE(336),
    [sym_output] = STATE(336),
    [sym_input] = STATE(336),
    [sym_conditional] = STATE(336),
    [sym_process_let] = STATE(336),
    [sym_deterministic_choice] = STATE(336),
    [sym_non_deterministic_choice] = STATE(336),
    [sym_event] = STATE(336),
    [sym_replication] = STATE(336),
    [sym_set_state] = STATE(336),
    [sym_delete_state] = STATE(336),
    [sym_read_state] = STATE(336),
    [sym_set_lock] = STATE(336),
    [sym_remove_lock] = STATE(336),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(129),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__process] = STATE(529),
    [sym__elementary_process] = STATE(529),
    [sym__extended_process] = STATE(529),
    [sym__stateful_process] = STATE(529),
    [sym_location_process] = STATE(529),
    [sym_inline_msr_process] = STATE(529),
    [sym__nested_process] = STATE(529),
    [sym_predefined_process] = STATE(529),
    [sym_binding] = STATE(529),
    [sym_output] = STATE(529),
    [sym_input] = STATE(529),
    [sym_conditional] = STATE(529),
    [sym_process_let] = STATE(529),
    [sym_deterministic_choice] = STATE(529),
    [sym_non_deterministic_choice] = STATE(529),
    [sym_event] = STATE(529),
    [sym_replication] = STATE(529),
    [sym_set_state] = STATE(529),
    [sym_delete_state] = STATE(529),
    [sym_read_state] = STATE(529),
    [sym_set_lock] = STATE(529),
    [sym_remove_lock] = STATE(529),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(131),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__process] = STATE(326),
    [sym__elementary_process] = STATE(326),
    [sym__extended_process] = STATE(326),
    [sym__stateful_process] = STATE(326),
    [sym_location_process] = STATE(326),
    [sym_inline_msr_process] = STATE(326),
    [sym__nested_process] = STATE(326),
    [sym_predefined_process] = STATE(326),
    [sym_binding] = STATE(326),
    [sym_output] = STATE(326),
    [sym_input] = STATE(326),
    [sym_conditional] = STATE(326),
    [sym_process_let] = STATE(326),
    [sym_deterministic_choice] = STATE(326),
    [sym_non_deterministic_choice] = STATE(326),
    [sym_event] = STATE(326),
    [sym_replication] = STATE(326),
    [sym_set_state] = STATE(326),
    [sym_delete_state] = STATE(326),
    [sym_read_state] = STATE(326),
    [sym_set_lock] = STATE(326),
    [sym_remove_lock] = STATE(326),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(133),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__process] = STATE(528),
    [sym__elementary_process] = STATE(528),
    [sym__extended_process] = STATE(528),
    [sym__stateful_process] = STATE(528),
    [sym_location_process] = STATE(528),
    [sym_inline_msr_process] = STATE(528),
    [sym__nested_process] = STATE(528),
    [sym_predefined_process] = STATE(528),
    [sym_binding] = STATE(528),
    [sym_output] = STATE(528),
    [sym_input] = STATE(528),
    [sym_conditional] = STATE(528),
    [sym_process_let] = STATE(528),
    [sym_deterministic_choice] = STATE(528),
    [sym_non_deterministic_choice] = STATE(528),
    [sym_event] = STATE(528),
    [sym_replication] = STATE(528),
    [sym_set_state] = STATE(528),
    [sym_delete_state] = STATE(528),
    [sym_read_state] = STATE(528),
    [sym_set_lock] = STATE(528),
    [sym_remove_lock] = STATE(528),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(135),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__process] = STATE(525),
    [sym__elementary_process] = STATE(525),
    [sym__extended_process] = STATE(525),
    [sym__stateful_process] = STATE(525),
    [sym_location_process] = STATE(525),
    [sym_inline_msr_process] = STATE(525),
    [sym__nested_process] = STATE(525),
    [sym_predefined_process] = STATE(525),
    [sym_binding] = STATE(525),
    [sym_output] = STATE(525),
    [sym_input] = STATE(525),
    [sym_conditional] = STATE(525),
    [sym_process_let] = STATE(525),
    [sym_deterministic_choice] = STATE(525),
    [sym_non_deterministic_choice] = STATE(525),
    [sym_event] = STATE(525),
    [sym_replication] = STATE(525),
    [sym_set_state] = STATE(525),
    [sym_delete_state] = STATE(525),
    [sym_read_state] = STATE(525),
    [sym_set_lock] = STATE(525),
    [sym_remove_lock] = STATE(525),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(137),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__process] = STATE(342),
    [sym__elementary_process] = STATE(342),
    [sym__extended_process] = STATE(342),
    [sym__stateful_process] = STATE(342),
    [sym_location_process] = STATE(342),
    [sym_inline_msr_process] = STATE(342),
    [sym__nested_process] = STATE(342),
    [sym_predefined_process] = STATE(342),
    [sym_binding] = STATE(342),
    [sym_output] = STATE(342),
    [sym_input] = STATE(342),
    [sym_conditional] = STATE(342),
    [sym_process_let] = STATE(342),
    [sym_deterministic_choice] = STATE(342),
    [sym_non_deterministic_choice] = STATE(342),
    [sym_event] = STATE(342),
    [sym_replication] = STATE(342),
    [sym_set_state] = STATE(342),
    [sym_delete_state] = STATE(342),
    [sym_read_state] = STATE(342),
    [sym_set_lock] = STATE(342),
    [sym_remove_lock] = STATE(342),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(139),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__process] = STATE(521),
    [sym__elementary_process] = STATE(521),
    [sym__extended_process] = STATE(521),
    [sym__stateful_process] = STATE(521),
    [sym_location_process] = STATE(521),
    [sym_inline_msr_process] = STATE(521),
    [sym__nested_process] = STATE(521),
    [sym_predefined_process] = STATE(521),
    [sym_binding] = STATE(521),
    [sym_output] = STATE(521),
    [sym_input] = STATE(521),
    [sym_conditional] = STATE(521),
    [sym_process_let] = STATE(521),
    [sym_deterministic_choice] = STATE(521),
    [sym_non_deterministic_choice] = STATE(521),
    [sym_event] = STATE(521),
    [sym_replication] = STATE(521),
    [sym_set_state] = STATE(521),
    [sym_delete_state] = STATE(521),
    [sym_read_state] = STATE(521),
    [sym_set_lock] = STATE(521),
    [sym_remove_lock] = STATE(521),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(141),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__process] = STATE(339),
    [sym__elementary_process] = STATE(339),
    [sym__extended_process] = STATE(339),
    [sym__stateful_process] = STATE(339),
    [sym_location_process] = STATE(339),
    [sym_inline_msr_process] = STATE(339),
    [sym__nested_process] = STATE(339),
    [sym_predefined_process] = STATE(339),
    [sym_binding] = STATE(339),
    [sym_output] = STATE(339),
    [sym_input] = STATE(339),
    [sym_conditional] = STATE(339),
    [sym_process_let] = STATE(339),
    [sym_deterministic_choice] = STATE(339),
    [sym_non_deterministic_choice] = STATE(339),
    [sym_event] = STATE(339),
    [sym_replication] = STATE(339),
    [sym_set_state] = STATE(339),
    [sym_delete_state] = STATE(339),
    [sym_read_state] = STATE(339),
    [sym_set_lock] = STATE(339),
    [sym_remove_lock] = STATE(339),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(143),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__condition] = STATE(1244),
    [sym_equality_check] = STATE(1244),
    [sym_lesser_check] = STATE(1244),
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(718),
    [sym_tuple_term] = STATE(718),
    [sym_mset_term] = STATE(718),
    [sym_nat_term] = STATE(718),
    [sym_xor_term] = STATE(718),
    [sym_mul_term] = STATE(718),
    [sym_exp_term] = STATE(718),
    [sym_nested_term] = STATE(718),
    [sym_nullary_fun] = STATE(718),
    [sym_binary_app] = STATE(718),
    [sym_nary_app] = STATE(718),
    [sym__literal] = STATE(689),
    [sym__non_temporal_var] = STATE(689),
    [sym_pub_var] = STATE(689),
    [sym_fresh_var] = STATE(689),
    [sym_msg_var_or_nullary_fun] = STATE(689),
    [sym_nat_var] = STATE(689),
    [sym_comp_var] = STATE(689),
    [sym__custom_type_var] = STATE(689),
    [sym_custom_var] = STATE(689),
    [sym_any_var] = STATE(689),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(689),
    [sym_fresh_name] = STATE(689),
    [sym__formula] = STATE(782),
    [sym_iff] = STATE(782),
    [sym_imp] = STATE(782),
    [sym_disjunction] = STATE(782),
    [sym_conjunction] = STATE(782),
    [sym_negation] = STATE(782),
    [sym_nested_formula] = STATE(782),
    [sym__temporal_variable_operation] = STATE(782),
    [sym_temp_var_induction] = STATE(782),
    [sym_temp_var_order] = STATE(782),
    [sym_temp_var_eq] = STATE(782),
    [sym_action_constraint] = STATE(782),
    [sym_term_eq] = STATE(782),
    [sym_subterm_rel] = STATE(782),
    [sym_quantified_formula] = STATE(782),
    [sym_atom] = STATE(782),
    [sym_predicate_ref] = STATE(737),
    [sym_pre_defined] = STATE(782),
    [sym_ident] = ACTIONS(145),
    [anon_sym_EQ] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(163),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__process] = STATE(520),
    [sym__elementary_process] = STATE(520),
    [sym__extended_process] = STATE(520),
    [sym__stateful_process] = STATE(520),
    [sym_location_process] = STATE(520),
    [sym_inline_msr_process] = STATE(520),
    [sym__nested_process] = STATE(520),
    [sym_predefined_process] = STATE(520),
    [sym_binding] = STATE(520),
    [sym_output] = STATE(520),
    [sym_input] = STATE(520),
    [sym_conditional] = STATE(520),
    [sym_process_let] = STATE(520),
    [sym_deterministic_choice] = STATE(520),
    [sym_non_deterministic_choice] = STATE(520),
    [sym_event] = STATE(520),
    [sym_replication] = STATE(520),
    [sym_set_state] = STATE(520),
    [sym_delete_state] = STATE(520),
    [sym_read_state] = STATE(520),
    [sym_set_lock] = STATE(520),
    [sym_remove_lock] = STATE(520),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(171),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__process] = STATE(518),
    [sym__elementary_process] = STATE(518),
    [sym__extended_process] = STATE(518),
    [sym__stateful_process] = STATE(518),
    [sym_location_process] = STATE(518),
    [sym_inline_msr_process] = STATE(518),
    [sym__nested_process] = STATE(518),
    [sym_predefined_process] = STATE(518),
    [sym_binding] = STATE(518),
    [sym_output] = STATE(518),
    [sym_input] = STATE(518),
    [sym_conditional] = STATE(518),
    [sym_process_let] = STATE(518),
    [sym_deterministic_choice] = STATE(518),
    [sym_non_deterministic_choice] = STATE(518),
    [sym_event] = STATE(518),
    [sym_replication] = STATE(518),
    [sym_set_state] = STATE(518),
    [sym_delete_state] = STATE(518),
    [sym_read_state] = STATE(518),
    [sym_set_lock] = STATE(518),
    [sym_remove_lock] = STATE(518),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(173),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__process] = STATE(516),
    [sym__elementary_process] = STATE(516),
    [sym__extended_process] = STATE(516),
    [sym__stateful_process] = STATE(516),
    [sym_location_process] = STATE(516),
    [sym_inline_msr_process] = STATE(516),
    [sym__nested_process] = STATE(516),
    [sym_predefined_process] = STATE(516),
    [sym_binding] = STATE(516),
    [sym_output] = STATE(516),
    [sym_input] = STATE(516),
    [sym_conditional] = STATE(516),
    [sym_process_let] = STATE(516),
    [sym_deterministic_choice] = STATE(516),
    [sym_non_deterministic_choice] = STATE(516),
    [sym_event] = STATE(516),
    [sym_replication] = STATE(516),
    [sym_set_state] = STATE(516),
    [sym_delete_state] = STATE(516),
    [sym_read_state] = STATE(516),
    [sym_set_lock] = STATE(516),
    [sym_remove_lock] = STATE(516),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(175),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__process] = STATE(468),
    [sym__elementary_process] = STATE(468),
    [sym__extended_process] = STATE(468),
    [sym__stateful_process] = STATE(468),
    [sym_location_process] = STATE(468),
    [sym_inline_msr_process] = STATE(468),
    [sym__nested_process] = STATE(468),
    [sym_predefined_process] = STATE(468),
    [sym_binding] = STATE(468),
    [sym_output] = STATE(468),
    [sym_input] = STATE(468),
    [sym_conditional] = STATE(468),
    [sym_process_let] = STATE(468),
    [sym_deterministic_choice] = STATE(468),
    [sym_non_deterministic_choice] = STATE(468),
    [sym_event] = STATE(468),
    [sym_replication] = STATE(468),
    [sym_set_state] = STATE(468),
    [sym_delete_state] = STATE(468),
    [sym_read_state] = STATE(468),
    [sym_set_lock] = STATE(468),
    [sym_remove_lock] = STATE(468),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(177),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__process] = STATE(344),
    [sym__elementary_process] = STATE(344),
    [sym__extended_process] = STATE(344),
    [sym__stateful_process] = STATE(344),
    [sym_location_process] = STATE(344),
    [sym_inline_msr_process] = STATE(344),
    [sym__nested_process] = STATE(344),
    [sym_predefined_process] = STATE(344),
    [sym_binding] = STATE(344),
    [sym_output] = STATE(344),
    [sym_input] = STATE(344),
    [sym_conditional] = STATE(344),
    [sym_process_let] = STATE(344),
    [sym_deterministic_choice] = STATE(344),
    [sym_non_deterministic_choice] = STATE(344),
    [sym_event] = STATE(344),
    [sym_replication] = STATE(344),
    [sym_set_state] = STATE(344),
    [sym_delete_state] = STATE(344),
    [sym_read_state] = STATE(344),
    [sym_set_lock] = STATE(344),
    [sym_remove_lock] = STATE(344),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(179),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__process] = STATE(535),
    [sym__elementary_process] = STATE(535),
    [sym__extended_process] = STATE(535),
    [sym__stateful_process] = STATE(535),
    [sym_location_process] = STATE(535),
    [sym_inline_msr_process] = STATE(535),
    [sym__nested_process] = STATE(535),
    [sym_predefined_process] = STATE(535),
    [sym_binding] = STATE(535),
    [sym_output] = STATE(535),
    [sym_input] = STATE(535),
    [sym_conditional] = STATE(535),
    [sym_process_let] = STATE(535),
    [sym_deterministic_choice] = STATE(535),
    [sym_non_deterministic_choice] = STATE(535),
    [sym_event] = STATE(535),
    [sym_replication] = STATE(535),
    [sym_set_state] = STATE(535),
    [sym_delete_state] = STATE(535),
    [sym_read_state] = STATE(535),
    [sym_set_lock] = STATE(535),
    [sym_remove_lock] = STATE(535),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(181),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [21] = {
    [sym__process] = STATE(539),
    [sym__elementary_process] = STATE(539),
    [sym__extended_process] = STATE(539),
    [sym__stateful_process] = STATE(539),
    [sym_location_process] = STATE(539),
    [sym_inline_msr_process] = STATE(539),
    [sym__nested_process] = STATE(539),
    [sym_predefined_process] = STATE(539),
    [sym_binding] = STATE(539),
    [sym_output] = STATE(539),
    [sym_input] = STATE(539),
    [sym_conditional] = STATE(539),
    [sym_process_let] = STATE(539),
    [sym_deterministic_choice] = STATE(539),
    [sym_non_deterministic_choice] = STATE(539),
    [sym_event] = STATE(539),
    [sym_replication] = STATE(539),
    [sym_set_state] = STATE(539),
    [sym_delete_state] = STATE(539),
    [sym_read_state] = STATE(539),
    [sym_set_lock] = STATE(539),
    [sym_remove_lock] = STATE(539),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(183),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [22] = {
    [sym__process] = STATE(553),
    [sym__elementary_process] = STATE(553),
    [sym__extended_process] = STATE(553),
    [sym__stateful_process] = STATE(553),
    [sym_location_process] = STATE(553),
    [sym_inline_msr_process] = STATE(553),
    [sym__nested_process] = STATE(553),
    [sym_predefined_process] = STATE(553),
    [sym_binding] = STATE(553),
    [sym_output] = STATE(553),
    [sym_input] = STATE(553),
    [sym_conditional] = STATE(553),
    [sym_process_let] = STATE(553),
    [sym_deterministic_choice] = STATE(553),
    [sym_non_deterministic_choice] = STATE(553),
    [sym_event] = STATE(553),
    [sym_replication] = STATE(553),
    [sym_set_state] = STATE(553),
    [sym_delete_state] = STATE(553),
    [sym_read_state] = STATE(553),
    [sym_set_lock] = STATE(553),
    [sym_remove_lock] = STATE(553),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(185),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [23] = {
    [sym__process] = STATE(860),
    [sym__elementary_process] = STATE(860),
    [sym__extended_process] = STATE(860),
    [sym__stateful_process] = STATE(860),
    [sym_location_process] = STATE(860),
    [sym_inline_msr_process] = STATE(860),
    [sym__nested_process] = STATE(860),
    [sym_predefined_process] = STATE(860),
    [sym_binding] = STATE(860),
    [sym_output] = STATE(860),
    [sym_input] = STATE(860),
    [sym_conditional] = STATE(860),
    [sym_process_let] = STATE(860),
    [sym_deterministic_choice] = STATE(860),
    [sym_non_deterministic_choice] = STATE(860),
    [sym_event] = STATE(860),
    [sym_replication] = STATE(860),
    [sym_set_state] = STATE(860),
    [sym_delete_state] = STATE(860),
    [sym_read_state] = STATE(860),
    [sym_set_lock] = STATE(860),
    [sym_remove_lock] = STATE(860),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(744),
    [sym_tuple_term] = STATE(744),
    [sym_mset_term] = STATE(744),
    [sym_nat_term] = STATE(744),
    [sym_xor_term] = STATE(744),
    [sym_mul_term] = STATE(744),
    [sym_exp_term] = STATE(744),
    [sym_nested_term] = STATE(744),
    [sym_nullary_fun] = STATE(744),
    [sym_binary_app] = STATE(744),
    [sym_nary_app] = STATE(744),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(187),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [24] = {
    [sym__process] = STATE(332),
    [sym__elementary_process] = STATE(332),
    [sym__extended_process] = STATE(332),
    [sym__stateful_process] = STATE(332),
    [sym_location_process] = STATE(332),
    [sym_inline_msr_process] = STATE(332),
    [sym__nested_process] = STATE(332),
    [sym_predefined_process] = STATE(332),
    [sym_binding] = STATE(332),
    [sym_output] = STATE(332),
    [sym_input] = STATE(332),
    [sym_conditional] = STATE(332),
    [sym_process_let] = STATE(332),
    [sym_deterministic_choice] = STATE(332),
    [sym_non_deterministic_choice] = STATE(332),
    [sym_event] = STATE(332),
    [sym_replication] = STATE(332),
    [sym_set_state] = STATE(332),
    [sym_delete_state] = STATE(332),
    [sym_read_state] = STATE(332),
    [sym_set_lock] = STATE(332),
    [sym_remove_lock] = STATE(332),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(189),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [25] = {
    [sym__process] = STATE(517),
    [sym__elementary_process] = STATE(517),
    [sym__extended_process] = STATE(517),
    [sym__stateful_process] = STATE(517),
    [sym_location_process] = STATE(517),
    [sym_inline_msr_process] = STATE(517),
    [sym__nested_process] = STATE(517),
    [sym_predefined_process] = STATE(517),
    [sym_binding] = STATE(517),
    [sym_output] = STATE(517),
    [sym_input] = STATE(517),
    [sym_conditional] = STATE(517),
    [sym_process_let] = STATE(517),
    [sym_deterministic_choice] = STATE(517),
    [sym_non_deterministic_choice] = STATE(517),
    [sym_event] = STATE(517),
    [sym_replication] = STATE(517),
    [sym_set_state] = STATE(517),
    [sym_delete_state] = STATE(517),
    [sym_read_state] = STATE(517),
    [sym_set_lock] = STATE(517),
    [sym_remove_lock] = STATE(517),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(191),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [26] = {
    [sym__process] = STATE(555),
    [sym__elementary_process] = STATE(555),
    [sym__extended_process] = STATE(555),
    [sym__stateful_process] = STATE(555),
    [sym_location_process] = STATE(555),
    [sym_inline_msr_process] = STATE(555),
    [sym__nested_process] = STATE(555),
    [sym_predefined_process] = STATE(555),
    [sym_binding] = STATE(555),
    [sym_output] = STATE(555),
    [sym_input] = STATE(555),
    [sym_conditional] = STATE(555),
    [sym_process_let] = STATE(555),
    [sym_deterministic_choice] = STATE(555),
    [sym_non_deterministic_choice] = STATE(555),
    [sym_event] = STATE(555),
    [sym_replication] = STATE(555),
    [sym_set_state] = STATE(555),
    [sym_delete_state] = STATE(555),
    [sym_read_state] = STATE(555),
    [sym_set_lock] = STATE(555),
    [sym_remove_lock] = STATE(555),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(193),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [27] = {
    [sym__process] = STATE(548),
    [sym__elementary_process] = STATE(548),
    [sym__extended_process] = STATE(548),
    [sym__stateful_process] = STATE(548),
    [sym_location_process] = STATE(548),
    [sym_inline_msr_process] = STATE(548),
    [sym__nested_process] = STATE(548),
    [sym_predefined_process] = STATE(548),
    [sym_binding] = STATE(548),
    [sym_output] = STATE(548),
    [sym_input] = STATE(548),
    [sym_conditional] = STATE(548),
    [sym_process_let] = STATE(548),
    [sym_deterministic_choice] = STATE(548),
    [sym_non_deterministic_choice] = STATE(548),
    [sym_event] = STATE(548),
    [sym_replication] = STATE(548),
    [sym_set_state] = STATE(548),
    [sym_delete_state] = STATE(548),
    [sym_read_state] = STATE(548),
    [sym_set_lock] = STATE(548),
    [sym_remove_lock] = STATE(548),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(195),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [28] = {
    [sym__process] = STATE(343),
    [sym__elementary_process] = STATE(343),
    [sym__extended_process] = STATE(343),
    [sym__stateful_process] = STATE(343),
    [sym_location_process] = STATE(343),
    [sym_inline_msr_process] = STATE(343),
    [sym__nested_process] = STATE(343),
    [sym_predefined_process] = STATE(343),
    [sym_binding] = STATE(343),
    [sym_output] = STATE(343),
    [sym_input] = STATE(343),
    [sym_conditional] = STATE(343),
    [sym_process_let] = STATE(343),
    [sym_deterministic_choice] = STATE(343),
    [sym_non_deterministic_choice] = STATE(343),
    [sym_event] = STATE(343),
    [sym_replication] = STATE(343),
    [sym_set_state] = STATE(343),
    [sym_delete_state] = STATE(343),
    [sym_read_state] = STATE(343),
    [sym_set_lock] = STATE(343),
    [sym_remove_lock] = STATE(343),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(197),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__process] = STATE(536),
    [sym__elementary_process] = STATE(536),
    [sym__extended_process] = STATE(536),
    [sym__stateful_process] = STATE(536),
    [sym_location_process] = STATE(536),
    [sym_inline_msr_process] = STATE(536),
    [sym__nested_process] = STATE(536),
    [sym_predefined_process] = STATE(536),
    [sym_binding] = STATE(536),
    [sym_output] = STATE(536),
    [sym_input] = STATE(536),
    [sym_conditional] = STATE(536),
    [sym_process_let] = STATE(536),
    [sym_deterministic_choice] = STATE(536),
    [sym_non_deterministic_choice] = STATE(536),
    [sym_event] = STATE(536),
    [sym_replication] = STATE(536),
    [sym_set_state] = STATE(536),
    [sym_delete_state] = STATE(536),
    [sym_read_state] = STATE(536),
    [sym_set_lock] = STATE(536),
    [sym_remove_lock] = STATE(536),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(199),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [30] = {
    [sym__process] = STATE(334),
    [sym__elementary_process] = STATE(334),
    [sym__extended_process] = STATE(334),
    [sym__stateful_process] = STATE(334),
    [sym_location_process] = STATE(334),
    [sym_inline_msr_process] = STATE(334),
    [sym__nested_process] = STATE(334),
    [sym_predefined_process] = STATE(334),
    [sym_binding] = STATE(334),
    [sym_output] = STATE(334),
    [sym_input] = STATE(334),
    [sym_conditional] = STATE(334),
    [sym_process_let] = STATE(334),
    [sym_deterministic_choice] = STATE(334),
    [sym_non_deterministic_choice] = STATE(334),
    [sym_event] = STATE(334),
    [sym_replication] = STATE(334),
    [sym_set_state] = STATE(334),
    [sym_delete_state] = STATE(334),
    [sym_read_state] = STATE(334),
    [sym_set_lock] = STATE(334),
    [sym_remove_lock] = STATE(334),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(201),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [31] = {
    [sym__process] = STATE(335),
    [sym__elementary_process] = STATE(335),
    [sym__extended_process] = STATE(335),
    [sym__stateful_process] = STATE(335),
    [sym_location_process] = STATE(335),
    [sym_inline_msr_process] = STATE(335),
    [sym__nested_process] = STATE(335),
    [sym_predefined_process] = STATE(335),
    [sym_binding] = STATE(335),
    [sym_output] = STATE(335),
    [sym_input] = STATE(335),
    [sym_conditional] = STATE(335),
    [sym_process_let] = STATE(335),
    [sym_deterministic_choice] = STATE(335),
    [sym_non_deterministic_choice] = STATE(335),
    [sym_event] = STATE(335),
    [sym_replication] = STATE(335),
    [sym_set_state] = STATE(335),
    [sym_delete_state] = STATE(335),
    [sym_read_state] = STATE(335),
    [sym_set_lock] = STATE(335),
    [sym_remove_lock] = STATE(335),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(203),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__process] = STATE(354),
    [sym__elementary_process] = STATE(354),
    [sym__extended_process] = STATE(354),
    [sym__stateful_process] = STATE(354),
    [sym_location_process] = STATE(354),
    [sym_inline_msr_process] = STATE(354),
    [sym__nested_process] = STATE(354),
    [sym_predefined_process] = STATE(354),
    [sym_binding] = STATE(354),
    [sym_output] = STATE(354),
    [sym_input] = STATE(354),
    [sym_conditional] = STATE(354),
    [sym_process_let] = STATE(354),
    [sym_deterministic_choice] = STATE(354),
    [sym_non_deterministic_choice] = STATE(354),
    [sym_event] = STATE(354),
    [sym_replication] = STATE(354),
    [sym_set_state] = STATE(354),
    [sym_delete_state] = STATE(354),
    [sym_read_state] = STATE(354),
    [sym_set_lock] = STATE(354),
    [sym_remove_lock] = STATE(354),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(205),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [33] = {
    [sym__process] = STATE(556),
    [sym__elementary_process] = STATE(556),
    [sym__extended_process] = STATE(556),
    [sym__stateful_process] = STATE(556),
    [sym_location_process] = STATE(556),
    [sym_inline_msr_process] = STATE(556),
    [sym__nested_process] = STATE(556),
    [sym_predefined_process] = STATE(556),
    [sym_binding] = STATE(556),
    [sym_output] = STATE(556),
    [sym_input] = STATE(556),
    [sym_conditional] = STATE(556),
    [sym_process_let] = STATE(556),
    [sym_deterministic_choice] = STATE(556),
    [sym_non_deterministic_choice] = STATE(556),
    [sym_event] = STATE(556),
    [sym_replication] = STATE(556),
    [sym_set_state] = STATE(556),
    [sym_delete_state] = STATE(556),
    [sym_read_state] = STATE(556),
    [sym_set_lock] = STATE(556),
    [sym_remove_lock] = STATE(556),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(207),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [34] = {
    [sym__process] = STATE(868),
    [sym__elementary_process] = STATE(868),
    [sym__extended_process] = STATE(868),
    [sym__stateful_process] = STATE(868),
    [sym_location_process] = STATE(868),
    [sym_inline_msr_process] = STATE(868),
    [sym__nested_process] = STATE(868),
    [sym_predefined_process] = STATE(868),
    [sym_binding] = STATE(868),
    [sym_output] = STATE(868),
    [sym_input] = STATE(868),
    [sym_conditional] = STATE(868),
    [sym_process_let] = STATE(868),
    [sym_deterministic_choice] = STATE(868),
    [sym_non_deterministic_choice] = STATE(868),
    [sym_event] = STATE(868),
    [sym_replication] = STATE(868),
    [sym_set_state] = STATE(868),
    [sym_delete_state] = STATE(868),
    [sym_read_state] = STATE(868),
    [sym_set_lock] = STATE(868),
    [sym_remove_lock] = STATE(868),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(744),
    [sym_tuple_term] = STATE(744),
    [sym_mset_term] = STATE(744),
    [sym_nat_term] = STATE(744),
    [sym_xor_term] = STATE(744),
    [sym_mul_term] = STATE(744),
    [sym_exp_term] = STATE(744),
    [sym_nested_term] = STATE(744),
    [sym_nullary_fun] = STATE(744),
    [sym_binary_app] = STATE(744),
    [sym_nary_app] = STATE(744),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(209),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [35] = {
    [sym__process] = STATE(557),
    [sym__elementary_process] = STATE(557),
    [sym__extended_process] = STATE(557),
    [sym__stateful_process] = STATE(557),
    [sym_location_process] = STATE(557),
    [sym_inline_msr_process] = STATE(557),
    [sym__nested_process] = STATE(557),
    [sym_predefined_process] = STATE(557),
    [sym_binding] = STATE(557),
    [sym_output] = STATE(557),
    [sym_input] = STATE(557),
    [sym_conditional] = STATE(557),
    [sym_process_let] = STATE(557),
    [sym_deterministic_choice] = STATE(557),
    [sym_non_deterministic_choice] = STATE(557),
    [sym_event] = STATE(557),
    [sym_replication] = STATE(557),
    [sym_set_state] = STATE(557),
    [sym_delete_state] = STATE(557),
    [sym_read_state] = STATE(557),
    [sym_set_lock] = STATE(557),
    [sym_remove_lock] = STATE(557),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(211),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [36] = {
    [sym__process] = STATE(554),
    [sym__elementary_process] = STATE(554),
    [sym__extended_process] = STATE(554),
    [sym__stateful_process] = STATE(554),
    [sym_location_process] = STATE(554),
    [sym_inline_msr_process] = STATE(554),
    [sym__nested_process] = STATE(554),
    [sym_predefined_process] = STATE(554),
    [sym_binding] = STATE(554),
    [sym_output] = STATE(554),
    [sym_input] = STATE(554),
    [sym_conditional] = STATE(554),
    [sym_process_let] = STATE(554),
    [sym_deterministic_choice] = STATE(554),
    [sym_non_deterministic_choice] = STATE(554),
    [sym_event] = STATE(554),
    [sym_replication] = STATE(554),
    [sym_set_state] = STATE(554),
    [sym_delete_state] = STATE(554),
    [sym_read_state] = STATE(554),
    [sym_set_lock] = STATE(554),
    [sym_remove_lock] = STATE(554),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(213),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [37] = {
    [sym__process] = STATE(355),
    [sym__elementary_process] = STATE(355),
    [sym__extended_process] = STATE(355),
    [sym__stateful_process] = STATE(355),
    [sym_location_process] = STATE(355),
    [sym_inline_msr_process] = STATE(355),
    [sym__nested_process] = STATE(355),
    [sym_predefined_process] = STATE(355),
    [sym_binding] = STATE(355),
    [sym_output] = STATE(355),
    [sym_input] = STATE(355),
    [sym_conditional] = STATE(355),
    [sym_process_let] = STATE(355),
    [sym_deterministic_choice] = STATE(355),
    [sym_non_deterministic_choice] = STATE(355),
    [sym_event] = STATE(355),
    [sym_replication] = STATE(355),
    [sym_set_state] = STATE(355),
    [sym_delete_state] = STATE(355),
    [sym_read_state] = STATE(355),
    [sym_set_lock] = STATE(355),
    [sym_remove_lock] = STATE(355),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(215),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [38] = {
    [sym__process] = STATE(549),
    [sym__elementary_process] = STATE(549),
    [sym__extended_process] = STATE(549),
    [sym__stateful_process] = STATE(549),
    [sym_location_process] = STATE(549),
    [sym_inline_msr_process] = STATE(549),
    [sym__nested_process] = STATE(549),
    [sym_predefined_process] = STATE(549),
    [sym_binding] = STATE(549),
    [sym_output] = STATE(549),
    [sym_input] = STATE(549),
    [sym_conditional] = STATE(549),
    [sym_process_let] = STATE(549),
    [sym_deterministic_choice] = STATE(549),
    [sym_non_deterministic_choice] = STATE(549),
    [sym_event] = STATE(549),
    [sym_replication] = STATE(549),
    [sym_set_state] = STATE(549),
    [sym_delete_state] = STATE(549),
    [sym_read_state] = STATE(549),
    [sym_set_lock] = STATE(549),
    [sym_remove_lock] = STATE(549),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(217),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [39] = {
    [sym__process] = STATE(353),
    [sym__elementary_process] = STATE(353),
    [sym__extended_process] = STATE(353),
    [sym__stateful_process] = STATE(353),
    [sym_location_process] = STATE(353),
    [sym_inline_msr_process] = STATE(353),
    [sym__nested_process] = STATE(353),
    [sym_predefined_process] = STATE(353),
    [sym_binding] = STATE(353),
    [sym_output] = STATE(353),
    [sym_input] = STATE(353),
    [sym_conditional] = STATE(353),
    [sym_process_let] = STATE(353),
    [sym_deterministic_choice] = STATE(353),
    [sym_non_deterministic_choice] = STATE(353),
    [sym_event] = STATE(353),
    [sym_replication] = STATE(353),
    [sym_set_state] = STATE(353),
    [sym_delete_state] = STATE(353),
    [sym_read_state] = STATE(353),
    [sym_set_lock] = STATE(353),
    [sym_remove_lock] = STATE(353),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(219),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [40] = {
    [sym__process] = STATE(348),
    [sym__elementary_process] = STATE(348),
    [sym__extended_process] = STATE(348),
    [sym__stateful_process] = STATE(348),
    [sym_location_process] = STATE(348),
    [sym_inline_msr_process] = STATE(348),
    [sym__nested_process] = STATE(348),
    [sym_predefined_process] = STATE(348),
    [sym_binding] = STATE(348),
    [sym_output] = STATE(348),
    [sym_input] = STATE(348),
    [sym_conditional] = STATE(348),
    [sym_process_let] = STATE(348),
    [sym_deterministic_choice] = STATE(348),
    [sym_non_deterministic_choice] = STATE(348),
    [sym_event] = STATE(348),
    [sym_replication] = STATE(348),
    [sym_set_state] = STATE(348),
    [sym_delete_state] = STATE(348),
    [sym_read_state] = STATE(348),
    [sym_set_lock] = STATE(348),
    [sym_remove_lock] = STATE(348),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(221),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [41] = {
    [sym__process] = STATE(340),
    [sym__elementary_process] = STATE(340),
    [sym__extended_process] = STATE(340),
    [sym__stateful_process] = STATE(340),
    [sym_location_process] = STATE(340),
    [sym_inline_msr_process] = STATE(340),
    [sym__nested_process] = STATE(340),
    [sym_predefined_process] = STATE(340),
    [sym_binding] = STATE(340),
    [sym_output] = STATE(340),
    [sym_input] = STATE(340),
    [sym_conditional] = STATE(340),
    [sym_process_let] = STATE(340),
    [sym_deterministic_choice] = STATE(340),
    [sym_non_deterministic_choice] = STATE(340),
    [sym_event] = STATE(340),
    [sym_replication] = STATE(340),
    [sym_set_state] = STATE(340),
    [sym_delete_state] = STATE(340),
    [sym_read_state] = STATE(340),
    [sym_set_lock] = STATE(340),
    [sym_remove_lock] = STATE(340),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(223),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [42] = {
    [sym__process] = STATE(327),
    [sym__elementary_process] = STATE(327),
    [sym__extended_process] = STATE(327),
    [sym__stateful_process] = STATE(327),
    [sym_location_process] = STATE(327),
    [sym_inline_msr_process] = STATE(327),
    [sym__nested_process] = STATE(327),
    [sym_predefined_process] = STATE(327),
    [sym_binding] = STATE(327),
    [sym_output] = STATE(327),
    [sym_input] = STATE(327),
    [sym_conditional] = STATE(327),
    [sym_process_let] = STATE(327),
    [sym_deterministic_choice] = STATE(327),
    [sym_non_deterministic_choice] = STATE(327),
    [sym_event] = STATE(327),
    [sym_replication] = STATE(327),
    [sym_set_state] = STATE(327),
    [sym_delete_state] = STATE(327),
    [sym_read_state] = STATE(327),
    [sym_set_lock] = STATE(327),
    [sym_remove_lock] = STATE(327),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(225),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [43] = {
    [sym__process] = STATE(541),
    [sym__elementary_process] = STATE(541),
    [sym__extended_process] = STATE(541),
    [sym__stateful_process] = STATE(541),
    [sym_location_process] = STATE(541),
    [sym_inline_msr_process] = STATE(541),
    [sym__nested_process] = STATE(541),
    [sym_predefined_process] = STATE(541),
    [sym_binding] = STATE(541),
    [sym_output] = STATE(541),
    [sym_input] = STATE(541),
    [sym_conditional] = STATE(541),
    [sym_process_let] = STATE(541),
    [sym_deterministic_choice] = STATE(541),
    [sym_non_deterministic_choice] = STATE(541),
    [sym_event] = STATE(541),
    [sym_replication] = STATE(541),
    [sym_set_state] = STATE(541),
    [sym_delete_state] = STATE(541),
    [sym_read_state] = STATE(541),
    [sym_set_lock] = STATE(541),
    [sym_remove_lock] = STATE(541),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(227),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [44] = {
    [sym__process] = STATE(328),
    [sym__elementary_process] = STATE(328),
    [sym__extended_process] = STATE(328),
    [sym__stateful_process] = STATE(328),
    [sym_location_process] = STATE(328),
    [sym_inline_msr_process] = STATE(328),
    [sym__nested_process] = STATE(328),
    [sym_predefined_process] = STATE(328),
    [sym_binding] = STATE(328),
    [sym_output] = STATE(328),
    [sym_input] = STATE(328),
    [sym_conditional] = STATE(328),
    [sym_process_let] = STATE(328),
    [sym_deterministic_choice] = STATE(328),
    [sym_non_deterministic_choice] = STATE(328),
    [sym_event] = STATE(328),
    [sym_replication] = STATE(328),
    [sym_set_state] = STATE(328),
    [sym_delete_state] = STATE(328),
    [sym_read_state] = STATE(328),
    [sym_set_lock] = STATE(328),
    [sym_remove_lock] = STATE(328),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(229),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [45] = {
    [sym__process] = STATE(470),
    [sym__elementary_process] = STATE(470),
    [sym__extended_process] = STATE(470),
    [sym__stateful_process] = STATE(470),
    [sym_location_process] = STATE(470),
    [sym_inline_msr_process] = STATE(470),
    [sym__nested_process] = STATE(470),
    [sym_predefined_process] = STATE(470),
    [sym_binding] = STATE(470),
    [sym_output] = STATE(470),
    [sym_input] = STATE(470),
    [sym_conditional] = STATE(470),
    [sym_process_let] = STATE(470),
    [sym_deterministic_choice] = STATE(470),
    [sym_non_deterministic_choice] = STATE(470),
    [sym_event] = STATE(470),
    [sym_replication] = STATE(470),
    [sym_set_state] = STATE(470),
    [sym_delete_state] = STATE(470),
    [sym_read_state] = STATE(470),
    [sym_set_lock] = STATE(470),
    [sym_remove_lock] = STATE(470),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(231),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [46] = {
    [sym__process] = STATE(351),
    [sym__elementary_process] = STATE(351),
    [sym__extended_process] = STATE(351),
    [sym__stateful_process] = STATE(351),
    [sym_location_process] = STATE(351),
    [sym_inline_msr_process] = STATE(351),
    [sym__nested_process] = STATE(351),
    [sym_predefined_process] = STATE(351),
    [sym_binding] = STATE(351),
    [sym_output] = STATE(351),
    [sym_input] = STATE(351),
    [sym_conditional] = STATE(351),
    [sym_process_let] = STATE(351),
    [sym_deterministic_choice] = STATE(351),
    [sym_non_deterministic_choice] = STATE(351),
    [sym_event] = STATE(351),
    [sym_replication] = STATE(351),
    [sym_set_state] = STATE(351),
    [sym_delete_state] = STATE(351),
    [sym_read_state] = STATE(351),
    [sym_set_lock] = STATE(351),
    [sym_remove_lock] = STATE(351),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(233),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [47] = {
    [sym__process] = STATE(3),
    [sym__elementary_process] = STATE(3),
    [sym__extended_process] = STATE(3),
    [sym__stateful_process] = STATE(3),
    [sym_location_process] = STATE(3),
    [sym_inline_msr_process] = STATE(3),
    [sym__nested_process] = STATE(3),
    [sym_predefined_process] = STATE(3),
    [sym_binding] = STATE(3),
    [sym_output] = STATE(3),
    [sym_input] = STATE(3),
    [sym_conditional] = STATE(3),
    [sym_process_let] = STATE(3),
    [sym_deterministic_choice] = STATE(3),
    [sym_non_deterministic_choice] = STATE(3),
    [sym_event] = STATE(3),
    [sym_replication] = STATE(3),
    [sym_set_state] = STATE(3),
    [sym_delete_state] = STATE(3),
    [sym_read_state] = STATE(3),
    [sym_set_lock] = STATE(3),
    [sym_remove_lock] = STATE(3),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(235),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [48] = {
    [sym__process] = STATE(329),
    [sym__elementary_process] = STATE(329),
    [sym__extended_process] = STATE(329),
    [sym__stateful_process] = STATE(329),
    [sym_location_process] = STATE(329),
    [sym_inline_msr_process] = STATE(329),
    [sym__nested_process] = STATE(329),
    [sym_predefined_process] = STATE(329),
    [sym_binding] = STATE(329),
    [sym_output] = STATE(329),
    [sym_input] = STATE(329),
    [sym_conditional] = STATE(329),
    [sym_process_let] = STATE(329),
    [sym_deterministic_choice] = STATE(329),
    [sym_non_deterministic_choice] = STATE(329),
    [sym_event] = STATE(329),
    [sym_replication] = STATE(329),
    [sym_set_state] = STATE(329),
    [sym_delete_state] = STATE(329),
    [sym_read_state] = STATE(329),
    [sym_set_lock] = STATE(329),
    [sym_remove_lock] = STATE(329),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(237),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [49] = {
    [sym__process] = STATE(476),
    [sym__elementary_process] = STATE(476),
    [sym__extended_process] = STATE(476),
    [sym__stateful_process] = STATE(476),
    [sym_location_process] = STATE(476),
    [sym_inline_msr_process] = STATE(476),
    [sym__nested_process] = STATE(476),
    [sym_predefined_process] = STATE(476),
    [sym_binding] = STATE(476),
    [sym_output] = STATE(476),
    [sym_input] = STATE(476),
    [sym_conditional] = STATE(476),
    [sym_process_let] = STATE(476),
    [sym_deterministic_choice] = STATE(476),
    [sym_non_deterministic_choice] = STATE(476),
    [sym_event] = STATE(476),
    [sym_replication] = STATE(476),
    [sym_set_state] = STATE(476),
    [sym_delete_state] = STATE(476),
    [sym_read_state] = STATE(476),
    [sym_set_lock] = STATE(476),
    [sym_remove_lock] = STATE(476),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(239),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [50] = {
    [sym__condition] = STATE(1124),
    [sym_equality_check] = STATE(1124),
    [sym_lesser_check] = STATE(1124),
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(718),
    [sym_tuple_term] = STATE(718),
    [sym_mset_term] = STATE(718),
    [sym_nat_term] = STATE(718),
    [sym_xor_term] = STATE(718),
    [sym_mul_term] = STATE(718),
    [sym_exp_term] = STATE(718),
    [sym_nested_term] = STATE(718),
    [sym_nullary_fun] = STATE(718),
    [sym_binary_app] = STATE(718),
    [sym_nary_app] = STATE(718),
    [sym__literal] = STATE(689),
    [sym__non_temporal_var] = STATE(689),
    [sym_pub_var] = STATE(689),
    [sym_fresh_var] = STATE(689),
    [sym_msg_var_or_nullary_fun] = STATE(689),
    [sym_nat_var] = STATE(689),
    [sym_comp_var] = STATE(689),
    [sym__custom_type_var] = STATE(689),
    [sym_custom_var] = STATE(689),
    [sym_any_var] = STATE(689),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(689),
    [sym_fresh_name] = STATE(689),
    [sym__formula] = STATE(782),
    [sym_iff] = STATE(782),
    [sym_imp] = STATE(782),
    [sym_disjunction] = STATE(782),
    [sym_conjunction] = STATE(782),
    [sym_negation] = STATE(782),
    [sym_nested_formula] = STATE(782),
    [sym__temporal_variable_operation] = STATE(782),
    [sym_temp_var_induction] = STATE(782),
    [sym_temp_var_order] = STATE(782),
    [sym_temp_var_eq] = STATE(782),
    [sym_action_constraint] = STATE(782),
    [sym_term_eq] = STATE(782),
    [sym_subterm_rel] = STATE(782),
    [sym_quantified_formula] = STATE(782),
    [sym_atom] = STATE(782),
    [sym_predicate_ref] = STATE(737),
    [sym_pre_defined] = STATE(782),
    [sym_ident] = ACTIONS(145),
    [anon_sym_EQ] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(153),
    [anon_sym_DOLLAR] = ACTIONS(155),
    [anon_sym_TILDE] = ACTIONS(157),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(159),
    [anon_sym_SQUOTE] = ACTIONS(161),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(163),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [51] = {
    [sym__process] = STATE(325),
    [sym__elementary_process] = STATE(325),
    [sym__extended_process] = STATE(325),
    [sym__stateful_process] = STATE(325),
    [sym_location_process] = STATE(325),
    [sym_inline_msr_process] = STATE(325),
    [sym__nested_process] = STATE(325),
    [sym_predefined_process] = STATE(325),
    [sym_binding] = STATE(325),
    [sym_output] = STATE(325),
    [sym_input] = STATE(325),
    [sym_conditional] = STATE(325),
    [sym_process_let] = STATE(325),
    [sym_deterministic_choice] = STATE(325),
    [sym_non_deterministic_choice] = STATE(325),
    [sym_event] = STATE(325),
    [sym_replication] = STATE(325),
    [sym_set_state] = STATE(325),
    [sym_delete_state] = STATE(325),
    [sym_read_state] = STATE(325),
    [sym_set_lock] = STATE(325),
    [sym_remove_lock] = STATE(325),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(241),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [52] = {
    [sym__process] = STATE(542),
    [sym__elementary_process] = STATE(542),
    [sym__extended_process] = STATE(542),
    [sym__stateful_process] = STATE(542),
    [sym_location_process] = STATE(542),
    [sym_inline_msr_process] = STATE(542),
    [sym__nested_process] = STATE(542),
    [sym_predefined_process] = STATE(542),
    [sym_binding] = STATE(542),
    [sym_output] = STATE(542),
    [sym_input] = STATE(542),
    [sym_conditional] = STATE(542),
    [sym_process_let] = STATE(542),
    [sym_deterministic_choice] = STATE(542),
    [sym_non_deterministic_choice] = STATE(542),
    [sym_event] = STATE(542),
    [sym_replication] = STATE(542),
    [sym_set_state] = STATE(542),
    [sym_delete_state] = STATE(542),
    [sym_read_state] = STATE(542),
    [sym_set_lock] = STATE(542),
    [sym_remove_lock] = STATE(542),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(243),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [53] = {
    [sym__process] = STATE(346),
    [sym__elementary_process] = STATE(346),
    [sym__extended_process] = STATE(346),
    [sym__stateful_process] = STATE(346),
    [sym_location_process] = STATE(346),
    [sym_inline_msr_process] = STATE(346),
    [sym__nested_process] = STATE(346),
    [sym_predefined_process] = STATE(346),
    [sym_binding] = STATE(346),
    [sym_output] = STATE(346),
    [sym_input] = STATE(346),
    [sym_conditional] = STATE(346),
    [sym_process_let] = STATE(346),
    [sym_deterministic_choice] = STATE(346),
    [sym_non_deterministic_choice] = STATE(346),
    [sym_event] = STATE(346),
    [sym_replication] = STATE(346),
    [sym_set_state] = STATE(346),
    [sym_delete_state] = STATE(346),
    [sym_read_state] = STATE(346),
    [sym_set_lock] = STATE(346),
    [sym_remove_lock] = STATE(346),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(245),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [54] = {
    [sym__process] = STATE(543),
    [sym__elementary_process] = STATE(543),
    [sym__extended_process] = STATE(543),
    [sym__stateful_process] = STATE(543),
    [sym_location_process] = STATE(543),
    [sym_inline_msr_process] = STATE(543),
    [sym__nested_process] = STATE(543),
    [sym_predefined_process] = STATE(543),
    [sym_binding] = STATE(543),
    [sym_output] = STATE(543),
    [sym_input] = STATE(543),
    [sym_conditional] = STATE(543),
    [sym_process_let] = STATE(543),
    [sym_deterministic_choice] = STATE(543),
    [sym_non_deterministic_choice] = STATE(543),
    [sym_event] = STATE(543),
    [sym_replication] = STATE(543),
    [sym_set_state] = STATE(543),
    [sym_delete_state] = STATE(543),
    [sym_read_state] = STATE(543),
    [sym_set_lock] = STATE(543),
    [sym_remove_lock] = STATE(543),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(247),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [55] = {
    [sym__process] = STATE(546),
    [sym__elementary_process] = STATE(546),
    [sym__extended_process] = STATE(546),
    [sym__stateful_process] = STATE(546),
    [sym_location_process] = STATE(546),
    [sym_inline_msr_process] = STATE(546),
    [sym__nested_process] = STATE(546),
    [sym_predefined_process] = STATE(546),
    [sym_binding] = STATE(546),
    [sym_output] = STATE(546),
    [sym_input] = STATE(546),
    [sym_conditional] = STATE(546),
    [sym_process_let] = STATE(546),
    [sym_deterministic_choice] = STATE(546),
    [sym_non_deterministic_choice] = STATE(546),
    [sym_event] = STATE(546),
    [sym_replication] = STATE(546),
    [sym_set_state] = STATE(546),
    [sym_delete_state] = STATE(546),
    [sym_read_state] = STATE(546),
    [sym_set_lock] = STATE(546),
    [sym_remove_lock] = STATE(546),
    [sym_premise] = STATE(909),
    [sym__term] = STATE(311),
    [sym_tuple_term] = STATE(311),
    [sym_mset_term] = STATE(311),
    [sym_nat_term] = STATE(311),
    [sym_xor_term] = STATE(311),
    [sym_mul_term] = STATE(311),
    [sym_exp_term] = STATE(311),
    [sym_nested_term] = STATE(311),
    [sym_nullary_fun] = STATE(311),
    [sym_binary_app] = STATE(311),
    [sym_nary_app] = STATE(311),
    [sym__literal] = STATE(283),
    [sym__non_temporal_var] = STATE(283),
    [sym_pub_var] = STATE(283),
    [sym_fresh_var] = STATE(283),
    [sym_msg_var_or_nullary_fun] = STATE(283),
    [sym_nat_var] = STATE(283),
    [sym_comp_var] = STATE(283),
    [sym__custom_type_var] = STATE(283),
    [sym_custom_var] = STATE(283),
    [sym_any_var] = STATE(283),
    [sym_pub_name] = STATE(283),
    [sym_fresh_name] = STATE(283),
    [sym_ident] = ACTIONS(83),
    [anon_sym_EQ] = ACTIONS(85),
    [anon_sym_LPAREN] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(89),
    [anon_sym_out] = ACTIONS(91),
    [anon_sym_in] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(95),
    [anon_sym_let] = ACTIONS(97),
    [sym_null] = ACTIONS(249),
    [anon_sym_event] = ACTIONS(101),
    [anon_sym_BANG] = ACTIONS(103),
    [anon_sym_insert] = ACTIONS(105),
    [anon_sym_delete] = ACTIONS(107),
    [anon_sym_lookup] = ACTIONS(109),
    [anon_sym_lock] = ACTIONS(111),
    [anon_sym_unlock] = ACTIONS(113),
    [anon_sym_LT] = ACTIONS(115),
    [anon_sym_DOLLAR] = ACTIONS(117),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_PERCENT] = ACTIONS(121),
    [anon_sym_SQUOTE] = ACTIONS(123),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(125),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [56] = {
    [sym__process] = STATE(341),
    [sym__elementary_process] = STATE(341),
    [sym__extended_process] = STATE(341),
    [sym__stateful_process] = STATE(341),
    [sym_location_process] = STATE(341),
    [sym_inline_msr_process] = STATE(341),
    [sym__nested_process] = STATE(341),
    [sym_predefined_process] = STATE(341),
    [sym_binding] = STATE(341),
    [sym_output] = STATE(341),
    [sym_input] = STATE(341),
    [sym_conditional] = STATE(341),
    [sym_process_let] = STATE(341),
    [sym_deterministic_choice] = STATE(341),
    [sym_non_deterministic_choice] = STATE(341),
    [sym_event] = STATE(341),
    [sym_replication] = STATE(341),
    [sym_set_state] = STATE(341),
    [sym_delete_state] = STATE(341),
    [sym_read_state] = STATE(341),
    [sym_set_lock] = STATE(341),
    [sym_remove_lock] = STATE(341),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(251),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [57] = {
    [sym__process] = STATE(324),
    [sym__elementary_process] = STATE(324),
    [sym__extended_process] = STATE(324),
    [sym__stateful_process] = STATE(324),
    [sym_location_process] = STATE(324),
    [sym_inline_msr_process] = STATE(324),
    [sym__nested_process] = STATE(324),
    [sym_predefined_process] = STATE(324),
    [sym_binding] = STATE(324),
    [sym_output] = STATE(324),
    [sym_input] = STATE(324),
    [sym_conditional] = STATE(324),
    [sym_process_let] = STATE(324),
    [sym_deterministic_choice] = STATE(324),
    [sym_non_deterministic_choice] = STATE(324),
    [sym_event] = STATE(324),
    [sym_replication] = STATE(324),
    [sym_set_state] = STATE(324),
    [sym_delete_state] = STATE(324),
    [sym_read_state] = STATE(324),
    [sym_set_lock] = STATE(324),
    [sym_remove_lock] = STATE(324),
    [sym_premise] = STATE(905),
    [sym__term] = STATE(237),
    [sym_tuple_term] = STATE(237),
    [sym_mset_term] = STATE(237),
    [sym_nat_term] = STATE(237),
    [sym_xor_term] = STATE(237),
    [sym_mul_term] = STATE(237),
    [sym_exp_term] = STATE(237),
    [sym_nested_term] = STATE(237),
    [sym_nullary_fun] = STATE(237),
    [sym_binary_app] = STATE(237),
    [sym_nary_app] = STATE(237),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym_ident] = ACTIONS(45),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(47),
    [anon_sym_LBRACK] = ACTIONS(51),
    [anon_sym_new] = ACTIONS(53),
    [anon_sym_out] = ACTIONS(55),
    [anon_sym_in] = ACTIONS(57),
    [anon_sym_if] = ACTIONS(59),
    [anon_sym_let] = ACTIONS(61),
    [sym_null] = ACTIONS(253),
    [anon_sym_event] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(71),
    [anon_sym_insert] = ACTIONS(73),
    [anon_sym_delete] = ACTIONS(75),
    [anon_sym_lookup] = ACTIONS(77),
    [anon_sym_lock] = ACTIONS(79),
    [anon_sym_unlock] = ACTIONS(81),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [58] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(730),
    [sym_tuple_term] = STATE(730),
    [sym_mset_term] = STATE(730),
    [sym_nat_term] = STATE(730),
    [sym_xor_term] = STATE(730),
    [sym_mul_term] = STATE(730),
    [sym_exp_term] = STATE(730),
    [sym_nested_term] = STATE(730),
    [sym_nullary_fun] = STATE(730),
    [sym_binary_app] = STATE(730),
    [sym_nary_app] = STATE(730),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_temporal_var] = STATE(1097),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(781),
    [sym_iff] = STATE(781),
    [sym_imp] = STATE(781),
    [sym_disjunction] = STATE(781),
    [sym_conjunction] = STATE(781),
    [sym_negation] = STATE(781),
    [sym_nested_formula] = STATE(781),
    [sym__temporal_variable_operation] = STATE(781),
    [sym_temp_var_induction] = STATE(781),
    [sym_temp_var_order] = STATE(781),
    [sym_temp_var_eq] = STATE(781),
    [sym_action_constraint] = STATE(781),
    [sym_term_eq] = STATE(781),
    [sym_subterm_rel] = STATE(781),
    [sym_quantified_formula] = STATE(781),
    [sym_atom] = STATE(781),
    [sym_predicate_ref] = STATE(781),
    [sym_pre_defined] = STATE(781),
    [sym_ident] = ACTIONS(255),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(261),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [59] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(771),
    [sym_iff] = STATE(771),
    [sym_imp] = STATE(771),
    [sym_disjunction] = STATE(771),
    [sym_conjunction] = STATE(771),
    [sym_negation] = STATE(771),
    [sym_nested_formula] = STATE(771),
    [sym__temporal_variable_operation] = STATE(771),
    [sym_temp_var_induction] = STATE(771),
    [sym_temp_var_order] = STATE(771),
    [sym_temp_var_eq] = STATE(771),
    [sym_action_constraint] = STATE(771),
    [sym_term_eq] = STATE(771),
    [sym_subterm_rel] = STATE(771),
    [sym_quantified_formula] = STATE(771),
    [sym_atom] = STATE(771),
    [sym_predicate_ref] = STATE(771),
    [sym_pre_defined] = STATE(771),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [60] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(773),
    [sym_iff] = STATE(773),
    [sym_imp] = STATE(773),
    [sym_disjunction] = STATE(773),
    [sym_conjunction] = STATE(773),
    [sym_negation] = STATE(773),
    [sym_nested_formula] = STATE(773),
    [sym__temporal_variable_operation] = STATE(773),
    [sym_temp_var_induction] = STATE(773),
    [sym_temp_var_order] = STATE(773),
    [sym_temp_var_eq] = STATE(773),
    [sym_action_constraint] = STATE(773),
    [sym_term_eq] = STATE(773),
    [sym_subterm_rel] = STATE(773),
    [sym_quantified_formula] = STATE(773),
    [sym_atom] = STATE(773),
    [sym_predicate_ref] = STATE(773),
    [sym_pre_defined] = STATE(773),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [61] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(775),
    [sym_iff] = STATE(775),
    [sym_imp] = STATE(775),
    [sym_disjunction] = STATE(775),
    [sym_conjunction] = STATE(775),
    [sym_negation] = STATE(775),
    [sym_nested_formula] = STATE(775),
    [sym__temporal_variable_operation] = STATE(775),
    [sym_temp_var_induction] = STATE(775),
    [sym_temp_var_order] = STATE(775),
    [sym_temp_var_eq] = STATE(775),
    [sym_action_constraint] = STATE(775),
    [sym_term_eq] = STATE(775),
    [sym_subterm_rel] = STATE(775),
    [sym_quantified_formula] = STATE(775),
    [sym_atom] = STATE(775),
    [sym_predicate_ref] = STATE(775),
    [sym_pre_defined] = STATE(775),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [62] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(216),
    [sym_iff] = STATE(216),
    [sym_imp] = STATE(216),
    [sym_disjunction] = STATE(216),
    [sym_conjunction] = STATE(216),
    [sym_negation] = STATE(216),
    [sym_nested_formula] = STATE(216),
    [sym__temporal_variable_operation] = STATE(216),
    [sym_temp_var_induction] = STATE(216),
    [sym_temp_var_order] = STATE(216),
    [sym_temp_var_eq] = STATE(216),
    [sym_action_constraint] = STATE(216),
    [sym_term_eq] = STATE(216),
    [sym_subterm_rel] = STATE(216),
    [sym_quantified_formula] = STATE(216),
    [sym_atom] = STATE(216),
    [sym_predicate_ref] = STATE(216),
    [sym_pre_defined] = STATE(216),
    [sym_ident] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [63] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(784),
    [sym_iff] = STATE(784),
    [sym_imp] = STATE(784),
    [sym_disjunction] = STATE(784),
    [sym_conjunction] = STATE(784),
    [sym_negation] = STATE(784),
    [sym_nested_formula] = STATE(784),
    [sym__temporal_variable_operation] = STATE(784),
    [sym_temp_var_induction] = STATE(784),
    [sym_temp_var_order] = STATE(784),
    [sym_temp_var_eq] = STATE(784),
    [sym_action_constraint] = STATE(784),
    [sym_term_eq] = STATE(784),
    [sym_subterm_rel] = STATE(784),
    [sym_quantified_formula] = STATE(784),
    [sym_atom] = STATE(784),
    [sym_predicate_ref] = STATE(784),
    [sym_pre_defined] = STATE(784),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [64] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(216),
    [sym_iff] = STATE(216),
    [sym_imp] = STATE(216),
    [sym_disjunction] = STATE(216),
    [sym_conjunction] = STATE(216),
    [sym_negation] = STATE(216),
    [sym_nested_formula] = STATE(216),
    [sym__temporal_variable_operation] = STATE(216),
    [sym_temp_var_induction] = STATE(216),
    [sym_temp_var_order] = STATE(216),
    [sym_temp_var_eq] = STATE(216),
    [sym_action_constraint] = STATE(216),
    [sym_term_eq] = STATE(216),
    [sym_subterm_rel] = STATE(216),
    [sym_quantified_formula] = STATE(216),
    [sym_atom] = STATE(216),
    [sym_predicate_ref] = STATE(216),
    [sym_pre_defined] = STATE(216),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [65] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(241),
    [sym_iff] = STATE(241),
    [sym_imp] = STATE(241),
    [sym_disjunction] = STATE(241),
    [sym_conjunction] = STATE(241),
    [sym_negation] = STATE(241),
    [sym_nested_formula] = STATE(241),
    [sym__temporal_variable_operation] = STATE(241),
    [sym_temp_var_induction] = STATE(241),
    [sym_temp_var_order] = STATE(241),
    [sym_temp_var_eq] = STATE(241),
    [sym_action_constraint] = STATE(241),
    [sym_term_eq] = STATE(241),
    [sym_subterm_rel] = STATE(241),
    [sym_quantified_formula] = STATE(241),
    [sym_atom] = STATE(241),
    [sym_predicate_ref] = STATE(241),
    [sym_pre_defined] = STATE(241),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [66] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(242),
    [sym_iff] = STATE(242),
    [sym_imp] = STATE(242),
    [sym_disjunction] = STATE(242),
    [sym_conjunction] = STATE(242),
    [sym_negation] = STATE(242),
    [sym_nested_formula] = STATE(242),
    [sym__temporal_variable_operation] = STATE(242),
    [sym_temp_var_induction] = STATE(242),
    [sym_temp_var_order] = STATE(242),
    [sym_temp_var_eq] = STATE(242),
    [sym_action_constraint] = STATE(242),
    [sym_term_eq] = STATE(242),
    [sym_subterm_rel] = STATE(242),
    [sym_quantified_formula] = STATE(242),
    [sym_atom] = STATE(242),
    [sym_predicate_ref] = STATE(242),
    [sym_pre_defined] = STATE(242),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [67] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(215),
    [sym_iff] = STATE(215),
    [sym_imp] = STATE(215),
    [sym_disjunction] = STATE(215),
    [sym_conjunction] = STATE(215),
    [sym_negation] = STATE(215),
    [sym_nested_formula] = STATE(215),
    [sym__temporal_variable_operation] = STATE(215),
    [sym_temp_var_induction] = STATE(215),
    [sym_temp_var_order] = STATE(215),
    [sym_temp_var_eq] = STATE(215),
    [sym_action_constraint] = STATE(215),
    [sym_term_eq] = STATE(215),
    [sym_subterm_rel] = STATE(215),
    [sym_quantified_formula] = STATE(215),
    [sym_atom] = STATE(215),
    [sym_predicate_ref] = STATE(215),
    [sym_pre_defined] = STATE(215),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [68] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(244),
    [sym_iff] = STATE(244),
    [sym_imp] = STATE(244),
    [sym_disjunction] = STATE(244),
    [sym_conjunction] = STATE(244),
    [sym_negation] = STATE(244),
    [sym_nested_formula] = STATE(244),
    [sym__temporal_variable_operation] = STATE(244),
    [sym_temp_var_induction] = STATE(244),
    [sym_temp_var_order] = STATE(244),
    [sym_temp_var_eq] = STATE(244),
    [sym_action_constraint] = STATE(244),
    [sym_term_eq] = STATE(244),
    [sym_subterm_rel] = STATE(244),
    [sym_quantified_formula] = STATE(244),
    [sym_atom] = STATE(244),
    [sym_predicate_ref] = STATE(244),
    [sym_pre_defined] = STATE(244),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [69] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(218),
    [sym_iff] = STATE(218),
    [sym_imp] = STATE(218),
    [sym_disjunction] = STATE(218),
    [sym_conjunction] = STATE(218),
    [sym_negation] = STATE(218),
    [sym_nested_formula] = STATE(218),
    [sym__temporal_variable_operation] = STATE(218),
    [sym_temp_var_induction] = STATE(218),
    [sym_temp_var_order] = STATE(218),
    [sym_temp_var_eq] = STATE(218),
    [sym_action_constraint] = STATE(218),
    [sym_term_eq] = STATE(218),
    [sym_subterm_rel] = STATE(218),
    [sym_quantified_formula] = STATE(218),
    [sym_atom] = STATE(218),
    [sym_predicate_ref] = STATE(218),
    [sym_pre_defined] = STATE(218),
    [sym_ident] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [70] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(731),
    [sym_tuple_term] = STATE(731),
    [sym_mset_term] = STATE(731),
    [sym_nat_term] = STATE(731),
    [sym_xor_term] = STATE(731),
    [sym_mul_term] = STATE(731),
    [sym_exp_term] = STATE(731),
    [sym_nested_term] = STATE(731),
    [sym_nullary_fun] = STATE(731),
    [sym_binary_app] = STATE(731),
    [sym_nary_app] = STATE(731),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(781),
    [sym_iff] = STATE(781),
    [sym_imp] = STATE(781),
    [sym_disjunction] = STATE(781),
    [sym_conjunction] = STATE(781),
    [sym_negation] = STATE(781),
    [sym_nested_formula] = STATE(781),
    [sym__temporal_variable_operation] = STATE(781),
    [sym_temp_var_induction] = STATE(781),
    [sym_temp_var_order] = STATE(781),
    [sym_temp_var_eq] = STATE(781),
    [sym_action_constraint] = STATE(781),
    [sym_term_eq] = STATE(781),
    [sym_subterm_rel] = STATE(781),
    [sym_quantified_formula] = STATE(781),
    [sym_atom] = STATE(781),
    [sym_predicate_ref] = STATE(781),
    [sym_pre_defined] = STATE(781),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [71] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(261),
    [sym_iff] = STATE(261),
    [sym_imp] = STATE(261),
    [sym_disjunction] = STATE(261),
    [sym_conjunction] = STATE(261),
    [sym_negation] = STATE(261),
    [sym_nested_formula] = STATE(261),
    [sym__temporal_variable_operation] = STATE(261),
    [sym_temp_var_induction] = STATE(261),
    [sym_temp_var_order] = STATE(261),
    [sym_temp_var_eq] = STATE(261),
    [sym_action_constraint] = STATE(261),
    [sym_term_eq] = STATE(261),
    [sym_subterm_rel] = STATE(261),
    [sym_quantified_formula] = STATE(261),
    [sym_atom] = STATE(261),
    [sym_predicate_ref] = STATE(261),
    [sym_pre_defined] = STATE(261),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [72] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(759),
    [sym_iff] = STATE(759),
    [sym_imp] = STATE(759),
    [sym_disjunction] = STATE(759),
    [sym_conjunction] = STATE(759),
    [sym_negation] = STATE(759),
    [sym_nested_formula] = STATE(759),
    [sym__temporal_variable_operation] = STATE(759),
    [sym_temp_var_induction] = STATE(759),
    [sym_temp_var_order] = STATE(759),
    [sym_temp_var_eq] = STATE(759),
    [sym_action_constraint] = STATE(759),
    [sym_term_eq] = STATE(759),
    [sym_subterm_rel] = STATE(759),
    [sym_quantified_formula] = STATE(759),
    [sym_atom] = STATE(759),
    [sym_predicate_ref] = STATE(759),
    [sym_pre_defined] = STATE(759),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [73] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(218),
    [sym_iff] = STATE(218),
    [sym_imp] = STATE(218),
    [sym_disjunction] = STATE(218),
    [sym_conjunction] = STATE(218),
    [sym_negation] = STATE(218),
    [sym_nested_formula] = STATE(218),
    [sym__temporal_variable_operation] = STATE(218),
    [sym_temp_var_induction] = STATE(218),
    [sym_temp_var_order] = STATE(218),
    [sym_temp_var_eq] = STATE(218),
    [sym_action_constraint] = STATE(218),
    [sym_term_eq] = STATE(218),
    [sym_subterm_rel] = STATE(218),
    [sym_quantified_formula] = STATE(218),
    [sym_atom] = STATE(218),
    [sym_predicate_ref] = STATE(218),
    [sym_pre_defined] = STATE(218),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [74] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(717),
    [sym_iff] = STATE(717),
    [sym_imp] = STATE(717),
    [sym_disjunction] = STATE(717),
    [sym_conjunction] = STATE(717),
    [sym_negation] = STATE(717),
    [sym_nested_formula] = STATE(717),
    [sym__temporal_variable_operation] = STATE(717),
    [sym_temp_var_induction] = STATE(717),
    [sym_temp_var_order] = STATE(717),
    [sym_temp_var_eq] = STATE(717),
    [sym_action_constraint] = STATE(717),
    [sym_term_eq] = STATE(717),
    [sym_subterm_rel] = STATE(717),
    [sym_quantified_formula] = STATE(717),
    [sym_atom] = STATE(717),
    [sym_predicate_ref] = STATE(717),
    [sym_pre_defined] = STATE(717),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [75] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(218),
    [sym_iff] = STATE(218),
    [sym_imp] = STATE(218),
    [sym_disjunction] = STATE(218),
    [sym_conjunction] = STATE(218),
    [sym_negation] = STATE(218),
    [sym_nested_formula] = STATE(218),
    [sym__temporal_variable_operation] = STATE(218),
    [sym_temp_var_induction] = STATE(218),
    [sym_temp_var_order] = STATE(218),
    [sym_temp_var_eq] = STATE(218),
    [sym_action_constraint] = STATE(218),
    [sym_term_eq] = STATE(218),
    [sym_subterm_rel] = STATE(218),
    [sym_quantified_formula] = STATE(218),
    [sym_atom] = STATE(218),
    [sym_predicate_ref] = STATE(218),
    [sym_pre_defined] = STATE(218),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [76] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(730),
    [sym_tuple_term] = STATE(730),
    [sym_mset_term] = STATE(730),
    [sym_nat_term] = STATE(730),
    [sym_xor_term] = STATE(730),
    [sym_mul_term] = STATE(730),
    [sym_exp_term] = STATE(730),
    [sym_nested_term] = STATE(730),
    [sym_nullary_fun] = STATE(730),
    [sym_binary_app] = STATE(730),
    [sym_nary_app] = STATE(730),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(781),
    [sym_iff] = STATE(781),
    [sym_imp] = STATE(781),
    [sym_disjunction] = STATE(781),
    [sym_conjunction] = STATE(781),
    [sym_negation] = STATE(781),
    [sym_nested_formula] = STATE(781),
    [sym__temporal_variable_operation] = STATE(781),
    [sym_temp_var_induction] = STATE(781),
    [sym_temp_var_order] = STATE(781),
    [sym_temp_var_eq] = STATE(781),
    [sym_action_constraint] = STATE(781),
    [sym_term_eq] = STATE(781),
    [sym_subterm_rel] = STATE(781),
    [sym_quantified_formula] = STATE(781),
    [sym_atom] = STATE(781),
    [sym_predicate_ref] = STATE(781),
    [sym_pre_defined] = STATE(781),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [77] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(215),
    [sym_iff] = STATE(215),
    [sym_imp] = STATE(215),
    [sym_disjunction] = STATE(215),
    [sym_conjunction] = STATE(215),
    [sym_negation] = STATE(215),
    [sym_nested_formula] = STATE(215),
    [sym__temporal_variable_operation] = STATE(215),
    [sym_temp_var_induction] = STATE(215),
    [sym_temp_var_order] = STATE(215),
    [sym_temp_var_eq] = STATE(215),
    [sym_action_constraint] = STATE(215),
    [sym_term_eq] = STATE(215),
    [sym_subterm_rel] = STATE(215),
    [sym_quantified_formula] = STATE(215),
    [sym_atom] = STATE(215),
    [sym_predicate_ref] = STATE(215),
    [sym_pre_defined] = STATE(215),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [78] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(711),
    [sym_iff] = STATE(711),
    [sym_imp] = STATE(711),
    [sym_disjunction] = STATE(711),
    [sym_conjunction] = STATE(711),
    [sym_negation] = STATE(711),
    [sym_nested_formula] = STATE(711),
    [sym__temporal_variable_operation] = STATE(711),
    [sym_temp_var_induction] = STATE(711),
    [sym_temp_var_order] = STATE(711),
    [sym_temp_var_eq] = STATE(711),
    [sym_action_constraint] = STATE(711),
    [sym_term_eq] = STATE(711),
    [sym_subterm_rel] = STATE(711),
    [sym_quantified_formula] = STATE(711),
    [sym_atom] = STATE(711),
    [sym_predicate_ref] = STATE(711),
    [sym_pre_defined] = STATE(711),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [79] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(765),
    [sym_iff] = STATE(765),
    [sym_imp] = STATE(765),
    [sym_disjunction] = STATE(765),
    [sym_conjunction] = STATE(765),
    [sym_negation] = STATE(765),
    [sym_nested_formula] = STATE(765),
    [sym__temporal_variable_operation] = STATE(765),
    [sym_temp_var_induction] = STATE(765),
    [sym_temp_var_order] = STATE(765),
    [sym_temp_var_eq] = STATE(765),
    [sym_action_constraint] = STATE(765),
    [sym_term_eq] = STATE(765),
    [sym_subterm_rel] = STATE(765),
    [sym_quantified_formula] = STATE(765),
    [sym_atom] = STATE(765),
    [sym_predicate_ref] = STATE(765),
    [sym_pre_defined] = STATE(765),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [80] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(708),
    [sym_iff] = STATE(708),
    [sym_imp] = STATE(708),
    [sym_disjunction] = STATE(708),
    [sym_conjunction] = STATE(708),
    [sym_negation] = STATE(708),
    [sym_nested_formula] = STATE(708),
    [sym__temporal_variable_operation] = STATE(708),
    [sym_temp_var_induction] = STATE(708),
    [sym_temp_var_order] = STATE(708),
    [sym_temp_var_eq] = STATE(708),
    [sym_action_constraint] = STATE(708),
    [sym_term_eq] = STATE(708),
    [sym_subterm_rel] = STATE(708),
    [sym_quantified_formula] = STATE(708),
    [sym_atom] = STATE(708),
    [sym_predicate_ref] = STATE(708),
    [sym_pre_defined] = STATE(708),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [81] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(216),
    [sym_iff] = STATE(216),
    [sym_imp] = STATE(216),
    [sym_disjunction] = STATE(216),
    [sym_conjunction] = STATE(216),
    [sym_negation] = STATE(216),
    [sym_nested_formula] = STATE(216),
    [sym__temporal_variable_operation] = STATE(216),
    [sym_temp_var_induction] = STATE(216),
    [sym_temp_var_order] = STATE(216),
    [sym_temp_var_eq] = STATE(216),
    [sym_action_constraint] = STATE(216),
    [sym_term_eq] = STATE(216),
    [sym_subterm_rel] = STATE(216),
    [sym_quantified_formula] = STATE(216),
    [sym_atom] = STATE(216),
    [sym_predicate_ref] = STATE(216),
    [sym_pre_defined] = STATE(216),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [82] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(762),
    [sym_iff] = STATE(762),
    [sym_imp] = STATE(762),
    [sym_disjunction] = STATE(762),
    [sym_conjunction] = STATE(762),
    [sym_negation] = STATE(762),
    [sym_nested_formula] = STATE(762),
    [sym__temporal_variable_operation] = STATE(762),
    [sym_temp_var_induction] = STATE(762),
    [sym_temp_var_order] = STATE(762),
    [sym_temp_var_eq] = STATE(762),
    [sym_action_constraint] = STATE(762),
    [sym_term_eq] = STATE(762),
    [sym_subterm_rel] = STATE(762),
    [sym_quantified_formula] = STATE(762),
    [sym_atom] = STATE(762),
    [sym_predicate_ref] = STATE(762),
    [sym_pre_defined] = STATE(762),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [83] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(777),
    [sym_iff] = STATE(777),
    [sym_imp] = STATE(777),
    [sym_disjunction] = STATE(777),
    [sym_conjunction] = STATE(777),
    [sym_negation] = STATE(777),
    [sym_nested_formula] = STATE(777),
    [sym__temporal_variable_operation] = STATE(777),
    [sym_temp_var_induction] = STATE(777),
    [sym_temp_var_order] = STATE(777),
    [sym_temp_var_eq] = STATE(777),
    [sym_action_constraint] = STATE(777),
    [sym_term_eq] = STATE(777),
    [sym_subterm_rel] = STATE(777),
    [sym_quantified_formula] = STATE(777),
    [sym_atom] = STATE(777),
    [sym_predicate_ref] = STATE(777),
    [sym_pre_defined] = STATE(777),
    [sym_ident] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [84] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(778),
    [sym_iff] = STATE(778),
    [sym_imp] = STATE(778),
    [sym_disjunction] = STATE(778),
    [sym_conjunction] = STATE(778),
    [sym_negation] = STATE(778),
    [sym_nested_formula] = STATE(778),
    [sym__temporal_variable_operation] = STATE(778),
    [sym_temp_var_induction] = STATE(778),
    [sym_temp_var_order] = STATE(778),
    [sym_temp_var_eq] = STATE(778),
    [sym_action_constraint] = STATE(778),
    [sym_term_eq] = STATE(778),
    [sym_subterm_rel] = STATE(778),
    [sym_quantified_formula] = STATE(778),
    [sym_atom] = STATE(778),
    [sym_predicate_ref] = STATE(778),
    [sym_pre_defined] = STATE(778),
    [sym_ident] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [85] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(215),
    [sym_iff] = STATE(215),
    [sym_imp] = STATE(215),
    [sym_disjunction] = STATE(215),
    [sym_conjunction] = STATE(215),
    [sym_negation] = STATE(215),
    [sym_nested_formula] = STATE(215),
    [sym__temporal_variable_operation] = STATE(215),
    [sym_temp_var_induction] = STATE(215),
    [sym_temp_var_order] = STATE(215),
    [sym_temp_var_eq] = STATE(215),
    [sym_action_constraint] = STATE(215),
    [sym_term_eq] = STATE(215),
    [sym_subterm_rel] = STATE(215),
    [sym_quantified_formula] = STATE(215),
    [sym_atom] = STATE(215),
    [sym_predicate_ref] = STATE(215),
    [sym_pre_defined] = STATE(215),
    [sym_ident] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [86] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(760),
    [sym_iff] = STATE(760),
    [sym_imp] = STATE(760),
    [sym_disjunction] = STATE(760),
    [sym_conjunction] = STATE(760),
    [sym_negation] = STATE(760),
    [sym_nested_formula] = STATE(760),
    [sym__temporal_variable_operation] = STATE(760),
    [sym_temp_var_induction] = STATE(760),
    [sym_temp_var_order] = STATE(760),
    [sym_temp_var_eq] = STATE(760),
    [sym_action_constraint] = STATE(760),
    [sym_term_eq] = STATE(760),
    [sym_subterm_rel] = STATE(760),
    [sym_quantified_formula] = STATE(760),
    [sym_atom] = STATE(760),
    [sym_predicate_ref] = STATE(760),
    [sym_pre_defined] = STATE(760),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [87] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(779),
    [sym_iff] = STATE(779),
    [sym_imp] = STATE(779),
    [sym_disjunction] = STATE(779),
    [sym_conjunction] = STATE(779),
    [sym_negation] = STATE(779),
    [sym_nested_formula] = STATE(779),
    [sym__temporal_variable_operation] = STATE(779),
    [sym_temp_var_induction] = STATE(779),
    [sym_temp_var_order] = STATE(779),
    [sym_temp_var_eq] = STATE(779),
    [sym_action_constraint] = STATE(779),
    [sym_term_eq] = STATE(779),
    [sym_subterm_rel] = STATE(779),
    [sym_quantified_formula] = STATE(779),
    [sym_atom] = STATE(779),
    [sym_predicate_ref] = STATE(779),
    [sym_pre_defined] = STATE(779),
    [sym_ident] = ACTIONS(271),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(151),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(165),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(167),
    [anon_sym_u2203] = ACTIONS(169),
    [anon_sym_All] = ACTIONS(167),
    [anon_sym_u2200] = ACTIONS(169),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [88] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(723),
    [sym_tuple_term] = STATE(723),
    [sym_mset_term] = STATE(723),
    [sym_nat_term] = STATE(723),
    [sym_xor_term] = STATE(723),
    [sym_mul_term] = STATE(723),
    [sym_exp_term] = STATE(723),
    [sym_nested_term] = STATE(723),
    [sym_nullary_fun] = STATE(723),
    [sym_binary_app] = STATE(723),
    [sym_nary_app] = STATE(723),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(780),
    [sym_iff] = STATE(780),
    [sym_imp] = STATE(780),
    [sym_disjunction] = STATE(780),
    [sym_conjunction] = STATE(780),
    [sym_negation] = STATE(780),
    [sym_nested_formula] = STATE(780),
    [sym__temporal_variable_operation] = STATE(780),
    [sym_temp_var_induction] = STATE(780),
    [sym_temp_var_order] = STATE(780),
    [sym_temp_var_eq] = STATE(780),
    [sym_action_constraint] = STATE(780),
    [sym_term_eq] = STATE(780),
    [sym_subterm_rel] = STATE(780),
    [sym_quantified_formula] = STATE(780),
    [sym_atom] = STATE(780),
    [sym_predicate_ref] = STATE(780),
    [sym_pre_defined] = STATE(780),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [89] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(757),
    [sym_iff] = STATE(757),
    [sym_imp] = STATE(757),
    [sym_disjunction] = STATE(757),
    [sym_conjunction] = STATE(757),
    [sym_negation] = STATE(757),
    [sym_nested_formula] = STATE(757),
    [sym__temporal_variable_operation] = STATE(757),
    [sym_temp_var_induction] = STATE(757),
    [sym_temp_var_order] = STATE(757),
    [sym_temp_var_eq] = STATE(757),
    [sym_action_constraint] = STATE(757),
    [sym_term_eq] = STATE(757),
    [sym_subterm_rel] = STATE(757),
    [sym_quantified_formula] = STATE(757),
    [sym_atom] = STATE(757),
    [sym_predicate_ref] = STATE(757),
    [sym_pre_defined] = STATE(757),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [90] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(770),
    [sym_iff] = STATE(770),
    [sym_imp] = STATE(770),
    [sym_disjunction] = STATE(770),
    [sym_conjunction] = STATE(770),
    [sym_negation] = STATE(770),
    [sym_nested_formula] = STATE(770),
    [sym__temporal_variable_operation] = STATE(770),
    [sym_temp_var_induction] = STATE(770),
    [sym_temp_var_order] = STATE(770),
    [sym_temp_var_eq] = STATE(770),
    [sym_action_constraint] = STATE(770),
    [sym_term_eq] = STATE(770),
    [sym_subterm_rel] = STATE(770),
    [sym_quantified_formula] = STATE(770),
    [sym_atom] = STATE(770),
    [sym_predicate_ref] = STATE(770),
    [sym_pre_defined] = STATE(770),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [91] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(768),
    [sym_iff] = STATE(768),
    [sym_imp] = STATE(768),
    [sym_disjunction] = STATE(768),
    [sym_conjunction] = STATE(768),
    [sym_negation] = STATE(768),
    [sym_nested_formula] = STATE(768),
    [sym__temporal_variable_operation] = STATE(768),
    [sym_temp_var_induction] = STATE(768),
    [sym_temp_var_order] = STATE(768),
    [sym_temp_var_eq] = STATE(768),
    [sym_action_constraint] = STATE(768),
    [sym_term_eq] = STATE(768),
    [sym_subterm_rel] = STATE(768),
    [sym_quantified_formula] = STATE(768),
    [sym_atom] = STATE(768),
    [sym_predicate_ref] = STATE(768),
    [sym_pre_defined] = STATE(768),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [92] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(774),
    [sym_iff] = STATE(774),
    [sym_imp] = STATE(774),
    [sym_disjunction] = STATE(774),
    [sym_conjunction] = STATE(774),
    [sym_negation] = STATE(774),
    [sym_nested_formula] = STATE(774),
    [sym__temporal_variable_operation] = STATE(774),
    [sym_temp_var_induction] = STATE(774),
    [sym_temp_var_order] = STATE(774),
    [sym_temp_var_eq] = STATE(774),
    [sym_action_constraint] = STATE(774),
    [sym_term_eq] = STATE(774),
    [sym_subterm_rel] = STATE(774),
    [sym_quantified_formula] = STATE(774),
    [sym_atom] = STATE(774),
    [sym_predicate_ref] = STATE(774),
    [sym_pre_defined] = STATE(774),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [93] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(728),
    [sym_iff] = STATE(728),
    [sym_imp] = STATE(728),
    [sym_disjunction] = STATE(728),
    [sym_conjunction] = STATE(728),
    [sym_negation] = STATE(728),
    [sym_nested_formula] = STATE(728),
    [sym__temporal_variable_operation] = STATE(728),
    [sym_temp_var_induction] = STATE(728),
    [sym_temp_var_order] = STATE(728),
    [sym_temp_var_eq] = STATE(728),
    [sym_action_constraint] = STATE(728),
    [sym_term_eq] = STATE(728),
    [sym_subterm_rel] = STATE(728),
    [sym_quantified_formula] = STATE(728),
    [sym_atom] = STATE(728),
    [sym_predicate_ref] = STATE(728),
    [sym_pre_defined] = STATE(728),
    [sym_ident] = ACTIONS(269),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(259),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(263),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(265),
    [anon_sym_u2203] = ACTIONS(267),
    [anon_sym_All] = ACTIONS(265),
    [anon_sym_u2200] = ACTIONS(267),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
  [94] = {
    [sym__fact] = STATE(1242),
    [sym_fact] = STATE(1242),
    [sym__term] = STATE(736),
    [sym_tuple_term] = STATE(736),
    [sym_mset_term] = STATE(736),
    [sym_nat_term] = STATE(736),
    [sym_xor_term] = STATE(736),
    [sym_mul_term] = STATE(736),
    [sym_exp_term] = STATE(736),
    [sym_nested_term] = STATE(736),
    [sym_nullary_fun] = STATE(736),
    [sym_binary_app] = STATE(736),
    [sym_nary_app] = STATE(736),
    [sym__literal] = STATE(144),
    [sym__non_temporal_var] = STATE(144),
    [sym_pub_var] = STATE(144),
    [sym_fresh_var] = STATE(144),
    [sym_msg_var_or_nullary_fun] = STATE(144),
    [sym_nat_var] = STATE(144),
    [sym_comp_var] = STATE(144),
    [sym__custom_type_var] = STATE(144),
    [sym_custom_var] = STATE(144),
    [sym_any_var] = STATE(144),
    [sym_temporal_var_optional_prefix] = STATE(999),
    [sym_pub_name] = STATE(144),
    [sym_fresh_name] = STATE(144),
    [sym__formula] = STATE(758),
    [sym_iff] = STATE(758),
    [sym_imp] = STATE(758),
    [sym_disjunction] = STATE(758),
    [sym_conjunction] = STATE(758),
    [sym_negation] = STATE(758),
    [sym_nested_formula] = STATE(758),
    [sym__temporal_variable_operation] = STATE(758),
    [sym_temp_var_induction] = STATE(758),
    [sym_temp_var_order] = STATE(758),
    [sym_temp_var_eq] = STATE(758),
    [sym_action_constraint] = STATE(758),
    [sym_term_eq] = STATE(758),
    [sym_subterm_rel] = STATE(758),
    [sym_quantified_formula] = STATE(758),
    [sym_atom] = STATE(758),
    [sym_predicate_ref] = STATE(758),
    [sym_pre_defined] = STATE(758),
    [sym_ident] = ACTIONS(7),
    [anon_sym_EQ] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(257),
    [anon_sym_not] = ACTIONS(13),
    [anon_sym_BANG] = ACTIONS(15),
    [anon_sym_LT] = ACTIONS(19),
    [anon_sym_DOLLAR] = ACTIONS(21),
    [anon_sym_TILDE] = ACTIONS(23),
    [anon_sym_POUND] = ACTIONS(25),
    [anon_sym_PERCENT] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [anon_sym_TILDE_SQUOTE] = ACTIONS(31),
    [anon_sym_u00ac] = ACTIONS(33),
    [anon_sym_last] = ACTIONS(35),
    [anon_sym_Ex] = ACTIONS(37),
    [anon_sym_u2203] = ACTIONS(39),
    [anon_sym_All] = ACTIONS(37),
    [anon_sym_u2200] = ACTIONS(39),
    [anon_sym_u22a5] = ACTIONS(41),
    [anon_sym_F] = ACTIONS(43),
    [anon_sym_u22a4] = ACTIONS(41),
    [anon_sym_T] = ACTIONS(43),
    [sym_multi_comment] = ACTIONS(3),
    [sym_single_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 15,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(45), 1,
      sym_ident,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    STATE(537), 1,
      sym_equation,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(275), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(806), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
    ACTIONS(273), 21,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
  [92] = 30,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(283), 1,
      anon_sym_POUNDelse,
    ACTIONS(285), 1,
      anon_sym_POUNDendif,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(291), 1,
      anon_sym_PIPE,
    ACTIONS(293), 1,
      anon_sym_AMP,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(101), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [214] = 15,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(45), 1,
      sym_ident,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    STATE(537), 1,
      sym_equation,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(333), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(806), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
    ACTIONS(331), 21,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
  [306] = 15,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(45), 1,
      sym_ident,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    STATE(537), 1,
      sym_equation,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(337), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(806), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
    ACTIONS(335), 21,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
  [398] = 15,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(45), 1,
      sym_ident,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    STATE(537), 1,
      sym_equation,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(341), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(806), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
    ACTIONS(339), 21,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
  [490] = 28,
    ACTIONS(343), 1,
      sym_ident,
    ACTIONS(346), 1,
      anon_sym_end,
    ACTIONS(348), 1,
      anon_sym_POUNDifdef,
    ACTIONS(353), 1,
      anon_sym_POUNDdefine,
    ACTIONS(356), 1,
      anon_sym_POUNDinclude,
    ACTIONS(359), 1,
      anon_sym_builtins,
    ACTIONS(362), 1,
      anon_sym_functions,
    ACTIONS(365), 1,
      anon_sym_equations,
    ACTIONS(371), 1,
      anon_sym_options,
    ACTIONS(374), 1,
      anon_sym_heuristic,
    ACTIONS(377), 1,
      anon_sym_tactic,
    ACTIONS(380), 1,
      anon_sym_process,
    ACTIONS(383), 1,
      anon_sym_let,
    ACTIONS(386), 1,
      anon_sym_export,
    ACTIONS(389), 1,
      anon_sym_rule,
    ACTIONS(392), 1,
      anon_sym_macros,
    ACTIONS(398), 1,
      anon_sym_test,
    ACTIONS(401), 1,
      anon_sym_lemma,
    ACTIONS(404), 1,
      anon_sym_diffLemma,
    ACTIONS(407), 1,
      anon_sym_equivLemma,
    ACTIONS(410), 1,
      anon_sym_diffEquivLemma,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(351), 2,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
    ACTIONS(368), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(395), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(100), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [607] = 28,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(413), 1,
      anon_sym_POUNDelse,
    ACTIONS(415), 1,
      anon_sym_POUNDendif,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(100), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [723] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(417), 1,
      anon_sym_POUNDendif,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(108), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [836] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(419), 1,
      anon_sym_end,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(109), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [949] = 9,
    ACTIONS(429), 1,
      anon_sym_LPAREN,
    ACTIONS(431), 1,
      anon_sym_LBRACE,
    ACTIONS(433), 1,
      anon_sym_LT,
    ACTIONS(435), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(427), 4,
      anon_sym_EQ,
      anon_sym_then,
      anon_sym_PLUS,
      anon_sym_XOR,
    ACTIONS(423), 9,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_LT_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(425), 16,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(421), 23,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [1026] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(437), 1,
      anon_sym_end,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(106), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [1139] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(439), 1,
      anon_sym_end,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(100), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [1252] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(415), 1,
      anon_sym_POUNDendif,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(110), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [1365] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(441), 1,
      anon_sym_POUNDendif,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(100), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [1478] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(443), 1,
      anon_sym_end,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(100), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [1591] = 27,
    ACTIONS(279), 1,
      sym_ident,
    ACTIONS(281), 1,
      anon_sym_POUNDifdef,
    ACTIONS(287), 1,
      anon_sym_POUNDdefine,
    ACTIONS(289), 1,
      anon_sym_POUNDinclude,
    ACTIONS(295), 1,
      anon_sym_builtins,
    ACTIONS(297), 1,
      anon_sym_functions,
    ACTIONS(299), 1,
      anon_sym_equations,
    ACTIONS(303), 1,
      anon_sym_options,
    ACTIONS(305), 1,
      anon_sym_heuristic,
    ACTIONS(307), 1,
      anon_sym_tactic,
    ACTIONS(309), 1,
      anon_sym_process,
    ACTIONS(311), 1,
      anon_sym_let,
    ACTIONS(313), 1,
      anon_sym_export,
    ACTIONS(315), 1,
      anon_sym_rule,
    ACTIONS(317), 1,
      anon_sym_macros,
    ACTIONS(321), 1,
      anon_sym_test,
    ACTIONS(323), 1,
      anon_sym_lemma,
    ACTIONS(325), 1,
      anon_sym_diffLemma,
    ACTIONS(327), 1,
      anon_sym_equivLemma,
    ACTIONS(329), 1,
      anon_sym_diffEquivLemma,
    ACTIONS(417), 1,
      anon_sym_POUNDendif,
    STATE(480), 1,
      sym_simple_rule,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(301), 2,
      anon_sym_predicate,
      anon_sym_predicates,
    ACTIONS(319), 2,
      anon_sym_restriction,
      anon_sym_axiom,
    STATE(573), 3,
      sym_ifdef,
      sym_define,
      sym_include,
    STATE(100), 27,
      sym__body_item,
      sym_preprocessor,
      sym__signature_spec,
      sym_built_ins,
      sym_functions,
      sym_equations,
      sym_predicates,
      sym_options,
      sym_global_heuristic,
      sym_tactic,
      sym_process,
      sym_let,
      sym_export,
      sym__rule,
      sym_rule,
      sym_diff_rule,
      sym_macros,
      sym_restriction,
      sym_case_test,
      sym__lemma,
      sym_lemma,
      sym_diff_lemma,
      sym_accountability_lemma,
      sym_equiv_lemma,
      sym_diff_equiv_lemma,
      sym_formal_comment,
      aux_sym_theory_repeat1,
  [1704] = 8,
    ACTIONS(451), 1,
      anon_sym_LBRACK,
    STATE(251), 1,
      sym_fact_annotes,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(453), 2,
      anon_sym_AT,
      anon_sym_u25b6,
    ACTIONS(449), 3,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_XOR,
    ACTIONS(455), 7,
      anon_sym_LT_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(447), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(445), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [1778] = 10,
    ACTIONS(451), 1,
      anon_sym_LBRACK,
    ACTIONS(463), 1,
      anon_sym_RPAREN,
    ACTIONS(468), 1,
      anon_sym_then,
    STATE(248), 1,
      sym_fact_annotes,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(466), 2,
      anon_sym_AT,
      anon_sym_u25b6,
    ACTIONS(461), 3,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_XOR,
    ACTIONS(471), 7,
      anon_sym_LT_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(459), 16,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(457), 23,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [1856] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(471), 22,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(461), 31,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [1918] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(455), 22,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(449), 31,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [1980] = 7,
    ACTIONS(473), 1,
      anon_sym_COLON,
    ACTIONS(476), 1,
      anon_sym_LPAREN,
    ACTIONS(478), 1,
      anon_sym_LBRACE,
    ACTIONS(480), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(423), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(427), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [2050] = 4,
    ACTIONS(486), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(484), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(482), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [2112] = 5,
    ACTIONS(473), 1,
      anon_sym_COLON,
    ACTIONS(480), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(423), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(427), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [2176] = 5,
    ACTIONS(490), 1,
      anon_sym_COLON,
    ACTIONS(495), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(493), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(488), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [2240] = 4,
    ACTIONS(501), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(499), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(497), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [2302] = 7,
    ACTIONS(503), 1,
      anon_sym_COLON,
    ACTIONS(506), 1,
      anon_sym_LPAREN,
    ACTIONS(508), 1,
      anon_sym_LBRACE,
    ACTIONS(510), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(423), 17,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
    ACTIONS(427), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2370] = 5,
    ACTIONS(503), 1,
      anon_sym_COLON,
    ACTIONS(510), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(423), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(427), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2434] = 4,
    ACTIONS(512), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(484), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(482), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2496] = 4,
    ACTIONS(514), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(499), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(497), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2558] = 5,
    ACTIONS(516), 1,
      anon_sym_COLON,
    ACTIONS(519), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(493), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(488), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2622] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(523), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(521), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2681] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(527), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(525), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2740] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(531), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(529), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2799] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(535), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(533), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2858] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(539), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(537), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2917] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(543), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(541), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [2976] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(547), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(545), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3035] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(551), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(549), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3094] = 4,
    ACTIONS(555), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(557), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(553), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [3155] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(547), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(545), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [3214] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(561), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(559), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3273] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(565), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(563), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3332] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(569), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(567), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3391] = 4,
    ACTIONS(571), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(569), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(567), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [3452] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(576), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(574), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3511] = 4,
    ACTIONS(580), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(583), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(578), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3572] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(583), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(578), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3631] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(587), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(585), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3690] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(527), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(525), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [3749] = 4,
    ACTIONS(589), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(557), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(553), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3810] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(551), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(549), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [3869] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(561), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(559), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [3928] = 4,
    ACTIONS(591), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(569), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(567), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [3989] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(565), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(563), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4048] = 4,
    ACTIONS(594), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(583), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(578), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4109] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(569), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(567), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4168] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(599), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(597), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [4227] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(576), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(574), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4286] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(603), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(601), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [4345] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(607), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(605), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4404] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(607), 20,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(605), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [4463] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(603), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(601), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4522] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(599), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(597), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4581] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(543), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(541), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4640] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(539), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(537), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4699] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(535), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(533), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4758] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(587), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(585), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4817] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(531), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(529), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4876] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(523), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(521), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4935] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(583), 23,
      anon_sym_COLON,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(578), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [4994] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(455), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(449), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [5052] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(611), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(609), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [5110] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(617), 2,
      sym_solved,
      sym_mirrored,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(569), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(615), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(613), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5190] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(635), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(578), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(633), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(631), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5270] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(641), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(576), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(639), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(637), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5350] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(647), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(568), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(645), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(643), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5430] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(653), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(567), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(651), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(649), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5510] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(659), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(577), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(657), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(655), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5590] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(663), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(661), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [5648] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(667), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(665), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [5706] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(671), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(669), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [5764] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(677), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(586), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(675), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(673), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5844] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(683), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(563), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(681), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(679), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5924] = 10,
    ACTIONS(689), 1,
      anon_sym_PLUS,
    ACTIONS(691), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(693), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(695), 1,
      anon_sym_XOR,
    ACTIONS(697), 1,
      anon_sym_u2295,
    ACTIONS(699), 1,
      anon_sym_STAR,
    ACTIONS(701), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(687), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(685), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [5996] = 10,
    ACTIONS(689), 1,
      anon_sym_PLUS,
    ACTIONS(691), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(693), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(695), 1,
      anon_sym_XOR,
    ACTIONS(697), 1,
      anon_sym_u2295,
    ACTIONS(699), 1,
      anon_sym_STAR,
    ACTIONS(701), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(705), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(703), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [6068] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(711), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(574), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(709), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(707), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [6148] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(715), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(713), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6206] = 14,
    ACTIONS(619), 1,
      anon_sym_by,
    ACTIONS(621), 1,
      anon_sym_case,
    ACTIONS(625), 1,
      anon_sym_solve,
    ACTIONS(629), 1,
      anon_sym_step,
    STATE(933), 1,
      sym_case,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(627), 2,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(721), 2,
      sym_solved,
      sym_mirrored,
    STATE(201), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    STATE(596), 2,
      sym__proof_methods,
      sym_proof_method,
    STATE(580), 4,
      sym__proof_skeleton,
      sym_by_method,
      sym_method_skeleton,
      sym_cases,
    ACTIONS(623), 5,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
    ACTIONS(719), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(717), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [6286] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(667), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(665), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [6344] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(663), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(661), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [6402] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(471), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(461), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6460] = 4,
    ACTIONS(701), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(725), 21,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(723), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6520] = 4,
    ACTIONS(701), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(729), 21,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(727), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6580] = 8,
    ACTIONS(689), 1,
      anon_sym_PLUS,
    ACTIONS(691), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(693), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(699), 1,
      anon_sym_STAR,
    ACTIONS(701), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(733), 18,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u2295,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(731), 26,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6648] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(671), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(669), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6706] = 5,
    ACTIONS(699), 1,
      anon_sym_STAR,
    ACTIONS(701), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(737), 20,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(735), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6768] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(611), 22,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(609), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6826] = 6,
    ACTIONS(693), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(699), 1,
      anon_sym_STAR,
    ACTIONS(701), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(741), 19,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_PLUS_PLUS,
      anon_sym_u2295,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(739), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      sym_ident,
  [6890] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(715), 19,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_LT,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_u228f,
    ACTIONS(713), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [6948] = 4,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(729), 16,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
    ACTIONS(727), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [7006] = 4,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(725), 16,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
    ACTIONS(723), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [7064] = 6,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(741), 14,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_u2295,
    ACTIONS(739), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [7126] = 5,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(737), 15,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
    ACTIONS(735), 30,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [7186] = 8,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(733), 13,
      anon_sym_EQ,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_GT,
      anon_sym_u2295,
    ACTIONS(731), 29,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_in,
      anon_sym_then,
      anon_sym_else,
      anon_sym_let,
      anon_sym_as,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      anon_sym_XOR,
      anon_sym_PERCENT,
      sym_ident,
  [7252] = 6,
    STATE(560), 1,
      sym_built_in,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(759), 4,
      anon_sym_hashing,
      anon_sym_signing,
      anon_sym_xor,
      anon_sym_multiset,
    ACTIONS(755), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(757), 12,
      anon_sym_diffie_DASHhellman,
      anon_sym_symmetric_DASHencryption,
      anon_sym_asymmetric_DASHencryption,
      anon_sym_bilinear_DASHpairing,
      anon_sym_natural_DASHnumbers,
      anon_sym_revealing_DASHsigning,
      anon_sym_locations_DASHreport,
      anon_sym_reliable_DASHchannel,
      anon_sym_dest_DASHpairing,
      anon_sym_dest_DASHsigning,
      anon_sym_dest_DASHsymmetric_DASHencryption,
      anon_sym_dest_DASHasymmetric_DASHencryption,
    ACTIONS(753), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7311] = 8,
    ACTIONS(765), 1,
      anon_sym_not,
    STATE(200), 1,
      aux_sym_prio_repeat1,
    STATE(228), 1,
      sym_function_name,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(763), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(238), 5,
      sym__function,
      sym_or_function,
      sym_and_function,
      sym_not_function,
      sym_std_function,
    ACTIONS(768), 7,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
    ACTIONS(761), 24,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7374] = 5,
    ACTIONS(629), 1,
      anon_sym_step,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(202), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    ACTIONS(773), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(771), 34,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_solved,
      sym_mirrored,
      anon_sym_by,
      anon_sym_next,
      anon_sym_qed,
      anon_sym_case,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_solve,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
      sym_ident,
  [7431] = 5,
    ACTIONS(779), 1,
      anon_sym_step,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(202), 2,
      sym_step,
      aux_sym__proof_methods_repeat1,
    ACTIONS(777), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(775), 34,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_solved,
      sym_mirrored,
      anon_sym_by,
      anon_sym_next,
      anon_sym_qed,
      anon_sym_case,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_solve,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
      sym_ident,
  [7488] = 8,
    ACTIONS(786), 1,
      anon_sym_not,
    STATE(200), 1,
      aux_sym_prio_repeat1,
    STATE(228), 1,
      sym_function_name,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(784), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(238), 5,
      sym__function,
      sym_or_function,
      sym_and_function,
      sym_not_function,
      sym_std_function,
    ACTIONS(788), 7,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
    ACTIONS(782), 24,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7551] = 8,
    ACTIONS(786), 1,
      anon_sym_not,
    STATE(200), 1,
      aux_sym_prio_repeat1,
    STATE(228), 1,
      sym_function_name,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(792), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(238), 5,
      sym__function,
      sym_or_function,
      sym_and_function,
      sym_not_function,
      sym_std_function,
    ACTIONS(788), 7,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
    ACTIONS(790), 24,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7614] = 5,
    ACTIONS(794), 1,
      anon_sym_COLON,
    ACTIONS(798), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(796), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(433), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7671] = 6,
    STATE(560), 1,
      sym_built_in,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(759), 4,
      anon_sym_hashing,
      anon_sym_signing,
      anon_sym_xor,
      anon_sym_multiset,
    ACTIONS(802), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(757), 12,
      anon_sym_diffie_DASHhellman,
      anon_sym_symmetric_DASHencryption,
      anon_sym_asymmetric_DASHencryption,
      anon_sym_bilinear_DASHpairing,
      anon_sym_natural_DASHnumbers,
      anon_sym_revealing_DASHsigning,
      anon_sym_locations_DASHreport,
      anon_sym_reliable_DASHchannel,
      anon_sym_dest_DASHpairing,
      anon_sym_dest_DASHsigning,
      anon_sym_dest_DASHsymmetric_DASHencryption,
      anon_sym_dest_DASHasymmetric_DASHencryption,
    ACTIONS(800), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7730] = 4,
    ACTIONS(806), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(808), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(804), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7784] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(812), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(810), 35,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_solved,
      sym_mirrored,
      anon_sym_by,
      anon_sym_next,
      anon_sym_qed,
      anon_sym_case,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_solve,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
      anon_sym_step,
      sym_ident,
  [7836] = 8,
    ACTIONS(786), 1,
      anon_sym_not,
    STATE(200), 1,
      aux_sym_prio_repeat1,
    STATE(228), 1,
      sym_function_name,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(816), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(238), 5,
      sym__function,
      sym_or_function,
      sym_and_function,
      sym_not_function,
      sym_std_function,
    ACTIONS(788), 7,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
    ACTIONS(814), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_deprio,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7898] = 4,
    ACTIONS(822), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(820), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(818), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [7952] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(826), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(824), 35,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_solved,
      sym_mirrored,
      anon_sym_by,
      anon_sym_next,
      anon_sym_qed,
      anon_sym_case,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_solve,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
      anon_sym_step,
      sym_ident,
  [8004] = 8,
    ACTIONS(786), 1,
      anon_sym_not,
    STATE(200), 1,
      aux_sym_prio_repeat1,
    STATE(228), 1,
      sym_function_name,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(830), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    STATE(238), 5,
      sym__function,
      sym_or_function,
      sym_and_function,
      sym_not_function,
      sym_std_function,
    ACTIONS(788), 7,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
    ACTIONS(828), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_deprio,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8066] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(834), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(832), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8117] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(838), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(836), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8168] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(842), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(840), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8219] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(846), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(844), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8270] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(808), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(804), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8321] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(850), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(848), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8372] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(854), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(852), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8423] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(858), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(856), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8474] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(862), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(860), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8525] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(866), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_rule_DASHequivalence,
      anon_sym_backward_DASHsearch,
    ACTIONS(864), 35,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_solved,
      sym_mirrored,
      anon_sym_by,
      anon_sym_next,
      anon_sym_qed,
      anon_sym_case,
      anon_sym_sorry,
      anon_sym_simplify,
      anon_sym_solve,
      anon_sym_contradiction,
      anon_sym_induction,
      anon_sym_ATTACK,
      anon_sym_step,
      sym_ident,
  [8576] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(870), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(868), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8627] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(874), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(872), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8678] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(878), 17,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_AMP,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
      anon_sym_u2227,
    ACTIONS(876), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_then,
      anon_sym_let,
      anon_sym_EQ2,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8729] = 5,
    ACTIONS(882), 1,
      anon_sym_DQUOTE,
    STATE(226), 1,
      aux_sym_std_function_repeat1,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(885), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(880), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8783] = 5,
    ACTIONS(889), 1,
      anon_sym_DQUOTE,
    STATE(226), 1,
      aux_sym_std_function_repeat1,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(891), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(887), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8837] = 5,
    ACTIONS(889), 1,
      anon_sym_DQUOTE,
    STATE(227), 1,
      aux_sym_std_function_repeat1,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(895), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(893), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8891] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(899), 8,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(897), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8940] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(903), 8,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(901), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [8989] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(907), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(905), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9037] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(911), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(909), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9085] = 11,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(917), 1,
      anon_sym_SEMI,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(915), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
    ACTIONS(913), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9149] = 5,
    ACTIONS(451), 1,
      anon_sym_LBRACK,
    STATE(251), 1,
      sym_fact_annotes,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(453), 13,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_u25b6,
    ACTIONS(923), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9201] = 11,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(929), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(927), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
    ACTIONS(925), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9265] = 11,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(935), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(933), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
    ACTIONS(931), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9329] = 9,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(939), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
    ACTIONS(937), 25,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9389] = 5,
    ACTIONS(945), 1,
      anon_sym_PIPE,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(943), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(941), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9441] = 4,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(951), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_PIPE,
    ACTIONS(949), 32,
      anon_sym_end,
      anon_sym_not,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_prio,
      anon_sym_deprio,
      anon_sym_regex,
      anon_sym_isFactName,
      anon_sym_isInFactTerms,
      anon_sym_dhreNoise,
      anon_sym_defaultNoise,
      anon_sym_reasonableNoncesNoise,
      anon_sym_nonAbsurdGoal,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9491] = 11,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(957), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(955), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
    ACTIONS(953), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9555] = 6,
    ACTIONS(963), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_u2228,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(965), 2,
      anon_sym_AMP,
      anon_sym_u2227,
    ACTIONS(961), 13,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(959), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9609] = 7,
    ACTIONS(963), 1,
      anon_sym_PIPE,
    ACTIONS(967), 1,
      anon_sym_u2228,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(965), 2,
      anon_sym_AMP,
      anon_sym_u2227,
    ACTIONS(973), 2,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(971), 11,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
    ACTIONS(969), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9665] = 5,
    ACTIONS(451), 1,
      anon_sym_LBRACK,
    STATE(248), 1,
      sym_fact_annotes,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(466), 13,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_u25b6,
    ACTIONS(975), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9717] = 4,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(965), 2,
      anon_sym_AMP,
      anon_sym_u2227,
    ACTIONS(979), 14,
      anon_sym_DQUOTE,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
      anon_sym_LT_EQ_GT,
      anon_sym_PIPE_PIPE,
      anon_sym_u2225,
      anon_sym_u21d4,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_u2228,
    ACTIONS(977), 23,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9767] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(983), 13,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_u25b6,
    ACTIONS(981), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9813] = 7,
    ACTIONS(985), 1,
      anon_sym_COLON,
    ACTIONS(988), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_LBRACE,
    ACTIONS(993), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(423), 14,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(427), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [9867] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(997), 10,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(995), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9913] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1001), 13,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_u25b6,
    ACTIONS(999), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [9959] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1005), 13,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_u25b6,
    ACTIONS(1003), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [10005] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1009), 13,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_u25b6,
    ACTIONS(1007), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [10051] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(466), 13,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_u25b6,
    ACTIONS(975), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [10097] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1013), 10,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1011), 27,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [10143] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1017), 1,
      anon_sym_RPAREN,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1134), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10214] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1021), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1193), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10285] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1023), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1154), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10356] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1025), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1053), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10427] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1027), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1111), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10498] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1029), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1288), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10569] = 5,
    ACTIONS(1031), 1,
      anon_sym_COLON,
    ACTIONS(1034), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(493), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(488), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [10618] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1036), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1082), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10689] = 7,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(965), 2,
      anon_sym_AMP,
      anon_sym_u2227,
    ACTIONS(967), 2,
      anon_sym_PIPE,
      anon_sym_u2228,
    ACTIONS(973), 2,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(1042), 2,
      anon_sym_LT_EQ_GT,
      anon_sym_u21d4,
    ACTIONS(1040), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1038), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [10742] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1044), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1250), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10813] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1023), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1231), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10884] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1046), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1088), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [10955] = 4,
    ACTIONS(1048), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(499), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(497), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11002] = 4,
    ACTIONS(1050), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(484), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(482), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11049] = 5,
    ACTIONS(985), 1,
      anon_sym_COLON,
    ACTIONS(993), 1,
      anon_sym_DOT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(423), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(427), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11098] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1052), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1203), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [11169] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1054), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1316), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [11240] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1056), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1227), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [11311] = 16,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      sym_ident,
    ACTIONS(1019), 1,
      anon_sym_POUND,
    ACTIONS(1029), 1,
      anon_sym_RPAREN,
    STATE(894), 1,
      sym_temporal_var,
    STATE(1205), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(756), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [11382] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(543), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(541), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11426] = 10,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1060), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1058), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [11484] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(539), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(537), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11528] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(535), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(533), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11572] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(531), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(529), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11616] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(583), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(578), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11660] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(523), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(521), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11704] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(587), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(585), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11748] = 14,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(45), 1,
      sym_ident,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1062), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(290), 2,
      sym_term_eq,
      aux_sym_process_let_repeat1,
    STATE(792), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [11814] = 7,
    ACTIONS(1068), 1,
      sym_standard_goal_ranking,
    ACTIONS(1074), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1071), 2,
      anon_sym_O,
      anon_sym_o,
    STATE(281), 4,
      sym__goal_ranking,
      sym_oracle_goal_ranking,
      sym_tactic_goal_ranking,
      aux_sym_global_heuristic_repeat1,
    ACTIONS(1066), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1064), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [11866] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(547), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(545), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11910] = 4,
    ACTIONS(1077), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(557), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(553), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [11956] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(603), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(601), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12000] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(569), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(567), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12044] = 7,
    ACTIONS(1083), 1,
      sym_standard_goal_ranking,
    ACTIONS(1087), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1085), 2,
      anon_sym_O,
      anon_sym_o,
    STATE(281), 4,
      sym__goal_ranking,
      sym_oracle_goal_ranking,
      sym_tactic_goal_ranking,
      aux_sym_global_heuristic_repeat1,
    ACTIONS(1081), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1079), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [12096] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(565), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(563), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12140] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(576), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(574), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12184] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(599), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(597), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12228] = 14,
    ACTIONS(1089), 1,
      sym_ident,
    ACTIONS(1092), 1,
      anon_sym_EQ,
    ACTIONS(1095), 1,
      anon_sym_LPAREN,
    ACTIONS(1098), 1,
      anon_sym_in,
    ACTIONS(1100), 1,
      anon_sym_LT,
    ACTIONS(1103), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      anon_sym_TILDE,
    ACTIONS(1109), 1,
      anon_sym_PERCENT,
    ACTIONS(1112), 1,
      anon_sym_SQUOTE,
    ACTIONS(1115), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(290), 2,
      sym_term_eq,
      aux_sym_process_let_repeat1,
    STATE(792), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [12294] = 4,
    ACTIONS(1118), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(569), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(567), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12340] = 10,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1123), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1121), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [12398] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(607), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(605), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12442] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(527), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(525), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12486] = 10,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1127), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1125), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [12544] = 4,
    ACTIONS(1129), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(583), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(578), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12590] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(551), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(549), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12634] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(561), 16,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(559), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12678] = 14,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(45), 1,
      sym_ident,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1132), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(290), 2,
      sym_term_eq,
      aux_sym_process_let_repeat1,
    STATE(792), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [12744] = 10,
    ACTIONS(743), 1,
      anon_sym_CARET,
    ACTIONS(745), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(747), 1,
      anon_sym_STAR,
    ACTIONS(749), 1,
      anon_sym_PLUS,
    ACTIONS(751), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(919), 1,
      anon_sym_XOR,
    ACTIONS(921), 1,
      anon_sym_u2295,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1136), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1134), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [12802] = 4,
    ACTIONS(1142), 1,
      anon_sym_AT,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1140), 9,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1138), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [12847] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(455), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(449), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12890] = 11,
    ACTIONS(1144), 1,
      anon_sym_SEMI,
    ACTIONS(1146), 1,
      anon_sym_PLUS,
    ACTIONS(1148), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1150), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(1152), 1,
      anon_sym_XOR,
    ACTIONS(1154), 1,
      anon_sym_u2295,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(927), 9,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(925), 17,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12949] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(611), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(609), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [12992] = 11,
    ACTIONS(1146), 1,
      anon_sym_PLUS,
    ACTIONS(1148), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1150), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(1152), 1,
      anon_sym_XOR,
    ACTIONS(1154), 1,
      anon_sym_u2295,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(1160), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(915), 9,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(913), 17,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13051] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(715), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(713), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13094] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(671), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(669), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13137] = 4,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(725), 14,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(723), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13182] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(471), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(461), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13225] = 11,
    ACTIONS(1146), 1,
      anon_sym_PLUS,
    ACTIONS(1148), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1150), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(1152), 1,
      anon_sym_XOR,
    ACTIONS(1154), 1,
      anon_sym_u2295,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(1162), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(955), 9,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(953), 17,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13284] = 9,
    ACTIONS(1148), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1150), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(1152), 1,
      anon_sym_XOR,
    ACTIONS(1154), 1,
      anon_sym_u2295,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(939), 10,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(937), 18,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13339] = 6,
    ACTIONS(1150), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(741), 12,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_u2295,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(739), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13388] = 4,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(729), 14,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(727), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13433] = 8,
    ACTIONS(1146), 1,
      anon_sym_PLUS,
    ACTIONS(1148), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1150), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(733), 11,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_u2295,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(731), 18,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13486] = 5,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(737), 13,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(735), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13533] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(663), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(661), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13576] = 11,
    ACTIONS(1146), 1,
      anon_sym_PLUS,
    ACTIONS(1148), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1150), 1,
      anon_sym_PERCENT_PLUS,
    ACTIONS(1152), 1,
      anon_sym_XOR,
    ACTIONS(1154), 1,
      anon_sym_u2295,
    ACTIONS(1156), 1,
      anon_sym_STAR,
    ACTIONS(1158), 1,
      anon_sym_CARET,
    ACTIONS(1164), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(933), 9,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(931), 17,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13635] = 13,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(280), 2,
      sym_term_eq,
      aux_sym_process_let_repeat1,
    STATE(792), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [13698] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(667), 15,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG,
      anon_sym_LT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT_PLUS,
      anon_sym_u2295,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_DOLLAR,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(665), 19,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      anon_sym_PLUS,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_XOR,
      anon_sym_TILDE,
      anon_sym_PERCENT,
      sym_ident,
  [13741] = 13,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(299), 2,
      sym_term_eq,
      aux_sym_process_let_repeat1,
    STATE(792), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [13804] = 4,
    ACTIONS(589), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1170), 9,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1168), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [13849] = 5,
    ACTIONS(589), 1,
      anon_sym_COLON,
    ACTIONS(1176), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1174), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1172), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [13896] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1170), 9,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1168), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [13938] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1180), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1178), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [13986] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1190), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1188), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14034] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1194), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1192), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14082] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1198), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1196), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14130] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1202), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1200), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14178] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1206), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1204), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14226] = 13,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    STATE(487), 1,
      sym_equation,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(806), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [14288] = 7,
    ACTIONS(1212), 1,
      anon_sym_prio,
    ACTIONS(1214), 1,
      anon_sym_deprio,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(457), 2,
      sym_prio,
      aux_sym_tactic_repeat1,
    STATE(477), 2,
      sym_deprio,
      aux_sym_tactic_repeat2,
    ACTIONS(1210), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1208), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14338] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1218), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1216), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14386] = 4,
    ACTIONS(1224), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1222), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1220), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14430] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1228), 9,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1226), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14472] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1232), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1230), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14520] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1236), 9,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1234), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14562] = 5,
    STATE(526), 1,
      sym_option,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1240), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1242), 5,
      anon_sym_translation_DASHstate_DASHoptimisation,
      anon_sym_translation_DASHprogress,
      anon_sym_translation_DASHasynchronous_DASHchannels,
      anon_sym_translation_DASHcompress_DASHevents,
      anon_sym_translation_DASHallow_DASHpattern_DASHlookups,
    ACTIONS(1238), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14608] = 13,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    STATE(502), 1,
      sym_equation,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(806), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [14670] = 7,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(1248), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1246), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
    ACTIONS(1244), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14720] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1252), 9,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1250), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14762] = 8,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(1258), 1,
      anon_sym_SEMI,
    ACTIONS(1260), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1256), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
    ACTIONS(1254), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14814] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1264), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1262), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14862] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1268), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1266), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14910] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1272), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1270), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [14958] = 5,
    STATE(526), 1,
      sym_option,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1242), 5,
      anon_sym_translation_DASHstate_DASHoptimisation,
      anon_sym_translation_DASHprogress,
      anon_sym_translation_DASHasynchronous_DASHchannels,
      anon_sym_translation_DASHcompress_DASHevents,
      anon_sym_translation_DASHallow_DASHpattern_DASHlookups,
    ACTIONS(1276), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1274), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15004] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1280), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1278), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15052] = 4,
    ACTIONS(1286), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1284), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1282), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15096] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1290), 9,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1288), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15138] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1284), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1282), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15186] = 4,
    ACTIONS(1296), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1294), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1292), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15230] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1294), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1292), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15278] = 7,
    ACTIONS(1212), 1,
      anon_sym_prio,
    ACTIONS(1214), 1,
      anon_sym_deprio,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(457), 2,
      sym_prio,
      aux_sym_tactic_repeat1,
    STATE(471), 2,
      sym_deprio,
      aux_sym_tactic_repeat2,
    ACTIONS(1300), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1298), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15328] = 7,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(1306), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1304), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1302), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15378] = 4,
    ACTIONS(1312), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1310), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1308), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15422] = 7,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(1318), 1,
      anon_sym_else,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1316), 7,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_SEMI,
    ACTIONS(1314), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15472] = 4,
    ACTIONS(1324), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1322), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1320), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15516] = 13,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    STATE(537), 1,
      sym_equation,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(806), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [15578] = 4,
    ACTIONS(1330), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1328), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1326), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15622] = 4,
    ACTIONS(1336), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1334), 8,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_RPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
    ACTIONS(1332), 24,
      anon_sym_end,
      anon_sym_PIPE,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_else,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15666] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(748), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [15725] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(236), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [15784] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(811), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [15843] = 4,
    ACTIONS(1340), 1,
      anon_sym_DQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1342), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_LBRACE,
    ACTIONS(1338), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      sym_standard_goal_ranking,
      anon_sym_O,
      anon_sym_o,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [15886] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(743), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [15945] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(313), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16004] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(734), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16063] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(809), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16122] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(319), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16181] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(801), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16240] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(732), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16299] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(187), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16358] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(188), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16417] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(190), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16476] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(181), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16535] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(174), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16594] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(295), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16653] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(178), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16712] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(739), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16771] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(800), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16830] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(645), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16889] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(179), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [16948] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(192), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17007] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(314), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17066] = 12,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    ACTIONS(157), 1,
      anon_sym_TILDE,
    ACTIONS(159), 1,
      anon_sym_PERCENT,
    ACTIONS(161), 1,
      anon_sym_SQUOTE,
    ACTIONS(163), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1366), 1,
      sym_ident,
    ACTIONS(1368), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(716), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(689), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17125] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(195), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17184] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(802), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17243] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(315), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17302] = 12,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    ACTIONS(157), 1,
      anon_sym_TILDE,
    ACTIONS(159), 1,
      anon_sym_PERCENT,
    ACTIONS(161), 1,
      anon_sym_SQUOTE,
    ACTIONS(163), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1366), 1,
      sym_ident,
    ACTIONS(1368), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(699), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(689), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17361] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(755), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17420] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(789), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17479] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(240), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17538] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(300), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17597] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(312), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17656] = 12,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    ACTIONS(157), 1,
      anon_sym_TILDE,
    ACTIONS(159), 1,
      anon_sym_PERCENT,
    ACTIONS(161), 1,
      anon_sym_SQUOTE,
    ACTIONS(163), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1366), 1,
      sym_ident,
    ACTIONS(1368), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(700), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(689), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17715] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(308), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17774] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(292), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17833] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(741), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17892] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(310), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [17951] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(793), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18010] = 12,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    ACTIONS(157), 1,
      anon_sym_TILDE,
    ACTIONS(159), 1,
      anon_sym_PERCENT,
    ACTIONS(161), 1,
      anon_sym_SQUOTE,
    ACTIONS(163), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1366), 1,
      sym_ident,
    ACTIONS(1368), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(701), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(689), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18069] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(233), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18128] = 12,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    ACTIONS(157), 1,
      anon_sym_TILDE,
    ACTIONS(159), 1,
      anon_sym_PERCENT,
    ACTIONS(161), 1,
      anon_sym_SQUOTE,
    ACTIONS(163), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1366), 1,
      sym_ident,
    ACTIONS(1368), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(702), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(689), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18187] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(649), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18246] = 12,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    ACTIONS(157), 1,
      anon_sym_TILDE,
    ACTIONS(159), 1,
      anon_sym_PERCENT,
    ACTIONS(161), 1,
      anon_sym_SQUOTE,
    ACTIONS(163), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1366), 1,
      sym_ident,
    ACTIONS(1368), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(703), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(689), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18305] = 12,
    ACTIONS(147), 1,
      anon_sym_EQ,
    ACTIONS(153), 1,
      anon_sym_LT,
    ACTIONS(155), 1,
      anon_sym_DOLLAR,
    ACTIONS(157), 1,
      anon_sym_TILDE,
    ACTIONS(159), 1,
      anon_sym_PERCENT,
    ACTIONS(161), 1,
      anon_sym_SQUOTE,
    ACTIONS(163), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1366), 1,
      sym_ident,
    ACTIONS(1368), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(706), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(689), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18364] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(808), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18423] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(653), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18482] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(654), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18541] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(656), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18600] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(657), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18659] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(650), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18718] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(647), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18777] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(745), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18836] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(750), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18895] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(805), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [18954] = 12,
    ACTIONS(1370), 1,
      sym_ident,
    ACTIONS(1372), 1,
      anon_sym_EQ,
    ACTIONS(1374), 1,
      anon_sym_LPAREN,
    ACTIONS(1376), 1,
      anon_sym_LT,
    ACTIONS(1378), 1,
      anon_sym_DOLLAR,
    ACTIONS(1380), 1,
      anon_sym_TILDE,
    ACTIONS(1382), 1,
      anon_sym_PERCENT,
    ACTIONS(1384), 1,
      anon_sym_SQUOTE,
    ACTIONS(1386), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(655), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(637), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19013] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(740), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19072] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(193), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19131] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(798), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19190] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(317), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19249] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(235), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19308] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(303), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19367] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(183), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19426] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(790), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19485] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(783), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19544] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(306), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19603] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(785), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19662] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(807), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19721] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(754), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19780] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(799), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19839] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(273), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19898] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(193), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [19957] = 12,
    ACTIONS(1348), 1,
      sym_ident,
    ACTIONS(1350), 1,
      anon_sym_EQ,
    ACTIONS(1352), 1,
      anon_sym_LPAREN,
    ACTIONS(1354), 1,
      anon_sym_LT,
    ACTIONS(1356), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_TILDE,
    ACTIONS(1360), 1,
      anon_sym_PERCENT,
    ACTIONS(1362), 1,
      anon_sym_SQUOTE,
    ACTIONS(1364), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(186), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(133), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20016] = 12,
    ACTIONS(85), 1,
      anon_sym_EQ,
    ACTIONS(115), 1,
      anon_sym_LT,
    ACTIONS(117), 1,
      anon_sym_DOLLAR,
    ACTIONS(119), 1,
      anon_sym_TILDE,
    ACTIONS(121), 1,
      anon_sym_PERCENT,
    ACTIONS(123), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1344), 1,
      sym_ident,
    ACTIONS(1346), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(305), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(283), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20075] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(787), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20134] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(733), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20193] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(709), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20252] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(183), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20311] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(719), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20370] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(714), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20429] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(710), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20488] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(794), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20547] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(749), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20606] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(766), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20665] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(196), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20724] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(769), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20783] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1388), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(704), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20842] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(197), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20901] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(198), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [20960] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(194), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [21019] = 12,
    ACTIONS(9), 1,
      anon_sym_EQ,
    ACTIONS(19), 1,
      anon_sym_LT,
    ACTIONS(21), 1,
      anon_sym_DOLLAR,
    ACTIONS(23), 1,
      anon_sym_TILDE,
    ACTIONS(27), 1,
      anon_sym_PERCENT,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(277), 1,
      anon_sym_LPAREN,
    ACTIONS(1166), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(767), 11,
      sym__term,
      sym_tuple_term,
      sym_mset_term,
      sym_nat_term,
      sym_xor_term,
      sym_mul_term,
      sym_exp_term,
      sym_nested_term,
      sym_nullary_fun,
      sym_binary_app,
      sym_nary_app,
    STATE(144), 12,
      sym__literal,
      sym__non_temporal_var,
      sym_pub_var,
      sym_fresh_var,
      sym_msg_var_or_nullary_fun,
      sym_nat_var,
      sym_comp_var,
      sym__custom_type_var,
      sym_custom_var,
      sym_any_var,
      sym_pub_name,
      sym_fresh_name,
  [21078] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1392), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_LBRACE,
    ACTIONS(1390), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      sym_standard_goal_ranking,
      anon_sym_O,
      anon_sym_o,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21118] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1396), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1394), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21158] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1400), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1398), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21198] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1404), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1402), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21238] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1408), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_LBRACE,
    ACTIONS(1406), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      sym_standard_goal_ranking,
      anon_sym_O,
      anon_sym_o,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21278] = 5,
    ACTIONS(1414), 1,
      anon_sym_prio,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(457), 2,
      sym_prio,
      aux_sym_tactic_repeat1,
    ACTIONS(1412), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1410), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_deprio,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21322] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1419), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1417), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21362] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1423), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1421), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21402] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1427), 6,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
      anon_sym_COMMA,
    ACTIONS(1425), 25,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_left,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_variants,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21442] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1005), 14,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_BANG,
      anon_sym_RBRACK_DASH_GT,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1003), 16,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      sym_ident,
  [21481] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1009), 14,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_BANG,
      anon_sym_RBRACK_DASH_GT,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(1007), 16,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      sym_ident,
  [21520] = 5,
    ACTIONS(1214), 1,
      anon_sym_deprio,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(475), 2,
      sym_deprio,
      aux_sym_tactic_repeat2,
    ACTIONS(1210), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1208), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21563] = 5,
    ACTIONS(1429), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(547), 3,
      sym__function_sym,
      sym_function_untyped,
      sym_function_typed,
    ACTIONS(1433), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1431), 21,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
  [21606] = 5,
    ACTIONS(1429), 1,
      sym_ident,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(547), 3,
      sym__function_sym,
      sym_function_untyped,
      sym_function_typed,
    ACTIONS(1437), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1435), 21,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
  [21649] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1001), 14,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_BANG,
      anon_sym_RBRACK_DASH_GT,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(999), 16,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      sym_ident,
  [21688] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1441), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1439), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21733] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1445), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1443), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21778] = 5,
    ACTIONS(1451), 1,
      anon_sym_variants,
    STATE(523), 1,
      sym_variants,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1449), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1447), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21821] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1455), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1453), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21866] = 5,
    ACTIONS(1214), 1,
      anon_sym_deprio,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(475), 2,
      sym_deprio,
      aux_sym_tactic_repeat2,
    ACTIONS(1459), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1457), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21909] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(983), 14,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_BANG,
      anon_sym_RBRACK_DASH_GT,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(981), 16,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      sym_ident,
  [21948] = 5,
    ACTIONS(1465), 1,
      anon_sym_COMMA,
    STATE(479), 1,
      aux_sym_variants_repeat1,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1463), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1461), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [21991] = 3,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(466), 14,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_SEMI,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_BANG,
      anon_sym_RBRACK_DASH_GT,
      anon_sym_LT,
      anon_sym_DOLLAR,
      anon_sym_PERCENT,
      anon_sym_SQUOTE,
      anon_sym_TILDE_SQUOTE,
    ACTIONS(975), 16,
      anon_sym_PIPE,
      anon_sym_new,
      anon_sym_out,
      anon_sym_in,
      anon_sym_if,
      anon_sym_else,
      anon_sym_let,
      sym_null,
      anon_sym_event,
      anon_sym_insert,
      anon_sym_delete,
      anon_sym_lookup,
      anon_sym_lock,
      anon_sym_unlock,
      anon_sym_TILDE,
      sym_ident,
  [22030] = 5,
    ACTIONS(1471), 1,
      anon_sym_deprio,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(475), 2,
      sym_deprio,
      aux_sym_tactic_repeat2,
    ACTIONS(1469), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1467), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [22073] = 6,
    ACTIONS(1182), 1,
      anon_sym_PIPE,
    ACTIONS(1184), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1186), 1,
      anon_sym_PLUS,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1476), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1474), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [22118] = 5,
    ACTIONS(1214), 1,
      anon_sym_deprio,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    STATE(475), 2,
      sym_deprio,
      aux_sym_tactic_repeat2,
    ACTIONS(1300), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1298), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [22161] = 5,
    ACTIONS(1482), 1,
      anon_sym_COMMA,
    STATE(478), 1,
      aux_sym_variants_repeat1,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1480), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1478), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [22204] = 5,
    ACTIONS(1465), 1,
      anon_sym_COMMA,
    STATE(478), 1,
      aux_sym_variants_repeat1,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1487), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1485), 23,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_right,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [22247] = 6,
    ACTIONS(1451), 1,
      anon_sym_variants,
    ACTIONS(1489), 1,
      anon_sym_left,
    STATE(523), 1,
      sym_variants,
    ACTIONS(3), 2,
      sym_multi_comment,
      sym_single_comment,
    ACTIONS(1449), 5,
      anon_sym_POUNDifdef,
      anon_sym_POUNDelse,
      anon_sym_POUNDendif,
      anon_sym_POUNDdefine,
      anon_sym_POUNDinclude,
    ACTIONS(1447), 22,
      anon_sym_end,
      anon_sym_builtins,
      anon_sym_functions,
      anon_sym_equations,
      anon_sym_predicate,
      anon_sym_predicates,
      anon_sym_options,
      anon_sym_heuristic,
      anon_sym_tactic,
      anon_sym_process,
      anon_sym_let,
      anon_sym_export,
      anon_sym_rule,
      anon_sym_macros,
      anon_sym_restriction,
      anon_sym_axiom,
      anon_sym_test,
      anon_sym_lemma,
      anon_sym_diffLemma,
      anon_sym_equivLemma,
      anon_sym_diffEquivLemma,
      sym_ident,
  [2229