/* These entries are automatically generated by makedesc.py to make sure
 * that their keys and signatures are right except when otherwise
 * specified. */

static const char EX_RI_MINIMAL[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAbeja00FtmqpWPIF6GPZtoI0uBiRk7InZ3EV/8U/e1KRAQAgBADZeEW7\n"
  "LYPn7S5mD4DnQpTVdns8xJtRboTtfqTs6nTpOwWV8+WI94ZME6k6T2FEChi/3qs8\n"
  "VeCQIM2wW6rEQyUcQzFwqk9bks20K/8x/2vxGopxeAPpJ3glHYqweNM1ZAQ=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAL2WKwBXssq8ImAdp9VauVXKiKNPsW2ocRlEVsmTLc+R7KORI7ssMM33\n"
  "1TV5fjKw9a7kSAVKWuthHlpYf8zVosEaECEon2K9zlKPzpGYTfIecKzMTZdjP4mR\n"
  "Eo10yberjn0W9dRbqCM2Cq6ofJpz8du3o2hDCx4N880Fyr+G1or3AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 2XhFuy2D5+0uZg+A50KU1XZ7PMSbUW6E7X6k7Op06Ts=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANfuddZ47R/rAqf1vgryApzX6k3Lp4kfY8dgortrpeIY2AMrPPBrDc+r\n"
  "TVBeKRtnlOUstHtZ6ZV9BNUUg1zd0+RlkITWlSRrKXDI8SskNh5RhyB6cYNyKmld\n"
  "tpyTl1BCvqDb+5QHzNtuQ6zGfo2U2WqZarGEwb5edfPy5iMRNyNtAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key 2kTFTRb+2MmTBjlS9o1bD/1YGQSqYez46+ROA777jGw=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAdl4Rbstg+ftLmYPgOdClNV2ezzEm1FuhO1+pOzqdOk7AGsEQYwHCV65\n"
  "YCx4fS6zYcrq/nMtz0EfoVyVBbBsRemZ4eXH+a5tOZf6uQDHwE2na8s1sdLB0LcJ\n"
  "k4lxJJAT6wE=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "1xp9J+HTe7Xz9otke8bGVo0jeTICkbV372X0x4r2Nlex+U4pNMI+H7r2VEn0xCa4\n"
  "0Mv6huE9/oYVZL0/XgDNJKiYlzDTQvaabvb5teLc31O5AnFS6LvIo0FFflNvaoLE\n"
  "6h/siROaO9/n3Y56hGNbkg/omkuRsv0+UddLjLxxs8Y=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 WGGVwF/5vU7kD4U3N26vuh5cie0AQc+xmVeV4ikdhGOgChNqqVG5fRN8pl2x0wPJipC1aJwJf9GOamMChSP4Ag\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "UQ4017wr2yQlu0wVBuLJlJLWudEGJ+9Z+ZiyJRCrsVauB1L2o+oCK5fsrQeKIWQM\n"
  "PSJ2o1tXgHAxJixOoTu1tlWNdZeQGNYRh7N2IbRvtwZ1p7NwgM5cG7CCQ/JDiGGy\n"
  "exMCOnyJpT2pD6KS2SEhbFe4nGxeUnmiJhSFsxAl9Q0=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_MAXIMAL[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAcDfLx3m1n7Cd3ZUnm+i/fjYWdxZJ2OxffZTq+C5Qhh8AQAgBAD8rDLK\n"
  "Vraijk0AAOo1CC2vJ+D+E5NwcwrOyKW9Q9wa17CXmHNUAw3LzqxT6RfoWtvKTNZ7\n"
  "CtrLhi7vW4ypl9u0KC2DUofm2of/vmGDVeNqbe8EYWdvLnU284Xy6GCt6QQ=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAL0rYefTyz0UxOqvMHkcMN/Otd5PpHQeEOuEI0CwnIe1BaHP9Z3o2T7c\n"
  "BoIkjYN4WWUss2ymcpFsikHO1/Qt7Jjeg0teLKeRk6kxoBeoXU3jH/XWIZQ72C0b\n"
  "NDxIvm0ZO8hHXpXySbL7WdUE2FmPZA92+LI02PVh05FNdvPODnTBAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 /Kwyyla2oo5NAADqNQgtryfg/hOTcHMKzsilvUPcGtc=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANPEmrfTxh6KAokO33hjwdCG5VqwSRf8D85MF7as4WrqIvmq3l+yhX4N\n"
  "rxBXU/oH2NHdkEJp+wDi3ec0U4RO3x5N3c+pkLJ7T3PzX2bqyhXw+M8KFH9OgV8R\n"
  "uDjeZde+6/I78zf9c93N+44348otSnOIVJi7J2XcKc1nLEg+kaSVAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key XNNdSQl9M8leFmXQy8fR4LBWUpSMAq/5sVrm1gdBcUo=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAfysMspWtqKOTQAA6jUILa8n4P4Tk3BzCs7Ipb1D3BrXAHKPG/YoVIfa\n"
  "3eEbf1Z5PTnWgUXAPjGnDsVwSRiO+L3cW55varIF4OzANq0YbBVk6DxuSKQRhitV\n"
  "Em9uzK+n9gw=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "pUhJD9GilzzJmZg7BKErxfjlqABZmV1/6U6MpquraNZy1q5/8Q/VMvVVyqkavLQd\n"
  "ue3QrEr9bUCG7TcrNYkCS95D0+Pgigzwmrxd7Ry4eBZTwUbm+G2HYLVCFX6YMX2r\n"
  "kkmsX8KYlVZxgkUPVsbTmjVjWxK9nRN9A7+8shNYzAQ=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject 127.0.0.1:*\n"
  "accept *:80\n"
  "reject *:*\n"
  "ipv6-policy accept 80,100,101\n"
  "uptime 1000\n"
  "hibernating 0\n"
  "unrecognized-keywords are just dandy in this format\n"
  "platform Tor 0.2.4.23 on a Banana PC Jr 6000 Series\n"
  "contact O.W.Jones\n"
  "fingerprint E9D3 2FC2 7674 5958 C315 803D BAF0 9EE5 C29C 3A0B\n"
  "read-history 900 1,2,3,4\n"
  "write-history 900 1,2,3,4\n"
  "extra-info-digest AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA\n"
  "hidden-service-dir\n"
  "allow-single-hop-exits\n"
  "family $AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA $BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\n"
  "caches-extra-info\n"
  "or-address [::1:2:3:4]:9999\n"
  "or-address 127.0.0.99:10000\n"
  "opt fred is a fine router\n"
  "router-sig-ed25519 uBj+IWQchmSBwFO9m2wyaGL2jQ6mz7vx9bUxavKAWovIBtB8b3XCyxOfs7bYP5yXM5MYGcAb2FG0S7BS344pCw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "Y/kIU3v/wA0Uq2mwGyELOMiBqhU2ydgqJVtgH/0oXWvl3YTX3JJCP0lSCWTYFX8N\n"
  "QZ6zlk9SCPcQ7etUFOZz7XNkDXChZCjRwK921+ko18b+6AK+OCZ1rTi8EepsgTGS\n"
  "DicGNpmReRVQc9wGWyXsRYS0KBeRBB42gweZ6vlG+6w=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_SIG1[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAYXI0XoJPqR80XqwEbqmiOLL5CwG71dv+66mseJUGu+gAQAgBADAWmwm\n"
  "dp+JZnolhz8FLdL6abtj+MRbcbhTTg5gDRdcSsc39Bf3UPkhUEhOtTn7tbyNXEtO\n"
  "iPDCvdR8t4xBgOqDLnNygoqMdCsf2eNYR8hzxXF4zn/La20L4g3hRwX5OgA=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANhXTGXVE78ronMXn5Im4nML51N69oYpEjh3QqLCq7V19vNCnCbQjcRT\n"
  "1zHEpL2+HIBHGW7r4phYtq6jRrPOkRk+9A43KMbyYUX8I6Zx/DrryYWKOyZi5Gh0\n"
  "9VmIp8uwL3oD2icNTIkvAZQ2N2EkMeqkHeqLvHhotDgNvWmOW2+lAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 wFpsJnafiWZ6JYc/BS3S+mm7Y/jEW3G4U04OYA0XXEo=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMAXX3EzjnH+PyThsoj9klX/WZRWSOzzCEKWu4+galdvzex4BRLnFjQd\n"
  "RWRPcu6jd4eT+niaf0xacmDZuUlObhH0KdMx85JV1DfIO+LicGXwf+A8capCMsdT\n"
  "E+ZRv+myozxvtYF5dXWWfBtb/HGyLBGP7LbiFM1a9Fy/opdCPI+/AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key LzriIs6B1YnUXISLCa0Ncgol4tt9coK0TlsyH9L8oyg=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAcBabCZ2n4lmeiWHPwUt0vppu2P4xFtxuFNODmANF1xKABvGX+C/nEsG\n"
  "zqV/hrnqlfA/+3Pslp9+uPNs7nuq/gfsVlIjcOMcH1wpun1LxJ4CfaHbRoV9Azjm\n"
  "AbJ4+sLFxgk=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "CLhxMDL3CG8PG1UADvY604uoSwWZ5qDmlHLBc2FkJvdpP/wzovI615W+ew/DA/Jp\n"
  "i5eHenjefH7LSfzGV1ZbjMZpRASqyHBsyl5nhOUEijRYlRi/LCsJutnOve6rJGfh\n"
  "dedKLdeCqplto7xhROxvZcqhpwJTC+iJ4ghM4Xcg8Sk=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 stCTjuw9egedA5hdDe1PQoljcLW3Fsg2ZYR3mre1moOd3mxTDI1Hz4uN+ZEDjedG4BNjDNcFY3qDS71Bs5cqDA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "aV5gqy5fTtsrdntTPRPGdeN376lXK+blHJuqbAL0WQ7XaMB4r+F8/whFu0cObOqD\n"
  "AqAhxkcMu721iYCkUNQvhc3FDou2i1mBJFDrhZEtux/2aXODIMG+OPdDUCyBqeQR\n"
  "oYLLfLR4ZZic1tlBFRRNdtXGF2SHeIM052F7PbeJz2A=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_TOKENS[] =
  "router bob\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAY1Po0v0V6qx88GtnuvL+A1OgBABUAjtKSNXR3ZZbB7BAQAgBADilhyL\n"
  "8kQhWtuPIYxVEQNYAqH/zZCGy7Dj84NEHauI7RaK3GtpbxrIKsMV6oIjyabSSwck\n"
  "lTBMZ21/EQERwvzyJC6XhSbPIWjI2MpZa5zez+RueZuGhOfqPDidE3sJUA8=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAOMS5ORipGxb7cm0JEUMxbTh6Jj8t2fMSC4sSAEWtScFVSa5Lc9duuPO\n"
  "QFRBMFSN7JPp7yv4MiQ/7UWQbm8KeSHwTdLJAaU9IaK8We0oQYPrW5qjHZGexYBu\n"
  "xy27uSSerxMnk9tulG/AGLQUwTaVVzMZKswvvx4Rerk1QBVQKAzhAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 4pYci/JEIVrbjyGMVREDWAKh/82Qhsuw4/ODRB2riO0=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANEtuNrjt+lqyvpAOhb1KgoZrtHOVsgvxbQxntUFWxNFWDu0pQ1oeD2Z\n"
  "sKK1LchHdDAZMo5Hx6Kph8zYtrOW5lP1uo8Q2UfZfkUvmMFWFzPE60Sw7OHW0emI\n"
  "53qvAsaKcGkqjH7/BqkNhoz+Z7kPrp1hj3bzPJL2WRwl5Oc5v0EDAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key /O0T65ZXDCLznQB8kW5e24GfH5Ep1Hp8Wn72d7MLKHc=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAeKWHIvyRCFa248hjFURA1gCof/NkIbLsOPzg0Qdq4jtALHBaxDDFa82\n"
  "TnVkxKLU/OQ+b8w1OFtaphO6OUPnF9TCuxcL1Q7uEyD8aVpgSHs6+vAsGEA/iYjV\n"
  "qNRsst8dAwQ=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "ILLtKDOLTh4o9trasbxFq0mXfZylPyo3CBjYwZlrSONma9vLmjVob6uU4hugoL9V\n"
  "Ti5+GgkfNszCiyDJfTkZtL57HtnbHEF6xrMcVDF4j3/ChJR4leaE9IiT2i2Qqe/k\n"
  "pQVThYaTVooBjuuenqqduGdkQD0sWR0Nd9sormczWbg=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 B/2mFc4gjSmcRguwheihVNruRrqjWWULorDNIIbF2eIER8ZG5DMiG9x57dKf68ga1MeL2Jx6BLhvIHpBxdloBA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "ymrdXf4aSaFDb5Qy39rn8u97kKqzs5HZ62dCWLHDyfewUSyNilg7Wt11v4cs7l/7\n"
  "zizuBHz0Y4E8d6rdoO4PP9KBWFnpcIblaPC5f/SLnNyP93Z6H55gzm1fvTU9cTZM\n"
  "zKSyCKiUSYpHba5jO70pyR0uOHeu6QhnuphxEN7/KOc=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_PUBLISHED[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAdYwLWzkkORAf4oCu7/DXxkHqpAuz/6kHURFX99fxos7AQAgBACvXQAY\n"
  "eQLaT3/Y512bMp/QFMwqhb3LZJrdQaamSfIkpeQgxtDmcMb2pzU4Qvq34qyBON0z\n"
  "3yqEUA8PkjK8F/tCayXzftZIMn88qna4OWtytpnRI+qhfkZ2qeCcsXKCTAE=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALoFN+2xSVUeUDh9zMC5O3MRa3T3hS1Uiw0KMgai6TXM4vYvIva5Hsmf\n"
  "jkD5eERRn9NvYF+dVM6mZqUsra93Q0P93WJjSS0V9Hi4KERAZEJYXpdOq6xwF2A0\n"
  "fy7AfcxrARjk6Scjqq4WRdWJ80F7fmtRC2aJQx9hrsoYJUylkzc9AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 r10AGHkC2k9/2OddmzKf0BTMKoW9y2Sa3UGmpknyJKU=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALKTuo70dMO6xF89bE/ke4IkN2V9t49UtSI+X607oul59J32YEjCdhOh\n"
  "mGDw9c/IpUg/fC6yyhNxrVJttKHju3bcHqMTMbkjvyQcEqRRR3f8i5YNmLj3bNxc\n"
  "vyom0RpyUopuVUx3IFhd1R3MkBVLjMVYOu9zpre8PnDeEtjFNpZlAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key v6c+IGW5pPiYjt/7EUjzO5VAEYETPAAr/qGw3H/N6AE=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAa9dABh5AtpPf9jnXZsyn9AUzCqFvctkmt1BpqZJ8iSlAEzibhI3GhEl\n"
  "AuLAGw9oa+6KcgVuJb77xBj/9uezeCXCkiPDA6HPjhLsBGlZTchRSZ2CNnRkMB5I\n"
  "phz7u5XhWgE=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "lyaSCIaSAW5R09tUtkwRvJBDYgCGq2zbgO3hkG8L0XoUAjBU+VyGdqUeWwt3mMeH\n"
  "nzOTa+oiO4uGbCic8nMXSQMeSD8X1uLTDn5w1QgJlGbJP0nfJyHPzFafIMKPYe9u\n"
  "bUWThv2WwfygfZLpm9Vtg+wOuCf6CEPUekBtV/mzDkw=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 99:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 4VtXGU7x0OmWCijvK6CGTrKEtEqmbfwau2oIWfmX2anU7rWKrHp29HlBljK62cso22ODdfjDA9xOIUF3/Rx2BA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "CLIS6weTFUdRmbZQXuu6084omWxMbVmbbEvVZcgxNJdFA1Kjj5XLLw4xU9710FHH\n"
  "FHqftfs5e483aw3ge/A44L03JL6aUeeQiRU7+A4daLq2h+pw7sTM5CzB9nQYMaQQ\n"
  "1PyCDtVGLPXlFcNyVsJV135RplESfC/SMOJCdqqErew=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_BANDWIDTH[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAaUhoYyIeOU1shTEDUP1aHQqyxQrwwVfEQgqR30hmhxgAQAgBAD/v+wN\n"
  "v7f62EeJZlcfrx3ar1tVPwbYg+tr8nI6vAsfZ5CnHu+tFZwH/z8wYr99xeLNE1WM\n"
  "PSS5gecVO5O/dmX2prMLZC+3+wTUNPMPhUeZEalQQmqtm1Lf132P7jQIpQY=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMJ1zsaN0EPSavqoy/FCS/fbm4MYJFcawEbMmB6mh0cQSR5koddyHeFO\n"
  "eQZAs9kAPgSOU7Ka1eMTJEZxYqOY3vsqUojdwqV4KGsSaWhPck74D0pZBEK6iaXP\n"
  "5R7dfo4Z/msPV0w7lWRkgn1WXCEq9Z6RXeW+82kZlq4tgQtwh3xvAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 /7/sDb+3+thHiWZXH68d2q9bVT8G2IPra/JyOrwLH2c=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKmq+DEg6AMhSUN7MFblSU3TcDg6fpmHANdELEKKIfSTu0uzjqpctZ8J\n"
  "GY0BHAFx/ckd3Sz6MFYo6UYgsKw93349DFG8KNTwxZH6ZvD1MhLQf1YcT2GRxGIZ\n"
  "lnisR0FRM8sw1d6gWd69wet9McE0+2BwsD2HgZDmHG5IZfNBq02tAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key 5VBTNKFPXQyw/SIdNg7zgW/pXqTh+VKIo8kObZQU5Go=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAf+/7A2/t/rYR4lmVx+vHdqvW1U/BtiD62vycjq8Cx9nAASWPz85p2Es\n"
  "QOD8JH26Zc5NWVauFqaTtoOrUnddgpfabhbugZ8jugBc47D9SJhkIMp3EfC6GlPw\n"
  "W3vOM1ovpA0=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "HY3nfEgabs7A4X1xrKk+4aIZGhrXycSXVaS7Xth0WogrNhK342+OfFkl9VdhYDpF\n"
  "SLAw54Vu4M9t18fQtDPaVANujrsvdItkm9YEnOATgXR4vFqBDWXO6NJjMpnmkpYR\n"
  "6OdOu2FpKi5K+WYuUUrkabeXdykPP11rmLx8QGfXKng=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth why hello there\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 W6O58DzFB5fa36RszIIcRUgLD5M/7CeVEXPjgfn/SVn2EXz2TMzTqZvJpEMSDWx++ZDvQ4x9VCZB35Rvu2SZBw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "tDz9zY+0EzMa7m33Bu6D1GApdsSh06uoVGKpbXT2FqQEa/Pl3xdkNURNIlqMqupi\n"
  "riyUaVud31+fQtkqV+KpAHBYCfKN6eT6KGloocCx8eK/w22+O/vAnF9wviDJLcg5\n"
  "q5LyGgs6ZGO6x9VfOScemj8BRjBQ5ro4MRyzSekm3ew=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_ONIONKEY[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAW1xClFKHwnXFI+597t7/uU2mng7CGM9sc7FRKee3UlfAQAgBACPfVQl\n"
  "9cApxwShdfQ9+w4Akbp+zzrxQjJLwq0Qe7qvKgyl7u1hWyJH/aguIbkCQDPhDUsj\n"
  "Mc5xVdNamPsWuPRIyxKJLQ9+bhJtUeI3SYc0BwMCUzP4a4EkqeGvvbOEvw0=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALiWTCyh2ZwplM4DQDwQ1DKVmTInxsuILLmv8DATTZXyMhsBnHf7UPTf\n"
  "qYZz78V/bW5JSluXYPaLvt1ZteZelLAabbaTl9ezmH0unaXQ7K4lE+Ige/rA0Vfj\n"
  "YKF/MLdSsEeFj8pAomQvaqUoBgByGHz+eLLVcSAGTvl8hiEXTBSjAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 j31UJfXAKccEoXX0PfsOAJG6fs868UIyS8KtEHu6ryo=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGHAoGBANBKlyoqApWzG7UzmXcxhXM4T370FbN1edPbw4WAczBDXJslXCU9Xk1r\n"
  "fKfoi/+WiTGvH7RcZWPm7wnThq2u2EAO/IPPcLE9cshLBkK28EvDg5K/WsYedbY9\n"
  "1Gou+7ZSwMEPv2b13c7eWnSW1YvFa64pVDKu2sKnIjX6Bm0HZGbXAgED=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key wIOhItdhRuyT0Feij9xNXTEPuV9mE6fXU8Y6l1Mjjx4=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAY99VCX1wCnHBKF19D37DgCRun7POvFCMkvCrRB7uq8qAEYfc9irhCYM\n"
  "WseTLWwjMSClI277sp1lzy1Y7PN/tlQqZkG1mRcGELYARY1cWkj4b2G09oKY41TF\n"
  "1+EG5BTCSA4=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "E/Sq3MBmp6wnl6QQXI9pt+B2cGzepUMuOvb+v9tN0+YHE81VRHzXORq6kEVRvc5e\n"
  "t/7qpynQ9QcsPMfPHr/6hFJMHvBKJAKl4ulbdy+dIkKSiwhgp1bXqUV9GoUjDAHy\n"
  "fw1CA6oKififqoMVqZN6infAVIo7yl6OPAhY1yZLIMI=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 Iw6AuWlz9lT69zV9UjBWiPrenfnuTITlv0YxJlJ00k2kzQTKOTcbEBYrqbm1uDWzgcLqtw2BI48V/VpE9JzFAA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "U15TJrcDOWr7qwtZH46wpAfSZlN/oinnf0a1wPEYQvHditLj6WgH9p4/r0BT8dI1\n"
  "hi1Y6KWZhMx7/Qwq/MyigMeQelHV2caiWEySKqqfxfa7yore5+ismj0quBTCJaWv\n"
  "3sM4zWkwaVPvTNtz1btsJYkEKWG3NvPNcZHpxZr2dj4=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_PORTS[] =
  "router fred 127.0.0.1 900001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAfb3eBF1wYkkPlk5AHyDmRwtEQDfd7pzfAYRcInfzwnvAQAgBABFNYwJ\n"
  "gZyXCSt9SbuYCDYXpKt4cPuAW9BCmRHABo7BUcRuOWtfVn0zH5qs4V3490Anu8p6\n"
  "KHYDAiAS2gfcnTc2OCz1iw1rY1egGjH5+uUIjckdftghs4QOghLVmyUSHQM=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANKi30IsA+x93+fyVJjP8IC3iF8TWe4lJsYbTCvfcJa0+j/GSPLdxClT\n"
  "AT4QJkNCNgZcJmo1QqiFAUZHeWs7kKhlSyQT7YLrpSlnjRIBwPBn8ddAY/X67tpS\n"
  "eXAiWzhpEuzHgle3nCQMlYNUQJp0Yyj6UvK9SiD9B/WCs/ICmWzDAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 RTWMCYGclwkrfUm7mAg2F6SreHD7gFvQQpkRwAaOwVE=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALpZKULTdehX4/NbsioiJ6i3m5YiUe0iKpRnx51VkFOd0HaRdfY1AEyo\n"
  "FSQtRBYgzugvd6RnWknzcl5r3f38irYS1aAidS4fkTBq1Ce58Yx5iiaHIjylrFlH\n"
  "3f9N9m/mny5l0QgGvqI+dl94/zr80hDDSxrlH7eIvcIa+BuoTfdNAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key qR1PUvc7ky3rgJ6mWwjNo1aAQZsFZDsJHVy8akTgHls=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAUU1jAmBnJcJK31Ju5gINhekq3hw+4Bb0EKZEcAGjsFRABHNkPpYhab0\n"
  "ehvtfFPDt90wzDnWsebaqe6EZe+bPSrZCGGDMjgs/1VajEK09zH0FV/F3d5B+XYw\n"
  "YegiFba6mwE=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "QJCikM5x69I4ErNhwwLTGZ8utGy9P5NjAK+T1BgPOkJJJTzLWz/t5AhLUorAmvC3\n"
  "fa4byUrVFX8wO6bmnMINaBDVPVlVVcWp2fclI7f9l8q/oCp1GKdmYnyky2RxoXoK\n"
  "qJBi5CnLCRjpaO36Y4OeUld5jr3gzezDmkD7YQLtzAc=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 9tBjrFWWzCXx3ZUUgDHXykKsi+9sOoSYBneo+QZMtgWPJnYH16sT4eAQ0Y0PYd7OlXOZvOB5u3JX/yCujJpnCA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "AKtLxm4FGx5TawJi8kKQL5X8SyQTcDoyHXM+MH8SGjsx3tq560HCK+SGSeoWayGa\n"
  "s69aHl0nUmH5UMnDOdiWPZqzTi+K5kmO3ik3zkSZQ7/XsUMl+o6In3OkxQrqL7ka\n"
  "Xdqh3Zz3MT5DE6LBvTSRjnET1Bocfx2+bqkYpUEpxyo=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_NEG_BANDWIDTH[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAbfU59VhOWlweNlw/DQgCRjBh7EtF0hewpRHsuiVKUnTAQAgBABEV12f\n"
  "2PB6QzHgt/bGosT8rLoBpR16XSi8aqCdurCvr4niKEyudgp+d1h3J8UyB7stQ6T7\n"
  "qaKCyhXg4v96Rctc8nbi/2HMWvPj+wUqc8ArTrVSH8b3XPijrBU1RLTeFgU=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMTLuiE+qY3Msi3rgMQ6/jLJu3JyunkZ1MqMTgdqwLi7kPTQHUKg15v+\n"
  "6xUpEJG9lgdn55OKx4EWda0nntm+TvmPg32ijgX9+hfmQ/euy/kgfrFkN23JAa3k\n"
  "myqNj9p/LcUML3QFHi7V0mQkcNvXPKOQ001JqW78EGxBccuFQcP7AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 RFddn9jwekMx4Lf2xqLE/Ky6AaUdel0ovGqgnbqwr68=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANKNi9dzOok4QWBoT//XU/ok0UySUyZH41gNH5AM1kCMC34DNvfcTnHb\n"
  "KG57vyi9fUBQPpg6dOTav0feit8v6Mm18v0P1dMUzeFiiu3HjEeoEhpfCRyUGbtd\n"
  "LSaLLyLrFbM0Ejhh/DJXOdtSKBdPCgdRGceq3z1zihVvqOypm5eDAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key cGIQnSfgCDYXatS8Iiu7MN8iLAoFVageRdeDYd6Y4SM=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAURXXZ/Y8HpDMeC39saixPysugGlHXpdKLxqoJ26sK+vAC2ouHrvGEya\n"
  "blACfJBgviThszToS+i4ohSdWOXVEvXflIQPjttaduf6+B6YwLTcXnmCVDEq8Z0o\n"
  "Qc1FSGXkLgw=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "CN6jEFhWkQ3j46kbqRgfH5ngz6exkJj000887E7oinmWITJyVA2oX75NeU4uNdt+\n"
  "Qrv7bjQIvKyJ+ThzW+E6lNoDbd2Nb+9TkK25tOO7QEzWMOeG2ASvI9NOVlzOktIh\n"
  "w80DXx5kYgYQ3diDC136rkU4BBdnQDX5aryIqvhESEs=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 -1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 GN+uBj6dVw//1wQfItXo//CCQxgse+Ch45REa7XrJaJJHlThviicTmYL6gH4Ft76n6QElNppbys7MJpL/KuNDQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "h0ksY36ssG9o8ypJM9gedjDsw816vTOKhiJfaiC/jDdj95aflz3C/WfVviwVPrru\n"
  "2ThlVuJqESbBykEsW7zBQxJzR3m+1xo3aGpyK37pHx2M7Ys1NkxravfvTw2MVe2C\n"
  "ZSORjIQZirKTNq9OAPF6h/xxiRvI1tlvMBN6bfeyVe8=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_IP[] =
  "router fred 100.127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAXBpI4NGHpiYtqH9QSueuPqjGjV+NwTGv1Wr7AAEr/lAAQAgBABzxwnC\n"
  "88ko/02rKCpajAup4icjbr7R2Yzj4i3/d36G8LmUMVTI8TRIwjV9CMQehqfNWMq7\n"
  "Cmm5b79vpKgjk7ahT/UajbwPxdmec5C72pUiszuTkAdh7OLFeA89BUPkYQQ=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAPG7HhynsWUO4hRHZ9yljs1/DFba8wuw56k//JLHDaM7GXwvfOjzTznZ\n"
  "Iz8GjT7a0s+XvIqIwBxxUfsffAdRpoUVoJGTvcuLrbYTjVvhZ2rKBgXk1Dy+HOSZ\n"
  "rF7/3X7n73Jw27g07yB4Ymz7pCrqFTEdHUSEe998IE5yWRwPcJKhAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 c8cJwvPJKP9NqygqWowLqeInI26+0dmM4+It/3d+hvA=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMWXC95x/pQF+LVa7Z2LKjuL1Zow6+I/2pK5pxqwTv0LiZHEjrCq5Yyn\n"
  "cXobbDuQqMIQs9MiZl9mceXNz9gORncgN9MGae7mAcQFJIH+Hv5Bp2h1QVpjllcl\n"
  "yhGFtDVfGjOmr1AUAP2gR7GsmLMzjH6bUtD0o8JujF683x6VRGTDAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key Ue8UgMdiy+jJN+u+N304hAjGzli0ckutdhwTwpJj5Bs=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAXPHCcLzySj/TasoKlqMC6niJyNuvtHZjOPiLf93fobwALDJghOhBUQ6\n"
  "PvjUF4HdnKk94mFUnVEuXhbDQkqVpUSwqaDgs8pvMps+kysskBrQT9m8UdtvFg+b\n"
  "7hC2d+i5iwg=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "fmwhrHV1jQWhrQ3GnQZoY1l2LPcw0kRMEobEyIcDiy3hCTQDQcaChlTVM+fzmcoL\n"
  "3aF5FFn7UICK8NAJ9P2HyyC185+KEoLKF6haXCMiTWye0tVN/pZgxvwY49WBEkfs\n"
  "yUcQa9Ixq6BxBjyxaDvsp7zXcdhFKYU3ukI3IAFVlqs=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 +GEY9H7Q+FV5nimwaLadRy4etG7TgGCKal0LqFhHc4L0dXv8EtcplaKUDxivN2u7bm05enwRWr/z/YxvAiR4DQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "0fO8rKE3VjyjmF506pxkOH8tIHaN+VBVQViRPE/JmCzBPnaNPIj3FnSaQ3lowlzz\n"
  "Gy4JE8+/6TS5t2C+MGHUsfTlTZOudtnd09fF/FGERljzzGNx4ABEhGIxf79TG3rj\n"
  "H0bMCfO3Q1x7X01WZ7f7kreVWC5z6fbrcCgvR7PIxuw=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_DIRPORT[] =
  "router fred 127.0.0.1 9001 0 bob\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAeSXj4cWNVaGVBdAZZDkDAdmQFTUpxHYo0ux4eoc7bytAQAgBAC4EaEq\n"
  "+La3x6f1fJqlT8YhqxetiSdlhLPcFkeWLTOTf3BRXHAQ1EVdiSu76J9il/gn6u4h\n"
  "j7jaUEIf3v6WovHJ2qAy7wiJRDuXO3aExat3RLJCvqvkaQjgrKFYAmlpDAc=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALJUtCdVl3BTyy761sZAnKa8N6VOT4QNBLSXxbmVOExMbyr7AVTvOeNk\n"
  "rrcDbKj35e6fcEFaJbPWHBuHCcRqH54BI2nD4CzR+t0RFSXYK7ZbyM1mhRR4Kshg\n"
  "WlEAaawZiXte09FAaSNZNrkzdQwXy86JXdZjwjyegfDRj9aaxS3xAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 uBGhKvi2t8en9XyapU/GIasXrYknZYSz3BZHli0zk38=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAL5TunHoAxAC+j3w9P9KmspLn/xl8EZZUfovx9gJ95S/R7uPZYMY1Cdf\n"
  "d0sObKeV/bdO+7EUT2dpu6ngMj+sS6xam1/VhI0DZemTVHVGh/NOr4P/5Gtgd5+L\n"
  "g21nRpc77sPtFibJSHhA8M3LGbwZEhbtje4N6r+HlOitX6u69z0JAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key XHq9XhW9b+fh+ZTAUiZw835EI5QzC0t353VeYWUrQFU=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAbgRoSr4trfHp/V8mqVPxiGrF62JJ2WEs9wWR5YtM5N/AD84uDUsUs8x\n"
  "FOOzaneZZrA38hU/7ocJJ0c8uyAHyJ2FKGsRrLvtK3dbrb1WEyZMTF4U0Ht5tF9h\n"
  "FYNzHcqFBA4=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "plpu9CjEVOV598popgY9KpeKyXYdhgV4e4cn8xq4ulQOAmqodjw5cd8iEkXYQF6z\n"
  "g6LT87XHdyLbVOa6Diz8ed7lX6gV0bNLId+mfu+wowTCKp9NxF/+/oZGF6gHrT9z\n"
  "XsoRUk89LO5JhHMhHH/WdHNe+d6EQGdqMC8oDzrZlTg=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 iIG3Qv7UShaMwFLJRnoplp6iS/Y+oz60D5hLbE41zpH3CzHNz/5dkbDrss5yMWPyWyBC9bZzUytNusyjBWjaDA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "eK0fcXaG9ZE5PseMnntHv2PQwEiSZZ3T+wrpQb97MwgIrU0zgBPc8fZZemMpiJ6O\n"
  "f+0SziFXrYWPOOji3fATBHm1w132bE/0lDbUYf17tHMq9/Uvy9cA03f7Vt2+A9tW\n"
  "xG0iqGpeqoJqg9DcYXbzB58tGkTGwVwSba6MXBRJSnU=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_NAME2[] =
  "router verylongnamethatnevereverendsandgoesontoolong 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAXPRPZ2/Fwcf6Y7r0OZ/DsY50YcgEUsDcYU9SNPRJRolAQAgBAA0NkVW\n"
  "i3wAeoIg9BeSaD11/nqc5+lOqxsRW5KgrUF5F9EaBcn1mK8QMpZmStY2pyk4PHtE\n"
  "dAHvytGNgzllNG8ZqCYWQbB38OcYIVp6snV5P6O5FVDzoLHKxB2RZq9CKA8=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAK1B43OIRWXV0MifW6xipNWJbezgje3v81ks04dgu4nNi/4opPzV5wJU\n"
  "3d244I4/KlRgzY4L7D/mxBYtoNtpC2Dae53TkgnLAwHdx77XkoEGuQMjFUtRxejj\n"
  "KtVUZW5N5kDCG6bItzpmULvRmYoJa0kSGn5nROo4CCiyJSX1tK6xAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 NDZFVot8AHqCIPQXkmg9df56nOfpTqsbEVuSoK1BeRc=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMWiMIxbssLwJpiCvHvZrg3sbXPMLu/EN3naP1PI0+R2NrlU5AAIEw2X\n"
  "NeK4LJyBdO4XXBFL+R3HBlUcXjzphHWxeRgYgg85AfF1xhqIgXpzA0AgGRaQ8GcZ\n"
  "5BZm8fBg8CRiS/DLIgwloQmvOJcUDqYLWqvz91zxeGHK+92msp0jAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key J7+npqmFouE4EuXuQAbhc8d6lGGab27mFTQLeXCnAzU=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQATQ2RVaLfAB6giD0F5JoPXX+epzn6U6rGxFbkqCtQXkXALDsSLNkQF1E\n"
  "8OpEiD4TyefBcLptg136A7UXqXbC1nWC+xUHYBCgkI5ymEtMHOn9bpl01ULisRH/\n"
  "29OEIlRPwQQ=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "tVZrb1HMx1OCvD61ulJgLwwRZz5mLv/qmIXym5JaWApvKPFwUkTeqlMKVD6HwmQq\n"
  "FWAVIvqZNSA5jkq5PJ+LpM7QBuUrA1tuDVnieCQKpC+iP3Gs9c1aad7jrpciDB9A\n"
  "MqaJkfketFTtOEa858NWMO/bHAIjcfnGHxRVf3vwIQk=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 +ZJ6ovLWqUfLCwpGqge14MwQfPiWhQYopxbzQQKPtgHnRO5qaMb4K7oIKmMkmKaDchTrz0WyIGFZez6u40qQCA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "PRiWQYy6k2mmwHHkP0AvQN/r318tQXWGzkNBlwoNwewVTRbq0J6Ds9aIWHAijd4b\n"
  "vW8E+AHWt3so1ucjq2ix5NwYInhiGHcTSRUqGOKo1WtgcrmGP00g5axZCVxsRDRf\n"
  "Ev4TNKSLXDRvblNSpYTccuTc/ExvKREplVrajjxN0X8=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_BANDWIDTH2[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAYnSPlxnc+nZZZIokyW+85uwJkjxUDEqTweLYVXCtdekAQAgBAD9bAif\n"
  "9zqaYAZfgnkiER+TADvD001LseJa0fQEPA8EN+zx+GpjHP2yBU1ZHPo4rtIDoaCl\n"
  "AioFwzs546cZoZGJsp7U6NDvncqIcu1rGEeOk2MK9Tw7Bfxvi5vkgEO6wAw=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMWlPXGRLRI5kHuR7pMHD977D0XkwSJ5QwrFnbi0FVG5tN79nRRfmZcJ\n"
  "5DRQAJu35CFo8wgHTJDec9/gXu1gjjDq6SfIcEVjIF1JX/pKC9+CpYbqhGBxTJLg\n"
  "ysPqgQDq4PdkqSU1FMzcW08FOXmVZCkPTm0J7CwKIefubo/IghjZAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 /WwIn/c6mmAGX4J5IhEfkwA7w9NNS7HiWtH0BDwPBDc=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAK80UOCQiPEWjOB8yPslBNOEPFcK5AKeA+hIIh6FFceGYxeiIWF5LBIC\n"
  "5g4dn1GBlUcPX3P/d5m0DXGnGPskwHFyQLpFO0ga4F5HdirTnEUMiko0Nonbrseu\n"
  "F44Dk+x/KGa1B+8Xr68HZbJGf3kHSlGVDFwVnSBwmRsMjTkW8qyDAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key wrcJB+L6TYel2UOh6d2/11nrQI5TePnxJUZZ54NUShs=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAf1sCJ/3OppgBl+CeSIRH5MAO8PTTUux4lrR9AQ8DwQ3AK0mat83aPjn\n"
  "XxaHRYZ0M6qHd5NhM0z6RGtw1SmT4AtK1g0ZkcVdDhgzjdu62Y5tU0pzBlK0A9Pr\n"
  "BW+haJUp4Qc=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "JDqs9wmPisHZOZ0s2Dj6E0jFvFhy6KcXuH0De6Ssud5TJqqY8RNOruJA+OIc5/mV\n"
  "7rAGsedOETg8d37D09q35RPCPNDC7Ja/Xud0BLeB2VBn3AwxDimHLtp6KyU93CzC\n"
  "nsUu8iblk6M/hPiinoo8s2qRWj3CvtX9xgkWxrfmI4o=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 hello 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 c5WgGlFiqkcoxrblfnz6S14En3b3F6TkHEqYDg3p9BHA0doDNntOiOJZr6y1hxuZZVxHkGyqz26wqHl1OXWrAA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "Vkqau37qjImmyVIa1+w8f8JdXAFiQ1js7gTmkHBxNJrNpNuwAIogOt8KVDwYL3yV\n"
  "fR3I+kRNjbWn5PfKY8fENtmwj25IpOeJB1UcC3bBpfaUHnUYj4nNLoOxfKO+cOoN\n"
  "uUhb2jyxJzbSFLuPmIlD5ZiDK9cT/J+Q/o36Ll9TLXE=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_UPTIME[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAQvNaHu5qx4lh0J5u39pwIR+4bHrHty+wSqMbmR4i5mGAQAgBAAm5VPl\n"
  "ChSd6wSrmDX50ZZmvkr3EZwt+R3JtUiYZ77yqVlAGBws0BGvUIbYOUHcS4pWuDSX\n"
  "KwVT5wktWdgm/VKqZv75Ekbt1HqVAtJVrTXWramFH1JfX+di4xIaYmYRZA4=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMn6qgw7XEvpr8+99/6trahXGW2laXSQGZzrgLdOAIeCK85uqhOmE15V\n"
  "4J+fvueDykuU5KpgIjvqC8GdzWWZ8THDMOfi2L4kfnF+KZLAxE2b/M67+8dYlIJY\n"
  "Xip1Wy9LRmJvlnLpwJtm4R6eYFSANEX1sSkQQKS3mgsJbAx9sOtPAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 JuVT5QoUnesEq5g1+dGWZr5K9xGcLfkdybVImGe+8qk=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKjYRj75Sv9HEGOb+MTtlOkBUHubxF6inexiMOOIeypOTU4tGbxz5CBx\n"
  "IPMR9HGSxR0maExkaBXjA35zIy9mjAMoclTc/cXdMiD/hJfcPACGBFyeKlblYNKd\n"
  "clR72dRskggOXPo8wSQMX+4ngB6wOfi6HWH+tT4ZW+VoO8DmraHBAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key eQjy89b9KtHPSi5/+lxGB2L2l98lbxP4wqOwVRbJPzc=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQASblU+UKFJ3rBKuYNfnRlma+SvcRnC35Hcm1SJhnvvKpAHV+58GHOOCu\n"
  "AdKmVPv2VitBQgdgYhgITdTEo4gHSWSnJ7NSf59IZQmleYAQDFC2ZJUJy0n5zTQj\n"
  "R4u9ikE2XQk=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "mrgyJtcOK97/nva7eGZLk1slPCGmRUm6CvfC/cVrbAiiJF7OxkPEb0SOO8291wKQ\n"
  "qCxQVXp1Ox/gcILrgRuOTMDDCEAKlYtofKaw+ya3XNqImLtxLNS4MzzNR4kNvuD5\n"
  "cd9wxTdUZMcbNnWxrwAtp3knuUbv5s+fPB/C9dPK+u8=\n"
  "-----END CROSSCERT-----\n"
  "uptime forever-and-a-day\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 YZgLS52VJa/LEUkgPEoWAuv6fpmD7BnTIYlxa/gF6OsQiriCTtZp1rg351eoMDt4lxaHFXdiE+uVj+97/thWDw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "O4zO6U4LPp/eEzhLMA1fCdkHW2GxlkvQx4x+v5v/DDf22r3YqQpazRoScAMXgqPd\n"
  "m6SWYs13ipqs1/9WDLbwv3dPqOAIgGvOeQobQ06Yxqi4nqg7WW+asbM5K7iNIFYZ\n"
  "SL51DpGbMKDwgRCaobua9LjxzOtrBROKgwpudn4drkM=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_BANDWIDTH3[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAZGXxVfBig1quo5wNr6AAbHSuTo8wQga3b0wyrhm49IrAQAgBAD8KBVe\n"
  "paDp9WBD9Yk6CbO7dqW2bGBYDYHxhMVrAP/xDV2Z7HOjXFjZa5dgz+kcqdxV9BQK\n"
  "Fvd6c3ZhRpb2jqTKSyoiwwnYOJ0qpbLbHjNC6kIiwzpMKF5/eBIRnL4vugY=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMQHT7ehq+M8EKdXLpxc244S7bFsV99WL9B38RS6uWp+Zw5iMhMqBQDU\n"
  "gLyTzojkB6/MhCQRlai5xmOdexpT9Il9H+C3d2L8A7tHj/58SMH5fUK9Pk91p1xV\n"
  "pTSkelUNNTTivrkhWYKkZ83N1X9QHEiyM9UOBrx+yQh/ANVOF90lAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 /CgVXqWg6fVgQ/WJOgmzu3altmxgWA2B8YTFawD/8Q0=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKpe3Vz5SPLedYcIun0NxBb9WHU+PF52CNtyfFSX7ydLk1fEq7ug2Kc3\n"
  "iT0kZYnYUqIM9tlp94JwOiFLaOfiYdqi1NF8eCHaljf0Fkl+LI4i7+TAxIvSWF9E\n"
  "00vfFN5vRmH2vnR/tGyM1kbrVJiaBKZLu2FkN7wS5gqXhQl40s3hAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key VxoUHpKVDO1CwJrUaszxPFyPFBYJpXscprJARNOUFCw=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAfwoFV6loOn1YEP1iToJs7t2pbZsYFgNgfGExWsA//ENAHxn+CYVO2ow\n"
  "HY22+Iab30Z52szYAWonI/ivMFc1JXDwhZEYw6p2S9tg5VhPc0EZyFdF1i/HrVwZ\n"
  "rLdd9n0apg0=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "qAE8PqbI12yeyLWaGyW8TtGv+LNXddZF7hTalGr/Hrd9JD3SrT0sPdn//qQZZbMe\n"
  "fFAiGR42w8P5XlLXp2O8hbpn24dr0MLAPsxL6YwRBWFCUknPtgnHDau5ycXctUlS\n"
  "zjLi32GfA3FQKnMUp5tJs5hjbeNAUld7Hi3Lu2z6MRc=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 -1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 AO4AMaoDJC3BCSY9WGz/MuOx9IO1jZwEuTM/PTacIB3Q2+6MR+mnuaWDh7fB+IgyGeBgo1s4ScccosxHDBH3Bw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "LkLZaaP2n1OwlzJZ93jWCO1qegtUqLCh1TyHhpb/PzREJsfsqWATfl14TK+Bhytu\n"
  "H2xDuGFCejTWH1+g+rh7Fkd33W3SirppNpr9Q7s5Sj8fA51HAWk7nYArSiWYmwBR\n"
  "ITqgfNVhi192LE2mkgFJeP7SDBcs3dYXTu/nbpwXtXM=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_NTOR_KEY[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAeHEwGvEQ6Q0Q4feihyajToFJ/tJdYb7X0U6LJX83+x4AQAgBABfIsFo\n"
  "zK+xiF5YqrRX9jIluwrJqUXcnRBc6jzzEnMIXCFIlaXAHlR7FtlVjhoUy+pClNul\n"
  "WcT+JjHbzUwXwAtqhV/tDhLAHk+Ay1vwH1pVlqDBC6UYE1WnAfzUGdGz9AE=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKScAJYuwEgWW/u1K9zpBmTcM2/iwH1yfdQ3MgAcLEGTukHyMb0FJ8GI\n"
  "zetrQJn0mBY+W/Hb4xylMMz2GL9pgsmGjKxDLcW9at9rA5FXunCEvRkfCvJhhSzS\n"
  "KDbtTM0030k6uvSo1MQKt1zrntdUXkCDZYl8+yDewb3MfNgOCNZNAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 XyLBaMyvsYheWKq0V/YyJbsKyalF3J0QXOo88xJzCFw=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMpVLmZCeEHM7aRPjxGrcYYTlm2YmFVYkQCMealSBwoP/zMEPnLXODPx\n"
  "vNx0syUAKg9WraLRoVoTNgHQvPWJCIHULthD61O+S966zItMUoWjD3lfrwZRkA2S\n"
  "NDvzxUAuxhqS01zfoXGw9jq058b4yhGxdkeloz/6ctIf78dCbfC3AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key xjiodE8eCJMDycIoosVW5OnhmvEDSn3zQ9uFSpVnI7RI=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAV8iwWjMr7GIXliqtFf2MiW7CsmpRdydEFzqPPMScwhcANqd8l+sKSqF\n"
  "jfzw43nwQ24k+ktkImehYV443lPygB45J9hfk1Frtf73sdnb3r/Oq3nFfkqTHiZA\n"
  "vfpkxWg3qgM=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "t3ByKPtpGpveOkZI5ArpxDsdjmRbo+vdmqGmDOdUzGEQ7xLZ4tfsul/yvkKNX9WT\n"
  "f40zkn1kOpEkiNRhpJT1z33yUeGO4Sps8oezTf9mQJCccsTyZ8Jj49V1VSZ2jrAw\n"
  "J3GJNoqr1lO68HvCA5avXKb8M+uUlB1zoimkTyq14Tg=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 r73EDnNHPxOwmwTR4mcoeM0/P51/WmFnvW/oLzgaR+Cjx1QObZEKO45xqB+QatM0IQ+7H23R2m6cD0iTi6GzDQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "SpSRg72z5U5RUIVQymJNyufSYH3RZPdlGweBzUypnaU4+iBum7IB69M2VPE4bchK\n"
  "EObhVkqTisg6utm6h9HyDUgpgtAIS25IfeRhb713RNdJYeD1KW5KBcmdI5g/eoCB\n"
  "4N8XrU4+xI6B6chj8I2GiYCMCT7gWFOqAIoJlOJN/UY=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_FINGERPRINT[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQARuzNoxmRJWC5XJHiZrz6JnjmLqWZdGCf7gxcyDanXhqAQAgBAC96/co\n"
  "YtwP7WOha/PdIPmAj9uCv7vl/GtDI7SYowz/i0AqWXGk1T/GIGeSJZ3uSWq9u3tP\n"
  "ytPSnJvmqj6wMkGLQ7oZsi3G1DTuh/gU4fY3aIAQcm6LEestgnI6RkQF1gY=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAOhMzS1rZAYB2AZpV9VvAF3twjoMaKuwscP0Z2eFih5/WhUWBSlq0ik7\n"
  "4XgTYXS1EtV2GjgCE3aIdElr1eBar4+cz58jKssZH5FFWDzPmEN4g6qzifIbsvXk\n"
  "MeAF1u6wCr/TDJ7srCSp4EL/f6V2y0uC951Z24wKGnRZadBQlmo/AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 vev3KGLcD+1joWvz3SD5gI/bgr+75fxrQyO0mKMM/4s=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALdUFqqQlTglmEhthhBDk4ZYeG6NA08jemECh1Eusl+cgiQzvD9nMwdC\n"
  "euE8OTZkDa2CxlhCdUNV0D67X4hp5C77uJzLGL1LHUeQQaNIkJeMP9A1iZpHcpki\n"
  "Q9iN/XEMiDK5z42IGc40cimSU1SDCgKquDg+mLyUmQzpo/9GzRvVAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key e7xFX5txUS4DxZsux+D2Pz7YGIy60IfBCsxqgSbcCTg=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAb3r9yhi3A/tY6Fr890g+YCP24K/u+X8a0MjtJijDP+LAH5UAsebB7YK\n"
  "McQQD2Kt1QtPfkIClLENUG410z6SwWNU1A1p7nJQ0AcCUrsM/5gZfwPzaoEfFZWJ\n"
  "dmRHtqF/4As=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "DO+sLD0Q6Ls39UplbwmIP1kqrYPdUTO1ydHtdEl22+nXbzQ+vIEaMprv77fbOkJS\n"
  "adq3HQ7WDJ+ESxYyvnOn0rxCv/P4zENgbWE4s10uMWQ5Oqirwlk6peNou9MZ8Re1\n"
  "1VChxzgerdCJcOOvTW7CCR/7A4QKnn8zu38cT51ncO4=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "fingerprint 5555\n"
  "reject *:*\n"
  "router-sig-ed25519 lF577k8aob8csasyKZnvyyfbBze3dgO5QhHRrUCDEoE5bFLRLs50RLwWSn9wNiuOc8tFOFvXqT9o/Y0rziEWCg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "S4yw7hIs9NHODCiTFcSh4YpYHbG4XP3rq9YyJgUG+uWen18N904p+4iQwGh+Ye3T\n"
  "cHl++4ZkXajAuSm4ZT784/SserPJmxxZroeSMVcdBgGdngOq62kVtfqBRyFDUtBU\n"
  "CvCb6eHRB+BoKHWcSSyr/abEqO+AfjjWRVEsd7B4PT8=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_MISMATCHED_FINGERPRINT[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAblHLIIIJbgQ7K3DMC/bztGu14OqVAr9A/sTA3/eethrAQAgBACvXlt6\n"
  "ONBSjN/eXPqM26//TBLhJ880ueBSi2sw+UBpUXqJJsJcW/nChhopJvXkM2LAMF2Q\n"
  "fnXee5XVoAO50gMaDU7vvh9GVnuAiV4coKDzmDyKVYnGN5CdCk0zj9LlegI=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKNE/KxjoKl5AIVfvGBm2o863+0/NS3DZsEo0nKaO2n4ZDeAjwezHYl2\n"
  "HVCod3XUGRrYs4pAz0x7QYcWrI+v1RSy9JqouZeZsCI06lB/4tedve7hUN6nh+9r\n"
  "AmxK/9RF7O2dosFWTss8ZdK7zYiNTOVcu9nrzpZCsx62TJl48l4VAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 r15bejjQUozf3lz6jNuv/0wS4SfPNLngUotrMPlAaVE=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAJbj7YfrDjilYtStM+ujxajNuayX+IUE2ZXBn4ZD37BAVXSdnoDBnV2q\n"
  "TMyelhaQlPHHlJKhDnU6l9IJhMYS81rHcavShnbq6xRk/MyIYT5m9a8e9zGjpFOu\n"
  "++tnFR3CO9QM3PL2gKln9Ta+yRbFJ1Dut6Nx5BOsKQsQwU9Hekl9AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key z3SSwtgbp0wv2AUpqmoRh+r0Ebc4DNy8s0nO9v/IDRQ=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAa9eW3o40FKM395c+ozbr/9MEuEnzzS54FKLazD5QGlRAImd//fC+Kly\n"
  "EP8g9NhXLgNwyYMPv4AVK/IHBodacLoBibzr3tjOEryYVjp5GMjdV31FM48yUMEP\n"
  "684oirlXMwo=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "iPAp07r37ZfIGSVkunV7GbD4wUg9YTzkfZqqK6v/k+PktFD3ymFMm17xSWB+iDBZ\n"
  "kPHuPL7n00fARbs7hZxmxB+Z8VV8aIU2o4Tnh91NHVxd1WIfrqNIwKUIXt821Qc/\n"
  "fhotsrR6u1NGcqHiUZLOq7DFCtX4xvTMXDnQA2Y3F1Q=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "fingerprint CC43 DC8E 8C9E 3E6D 59CD 0399 2491 0C8C E1E4 50D2\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 I1vjiJ3q04pz1mO5zxsoy3ng4y3Ix6YxNEUaO7O83kOiU+VvGmaO+fzlXkTMuAz30BFm75Yckpeiqodak+F7Dg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "NRlkV2yLpVDu9fppAPrOyw6rcNvcDjATuZbiwL13KR9NOKFZtF9KQ+qSme4Y8Hcg\n"
  "hjlVuRiShZPmjq3n6iktNRryn1+ziVrjr6WQQBZyd0HuJ86PAUW8LOC7bI18AzT7\n"
  "fibS1unSsKBzcFjuP5Uz/ZGABG6lhbgvoleRbAFbd4s=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_HAS_ACCEPT6[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQATlCWYR3MJXT0ttJyn6HikvWxiw1QlFMUv6P9aVNxSeoAQAgBADrOgV7\n"
  "plvP37tRpQENPGYV8J0+hJAK5YcnEtfnPFSIf2TimQb9VZZ4Zcn/7WLIsAkWP7lu\n"
  "BPY5GC8YPPz5kaHDkrsX7LExapYw0KrrLrHHOf3DWuNayjzRfkPFOIitIAI=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANEcIzy+Sq/G43SLJDO9cVZWUC9aPR6VX+C3A7nToJgl7eqRuI9EWdLc\n"
  "ORZTRoLWfEeu9ciJpjfOdIt45Sz23lZ1ZULRQEOrgZ4rXMolSdVYMKPKuldvj6fz\n"
  "t4QRUdkVGISNn7lVmdF6Dti6NNMdS0H+vFM4C6OK7qc1WY2qD3NlAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 6zoFe6Zbz9+7UaUBDTxmFfCdPoSQCuWHJxLX5zxUiH8=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAOChxY+BMY6iajCYdjz3My8oqJw++gvhnH3aQk+a+pmXO5dFnSeWnnxU\n"
  "7kue4Kc/F9C5ZLdArObXegUYE7nge3Sss0gxlNj8E1eItCkh5mDXKxj4wGoYFxqi\n"
  "tMuJIcMSkz6mt9iOIC/33AcFLHCH2fEPL9lNqKZw324+2B/HwBkZAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key oOTk28yuw1rfN9ieyNcjsR41nmWZ3sMl7WAq/8rIyWU=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAes6BXumW8/fu1GlAQ08ZhXwnT6EkArlhycS1+c8VIh/AFfG1jFn0GEz\n"
  "Izr4UdQrqbSIW4GnGZt/cWF+5GgrFqVLKjLQn0qL59+RcI5uL8t4HYMeX7DDW05D\n"
  "kFEyCR0K3QM=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "WiHEajyWxVHtfGW2zk1P/oiayJ71SooJ5h8VTJvt3Ll6EwTk0OLKrT+WHfnKyIsx\n"
  "Zc0ocAD/fB89k8aD9doEbyGhtxYOnbHzm+Bu/HBpHcsom3sJ8V5dAG7T0SsA2e7j\n"
  "/nUR/px6AhyLRVTPCwHJffU7BgCBpZR5qpxwE6iFJec=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "accept6 *:80\n"
  "reject6 *:*\n"
  "router-sig-ed25519 UPASGxdHFoEI9MK012Ip83qfdYAAAaaDpr/2xn4dDozCGisojWJ1Cdv5HDLpXRsdcjkvOjg48XQHMiFQHLWEDg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "m+JqBjl516GHFnz/BMCX2Fc3vJkZxcstqa1+QScfj+hagYlW97SyUSTlGrNJcP0R\n"
  "F6ZP5p8DFRoyMPLUsHv3cXodSCmmlGYZLctIAlAwNPyvjx8K4viE4/ImEemoKWzd\n"
  "D1ylziMbpPYQ//9w3a5zNrOuigFGKyQJdtc4eKbMkQM=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_NO_EXIT_POLICY[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQATYAnLUERikTHIW5W60T/eDjs/+G8GViekaCOpm7O5oAAQAgBADvnTrF\n"
  "bsB6EXhry4mELlXb0xIK+zDsMniuXXOs3dZhondVXKfc/6XyytBWFt3V2323aYwg\n"
  "W1uRiwqrqdbGGCelO6Vfp02HtSKOUELhzb3XRfJjrTTOf/ov0TFKqZq4oAo=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKKGX1tx5+kYDoBULSeIl8Yj+bfOwoQACHT/S/W9Mt3OKcfrjjaUxxoY\n"
  "TYu9W4m0CbVOmTcNnB/StDwub+fhFgg/jf8dUywFuzl8Dv0+Elvd6rhr8sQO6UWm\n"
  "nUpZL4yvOVehl5pcY9lIUYX8SE6akUCLo6S1mJ1/aUnNK6i9TxSrAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 7506xW7AehF4a8uJhC5V29MSCvsw7DJ4rl1zrN3WYaI=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANM184uIu8XUgWZBARcAOJSZ9UxN2aecqJ0QcicJ/OSt1GDrxrmIuvCh\n"
  "+lGA2dT1uqGVJrrSKMQoBYsvJXK1gMFwvhl9pjg4LGkXLS3CUJffjwSxRJ2wF8Ga\n"
  "yVC8SLWJqFPE7/ReWLES5Qx8/LqpJwIORwQbJc9r2g325U07HYGLAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key jQrLewVdDUe3MvTdLNB9H2Is2mhQx+TCOlbIdDyxTlQ=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAe+dOsVuwHoReGvLiYQuVdvTEgr7MOwyeK5dc6zd1mGiALA5bpkro0Qh\n"
  "9tV7U1Ym6Pngmgs/Tx8yUzwGIoefT4A1L14yYokNBBe9DQ207rA5y9u9WnuT5mZH\n"
  "2mcZOMGzywM=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "WC79UXdGUGKTPFfB7Oz4qtk5uytmNA5XoCH4w9cpKOUBxG5Fc9Dol58STLr/AWoS\n"
  "A9Gfx2zN5MoOyv34z2UlUV5Kp75zT8emxun47SqKv+lqRqRTtHrFavOkO0LbSRH3\n"
  "bxYDdx/HmQnz48vQyK+VLm8lowsxCjgIBVmTKs93t3c=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "router-sig-ed25519 DA5Fd5XeIyZWetlWbLRKUPBZ6MLW16/C3/m42sSMV5ya4MRMIql9keH/m7apzd6F8UqHztuHnFpgfOXwyN3OCQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "aGvBliAHSDUmrFcHMLuEKQVFY+zr6oYKgJjBe2G0j3Xcw9VpwSpZkgmZa5jJI0br\n"
  "HJwA0sd8NhzGuP9oCLbRI6pdT5l8TDCM+zM/G93Sz3cgxATj2bxDTg9/B4HNObCn\n"
  "1VufCazt1ild43svRJa2bLsqWKTRHKA8LGKmwYsvlWI=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_IPV6_EXIT_POLICY[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAUGR5G6d4pKIbn8TsRPUlzF3aG+bGlSRq5CmgY3FHvXCAQAgBADHVYAg\n"
  "VsnLCsUgF4yKxR8mDyeVRASJ6Lan1xwA49u0MrcvHJDohop1C2fRi6npUKM+G80J\n"
  "vebsEbexWjnaWURBrwx6YvvF22lw5TEc6dm8KxhGNOWSBFukr3tWJpn6ogA=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMebdGK2Ac/1eewX+boQNlZA+msq7kCqqS3FM8GRBrCZGm4MFCx6bDZT\n"
  "sMWjOqN3FGPjN49I4GYlgkqlcvgaKFB/DGbXOn7X1W8fa0qzKK7okK9qtHMAjINg\n"
  "RjZ4aHWmeGhsVpGD1ifEEofWWjx7/T8dx7XIvNdu2zgKVjuySdGrAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 x1WAIFbJywrFIBeMisUfJg8nlUQEiei2p9ccAOPbtDI=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAOFfyR3mbBZMu85gSrw/VBofkCmp8CwKU68pEWc3SL29c6LjV9LCXrDZ\n"
  "08jUZ1RRHR8hYeLaz3ZxLhOQ50JYw55w6YhLbfzZS5+xt7gay6M2iFjj6vH8QPqc\n"
  "T1zFNy0DAYID6u2AcvTGrRdRPv9NBs64wf2fJAGWUXNPQMlCIjKtAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key 43r7FnWu5hrjSRXEIEGIOsja18U1+5/zMUDWqOlKSRc=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAcdVgCBWycsKxSAXjIrFHyYPJ5VEBInotqfXHADj27QyAFEDwHRfJikw\n"
  "3q2nD4w+XXQg5kk4g+pKuFaVSIbO1Xem9F2Hd+0JgiLlDSuAgLeUKiZIqGAm2Cil\n"
  "vDw1Z+8kHAA=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "LVjbq3IyLJSQ09ywgtPZ11ddpq6Mbldd7CsX7VAE66ihd5LMJmEVuugilHZqIvQW\n"
  "JeXJylZWvqbwFEy4DDZCTZBh9aXUouZEIm3jNxyWDu5LKs9M/cKZTXcleWiipDue\n"
  "yS72i2K2l9zPY+YoNMElc9TlC+lrOlpaT+fwR+93cWo=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "ipv6-policy kfdslfdfj sdjfk sdfjsdf\n"
  "router-sig-ed25519 T9pQHeYGU9voVeSoywCtL62Ep2EyYSO7DWjwVOkLxQccAyBa3NS1sBaEVEPXyDtnXeZQUL2hCDy4kEulLimnDQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "HDzaU7OdsTuFtjmHwqXkJ/+DCkTyz1vzd39F5L1x2dDZHqk0DJNHy5E6jWpN4yqF\n"
  "m3nvoKS2II8r06NX7gloF67lfwTtEVc11HZWqyuzAQPZZj2VlPGH/vbTA1NL8MjM\n"
  "Qn7yzykq8Ry+mLVJ4b1vtZOHm67K4q3V3pSBG5AKO68=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_BAD_FAMILY[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAURbCqkJspCMD7ju6hc5A5b+nTEaKJ+Pay1TpF7nYZXhAQAgBADzX5sn\n"
  "pjOeXa3eX/C9pVLjwtq5VRddbd7lf0JNlZ1ad3wtO0l5ETftHyU6QoA4g1ZU6itY\n"
  "IQVLmIdvHo4nXMvUDPWvzEMZiD1epyNnVHglyJXMzC5dzUteE/Jdb0wx8gU=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMIwbAgXUtGKe8W2wsaJPqFz2cCaRZy+1ZHEpyMWSN69UDdl+QTEI5qI\n"
  "W52+bXLXOCQOPLaFtSmfv6i09pPlb9XcyZCfI3W/01KgpKDWFji4QACK7BQCCxaZ\n"
  "avKwo8eN0XSL5ihcPSZvSMFjX3AdAMLdtYdQVNpCg80NjmfHK1FfAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 81+bJ6Yznl2t3l/wvaVS48LauVUXXW3e5X9CTZWdWnc=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALNX/+fYN5lj6v7UqrK+URDxRBPnrMGCv79WZ7lfSc1yaxFPWqAG/OD1\n"
  "X7Voqb5xhr5bsszliBe2m0DfOTOPTQ91SyjUoPEXznfHYkbwGVRhNKNa2eN7E1Sl\n"
  "xw2iSoCnZEpKSaQsLvHvIaYiWnhvHtRl7QCuAym1I1hPPw+BTnkrAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key XjO8+6SaRrPblN+i3FftAlAR1SAij1e/Tlj6x2L6T3U=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAfNfmyemM55drd5f8L2lUuPC2rlVF11t3uV/Qk2VnVp3AFoeOhW877qn\n"
  "nmT9epNCicfIcyEynHC2865A0htIKT1CCRA6MFNnCMPIs9TpYU0G1zyrvdObtPsm\n"
  "w+QHaRhFuwg=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "q0Pp+duh37vyrIjY1gW+16ueGRoXOmFwILm9Eq/6zQedtnUrReTS4CqtkRvMTJp6\n"
  "JeOOHWD4mcYdoC31NxaYhr/E7aafE/rzRZk0b5H5RgtixVdsrUUcFyWXLsYP+koC\n"
  "pTk9g3nsOfQCF3u/p0nspsogkZd8qq4fLqyJDK4qh2s=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "family aaaa,bbbb\n"
  "reject *:*\n"
  "router-sig-ed25519 h4sKEoqV2V/jvbP+AM8dEW7gyXWzMi5u680qa0k4VvgDwj8mkQG7NYguy2O5ovZX5wTE81b9pjNmR7Fx4Wm+Bw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "qEFvYELbbiKjTnXxmbYZDHdeEDIAJrIhxbgLfTFKI6LlOQ+sy5XGd+fCU365U6Mu\n"
  "0jOej6XL1XQaHE1tFhviGj1pNLlaKL3xK/VDLNhjJSR20adtOQo7UX5NutWhQdSv\n"
  "L8k5Kqc43XXhqQrMC2nKdFAF43mcp3MesBAnkJVFBqw=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ZERO_ORPORT[] =
  "router fred 127.0.0.1 0 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAUmwuikZ7vHosMBCYuyHaTxtFLZstIlPgiR7CYZNyfC6AQAgBABYaoui\n"
  "ahSEC4liv03C91ZzmpKPUy09X9nOUYgRtb+rsJ6/GklBLyC1pX7YGiCbUfnRcIXE\n"
  "PRaFkYvku9qdIvj8Zxf+dxPLOQbuNbR7Ky2oLVgLJnC65N5tzoqcN7axWgY=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALbQl2VvUsDYFiqLWZdJI5w44z8mmtrDyYC2in84CI7NmBqrqODyVDDV\n"
  "xU7ZJtIfzmBFiN+oxl3Xja+p2UeZ2qhaPxNwBvpkj3uLoyqjrzxRvzrXOILxrJq0\n"
  "zsVU6F9J4PD8khEK472XsnEwmY5wK1cVNm/n6eodGppqQbjMal6XAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 WGqLomoUhAuJYr9NwvdWc5qSj1MtPV/ZzlGIEbW/q7A=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAJ71N74R9kO7XgyH0CH2Z4qtr2YKwu+U4FCgBZozMoBe+vcynzNNXRMR\n"
  "UOKl+hD5nl6CjDO+1Q36iUJPu873CzZv6SXsICnMIkFx/nrMD8JGEiqupjj8H4SS\n"
  "t3hRhlU6pStjwhqqJozUVinJ+CKCwHG9UnUBGiPNRAwAPU+2VVcHAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key 6qko2boqKfkcENCGbCSZ1RbZN3TY2AFqo5WMFnwioC8=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAVhqi6JqFIQLiWK/TcL3VnOako9TLT1f2c5RiBG1v6uwAIB8Iig7LEAU\n"
  "CcznIarqADUWZK/MjxQZHoCdVmb3DlVZ86BWnulrjUnFPINqBRsM1m7a92AHJI28\n"
  "SdQ+PEw5VAs=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "VAzikUKMdtT0ejXQ9XjA0IFKYyJK3LUpwYRx5jHupvpM9pMww1UpVORwEySOuu/l\n"
  "iWy+YT2BJ1T1gybHO/BUbMUOCJs746wKaRu1TNoa0iB5hBS08eZHsLcuMPWNj4HZ\n"
  "8ul4kp0JL6s3SwCyHPx+3ZiXWlAlyixIMwYMYp3iUwA=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 wYbZMmEuVaKbcQVwPDuNfqoowIUQB2AXmLhuZn7x7c7Le1K6GJvGxUP51xamZNJtPZpb3B2hY0Q8x+gk5JI9CA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "tiwHHQTe0A/QpY6oom3lG7CbFvTtd9KfAyHN8kZAxo/mctogQw3ZBZbUFZWhrQhl\n"
  "L57BcL/UgaAAtl7eD3X/91uaoEZl/avxlmvgTEg59aQnBzhAkhj/ZYOjQqTTlfWS\n"
  "fv8wOQgiuJSKTBBY2LZAJyMDj0oI7PK2JYBtnUvi27A=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_MISSING_CROSSCERT[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAbLkl65prybuOHnQxRi+wVzjNlEsViHPH/T6RWQHtNaIAQAgBAAEVy+i\n"
  "zeBNENBHHpiag6H+8XDe77msq4YHvxeycWRuJjjNnEcLLQMbtnNFmgzKWwGT2uPj\n"
  "+U3Z9Rg0+PRkXHKnJKZJLYrglWHjQdiFELn8opGTNX3rkd/FdU9Ws/Fliws=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANyNH7TLjpmgV1TTkT716iNp9tpZHwDHoYWduoiZntmDHpRN4rp0AdhD\n"
  "LQ5/JEdW/XjAhcnynzINgvGw1nK2XiC/UdTv/Gx6/6Nt9Izn7oAT5YRUOOUaBDYm\n"
  "9Q8uNo8d/4FrXDEsxaMJme88v2Z6LJd8FozBwlkfeTKdOJon6IabAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 BFcvos3gTRDQRx6YmoOh/vFw3u+5rKuGB78XsnFkbiY=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKT6X+Qm7moNEV7o0oAcrbzpOa0UyOkqWxQkfijqcMbreuMXvfLyBB9l\n"
  "dgttee0cf0LmWWv9nBtwlbQNgFzkOwcvPRQZ2e1AiFsk/bFlQ5Ow9nxRJoUboL/r\n"
  "9VCaflE+ETtV+fTl5R1sn3j3OsxK8SOhOl5s+6OAisp3wEaVhjVTAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key DqsbD32Vw56RVM6+gdrE3x0b3DqBsuMsbwOpzYPSB2k=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAQRXL6LN4E0Q0EcemJqDof7xcN7vuayrhge/F7JxZG4mAHlxXgoRkCMR\n"
  "QRUsroTKgpVFI6FasFLpfbn1PNzhBwrA0x2Jf5VftmgraI40+oLxL9SiMGzakBfJ\n"
  "FRXjeMEk2AU=\n"
  "-----END ED25519 CERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 Dxt546uUdpCxCbO21HaaA6JtW70Xsx5evw9l2eVlWpGDzCTfGO4cMlIUku4ABQdrT6wk3Er9qL5paNyhrYjfBQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "ik0LYc81zprhK5GN0SxE1ikzF+sAzCjo2vhFsihljOyg3d9XxhbriTpROJeUe8Ig\n"
  "PpgLPeJxPFOvs5jC2XeTAOpxdYyMqC7d/RfupG2v9qBzcj9a84p+tOP1DZKg9snn\n"
  "NZS6fGWijh+okwRlvbFPk9e4Z6gJUSLthTUhz6P8/LA=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_MISSING_CROSSCERT2[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAXpNZkKl/K3IRSQvhjsdeSGChzvAux17KOfhfmTGqNXIAQAgBADG8kM5\n"
  "+9iJxF/Hf2jvvpiZddN8V4RPcJH5i3tIsekmwsaoy3FMnMisGFsOFUjxtSRLmAM5\n"
  "EtGNJayNNny0qDRo6o/LxmXhl7fVxQPnyFEPjSn93cLWVV6/0LjYaYHUsAo=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALJTSfgKFoMA5o4dDduwgwHfjU2KE3rZ430TGK9xhBFrum2wG8ct4my7\n"
  "LS/EbTtxhQjNSrW3D1loThQH7H//cjjrtZyFs4cKwIimpnkRWpQzDtjSUF9vwAGZ\n"
  "nUPuStPG/hBvJROVUmHV15nAgi+bWigEtXrNCPlpGaojBBIqDRAjAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 xvJDOfvYicRfx39o776YmXXTfFeET3CR+Yt7SLHpJsI=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMXYiBXNlbvmWAM3tVe2fC7fazqaQzsXLH39QRhPE2DyldBdsmf8anc9\n"
  "0rbY8uS/O5WNqc0KK0wivSt8zDLxfkw9GFM3WKgvdiqvRkmpOs5GDvzRdM/yGRNc\n"
  "gCUBe9q/pE6LQJqoWx6cCcLKGG9Ga8c4WB0ttpiVc3cfoFXEz1RbAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key N+jVTn3dmb40NOrpkFGvGTskcX6mGPp7uruGdhIlMXk=\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "Cnbs898bRLOgjytkt2bzfJmewumRwscGqXDMG10y9QtU+MuZuTl+Mv0w/GmlJG0v\n"
  "H8ECNQhv642hJOBOuiS1huF4dW2lEhFm+xh0LaxaGFFvJRtuH6NfWDmI1bhN5zbK\n"
  "RqKeu6QamghmtcwiEym4M1fPPkGbOY2nwJhhEEZOQCg=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 nZA7TcgGlFa64ZViIMqIVNP3d9C6XGY+5so6Ll2Yeu31N6MdIbwrYL99nfCkfwyD2islcHl0kp45c3ZZrkmQDg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "gD19cH/jeIsTBAjds6FflLMXw++Ix9MoWEfFDPAxbD07rdjtU9x6Z9smDAUG29/v\n"
  "bWvaQPz7mD62IVu/IxINEVOS7vGrSbgvFKzUm9a3FJiQf8oWfHrNE2PNPAZ8GCgF\n"
  "sdyo0rXyPgMkuW5ZtxDxejaybzVBkIbpADFkJI3B210=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_MISSING_CROSSCERT_SIGN[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAY4Q/FgXCRTVdPYd+7V5rMNtz2yUwCCUHXzduBIWfmbjAQAgBADwQyw5\n"
  "OWRsl2fz/uGjbzBhT/2AqRNTZCZ1oIR/Lf8ZhY/JbQRCrYwMqMfJz6AHaOJ+gYE9\n"
  "Z/ooJfYDXMkhBufAy6pgq5HQKKPY9f4drPGrcspQSilJYNsc7xdaPKHfAwk=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMk3FKSQ9eH4MipJoEzJ8ts3ujO8ed1YutjfFuRZVI658MX1ra9wZdjs\n"
  "bKfICz0CoT3uJMs5QesGh75r1iXZuFcLq6+WJq/kzI2cIhdDRMQsP48kbKxhwI4C\n"
  "FkDtK8urxS7Qpq7R2OhLjJwwrN2BcWa8sIOVXZaSp8qxauE11OoVAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 8EMsOTlkbJdn8/7ho28wYU/9gKkTU2QmdaCEfy3/GYU=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMGSYXKAwFsZbEbRjiHyGoiiq6EdY0tW9hrmW1ma1nMaIoNbjpR1AVOh\n"
  "ItYigmRi9zwLZy1b/P9Q8dlazdafc0bb+TISwu+4Cd8BKa7Ca2B43JAR1i7StxpT\n"
  "DMw5/QqrFw7hiTrFN3K1RVH3ZDMyCD+KjjfQh0RM9ytf3ySniUDFAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key t1Ps5TqoFvAJxqCLMUcuoovr8Nq2AzwjDPB49Mi48SA=\n"
  "ntor-onion-key-crosscert\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAfBDLDk5ZGyXZ/P+4aNvMGFP/YCpE1NkJnWghH8t/xmFAIQzKPwLjOWJ\n"
  "VnP514SdbuwehSRrkUMxBSqDxzsDyC5pUCqJhrj3EuXDAMeW5Hz5ukuimdIJyvPu\n"
  "2cLXN/1Emg4=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "SaVwgM+jd1yrKldHqi8XalnXOplkBHFOn6AXtxDlCm4rnsb3Spt0006nErCDJJQn\n"
  "xWkcz3mF2g3Hdf6NeSvAkH13SfqZbHZXQeYVtQHrmIF7TEHL6KHVNJD8ZxIoe0xp\n"
  "IawxfHSj3FHheiVvXGamM/7fpWyoNvYP3cnZJv6zqCo=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 f/KOmiv/aPMOnY3S4sKQsnp08KBrQVCT443ehtvYtiTnaSuxUC5tYY4S4rbQaGjNRFNX1Befwi4OvJ3dLFTtCA\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "JtCuaAENvHhc1tLTI9kkUsRne/OlEeIgB6f+BqMIbxWDpmiw2SHTbYVx6TbKZ2wU\n"
  "qR3R7SvapeGUIfoVhvVEzxExYTRvFvF/ICDs5vve1aoWilrFstpXsMcL5tG5+ljm\n"
  "cGJ5PNsTJXrlOy7p/UEHyvgqWcMKxMRBjgMe6je5w7w=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_BAD_SIG1[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQARhWF2mKrRP75a4g/xPp+fAkIlyKgZa5rKIzGZJiABheAQAgBAB8rr8g\n"
  "E3MaKYmA93baIS0pvM2tjjeozZTQVzCrP2PykhNcs24ytb7LHgquweVH71Pk3Ltf\n"
  "Dvl/2MoSFelmOjq4ikrLjntVmnIO1a3aNpt8XmeqjrVg3pBlXqdLdloedQI=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMnGnWWnyF3uo3aFhiph4x2i6yjnHC6ssgDsDR1UA0dUZ7938LcOMPU/\n"
  "WWUQP50kRx3l7lWPRd3IBm8Xqkg5QFKIoB+0UmHp6jqpVv6p10EyJ7Am0SYcswre\n"
  "vIZzz6XLEAVeeKVBW5p53KrzIhi8cjbOIofUspcBlHX9omB6Va2nAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 fK6/IBNzGimJgPd22iEtKbzNrY43qM2U0Fcwqz9j8pI=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMy673ilZFIPOsfMdt1sNYFw9Na/UoOGH8peXmGp5gpFpkJSHamZpqGj\n"
  "8OdW+KVU2/WzS96fEQ01wC1IiXwcjUtrD6Ny2JKJPARxPADQ31hS67z7gDVjJe9Q\n"
  "vFzYBf5x3aBKjKHbFMUz7y4L1IeBYfb+F5RBg6yrDA6LsPKKhJdRAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key /7ar3nf3rOfiv8Ab01rqVT/ku2jiWZgHHMGW14GPhTs=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAXyuvyATcxopiYD3dtohLSm8za2ON6jNlNBXMKs/Y/KSAFcBPlSKXOxY\n"
  "F25sS5nNj58Z13bBW/WnQ7Dq0kYvS4o80iO4ds91ktwMZiiadfVu2az6tjNRb5+o\n"
  "iShsVStqfw8=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "TnfcFWCbg72d4tlGSFpe/FATTeRcJVF2R+c6/d86lyPwntkdF6eEJDesEFW2Leil\n"
  "CQP9eJMiBbaEXU7xcMn9irguQl211lZj3+G47XUFNlORU+HWAR5PNeXj6jSGK89Y\n"
  "SIduafU14iKNUy2fzAFZooem+OzzDwMKIxTUTiqItfg=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 4DSdPePrToNx3WQ+4GfFelB8IyHu5Z9vTbbLZ02vfYEsCF9QeaeHbYagY/yjdt+9e71jmfM+W5MfRQd8FJ1+Dg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "p0PBLzGrU5B4BIwcVcTiJCsSdnWcglG2urJuOSWh2tHx0lWIg5kPUX+WGMh/xarE\n"
  "0X7xQt6amBZxkL/d70RM222CHg4IwXhRAV1qotY9cBNDKS6nop1Pkx1HOCqmsldy\n"
  "VSmLG15Igt/y0aYvxPhVDfPUK1UmLH7eYKA7lKOCAbs=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_BAD_SIG2[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAWoTtIdIR0KUNFswr/4eaP/cjngCX15TLiYqCH9qtCSHAQAgBAATcxt4\n"
  "jNZlgrlMe5Ide4pmPN3MkpkrXFa9ZjIWjFZs/TC7Lg8D70xjvWo9l9GlIMUVcMYV\n"
  "fWvzlrzTByup2wz9etZfpP4BfuFXgPlQyTHyANTQlEMzlXnA28lD1y8DZg0=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAL3cADWgf3FVXZvBxRY9dkgCCSy9kcbk0bTbdvvhJSWHpaerpDFTrHou\n"
  "ELWhGyu5A5yxs9YvK76R6v3Gj/wB/mIhZCJSViTSoyZnBNb0szfJVVyf1/6iOeVH\n"
  "jtKj3B3kY/WzNVX246lVC2M47F/TmZ2n4TLE2avcnRQjAtULDQk/AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 E3MbeIzWZYK5THuSHXuKZjzdzJKZK1xWvWYyFoxWbP0=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAL0Gax09X2sIcIQrDw9mjLVeVHnXEhMteHZtadDkXZJMjdJJaurt55hw\n"
  "N01apm2qXB9nyUn5sShBadzygFTZzFHe1/MafUTAo7KUdJrpWZr8mBbxWFRBx0W/\n"
  "OE2Gm1LqIETkeolT+v8LW6VvMPLyexL6myQCGB6yfa6AQkWi335bAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key XI8YQWjxy6mxUIPwgS+ZP8GURSEw0r1IgbbOvYNLz2o=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQARNzG3iM1mWCuUx7kh17imY83cySmStcVr1mMhaMVmz9AN7rBobY682w\n"
  "ItzgJHnDFJv32kjQGc3eKRpZ851GsF/Jj7WXSnLa1oLaLmfFf5tgAKlA3Mi4jUzE\n"
  "JQCy7jvAygc=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "KxfRSdISHvFhJrKQX018NEb4rtZBZUgdrvaYWjazMkYz4o361wTOxD6lP3azblf9\n"
  "IqhiXydwCRA7Akye7+muib7JzxSm3wX5iJknRrt8DY141pViMaMvrwXEAqEFyB6b\n"
  "M/dYGQwUW2iYMkoQ6difHkDQihebE9lgl/WCmq4nRQs=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 XheVxa1Z1HTviM/peYPSAB04YBivv+4v6/HGZ/K4UbEhKTrjSLcvdLG80vP6Owv8676A5al43MLMprjGn7tF6Cg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "j9qheDodbn9NZ1S61hjo9aCdHQgRrOqlEYrCMDv8LsMQU1LK6UjmszRxh1q9Hu6V\n"
  "v7/qGUrsQLjg1Lfdw4qXQYmxTiWnleyncLnxn0Xd5I/S46SCsLoewgGN9uJ6gS/j\n"
  "UdOEhvT7ShgNSemx9SpRriMKKqTuTQxRmZynr5ibvvw=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_BAD_SIG3[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAVdvNBeuh/0X6D1QG7U4LBsMF66U4SuKDKplzNXLiKv7AQAgBADNUwKD\n"
  "ETv10GLuZWuupZtT6HAGZNIhMHvYd1gGyBaoy86fsINj4Vxi9YctBHudNk2P8VIn\n"
  "qFkmPvvSkJJaBgjVT638CvpTU3Bva4+8YTor4jpY3Ni6K9f9ALjg4U+UBQ8=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANws+5gBYCgJhS4fYgStezRe+Y9mfuvTKWub9ytiZIiaPjtC4cu6+wuP\n"
  "9bEQgiESx6GXL4L+CtcOSc8COFRPv1PxFXjkMKXfTAx57Rw8xc1qotWNshSUp7rL\n"
  "JxSjOuEHd/dctIebor9akKPypAwnJhqrq+bqf9/kGaHckxK/ask/AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 zVMCgxE79dBi7mVrrqWbU+hwBmTSITB72HdYBsgWqMs=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMD0OLUYVhMiZz7tpxztxNwMTj4dQU9l++rRTfb+7vVZ+KAIb/8rjiU1\n"
  "XXyV3AekijxQlOghj36lZBtethX8RyahsHmWyGqo1UmqCU1PtwfihdYuofvyI8Iu\n"
  "V89G6QilsCPy2rpgYmEkmHt68FwlMnTjPUiKI5dZUk5WKrxsTgsxAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key DTa03lDz0APjbwCJN864xaYSxbPbVulLoAZIC4M4wGE=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAc1TAoMRO/XQYu5la66lm1PocAZk0iEwe9h3WAbIFqjLABej8E/aUX6f\n"
  "2KFbmHFALYZCxszNCfg9HGQ+hfTjuTPONZ9yzudUoTTKq8MIMCD/5WKfzMJAHq/P\n"
  "qNQuVt/gGA8=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "syosw/6anYcwlNT5fGd1vCw9uFBUckIjGz3DmS1vVXzsTrdppcFotmzzYjV491xR\n"
  "q8AyGyLlVIIuXabVuE+94ZpzDLWs82NqWMiYPNSNW2ctSVu+AE/KYjJCCz0SIE8/\n"
  "bq40OQNQ6TNLWv1ubxZSDwcXrn4/VcV9IJrFjLpw2rA=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 lemondcustard\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "d6F2sfCgQmo60QBPGGLZvMvwxw1h6DOlJO5NR31lgBrkLjnbaMJEtA8fNWOX5zW0\n"
  "gXXrJlL0qlENGJUZeUFobxDOVzTA3dz92q97t/jqBu3pgjmyESesFFkAgqqAGjYh\n"
  "RxUxJCDlyrmduGnl5GkjOVkS6UDhzRSRc+csxyXXp7E=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_BAD_CROSSCERT1[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAdQYl0NSJKxsHa9dGLZVBp+MohQmFDGSYOxdAmmrPS79AQAgBAD17lds\n"
  "HKOpu0Y2u4RCynTWwgdA9YZWYgkB1GSeOzuy/8CaWrZvEg0iaZmsYIlgeujMxq/v\n"
  "WEFzug6zYefoz93cN13o3pzAKY05A+KMvWPUnmvSlMqwlbnhjt3EjYoW9QQ=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAMBQN6sno1t3m1izKZEoo63H5WrHfskJVor73sc7lDAo8BvQk110pIEd\n"
  "2SGaFS9BNIUe51u4y8X+rDi3qXt5I11ifusvI1S6CMaM0p+Xh4osQGuvb31COpU7\n"
  "MMOOxCVhmf2D/Vu1KuB+pNB91I7Id3BXRNdX7cuBCjdVEzdVZ9MTAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 9e5XbByjqbtGNruEQsp01sIHQPWGVmIJAdRknjs7sv8=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANK1iFyjGQGns3jmNpkO8t1f2RkWQTA9VS2xwbIZ0QE2QT3miu7ny3F5\n"
  "992sLvs/XJGRh0Wr8I06MTXYqu1aZdqF+ailw/WTWwsqkWZwwRni8zWGW20zJ4Wv\n"
  "2X5FmPQXQFVXb1pRmICIt94zQONE67xxfzG7pPs5IVl71WRFs6JnAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key ddfknkGy8CYAOi/IVWmQyBLb6hgY2KZSct8tCNRXzx0=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABf55AXL4pAregsMa2ovmTBGaMCyWz/4LpICgAAuWXtTvA1IfAKo6ANUq+hi+\n"
  "xb3J4aYafnszlj87oi/DR+SDf29wzwNw8gmaqGzJ5GbfISfABuTUCzlilZyVnLxi\n"
  "BHcCH6PWiAQ=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "zW3a26ATVWny3gEALe2VETRNIOFKMlRMCGjAKEyGQsGddSRYm08daaZkX7TzKRFq\n"
  "TwZAcQ4BzhwCcnQtb/zwMSW1eIdKgO1rqZLhdo/awUuRtuPeG0vPoqahIQH3X81r\n"
  "vh/Iy6f1xp3sfasib5AO8wZWhJ+LHaA1yt7DCfQBudU=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 hKynmNoTSZn+Au4mlsO+yWIvCn9g2SpITDdbKDAgdLQ8qXJRG/oxiKOlmGuhpz7Q4ETSChkfOab4II3GNhQWBg\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "X37fMViJCh6+AQbMIWW9y8XwHridRmgcW5vZT93357C1NRy4MkuJt5O7sZ9YWE9g\n"
  "8kKeeKRjXUfudbu00P/pmTKbLBucsPounK5uSpTs18FAed1p0wRDeM3KaddQsGjI\n"
  "WuJe8hOufwyUWdFBBLJhH1rsCLJlY5P2lC6Wgs5WyEE=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_MISPLACED1[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKh/VcmuyOszxrGZY8xIGAbQ7bXnSVf3iL+9RBKi3Lva0oN90zLYKfKt\n"
  "Z0hBB/lHukUeaUZhTNx8ASTcoFnTcMD8rw1XQbjVyTdPWrHNVhZEGAD8TmeOrjEP\n"
  "6/cLJTKxY2EAv/1Uli0F+mWInINRzdsa0EB9MbU9R1yr0YZMQZ8NAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQAWka/Nj7mht9fCo+vwXF59aGNWMDeuOhkcBq1m/WjG2vAQAgBABDDm8X\n"
  "xgMoftELU7Umgf44257ImjgG1okFpkTGOq+K489uFUre+q+Ikurp+4H7j9d6kCIA\n"
  "htYSDr1LfVBzxPttICRAX0cLg1rnIWRdB8TzXehF4/0hHAjtwkYKnPiVQQI=\n"
  "-----END ED25519 CERT-----\n"
  "master-key-ed25519 Qw5vF8YDKH7RC1O1JoH+ONueyJo4BtaJBaZExjqviuM=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAO9rHWfTdV5l8VtwNtwEDhd0BtmQpqxkXN0SV9pa6NLKeVMcROmlKL0u\n"
  "EmF5njuLZTDRJk48HaT3/anU4qUGiDxtIU2np+eFkrYyLvyiaGyc20ph4ffLVzbG\n"
  "VCSSkIVz4TYamplaBkY6yY+IBBk1u/klmeCBvgMhSIISxUklkxudAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key PKfyrBmRFyANA+2PZAXawdNZom3VF+Cfg9lKy2OjuWM=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAUMObxfGAyh+0QtTtSaB/jjbnsiaOAbWiQWmRMY6r4rjAJQykafOIJRQ\n"
  "ex8+e+xpwVpyJJOidTVW2bBWG0ZIi+4W5Dj9eFiuV9x2kPTy7ZFueNAWZ7NstyTr\n"
  "vLtNc5qRrg4=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "tqzgSiMy4U6J/yyYhg5hVIqO0vAgAwIMYPXWDRvAIomfnIpUCkHSIdyLD+7a4Yp3\n"
  "ZhXbLug85b6bK3pOTB2cLI9v2gwsgOyewUdt8prZLTOPDF3EDRD7UKCNMrQIIBw6\n"
  "kKwKIJVhAQKPi+gC2n7i07Y4zjGTaV4CiWe2h6E61lc=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 A1DMqknKoPrPRHr1Y1j8cd22Ziwcfl7b/3VKI4pthyLnFRpb768nlHi615YdwSve4L71d+c4vGMuKyeCcGbFDQ\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "KaOyGt84OBS8/83TQWKkfMLk/r/1ebWiA2Wkgda2cWx2L3Dh9V/3PDGwAWoG6m1r\n"
  "20mVuLKwWCCNYG2fGC4J/NMETXI5p5b1+ze1KDYiO5hQtTJvMktmfa5+p0xLB43M\n"
  "xjzpDoX0A37hP9XJa5d1Q7G2cnd64P70QqhToDtoswc=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_MISPLACED2[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQQABstQATjkYvZoN/RVHbJNtRWwmkazJVupqF/prNxdNJnRDWlDAQAgBADCNrLD\n"
  "VQBs6tkIMGcR0PB+jrCvIuiQGGJzLsIfvxrG5UXWZsFEA5CnF6Lvjqu6p1CRkUF4\n"
  "kpNC9xWcK8yDWhDCd5DLmFEDGFw/cD4rRACKatnQsGMN3KfDioWweSBI9wk=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAKdyNeuXJvnloOXD3iUxvvS7OBux3tpTfKxGdx124adeAKkiRL7EmXk3\n"
  "LaUbHL3IhsVaf6JeyRzc+onEsD/uNeO0P7+GtvC5ZAkj1/6MxBaJioLGXoIacMak\n"
  "NpmDYxhTcG75aEwgZX2RTla1j+5bIoG1o5Z76dkFMVUWsRtthFNRAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 wjayw1UAbOrZCDBnEdDwfo6wryLokBhicy7CH78axuU=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBANBQwXgkKvrnfMDKDkV5x1bxlR07x+AOru5ypJH4qQh+GMYXpnkw0T7r\n"
  "anIJtEFP0+FpbaRRI/xAPMpFUFsbeNH/+Yeove/6kKfv1rlgqWr/yI2XIW8Fl70i\n"
  "DW2cnW43cwa/HDitFjE5vnkvkMWFn1XIgwhm7+NDIDbnmDkKZ8U7AgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key CbrcCjCeTGum8vZumB6lvTA00BztRN8tNn41GLHdkUI=\n"
  "ntor-onion-key-crosscert 0\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAcI2ssNVAGzq2QgwZxHQ8H6OsK8i6JAYYnMuwh+/GsblANS8qpQqkLmw\n"
  "vcRttr/HvckIBY8i99OoqctPQziRUq2Up6Ag1b1MSgN3knRfi6wjmpz9Jn149kFx\n"
  "HQ8sTCSu+QI=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "DOH8ntVhHlms3NjkOvsCf5Qu1/DhHmJOL+J8ySD89lT2RBt0K07G9vAjc4NkkUpD\n"
  "N2e9myNWbDCp8sjsYzWfqpv94IypSBEfwQFgV6peoAZxHkq35Nj9sIJ+rQloanJJ\n"
  "RZkWyu1GILpggcNvWS6BYQQcRxu/lStLy917s24U7co=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "router-sig-ed25519 whWcVxkGo+l29Hsn+BLP96MReHTxQHTSgmMMzeQ4jZ0qV6B9kkj1Ma21oyl3iTmUCOtexgOiX5fImfMLkOxFDQ\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "py73sIYGI4awS9g4JFTSElHCg5pWYqEjLz/jbON7pZ80GGUG5wxXVxNRwtGvMrWk\n"
  "zG2tW7SBm0TH6wdWeE5NhN1VSjgCqw7qSk2MJS2XHn5hBRTxzF4/Es/TJaziAqvY\n"
  "e8ehZwqDPcG0vMhd97/uxoyKNdkyObhW+RNYRtGvCxg=\n"
  "-----END SIGNATURE-----\n"
  ;
static const char EX_RI_ED_BAD_CERT1[] =
  "router fred 127.0.0.1 9001 0 9002\n"
  "identity-ed25519\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABf55AYf+rX8a5rzdTBGPvLdQIP8XcElDDQnJIruGqfDTj+tjAP+3XOL2UTmn\n"
  "Hu39PbLZV+m9DIj/DvG38M0hP4MmHUjP/iZG5PaCX6/aMe+nQSNuTl0IDGpIo1l8\n"
  "dZToQTFSzAQ=\n"
  "-----END ED25519 CERT-----\n"
  "signing-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBALkr+jsRorIXiOA6obO6OLPitE/d+OzWz1SH6CHRs0m5KL+T6M9t0qqK\n"
  "O2BTOmrjPTaGdEsakkcfiZeSj02MviuSadZ/JF8FoAYx9yCbmlAh/FE3qvoY1lrE\n"
  "mAZhA2sTc32sHusQNBKRFfGHeckaE0i9MW7L+Crq2dLcwI/YZEldAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "master-key-ed25519 brKx2WhJlN4ExqUOr6CTx20MX57JkAetrrTwpt1cEt8=\n"
  "onion-key\n"
  "-----BEGIN RSA PUBLIC KEY-----\n"
  "MIGJAoGBAM8kNdNCiheKwYmN+wA+/aCLtr1aRJtoYggQPGT3rhm8m2bOhxixjdCD\n"
  "jiDkqfYjnaNizNnwpS47h1MWHzgTWKF/QS4JXvCG5M56KDJot2z03qbdoRUv5+Z9\n"
  "yQIx6ad1p2Km24P4IHmAYItwFBGir7y86C6mOdX4Sp139hDJOIsZAgMBAAE=\n"
  "-----END RSA PUBLIC KEY-----\n"
  "ntor-onion-key AP9U8b/4WUiOB899TlNgoYrnUdUqrwQYLgF0Smsj8E0=\n"
  "ntor-onion-key-crosscert 1\n"
  "-----BEGIN ED25519 CERT-----\n"
  "AQoABstQAW6ysdloSZTeBMalDq+gk8dtDF+eyZAHra608KbdXBLfAKPMVgkcGgA4\n"
  "8B+Bu8/lk14zBtzryJKvwg8UVOVd0tPnX7GiVyPmDCPbEZPnHG3Yvq+ir6HkiZAO\n"
  "mirgIIhkPwI=\n"
  "-----END ED25519 CERT-----\n"
  "onion-key-crosscert\n"
  "-----BEGIN CROSSCERT-----\n"
  "GnUJtlnkqHZKQAzwNPgAesR1R7hebqY/hMIKj9s/y+PxGgs+aNP2gfv4W+dtQ209\n"
  "jHGxF+n6s2hm3Am0EFQ2h1ULTJh9uYnIs1f1kyx8DdydXdx3pZcURLRenmiRowB7\n"
  "iGn76ICqqGVZKpGtszmSe3L35XXl7HwzJTjYzcs95vo=\n"
  "-----END CROSSCERT-----\n"
  "published 2014-10-05 12:00:00\n"
  "bandwidth 1000 1000 1000\n"
  "proto Link=5\n"
  "reject *:*\n"
  "router-sig-ed25519 RqA4oirneie/ywl6j99vc2B1mUlMfIlakR7M6M4Minf7x6t7EMOsNVvOMKBSsPaBu/qcoOwhMynHdhTCmWHpBw\n"
  "router-signature\n"
  "-----BEGIN SIGNATURE-----\n"
  "Ui31suskhBbwTRc24NfUneh1c2LfUqjap5dCCfdmoVgvTSnk2RDW+IC4jwwFliWp\n"
  "Gs2RJsPy527LRPRrXKJv3MnKO6uUPZXUjs/QZjdJgTMCzLY7jJBwnmAqj5BjUMfO\n"
  "+S3hOhBZlDmLeYk4p+sppZjR0P9EFy2e3U3homiz1dM=\n"
  "-----END SIGNATURE-----\n"
  ;
