% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_heteroscedasticity.R
\name{check_heteroscedasticity}
\alias{check_heteroscedasticity}
\alias{check_heteroskedasticity}
\title{Check model for (non-)constant error variance}
\usage{
check_heteroscedasticity(x, ...)

check_heteroskedasticity(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}
}
\value{
The p-value of the test statistics. A p-value < 0.05 indicates a
non-constant variance (heteroskedasticity).
}
\description{
Significance testing for linear regression models assumes that
the model errors (or residuals) have constant variance. If this assumption
is violated the p-values from the model are no longer reliable.
}
\details{
This test of the hypothesis of (non-)constant error is also called
\emph{Breusch-Pagan test} (\cite{1979}).
}
\note{
There is also a \href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method}
implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
m <<- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_heteroscedasticity(m)

# plot results
\dontshow{if (insight::check_if_installed("see", minimum_version = "0.9.1", quietly = TRUE)) withAutoprint(\{ # examplesIf}
x <- check_heteroscedasticity(m)
plot(x)
\dontshow{\}) # examplesIf}
}
\references{
Breusch, T. S., and Pagan, A. R. (1979) A simple test for heteroscedasticity
and random coefficient variation. Econometrica 47, 1287-1294.
}
\seealso{
Other functions to check model assumptions and and assess model quality: 
\code{\link{check_autocorrelation}()},
\code{\link{check_collinearity}()},
\code{\link{check_convergence}()},
\code{\link{check_homogeneity}()},
\code{\link{check_model}()},
\code{\link{check_outliers}()},
\code{\link{check_overdispersion}()},
\code{\link{check_predictions}()},
\code{\link{check_singularity}()},
\code{\link{check_zeroinflation}()}
}
\concept{functions to check model assumptions and and assess model quality}
