/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     delscanb.c                                                     *
 *            Funktion zum Ausschneiden des eigentlichen Bildes aus einem    *
 *            Bild mit "hellem" Rand, der durch die Maske des Scanners       *
 *            entstanden sein knnte                                         *
 * Autor:     Andreas Tille                                                  *
 * Datum:     03.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <stdio.h>
#include <string.h>

#include "paul.h" 

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif


int DeleteScannerBorder(PAUL *p)
/* cut bright border of images
 * way: negativ of image -- cut dark border -- negativ of image
 * --- parameter: ---
 * PAUL *p                    : list of images, options
 *                            : used options: 
 *                              flag : Scannerrand
 * --- return: ---
 * int   DeleteScannerBorder(): if OK 0, else -1
 */
{
   PICTURE *bild;
   GList   *pl;
   int      thresh, terr;
   
   if ( !NBILDER(p->piclist) ) return 0;

   /* Negieren */
   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      if ( IsMonochrom(bild) && bild->storepix == 3 ) 
         NegativBuffer(bild->DATA + 1, bild->storepix*bild->size, 3);
      else 
         NegativBuffer(bild->DATA, bild->storepix*bild->size, 1);
   }
   /* Rand abschneiden */
   thresh         = p->opt->thresh;
   terr           = p->opt->terr;
   p->opt->thresh = DEFAULT_SCAN_THRESHOLD;
   p->opt->terr   = DEFAULT_SCAN_ERROR;
   SelectPictureWithoutBorder(p); 
   p->opt->thresh = thresh;
   p->opt->terr   = terr;
   /* Nochmal Negieren */
   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      if ( IsMonochrom(bild) && bild->storepix == 3 ) 
         NegativBuffer(bild->DATA + 1, bild->storepix*bild->size, 3);
      else 
         NegativBuffer(bild->DATA, bild->storepix*bild->size, 1);
   }
   return 0;
}



